// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Generative AI Service Management API
//
// OCI Generative AI is a fully managed service that provides a set of state-of-the-art, customizable large language models (LLMs) that cover a wide range of use cases for text generation, summarization, and text embeddings.
// Use the Generative AI service management API to create and manage DedicatedAiCluster, Endpoint, Model, and WorkRequest in the Generative AI service. For example, create a custom model by fine-tuning an out-of-the-box model using your own data, on a fine-tuning dedicated AI cluster. Then, create a hosting dedicated AI cluster with an endpoint to host your custom model.
// To access your custom model endpoints, or to try the out-of-the-box models to generate text, summarize, and create text embeddings see the Generative AI Inference API (https://docs.oracle.com/iaas/api/#/en/generative-ai-inference/latest/).
// To learn more about the service, see the Generative AI documentation (https://docs.oracle.com/iaas/Content/generative-ai/home.htm).
//

package generativeai

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ContentModerationConfig The configuration details, whether to add the content moderation feature to the model. Content moderation removes toxic and biased content from responses.
type ContentModerationConfig struct {

	// Whether to enable the content moderation feature.
	IsEnabled *bool `mandatory:"true" json:"isEnabled"`

	// Enum for the modes of operation for inference protection.
	Mode ContentModerationConfigModeEnum `mandatory:"false" json:"mode,omitempty"`

	// The OCID of the model used for the feature.
	ModelId *string `mandatory:"false" json:"modelId"`
}

func (m ContentModerationConfig) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ContentModerationConfig) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if _, ok := GetMappingContentModerationConfigModeEnum(string(m.Mode)); !ok && m.Mode != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Mode: %s. Supported values are: %s.", m.Mode, strings.Join(GetContentModerationConfigModeEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ContentModerationConfigModeEnum Enum with underlying type: string
type ContentModerationConfigModeEnum string

// Set of constants representing the allowable values for ContentModerationConfigModeEnum
const (
	ContentModerationConfigModeInform ContentModerationConfigModeEnum = "INFORM"
	ContentModerationConfigModeBlock  ContentModerationConfigModeEnum = "BLOCK"
)

var mappingContentModerationConfigModeEnum = map[string]ContentModerationConfigModeEnum{
	"INFORM": ContentModerationConfigModeInform,
	"BLOCK":  ContentModerationConfigModeBlock,
}

var mappingContentModerationConfigModeEnumLowerCase = map[string]ContentModerationConfigModeEnum{
	"inform": ContentModerationConfigModeInform,
	"block":  ContentModerationConfigModeBlock,
}

// GetContentModerationConfigModeEnumValues Enumerates the set of values for ContentModerationConfigModeEnum
func GetContentModerationConfigModeEnumValues() []ContentModerationConfigModeEnum {
	values := make([]ContentModerationConfigModeEnum, 0)
	for _, v := range mappingContentModerationConfigModeEnum {
		values = append(values, v)
	}
	return values
}

// GetContentModerationConfigModeEnumStringValues Enumerates the set of values in String for ContentModerationConfigModeEnum
func GetContentModerationConfigModeEnumStringValues() []string {
	return []string{
		"INFORM",
		"BLOCK",
	}
}

// GetMappingContentModerationConfigModeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingContentModerationConfigModeEnum(val string) (ContentModerationConfigModeEnum, bool) {
	enum, ok := mappingContentModerationConfigModeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
