﻿/*
    This file is part of Flycast.

    Flycast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    Flycast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Flycast.  If not, see <https://www.gnu.org/licenses/>.
 */
#ifndef LIBRETRO_CORE_OPTIONS_INTL_H__
#define LIBRETRO_CORE_OPTIONS_INTL_H__

#if defined(_MSC_VER) && (_MSC_VER >= 1500 && _MSC_VER < 1900)
/* https://support.microsoft.com/en-us/kb/980263 */
#pragma execution_character_set("utf-8")
#pragma warning(disable:4566)
#endif

#include <libretro.h>

#include "libretro_core_option_defines.h"

/*
 ********************************
 * VERSION: 2.0
 ********************************
 *
 * - 2.0: Add support for core options v2 interface
 * - 1.3: Move translations to libretro_core_options_intl.h
 *        - libretro_core_options_intl.h includes BOM and utf-8
 *          fix for MSVC 2010-2013
 *        - Added HAVE_NO_LANGEXTRA flag to disable translations
 *          on platforms/compilers without BOM support
 * - 1.2: Use core options v1 interface when
 *        RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION is >= 1
 *        (previously required RETRO_ENVIRONMENT_GET_CORE_OPTIONS_VERSION == 1)
 * - 1.1: Support generation of core options v0 retro_core_option_value
 *        arrays containing options with a single value
 * - 1.0: First commit
*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 ********************************
 * Core Option Definitions
 ********************************
*/
/* RETRO_LANGUAGE_AR */

#define CATEGORY_SYSTEM_LABEL_AR "نظام"
#define CATEGORY_SYSTEM_INFO_0_AR NULL
#define CATEGORY_VIDEO_LABEL_AR "فيديو"
#define CATEGORY_VIDEO_INFO_0_AR NULL
#define CATEGORY_PERFORMANCE_LABEL_AR "الأداء"
#define CATEGORY_PERFORMANCE_INFO_0_AR NULL
#define CATEGORY_HACKS_LABEL_AR NULL
#define CATEGORY_HACKS_INFO_0_AR NULL
#define CATEGORY_INPUT_LABEL_AR "الإدخال"
#define CATEGORY_INPUT_INFO_0_AR NULL
#define CATEGORY_EXPANSIONS_LABEL_AR NULL
#define CATEGORY_EXPANSIONS_INFO_0_AR NULL
#define CATEGORY_VMU_LABEL_AR NULL
#define CATEGORY_VMU_INFO_0_AR NULL
#define CORE_OPTION_NAME_REGION_LABEL_AR "المنطقة"
#define OPTION_VAL_JAPAN_AR NULL
#define OPTION_VAL_USA_AR NULL
#define OPTION_VAL_EUROPE_AR NULL
#define OPTION_VAL_DEFAULT_AR NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_AR "اللّغة"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_AR NULL
#define OPTION_VAL_JAPANESE_AR "Japanese - 日本語"
#define OPTION_VAL_ENGLISH_AR NULL
#define OPTION_VAL_GERMAN_AR "German - Deutsch"
#define OPTION_VAL_FRENCH_AR "French - Français"
#define OPTION_VAL_SPANISH_AR "Spanish - Español"
#define OPTION_VAL_ITALIAN_AR "Italian - Italiano"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_AR NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_AR NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_AR NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_AR NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_AR NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_AR NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_AR NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_AR NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_AR NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_AR NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_AR NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_AR NULL
#define CORE_OPTION_NAME_UPNP_LABEL_AR NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_AR NULL
#define CORE_OPTION_NAME_DCNET_LABEL_AR NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_AR NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_AR NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_AR NULL
#define OPTION_VAL_320X240_AR NULL
#define OPTION_VAL_640X480_AR NULL
#define OPTION_VAL_800X600_AR NULL
#define OPTION_VAL_960X720_AR NULL
#define OPTION_VAL_1024X768_AR NULL
#define OPTION_VAL_1280X960_AR NULL
#define OPTION_VAL_1440X1080_AR NULL
#define OPTION_VAL_1600X1200_AR NULL
#define OPTION_VAL_1920X1440_AR NULL
#define OPTION_VAL_2560X1920_AR NULL
#define OPTION_VAL_2880X2160_AR NULL
#define OPTION_VAL_3200X2400_AR NULL
#define OPTION_VAL_3840X2880_AR NULL
#define OPTION_VAL_4480X3360_AR NULL
#define OPTION_VAL_5120X3840_AR NULL
#define OPTION_VAL_5760X4320_AR NULL
#define OPTION_VAL_6400X4800_AR NULL
#define OPTION_VAL_7040X5280_AR NULL
#define OPTION_VAL_7680X5760_AR NULL
#define OPTION_VAL_8320X6240_AR NULL
#define OPTION_VAL_8960X6720_AR NULL
#define OPTION_VAL_9600X7200_AR NULL
#define OPTION_VAL_10240X7680_AR NULL
#define OPTION_VAL_10880X8160_AR NULL
#define OPTION_VAL_11520X8640_AR NULL
#define OPTION_VAL_12160X9120_AR NULL
#define OPTION_VAL_12800X9600_AR NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_AR NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_AR NULL
#define OPTION_VAL_VGA_AR NULL
#define OPTION_VAL_TV_RGB_AR NULL
#define OPTION_VAL_TV_COMPOSITE_AR NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_AR NULL
#define OPTION_VAL_NTSC_AR NULL
#define OPTION_VAL_PAL_AR NULL
#define OPTION_VAL_PAL_N_AR NULL
#define OPTION_VAL_PAL_M_AR NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_AR "اتجاه الشاشة"
#define OPTION_VAL_HORIZONTAL_AR NULL
#define OPTION_VAL_VERTICAL_AR NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_AR NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_AR NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_AR NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_AR NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_AR NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_AR NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_AR NULL
#define OPTION_VAL_512MB_AR NULL
#define OPTION_VAL_1GB_AR NULL
#define OPTION_VAL_2GB_AR NULL
#define OPTION_VAL_4GB_AR NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_AR NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_AR NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_AR NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_AR NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_AR NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_AR NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_AR NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_AR NULL
#define CORE_OPTION_NAME_FOG_LABEL_AR NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_AR NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_AR NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_AR NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_AR NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_AR NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_AR NULL
#define OPTION_VAL_1_AR NULL
#define OPTION_VAL_2_AR NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_AR NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_AR NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_AR NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_AR NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_AR NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_AR NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_AR NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_AR NULL
#define OPTION_VAL_2_O27_AR NULL
#define OPTION_VAL_4_AR NULL
#define OPTION_VAL_6_AR NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_AR NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_AR NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_AR NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_AR NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_AR NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_AR NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_AR NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_AR NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_AR NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_AR NULL
#define OPTION_VAL_SOME_AR "عادي"
#define OPTION_VAL_MORE_AR NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_AR NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_AR NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_AR NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_AR NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_AR NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_AR NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_AR NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_AR NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_AR NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_AR NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_AR NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_AR NULL
#define OPTION_VAL_100_AR NULL
#define OPTION_VAL_110_AR NULL
#define OPTION_VAL_120_AR NULL
#define OPTION_VAL_130_AR NULL
#define OPTION_VAL_140_AR NULL
#define OPTION_VAL_150_AR NULL
#define OPTION_VAL_160_AR NULL
#define OPTION_VAL_170_AR NULL
#define OPTION_VAL_180_AR NULL
#define OPTION_VAL_190_AR NULL
#define OPTION_VAL_200_AR NULL
#define OPTION_VAL_210_AR NULL
#define OPTION_VAL_220_AR NULL
#define OPTION_VAL_230_AR NULL
#define OPTION_VAL_240_AR NULL
#define OPTION_VAL_250_AR NULL
#define OPTION_VAL_260_AR NULL
#define OPTION_VAL_270_AR NULL
#define OPTION_VAL_280_AR NULL
#define OPTION_VAL_290_AR NULL
#define OPTION_VAL_300_AR NULL
#define OPTION_VAL_310_AR NULL
#define OPTION_VAL_320_AR NULL
#define OPTION_VAL_330_AR NULL
#define OPTION_VAL_340_AR NULL
#define OPTION_VAL_350_AR NULL
#define OPTION_VAL_360_AR NULL
#define OPTION_VAL_370_AR NULL
#define OPTION_VAL_380_AR NULL
#define OPTION_VAL_390_AR NULL
#define OPTION_VAL_400_AR NULL
#define OPTION_VAL_410_AR NULL
#define OPTION_VAL_420_AR NULL
#define OPTION_VAL_430_AR NULL
#define OPTION_VAL_440_AR NULL
#define OPTION_VAL_450_AR NULL
#define OPTION_VAL_460_AR NULL
#define OPTION_VAL_470_AR NULL
#define OPTION_VAL_480_AR NULL
#define OPTION_VAL_490_AR NULL
#define OPTION_VAL_500_AR NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_AR NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_AR NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_AR NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_AR NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_AR NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_AR NULL
#define OPTION_VAL_0_AR NULL
#define OPTION_VAL_5_AR NULL
#define OPTION_VAL_10_AR NULL
#define OPTION_VAL_15_AR NULL
#define OPTION_VAL_20_AR NULL
#define OPTION_VAL_25_AR NULL
#define OPTION_VAL_30_AR NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_AR NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_AR NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_AR NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_AR NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_AR NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_AR NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_AR NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_AR NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_AR NULL
#define OPTION_VAL_50_AR NULL
#define OPTION_VAL_60_AR NULL
#define OPTION_VAL_70_AR NULL
#define OPTION_VAL_80_AR NULL
#define OPTION_VAL_90_AR NULL
#define OPTION_VAL_100_O46_AR NULL
#define OPTION_VAL_110_O46_AR NULL
#define OPTION_VAL_120_O46_AR NULL
#define OPTION_VAL_130_O46_AR NULL
#define OPTION_VAL_140_O46_AR NULL
#define OPTION_VAL_150_O46_AR NULL
#define OPTION_VAL_160_O46_AR NULL
#define OPTION_VAL_170_O46_AR NULL
#define OPTION_VAL_180_O46_AR NULL
#define OPTION_VAL_190_O46_AR NULL
#define OPTION_VAL_200_O46_AR NULL
#define OPTION_VAL_210_O46_AR NULL
#define OPTION_VAL_220_O46_AR NULL
#define OPTION_VAL_230_O46_AR NULL
#define OPTION_VAL_240_O46_AR NULL
#define OPTION_VAL_250_O46_AR NULL
#define OPTION_VAL_260_O46_AR NULL
#define OPTION_VAL_270_O46_AR NULL
#define OPTION_VAL_280_O46_AR NULL
#define OPTION_VAL_290_O46_AR NULL
#define OPTION_VAL_300_O46_AR NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_AR NULL
#define OPTION_VAL_WHITE_AR NULL
#define OPTION_VAL_RED_AR "أحمر"
#define OPTION_VAL_GREEN_AR "أخضر"
#define OPTION_VAL_BLUE_AR "أزرق"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_AR NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_AR NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_AR NULL
#define OPTION_VAL_VMU_AR NULL
#define OPTION_VAL_PURUPURU_AR NULL
#define OPTION_VAL_NONE_AR "لاشيء"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_AR NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_AR NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_AR NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_AR NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_AR NULL
#define OPTION_VAL_VMU_A1_AR NULL
#define OPTION_VAL_ALL_VMUS_AR NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_AR NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_AR NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_AR NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_AR NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_AR NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_AR NULL
#define OPTION_VAL_UPPER_LEFT_AR NULL
#define OPTION_VAL_UPPER_RIGHT_AR NULL
#define OPTION_VAL_LOWER_LEFT_AR NULL
#define OPTION_VAL_LOWER_RIGHT_AR NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_AR NULL
#define OPTION_VAL_1X_AR NULL
#define OPTION_VAL_3X_AR NULL
#define OPTION_VAL_5X_AR NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_AR NULL
#define OPTION_VAL_DEFAULT_ON_00_AR NULL
#define OPTION_VAL_DEFAULT_OFF_01_AR NULL
#define OPTION_VAL_BLACK_02_AR NULL
#define OPTION_VAL_LIGHT_BLUE_04_AR NULL
#define OPTION_VAL_CYAN_06_AR NULL
#define OPTION_VAL_CYAN_BLUE_07_AR NULL
#define OPTION_VAL_LIGHT_GREEN_08_AR NULL
#define OPTION_VAL_CYAN_GREEN_09_AR NULL
#define OPTION_VAL_LIGHT_CYAN_10_AR NULL
#define OPTION_VAL_PURPLE_12_AR NULL
#define OPTION_VAL_LIGHT_PURPLE_13_AR NULL
#define OPTION_VAL_YELLOW_14_AR "أصفر"
#define OPTION_VAL_GRAY_15_AR NULL
#define OPTION_VAL_LIGHT_PURPLE_2_16_AR NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_AR NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_AR NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_AR NULL
#define OPTION_VAL_LIGHT_RED_2_20_AR NULL
#define OPTION_VAL_MAGENTA_21_AR NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_AR NULL
#define OPTION_VAL_LIGHT_ORANGE_23_AR NULL
#define OPTION_VAL_ORANGE_24_AR NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_AR NULL
#define OPTION_VAL_LIGHT_YELLOW_26_AR NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_AR NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_AR NULL
#define OPTION_VAL_40_AR NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_AR NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_AR NULL

struct retro_core_option_v2_category option_cats_ar[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_AR,
      CATEGORY_SYSTEM_INFO_0_AR
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_AR,
      CATEGORY_VIDEO_INFO_0_AR
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_AR,
      CATEGORY_PERFORMANCE_INFO_0_AR
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AR,
      CATEGORY_HACKS_INFO_0_AR
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AR,
      CATEGORY_INPUT_INFO_0_AR
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_AR,
      CATEGORY_EXPANSIONS_INFO_0_AR
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_AR,
      CATEGORY_VMU_INFO_0_AR
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ar[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_AR,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_AR },
         { "USA",     OPTION_VAL_USA_AR },
         { "Europe",  OPTION_VAL_EUROPE_AR },
         { "Default", OPTION_VAL_DEFAULT_AR },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_AR,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_AR },
         { "English",  OPTION_VAL_ENGLISH_AR },
         { "German",   OPTION_VAL_GERMAN_AR },
         { "French",   OPTION_VAL_FRENCH_AR },
         { "Spanish",  OPTION_VAL_SPANISH_AR },
         { "Italian",  OPTION_VAL_ITALIAN_AR },
         { "Default",  OPTION_VAL_DEFAULT_AR },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_AR,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_AR,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_AR },
         { "640x480",    OPTION_VAL_640X480_AR },
         { "800x600",    OPTION_VAL_800X600_AR },
         { "960x720",    OPTION_VAL_960X720_AR },
         { "1024x768",   OPTION_VAL_1024X768_AR },
         { "1280x960",   OPTION_VAL_1280X960_AR },
         { "1440x1080",  OPTION_VAL_1440X1080_AR },
         { "1600x1200",  OPTION_VAL_1600X1200_AR },
         { "1920x1440",  OPTION_VAL_1920X1440_AR },
         { "2560x1920",  OPTION_VAL_2560X1920_AR },
         { "2880x2160",  OPTION_VAL_2880X2160_AR },
         { "3200x2400",  OPTION_VAL_3200X2400_AR },
         { "3840x2880",  OPTION_VAL_3840X2880_AR },
         { "4480x3360",  OPTION_VAL_4480X3360_AR },
         { "5120x3840",  OPTION_VAL_5120X3840_AR },
         { "5760x4320",  OPTION_VAL_5760X4320_AR },
         { "6400x4800",  OPTION_VAL_6400X4800_AR },
         { "7040x5280",  OPTION_VAL_7040X5280_AR },
         { "7680x5760",  OPTION_VAL_7680X5760_AR },
         { "8320x6240",  OPTION_VAL_8320X6240_AR },
         { "8960x6720",  OPTION_VAL_8960X6720_AR },
         { "9600x7200",  OPTION_VAL_9600X7200_AR },
         { "10240x7680", OPTION_VAL_10240X7680_AR },
         { "10880x8160", OPTION_VAL_10880X8160_AR },
         { "11520x8640", OPTION_VAL_11520X8640_AR },
         { "12160x9120", OPTION_VAL_12160X9120_AR },
         { "12800x9600", OPTION_VAL_12800X9600_AR },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_AR,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_AR },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_AR },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_AR },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_AR,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_AR },
         { "PAL",     OPTION_VAL_PAL_AR },
         { "PAL_N",   OPTION_VAL_PAL_N_AR },
         { "PAL_M",   OPTION_VAL_PAL_M_AR },
         { "Default", OPTION_VAL_DEFAULT_AR },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_AR,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_AR },
         { "vertical",   OPTION_VAL_VERTICAL_AR },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_AR,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_AR },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_AR },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_AR },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_AR,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_AR },
         { "1GB",   OPTION_VAL_1GB_AR },
         { "2GB",   OPTION_VAL_2GB_AR },
         { "4GB",   OPTION_VAL_4GB_AR },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_AR,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_AR,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_AR,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_AR,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_AR },
         { "1",  OPTION_VAL_1_AR },
         { "2",  OPTION_VAL_2_AR },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_AR,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_AR,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_AR },
         { "4",  OPTION_VAL_4_AR },
         { "6",  OPTION_VAL_6_AR },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_AR,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_AR,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_AR,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_AR,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_AR,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_AR,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_AR,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_AR },
         { "more", OPTION_VAL_MORE_AR },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_AR,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_AR },
         { "110", OPTION_VAL_110_AR },
         { "120", OPTION_VAL_120_AR },
         { "130", OPTION_VAL_130_AR },
         { "140", OPTION_VAL_140_AR },
         { "150", OPTION_VAL_150_AR },
         { "160", OPTION_VAL_160_AR },
         { "170", OPTION_VAL_170_AR },
         { "180", OPTION_VAL_180_AR },
         { "190", OPTION_VAL_190_AR },
         { "200", OPTION_VAL_200_AR },
         { "210", OPTION_VAL_210_AR },
         { "220", OPTION_VAL_220_AR },
         { "230", OPTION_VAL_230_AR },
         { "240", OPTION_VAL_240_AR },
         { "250", OPTION_VAL_250_AR },
         { "260", OPTION_VAL_260_AR },
         { "270", OPTION_VAL_270_AR },
         { "280", OPTION_VAL_280_AR },
         { "290", OPTION_VAL_290_AR },
         { "300", OPTION_VAL_300_AR },
         { "310", OPTION_VAL_310_AR },
         { "320", OPTION_VAL_320_AR },
         { "330", OPTION_VAL_330_AR },
         { "340", OPTION_VAL_340_AR },
         { "350", OPTION_VAL_350_AR },
         { "360", OPTION_VAL_360_AR },
         { "370", OPTION_VAL_370_AR },
         { "380", OPTION_VAL_380_AR },
         { "390", OPTION_VAL_390_AR },
         { "400", OPTION_VAL_400_AR },
         { "410", OPTION_VAL_410_AR },
         { "420", OPTION_VAL_420_AR },
         { "430", OPTION_VAL_430_AR },
         { "440", OPTION_VAL_440_AR },
         { "450", OPTION_VAL_450_AR },
         { "460", OPTION_VAL_460_AR },
         { "470", OPTION_VAL_470_AR },
         { "480", OPTION_VAL_480_AR },
         { "490", OPTION_VAL_490_AR },
         { "500", OPTION_VAL_500_AR },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_AR,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_AR,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_AR },
         { "5%",  OPTION_VAL_5_AR },
         { "10%", OPTION_VAL_10_AR },
         { "15%", OPTION_VAL_15_AR },
         { "20%", OPTION_VAL_20_AR },
         { "25%", OPTION_VAL_25_AR },
         { "30%", OPTION_VAL_30_AR },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_AR,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_AR },
         { "5%",  OPTION_VAL_5_AR },
         { "10%", OPTION_VAL_10_AR },
         { "15%", OPTION_VAL_15_AR },
         { "20%", OPTION_VAL_20_AR },
         { "25%", OPTION_VAL_25_AR },
         { "30%", OPTION_VAL_30_AR },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_AR,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_AR,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_AR,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_AR },
         { "60%",  OPTION_VAL_60_AR },
         { "70%",  OPTION_VAL_70_AR },
         { "80%",  OPTION_VAL_80_AR },
         { "90%",  OPTION_VAL_90_AR },
         { "100%", OPTION_VAL_100_O46_AR },
         { "110%", OPTION_VAL_110_O46_AR },
         { "120%", OPTION_VAL_120_O46_AR },
         { "130%", OPTION_VAL_130_O46_AR },
         { "140%", OPTION_VAL_140_O46_AR },
         { "150%", OPTION_VAL_150_O46_AR },
         { "160%", OPTION_VAL_160_O46_AR },
         { "170%", OPTION_VAL_170_O46_AR },
         { "180%", OPTION_VAL_180_O46_AR },
         { "190%", OPTION_VAL_190_O46_AR },
         { "200%", OPTION_VAL_200_O46_AR },
         { "210%", OPTION_VAL_210_O46_AR },
         { "220%", OPTION_VAL_220_O46_AR },
         { "230%", OPTION_VAL_230_O46_AR },
         { "240%", OPTION_VAL_240_O46_AR },
         { "250%", OPTION_VAL_250_O46_AR },
         { "260%", OPTION_VAL_260_O46_AR },
         { "270%", OPTION_VAL_270_O46_AR },
         { "280%", OPTION_VAL_280_O46_AR },
         { "290%", OPTION_VAL_290_O46_AR },
         { "300%", OPTION_VAL_300_O46_AR },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_AR,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AR },
         { "Red",      OPTION_VAL_RED_AR },
         { "Green",    OPTION_VAL_GREEN_AR },
         { "Blue",     OPTION_VAL_BLUE_AR },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_AR,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AR },
         { "Red",      OPTION_VAL_RED_AR },
         { "Green",    OPTION_VAL_GREEN_AR },
         { "Blue",     OPTION_VAL_BLUE_AR },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_AR,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AR },
         { "Red",      OPTION_VAL_RED_AR },
         { "Green",    OPTION_VAL_GREEN_AR },
         { "Blue",     OPTION_VAL_BLUE_AR },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_AR,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AR },
         { "Red",      OPTION_VAL_RED_AR },
         { "Green",    OPTION_VAL_GREEN_AR },
         { "Blue",     OPTION_VAL_BLUE_AR },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_AR,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_AR,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AR },
         { "Purupuru", OPTION_VAL_PURUPURU_AR },
         { "None",     OPTION_VAL_NONE_AR },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_AR,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_AR,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_AR,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_AR },
         { "All VMUs", OPTION_VAL_ALL_VMUS_AR },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_AR,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_AR,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_AR,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_AR,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_AR,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_AR,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AR },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AR },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AR },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AR },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AR },
         { "2x", OPTION_VAL_2_O27_AR },
         { "3x", OPTION_VAL_3X_AR },
         { "4x", OPTION_VAL_4_AR },
         { "5x", OPTION_VAL_5X_AR },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AR },
         { "20%",  OPTION_VAL_20_AR },
         { "30%",  OPTION_VAL_30_AR },
         { "40%",  OPTION_VAL_40_AR },
         { "50%",  OPTION_VAL_50_AR },
         { "60%",  OPTION_VAL_60_AR },
         { "70%",  OPTION_VAL_70_AR },
         { "80%",  OPTION_VAL_80_AR },
         { "90%",  OPTION_VAL_90_AR },
         { "100%", OPTION_VAL_100_O46_AR },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AR },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AR },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AR },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AR },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AR },
         { "2x", OPTION_VAL_2_O27_AR },
         { "3x", OPTION_VAL_3X_AR },
         { "4x", OPTION_VAL_4_AR },
         { "5x", OPTION_VAL_5X_AR },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AR },
         { "20%",  OPTION_VAL_20_AR },
         { "30%",  OPTION_VAL_30_AR },
         { "40%",  OPTION_VAL_40_AR },
         { "50%",  OPTION_VAL_50_AR },
         { "60%",  OPTION_VAL_60_AR },
         { "70%",  OPTION_VAL_70_AR },
         { "80%",  OPTION_VAL_80_AR },
         { "90%",  OPTION_VAL_90_AR },
         { "100%", OPTION_VAL_100_O46_AR },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AR },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AR },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AR },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AR },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AR },
         { "2x", OPTION_VAL_2_O27_AR },
         { "3x", OPTION_VAL_3X_AR },
         { "4x", OPTION_VAL_4_AR },
         { "5x", OPTION_VAL_5X_AR },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AR },
         { "20%",  OPTION_VAL_20_AR },
         { "30%",  OPTION_VAL_30_AR },
         { "40%",  OPTION_VAL_40_AR },
         { "50%",  OPTION_VAL_50_AR },
         { "60%",  OPTION_VAL_60_AR },
         { "70%",  OPTION_VAL_70_AR },
         { "80%",  OPTION_VAL_80_AR },
         { "90%",  OPTION_VAL_90_AR },
         { "100%", OPTION_VAL_100_O46_AR },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AR },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AR },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AR },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AR },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AR },
         { "2x", OPTION_VAL_2_O27_AR },
         { "3x", OPTION_VAL_3X_AR },
         { "4x", OPTION_VAL_4_AR },
         { "5x", OPTION_VAL_5X_AR },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AR },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AR },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AR },
         { "BLUE 03",           OPTION_VAL_BLUE_AR },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AR },
         { "GREEN 05",          OPTION_VAL_GREEN_AR },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AR },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AR },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AR },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AR },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AR },
         { "RED 11",            OPTION_VAL_RED_AR },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AR },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AR },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AR },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AR },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AR },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AR },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AR },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AR },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AR },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AR },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AR },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AR },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AR },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AR },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AR },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AR },
         { "WHITE 28",          OPTION_VAL_WHITE_AR },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_AR,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AR },
         { "20%",  OPTION_VAL_20_AR },
         { "30%",  OPTION_VAL_30_AR },
         { "40%",  OPTION_VAL_40_AR },
         { "50%",  OPTION_VAL_50_AR },
         { "60%",  OPTION_VAL_60_AR },
         { "70%",  OPTION_VAL_70_AR },
         { "80%",  OPTION_VAL_80_AR },
         { "90%",  OPTION_VAL_90_AR },
         { "100%", OPTION_VAL_100_O46_AR },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ar = {
   option_cats_ar,
   option_defs_ar
};

/* RETRO_LANGUAGE_AST */

#define CATEGORY_SYSTEM_LABEL_AST "Sistema"
#define CATEGORY_SYSTEM_INFO_0_AST NULL
#define CATEGORY_VIDEO_LABEL_AST "Videu"
#define CATEGORY_VIDEO_INFO_0_AST NULL
#define CATEGORY_PERFORMANCE_LABEL_AST "Rindimientu"
#define CATEGORY_PERFORMANCE_INFO_0_AST NULL
#define CATEGORY_HACKS_LABEL_AST "Hacks de la emulación"
#define CATEGORY_HACKS_INFO_0_AST NULL
#define CATEGORY_INPUT_LABEL_AST "Entrada"
#define CATEGORY_INPUT_INFO_0_AST NULL
#define CATEGORY_EXPANSIONS_LABEL_AST NULL
#define CATEGORY_EXPANSIONS_INFO_0_AST NULL
#define CATEGORY_VMU_LABEL_AST NULL
#define CATEGORY_VMU_INFO_0_AST NULL
#define CORE_OPTION_NAME_REGION_LABEL_AST "Rexón"
#define OPTION_VAL_JAPAN_AST "Xapón"
#define OPTION_VAL_USA_AST "Estaos Xuníos"
#define OPTION_VAL_EUROPE_AST "Europa"
#define OPTION_VAL_DEFAULT_AST NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_AST "Llingua"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_AST NULL
#define OPTION_VAL_JAPANESE_AST "Xaponés"
#define OPTION_VAL_ENGLISH_AST "Inglés"
#define OPTION_VAL_GERMAN_AST "Alemán"
#define OPTION_VAL_FRENCH_AST "Francés"
#define OPTION_VAL_SPANISH_AST "Castellán"
#define OPTION_VAL_ITALIAN_AST "Italianu"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_AST NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_AST NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_AST NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_AST NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_AST "Activar el DSP"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_AST "Activa la emulación del procesador de señal dixital (DSP) d'audiu de Dreamcast. Ameyora la precisión del soníu xeneráu mas aumenta los requirimientos de rindimientu."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_AST NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_AST NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_AST NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_AST NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_AST NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_AST NULL
#define CORE_OPTION_NAME_UPNP_LABEL_AST NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_AST NULL
#define CORE_OPTION_NAME_DCNET_LABEL_AST "Usar DCNet (opción esperimental)"
#define CORE_OPTION_NAME_DCNET_INFO_0_AST NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_AST "Resolución interna"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_AST "Modifica la resolución de la renderización."
#define OPTION_VAL_320X240_AST NULL
#define OPTION_VAL_640X480_AST NULL
#define OPTION_VAL_800X600_AST "800x600 (x1,25)"
#define OPTION_VAL_960X720_AST "960x720 (x1,5)"
#define OPTION_VAL_1024X768_AST "1024x768 (x1,6)"
#define OPTION_VAL_1280X960_AST NULL
#define OPTION_VAL_1440X1080_AST "1440x1080 (x2,25)"
#define OPTION_VAL_1600X1200_AST "1600x1200 (x2,5)"
#define OPTION_VAL_1920X1440_AST NULL
#define OPTION_VAL_2560X1920_AST NULL
#define OPTION_VAL_2880X2160_AST "2880x2160 (x4,5)"
#define OPTION_VAL_3200X2400_AST NULL
#define OPTION_VAL_3840X2880_AST NULL
#define OPTION_VAL_4480X3360_AST NULL
#define OPTION_VAL_5120X3840_AST NULL
#define OPTION_VAL_5760X4320_AST NULL
#define OPTION_VAL_6400X4800_AST NULL
#define OPTION_VAL_7040X5280_AST NULL
#define OPTION_VAL_7680X5760_AST NULL
#define OPTION_VAL_8320X6240_AST NULL
#define OPTION_VAL_8960X6720_AST NULL
#define OPTION_VAL_9600X7200_AST NULL
#define OPTION_VAL_10240X7680_AST NULL
#define OPTION_VAL_10880X8160_AST NULL
#define OPTION_VAL_11520X8640_AST NULL
#define OPTION_VAL_12160X9120_AST NULL
#define OPTION_VAL_12800X9600_AST NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_AST "Tipu de cable"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_AST NULL
#define OPTION_VAL_VGA_AST NULL
#define OPTION_VAL_TV_RGB_AST NULL
#define OPTION_VAL_TV_COMPOSITE_AST "TV (compuestu)"
#define CORE_OPTION_NAME_BROADCAST_LABEL_AST NULL
#define OPTION_VAL_NTSC_AST NULL
#define OPTION_VAL_PAL_AST NULL
#define OPTION_VAL_PAL_N_AST "PAL-N (Arxentina, Paraguái y Uruguái)"
#define OPTION_VAL_PAL_M_AST "PAL-M (Brasil)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_AST "Orientación de la pantalla"
#define OPTION_VAL_HORIZONTAL_AST NULL
#define OPTION_VAL_VERTICAL_AST NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_AST NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_AST NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_AST NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_AST NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_AST NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_AST NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_AST NULL
#define OPTION_VAL_512MB_AST NULL
#define OPTION_VAL_1GB_AST NULL
#define OPTION_VAL_2GB_AST NULL
#define OPTION_VAL_4GB_AST NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_AST NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_AST NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_AST NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_AST NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_AST NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_AST NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_AST NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_AST NULL
#define CORE_OPTION_NAME_FOG_LABEL_AST "Efeutos de nublina"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_AST "Modificador del volume"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_AST NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_AST "Filtru anisotrópicu"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_AST NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_AST NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_AST NULL
#define OPTION_VAL_1_AST NULL
#define OPTION_VAL_2_AST NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_AST NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_AST NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_AST NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_AST NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_AST NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_AST NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_AST NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_AST NULL
#define OPTION_VAL_2_O27_AST "x2"
#define OPTION_VAL_4_AST "x4"
#define OPTION_VAL_6_AST "x6"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_AST NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_AST NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_AST NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_AST NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_AST NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_AST NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_AST NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_AST NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_AST NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_AST NULL
#define OPTION_VAL_SOME_AST NULL
#define OPTION_VAL_MORE_AST NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_AST NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_AST NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_AST NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_AST NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_AST NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_AST NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_AST NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_AST "Aumenta la velocidá de carga de los GD-ROMs."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_AST NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_AST NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_AST NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_AST NULL
#define OPTION_VAL_100_AST NULL
#define OPTION_VAL_110_AST NULL
#define OPTION_VAL_120_AST NULL
#define OPTION_VAL_130_AST NULL
#define OPTION_VAL_140_AST NULL
#define OPTION_VAL_150_AST NULL
#define OPTION_VAL_160_AST NULL
#define OPTION_VAL_170_AST NULL
#define OPTION_VAL_180_AST NULL
#define OPTION_VAL_190_AST NULL
#define OPTION_VAL_200_AST NULL
#define OPTION_VAL_210_AST NULL
#define OPTION_VAL_220_AST NULL
#define OPTION_VAL_230_AST NULL
#define OPTION_VAL_240_AST NULL
#define OPTION_VAL_250_AST NULL
#define OPTION_VAL_260_AST NULL
#define OPTION_VAL_270_AST NULL
#define OPTION_VAL_280_AST NULL
#define OPTION_VAL_290_AST NULL
#define OPTION_VAL_300_AST NULL
#define OPTION_VAL_310_AST NULL
#define OPTION_VAL_320_AST NULL
#define OPTION_VAL_330_AST NULL
#define OPTION_VAL_340_AST NULL
#define OPTION_VAL_350_AST NULL
#define OPTION_VAL_360_AST NULL
#define OPTION_VAL_370_AST NULL
#define OPTION_VAL_380_AST NULL
#define OPTION_VAL_390_AST NULL
#define OPTION_VAL_400_AST NULL
#define OPTION_VAL_410_AST NULL
#define OPTION_VAL_420_AST NULL
#define OPTION_VAL_430_AST NULL
#define OPTION_VAL_440_AST NULL
#define OPTION_VAL_450_AST NULL
#define OPTION_VAL_460_AST NULL
#define OPTION_VAL_470_AST NULL
#define OPTION_VAL_480_AST NULL
#define OPTION_VAL_490_AST NULL
#define OPTION_VAL_500_AST NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_AST NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_AST NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_AST NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_AST NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_AST NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_AST NULL
#define OPTION_VAL_0_AST NULL
#define OPTION_VAL_5_AST NULL
#define OPTION_VAL_10_AST NULL
#define OPTION_VAL_15_AST NULL
#define OPTION_VAL_20_AST NULL
#define OPTION_VAL_25_AST NULL
#define OPTION_VAL_30_AST NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_AST NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_AST NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_AST NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_AST NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_AST NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_AST NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_AST NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_AST NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_AST NULL
#define OPTION_VAL_50_AST NULL
#define OPTION_VAL_60_AST NULL
#define OPTION_VAL_70_AST NULL
#define OPTION_VAL_80_AST NULL
#define OPTION_VAL_90_AST NULL
#define OPTION_VAL_100_O46_AST NULL
#define OPTION_VAL_110_O46_AST NULL
#define OPTION_VAL_120_O46_AST NULL
#define OPTION_VAL_130_O46_AST NULL
#define OPTION_VAL_140_O46_AST NULL
#define OPTION_VAL_150_O46_AST NULL
#define OPTION_VAL_160_O46_AST NULL
#define OPTION_VAL_170_O46_AST NULL
#define OPTION_VAL_180_O46_AST NULL
#define OPTION_VAL_190_O46_AST NULL
#define OPTION_VAL_200_O46_AST NULL
#define OPTION_VAL_210_O46_AST NULL
#define OPTION_VAL_220_O46_AST NULL
#define OPTION_VAL_230_O46_AST NULL
#define OPTION_VAL_240_O46_AST NULL
#define OPTION_VAL_250_O46_AST NULL
#define OPTION_VAL_260_O46_AST NULL
#define OPTION_VAL_270_O46_AST NULL
#define OPTION_VAL_280_O46_AST NULL
#define OPTION_VAL_290_O46_AST NULL
#define OPTION_VAL_300_O46_AST NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_AST NULL
#define OPTION_VAL_WHITE_AST "Blancu"
#define OPTION_VAL_RED_AST "Coloráu"
#define OPTION_VAL_GREEN_AST "Verde"
#define OPTION_VAL_BLUE_AST "Azul"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_AST NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_AST NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_AST NULL
#define OPTION_VAL_VMU_AST NULL
#define OPTION_VAL_PURUPURU_AST NULL
#define OPTION_VAL_NONE_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_AST NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_AST NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_AST NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_AST NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_AST NULL
#define OPTION_VAL_VMU_A1_AST NULL
#define OPTION_VAL_ALL_VMUS_AST "Toles VMUs"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_AST "Soníos de la VMU"
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_AST "Cuando s'activa esta opción, reprodúcense los pitíos de la VMU."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_AST NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_AST NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_AST NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_AST NULL
#define OPTION_VAL_UPPER_LEFT_AST NULL
#define OPTION_VAL_UPPER_RIGHT_AST NULL
#define OPTION_VAL_LOWER_LEFT_AST NULL
#define OPTION_VAL_LOWER_RIGHT_AST NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_AST NULL
#define OPTION_VAL_1X_AST "x1"
#define OPTION_VAL_3X_AST "x3"
#define OPTION_VAL_5X_AST "x5"
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_AST NULL
#define OPTION_VAL_DEFAULT_ON_00_AST NULL
#define OPTION_VAL_DEFAULT_OFF_01_AST NULL
#define OPTION_VAL_BLACK_02_AST "Prietu"
#define OPTION_VAL_LIGHT_BLUE_04_AST "Azul claro"
#define OPTION_VAL_CYAN_06_AST "Cianu"
#define OPTION_VAL_CYAN_BLUE_07_AST "Azul ciano"
#define OPTION_VAL_LIGHT_GREEN_08_AST "Verde claro"
#define OPTION_VAL_CYAN_GREEN_09_AST "Verde ciano"
#define OPTION_VAL_LIGHT_CYAN_10_AST "Cianu claro"
#define OPTION_VAL_PURPLE_12_AST "Moráu"
#define OPTION_VAL_LIGHT_PURPLE_13_AST "Moráu claro"
#define OPTION_VAL_YELLOW_14_AST "Mariellu"
#define OPTION_VAL_GRAY_15_AST "Buxu"
#define OPTION_VAL_LIGHT_PURPLE_2_16_AST "Moráu claro (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_AST "Verde claro (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_AST "Verde claro (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_AST "Cianu claro (2)"
#define OPTION_VAL_LIGHT_RED_2_20_AST "Coloráu claro (2)"
#define OPTION_VAL_MAGENTA_21_AST "Maxenta"
#define OPTION_VAL_LIGHT_PURPLE_3_22_AST "Moráu claro (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_AST "Naranxa claro"
#define OPTION_VAL_ORANGE_24_AST "Naranxa"
#define OPTION_VAL_LIGHT_PURPLE_4_25_AST "Moráu claro (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_AST "Mariellu claro"
#define OPTION_VAL_LIGHT_YELLOW_2_27_AST "Mariellu claro (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_AST NULL
#define OPTION_VAL_40_AST NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_AST NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_AST NULL

struct retro_core_option_v2_category option_cats_ast[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_AST,
      CATEGORY_SYSTEM_INFO_0_AST
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_AST,
      CATEGORY_VIDEO_INFO_0_AST
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_AST,
      CATEGORY_PERFORMANCE_INFO_0_AST
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_AST,
      CATEGORY_HACKS_INFO_0_AST
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_AST,
      CATEGORY_INPUT_INFO_0_AST
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_AST,
      CATEGORY_EXPANSIONS_INFO_0_AST
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_AST,
      CATEGORY_VMU_INFO_0_AST
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ast[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_AST,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_AST },
         { "USA",     OPTION_VAL_USA_AST },
         { "Europe",  OPTION_VAL_EUROPE_AST },
         { "Default", OPTION_VAL_DEFAULT_AST },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_AST,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_AST },
         { "English",  OPTION_VAL_ENGLISH_AST },
         { "German",   OPTION_VAL_GERMAN_AST },
         { "French",   OPTION_VAL_FRENCH_AST },
         { "Spanish",  OPTION_VAL_SPANISH_AST },
         { "Italian",  OPTION_VAL_ITALIAN_AST },
         { "Default",  OPTION_VAL_DEFAULT_AST },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_AST,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_AST,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_AST },
         { "640x480",    OPTION_VAL_640X480_AST },
         { "800x600",    OPTION_VAL_800X600_AST },
         { "960x720",    OPTION_VAL_960X720_AST },
         { "1024x768",   OPTION_VAL_1024X768_AST },
         { "1280x960",   OPTION_VAL_1280X960_AST },
         { "1440x1080",  OPTION_VAL_1440X1080_AST },
         { "1600x1200",  OPTION_VAL_1600X1200_AST },
         { "1920x1440",  OPTION_VAL_1920X1440_AST },
         { "2560x1920",  OPTION_VAL_2560X1920_AST },
         { "2880x2160",  OPTION_VAL_2880X2160_AST },
         { "3200x2400",  OPTION_VAL_3200X2400_AST },
         { "3840x2880",  OPTION_VAL_3840X2880_AST },
         { "4480x3360",  OPTION_VAL_4480X3360_AST },
         { "5120x3840",  OPTION_VAL_5120X3840_AST },
         { "5760x4320",  OPTION_VAL_5760X4320_AST },
         { "6400x4800",  OPTION_VAL_6400X4800_AST },
         { "7040x5280",  OPTION_VAL_7040X5280_AST },
         { "7680x5760",  OPTION_VAL_7680X5760_AST },
         { "8320x6240",  OPTION_VAL_8320X6240_AST },
         { "8960x6720",  OPTION_VAL_8960X6720_AST },
         { "9600x7200",  OPTION_VAL_9600X7200_AST },
         { "10240x7680", OPTION_VAL_10240X7680_AST },
         { "10880x8160", OPTION_VAL_10880X8160_AST },
         { "11520x8640", OPTION_VAL_11520X8640_AST },
         { "12160x9120", OPTION_VAL_12160X9120_AST },
         { "12800x9600", OPTION_VAL_12800X9600_AST },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_AST,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_AST },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_AST },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_AST },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_AST,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_AST },
         { "PAL",     OPTION_VAL_PAL_AST },
         { "PAL_N",   OPTION_VAL_PAL_N_AST },
         { "PAL_M",   OPTION_VAL_PAL_M_AST },
         { "Default", OPTION_VAL_DEFAULT_AST },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_AST,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_AST },
         { "vertical",   OPTION_VAL_VERTICAL_AST },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_AST,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_AST },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_AST },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_AST },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_AST,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_AST },
         { "1GB",   OPTION_VAL_1GB_AST },
         { "2GB",   OPTION_VAL_2GB_AST },
         { "4GB",   OPTION_VAL_4GB_AST },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_AST,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_AST,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_AST,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_AST,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_AST },
         { "1",  OPTION_VAL_1_AST },
         { "2",  OPTION_VAL_2_AST },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_AST,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_AST,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_AST },
         { "4",  OPTION_VAL_4_AST },
         { "6",  OPTION_VAL_6_AST },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_AST,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_AST,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_AST,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_AST,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_AST,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_AST,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_AST,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_AST },
         { "more", OPTION_VAL_MORE_AST },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_AST,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_AST },
         { "110", OPTION_VAL_110_AST },
         { "120", OPTION_VAL_120_AST },
         { "130", OPTION_VAL_130_AST },
         { "140", OPTION_VAL_140_AST },
         { "150", OPTION_VAL_150_AST },
         { "160", OPTION_VAL_160_AST },
         { "170", OPTION_VAL_170_AST },
         { "180", OPTION_VAL_180_AST },
         { "190", OPTION_VAL_190_AST },
         { "200", OPTION_VAL_200_AST },
         { "210", OPTION_VAL_210_AST },
         { "220", OPTION_VAL_220_AST },
         { "230", OPTION_VAL_230_AST },
         { "240", OPTION_VAL_240_AST },
         { "250", OPTION_VAL_250_AST },
         { "260", OPTION_VAL_260_AST },
         { "270", OPTION_VAL_270_AST },
         { "280", OPTION_VAL_280_AST },
         { "290", OPTION_VAL_290_AST },
         { "300", OPTION_VAL_300_AST },
         { "310", OPTION_VAL_310_AST },
         { "320", OPTION_VAL_320_AST },
         { "330", OPTION_VAL_330_AST },
         { "340", OPTION_VAL_340_AST },
         { "350", OPTION_VAL_350_AST },
         { "360", OPTION_VAL_360_AST },
         { "370", OPTION_VAL_370_AST },
         { "380", OPTION_VAL_380_AST },
         { "390", OPTION_VAL_390_AST },
         { "400", OPTION_VAL_400_AST },
         { "410", OPTION_VAL_410_AST },
         { "420", OPTION_VAL_420_AST },
         { "430", OPTION_VAL_430_AST },
         { "440", OPTION_VAL_440_AST },
         { "450", OPTION_VAL_450_AST },
         { "460", OPTION_VAL_460_AST },
         { "470", OPTION_VAL_470_AST },
         { "480", OPTION_VAL_480_AST },
         { "490", OPTION_VAL_490_AST },
         { "500", OPTION_VAL_500_AST },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_AST,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_AST,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_AST },
         { "5%",  OPTION_VAL_5_AST },
         { "10%", OPTION_VAL_10_AST },
         { "15%", OPTION_VAL_15_AST },
         { "20%", OPTION_VAL_20_AST },
         { "25%", OPTION_VAL_25_AST },
         { "30%", OPTION_VAL_30_AST },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_AST,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_AST },
         { "5%",  OPTION_VAL_5_AST },
         { "10%", OPTION_VAL_10_AST },
         { "15%", OPTION_VAL_15_AST },
         { "20%", OPTION_VAL_20_AST },
         { "25%", OPTION_VAL_25_AST },
         { "30%", OPTION_VAL_30_AST },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_AST,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_AST,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_AST,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_AST },
         { "60%",  OPTION_VAL_60_AST },
         { "70%",  OPTION_VAL_70_AST },
         { "80%",  OPTION_VAL_80_AST },
         { "90%",  OPTION_VAL_90_AST },
         { "100%", OPTION_VAL_100_O46_AST },
         { "110%", OPTION_VAL_110_O46_AST },
         { "120%", OPTION_VAL_120_O46_AST },
         { "130%", OPTION_VAL_130_O46_AST },
         { "140%", OPTION_VAL_140_O46_AST },
         { "150%", OPTION_VAL_150_O46_AST },
         { "160%", OPTION_VAL_160_O46_AST },
         { "170%", OPTION_VAL_170_O46_AST },
         { "180%", OPTION_VAL_180_O46_AST },
         { "190%", OPTION_VAL_190_O46_AST },
         { "200%", OPTION_VAL_200_O46_AST },
         { "210%", OPTION_VAL_210_O46_AST },
         { "220%", OPTION_VAL_220_O46_AST },
         { "230%", OPTION_VAL_230_O46_AST },
         { "240%", OPTION_VAL_240_O46_AST },
         { "250%", OPTION_VAL_250_O46_AST },
         { "260%", OPTION_VAL_260_O46_AST },
         { "270%", OPTION_VAL_270_O46_AST },
         { "280%", OPTION_VAL_280_O46_AST },
         { "290%", OPTION_VAL_290_O46_AST },
         { "300%", OPTION_VAL_300_O46_AST },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_AST,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AST },
         { "Red",      OPTION_VAL_RED_AST },
         { "Green",    OPTION_VAL_GREEN_AST },
         { "Blue",     OPTION_VAL_BLUE_AST },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_AST,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AST },
         { "Red",      OPTION_VAL_RED_AST },
         { "Green",    OPTION_VAL_GREEN_AST },
         { "Blue",     OPTION_VAL_BLUE_AST },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_AST,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AST },
         { "Red",      OPTION_VAL_RED_AST },
         { "Green",    OPTION_VAL_GREEN_AST },
         { "Blue",     OPTION_VAL_BLUE_AST },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_AST,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_AST },
         { "Red",      OPTION_VAL_RED_AST },
         { "Green",    OPTION_VAL_GREEN_AST },
         { "Blue",     OPTION_VAL_BLUE_AST },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_AST,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_AST,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_AST },
         { "Purupuru", OPTION_VAL_PURUPURU_AST },
         { "None",     OPTION_VAL_NONE_AST },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_AST,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_AST,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_AST,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_AST },
         { "All VMUs", OPTION_VAL_ALL_VMUS_AST },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_AST,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_AST,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_AST,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_AST,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_AST,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_AST,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AST },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AST },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AST },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AST },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AST },
         { "2x", OPTION_VAL_2_O27_AST },
         { "3x", OPTION_VAL_3X_AST },
         { "4x", OPTION_VAL_4_AST },
         { "5x", OPTION_VAL_5X_AST },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AST },
         { "20%",  OPTION_VAL_20_AST },
         { "30%",  OPTION_VAL_30_AST },
         { "40%",  OPTION_VAL_40_AST },
         { "50%",  OPTION_VAL_50_AST },
         { "60%",  OPTION_VAL_60_AST },
         { "70%",  OPTION_VAL_70_AST },
         { "80%",  OPTION_VAL_80_AST },
         { "90%",  OPTION_VAL_90_AST },
         { "100%", OPTION_VAL_100_O46_AST },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AST },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AST },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AST },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AST },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AST },
         { "2x", OPTION_VAL_2_O27_AST },
         { "3x", OPTION_VAL_3X_AST },
         { "4x", OPTION_VAL_4_AST },
         { "5x", OPTION_VAL_5X_AST },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AST },
         { "20%",  OPTION_VAL_20_AST },
         { "30%",  OPTION_VAL_30_AST },
         { "40%",  OPTION_VAL_40_AST },
         { "50%",  OPTION_VAL_50_AST },
         { "60%",  OPTION_VAL_60_AST },
         { "70%",  OPTION_VAL_70_AST },
         { "80%",  OPTION_VAL_80_AST },
         { "90%",  OPTION_VAL_90_AST },
         { "100%", OPTION_VAL_100_O46_AST },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AST },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AST },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AST },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AST },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AST },
         { "2x", OPTION_VAL_2_O27_AST },
         { "3x", OPTION_VAL_3X_AST },
         { "4x", OPTION_VAL_4_AST },
         { "5x", OPTION_VAL_5X_AST },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AST },
         { "20%",  OPTION_VAL_20_AST },
         { "30%",  OPTION_VAL_30_AST },
         { "40%",  OPTION_VAL_40_AST },
         { "50%",  OPTION_VAL_50_AST },
         { "60%",  OPTION_VAL_60_AST },
         { "70%",  OPTION_VAL_70_AST },
         { "80%",  OPTION_VAL_80_AST },
         { "90%",  OPTION_VAL_90_AST },
         { "100%", OPTION_VAL_100_O46_AST },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_AST },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_AST },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_AST },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_AST },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_AST },
         { "2x", OPTION_VAL_2_O27_AST },
         { "3x", OPTION_VAL_3X_AST },
         { "4x", OPTION_VAL_4_AST },
         { "5x", OPTION_VAL_5X_AST },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_AST },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_AST },
         { "BLACK 02",          OPTION_VAL_BLACK_02_AST },
         { "BLUE 03",           OPTION_VAL_BLUE_AST },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_AST },
         { "GREEN 05",          OPTION_VAL_GREEN_AST },
         { "CYAN 06",           OPTION_VAL_CYAN_06_AST },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_AST },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_AST },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_AST },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_AST },
         { "RED 11",            OPTION_VAL_RED_AST },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_AST },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_AST },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_AST },
         { "GRAY 15",           OPTION_VAL_GRAY_15_AST },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_AST },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_AST },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_AST },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_AST },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_AST },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_AST },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_AST },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_AST },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_AST },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_AST },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_AST },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_AST },
         { "WHITE 28",          OPTION_VAL_WHITE_AST },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_AST,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_AST },
         { "20%",  OPTION_VAL_20_AST },
         { "30%",  OPTION_VAL_30_AST },
         { "40%",  OPTION_VAL_40_AST },
         { "50%",  OPTION_VAL_50_AST },
         { "60%",  OPTION_VAL_60_AST },
         { "70%",  OPTION_VAL_70_AST },
         { "80%",  OPTION_VAL_80_AST },
         { "90%",  OPTION_VAL_90_AST },
         { "100%", OPTION_VAL_100_O46_AST },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ast = {
   option_cats_ast,
   option_defs_ast
};

/* RETRO_LANGUAGE_BE */

#define CATEGORY_SYSTEM_LABEL_BE "Сістэма"
#define CATEGORY_SYSTEM_INFO_0_BE "Настройка рэгіёну, мовы, BIOS і асноўных параметраў абсталявання."
#define CATEGORY_VIDEO_LABEL_BE "Відэа"
#define CATEGORY_VIDEO_INFO_0_BE "Налады раздзялення, парадка-незалежнай празрыстасці і візуальных эфектаў."
#define CATEGORY_PERFORMANCE_LABEL_BE "Прадукцыйнасць"
#define CATEGORY_PERFORMANCE_INFO_0_BE "Настройкі шматпаточнага рэндэрынгу і пропуску кадраў."
#define CATEGORY_HACKS_LABEL_BE "Хакі эмуляцыі"
#define CATEGORY_HACKS_INFO_0_BE "Налады шырокафарматных чыт-кодаў, хуткасці загрузкі GD-ROM і замены тэкстураў."
#define CATEGORY_INPUT_LABEL_BE "Увод"
#define CATEGORY_INPUT_INFO_0_BE "Налады геймпада і светлавога пісталета."
#define CATEGORY_EXPANSIONS_LABEL_BE "Модулі пашырэння кантролераў"
#define CATEGORY_EXPANSIONS_INFO_0_BE "Выбар прылады (VMU, вібрапак), падлучанага да слотаў пашырэння кантролераў."
#define CATEGORY_VMU_LABEL_BE "Візуальныя карты памяці"
#define CATEGORY_VMU_INFO_0_BE "Настройкі файлаў захаванняў VMU для кожнай гульні і адлюстравання VMU на экране."
#define CORE_OPTION_NAME_REGION_LABEL_BE "Рэгіён"
#define OPTION_VAL_JAPAN_BE "Японія"
#define OPTION_VAL_USA_BE "ЗША"
#define OPTION_VAL_EUROPE_BE "Еўропа"
#define OPTION_VAL_DEFAULT_BE "Прадвызначана"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_BE "Мова"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_BE "Выбар мовы, якая выкарыстоўваецца ў BIOS, а таксама ў любых гульнях з падтрымкай некалькіх моваў."
#define OPTION_VAL_JAPANESE_BE "Японская"
#define OPTION_VAL_ENGLISH_BE "Англійская"
#define OPTION_VAL_GERMAN_BE "Нямецкая"
#define OPTION_VAL_FRENCH_BE "Французская"
#define OPTION_VAL_SPANISH_BE "Іспанская"
#define OPTION_VAL_ITALIAN_BE "Італьянская"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_BE "Эмуляцыя BIOS (патрабуецца перазапуск)"
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_BE "Прымусова выкарыстоўваць высокаўзроўневую эмуляцыю BIOS."
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_BE "Загружацца ў BIOS (патрабуецца перазапуск)"
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_BE "Загружацца непасрэдна ў меню Dreamcast BIOS."
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_BE "Уключыць DSP"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_BE "Уключае эмуляцыю гукавога DSP (лічбавага сігнальнага працэсара) Dreamcast. Паляпшае дакладнасць згенераванага гуку, але павялічвае сістэмныя патрабаванні."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_BE "Дазваляць сэрвісныя кнопкі аркадных гульняў"
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_BE "Уключае кнопку SERVICE для ўваходу ў налады аўтаматаў аркадных гульняў."
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_BE "Рэжым Free Play для гульняў NAOMI"
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_BE "Змяняць наладкі манетызацыі для ўключэння бясплатнай гульні."
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_BE "Эмуляцыя Broadband Adapter"
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_BE "Эмуляваць замест мадэма шырокапалосны Ethernet-адаптар. (Патрабуецца перазапуск)"
#define CORE_OPTION_NAME_UPNP_LABEL_BE "Уключыць UPnP"
#define CORE_OPTION_NAME_UPNP_INFO_0_BE "Выкарыстоўваць UPnP для аўтаматычнай наладкі вашага Інтэрнэт-роўтара для анлайн-гульняў."
#define CORE_OPTION_NAME_DCNET_LABEL_BE "Выкарыстоўваць DCNet (эксперыментальна)"
#define CORE_OPTION_NAME_DCNET_INFO_0_BE "Злучыцца з эксперыментальным воблачным сэрвісам DCNet."
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_BE "Унутраная раздзяляльнасць"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_BE "Змяніць раздзяляльнасць рэндэрынгу."
#define OPTION_VAL_320X240_BE "320x240 (напалову)"
#define OPTION_VAL_640X480_BE "640x480 (родная)"
#define OPTION_VAL_800X600_BE NULL
#define OPTION_VAL_960X720_BE NULL
#define OPTION_VAL_1024X768_BE NULL
#define OPTION_VAL_1280X960_BE NULL
#define OPTION_VAL_1440X1080_BE NULL
#define OPTION_VAL_1600X1200_BE NULL
#define OPTION_VAL_1920X1440_BE NULL
#define OPTION_VAL_2560X1920_BE NULL
#define OPTION_VAL_2880X2160_BE NULL
#define OPTION_VAL_3200X2400_BE NULL
#define OPTION_VAL_3840X2880_BE NULL
#define OPTION_VAL_4480X3360_BE NULL
#define OPTION_VAL_5120X3840_BE NULL
#define OPTION_VAL_5760X4320_BE NULL
#define OPTION_VAL_6400X4800_BE NULL
#define OPTION_VAL_7040X5280_BE NULL
#define OPTION_VAL_7680X5760_BE NULL
#define OPTION_VAL_8320X6240_BE NULL
#define OPTION_VAL_8960X6720_BE NULL
#define OPTION_VAL_9600X7200_BE NULL
#define OPTION_VAL_10240X7680_BE NULL
#define OPTION_VAL_10880X8160_BE NULL
#define OPTION_VAL_11520X8640_BE NULL
#define OPTION_VAL_12160X9120_BE NULL
#define OPTION_VAL_12800X9600_BE NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_BE "Тып кабеля"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_BE "Тып выходнага сігналу. 'ТБ (кампазіт)' з'яўляецца найболей сумяшчальным."
#define OPTION_VAL_VGA_BE NULL
#define OPTION_VAL_TV_RGB_BE "ТБ (RGB)"
#define OPTION_VAL_TV_COMPOSITE_BE "ТБ (кампазітны)"
#define CORE_OPTION_NAME_BROADCAST_LABEL_BE "Стандарт вяшчання"
#define OPTION_VAL_NTSC_BE NULL
#define OPTION_VAL_PAL_BE "PAL (свет)"
#define OPTION_VAL_PAL_N_BE "PAL-N (Аргенціна, Парагвай, Уругвай)"
#define OPTION_VAL_PAL_M_BE "PAL-M (Бразілія)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_BE "Арыентацыя экрана"
#define OPTION_VAL_HORIZONTAL_BE "Гарызантальная"
#define OPTION_VAL_VERTICAL_BE "Вертыкальная"
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_BE "Альфа-сартаванне"
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_BE "Выбар спосабу сартавання празрыстых палігонаў."
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_BE "Па пластах (хуткая, найменш дакладная)"
#define OPTION_VAL_PER_TRIANGLE_NORMAL_BE "Па трыкутніках (стандартная)"
#define OPTION_VAL_PER_PIXEL_ACCURATE_BE "Па пікселях (дакладная, самая павольная)"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_BE "Памер назапашвальнага буфера пікселяў"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_BE "Вялікія значэнні могуць спатрэбіцца для правільнага адлюстравання высокіх раздзяленняў."
#define OPTION_VAL_512MB_BE "512 МБ"
#define OPTION_VAL_1GB_BE "1 ГБ"
#define OPTION_VAL_2GB_BE "2 ГБ"
#define OPTION_VAL_4GB_BE "4 ГБ"
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_BE "Максімум празрыстых пластоў"
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_BE "Для складаных сцэн могуць запатрабавацца больш высокія значэнні."
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_BE "Поўная эмуляцыя фрэймбуфера"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_BE "Уключае поўную эмуляцыю кадравага буфера ў VRAM. Карысна для гульняў, якія наўпрост вырабляюць чытанне ці запіс фрэймбуфера ў VRAM. Пры ўключэнні ўнутранае раздзяленне будзе прымусова ўсталявана ў 640×480 і магчыма моцнае падзенне хуткасці."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_BE "Уключыць RTT буфер (рэндэру ў тэкстуру)"
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_BE "Капіюе адмаляваныя тэкстуры з GPU зваротна ў VRAM. Дадзеная настройка звычайна ўключана для гульняў, якія гэтага патрабуюць. Пры ўключэнні не выкарыстоўваецца маштабаванне рэндэрынгу тэкстураў і магчыма падзенне прадукцыйнасці."
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_BE "Mip-тэкстураванне"
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_BE "Можа павысіць прадукцыйнасць і знізіць мігаценне пры адлюстраванні на адлегласці паменшаных копій тэкстураў."
#define CORE_OPTION_NAME_FOG_LABEL_BE "Эфекты туману"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_BE "Мадыфікатар аб'ёму"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_BE "Функцыя графічнага працэсара Dreamcast, якая выкарыстоўваецца ў гульнях для адмалёўкі ценяў аб'ектаў. Па змаўчанні павінна быць уключана - уплыў на прадукцыйнасць звычайна мінімальны ці малазначны."
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_BE "Анізатропнае фільтраванне"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_BE "Паляпшае якасць тэкстураў на паверхнях пад непрамымі кутамі агляду ў адносінах да камеры. Больш высокія значэнні падвышаюць патрабаванні да GPU. Змены налады ўступаюць у сілу пры перазапуску."
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_BE "Згладжванне тэкстур"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_BE "Выбар метаду згладжвання тэкстураў. Выкарыстоўваецца для прымусовага фільтравання ўсіх тэкстураў, каб атрымаць больш дакладны (або згладжаны) малюнак. Любое значэнне, адрознае ад стандартнага можа прыводзіць да памылак рэндэрынгу. Для прымянення наладкі патрабуецца перазапуск."
#define OPTION_VAL_1_BE "Прымусова метадам бліжэйшага суседа"
#define OPTION_VAL_2_BE "Прымусова лінейнае"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_BE "Затрымліваць змену кадраў"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_BE "Дапамагае пазбегнуць мігацення экрана або скажэння заставак. Не рэкамендуецца на марудных платформах."
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_BE "Вызначаць змену частаты кадраў"
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_BE "Апавяшчаць франтэнд аб зменах унутранай частаты кадраў (напр. з 60 да 30 кад/хв). Паляпшае размеркаванне кадраў у гульнях з сталай частатой у 30 ці 20 кад/хв, але павінна быць выключана для гульняў з плывучым значэннем частаты кадраў (напр. Ecco the Dolphin, Unreal Tournament). Недаступна пры вкл. опцыі 'Аўтапропуск кадраў'."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_BE "Фільтр постапрацоўкі PowerVR2"
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_BE "Робіць постапрацоўку выявы для імітацыі эфектаў, спецыфічных для GPU PowerVR2 і аналагавых відэасігналаў."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_BE "Апскейлінг тэкстур (xBRZ)"
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_BE "Паляпшае 2D піксель-арт з ручной адмалёўкай. Рэкамендуецца толькі для 2D-гульняў з піксельнай графікай."
#define OPTION_VAL_2_O27_BE NULL
#define OPTION_VAL_4_BE NULL
#define OPTION_VAL_6_BE NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_BE "Максімальны памер згладжаных тэкстураў пры апскейлінгу"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_BE "Ўстаноўка максімальнага памеру тэкстураў пры маштабаванні. Для тэкстураў з памерам больш зададзенага значэння маштабаванне не прымяняецца."
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_BE "Натыўная глыбіня інтэрпаляцыі"
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_BE "Дапамагае пры праблемах з глыбінёй і скажэннем тэкстураў на відэакартах AMD. У шэрагу выпадкаў таксама развязвае праблемы на відэакартах Intel."
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_BE "Выпраўленне прасочвання пры апскейлінгу"
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_BE "Дапамагае ў выпадку прасочвання тэкстураў пры маштабаванні. Адключэнне дапамагае выправіць скажэнні пікселяў пры апскейлінгу 2D-гульняў (MVC2, CVS, KOF і інш.)"
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_BE "Рэндэрынг у асобным патоку"
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_BE "Запускае графічны і цэнтральны працэсары ў розных патоках. Настойліва рэкамендуецца."
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_BE "Аўтапропуск кадраў"
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_BE "Аўтаматычна прапускаць кадры пры запаволенні эмулятара. Ужываецца толькі з уключанай опцыяй 'Рэндэрынг у асобным патоку'."
#define OPTION_VAL_SOME_BE "Звычайна"
#define OPTION_VAL_MORE_BE "Найбольшы"
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_BE "Пропуск кадраў"
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_BE "Устанаўлівае колькасць пропускаў кадраў паміж кадрамі якія адлюстроўваюцца."
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_BE "Шырокаэкранныя чыт-коды (патрабуецца перазапуск)"
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_BE "Актывуе чыт-коды, якія дазваляюць адлюстроўваць некаторыя гульні ў фармаце шырокага экрана."
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_BE "Шырокафарматны хак"
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_BE "Адмалёўваць геаметрыю за межамі стандартных суадносін 4:3. Можа выклікаць скажэнні графікі ў пашыранай вобласці."
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_BE "Хуткая загрузка GD-ROM (зніжае дакладнасць)"
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_BE "Паскарае загрузку GD-ROM."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_BE "Мод Dreamcast на 32 Мбайт АЗП"
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_BE "Уключае мод для Dreamcast на 32 мегабайта АЗП. Можа ўплываць на сумяшчальнасць"
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_BE "Разгон/запавольванне SH4"
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_BE "Змена стандартнай частаты працэсара SH4 у 200 Мгц. Зніжэнне частаты дапамагае для слабых платформаў. Разгон можа падвышаць частату кадраў у некаторых гульнях. Выкарыстоўвайце з асцярожнасцю."
#define OPTION_VAL_100_BE "100 МГц"
#define OPTION_VAL_110_BE "110 МГц"
#define OPTION_VAL_120_BE "120 МГц"
#define OPTION_VAL_130_BE "130 МГц"
#define OPTION_VAL_140_BE "140 МГц"
#define OPTION_VAL_150_BE "150 МГц"
#define OPTION_VAL_160_BE "160 МГц"
#define OPTION_VAL_170_BE "170 МГц"
#define OPTION_VAL_180_BE "180 МГц"
#define OPTION_VAL_190_BE "190 МГц"
#define OPTION_VAL_200_BE "200 МГц"
#define OPTION_VAL_210_BE "210 МГц"
#define OPTION_VAL_220_BE "220 МГц"
#define OPTION_VAL_230_BE "230 МГц"
#define OPTION_VAL_240_BE "240 МГц"
#define OPTION_VAL_250_BE "250 МГц"
#define OPTION_VAL_260_BE "260 МГц"
#define OPTION_VAL_270_BE "270 МГц"
#define OPTION_VAL_280_BE "280 МГц"
#define OPTION_VAL_290_BE "290 МГц"
#define OPTION_VAL_300_BE "300 МГц"
#define OPTION_VAL_310_BE "310 МГц"
#define OPTION_VAL_320_BE "320 МГц"
#define OPTION_VAL_330_BE "330 МГц"
#define OPTION_VAL_340_BE "340 МГц"
#define OPTION_VAL_350_BE "350 МГц"
#define OPTION_VAL_360_BE "360 МГц"
#define OPTION_VAL_370_BE "370 МГц"
#define OPTION_VAL_380_BE "380 МГц"
#define OPTION_VAL_390_BE "390 МГц"
#define OPTION_VAL_400_BE "400 МГц"
#define OPTION_VAL_410_BE "410 МГц"
#define OPTION_VAL_420_BE "420 МГц"
#define OPTION_VAL_430_BE "430 МГц"
#define OPTION_VAL_440_BE "440 МГц"
#define OPTION_VAL_450_BE "450 МГц"
#define OPTION_VAL_460_BE "460 МГц"
#define OPTION_VAL_470_BE "470 МГц"
#define OPTION_VAL_480_BE "480 МГц"
#define OPTION_VAL_490_BE "490 МГц"
#define OPTION_VAL_500_BE "500 МГц"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_BE "Загружаць карыстальніцкія тэкстуры"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_BE "Загружаць прыстасаваныя тэкстуры з тэчкі 'system/dc/textures/<game-id>/'."
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_BE "Здымаць дамп тэкстур"
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_BE "Пры кожным выкарыстанні гульнёй новай тэкстуры яна будзе захоўвацца ў файл .png у тэчцы 'system/dc/texdump/<game-id>/'."
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_BE "Мёртвая зона аналагавага стыку"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_BE "Настройка велічыні адхілення аналагавага джойсціка для спрацоўвання."
#define OPTION_VAL_0_BE "0 %"
#define OPTION_VAL_5_BE "5 %"
#define OPTION_VAL_10_BE "10 %"
#define OPTION_VAL_15_BE "15 %"
#define OPTION_VAL_20_BE "20 %"
#define OPTION_VAL_25_BE "25 %"
#define OPTION_VAL_30_BE "30 %"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_BE "Мёртвая зона трыгераў"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_BE "Настройка ступені націску трыгераў для спрацоўвання."
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_BE "Лічбавыя трыгеры"
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_BE "Пры ўключэнні трыгеры будуць апрацоўвацца як стандартныя кнопкі, цалкам націснутыя ці не націснутыя, без прамежкавых палажэнняў."
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_BE "Трансляваць лічбавыя сігналы"
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_BE "Трансляваць падзеі лічбавага ўводу і стан вібрацыі ў TCP-порт 8000. Сумяшчальна з параметрам MAME \"-output network\"."
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_BE "Паказваць наладкі светлавога пісталета"
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_BE "Уключае канфігурацыю параметраў прыцэла светлавога пісталета. Для прымянення наладкі патрабуецца пераключыць хуткае меню."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_BE "Маштабаванне прыцэлу пісталета"
#define OPTION_VAL_50_BE "50 %"
#define OPTION_VAL_60_BE "60 %"
#define OPTION_VAL_70_BE "70 %"
#define OPTION_VAL_80_BE "80 %"
#define OPTION_VAL_90_BE "90 %"
#define OPTION_VAL_100_O46_BE "100 %"
#define OPTION_VAL_110_O46_BE "110 %"
#define OPTION_VAL_120_O46_BE "120 %"
#define OPTION_VAL_130_O46_BE "130 %"
#define OPTION_VAL_140_O46_BE "140 %"
#define OPTION_VAL_150_O46_BE "150 %"
#define OPTION_VAL_160_O46_BE "160 %"
#define OPTION_VAL_170_O46_BE "170 %"
#define OPTION_VAL_180_O46_BE "180 %"
#define OPTION_VAL_190_O46_BE "190 %"
#define OPTION_VAL_200_O46_BE "200 %"
#define OPTION_VAL_210_O46_BE "210 %"
#define OPTION_VAL_220_O46_BE "220 %"
#define OPTION_VAL_230_O46_BE "230 %"
#define OPTION_VAL_240_O46_BE "240 %"
#define OPTION_VAL_250_O46_BE "250 %"
#define OPTION_VAL_260_O46_BE "260 %"
#define OPTION_VAL_270_O46_BE "270 %"
#define OPTION_VAL_280_O46_BE "280 %"
#define OPTION_VAL_290_O46_BE "290 %"
#define OPTION_VAL_300_O46_BE "300 %"
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_BE "Адлюстраванне прыцэла пісталета 1"
#define OPTION_VAL_WHITE_BE "Белы"
#define OPTION_VAL_RED_BE "Чырвоная"
#define OPTION_VAL_GREEN_BE "Зялёная"
#define OPTION_VAL_BLUE_BE "Блакітная"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_BE "Адлюстраванне прыцэла пісталета 2"
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_BE "Адлюстраванне прыцэла пісталета 3"
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_BE "Адлюстраванне прыцэла пісталета 4"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_BE "Прылада ў слоце пашырэння A1"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння A1 (порт А слот 1)."
#define OPTION_VAL_VMU_BE NULL
#define OPTION_VAL_PURUPURU_BE "Вібрапак"
#define OPTION_VAL_NONE_BE "Няма"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_BE "Прылада ў слоце пашырэння A2"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння A2 (порт А слот 2)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_BE "Прылада ў слоце пашырэння B1"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння B1 (порт B слот 1)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_BE "Прылада ў слоце пашырэння B2"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння B2 (порт B слот 2)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_BE "Прылада ў слоце пашырэння C1"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння C1 (порт C слот 1)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_BE "Прылада ў слоце пашырэння C2"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння C2 (порт C слот 2)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_BE "Прылада ў слоце пашырэння D1"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння D1 (порт D слот 1)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_BE "Прылада ў слоце пашырэння D2"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_BE "Выбар прылады, уключанай у слот пашырэння D2 (порт D слот 2)."
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_BE "Асобныя візуальныя карты памяці (VMU) для гульняў"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_BE "VMU для кожнай гульні"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_BE "Калі выключана, усе гульні выкарыстоўваюць да 8 файлаў захавання VMU (A1/A2/B1/B2/C1/C2/D1/D2), размешчаных у сістэмнай тэчцы RetroArch.\nНалада 'VMU A1' стварае на кожную запушчаную гульню ўнікальны файл VMU 'A1' у тэчцы захавання RetroArch.\nНалада 'Усе VMU' стварае да 8 унікальных файлаў VMU (A1/A2/B1/B2/C1/C2/D1/D2) на кожную запушчаную гульню."
#define OPTION_VAL_VMU_A1_BE NULL
#define OPTION_VAL_ALL_VMUS_BE "Усе VMU"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_BE "Гукавыя сігналы візуальных карт памяці (VMU)"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_BE "Сігналы VMU"
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_BE "Уключае прайграванне сігналаў VMU."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_BE "Паказваць настройкі адлюстравання візуальных карт памяці (VMU)"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_BE "Паказваць наладкі адлюстравання VMU"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_BE "Уключае канфігурацыю памеру, становішча, колеру і бачнасці якая эмулюецца LCD-экранам VMU. Для прымянення наладкі патрабуецца пераключэнне хуткага меню."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_BE "Паказаць экран VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_BE "Палажэнне экрана VMU 1"
#define OPTION_VAL_UPPER_LEFT_BE "Зверху злева"
#define OPTION_VAL_UPPER_RIGHT_BE "Зверху справа"
#define OPTION_VAL_LOWER_LEFT_BE "Унізе злева"
#define OPTION_VAL_LOWER_RIGHT_BE "Унізе справа"
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_BE "Памер экрана VMU 1"
#define OPTION_VAL_1X_BE NULL
#define OPTION_VAL_3X_BE NULL
#define OPTION_VAL_5X_BE NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_BE "Колер уключаных пікселяў VMU 1"
#define OPTION_VAL_DEFAULT_ON_00_BE "Па змаўчанні ЎКЛ"
#define OPTION_VAL_DEFAULT_OFF_01_BE "Па змаўчанні ВЫКЛ"
#define OPTION_VAL_BLACK_02_BE "Чорны"
#define OPTION_VAL_LIGHT_BLUE_04_BE "Светла-блакітны"
#define OPTION_VAL_CYAN_06_BE "Марской хвалі"
#define OPTION_VAL_CYAN_BLUE_07_BE "Блакітна-сіні"
#define OPTION_VAL_LIGHT_GREEN_08_BE "Светла-зялёны"
#define OPTION_VAL_CYAN_GREEN_09_BE "Блакітна-зялёны"
#define OPTION_VAL_LIGHT_CYAN_10_BE "Светла-блакітны"
#define OPTION_VAL_PURPLE_12_BE "Фіялетавы"
#define OPTION_VAL_LIGHT_PURPLE_13_BE "Светла-фіялетавы"
#define OPTION_VAL_YELLOW_14_BE "Жоўтая"
#define OPTION_VAL_GRAY_15_BE "Шэры"
#define OPTION_VAL_LIGHT_PURPLE_2_16_BE "Светла-фіялетавы (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_BE "Светла-зялёны (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_BE "Светла-зялёны (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_BE "Светла-блакітны (2)"
#define OPTION_VAL_LIGHT_RED_2_20_BE "Светла-чырвоны (2)"
#define OPTION_VAL_MAGENTA_21_BE "Пурпурны"
#define OPTION_VAL_LIGHT_PURPLE_3_22_BE "Светла-фіялетавы (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_BE "Светла-аранжавы"
#define OPTION_VAL_ORANGE_24_BE "Аранжавы"
#define OPTION_VAL_LIGHT_PURPLE_4_25_BE "Светла-фіялетавы (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_BE "Светла-жоўты"
#define OPTION_VAL_LIGHT_YELLOW_2_27_BE "Светла-жоўты (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_BE "Колер выключаных пікселяў VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_BE "Бачнасць экрана VMU 1"
#define OPTION_VAL_40_BE "40 %"
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_BE "Паказаць экран VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_BE "Палажэнне экрана VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_BE "Памер экрана VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_BE "Колер уключаных пікселяў VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_BE "Колер выключаных пікселяў VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_BE "Бачнасць экрана VMU 2"
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_BE "Паказаць экран VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_BE "Палажэнне экрана VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_BE "Памер экрана VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_BE "Колер уключаных пікселяў VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_BE "Колер выключаных пікселяў VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_BE "Бачнасць экрана VMU 3"
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_BE "Паказаць экран VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_BE "Палажэнне экрана VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_BE "Памер экрана VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_BE "Колер уключаных пікселяў VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_BE "Колер выключаных пікселяў VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_BE "Бачнасць экрана VMU 4"

struct retro_core_option_v2_category option_cats_be[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_BE,
      CATEGORY_SYSTEM_INFO_0_BE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_BE,
      CATEGORY_VIDEO_INFO_0_BE
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_BE,
      CATEGORY_PERFORMANCE_INFO_0_BE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_BE,
      CATEGORY_HACKS_INFO_0_BE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_BE,
      CATEGORY_INPUT_INFO_0_BE
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_BE,
      CATEGORY_EXPANSIONS_INFO_0_BE
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_BE,
      CATEGORY_VMU_INFO_0_BE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_be[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_BE,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_BE },
         { "USA",     OPTION_VAL_USA_BE },
         { "Europe",  OPTION_VAL_EUROPE_BE },
         { "Default", OPTION_VAL_DEFAULT_BE },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_BE,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_BE },
         { "English",  OPTION_VAL_ENGLISH_BE },
         { "German",   OPTION_VAL_GERMAN_BE },
         { "French",   OPTION_VAL_FRENCH_BE },
         { "Spanish",  OPTION_VAL_SPANISH_BE },
         { "Italian",  OPTION_VAL_ITALIAN_BE },
         { "Default",  OPTION_VAL_DEFAULT_BE },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_BE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_BE,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_BE },
         { "640x480",    OPTION_VAL_640X480_BE },
         { "800x600",    OPTION_VAL_800X600_BE },
         { "960x720",    OPTION_VAL_960X720_BE },
         { "1024x768",   OPTION_VAL_1024X768_BE },
         { "1280x960",   OPTION_VAL_1280X960_BE },
         { "1440x1080",  OPTION_VAL_1440X1080_BE },
         { "1600x1200",  OPTION_VAL_1600X1200_BE },
         { "1920x1440",  OPTION_VAL_1920X1440_BE },
         { "2560x1920",  OPTION_VAL_2560X1920_BE },
         { "2880x2160",  OPTION_VAL_2880X2160_BE },
         { "3200x2400",  OPTION_VAL_3200X2400_BE },
         { "3840x2880",  OPTION_VAL_3840X2880_BE },
         { "4480x3360",  OPTION_VAL_4480X3360_BE },
         { "5120x3840",  OPTION_VAL_5120X3840_BE },
         { "5760x4320",  OPTION_VAL_5760X4320_BE },
         { "6400x4800",  OPTION_VAL_6400X4800_BE },
         { "7040x5280",  OPTION_VAL_7040X5280_BE },
         { "7680x5760",  OPTION_VAL_7680X5760_BE },
         { "8320x6240",  OPTION_VAL_8320X6240_BE },
         { "8960x6720",  OPTION_VAL_8960X6720_BE },
         { "9600x7200",  OPTION_VAL_9600X7200_BE },
         { "10240x7680", OPTION_VAL_10240X7680_BE },
         { "10880x8160", OPTION_VAL_10880X8160_BE },
         { "11520x8640", OPTION_VAL_11520X8640_BE },
         { "12160x9120", OPTION_VAL_12160X9120_BE },
         { "12800x9600", OPTION_VAL_12800X9600_BE },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_BE,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_BE },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_BE },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_BE },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_BE,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_BE },
         { "PAL",     OPTION_VAL_PAL_BE },
         { "PAL_N",   OPTION_VAL_PAL_N_BE },
         { "PAL_M",   OPTION_VAL_PAL_M_BE },
         { "Default", OPTION_VAL_DEFAULT_BE },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_BE,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_BE },
         { "vertical",   OPTION_VAL_VERTICAL_BE },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_BE,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_BE },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_BE },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_BE },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_BE,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_BE },
         { "1GB",   OPTION_VAL_1GB_BE },
         { "2GB",   OPTION_VAL_2GB_BE },
         { "4GB",   OPTION_VAL_4GB_BE },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_BE,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_BE,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_BE,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_BE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_BE },
         { "1",  OPTION_VAL_1_BE },
         { "2",  OPTION_VAL_2_BE },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_BE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_BE,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_BE },
         { "4",  OPTION_VAL_4_BE },
         { "6",  OPTION_VAL_6_BE },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_BE,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_BE,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_BE,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_BE,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_BE,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_BE,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_BE,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_BE },
         { "more", OPTION_VAL_MORE_BE },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_BE,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_BE },
         { "110", OPTION_VAL_110_BE },
         { "120", OPTION_VAL_120_BE },
         { "130", OPTION_VAL_130_BE },
         { "140", OPTION_VAL_140_BE },
         { "150", OPTION_VAL_150_BE },
         { "160", OPTION_VAL_160_BE },
         { "170", OPTION_VAL_170_BE },
         { "180", OPTION_VAL_180_BE },
         { "190", OPTION_VAL_190_BE },
         { "200", OPTION_VAL_200_BE },
         { "210", OPTION_VAL_210_BE },
         { "220", OPTION_VAL_220_BE },
         { "230", OPTION_VAL_230_BE },
         { "240", OPTION_VAL_240_BE },
         { "250", OPTION_VAL_250_BE },
         { "260", OPTION_VAL_260_BE },
         { "270", OPTION_VAL_270_BE },
         { "280", OPTION_VAL_280_BE },
         { "290", OPTION_VAL_290_BE },
         { "300", OPTION_VAL_300_BE },
         { "310", OPTION_VAL_310_BE },
         { "320", OPTION_VAL_320_BE },
         { "330", OPTION_VAL_330_BE },
         { "340", OPTION_VAL_340_BE },
         { "350", OPTION_VAL_350_BE },
         { "360", OPTION_VAL_360_BE },
         { "370", OPTION_VAL_370_BE },
         { "380", OPTION_VAL_380_BE },
         { "390", OPTION_VAL_390_BE },
         { "400", OPTION_VAL_400_BE },
         { "410", OPTION_VAL_410_BE },
         { "420", OPTION_VAL_420_BE },
         { "430", OPTION_VAL_430_BE },
         { "440", OPTION_VAL_440_BE },
         { "450", OPTION_VAL_450_BE },
         { "460", OPTION_VAL_460_BE },
         { "470", OPTION_VAL_470_BE },
         { "480", OPTION_VAL_480_BE },
         { "490", OPTION_VAL_490_BE },
         { "500", OPTION_VAL_500_BE },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_BE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_BE,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_BE },
         { "5%",  OPTION_VAL_5_BE },
         { "10%", OPTION_VAL_10_BE },
         { "15%", OPTION_VAL_15_BE },
         { "20%", OPTION_VAL_20_BE },
         { "25%", OPTION_VAL_25_BE },
         { "30%", OPTION_VAL_30_BE },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_BE,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_BE },
         { "5%",  OPTION_VAL_5_BE },
         { "10%", OPTION_VAL_10_BE },
         { "15%", OPTION_VAL_15_BE },
         { "20%", OPTION_VAL_20_BE },
         { "25%", OPTION_VAL_25_BE },
         { "30%", OPTION_VAL_30_BE },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_BE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_BE,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_BE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_BE },
         { "60%",  OPTION_VAL_60_BE },
         { "70%",  OPTION_VAL_70_BE },
         { "80%",  OPTION_VAL_80_BE },
         { "90%",  OPTION_VAL_90_BE },
         { "100%", OPTION_VAL_100_O46_BE },
         { "110%", OPTION_VAL_110_O46_BE },
         { "120%", OPTION_VAL_120_O46_BE },
         { "130%", OPTION_VAL_130_O46_BE },
         { "140%", OPTION_VAL_140_O46_BE },
         { "150%", OPTION_VAL_150_O46_BE },
         { "160%", OPTION_VAL_160_O46_BE },
         { "170%", OPTION_VAL_170_O46_BE },
         { "180%", OPTION_VAL_180_O46_BE },
         { "190%", OPTION_VAL_190_O46_BE },
         { "200%", OPTION_VAL_200_O46_BE },
         { "210%", OPTION_VAL_210_O46_BE },
         { "220%", OPTION_VAL_220_O46_BE },
         { "230%", OPTION_VAL_230_O46_BE },
         { "240%", OPTION_VAL_240_O46_BE },
         { "250%", OPTION_VAL_250_O46_BE },
         { "260%", OPTION_VAL_260_O46_BE },
         { "270%", OPTION_VAL_270_O46_BE },
         { "280%", OPTION_VAL_280_O46_BE },
         { "290%", OPTION_VAL_290_O46_BE },
         { "300%", OPTION_VAL_300_O46_BE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_BE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BE },
         { "Red",      OPTION_VAL_RED_BE },
         { "Green",    OPTION_VAL_GREEN_BE },
         { "Blue",     OPTION_VAL_BLUE_BE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_BE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BE },
         { "Red",      OPTION_VAL_RED_BE },
         { "Green",    OPTION_VAL_GREEN_BE },
         { "Blue",     OPTION_VAL_BLUE_BE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_BE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BE },
         { "Red",      OPTION_VAL_RED_BE },
         { "Green",    OPTION_VAL_GREEN_BE },
         { "Blue",     OPTION_VAL_BLUE_BE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_BE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BE },
         { "Red",      OPTION_VAL_RED_BE },
         { "Green",    OPTION_VAL_GREEN_BE },
         { "Blue",     OPTION_VAL_BLUE_BE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_BE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_BE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BE },
         { "Purupuru", OPTION_VAL_PURUPURU_BE },
         { "None",     OPTION_VAL_NONE_BE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_BE,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_BE,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_BE,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_BE },
         { "All VMUs", OPTION_VAL_ALL_VMUS_BE },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_BE,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_BE,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_BE,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_BE,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_BE,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_BE,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BE },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BE },
         { "2x", OPTION_VAL_2_O27_BE },
         { "3x", OPTION_VAL_3X_BE },
         { "4x", OPTION_VAL_4_BE },
         { "5x", OPTION_VAL_5X_BE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BE },
         { "20%",  OPTION_VAL_20_BE },
         { "30%",  OPTION_VAL_30_BE },
         { "40%",  OPTION_VAL_40_BE },
         { "50%",  OPTION_VAL_50_BE },
         { "60%",  OPTION_VAL_60_BE },
         { "70%",  OPTION_VAL_70_BE },
         { "80%",  OPTION_VAL_80_BE },
         { "90%",  OPTION_VAL_90_BE },
         { "100%", OPTION_VAL_100_O46_BE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BE },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BE },
         { "2x", OPTION_VAL_2_O27_BE },
         { "3x", OPTION_VAL_3X_BE },
         { "4x", OPTION_VAL_4_BE },
         { "5x", OPTION_VAL_5X_BE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BE },
         { "20%",  OPTION_VAL_20_BE },
         { "30%",  OPTION_VAL_30_BE },
         { "40%",  OPTION_VAL_40_BE },
         { "50%",  OPTION_VAL_50_BE },
         { "60%",  OPTION_VAL_60_BE },
         { "70%",  OPTION_VAL_70_BE },
         { "80%",  OPTION_VAL_80_BE },
         { "90%",  OPTION_VAL_90_BE },
         { "100%", OPTION_VAL_100_O46_BE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BE },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BE },
         { "2x", OPTION_VAL_2_O27_BE },
         { "3x", OPTION_VAL_3X_BE },
         { "4x", OPTION_VAL_4_BE },
         { "5x", OPTION_VAL_5X_BE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BE },
         { "20%",  OPTION_VAL_20_BE },
         { "30%",  OPTION_VAL_30_BE },
         { "40%",  OPTION_VAL_40_BE },
         { "50%",  OPTION_VAL_50_BE },
         { "60%",  OPTION_VAL_60_BE },
         { "70%",  OPTION_VAL_70_BE },
         { "80%",  OPTION_VAL_80_BE },
         { "90%",  OPTION_VAL_90_BE },
         { "100%", OPTION_VAL_100_O46_BE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BE },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BE },
         { "2x", OPTION_VAL_2_O27_BE },
         { "3x", OPTION_VAL_3X_BE },
         { "4x", OPTION_VAL_4_BE },
         { "5x", OPTION_VAL_5X_BE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BE },
         { "BLUE 03",           OPTION_VAL_BLUE_BE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BE },
         { "GREEN 05",          OPTION_VAL_GREEN_BE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BE },
         { "RED 11",            OPTION_VAL_RED_BE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BE },
         { "WHITE 28",          OPTION_VAL_WHITE_BE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_BE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BE },
         { "20%",  OPTION_VAL_20_BE },
         { "30%",  OPTION_VAL_30_BE },
         { "40%",  OPTION_VAL_40_BE },
         { "50%",  OPTION_VAL_50_BE },
         { "60%",  OPTION_VAL_60_BE },
         { "70%",  OPTION_VAL_70_BE },
         { "80%",  OPTION_VAL_80_BE },
         { "90%",  OPTION_VAL_90_BE },
         { "100%", OPTION_VAL_100_O46_BE },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_be = {
   option_cats_be,
   option_defs_be
};

/* RETRO_LANGUAGE_BG */

#define CATEGORY_SYSTEM_LABEL_BG NULL
#define CATEGORY_SYSTEM_INFO_0_BG NULL
#define CATEGORY_VIDEO_LABEL_BG "Видео"
#define CATEGORY_VIDEO_INFO_0_BG NULL
#define CATEGORY_PERFORMANCE_LABEL_BG NULL
#define CATEGORY_PERFORMANCE_INFO_0_BG NULL
#define CATEGORY_HACKS_LABEL_BG NULL
#define CATEGORY_HACKS_INFO_0_BG NULL
#define CATEGORY_INPUT_LABEL_BG "Вход"
#define CATEGORY_INPUT_INFO_0_BG NULL
#define CATEGORY_EXPANSIONS_LABEL_BG NULL
#define CATEGORY_EXPANSIONS_INFO_0_BG NULL
#define CATEGORY_VMU_LABEL_BG NULL
#define CATEGORY_VMU_INFO_0_BG NULL
#define CORE_OPTION_NAME_REGION_LABEL_BG NULL
#define OPTION_VAL_JAPAN_BG NULL
#define OPTION_VAL_USA_BG NULL
#define OPTION_VAL_EUROPE_BG NULL
#define OPTION_VAL_DEFAULT_BG NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_BG NULL
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_BG NULL
#define OPTION_VAL_JAPANESE_BG NULL
#define OPTION_VAL_ENGLISH_BG NULL
#define OPTION_VAL_GERMAN_BG NULL
#define OPTION_VAL_FRENCH_BG NULL
#define OPTION_VAL_SPANISH_BG NULL
#define OPTION_VAL_ITALIAN_BG NULL
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_BG NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_BG NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_BG NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_BG NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_BG NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_BG NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_BG NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_BG NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_BG NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_BG NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_BG NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_BG NULL
#define CORE_OPTION_NAME_UPNP_LABEL_BG NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_BG NULL
#define CORE_OPTION_NAME_DCNET_LABEL_BG NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_BG NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_BG NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_BG NULL
#define OPTION_VAL_320X240_BG NULL
#define OPTION_VAL_640X480_BG NULL
#define OPTION_VAL_800X600_BG NULL
#define OPTION_VAL_960X720_BG NULL
#define OPTION_VAL_1024X768_BG NULL
#define OPTION_VAL_1280X960_BG NULL
#define OPTION_VAL_1440X1080_BG NULL
#define OPTION_VAL_1600X1200_BG NULL
#define OPTION_VAL_1920X1440_BG NULL
#define OPTION_VAL_2560X1920_BG NULL
#define OPTION_VAL_2880X2160_BG NULL
#define OPTION_VAL_3200X2400_BG NULL
#define OPTION_VAL_3840X2880_BG NULL
#define OPTION_VAL_4480X3360_BG NULL
#define OPTION_VAL_5120X3840_BG NULL
#define OPTION_VAL_5760X4320_BG NULL
#define OPTION_VAL_6400X4800_BG NULL
#define OPTION_VAL_7040X5280_BG NULL
#define OPTION_VAL_7680X5760_BG NULL
#define OPTION_VAL_8320X6240_BG NULL
#define OPTION_VAL_8960X6720_BG NULL
#define OPTION_VAL_9600X7200_BG NULL
#define OPTION_VAL_10240X7680_BG NULL
#define OPTION_VAL_10880X8160_BG NULL
#define OPTION_VAL_11520X8640_BG NULL
#define OPTION_VAL_12160X9120_BG NULL
#define OPTION_VAL_12800X9600_BG NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_BG NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_BG NULL
#define OPTION_VAL_VGA_BG NULL
#define OPTION_VAL_TV_RGB_BG NULL
#define OPTION_VAL_TV_COMPOSITE_BG NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_BG NULL
#define OPTION_VAL_NTSC_BG NULL
#define OPTION_VAL_PAL_BG NULL
#define OPTION_VAL_PAL_N_BG NULL
#define OPTION_VAL_PAL_M_BG NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_BG NULL
#define OPTION_VAL_HORIZONTAL_BG NULL
#define OPTION_VAL_VERTICAL_BG NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_BG NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_BG NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_BG NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_BG NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_BG NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_BG NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_BG NULL
#define OPTION_VAL_512MB_BG NULL
#define OPTION_VAL_1GB_BG NULL
#define OPTION_VAL_2GB_BG NULL
#define OPTION_VAL_4GB_BG NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_BG NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_BG NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_BG NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_BG NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_BG NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_BG NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_BG NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_BG NULL
#define CORE_OPTION_NAME_FOG_LABEL_BG NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_BG NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_BG NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_BG NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_BG NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_BG NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_BG NULL
#define OPTION_VAL_1_BG NULL
#define OPTION_VAL_2_BG NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_BG NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_BG NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_BG NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_BG NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_BG NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_BG NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_BG NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_BG NULL
#define OPTION_VAL_2_O27_BG NULL
#define OPTION_VAL_4_BG NULL
#define OPTION_VAL_6_BG NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_BG NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_BG NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_BG NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_BG NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_BG NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_BG NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_BG NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_BG NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_BG NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_BG NULL
#define OPTION_VAL_SOME_BG NULL
#define OPTION_VAL_MORE_BG NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_BG NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_BG NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_BG NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_BG NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_BG NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_BG NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_BG NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_BG NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_BG NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_BG NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_BG NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_BG NULL
#define OPTION_VAL_100_BG NULL
#define OPTION_VAL_110_BG NULL
#define OPTION_VAL_120_BG NULL
#define OPTION_VAL_130_BG NULL
#define OPTION_VAL_140_BG NULL
#define OPTION_VAL_150_BG NULL
#define OPTION_VAL_160_BG NULL
#define OPTION_VAL_170_BG NULL
#define OPTION_VAL_180_BG NULL
#define OPTION_VAL_190_BG NULL
#define OPTION_VAL_200_BG NULL
#define OPTION_VAL_210_BG NULL
#define OPTION_VAL_220_BG NULL
#define OPTION_VAL_230_BG NULL
#define OPTION_VAL_240_BG NULL
#define OPTION_VAL_250_BG NULL
#define OPTION_VAL_260_BG NULL
#define OPTION_VAL_270_BG NULL
#define OPTION_VAL_280_BG NULL
#define OPTION_VAL_290_BG NULL
#define OPTION_VAL_300_BG NULL
#define OPTION_VAL_310_BG NULL
#define OPTION_VAL_320_BG NULL
#define OPTION_VAL_330_BG NULL
#define OPTION_VAL_340_BG NULL
#define OPTION_VAL_350_BG NULL
#define OPTION_VAL_360_BG NULL
#define OPTION_VAL_370_BG NULL
#define OPTION_VAL_380_BG NULL
#define OPTION_VAL_390_BG NULL
#define OPTION_VAL_400_BG NULL
#define OPTION_VAL_410_BG NULL
#define OPTION_VAL_420_BG NULL
#define OPTION_VAL_430_BG NULL
#define OPTION_VAL_440_BG NULL
#define OPTION_VAL_450_BG NULL
#define OPTION_VAL_460_BG NULL
#define OPTION_VAL_470_BG NULL
#define OPTION_VAL_480_BG NULL
#define OPTION_VAL_490_BG NULL
#define OPTION_VAL_500_BG NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_BG NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_BG NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_BG NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_BG NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_BG NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_BG NULL
#define OPTION_VAL_0_BG NULL
#define OPTION_VAL_5_BG NULL
#define OPTION_VAL_10_BG NULL
#define OPTION_VAL_15_BG NULL
#define OPTION_VAL_20_BG NULL
#define OPTION_VAL_25_BG NULL
#define OPTION_VAL_30_BG NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_BG NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_BG NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_BG NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_BG NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_BG NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_BG NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_BG NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_BG NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_BG NULL
#define OPTION_VAL_50_BG NULL
#define OPTION_VAL_60_BG NULL
#define OPTION_VAL_70_BG NULL
#define OPTION_VAL_80_BG NULL
#define OPTION_VAL_90_BG NULL
#define OPTION_VAL_100_O46_BG NULL
#define OPTION_VAL_110_O46_BG NULL
#define OPTION_VAL_120_O46_BG NULL
#define OPTION_VAL_130_O46_BG NULL
#define OPTION_VAL_140_O46_BG NULL
#define OPTION_VAL_150_O46_BG NULL
#define OPTION_VAL_160_O46_BG NULL
#define OPTION_VAL_170_O46_BG NULL
#define OPTION_VAL_180_O46_BG NULL
#define OPTION_VAL_190_O46_BG NULL
#define OPTION_VAL_200_O46_BG NULL
#define OPTION_VAL_210_O46_BG NULL
#define OPTION_VAL_220_O46_BG NULL
#define OPTION_VAL_230_O46_BG NULL
#define OPTION_VAL_240_O46_BG NULL
#define OPTION_VAL_250_O46_BG NULL
#define OPTION_VAL_260_O46_BG NULL
#define OPTION_VAL_270_O46_BG NULL
#define OPTION_VAL_280_O46_BG NULL
#define OPTION_VAL_290_O46_BG NULL
#define OPTION_VAL_300_O46_BG NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_BG NULL
#define OPTION_VAL_WHITE_BG NULL
#define OPTION_VAL_RED_BG NULL
#define OPTION_VAL_GREEN_BG NULL
#define OPTION_VAL_BLUE_BG NULL
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_BG NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_BG NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_BG NULL
#define OPTION_VAL_VMU_BG NULL
#define OPTION_VAL_PURUPURU_BG NULL
#define OPTION_VAL_NONE_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_BG NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_BG NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_BG NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_BG NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_BG NULL
#define OPTION_VAL_VMU_A1_BG NULL
#define OPTION_VAL_ALL_VMUS_BG NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_BG NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_BG NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_BG NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_BG NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_BG NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_BG NULL
#define OPTION_VAL_UPPER_LEFT_BG NULL
#define OPTION_VAL_UPPER_RIGHT_BG NULL
#define OPTION_VAL_LOWER_LEFT_BG NULL
#define OPTION_VAL_LOWER_RIGHT_BG NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_BG NULL
#define OPTION_VAL_1X_BG NULL
#define OPTION_VAL_3X_BG NULL
#define OPTION_VAL_5X_BG NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_BG NULL
#define OPTION_VAL_DEFAULT_ON_00_BG NULL
#define OPTION_VAL_DEFAULT_OFF_01_BG NULL
#define OPTION_VAL_BLACK_02_BG NULL
#define OPTION_VAL_LIGHT_BLUE_04_BG NULL
#define OPTION_VAL_CYAN_06_BG NULL
#define OPTION_VAL_CYAN_BLUE_07_BG NULL
#define OPTION_VAL_LIGHT_GREEN_08_BG NULL
#define OPTION_VAL_CYAN_GREEN_09_BG NULL
#define OPTION_VAL_LIGHT_CYAN_10_BG NULL
#define OPTION_VAL_PURPLE_12_BG NULL
#define OPTION_VAL_LIGHT_PURPLE_13_BG NULL
#define OPTION_VAL_YELLOW_14_BG NULL
#define OPTION_VAL_GRAY_15_BG NULL
#define OPTION_VAL_LIGHT_PURPLE_2_16_BG NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_BG NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_BG NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_BG NULL
#define OPTION_VAL_LIGHT_RED_2_20_BG NULL
#define OPTION_VAL_MAGENTA_21_BG NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_BG NULL
#define OPTION_VAL_LIGHT_ORANGE_23_BG NULL
#define OPTION_VAL_ORANGE_24_BG NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_BG NULL
#define OPTION_VAL_LIGHT_YELLOW_26_BG NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_BG NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_BG NULL
#define OPTION_VAL_40_BG NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_BG NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_BG NULL

struct retro_core_option_v2_category option_cats_bg[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_BG,
      CATEGORY_SYSTEM_INFO_0_BG
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_BG,
      CATEGORY_VIDEO_INFO_0_BG
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_BG,
      CATEGORY_PERFORMANCE_INFO_0_BG
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_BG,
      CATEGORY_HACKS_INFO_0_BG
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_BG,
      CATEGORY_INPUT_INFO_0_BG
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_BG,
      CATEGORY_EXPANSIONS_INFO_0_BG
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_BG,
      CATEGORY_VMU_INFO_0_BG
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_bg[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_BG,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_BG },
         { "USA",     OPTION_VAL_USA_BG },
         { "Europe",  OPTION_VAL_EUROPE_BG },
         { "Default", OPTION_VAL_DEFAULT_BG },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_BG,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_BG },
         { "English",  OPTION_VAL_ENGLISH_BG },
         { "German",   OPTION_VAL_GERMAN_BG },
         { "French",   OPTION_VAL_FRENCH_BG },
         { "Spanish",  OPTION_VAL_SPANISH_BG },
         { "Italian",  OPTION_VAL_ITALIAN_BG },
         { "Default",  OPTION_VAL_DEFAULT_BG },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_BG,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_BG,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_BG },
         { "640x480",    OPTION_VAL_640X480_BG },
         { "800x600",    OPTION_VAL_800X600_BG },
         { "960x720",    OPTION_VAL_960X720_BG },
         { "1024x768",   OPTION_VAL_1024X768_BG },
         { "1280x960",   OPTION_VAL_1280X960_BG },
         { "1440x1080",  OPTION_VAL_1440X1080_BG },
         { "1600x1200",  OPTION_VAL_1600X1200_BG },
         { "1920x1440",  OPTION_VAL_1920X1440_BG },
         { "2560x1920",  OPTION_VAL_2560X1920_BG },
         { "2880x2160",  OPTION_VAL_2880X2160_BG },
         { "3200x2400",  OPTION_VAL_3200X2400_BG },
         { "3840x2880",  OPTION_VAL_3840X2880_BG },
         { "4480x3360",  OPTION_VAL_4480X3360_BG },
         { "5120x3840",  OPTION_VAL_5120X3840_BG },
         { "5760x4320",  OPTION_VAL_5760X4320_BG },
         { "6400x4800",  OPTION_VAL_6400X4800_BG },
         { "7040x5280",  OPTION_VAL_7040X5280_BG },
         { "7680x5760",  OPTION_VAL_7680X5760_BG },
         { "8320x6240",  OPTION_VAL_8320X6240_BG },
         { "8960x6720",  OPTION_VAL_8960X6720_BG },
         { "9600x7200",  OPTION_VAL_9600X7200_BG },
         { "10240x7680", OPTION_VAL_10240X7680_BG },
         { "10880x8160", OPTION_VAL_10880X8160_BG },
         { "11520x8640", OPTION_VAL_11520X8640_BG },
         { "12160x9120", OPTION_VAL_12160X9120_BG },
         { "12800x9600", OPTION_VAL_12800X9600_BG },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_BG,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_BG },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_BG },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_BG },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_BG,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_BG },
         { "PAL",     OPTION_VAL_PAL_BG },
         { "PAL_N",   OPTION_VAL_PAL_N_BG },
         { "PAL_M",   OPTION_VAL_PAL_M_BG },
         { "Default", OPTION_VAL_DEFAULT_BG },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_BG,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_BG },
         { "vertical",   OPTION_VAL_VERTICAL_BG },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_BG,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_BG },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_BG },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_BG },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_BG,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_BG },
         { "1GB",   OPTION_VAL_1GB_BG },
         { "2GB",   OPTION_VAL_2GB_BG },
         { "4GB",   OPTION_VAL_4GB_BG },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_BG,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_BG,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_BG,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_BG,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_BG },
         { "1",  OPTION_VAL_1_BG },
         { "2",  OPTION_VAL_2_BG },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_BG,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_BG,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_BG },
         { "4",  OPTION_VAL_4_BG },
         { "6",  OPTION_VAL_6_BG },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_BG,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_BG,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_BG,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_BG,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_BG,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_BG,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_BG,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_BG },
         { "more", OPTION_VAL_MORE_BG },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_BG,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_BG },
         { "110", OPTION_VAL_110_BG },
         { "120", OPTION_VAL_120_BG },
         { "130", OPTION_VAL_130_BG },
         { "140", OPTION_VAL_140_BG },
         { "150", OPTION_VAL_150_BG },
         { "160", OPTION_VAL_160_BG },
         { "170", OPTION_VAL_170_BG },
         { "180", OPTION_VAL_180_BG },
         { "190", OPTION_VAL_190_BG },
         { "200", OPTION_VAL_200_BG },
         { "210", OPTION_VAL_210_BG },
         { "220", OPTION_VAL_220_BG },
         { "230", OPTION_VAL_230_BG },
         { "240", OPTION_VAL_240_BG },
         { "250", OPTION_VAL_250_BG },
         { "260", OPTION_VAL_260_BG },
         { "270", OPTION_VAL_270_BG },
         { "280", OPTION_VAL_280_BG },
         { "290", OPTION_VAL_290_BG },
         { "300", OPTION_VAL_300_BG },
         { "310", OPTION_VAL_310_BG },
         { "320", OPTION_VAL_320_BG },
         { "330", OPTION_VAL_330_BG },
         { "340", OPTION_VAL_340_BG },
         { "350", OPTION_VAL_350_BG },
         { "360", OPTION_VAL_360_BG },
         { "370", OPTION_VAL_370_BG },
         { "380", OPTION_VAL_380_BG },
         { "390", OPTION_VAL_390_BG },
         { "400", OPTION_VAL_400_BG },
         { "410", OPTION_VAL_410_BG },
         { "420", OPTION_VAL_420_BG },
         { "430", OPTION_VAL_430_BG },
         { "440", OPTION_VAL_440_BG },
         { "450", OPTION_VAL_450_BG },
         { "460", OPTION_VAL_460_BG },
         { "470", OPTION_VAL_470_BG },
         { "480", OPTION_VAL_480_BG },
         { "490", OPTION_VAL_490_BG },
         { "500", OPTION_VAL_500_BG },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_BG,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_BG,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_BG },
         { "5%",  OPTION_VAL_5_BG },
         { "10%", OPTION_VAL_10_BG },
         { "15%", OPTION_VAL_15_BG },
         { "20%", OPTION_VAL_20_BG },
         { "25%", OPTION_VAL_25_BG },
         { "30%", OPTION_VAL_30_BG },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_BG,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_BG },
         { "5%",  OPTION_VAL_5_BG },
         { "10%", OPTION_VAL_10_BG },
         { "15%", OPTION_VAL_15_BG },
         { "20%", OPTION_VAL_20_BG },
         { "25%", OPTION_VAL_25_BG },
         { "30%", OPTION_VAL_30_BG },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_BG,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_BG,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_BG,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_BG },
         { "60%",  OPTION_VAL_60_BG },
         { "70%",  OPTION_VAL_70_BG },
         { "80%",  OPTION_VAL_80_BG },
         { "90%",  OPTION_VAL_90_BG },
         { "100%", OPTION_VAL_100_O46_BG },
         { "110%", OPTION_VAL_110_O46_BG },
         { "120%", OPTION_VAL_120_O46_BG },
         { "130%", OPTION_VAL_130_O46_BG },
         { "140%", OPTION_VAL_140_O46_BG },
         { "150%", OPTION_VAL_150_O46_BG },
         { "160%", OPTION_VAL_160_O46_BG },
         { "170%", OPTION_VAL_170_O46_BG },
         { "180%", OPTION_VAL_180_O46_BG },
         { "190%", OPTION_VAL_190_O46_BG },
         { "200%", OPTION_VAL_200_O46_BG },
         { "210%", OPTION_VAL_210_O46_BG },
         { "220%", OPTION_VAL_220_O46_BG },
         { "230%", OPTION_VAL_230_O46_BG },
         { "240%", OPTION_VAL_240_O46_BG },
         { "250%", OPTION_VAL_250_O46_BG },
         { "260%", OPTION_VAL_260_O46_BG },
         { "270%", OPTION_VAL_270_O46_BG },
         { "280%", OPTION_VAL_280_O46_BG },
         { "290%", OPTION_VAL_290_O46_BG },
         { "300%", OPTION_VAL_300_O46_BG },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_BG,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BG },
         { "Red",      OPTION_VAL_RED_BG },
         { "Green",    OPTION_VAL_GREEN_BG },
         { "Blue",     OPTION_VAL_BLUE_BG },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_BG,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BG },
         { "Red",      OPTION_VAL_RED_BG },
         { "Green",    OPTION_VAL_GREEN_BG },
         { "Blue",     OPTION_VAL_BLUE_BG },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_BG,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BG },
         { "Red",      OPTION_VAL_RED_BG },
         { "Green",    OPTION_VAL_GREEN_BG },
         { "Blue",     OPTION_VAL_BLUE_BG },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_BG,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_BG },
         { "Red",      OPTION_VAL_RED_BG },
         { "Green",    OPTION_VAL_GREEN_BG },
         { "Blue",     OPTION_VAL_BLUE_BG },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_BG,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_BG,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_BG },
         { "Purupuru", OPTION_VAL_PURUPURU_BG },
         { "None",     OPTION_VAL_NONE_BG },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_BG,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_BG,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_BG,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_BG },
         { "All VMUs", OPTION_VAL_ALL_VMUS_BG },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_BG,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_BG,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_BG,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_BG,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_BG,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_BG,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BG },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BG },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BG },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BG },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BG },
         { "2x", OPTION_VAL_2_O27_BG },
         { "3x", OPTION_VAL_3X_BG },
         { "4x", OPTION_VAL_4_BG },
         { "5x", OPTION_VAL_5X_BG },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BG },
         { "20%",  OPTION_VAL_20_BG },
         { "30%",  OPTION_VAL_30_BG },
         { "40%",  OPTION_VAL_40_BG },
         { "50%",  OPTION_VAL_50_BG },
         { "60%",  OPTION_VAL_60_BG },
         { "70%",  OPTION_VAL_70_BG },
         { "80%",  OPTION_VAL_80_BG },
         { "90%",  OPTION_VAL_90_BG },
         { "100%", OPTION_VAL_100_O46_BG },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BG },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BG },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BG },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BG },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BG },
         { "2x", OPTION_VAL_2_O27_BG },
         { "3x", OPTION_VAL_3X_BG },
         { "4x", OPTION_VAL_4_BG },
         { "5x", OPTION_VAL_5X_BG },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BG },
         { "20%",  OPTION_VAL_20_BG },
         { "30%",  OPTION_VAL_30_BG },
         { "40%",  OPTION_VAL_40_BG },
         { "50%",  OPTION_VAL_50_BG },
         { "60%",  OPTION_VAL_60_BG },
         { "70%",  OPTION_VAL_70_BG },
         { "80%",  OPTION_VAL_80_BG },
         { "90%",  OPTION_VAL_90_BG },
         { "100%", OPTION_VAL_100_O46_BG },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BG },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BG },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BG },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BG },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BG },
         { "2x", OPTION_VAL_2_O27_BG },
         { "3x", OPTION_VAL_3X_BG },
         { "4x", OPTION_VAL_4_BG },
         { "5x", OPTION_VAL_5X_BG },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BG },
         { "20%",  OPTION_VAL_20_BG },
         { "30%",  OPTION_VAL_30_BG },
         { "40%",  OPTION_VAL_40_BG },
         { "50%",  OPTION_VAL_50_BG },
         { "60%",  OPTION_VAL_60_BG },
         { "70%",  OPTION_VAL_70_BG },
         { "80%",  OPTION_VAL_80_BG },
         { "90%",  OPTION_VAL_90_BG },
         { "100%", OPTION_VAL_100_O46_BG },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_BG },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_BG },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_BG },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_BG },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_BG },
         { "2x", OPTION_VAL_2_O27_BG },
         { "3x", OPTION_VAL_3X_BG },
         { "4x", OPTION_VAL_4_BG },
         { "5x", OPTION_VAL_5X_BG },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_BG },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_BG },
         { "BLACK 02",          OPTION_VAL_BLACK_02_BG },
         { "BLUE 03",           OPTION_VAL_BLUE_BG },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_BG },
         { "GREEN 05",          OPTION_VAL_GREEN_BG },
         { "CYAN 06",           OPTION_VAL_CYAN_06_BG },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_BG },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_BG },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_BG },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_BG },
         { "RED 11",            OPTION_VAL_RED_BG },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_BG },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_BG },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_BG },
         { "GRAY 15",           OPTION_VAL_GRAY_15_BG },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_BG },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_BG },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_BG },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_BG },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_BG },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_BG },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_BG },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_BG },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_BG },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_BG },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_BG },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_BG },
         { "WHITE 28",          OPTION_VAL_WHITE_BG },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_BG,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_BG },
         { "20%",  OPTION_VAL_20_BG },
         { "30%",  OPTION_VAL_30_BG },
         { "40%",  OPTION_VAL_40_BG },
         { "50%",  OPTION_VAL_50_BG },
         { "60%",  OPTION_VAL_60_BG },
         { "70%",  OPTION_VAL_70_BG },
         { "80%",  OPTION_VAL_80_BG },
         { "90%",  OPTION_VAL_90_BG },
         { "100%", OPTION_VAL_100_O46_BG },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_bg = {
   option_cats_bg,
   option_defs_bg
};

/* RETRO_LANGUAGE_CA */

#define CATEGORY_SYSTEM_LABEL_CA "Sistema"
#define CATEGORY_SYSTEM_INFO_0_CA "Canvia la configuració de regió, idioma, BIOS i del maquinari base."
#define CATEGORY_VIDEO_LABEL_CA "Vídeo"
#define CATEGORY_VIDEO_INFO_0_CA "Configura resolució, les transparències independents de l'ordre i els efectes visuals."
#define CATEGORY_PERFORMANCE_LABEL_CA "Rendiment"
#define CATEGORY_PERFORMANCE_INFO_0_CA "Configura el renderitzat multifil i l'omissió de fotogrames."
#define CATEGORY_HACKS_LABEL_CA "Correccions de l'emulació"
#define CATEGORY_HACKS_INFO_0_CA "Canvia la configuració de les correccions de pantalla panoràmica, la velocitat de càrrega de GD-ROM i la substitució de textures."
#define CATEGORY_INPUT_LABEL_CA "Entrada"
#define CATEGORY_INPUT_INFO_0_CA "Canvia la configuració dels controladors i les pistoles de llum."
#define CATEGORY_EXPANSIONS_LABEL_CA "Ports d'expansió dels controladors"
#define CATEGORY_EXPANSIONS_INFO_0_CA "Selecciona el dispositiu (VMU, dispositiu vibració) connectat a cada port d'expansió."
#define CATEGORY_VMU_LABEL_CA "Unitat de la memòria visual"
#define CATEGORY_VMU_INFO_0_CA "Configura fitxers per desar partides diferents per cada joc i la visibilitat en pantalla per cada joc."
#define CORE_OPTION_NAME_REGION_LABEL_CA "Regió"
#define OPTION_VAL_JAPAN_CA "Japó"
#define OPTION_VAL_USA_CA NULL
#define OPTION_VAL_EUROPE_CA "Europa"
#define OPTION_VAL_DEFAULT_CA "Per defecte"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_CA "Llengua"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_CA "Canvia la llengua que farà servir la BIOS i els jocs que contenen diferents idiomes."
#define OPTION_VAL_JAPANESE_CA "Japonès"
#define OPTION_VAL_ENGLISH_CA "Anglès"
#define OPTION_VAL_GERMAN_CA "Alemany"
#define OPTION_VAL_FRENCH_CA "Francès"
#define OPTION_VAL_SPANISH_CA "Español"
#define OPTION_VAL_ITALIAN_CA "Italià"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_CA "HLE BIOS (Es requereix reinici)"
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_CA "Obliga l'ús d'una BIOS amb emulació d'alt nivell."
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CA "Reinicia a la BIOS (Es requereix reinici)"
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CA "Inicia directament el menú de la BIOS de Dreamcast."
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_CA "Habilitar DSP"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CA "Habilita l'emulació del processador d'àudio DSP de Dreamcast. Millora la precisió del so generat, però augmenta els requisits de maquinari."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CA "Permet els botons de servei d'arcade"
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CA "Habilita el botó SERVICE per jocs arcade, per accedir a la configuració de la màquina."
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CA "Estableix els jocs de NAOMI com a gratuïts"
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CA "Modifica la configuració de monedes del joc a partides gratuïtes."
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_CA "Emulació de l'adaptador Broadband"
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CA "Emula l'adaptador de banda ampla per cable Ethernet en compte del mòdem (Es requereix reinici)."
#define CORE_OPTION_NAME_UPNP_LABEL_CA "Habilitat UPnP"
#define CORE_OPTION_NAME_UPNP_INFO_0_CA "Fes servir UPnP per configurar automàticament el router per jocs en línia."
#define CORE_OPTION_NAME_DCNET_LABEL_CA "Utilitzar DCNet (Experimental)"
#define CORE_OPTION_NAME_DCNET_INFO_0_CA "Connectar al servei al núvol experimental DCNet."
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CA "Resolució Interna"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CA "Modifica la resolució interna."
#define OPTION_VAL_320X240_CA "320 × 240 (50 %)"
#define OPTION_VAL_640X480_CA "640x480b (Natiu)"
#define OPTION_VAL_800X600_CA "800x600 (x1,25)"
#define OPTION_VAL_960X720_CA "960 × 720 (150 %)"
#define OPTION_VAL_1024X768_CA "1024x768 (x1,6)"
#define OPTION_VAL_1280X960_CA NULL
#define OPTION_VAL_1440X1080_CA "1440x1080 (x2,25)"
#define OPTION_VAL_1600X1200_CA "1600x1200 (x2,5)"
#define OPTION_VAL_1920X1440_CA "1920 × 1440 (300 %)"
#define OPTION_VAL_2560X1920_CA "2560 × 1920 (400 %)"
#define OPTION_VAL_2880X2160_CA "2880x2160 (x4,5)"
#define OPTION_VAL_3200X2400_CA "3200 × 2400 (500 %)"
#define OPTION_VAL_3840X2880_CA "3840 × 2880 (600 %)"
#define OPTION_VAL_4480X3360_CA NULL
#define OPTION_VAL_5120X3840_CA NULL
#define OPTION_VAL_5760X4320_CA NULL
#define OPTION_VAL_6400X4800_CA NULL
#define OPTION_VAL_7040X5280_CA NULL
#define OPTION_VAL_7680X5760_CA NULL
#define OPTION_VAL_8320X6240_CA NULL
#define OPTION_VAL_8960X6720_CA NULL
#define OPTION_VAL_9600X7200_CA NULL
#define OPTION_VAL_10240X7680_CA NULL
#define OPTION_VAL_10880X8160_CA NULL
#define OPTION_VAL_11520X8640_CA NULL
#define OPTION_VAL_12160X9120_CA NULL
#define OPTION_VAL_12800X9600_CA NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_CA "Tipus de cable"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CA "Tipus del senyal de sortida. 'TV (Composició)' és el tipus de senyal més suportat."
#define OPTION_VAL_VGA_CA NULL
#define OPTION_VAL_TV_RGB_CA NULL
#define OPTION_VAL_TV_COMPOSITE_CA "TV (Composició)"
#define CORE_OPTION_NAME_BROADCAST_LABEL_CA "Estàndard de transmissió"
#define OPTION_VAL_NTSC_CA NULL
#define OPTION_VAL_PAL_CA "Pal (Mundial)"
#define OPTION_VAL_PAL_N_CA NULL
#define OPTION_VAL_PAL_M_CA "PAL-M (Brasil)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CA "Orientació de la pantalla"
#define OPTION_VAL_HORIZONTAL_CA "Horitzontal"
#define OPTION_VAL_VERTICAL_CA NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CA "Ordenar per transparències"
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CA "Selecciona l'ordre de dibuix dels polígons transparents."
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CA "Per bandes (ràpid però menys acurat)"
#define OPTION_VAL_PER_TRIANGLE_NORMAL_CA NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_CA "Per píxel (acurat però lent)"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CA "Mida de la memòria intermèdia dels píxels d'acumulació"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CA "És possible que sigui necessari un valor alt perquè la imatge es mostri correctament amb resolucions superiors a la nativa."
#define OPTION_VAL_512MB_CA "512 MB"
#define OPTION_VAL_1GB_CA "1 GB"
#define OPTION_VAL_2GB_CA "2 GB"
#define OPTION_VAL_4GB_CA "4 GB"
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_CA "Nombre màxim de capes transparents"
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CA "Les escenes més complexes poden necessitar un valor més alt."
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CA "Emulació completa de la memòria intermèdia"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CA "Activa l'emulació completa de la memòria intermèdia de fotogrames a la VRAM. Ideal per aquells jocs que llegeixen o escriuen directament a la memòria intermèdia de la VRAM. Si s'activa aquesta opció, s'ajustarà la resolució interna a 640 x 480 i el rendiment es pot veure afectat."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CA "Habilita la memòria intermèdia RTT (Renderitzat a textures)"
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CA "Copia les textures renderitzades a la targeta gràfica a la memòria VRAM. Aquesta opció cal deixar-la activada per aquells jocs que ho necessitin. En activar aquesta opció, es desactiva l'escalat de textures i el rendiment es pot veure afectat."
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_CA NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_CA "En activar aquesta opció, les textures mostraran una versió més reduïda de mida si es troben més allunyades de la pantalla. Pot millorar el rendiment i reduir els efectes de distorsió."
#define CORE_OPTION_NAME_FOG_LABEL_CA "Efectes de boira"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CA "Modificador de volum"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CA "Una característica de la targeta gràfica de Dreamcast que solen fer servir alguns jocs per dibuixar les ombres dels objectes. Aquesta opció cal activar-se en general, no afecta el rendiment."
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CA "Filtre anisotròpic"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CA "Millora la qualitat de les textures si es troben en un angle oblic respecte a la càmera. Un valor alt necessitarà més recursos de la targeta gràfica. Cal reiniciar perquè els canvis tinguin efecte."
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CA "Filtratge de textures"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CA "Indica el mode de filtratge de textures que es farà servir. Es pot forçar un mode de filtratge concret en totes les textures amb l'objectiu d'aconseguir un aspecte per definit. Qualsevol valor que no sigui el valor per defecte pot provocar errors de renderitzat. Cal reiniciar per aplicar els canvis."
#define OPTION_VAL_1_CA "Força píxel més proper"
#define OPTION_VAL_2_CA "Forçar lineal"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CA "Retardar el canvi de fotogrames"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CA "Útil per evitar parpelleig constant errors gràfics en els vídeos. No es recomana activar-ho en plataformes amb pocs recursos."
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CA "Detecta els canvis en la taxa de fotogrames"
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CA "Informa al front-end si canvia la freqüència d'actualització interna. Millora la cadència de fotogrames en aquells jocs que s'executin a 30 o 20 fotogrames per segon fixes, però aquesta opció cal desactivar-se en aquells jocs que tinguin freqüències de fotogrames desbloquejades. NOTA: Aquesta opció no està disponible si s'activa Omissió automàtica de fotogrames."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CA "Filtre de postprocessat PowerVR2"
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CA "Postprocessa la imatge renderitzada per emular els efectes dedicats de la GPU PowerVR2 i els senyals de vídeo analògic."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_CA "Augment de mida de les textures (xBRZ)"
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CA "Millora els gràfics de tipus píxel art dibuixats a mà. Activa-ho només per jocs 2D pixelats."
#define OPTION_VAL_2_O27_CA NULL
#define OPTION_VAL_4_CA NULL
#define OPTION_VAL_6_CA NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CA "Mida màxima de l'escalat de textures"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CA "Selecciona un valor màxim per a l'escalat de textures. Si la mida de la textura és superior al valor seleccionat, no s'escalarà."
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CA "Interpolació nativa de profunditat"
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CA "Esmorteeix la corrupció de textures i els problemes gràfics de profunditat en fer servir una GPU de AMB. En alguns casos també pot ajudar en una GPU de Intel."
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CA "Corregeix els defectes de les vores en escalar"
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CA "Dona suport si les textures mostren vores sagnants en escalar-les. Desactivar aquesta opció pot ser útil si hi ha distorsió de píxels en escalar jocs 2D (MVC2, CVS, KOF, etç...)"
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CA "Renderitzat multifil"
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CA "Executa la GPU i la CPU en diferents fils. Molt recomanat."
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CA "Omissió automàtica de fotogrames"
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CA "Omet fotogrames automàticament si l'emulador funciona amb lentitud. Nota: Aquesta opció només funciona si l'opció 'Renderitzat multifil' està activada."
#define OPTION_VAL_SOME_CA NULL
#define OPTION_VAL_MORE_CA "Màxim"
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CA "Omissió de fotogrames"
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CA "Selecciona el nombre de fotogrames a ometre per cada fotograma en pantalla que es mostra."
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CA "Correccions per pantalles panoràmiques (Es requereix reinici)"
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CA "Activa els trucs que permet a certs jocs mostrar-se correctament en pantalles panoràmiques."
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CA "Correcció de pantalles panoràmiques"
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CA "Dibuixa geometries més enllà de la relació d'aspecte 4:3. Pot produir errors gràfics en les zones visibles."
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CA "Lectura ràpida de GD-ROM (poc acurat)"
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CA "Augmenta la velocitat de càrrega de GD-ROM."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CA NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CA "Activa la modificació de 32 MB de RAM per Dreamcast. Pot afectar la compatibilitat"
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_CA NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_CA "Canvia la velocitat del rellotge del processador principal SH4 dels 200 MHz per defecte. Baixar la velocitat pot ajudar a les plataformes més lentes. Augmentar la velocitat pot augmentar la velocitat en alguns jocs. Cal utilitzar amb precaució."
#define OPTION_VAL_100_CA NULL
#define OPTION_VAL_110_CA NULL
#define OPTION_VAL_120_CA NULL
#define OPTION_VAL_130_CA NULL
#define OPTION_VAL_140_CA NULL
#define OPTION_VAL_150_CA NULL
#define OPTION_VAL_160_CA NULL
#define OPTION_VAL_170_CA NULL
#define OPTION_VAL_180_CA NULL
#define OPTION_VAL_190_CA NULL
#define OPTION_VAL_200_CA NULL
#define OPTION_VAL_210_CA NULL
#define OPTION_VAL_220_CA NULL
#define OPTION_VAL_230_CA NULL
#define OPTION_VAL_240_CA NULL
#define OPTION_VAL_250_CA NULL
#define OPTION_VAL_260_CA NULL
#define OPTION_VAL_270_CA NULL
#define OPTION_VAL_280_CA NULL
#define OPTION_VAL_290_CA NULL
#define OPTION_VAL_300_CA NULL
#define OPTION_VAL_310_CA NULL
#define OPTION_VAL_320_CA NULL
#define OPTION_VAL_330_CA NULL
#define OPTION_VAL_340_CA NULL
#define OPTION_VAL_350_CA NULL
#define OPTION_VAL_360_CA NULL
#define OPTION_VAL_370_CA NULL
#define OPTION_VAL_380_CA NULL
#define OPTION_VAL_390_CA NULL
#define OPTION_VAL_400_CA NULL
#define OPTION_VAL_410_CA NULL
#define OPTION_VAL_420_CA NULL
#define OPTION_VAL_430_CA NULL
#define OPTION_VAL_440_CA NULL
#define OPTION_VAL_450_CA NULL
#define OPTION_VAL_460_CA NULL
#define OPTION_VAL_470_CA NULL
#define OPTION_VAL_480_CA NULL
#define OPTION_VAL_490_CA NULL
#define OPTION_VAL_500_CA NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CA "Carregar textures personalitzades"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CA "Carrega textures personalitzades que es trobin a la carpeta 'system/dc/textures/<game-id>/'."
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CA "Abocar textures"
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CA "Cada vegada que un joc faci servir una nova textura, aquesta es desarà en un fitxer .png a la carpeta 'system/dc/texdump/<game-id>/'."
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CA "Zona morta palanca analògica"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CA "Selecciona la distància a la qual es reconeix la pulsació del gatell."
#define OPTION_VAL_0_CA NULL
#define OPTION_VAL_5_CA NULL
#define OPTION_VAL_10_CA NULL
#define OPTION_VAL_15_CA NULL
#define OPTION_VAL_20_CA NULL
#define OPTION_VAL_25_CA NULL
#define OPTION_VAL_30_CA NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CA "Zona morta dels gatells"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CA "Selecciona la distància a la qual es reconeix la pulsació del gatell."
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CA "Gatells digitals"
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CA "En activar aquesta opció, els gatells funcionaran com botons normals, el que significa que el senyal serà polsat o no polsat, sense valor intermedi."
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CA "Transmet les sortides digitals"
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CA "Transmet els senyals digitals i l'estat de vibració del port TCP 8000. És compatible amb l'opció de MAME '-output network'."
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CA "Mostra la configuració de la pistola de llum"
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CA "Permet configurar les diferents mires de les pistoles de llum. NOTA: És imprescindible sortir i tornar a entrar al menú ràpid perquè el canvi funcioni."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CA "Escala del punt de mira de la pistola"
#define OPTION_VAL_50_CA NULL
#define OPTION_VAL_60_CA NULL
#define OPTION_VAL_70_CA NULL
#define OPTION_VAL_80_CA NULL
#define OPTION_VAL_90_CA NULL
#define OPTION_VAL_100_O46_CA NULL
#define OPTION_VAL_110_O46_CA NULL
#define OPTION_VAL_120_O46_CA NULL
#define OPTION_VAL_130_O46_CA NULL
#define OPTION_VAL_140_O46_CA NULL
#define OPTION_VAL_150_O46_CA NULL
#define OPTION_VAL_160_O46_CA NULL
#define OPTION_VAL_170_O46_CA NULL
#define OPTION_VAL_180_O46_CA NULL
#define OPTION_VAL_190_O46_CA NULL
#define OPTION_VAL_200_O46_CA NULL
#define OPTION_VAL_210_O46_CA NULL
#define OPTION_VAL_220_O46_CA NULL
#define OPTION_VAL_230_O46_CA NULL
#define OPTION_VAL_240_O46_CA NULL
#define OPTION_VAL_250_O46_CA NULL
#define OPTION_VAL_260_O46_CA NULL
#define OPTION_VAL_270_O46_CA NULL
#define OPTION_VAL_280_O46_CA NULL
#define OPTION_VAL_290_O46_CA NULL
#define OPTION_VAL_300_O46_CA NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CA "Mostra el punt de mira de la pistola 1"
#define OPTION_VAL_WHITE_CA "Blanc"
#define OPTION_VAL_RED_CA "Vermell"
#define OPTION_VAL_GREEN_CA "Verd"
#define OPTION_VAL_BLUE_CA "Blau"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CA "Mostra el punt de mira de la pistola 2"
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CA "Mostra el punt de mira de la pistola 3"
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CA "Mostra el punt de mira de la pistola 4"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CA "Dispositu en el port d'expansió A1"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió A1 (port A ranura 1)."
#define OPTION_VAL_VMU_CA NULL
#define OPTION_VAL_PURUPURU_CA "Pack de vibració"
#define OPTION_VAL_NONE_CA "Cap"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CA "Dispositiu en el port d'expansió A2"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió A2 (port A ranura 2)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CA "Dispositiu en el port d'expansió B1"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió B1 (port B ranura 1)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CA "Dispostiu en el port d'expanció B2"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió B2 (port B ranura 2)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CA "Dispositiu en el port d'expansió C1"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió C1 (port C ranura 1)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CA "Dispositiu en el port d'expansió C2"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió C2 (port C ranura 2)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CA "Dispositiu en el port d'expansió D1"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió D1 (port D ranura 1)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CA "Dispositiu en el port d'expanció D2"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CA "Selecciona el dispositiu connectat a la ranura d'expansió D2 (port D ranura 2)."
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CA "Separar Visual Memory (VMU) per cada joc"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CA "VMUs individuals per cada joc"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CA "En desactivar aquesta opció, tots els jocs compartiran els 8 fitxers de desats de VMU (A1/A2/B1/B2/C1/C2/D1/D2) que es troben a la carpeta del sistema de RetroArch. L'opció \"VMU A1\" crearà un únic fitxer de la VMU A1 a la carpeta de desats de RetroArch per cada joc que s'executi. L'opció \"Totes les VMU\" crearà 8 fitxers VMU únics per cada joc que s'executi."
#define OPTION_VAL_VMU_A1_CA NULL
#define OPTION_VAL_ALL_VMUS_CA "Totes les VMUs"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CA "Sons de les Visual Memory (VMU)"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CA "Sons VMU"
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_CA "Quan està actiu, es reprodueixen els sons de la VMU."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CA "Mostra la configuració de visualització de les Visual Memory (VMU)"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CA "Mostra la configuració de pantalla de VMU"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CA "Permet configurar la visibilitat, mida i posició de les pantalles LCD emulades. NOTA: cal sortir i tornar a entrar al menú ràpid perquè el canvi funcioni."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CA "Pantalla de la VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CA "Posició de la pantalla de la VMU 1"
#define OPTION_VAL_UPPER_LEFT_CA "Superior esquerra"
#define OPTION_VAL_UPPER_RIGHT_CA "Superior dret"
#define OPTION_VAL_LOWER_LEFT_CA "Inferiro esquerra"
#define OPTION_VAL_LOWER_RIGHT_CA "Inferior dret"
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CA "Mida de la pantalla de la VMU 1"
#define OPTION_VAL_1X_CA NULL
#define OPTION_VAL_3X_CA NULL
#define OPTION_VAL_5X_CA NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CA "Color dels píxels actius de la VMU 1"
#define OPTION_VAL_DEFAULT_ON_00_CA "Activat per defecte"
#define OPTION_VAL_DEFAULT_OFF_01_CA "Desactivat per defecte"
#define OPTION_VAL_BLACK_02_CA "Negre"
#define OPTION_VAL_LIGHT_BLUE_04_CA "Blau clar"
#define OPTION_VAL_CYAN_06_CA "Cian"
#define OPTION_VAL_CYAN_BLUE_07_CA "Blau cian"
#define OPTION_VAL_LIGHT_GREEN_08_CA "Verd lluminós"
#define OPTION_VAL_CYAN_GREEN_09_CA "Verd cian"
#define OPTION_VAL_LIGHT_CYAN_10_CA "Cian clar"
#define OPTION_VAL_PURPLE_12_CA "Lila"
#define OPTION_VAL_LIGHT_PURPLE_13_CA "Lila clar"
#define OPTION_VAL_YELLOW_14_CA "Groc"
#define OPTION_VAL_GRAY_15_CA "Gris"
#define OPTION_VAL_LIGHT_PURPLE_2_16_CA "Violeta clar (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_CA "Verd clar (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_CA "Verd clar (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_CA "Cian clar (2)"
#define OPTION_VAL_LIGHT_RED_2_20_CA "Vermell clar (2)"
#define OPTION_VAL_MAGENTA_21_CA NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_CA "Violeta clar (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_CA "Taronja clar"
#define OPTION_VAL_ORANGE_24_CA "Taronja"
#define OPTION_VAL_LIGHT_PURPLE_4_25_CA "Violeta clar (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_CA "Groc clar"
#define OPTION_VAL_LIGHT_YELLOW_2_27_CA "Groc clar (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CA "Color dels píxels inactius de la VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CA "Opacitat de la pantalla de la VMU 1"
#define OPTION_VAL_40_CA NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CA "Pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CA "Posició de la pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CA "Mida de la pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CA "Color dels píxels actius de la VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CA "Color dels píxels inactius de la VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CA "Opacitat de la pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CA "Pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CA "Posició de la pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CA "Mida de la pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CA "Color dels píxels actius de la VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CA "Color dels píxels inactius de la VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CA "Opacitat de la pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CA "Pantalla de la VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CA "Posició de la pantalla de la VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CA "Mida de la pantalla de la VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CA "Color dels píxels actius de la VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CA "Color dels píxels inactius de la VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CA "Opacitat de la pantalla de la VMU 4"

struct retro_core_option_v2_category option_cats_ca[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CA,
      CATEGORY_SYSTEM_INFO_0_CA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CA,
      CATEGORY_VIDEO_INFO_0_CA
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_CA,
      CATEGORY_PERFORMANCE_INFO_0_CA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CA,
      CATEGORY_HACKS_INFO_0_CA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CA,
      CATEGORY_INPUT_INFO_0_CA
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_CA,
      CATEGORY_EXPANSIONS_INFO_0_CA
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_CA,
      CATEGORY_VMU_INFO_0_CA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_ca[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_CA,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_CA },
         { "USA",     OPTION_VAL_USA_CA },
         { "Europe",  OPTION_VAL_EUROPE_CA },
         { "Default", OPTION_VAL_DEFAULT_CA },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_CA,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_CA },
         { "English",  OPTION_VAL_ENGLISH_CA },
         { "German",   OPTION_VAL_GERMAN_CA },
         { "French",   OPTION_VAL_FRENCH_CA },
         { "Spanish",  OPTION_VAL_SPANISH_CA },
         { "Italian",  OPTION_VAL_ITALIAN_CA },
         { "Default",  OPTION_VAL_DEFAULT_CA },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_CA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CA,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_CA },
         { "640x480",    OPTION_VAL_640X480_CA },
         { "800x600",    OPTION_VAL_800X600_CA },
         { "960x720",    OPTION_VAL_960X720_CA },
         { "1024x768",   OPTION_VAL_1024X768_CA },
         { "1280x960",   OPTION_VAL_1280X960_CA },
         { "1440x1080",  OPTION_VAL_1440X1080_CA },
         { "1600x1200",  OPTION_VAL_1600X1200_CA },
         { "1920x1440",  OPTION_VAL_1920X1440_CA },
         { "2560x1920",  OPTION_VAL_2560X1920_CA },
         { "2880x2160",  OPTION_VAL_2880X2160_CA },
         { "3200x2400",  OPTION_VAL_3200X2400_CA },
         { "3840x2880",  OPTION_VAL_3840X2880_CA },
         { "4480x3360",  OPTION_VAL_4480X3360_CA },
         { "5120x3840",  OPTION_VAL_5120X3840_CA },
         { "5760x4320",  OPTION_VAL_5760X4320_CA },
         { "6400x4800",  OPTION_VAL_6400X4800_CA },
         { "7040x5280",  OPTION_VAL_7040X5280_CA },
         { "7680x5760",  OPTION_VAL_7680X5760_CA },
         { "8320x6240",  OPTION_VAL_8320X6240_CA },
         { "8960x6720",  OPTION_VAL_8960X6720_CA },
         { "9600x7200",  OPTION_VAL_9600X7200_CA },
         { "10240x7680", OPTION_VAL_10240X7680_CA },
         { "10880x8160", OPTION_VAL_10880X8160_CA },
         { "11520x8640", OPTION_VAL_11520X8640_CA },
         { "12160x9120", OPTION_VAL_12160X9120_CA },
         { "12800x9600", OPTION_VAL_12800X9600_CA },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CA,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_CA },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_CA },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_CA },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_CA,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_CA },
         { "PAL",     OPTION_VAL_PAL_CA },
         { "PAL_N",   OPTION_VAL_PAL_N_CA },
         { "PAL_M",   OPTION_VAL_PAL_M_CA },
         { "Default", OPTION_VAL_DEFAULT_CA },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CA,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_CA },
         { "vertical",   OPTION_VAL_VERTICAL_CA },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CA,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CA },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_CA },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_CA },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CA,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_CA },
         { "1GB",   OPTION_VAL_1GB_CA },
         { "2GB",   OPTION_VAL_2GB_CA },
         { "4GB",   OPTION_VAL_4GB_CA },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CA,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_CA,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CA,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_CA },
         { "1",  OPTION_VAL_1_CA },
         { "2",  OPTION_VAL_2_CA },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CA,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_CA },
         { "4",  OPTION_VAL_4_CA },
         { "6",  OPTION_VAL_6_CA },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CA,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CA,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CA,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CA,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CA,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CA,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CA,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_CA },
         { "more", OPTION_VAL_MORE_CA },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CA,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CA },
         { "110", OPTION_VAL_110_CA },
         { "120", OPTION_VAL_120_CA },
         { "130", OPTION_VAL_130_CA },
         { "140", OPTION_VAL_140_CA },
         { "150", OPTION_VAL_150_CA },
         { "160", OPTION_VAL_160_CA },
         { "170", OPTION_VAL_170_CA },
         { "180", OPTION_VAL_180_CA },
         { "190", OPTION_VAL_190_CA },
         { "200", OPTION_VAL_200_CA },
         { "210", OPTION_VAL_210_CA },
         { "220", OPTION_VAL_220_CA },
         { "230", OPTION_VAL_230_CA },
         { "240", OPTION_VAL_240_CA },
         { "250", OPTION_VAL_250_CA },
         { "260", OPTION_VAL_260_CA },
         { "270", OPTION_VAL_270_CA },
         { "280", OPTION_VAL_280_CA },
         { "290", OPTION_VAL_290_CA },
         { "300", OPTION_VAL_300_CA },
         { "310", OPTION_VAL_310_CA },
         { "320", OPTION_VAL_320_CA },
         { "330", OPTION_VAL_330_CA },
         { "340", OPTION_VAL_340_CA },
         { "350", OPTION_VAL_350_CA },
         { "360", OPTION_VAL_360_CA },
         { "370", OPTION_VAL_370_CA },
         { "380", OPTION_VAL_380_CA },
         { "390", OPTION_VAL_390_CA },
         { "400", OPTION_VAL_400_CA },
         { "410", OPTION_VAL_410_CA },
         { "420", OPTION_VAL_420_CA },
         { "430", OPTION_VAL_430_CA },
         { "440", OPTION_VAL_440_CA },
         { "450", OPTION_VAL_450_CA },
         { "460", OPTION_VAL_460_CA },
         { "470", OPTION_VAL_470_CA },
         { "480", OPTION_VAL_480_CA },
         { "490", OPTION_VAL_490_CA },
         { "500", OPTION_VAL_500_CA },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CA },
         { "5%",  OPTION_VAL_5_CA },
         { "10%", OPTION_VAL_10_CA },
         { "15%", OPTION_VAL_15_CA },
         { "20%", OPTION_VAL_20_CA },
         { "25%", OPTION_VAL_25_CA },
         { "30%", OPTION_VAL_30_CA },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CA },
         { "5%",  OPTION_VAL_5_CA },
         { "10%", OPTION_VAL_10_CA },
         { "15%", OPTION_VAL_15_CA },
         { "20%", OPTION_VAL_20_CA },
         { "25%", OPTION_VAL_25_CA },
         { "30%", OPTION_VAL_30_CA },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CA,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_CA },
         { "60%",  OPTION_VAL_60_CA },
         { "70%",  OPTION_VAL_70_CA },
         { "80%",  OPTION_VAL_80_CA },
         { "90%",  OPTION_VAL_90_CA },
         { "100%", OPTION_VAL_100_O46_CA },
         { "110%", OPTION_VAL_110_O46_CA },
         { "120%", OPTION_VAL_120_O46_CA },
         { "130%", OPTION_VAL_130_O46_CA },
         { "140%", OPTION_VAL_140_O46_CA },
         { "150%", OPTION_VAL_150_O46_CA },
         { "160%", OPTION_VAL_160_O46_CA },
         { "170%", OPTION_VAL_170_O46_CA },
         { "180%", OPTION_VAL_180_O46_CA },
         { "190%", OPTION_VAL_190_O46_CA },
         { "200%", OPTION_VAL_200_O46_CA },
         { "210%", OPTION_VAL_210_O46_CA },
         { "220%", OPTION_VAL_220_O46_CA },
         { "230%", OPTION_VAL_230_O46_CA },
         { "240%", OPTION_VAL_240_O46_CA },
         { "250%", OPTION_VAL_250_O46_CA },
         { "260%", OPTION_VAL_260_O46_CA },
         { "270%", OPTION_VAL_270_O46_CA },
         { "280%", OPTION_VAL_280_O46_CA },
         { "290%", OPTION_VAL_290_O46_CA },
         { "300%", OPTION_VAL_300_O46_CA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CA },
         { "Red",      OPTION_VAL_RED_CA },
         { "Green",    OPTION_VAL_GREEN_CA },
         { "Blue",     OPTION_VAL_BLUE_CA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CA },
         { "Red",      OPTION_VAL_RED_CA },
         { "Green",    OPTION_VAL_GREEN_CA },
         { "Blue",     OPTION_VAL_BLUE_CA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CA },
         { "Red",      OPTION_VAL_RED_CA },
         { "Green",    OPTION_VAL_GREEN_CA },
         { "Blue",     OPTION_VAL_BLUE_CA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CA },
         { "Red",      OPTION_VAL_RED_CA },
         { "Green",    OPTION_VAL_GREEN_CA },
         { "Blue",     OPTION_VAL_BLUE_CA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CA },
         { "Purupuru", OPTION_VAL_PURUPURU_CA },
         { "None",     OPTION_VAL_NONE_CA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CA,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CA,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CA,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_CA },
         { "All VMUs", OPTION_VAL_ALL_VMUS_CA },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CA,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CA,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_CA,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CA,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CA,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CA,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CA },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CA },
         { "2x", OPTION_VAL_2_O27_CA },
         { "3x", OPTION_VAL_3X_CA },
         { "4x", OPTION_VAL_4_CA },
         { "5x", OPTION_VAL_5X_CA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CA },
         { "20%",  OPTION_VAL_20_CA },
         { "30%",  OPTION_VAL_30_CA },
         { "40%",  OPTION_VAL_40_CA },
         { "50%",  OPTION_VAL_50_CA },
         { "60%",  OPTION_VAL_60_CA },
         { "70%",  OPTION_VAL_70_CA },
         { "80%",  OPTION_VAL_80_CA },
         { "90%",  OPTION_VAL_90_CA },
         { "100%", OPTION_VAL_100_O46_CA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CA },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CA },
         { "2x", OPTION_VAL_2_O27_CA },
         { "3x", OPTION_VAL_3X_CA },
         { "4x", OPTION_VAL_4_CA },
         { "5x", OPTION_VAL_5X_CA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CA },
         { "20%",  OPTION_VAL_20_CA },
         { "30%",  OPTION_VAL_30_CA },
         { "40%",  OPTION_VAL_40_CA },
         { "50%",  OPTION_VAL_50_CA },
         { "60%",  OPTION_VAL_60_CA },
         { "70%",  OPTION_VAL_70_CA },
         { "80%",  OPTION_VAL_80_CA },
         { "90%",  OPTION_VAL_90_CA },
         { "100%", OPTION_VAL_100_O46_CA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CA },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CA },
         { "2x", OPTION_VAL_2_O27_CA },
         { "3x", OPTION_VAL_3X_CA },
         { "4x", OPTION_VAL_4_CA },
         { "5x", OPTION_VAL_5X_CA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CA },
         { "20%",  OPTION_VAL_20_CA },
         { "30%",  OPTION_VAL_30_CA },
         { "40%",  OPTION_VAL_40_CA },
         { "50%",  OPTION_VAL_50_CA },
         { "60%",  OPTION_VAL_60_CA },
         { "70%",  OPTION_VAL_70_CA },
         { "80%",  OPTION_VAL_80_CA },
         { "90%",  OPTION_VAL_90_CA },
         { "100%", OPTION_VAL_100_O46_CA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CA },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CA },
         { "2x", OPTION_VAL_2_O27_CA },
         { "3x", OPTION_VAL_3X_CA },
         { "4x", OPTION_VAL_4_CA },
         { "5x", OPTION_VAL_5X_CA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CA },
         { "BLUE 03",           OPTION_VAL_BLUE_CA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CA },
         { "GREEN 05",          OPTION_VAL_GREEN_CA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CA },
         { "RED 11",            OPTION_VAL_RED_CA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CA },
         { "WHITE 28",          OPTION_VAL_WHITE_CA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CA },
         { "20%",  OPTION_VAL_20_CA },
         { "30%",  OPTION_VAL_30_CA },
         { "40%",  OPTION_VAL_40_CA },
         { "50%",  OPTION_VAL_50_CA },
         { "60%",  OPTION_VAL_60_CA },
         { "70%",  OPTION_VAL_70_CA },
         { "80%",  OPTION_VAL_80_CA },
         { "90%",  OPTION_VAL_90_CA },
         { "100%", OPTION_VAL_100_O46_CA },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_ca = {
   option_cats_ca,
   option_defs_ca
};

/* RETRO_LANGUAGE_CHS */

#define CATEGORY_SYSTEM_LABEL_CHS "系统"
#define CATEGORY_SYSTEM_INFO_0_CHS "配置区域, 语言, BIOS和基础硬件设置."
#define CATEGORY_VIDEO_LABEL_CHS "视频"
#define CATEGORY_VIDEO_INFO_0_CHS "配置分辨率, 与顺序无关的透明度和视觉效果."
#define CATEGORY_PERFORMANCE_LABEL_CHS "性能"
#define CATEGORY_PERFORMANCE_INFO_0_CHS "配置线程渲染和跳帧设置."
#define CATEGORY_HACKS_LABEL_CHS "模拟修改"
#define CATEGORY_HACKS_INFO_0_CHS "配置宽屏覆盖, GD-ROM 加载速度和纹理替换设置."
#define CATEGORY_INPUT_LABEL_CHS "输入"
#define CATEGORY_INPUT_INFO_0_CHS "配置游戏手柄和光枪."
#define CATEGORY_EXPANSIONS_LABEL_CHS "控制器扩展槽"
#define CATEGORY_EXPANSIONS_INFO_0_CHS "选择插入每个控制器扩展槽的设备 (VMU, 震动设备)."
#define CATEGORY_VMU_LABEL_CHS "VMU 记忆卡掌机"
#define CATEGORY_VMU_INFO_0_CHS "配置每个游戏的 VMU 保存文件和屏幕上 VMU 的可见性."
#define CORE_OPTION_NAME_REGION_LABEL_CHS "区域"
#define OPTION_VAL_JAPAN_CHS "日本"
#define OPTION_VAL_USA_CHS "美国"
#define OPTION_VAL_EUROPE_CHS "欧洲"
#define OPTION_VAL_DEFAULT_CHS "默认值"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_CHS "语言"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_CHS "改变 BIOS 和任何包含多语言游戏所使用的语言."
#define OPTION_VAL_JAPANESE_CHS "日语"
#define OPTION_VAL_ENGLISH_CHS "英语"
#define OPTION_VAL_GERMAN_CHS "德语"
#define OPTION_VAL_FRENCH_CHS "法语"
#define OPTION_VAL_SPANISH_CHS "西班牙语"
#define OPTION_VAL_ITALIAN_CHS "意大利语"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_CHS "HLE BIOS (需要重启)"
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_CHS "强制使用高级模拟 BIOS."
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CHS "启动 BIOS (需要重启)"
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CHS "启动进入 Dreamcast BIOS 菜单."
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_CHS "启用 DSP"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CHS "启用模拟器 Dreamcast 音频 DSP (数字信号处理器). 提高生成声音的精确性, 但相应增加了性能需求."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CHS "允许街机服务按钮"
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CHS "启用街机游戏服务按钮, 进入机柜设置."
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CHS "NAOMI 游戏设置为免费游戏"
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CHS "修改游戏的硬币设置为免费游戏."
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_CHS "模拟宽带适配器"
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CHS "模拟以太网宽带适配器而不是调制解调器. (需要重启)"
#define CORE_OPTION_NAME_UPNP_LABEL_CHS "启用 UPnP"
#define CORE_OPTION_NAME_UPNP_INFO_0_CHS "使用 UPnP 自动配置您的网络路由器进行在线游戏."
#define CORE_OPTION_NAME_DCNET_LABEL_CHS "使用 DCNet (实验性)"
#define CORE_OPTION_NAME_DCNET_INFO_0_CHS "连接到实验性的 DCNet 云服务."
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CHS "内部分辨率"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CHS "修改渲染分辨率."
#define OPTION_VAL_320X240_CHS "320x240 (1/2)"
#define OPTION_VAL_640X480_CHS "640x480 (原生)"
#define OPTION_VAL_800X600_CHS NULL
#define OPTION_VAL_960X720_CHS NULL
#define OPTION_VAL_1024X768_CHS NULL
#define OPTION_VAL_1280X960_CHS NULL
#define OPTION_VAL_1440X1080_CHS NULL
#define OPTION_VAL_1600X1200_CHS NULL
#define OPTION_VAL_1920X1440_CHS NULL
#define OPTION_VAL_2560X1920_CHS NULL
#define OPTION_VAL_2880X2160_CHS NULL
#define OPTION_VAL_3200X2400_CHS NULL
#define OPTION_VAL_3840X2880_CHS NULL
#define OPTION_VAL_4480X3360_CHS NULL
#define OPTION_VAL_5120X3840_CHS NULL
#define OPTION_VAL_5760X4320_CHS NULL
#define OPTION_VAL_6400X4800_CHS NULL
#define OPTION_VAL_7040X5280_CHS NULL
#define OPTION_VAL_7680X5760_CHS NULL
#define OPTION_VAL_8320X6240_CHS NULL
#define OPTION_VAL_8960X6720_CHS NULL
#define OPTION_VAL_9600X7200_CHS NULL
#define OPTION_VAL_10240X7680_CHS NULL
#define OPTION_VAL_10880X8160_CHS NULL
#define OPTION_VAL_11520X8640_CHS NULL
#define OPTION_VAL_12160X9120_CHS NULL
#define OPTION_VAL_12800X9600_CHS NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_CHS "线缆类型"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CHS "输出信号类型. 最广泛支持的 '电视 (复合端子)'."
#define OPTION_VAL_VGA_CHS NULL
#define OPTION_VAL_TV_RGB_CHS NULL
#define OPTION_VAL_TV_COMPOSITE_CHS "TV (复合端子)"
#define CORE_OPTION_NAME_BROADCAST_LABEL_CHS "电视标准制式"
#define OPTION_VAL_NTSC_CHS NULL
#define OPTION_VAL_PAL_CHS "PAL (全球)"
#define OPTION_VAL_PAL_N_CHS "PAL-N (阿根廷, 巴拉圭, 乌拉圭)"
#define OPTION_VAL_PAL_M_CHS "PAL-M (巴西)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CHS "屏幕方向"
#define OPTION_VAL_HORIZONTAL_CHS "水平"
#define OPTION_VAL_VERTICAL_CHS "垂直"
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CHS "透明排序"
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CHS "选择透明多边形的排序方式."
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CHS "条形 (快速, 最不精确)"
#define OPTION_VAL_PER_TRIANGLE_NORMAL_CHS "三角形 (正常)"
#define OPTION_VAL_PER_PIXEL_ACCURATE_CHS "像素 (最慢, 精确)"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CHS "累积像素缓存大小"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CHS "为了正确输出更高分辨率可能需要更高的值."
#define OPTION_VAL_512MB_CHS NULL
#define OPTION_VAL_1GB_CHS NULL
#define OPTION_VAL_2GB_CHS NULL
#define OPTION_VAL_4GB_CHS NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_CHS "最大透明层数"
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CHS "复杂场景可能需要更高的数值."
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CHS "全帧缓存仿真"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CHS "在 VRAM 中启用全帧缓存仿真. 对于在 VRAM 上直接读取或写入帧缓存的游戏非常有用. 启用后, 内部分辨率将强制设置为 640x480, 性能可能会受到影响."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CHS "启用 RTT (纹理渲染) 缓存"
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CHS "将渲染的纹理从 GPU 复制回 VRAM. 游戏需要支持此选项才能启用. 启用时, 纹理渲染放大将被禁用, 性能可能会受到影响."
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_CHS "纹理映射"
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_CHS "启用纹理后, 当纹理出现在较远的地方时就会使用较小版本的纹理, 这可以提高性能并减少闪烁."
#define CORE_OPTION_NAME_FOG_LABEL_CHS "雾化效果"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CHS "体积编辑"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CHS "Dreamcast GPU 的功能, 通常被游戏用来绘制阴影对象. 一般情况下应该启用该功能 - 对性能的影响很小可以忽略不计."
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CHS "各向异性过滤"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CHS "可以使倾斜的表面纹理更清晰, 对 GPU 有较高的要求. 重新启动后生效."
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CHS "纹理过滤"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CHS "可以在所有纹理上强制使用某种纹理过滤模式. 以获得比默认模式更清晰 (更平滑) 的画面. 重新启动后生效."
#define OPTION_VAL_1_CHS "强制最近邻"
#define OPTION_VAL_2_CHS "线性过滤"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CHS "切换延迟帧"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CHS "对避免闪屏或视频故障很有用. 不建议在低阶平台上使用."
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CHS "检测帧率变化"
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CHS "当内部帧率改变时通知前端 (例如从60fps到30fps). 改善锁定的30fps或20fps游戏运行时的帧速率, 但对于未锁定 (不稳定) 帧速率的游戏应禁用 (例如 Ecco the Dolphin, Unreal Tournament). 注意: 当 '自动跳帧' 启用时不可用."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CHS "PowerVR2 后处理滤镜"
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CHS "对渲染的图像进行后处理以模拟 PowerVR2 GPU 的特有视频信号效果."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_CHS "纹理升频 (xBRZ)"
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CHS "增强手绘 2D 像素艺术图形. 仅适用于 2D 像素化游戏."
#define OPTION_VAL_2_O27_CHS "2 倍"
#define OPTION_VAL_4_CHS "4倍"
#define OPTION_VAL_6_CHS "6倍"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CHS "纹理升频最大值. 过滤大小"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CHS "为纹理升频选择一个最大尺寸值, 如果纹理尺寸大于所选值则不会升频."
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CHS "原生位深插值"
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CHS "解决 AMD GPU 的纹理损坏和位深问题. 某些情况下也适用英特尔 GPU."
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CHS "修复升频时边缘出血"
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CHS "有助于解决升频时纹理出血的问题. 在 2D 游戏 (例如: MVC2, CVS, KOF 等等) 中, 如果升频时像素出现扭曲, 应该禁用该功能"
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CHS "多线程渲染"
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CHS "在不同的线程上运行 GPU 和 CPU. 强烈推荐."
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CHS "自动跳帧"
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CHS "当游戏仿真运行缓慢时自动跳帧. 注意: 这个设置必须启用 '线程渲染' 选项."
#define OPTION_VAL_SOME_CHS "正常"
#define OPTION_VAL_MORE_CHS "最大"
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CHS "跳帧"
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CHS "设置两个实际渲染帧之间跳过的帧数."
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CHS "宽屏作弊 (需要重启)"
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CHS "激活宽屏作弊可以修改某些游戏以宽屏格式显示.\""
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CHS "宽屏增强"
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CHS "在正常的 4:3 宽高比之外绘制几何图形. 可能在显示区域产生图形故障."
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CHS "GD-ROM 快速读盘 (不精确)"
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CHS "加快 GD-ROM 读取速度."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CHS "Dreamcast 32MB 内存模块"
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CHS "启用 Dreamcast 32MB 内存模块. 可能会影响兼容性"
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_CHS "SH4 CPU 解锁/超频"
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_CHS "改变默认 SH4 主 CPU 时钟到 200 MHz. 解锁可能拖慢平台速度. 超频可能会增加某些游戏的帧率. 谨慎使用."
#define OPTION_VAL_100_CHS NULL
#define OPTION_VAL_110_CHS NULL
#define OPTION_VAL_120_CHS NULL
#define OPTION_VAL_130_CHS NULL
#define OPTION_VAL_140_CHS NULL
#define OPTION_VAL_150_CHS NULL
#define OPTION_VAL_160_CHS NULL
#define OPTION_VAL_170_CHS NULL
#define OPTION_VAL_180_CHS NULL
#define OPTION_VAL_190_CHS NULL
#define OPTION_VAL_200_CHS NULL
#define OPTION_VAL_210_CHS NULL
#define OPTION_VAL_220_CHS NULL
#define OPTION_VAL_230_CHS NULL
#define OPTION_VAL_240_CHS NULL
#define OPTION_VAL_250_CHS NULL
#define OPTION_VAL_260_CHS NULL
#define OPTION_VAL_270_CHS NULL
#define OPTION_VAL_280_CHS NULL
#define OPTION_VAL_290_CHS NULL
#define OPTION_VAL_300_CHS NULL
#define OPTION_VAL_310_CHS NULL
#define OPTION_VAL_320_CHS NULL
#define OPTION_VAL_330_CHS NULL
#define OPTION_VAL_340_CHS NULL
#define OPTION_VAL_350_CHS NULL
#define OPTION_VAL_360_CHS NULL
#define OPTION_VAL_370_CHS NULL
#define OPTION_VAL_380_CHS NULL
#define OPTION_VAL_390_CHS NULL
#define OPTION_VAL_400_CHS NULL
#define OPTION_VAL_410_CHS NULL
#define OPTION_VAL_420_CHS NULL
#define OPTION_VAL_430_CHS NULL
#define OPTION_VAL_440_CHS NULL
#define OPTION_VAL_450_CHS NULL
#define OPTION_VAL_460_CHS NULL
#define OPTION_VAL_470_CHS NULL
#define OPTION_VAL_480_CHS NULL
#define OPTION_VAL_490_CHS NULL
#define OPTION_VAL_500_CHS NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CHS "加载自定义纹理"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CHS "加载位于 'system/dc/textures/<game-id>/' 文件夹中的自定义纹理."
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CHS "转储纹理"
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CHS "每次游戏使用新纹理时, 都会以 .png 文件的形式保存在 'system/dc/texdump/<game-id>/' 文件夹中."
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CHS "摇杆死区"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CHS "选择要按多少次模拟摇杆才开始运行."
#define OPTION_VAL_0_CHS NULL
#define OPTION_VAL_5_CHS NULL
#define OPTION_VAL_10_CHS NULL
#define OPTION_VAL_15_CHS NULL
#define OPTION_VAL_20_CHS NULL
#define OPTION_VAL_25_CHS NULL
#define OPTION_VAL_30_CHS NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CHS "扳机死区"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CHS "选择要按多少次扳机才开始运行."
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CHS "数字扳机"
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CHS "启用后, 扳机像普通按钮一样运行为完全按下或未按下, 键程没有任何区别."
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CHS "输出数字制式"
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CHS "在 TCP 端口 8000 上输出数字制式和强制反馈. 兼容 \"-output network\" MAME 选项."
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CHS "光枪显示设置"
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CHS "启用光枪准星显示配置选项. 注意: 可能需要切换快捷菜单此设置才生效."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CHS "光枪准星缩放大小"
#define OPTION_VAL_50_CHS NULL
#define OPTION_VAL_60_CHS NULL
#define OPTION_VAL_70_CHS NULL
#define OPTION_VAL_80_CHS NULL
#define OPTION_VAL_90_CHS NULL
#define OPTION_VAL_100_O46_CHS NULL
#define OPTION_VAL_110_O46_CHS NULL
#define OPTION_VAL_120_O46_CHS NULL
#define OPTION_VAL_130_O46_CHS NULL
#define OPTION_VAL_140_O46_CHS NULL
#define OPTION_VAL_150_O46_CHS NULL
#define OPTION_VAL_160_O46_CHS NULL
#define OPTION_VAL_170_O46_CHS NULL
#define OPTION_VAL_180_O46_CHS NULL
#define OPTION_VAL_190_O46_CHS NULL
#define OPTION_VAL_200_O46_CHS NULL
#define OPTION_VAL_210_O46_CHS NULL
#define OPTION_VAL_220_O46_CHS NULL
#define OPTION_VAL_230_O46_CHS NULL
#define OPTION_VAL_240_O46_CHS NULL
#define OPTION_VAL_250_O46_CHS NULL
#define OPTION_VAL_260_O46_CHS NULL
#define OPTION_VAL_270_O46_CHS NULL
#define OPTION_VAL_280_O46_CHS NULL
#define OPTION_VAL_290_O46_CHS NULL
#define OPTION_VAL_300_O46_CHS NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CHS "光枪准星 1 显示"
#define OPTION_VAL_WHITE_CHS "白色"
#define OPTION_VAL_RED_CHS "红色"
#define OPTION_VAL_GREEN_CHS "绿色"
#define OPTION_VAL_BLUE_CHS "蓝色"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CHS "光枪准星 2 显示"
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CHS "光枪准星 3 显示"
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CHS "光枪准星 4 显示"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CHS "扩展槽 A1 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CHS "选择插入扩展槽 A1 (端口 A 槽位 1) 的设备."
#define OPTION_VAL_VMU_CHS NULL
#define OPTION_VAL_PURUPURU_CHS "震动包"
#define OPTION_VAL_NONE_CHS "无"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CHS "扩展槽 A2 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CHS "选择插入扩展槽 A2 (端口 A 槽位 2) 的设备."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CHS "扩展槽 B1 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CHS "选择插入扩展槽 B1 (端口 B 槽位 1) 的设备."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CHS "扩展槽 B2 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CHS "选择插入扩展槽 B2 (端口 B 槽位 2) 的设备."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CHS "扩展槽 C1 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CHS "选择插入扩展槽 C1 (端口 C 槽位 1) 的设备."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CHS "扩展槽 C2 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CHS "选择插入扩展槽 C2 (端口 C 槽位 2) 的设备."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CHS "扩展槽 D1 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CHS "选择插入扩展槽 D1 (端口 D 槽位 1) 的设备."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CHS "扩展槽 D2 中的设备"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CHS "选择插入扩展槽 D2 (端口 D 槽位 2) 的设备."
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CHS "每个游戏的记忆卡掌机/系统 (VMU)"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CHS "每个游戏 VMU"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CHS "禁用时, 所有游戏共享位于 RetroArch 系统目录中的 8 个 VMU 存档文件 (A1/A2/B1/B2/C1/C2/D1/D2).\n'VMU A1' 为每个启动的游戏在 RetroArch 存档目录中创建一个 VMU 'A1' 存档文件.\n'全部 VMU' 为每个启动的游戏创建 8 个 VMU 存档文件 (A1/A2/B1/B2/C1/C2/D1/D2)."
#define OPTION_VAL_VMU_A1_CHS NULL
#define OPTION_VAL_ALL_VMUS_CHS "全部 VMU"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CHS "Visual Memory Units/系统 (VMU) 声音"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CHS "VMU 声音"
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_CHS "启用时, 将播放 VMU 游玩音效."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CHS "显示记忆卡掌机/显示设置系统 (VMU)"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CHS "展示 VMU 显示设置"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CHS "启用配置并模拟 VMU LCD 屏幕的可见性, 大小, 位置和颜色. 注意: 可能需要切换快捷菜单此设置才生效."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CHS "VMU 屏幕 1 显示"
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CHS "VMU 屏幕 1 位置"
#define OPTION_VAL_UPPER_LEFT_CHS "左上角"
#define OPTION_VAL_UPPER_RIGHT_CHS "右上角"
#define OPTION_VAL_LOWER_LEFT_CHS "左下角"
#define OPTION_VAL_LOWER_RIGHT_CHS "右下角"
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CHS "VMU 屏幕 1 大小"
#define OPTION_VAL_1X_CHS "1倍"
#define OPTION_VAL_3X_CHS "3倍"
#define OPTION_VAL_5X_CHS "5倍"
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CHS "VMU 屏幕 1 背景像素颜色"
#define OPTION_VAL_DEFAULT_ON_00_CHS "默认打开"
#define OPTION_VAL_DEFAULT_OFF_01_CHS "默认关闭"
#define OPTION_VAL_BLACK_02_CHS "黑色"
#define OPTION_VAL_LIGHT_BLUE_04_CHS "浅蓝色"
#define OPTION_VAL_CYAN_06_CHS "青色"
#define OPTION_VAL_CYAN_BLUE_07_CHS "青蓝色"
#define OPTION_VAL_LIGHT_GREEN_08_CHS "浅绿色"
#define OPTION_VAL_CYAN_GREEN_09_CHS "青绿色"
#define OPTION_VAL_LIGHT_CYAN_10_CHS "浅青色"
#define OPTION_VAL_PURPLE_12_CHS "紫色"
#define OPTION_VAL_LIGHT_PURPLE_13_CHS "紫色"
#define OPTION_VAL_YELLOW_14_CHS "黄色"
#define OPTION_VAL_GRAY_15_CHS "灰色"
#define OPTION_VAL_LIGHT_PURPLE_2_16_CHS "浅紫色 (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_CHS "浅绿色 (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_CHS "浅绿色 (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_CHS "浅青色 (2)"
#define OPTION_VAL_LIGHT_RED_2_20_CHS "浅红色 (2)"
#define OPTION_VAL_MAGENTA_21_CHS "品红色"
#define OPTION_VAL_LIGHT_PURPLE_3_22_CHS "浅紫色 (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_CHS "浅橙色"
#define OPTION_VAL_ORANGE_24_CHS "橙色"
#define OPTION_VAL_LIGHT_PURPLE_4_25_CHS "浅紫色 (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_CHS "浅黄色"
#define OPTION_VAL_LIGHT_YELLOW_2_27_CHS "浅黄色 (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CHS "VMU 屏幕 1 前景像素颜色"
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CHS "VMU 屏幕 1 不透明度"
#define OPTION_VAL_40_CHS NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CHS "VMU 屏幕 2 显示"
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CHS "VMU 屏幕 2 位置"
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CHS "VMU 屏幕 2 大小"
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CHS "VMU 屏幕 2 背景像素颜色"
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CHS "VMU 屏幕 2 前景像素颜色"
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CHS "VMU 屏幕 2 不透明度"
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CHS "VMU 屏幕 3 显示"
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CHS "VMU 屏幕 3 位置"
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CHS "VMU 屏幕 3 大小"
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CHS "VMU 屏幕 3 背景像素颜色"
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CHS "VMU 屏幕 3 前景像素颜色"
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CHS "VMU 屏幕 3 不透明度"
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CHS "VMU 屏幕 4 显示"
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CHS "VMU 屏幕 4 位置"
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CHS "VMU 屏幕 4 大小"
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CHS "VMU 屏幕 4 背景像素颜色"
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CHS "VMU 屏幕 4 前景像素颜色"
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CHS "VMU 屏幕 4 不透明度"

struct retro_core_option_v2_category option_cats_chs[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CHS,
      CATEGORY_SYSTEM_INFO_0_CHS
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHS,
      CATEGORY_VIDEO_INFO_0_CHS
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_CHS,
      CATEGORY_PERFORMANCE_INFO_0_CHS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHS,
      CATEGORY_HACKS_INFO_0_CHS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHS,
      CATEGORY_INPUT_INFO_0_CHS
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_CHS,
      CATEGORY_EXPANSIONS_INFO_0_CHS
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_CHS,
      CATEGORY_VMU_INFO_0_CHS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_chs[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_CHS,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_CHS },
         { "USA",     OPTION_VAL_USA_CHS },
         { "Europe",  OPTION_VAL_EUROPE_CHS },
         { "Default", OPTION_VAL_DEFAULT_CHS },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_CHS,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_CHS },
         { "English",  OPTION_VAL_ENGLISH_CHS },
         { "German",   OPTION_VAL_GERMAN_CHS },
         { "French",   OPTION_VAL_FRENCH_CHS },
         { "Spanish",  OPTION_VAL_SPANISH_CHS },
         { "Italian",  OPTION_VAL_ITALIAN_CHS },
         { "Default",  OPTION_VAL_DEFAULT_CHS },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_CHS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CHS,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_CHS },
         { "640x480",    OPTION_VAL_640X480_CHS },
         { "800x600",    OPTION_VAL_800X600_CHS },
         { "960x720",    OPTION_VAL_960X720_CHS },
         { "1024x768",   OPTION_VAL_1024X768_CHS },
         { "1280x960",   OPTION_VAL_1280X960_CHS },
         { "1440x1080",  OPTION_VAL_1440X1080_CHS },
         { "1600x1200",  OPTION_VAL_1600X1200_CHS },
         { "1920x1440",  OPTION_VAL_1920X1440_CHS },
         { "2560x1920",  OPTION_VAL_2560X1920_CHS },
         { "2880x2160",  OPTION_VAL_2880X2160_CHS },
         { "3200x2400",  OPTION_VAL_3200X2400_CHS },
         { "3840x2880",  OPTION_VAL_3840X2880_CHS },
         { "4480x3360",  OPTION_VAL_4480X3360_CHS },
         { "5120x3840",  OPTION_VAL_5120X3840_CHS },
         { "5760x4320",  OPTION_VAL_5760X4320_CHS },
         { "6400x4800",  OPTION_VAL_6400X4800_CHS },
         { "7040x5280",  OPTION_VAL_7040X5280_CHS },
         { "7680x5760",  OPTION_VAL_7680X5760_CHS },
         { "8320x6240",  OPTION_VAL_8320X6240_CHS },
         { "8960x6720",  OPTION_VAL_8960X6720_CHS },
         { "9600x7200",  OPTION_VAL_9600X7200_CHS },
         { "10240x7680", OPTION_VAL_10240X7680_CHS },
         { "10880x8160", OPTION_VAL_10880X8160_CHS },
         { "11520x8640", OPTION_VAL_11520X8640_CHS },
         { "12160x9120", OPTION_VAL_12160X9120_CHS },
         { "12800x9600", OPTION_VAL_12800X9600_CHS },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_CHS },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_CHS },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_CHS },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_CHS,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_CHS },
         { "PAL",     OPTION_VAL_PAL_CHS },
         { "PAL_N",   OPTION_VAL_PAL_N_CHS },
         { "PAL_M",   OPTION_VAL_PAL_M_CHS },
         { "Default", OPTION_VAL_DEFAULT_CHS },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CHS,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_CHS },
         { "vertical",   OPTION_VAL_VERTICAL_CHS },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CHS },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_CHS },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_CHS },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_CHS },
         { "1GB",   OPTION_VAL_1GB_CHS },
         { "2GB",   OPTION_VAL_2GB_CHS },
         { "4GB",   OPTION_VAL_4GB_CHS },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CHS,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_CHS,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_CHS },
         { "1",  OPTION_VAL_1_CHS },
         { "2",  OPTION_VAL_2_CHS },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CHS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_CHS },
         { "4",  OPTION_VAL_4_CHS },
         { "6",  OPTION_VAL_6_CHS },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CHS,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CHS,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CHS,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CHS,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CHS,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CHS,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CHS,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_CHS },
         { "more", OPTION_VAL_MORE_CHS },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CHS,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CHS },
         { "110", OPTION_VAL_110_CHS },
         { "120", OPTION_VAL_120_CHS },
         { "130", OPTION_VAL_130_CHS },
         { "140", OPTION_VAL_140_CHS },
         { "150", OPTION_VAL_150_CHS },
         { "160", OPTION_VAL_160_CHS },
         { "170", OPTION_VAL_170_CHS },
         { "180", OPTION_VAL_180_CHS },
         { "190", OPTION_VAL_190_CHS },
         { "200", OPTION_VAL_200_CHS },
         { "210", OPTION_VAL_210_CHS },
         { "220", OPTION_VAL_220_CHS },
         { "230", OPTION_VAL_230_CHS },
         { "240", OPTION_VAL_240_CHS },
         { "250", OPTION_VAL_250_CHS },
         { "260", OPTION_VAL_260_CHS },
         { "270", OPTION_VAL_270_CHS },
         { "280", OPTION_VAL_280_CHS },
         { "290", OPTION_VAL_290_CHS },
         { "300", OPTION_VAL_300_CHS },
         { "310", OPTION_VAL_310_CHS },
         { "320", OPTION_VAL_320_CHS },
         { "330", OPTION_VAL_330_CHS },
         { "340", OPTION_VAL_340_CHS },
         { "350", OPTION_VAL_350_CHS },
         { "360", OPTION_VAL_360_CHS },
         { "370", OPTION_VAL_370_CHS },
         { "380", OPTION_VAL_380_CHS },
         { "390", OPTION_VAL_390_CHS },
         { "400", OPTION_VAL_400_CHS },
         { "410", OPTION_VAL_410_CHS },
         { "420", OPTION_VAL_420_CHS },
         { "430", OPTION_VAL_430_CHS },
         { "440", OPTION_VAL_440_CHS },
         { "450", OPTION_VAL_450_CHS },
         { "460", OPTION_VAL_460_CHS },
         { "470", OPTION_VAL_470_CHS },
         { "480", OPTION_VAL_480_CHS },
         { "490", OPTION_VAL_490_CHS },
         { "500", OPTION_VAL_500_CHS },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CHS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CHS },
         { "5%",  OPTION_VAL_5_CHS },
         { "10%", OPTION_VAL_10_CHS },
         { "15%", OPTION_VAL_15_CHS },
         { "20%", OPTION_VAL_20_CHS },
         { "25%", OPTION_VAL_25_CHS },
         { "30%", OPTION_VAL_30_CHS },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CHS,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CHS },
         { "5%",  OPTION_VAL_5_CHS },
         { "10%", OPTION_VAL_10_CHS },
         { "15%", OPTION_VAL_15_CHS },
         { "20%", OPTION_VAL_20_CHS },
         { "25%", OPTION_VAL_25_CHS },
         { "30%", OPTION_VAL_30_CHS },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CHS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CHS,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CHS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_CHS },
         { "60%",  OPTION_VAL_60_CHS },
         { "70%",  OPTION_VAL_70_CHS },
         { "80%",  OPTION_VAL_80_CHS },
         { "90%",  OPTION_VAL_90_CHS },
         { "100%", OPTION_VAL_100_O46_CHS },
         { "110%", OPTION_VAL_110_O46_CHS },
         { "120%", OPTION_VAL_120_O46_CHS },
         { "130%", OPTION_VAL_130_O46_CHS },
         { "140%", OPTION_VAL_140_O46_CHS },
         { "150%", OPTION_VAL_150_O46_CHS },
         { "160%", OPTION_VAL_160_O46_CHS },
         { "170%", OPTION_VAL_170_O46_CHS },
         { "180%", OPTION_VAL_180_O46_CHS },
         { "190%", OPTION_VAL_190_O46_CHS },
         { "200%", OPTION_VAL_200_O46_CHS },
         { "210%", OPTION_VAL_210_O46_CHS },
         { "220%", OPTION_VAL_220_O46_CHS },
         { "230%", OPTION_VAL_230_O46_CHS },
         { "240%", OPTION_VAL_240_O46_CHS },
         { "250%", OPTION_VAL_250_O46_CHS },
         { "260%", OPTION_VAL_260_O46_CHS },
         { "270%", OPTION_VAL_270_O46_CHS },
         { "280%", OPTION_VAL_280_O46_CHS },
         { "290%", OPTION_VAL_290_O46_CHS },
         { "300%", OPTION_VAL_300_O46_CHS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHS },
         { "Red",      OPTION_VAL_RED_CHS },
         { "Green",    OPTION_VAL_GREEN_CHS },
         { "Blue",     OPTION_VAL_BLUE_CHS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHS },
         { "Red",      OPTION_VAL_RED_CHS },
         { "Green",    OPTION_VAL_GREEN_CHS },
         { "Blue",     OPTION_VAL_BLUE_CHS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHS },
         { "Red",      OPTION_VAL_RED_CHS },
         { "Green",    OPTION_VAL_GREEN_CHS },
         { "Blue",     OPTION_VAL_BLUE_CHS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHS },
         { "Red",      OPTION_VAL_RED_CHS },
         { "Green",    OPTION_VAL_GREEN_CHS },
         { "Blue",     OPTION_VAL_BLUE_CHS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CHS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CHS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHS },
         { "Purupuru", OPTION_VAL_PURUPURU_CHS },
         { "None",     OPTION_VAL_NONE_CHS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CHS,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CHS,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CHS,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_CHS },
         { "All VMUs", OPTION_VAL_ALL_VMUS_CHS },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CHS,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CHS,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_CHS,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CHS,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CHS,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CHS,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHS },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHS },
         { "2x", OPTION_VAL_2_O27_CHS },
         { "3x", OPTION_VAL_3X_CHS },
         { "4x", OPTION_VAL_4_CHS },
         { "5x", OPTION_VAL_5X_CHS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHS },
         { "20%",  OPTION_VAL_20_CHS },
         { "30%",  OPTION_VAL_30_CHS },
         { "40%",  OPTION_VAL_40_CHS },
         { "50%",  OPTION_VAL_50_CHS },
         { "60%",  OPTION_VAL_60_CHS },
         { "70%",  OPTION_VAL_70_CHS },
         { "80%",  OPTION_VAL_80_CHS },
         { "90%",  OPTION_VAL_90_CHS },
         { "100%", OPTION_VAL_100_O46_CHS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHS },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHS },
         { "2x", OPTION_VAL_2_O27_CHS },
         { "3x", OPTION_VAL_3X_CHS },
         { "4x", OPTION_VAL_4_CHS },
         { "5x", OPTION_VAL_5X_CHS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHS },
         { "20%",  OPTION_VAL_20_CHS },
         { "30%",  OPTION_VAL_30_CHS },
         { "40%",  OPTION_VAL_40_CHS },
         { "50%",  OPTION_VAL_50_CHS },
         { "60%",  OPTION_VAL_60_CHS },
         { "70%",  OPTION_VAL_70_CHS },
         { "80%",  OPTION_VAL_80_CHS },
         { "90%",  OPTION_VAL_90_CHS },
         { "100%", OPTION_VAL_100_O46_CHS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHS },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHS },
         { "2x", OPTION_VAL_2_O27_CHS },
         { "3x", OPTION_VAL_3X_CHS },
         { "4x", OPTION_VAL_4_CHS },
         { "5x", OPTION_VAL_5X_CHS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHS },
         { "20%",  OPTION_VAL_20_CHS },
         { "30%",  OPTION_VAL_30_CHS },
         { "40%",  OPTION_VAL_40_CHS },
         { "50%",  OPTION_VAL_50_CHS },
         { "60%",  OPTION_VAL_60_CHS },
         { "70%",  OPTION_VAL_70_CHS },
         { "80%",  OPTION_VAL_80_CHS },
         { "90%",  OPTION_VAL_90_CHS },
         { "100%", OPTION_VAL_100_O46_CHS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHS },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHS },
         { "2x", OPTION_VAL_2_O27_CHS },
         { "3x", OPTION_VAL_3X_CHS },
         { "4x", OPTION_VAL_4_CHS },
         { "5x", OPTION_VAL_5X_CHS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHS },
         { "BLUE 03",           OPTION_VAL_BLUE_CHS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHS },
         { "GREEN 05",          OPTION_VAL_GREEN_CHS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHS },
         { "RED 11",            OPTION_VAL_RED_CHS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHS },
         { "WHITE 28",          OPTION_VAL_WHITE_CHS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CHS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHS },
         { "20%",  OPTION_VAL_20_CHS },
         { "30%",  OPTION_VAL_30_CHS },
         { "40%",  OPTION_VAL_40_CHS },
         { "50%",  OPTION_VAL_50_CHS },
         { "60%",  OPTION_VAL_60_CHS },
         { "70%",  OPTION_VAL_70_CHS },
         { "80%",  OPTION_VAL_80_CHS },
         { "90%",  OPTION_VAL_90_CHS },
         { "100%", OPTION_VAL_100_O46_CHS },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_chs = {
   option_cats_chs,
   option_defs_chs
};

/* RETRO_LANGUAGE_CHT */

#define CATEGORY_SYSTEM_LABEL_CHT "系統"
#define CATEGORY_SYSTEM_INFO_0_CHT NULL
#define CATEGORY_VIDEO_LABEL_CHT "顯示"
#define CATEGORY_VIDEO_INFO_0_CHT "變更解析度、渲染透明度和視覺效果的設定。"
#define CATEGORY_PERFORMANCE_LABEL_CHT "效能"
#define CATEGORY_PERFORMANCE_INFO_0_CHT NULL
#define CATEGORY_HACKS_LABEL_CHT "進階"
#define CATEGORY_HACKS_INFO_0_CHT NULL
#define CATEGORY_INPUT_LABEL_CHT "輸入"
#define CATEGORY_INPUT_INFO_0_CHT NULL
#define CATEGORY_EXPANSIONS_LABEL_CHT NULL
#define CATEGORY_EXPANSIONS_INFO_0_CHT NULL
#define CATEGORY_VMU_LABEL_CHT NULL
#define CATEGORY_VMU_INFO_0_CHT NULL
#define CORE_OPTION_NAME_REGION_LABEL_CHT "發售地"
#define OPTION_VAL_JAPAN_CHT NULL
#define OPTION_VAL_USA_CHT NULL
#define OPTION_VAL_EUROPE_CHT NULL
#define OPTION_VAL_DEFAULT_CHT "預設"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_CHT "語言"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_CHT NULL
#define OPTION_VAL_JAPANESE_CHT "日語"
#define OPTION_VAL_ENGLISH_CHT "英語"
#define OPTION_VAL_GERMAN_CHT "德語"
#define OPTION_VAL_FRENCH_CHT "法語"
#define OPTION_VAL_SPANISH_CHT "西班牙語"
#define OPTION_VAL_ITALIAN_CHT "意大利語"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_CHT NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CHT NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_CHT NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CHT NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CHT NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CHT NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CHT NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_CHT NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CHT NULL
#define CORE_OPTION_NAME_UPNP_LABEL_CHT NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DCNET_LABEL_CHT NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_CHT NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CHT "內部解析度"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CHT NULL
#define OPTION_VAL_320X240_CHT NULL
#define OPTION_VAL_640X480_CHT NULL
#define OPTION_VAL_800X600_CHT NULL
#define OPTION_VAL_960X720_CHT NULL
#define OPTION_VAL_1024X768_CHT NULL
#define OPTION_VAL_1280X960_CHT NULL
#define OPTION_VAL_1440X1080_CHT NULL
#define OPTION_VAL_1600X1200_CHT NULL
#define OPTION_VAL_1920X1440_CHT NULL
#define OPTION_VAL_2560X1920_CHT NULL
#define OPTION_VAL_2880X2160_CHT NULL
#define OPTION_VAL_3200X2400_CHT NULL
#define OPTION_VAL_3840X2880_CHT NULL
#define OPTION_VAL_4480X3360_CHT NULL
#define OPTION_VAL_5120X3840_CHT NULL
#define OPTION_VAL_5760X4320_CHT NULL
#define OPTION_VAL_6400X4800_CHT NULL
#define OPTION_VAL_7040X5280_CHT NULL
#define OPTION_VAL_7680X5760_CHT NULL
#define OPTION_VAL_8320X6240_CHT NULL
#define OPTION_VAL_8960X6720_CHT NULL
#define OPTION_VAL_9600X7200_CHT NULL
#define OPTION_VAL_10240X7680_CHT NULL
#define OPTION_VAL_10880X8160_CHT NULL
#define OPTION_VAL_11520X8640_CHT NULL
#define OPTION_VAL_12160X9120_CHT NULL
#define OPTION_VAL_12800X9600_CHT NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_CHT NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CHT NULL
#define OPTION_VAL_VGA_CHT NULL
#define OPTION_VAL_TV_RGB_CHT NULL
#define OPTION_VAL_TV_COMPOSITE_CHT NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_CHT NULL
#define OPTION_VAL_NTSC_CHT NULL
#define OPTION_VAL_PAL_CHT NULL
#define OPTION_VAL_PAL_N_CHT NULL
#define OPTION_VAL_PAL_M_CHT NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CHT "螢幕顯示方向"
#define OPTION_VAL_HORIZONTAL_CHT NULL
#define OPTION_VAL_VERTICAL_CHT NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CHT NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CHT NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CHT NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_CHT NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_CHT NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CHT NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CHT NULL
#define OPTION_VAL_512MB_CHT NULL
#define OPTION_VAL_1GB_CHT NULL
#define OPTION_VAL_2GB_CHT NULL
#define OPTION_VAL_4GB_CHT NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_CHT NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CHT NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CHT NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CHT NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CHT NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_CHT NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_FOG_LABEL_CHT NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CHT NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CHT NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CHT NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CHT "材質過濾"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CHT NULL
#define OPTION_VAL_1_CHT NULL
#define OPTION_VAL_2_CHT NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CHT NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CHT NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CHT NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CHT NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_CHT NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CHT NULL
#define OPTION_VAL_2_O27_CHT "2倍"
#define OPTION_VAL_4_CHT "4倍"
#define OPTION_VAL_6_CHT "6倍"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CHT NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CHT NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CHT NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CHT NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CHT NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CHT NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CHT NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CHT NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CHT NULL
#define OPTION_VAL_SOME_CHT "正常"
#define OPTION_VAL_MORE_CHT NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CHT NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CHT NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CHT NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CHT NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CHT NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CHT NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CHT NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_CHT NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_CHT NULL
#define OPTION_VAL_100_CHT NULL
#define OPTION_VAL_110_CHT NULL
#define OPTION_VAL_120_CHT NULL
#define OPTION_VAL_130_CHT NULL
#define OPTION_VAL_140_CHT NULL
#define OPTION_VAL_150_CHT NULL
#define OPTION_VAL_160_CHT NULL
#define OPTION_VAL_170_CHT NULL
#define OPTION_VAL_180_CHT NULL
#define OPTION_VAL_190_CHT NULL
#define OPTION_VAL_200_CHT NULL
#define OPTION_VAL_210_CHT NULL
#define OPTION_VAL_220_CHT NULL
#define OPTION_VAL_230_CHT NULL
#define OPTION_VAL_240_CHT NULL
#define OPTION_VAL_250_CHT NULL
#define OPTION_VAL_260_CHT NULL
#define OPTION_VAL_270_CHT NULL
#define OPTION_VAL_280_CHT NULL
#define OPTION_VAL_290_CHT NULL
#define OPTION_VAL_300_CHT NULL
#define OPTION_VAL_310_CHT NULL
#define OPTION_VAL_320_CHT NULL
#define OPTION_VAL_330_CHT NULL
#define OPTION_VAL_340_CHT NULL
#define OPTION_VAL_350_CHT NULL
#define OPTION_VAL_360_CHT NULL
#define OPTION_VAL_370_CHT NULL
#define OPTION_VAL_380_CHT NULL
#define OPTION_VAL_390_CHT NULL
#define OPTION_VAL_400_CHT NULL
#define OPTION_VAL_410_CHT NULL
#define OPTION_VAL_420_CHT NULL
#define OPTION_VAL_430_CHT NULL
#define OPTION_VAL_440_CHT NULL
#define OPTION_VAL_450_CHT NULL
#define OPTION_VAL_460_CHT NULL
#define OPTION_VAL_470_CHT NULL
#define OPTION_VAL_480_CHT NULL
#define OPTION_VAL_490_CHT NULL
#define OPTION_VAL_500_CHT NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CHT NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CHT NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CHT NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CHT NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CHT NULL
#define OPTION_VAL_0_CHT NULL
#define OPTION_VAL_5_CHT NULL
#define OPTION_VAL_10_CHT NULL
#define OPTION_VAL_15_CHT NULL
#define OPTION_VAL_20_CHT NULL
#define OPTION_VAL_25_CHT NULL
#define OPTION_VAL_30_CHT NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CHT NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CHT NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CHT NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CHT NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CHT NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CHT NULL
#define OPTION_VAL_50_CHT NULL
#define OPTION_VAL_60_CHT NULL
#define OPTION_VAL_70_CHT NULL
#define OPTION_VAL_80_CHT NULL
#define OPTION_VAL_90_CHT NULL
#define OPTION_VAL_100_O46_CHT NULL
#define OPTION_VAL_110_O46_CHT NULL
#define OPTION_VAL_120_O46_CHT NULL
#define OPTION_VAL_130_O46_CHT NULL
#define OPTION_VAL_140_O46_CHT NULL
#define OPTION_VAL_150_O46_CHT NULL
#define OPTION_VAL_160_O46_CHT NULL
#define OPTION_VAL_170_O46_CHT NULL
#define OPTION_VAL_180_O46_CHT NULL
#define OPTION_VAL_190_O46_CHT NULL
#define OPTION_VAL_200_O46_CHT NULL
#define OPTION_VAL_210_O46_CHT NULL
#define OPTION_VAL_220_O46_CHT NULL
#define OPTION_VAL_230_O46_CHT NULL
#define OPTION_VAL_240_O46_CHT NULL
#define OPTION_VAL_250_O46_CHT NULL
#define OPTION_VAL_260_O46_CHT NULL
#define OPTION_VAL_270_O46_CHT NULL
#define OPTION_VAL_280_O46_CHT NULL
#define OPTION_VAL_290_O46_CHT NULL
#define OPTION_VAL_300_O46_CHT NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CHT NULL
#define OPTION_VAL_WHITE_CHT "白色"
#define OPTION_VAL_RED_CHT "紅色"
#define OPTION_VAL_GREEN_CHT "綠色"
#define OPTION_VAL_BLUE_CHT "藍色"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CHT NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CHT NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CHT NULL
#define OPTION_VAL_VMU_CHT NULL
#define OPTION_VAL_PURUPURU_CHT NULL
#define OPTION_VAL_NONE_CHT "無"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CHT NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CHT NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CHT NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CHT NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CHT NULL
#define OPTION_VAL_VMU_A1_CHT NULL
#define OPTION_VAL_ALL_VMUS_CHT NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CHT NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_CHT NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CHT NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CHT NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CHT NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CHT NULL
#define OPTION_VAL_UPPER_LEFT_CHT NULL
#define OPTION_VAL_UPPER_RIGHT_CHT NULL
#define OPTION_VAL_LOWER_LEFT_CHT NULL
#define OPTION_VAL_LOWER_RIGHT_CHT NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CHT NULL
#define OPTION_VAL_1X_CHT "1倍"
#define OPTION_VAL_3X_CHT "3倍"
#define OPTION_VAL_5X_CHT "5倍"
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CHT NULL
#define OPTION_VAL_DEFAULT_ON_00_CHT NULL
#define OPTION_VAL_DEFAULT_OFF_01_CHT NULL
#define OPTION_VAL_BLACK_02_CHT "黑色"
#define OPTION_VAL_LIGHT_BLUE_04_CHT "淺藍色"
#define OPTION_VAL_CYAN_06_CHT "青色"
#define OPTION_VAL_CYAN_BLUE_07_CHT "青藍色"
#define OPTION_VAL_LIGHT_GREEN_08_CHT "淺綠色"
#define OPTION_VAL_CYAN_GREEN_09_CHT "青綠色"
#define OPTION_VAL_LIGHT_CYAN_10_CHT "淺青色"
#define OPTION_VAL_PURPLE_12_CHT "紫色"
#define OPTION_VAL_LIGHT_PURPLE_13_CHT "淺紫色"
#define OPTION_VAL_YELLOW_14_CHT "黃色"
#define OPTION_VAL_GRAY_15_CHT "灰色"
#define OPTION_VAL_LIGHT_PURPLE_2_16_CHT "淺紫色 (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_CHT "淺綠色 (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_CHT "淺綠色 (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_CHT "淺青色 (2)"
#define OPTION_VAL_LIGHT_RED_2_20_CHT "淡紅色 (2)"
#define OPTION_VAL_MAGENTA_21_CHT "洋紅色"
#define OPTION_VAL_LIGHT_PURPLE_3_22_CHT "淺紫色 (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_CHT "淺橘色"
#define OPTION_VAL_ORANGE_24_CHT "橙色"
#define OPTION_VAL_LIGHT_PURPLE_4_25_CHT "淺紫色 (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_CHT "淡黃色"
#define OPTION_VAL_LIGHT_YELLOW_2_27_CHT "淡黃色 (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CHT NULL
#define OPTION_VAL_40_CHT NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CHT NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CHT NULL

struct retro_core_option_v2_category option_cats_cht[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CHT,
      CATEGORY_SYSTEM_INFO_0_CHT
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CHT,
      CATEGORY_VIDEO_INFO_0_CHT
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_CHT,
      CATEGORY_PERFORMANCE_INFO_0_CHT
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CHT,
      CATEGORY_HACKS_INFO_0_CHT
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CHT,
      CATEGORY_INPUT_INFO_0_CHT
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_CHT,
      CATEGORY_EXPANSIONS_INFO_0_CHT
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_CHT,
      CATEGORY_VMU_INFO_0_CHT
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cht[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_CHT,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_CHT },
         { "USA",     OPTION_VAL_USA_CHT },
         { "Europe",  OPTION_VAL_EUROPE_CHT },
         { "Default", OPTION_VAL_DEFAULT_CHT },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_CHT,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_CHT },
         { "English",  OPTION_VAL_ENGLISH_CHT },
         { "German",   OPTION_VAL_GERMAN_CHT },
         { "French",   OPTION_VAL_FRENCH_CHT },
         { "Spanish",  OPTION_VAL_SPANISH_CHT },
         { "Italian",  OPTION_VAL_ITALIAN_CHT },
         { "Default",  OPTION_VAL_DEFAULT_CHT },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_CHT,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CHT,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_CHT },
         { "640x480",    OPTION_VAL_640X480_CHT },
         { "800x600",    OPTION_VAL_800X600_CHT },
         { "960x720",    OPTION_VAL_960X720_CHT },
         { "1024x768",   OPTION_VAL_1024X768_CHT },
         { "1280x960",   OPTION_VAL_1280X960_CHT },
         { "1440x1080",  OPTION_VAL_1440X1080_CHT },
         { "1600x1200",  OPTION_VAL_1600X1200_CHT },
         { "1920x1440",  OPTION_VAL_1920X1440_CHT },
         { "2560x1920",  OPTION_VAL_2560X1920_CHT },
         { "2880x2160",  OPTION_VAL_2880X2160_CHT },
         { "3200x2400",  OPTION_VAL_3200X2400_CHT },
         { "3840x2880",  OPTION_VAL_3840X2880_CHT },
         { "4480x3360",  OPTION_VAL_4480X3360_CHT },
         { "5120x3840",  OPTION_VAL_5120X3840_CHT },
         { "5760x4320",  OPTION_VAL_5760X4320_CHT },
         { "6400x4800",  OPTION_VAL_6400X4800_CHT },
         { "7040x5280",  OPTION_VAL_7040X5280_CHT },
         { "7680x5760",  OPTION_VAL_7680X5760_CHT },
         { "8320x6240",  OPTION_VAL_8320X6240_CHT },
         { "8960x6720",  OPTION_VAL_8960X6720_CHT },
         { "9600x7200",  OPTION_VAL_9600X7200_CHT },
         { "10240x7680", OPTION_VAL_10240X7680_CHT },
         { "10880x8160", OPTION_VAL_10880X8160_CHT },
         { "11520x8640", OPTION_VAL_11520X8640_CHT },
         { "12160x9120", OPTION_VAL_12160X9120_CHT },
         { "12800x9600", OPTION_VAL_12800X9600_CHT },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_CHT },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_CHT },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_CHT },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_CHT,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_CHT },
         { "PAL",     OPTION_VAL_PAL_CHT },
         { "PAL_N",   OPTION_VAL_PAL_N_CHT },
         { "PAL_M",   OPTION_VAL_PAL_M_CHT },
         { "Default", OPTION_VAL_DEFAULT_CHT },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CHT,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_CHT },
         { "vertical",   OPTION_VAL_VERTICAL_CHT },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CHT },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_CHT },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_CHT },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_CHT },
         { "1GB",   OPTION_VAL_1GB_CHT },
         { "2GB",   OPTION_VAL_2GB_CHT },
         { "4GB",   OPTION_VAL_4GB_CHT },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CHT,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_CHT,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_CHT },
         { "1",  OPTION_VAL_1_CHT },
         { "2",  OPTION_VAL_2_CHT },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CHT,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_CHT },
         { "4",  OPTION_VAL_4_CHT },
         { "6",  OPTION_VAL_6_CHT },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CHT,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CHT,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CHT,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CHT,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CHT,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CHT,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CHT,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_CHT },
         { "more", OPTION_VAL_MORE_CHT },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CHT,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CHT },
         { "110", OPTION_VAL_110_CHT },
         { "120", OPTION_VAL_120_CHT },
         { "130", OPTION_VAL_130_CHT },
         { "140", OPTION_VAL_140_CHT },
         { "150", OPTION_VAL_150_CHT },
         { "160", OPTION_VAL_160_CHT },
         { "170", OPTION_VAL_170_CHT },
         { "180", OPTION_VAL_180_CHT },
         { "190", OPTION_VAL_190_CHT },
         { "200", OPTION_VAL_200_CHT },
         { "210", OPTION_VAL_210_CHT },
         { "220", OPTION_VAL_220_CHT },
         { "230", OPTION_VAL_230_CHT },
         { "240", OPTION_VAL_240_CHT },
         { "250", OPTION_VAL_250_CHT },
         { "260", OPTION_VAL_260_CHT },
         { "270", OPTION_VAL_270_CHT },
         { "280", OPTION_VAL_280_CHT },
         { "290", OPTION_VAL_290_CHT },
         { "300", OPTION_VAL_300_CHT },
         { "310", OPTION_VAL_310_CHT },
         { "320", OPTION_VAL_320_CHT },
         { "330", OPTION_VAL_330_CHT },
         { "340", OPTION_VAL_340_CHT },
         { "350", OPTION_VAL_350_CHT },
         { "360", OPTION_VAL_360_CHT },
         { "370", OPTION_VAL_370_CHT },
         { "380", OPTION_VAL_380_CHT },
         { "390", OPTION_VAL_390_CHT },
         { "400", OPTION_VAL_400_CHT },
         { "410", OPTION_VAL_410_CHT },
         { "420", OPTION_VAL_420_CHT },
         { "430", OPTION_VAL_430_CHT },
         { "440", OPTION_VAL_440_CHT },
         { "450", OPTION_VAL_450_CHT },
         { "460", OPTION_VAL_460_CHT },
         { "470", OPTION_VAL_470_CHT },
         { "480", OPTION_VAL_480_CHT },
         { "490", OPTION_VAL_490_CHT },
         { "500", OPTION_VAL_500_CHT },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CHT,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CHT },
         { "5%",  OPTION_VAL_5_CHT },
         { "10%", OPTION_VAL_10_CHT },
         { "15%", OPTION_VAL_15_CHT },
         { "20%", OPTION_VAL_20_CHT },
         { "25%", OPTION_VAL_25_CHT },
         { "30%", OPTION_VAL_30_CHT },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CHT,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CHT },
         { "5%",  OPTION_VAL_5_CHT },
         { "10%", OPTION_VAL_10_CHT },
         { "15%", OPTION_VAL_15_CHT },
         { "20%", OPTION_VAL_20_CHT },
         { "25%", OPTION_VAL_25_CHT },
         { "30%", OPTION_VAL_30_CHT },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CHT,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CHT,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CHT,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_CHT },
         { "60%",  OPTION_VAL_60_CHT },
         { "70%",  OPTION_VAL_70_CHT },
         { "80%",  OPTION_VAL_80_CHT },
         { "90%",  OPTION_VAL_90_CHT },
         { "100%", OPTION_VAL_100_O46_CHT },
         { "110%", OPTION_VAL_110_O46_CHT },
         { "120%", OPTION_VAL_120_O46_CHT },
         { "130%", OPTION_VAL_130_O46_CHT },
         { "140%", OPTION_VAL_140_O46_CHT },
         { "150%", OPTION_VAL_150_O46_CHT },
         { "160%", OPTION_VAL_160_O46_CHT },
         { "170%", OPTION_VAL_170_O46_CHT },
         { "180%", OPTION_VAL_180_O46_CHT },
         { "190%", OPTION_VAL_190_O46_CHT },
         { "200%", OPTION_VAL_200_O46_CHT },
         { "210%", OPTION_VAL_210_O46_CHT },
         { "220%", OPTION_VAL_220_O46_CHT },
         { "230%", OPTION_VAL_230_O46_CHT },
         { "240%", OPTION_VAL_240_O46_CHT },
         { "250%", OPTION_VAL_250_O46_CHT },
         { "260%", OPTION_VAL_260_O46_CHT },
         { "270%", OPTION_VAL_270_O46_CHT },
         { "280%", OPTION_VAL_280_O46_CHT },
         { "290%", OPTION_VAL_290_O46_CHT },
         { "300%", OPTION_VAL_300_O46_CHT },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHT },
         { "Red",      OPTION_VAL_RED_CHT },
         { "Green",    OPTION_VAL_GREEN_CHT },
         { "Blue",     OPTION_VAL_BLUE_CHT },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHT },
         { "Red",      OPTION_VAL_RED_CHT },
         { "Green",    OPTION_VAL_GREEN_CHT },
         { "Blue",     OPTION_VAL_BLUE_CHT },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHT },
         { "Red",      OPTION_VAL_RED_CHT },
         { "Green",    OPTION_VAL_GREEN_CHT },
         { "Blue",     OPTION_VAL_BLUE_CHT },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CHT },
         { "Red",      OPTION_VAL_RED_CHT },
         { "Green",    OPTION_VAL_GREEN_CHT },
         { "Blue",     OPTION_VAL_BLUE_CHT },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CHT,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CHT,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CHT },
         { "Purupuru", OPTION_VAL_PURUPURU_CHT },
         { "None",     OPTION_VAL_NONE_CHT },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CHT,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CHT,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CHT,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_CHT },
         { "All VMUs", OPTION_VAL_ALL_VMUS_CHT },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CHT,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CHT,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_CHT,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CHT,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CHT,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CHT,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHT },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHT },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHT },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHT },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHT },
         { "2x", OPTION_VAL_2_O27_CHT },
         { "3x", OPTION_VAL_3X_CHT },
         { "4x", OPTION_VAL_4_CHT },
         { "5x", OPTION_VAL_5X_CHT },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHT },
         { "20%",  OPTION_VAL_20_CHT },
         { "30%",  OPTION_VAL_30_CHT },
         { "40%",  OPTION_VAL_40_CHT },
         { "50%",  OPTION_VAL_50_CHT },
         { "60%",  OPTION_VAL_60_CHT },
         { "70%",  OPTION_VAL_70_CHT },
         { "80%",  OPTION_VAL_80_CHT },
         { "90%",  OPTION_VAL_90_CHT },
         { "100%", OPTION_VAL_100_O46_CHT },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHT },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHT },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHT },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHT },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHT },
         { "2x", OPTION_VAL_2_O27_CHT },
         { "3x", OPTION_VAL_3X_CHT },
         { "4x", OPTION_VAL_4_CHT },
         { "5x", OPTION_VAL_5X_CHT },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHT },
         { "20%",  OPTION_VAL_20_CHT },
         { "30%",  OPTION_VAL_30_CHT },
         { "40%",  OPTION_VAL_40_CHT },
         { "50%",  OPTION_VAL_50_CHT },
         { "60%",  OPTION_VAL_60_CHT },
         { "70%",  OPTION_VAL_70_CHT },
         { "80%",  OPTION_VAL_80_CHT },
         { "90%",  OPTION_VAL_90_CHT },
         { "100%", OPTION_VAL_100_O46_CHT },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHT },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHT },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHT },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHT },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHT },
         { "2x", OPTION_VAL_2_O27_CHT },
         { "3x", OPTION_VAL_3X_CHT },
         { "4x", OPTION_VAL_4_CHT },
         { "5x", OPTION_VAL_5X_CHT },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHT },
         { "20%",  OPTION_VAL_20_CHT },
         { "30%",  OPTION_VAL_30_CHT },
         { "40%",  OPTION_VAL_40_CHT },
         { "50%",  OPTION_VAL_50_CHT },
         { "60%",  OPTION_VAL_60_CHT },
         { "70%",  OPTION_VAL_70_CHT },
         { "80%",  OPTION_VAL_80_CHT },
         { "90%",  OPTION_VAL_90_CHT },
         { "100%", OPTION_VAL_100_O46_CHT },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CHT },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CHT },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CHT },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CHT },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CHT },
         { "2x", OPTION_VAL_2_O27_CHT },
         { "3x", OPTION_VAL_3X_CHT },
         { "4x", OPTION_VAL_4_CHT },
         { "5x", OPTION_VAL_5X_CHT },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CHT },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CHT },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CHT },
         { "BLUE 03",           OPTION_VAL_BLUE_CHT },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CHT },
         { "GREEN 05",          OPTION_VAL_GREEN_CHT },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CHT },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CHT },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CHT },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CHT },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CHT },
         { "RED 11",            OPTION_VAL_RED_CHT },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CHT },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CHT },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CHT },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CHT },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CHT },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CHT },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CHT },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CHT },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CHT },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CHT },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CHT },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CHT },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CHT },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CHT },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CHT },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CHT },
         { "WHITE 28",          OPTION_VAL_WHITE_CHT },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CHT,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CHT },
         { "20%",  OPTION_VAL_20_CHT },
         { "30%",  OPTION_VAL_30_CHT },
         { "40%",  OPTION_VAL_40_CHT },
         { "50%",  OPTION_VAL_50_CHT },
         { "60%",  OPTION_VAL_60_CHT },
         { "70%",  OPTION_VAL_70_CHT },
         { "80%",  OPTION_VAL_80_CHT },
         { "90%",  OPTION_VAL_90_CHT },
         { "100%", OPTION_VAL_100_O46_CHT },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cht = {
   option_cats_cht,
   option_defs_cht
};

/* RETRO_LANGUAGE_CS */

#define CATEGORY_SYSTEM_LABEL_CS "Systém"
#define CATEGORY_SYSTEM_INFO_0_CS "Konfigurace regionu, jazyka, systému BIOS a základního nastavení hardwaru."
#define CATEGORY_VIDEO_LABEL_CS NULL
#define CATEGORY_VIDEO_INFO_0_CS "Konfigurace rozlišení, nastavení průhlednosti a vizuálních efektů nezávislých na pořadí."
#define CATEGORY_PERFORMANCE_LABEL_CS "Výkon"
#define CATEGORY_PERFORMANCE_INFO_0_CS "Konfigurace nastavení vykreslování ve vláknech a přeskakování snímků."
#define CATEGORY_HACKS_LABEL_CS "Emulace hacků"
#define CATEGORY_HACKS_INFO_0_CS "Konfigurace přepisu širokoúhlého zobrazení, rychlosti načítání GD-ROM a nastavení výměny textur."
#define CATEGORY_INPUT_LABEL_CS "Vstup"
#define CATEGORY_INPUT_INFO_0_CS "Konfigurace nastavení gamepadu a světelné pistole."
#define CATEGORY_EXPANSIONS_LABEL_CS "Rozšiřující sloty ovladače"
#define CATEGORY_EXPANSIONS_INFO_0_CS "Vyberte zařízení (VMU, rumble device) zapojené do každého rozšiřujícího slotu ovladače."
#define CATEGORY_VMU_LABEL_CS "Jednotka Vizuální Paměti"
#define CATEGORY_VMU_INFO_0_CS "Konfigurace ukládacích souborů VMU pro jednotlivé hry a nastavení viditelnosti VMU na obrazovce."
#define CORE_OPTION_NAME_REGION_LABEL_CS NULL
#define OPTION_VAL_JAPAN_CS "Japonsko"
#define OPTION_VAL_USA_CS NULL
#define OPTION_VAL_EUROPE_CS "Evropa"
#define OPTION_VAL_DEFAULT_CS "Výchozí"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_CS "Jazyk"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_CS "Změní jazyk používaný systémem BIOS a všemi hrami, které obsahují více jazyků."
#define OPTION_VAL_JAPANESE_CS "Japonština"
#define OPTION_VAL_ENGLISH_CS "Angličtina"
#define OPTION_VAL_GERMAN_CS "Němčina"
#define OPTION_VAL_FRENCH_CS "Francouzština"
#define OPTION_VAL_SPANISH_CS "Španělština"
#define OPTION_VAL_ITALIAN_CS "Italský"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_CS "HLE BIOS (nutný restart)"
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_CS "Vynucení použití vysokoúrovňové emulace systému BIOS."
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CS "Nabootovat Bios (Nutný Restart)"
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CS "Spustit přímo do menu Dreamcast BIOS."
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_CS "Povolit DSP"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CS "Umožňuje emulaci zvukového DSP (digitálního signálového procesoru) konzole Dreamcast. Zlepšuje přesnost generovaného zvuku, ale zvyšuje nároky na výkon."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CS "Povolení tlačítek služby Arcade"
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CS "Povoluje tlačítko SERVICE pro arkádové hry, které slouží k zadání nastavení kabinetu."
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CS "Nastavení her NAOMI na volné hraní"
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CS "Upravte nastavení mincí ve hře na volnou hru."
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_CS "Emulace širokopásmového adaptéru"
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CS "Místo modemu emulujte širokopásmový adaptér ethernetu. (nutný restart)"
#define CORE_OPTION_NAME_UPNP_LABEL_CS "Povolit UPnP"
#define CORE_OPTION_NAME_UPNP_INFO_0_CS "Pomocí UPnP můžete automaticky nakonfigurovat svůj internetový směrovač pro online hry."
#define CORE_OPTION_NAME_DCNET_LABEL_CS "Použití sítě DCNet (experimentální)"
#define CORE_OPTION_NAME_DCNET_INFO_0_CS "Připojení k experimentální cloudové službě DCNet."
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CS "Vnitřní rozlišení"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CS "Úprava rozlišení vykreslování."
#define OPTION_VAL_320X240_CS "320x240 (Poloviční)"
#define OPTION_VAL_640X480_CS "640x480 (nativní)"
#define OPTION_VAL_800X600_CS NULL
#define OPTION_VAL_960X720_CS "960 x 720 (x1.5)"
#define OPTION_VAL_1024X768_CS NULL
#define OPTION_VAL_1280X960_CS NULL
#define OPTION_VAL_1440X1080_CS "1440 x 1080 (x2.25)"
#define OPTION_VAL_1600X1200_CS NULL
#define OPTION_VAL_1920X1440_CS NULL
#define OPTION_VAL_2560X1920_CS "2560 x 1920 (x4)"
#define OPTION_VAL_2880X2160_CS NULL
#define OPTION_VAL_3200X2400_CS NULL
#define OPTION_VAL_3840X2880_CS NULL
#define OPTION_VAL_4480X3360_CS NULL
#define OPTION_VAL_5120X3840_CS NULL
#define OPTION_VAL_5760X4320_CS NULL
#define OPTION_VAL_6400X4800_CS NULL
#define OPTION_VAL_7040X5280_CS NULL
#define OPTION_VAL_7680X5760_CS NULL
#define OPTION_VAL_8320X6240_CS NULL
#define OPTION_VAL_8960X6720_CS NULL
#define OPTION_VAL_9600X7200_CS NULL
#define OPTION_VAL_10240X7680_CS NULL
#define OPTION_VAL_10880X8160_CS NULL
#define OPTION_VAL_11520X8640_CS NULL
#define OPTION_VAL_12160X9120_CS NULL
#define OPTION_VAL_12800X9600_CS NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_CS "Typ kabelu"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CS "Typ výstupního signálu. Nejvíce podporovaný je 'TV (Kompozitní)'."
#define OPTION_VAL_VGA_CS NULL
#define OPTION_VAL_TV_RGB_CS NULL
#define OPTION_VAL_TV_COMPOSITE_CS "TV (Kompozitní)"
#define CORE_OPTION_NAME_BROADCAST_LABEL_CS "Standardní Vysílání"
#define OPTION_VAL_NTSC_CS NULL
#define OPTION_VAL_PAL_CS "PAL (Svět)"
#define OPTION_VAL_PAL_N_CS NULL
#define OPTION_VAL_PAL_M_CS "PAL-M (Brazílie)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CS "Orientace obrazovky"
#define OPTION_VAL_HORIZONTAL_CS "Horizontální"
#define OPTION_VAL_VERTICAL_CS "Vertikální"
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CS "Třídění Alpha"
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CS "Vyberte způsob řazení průhledných polygonů."
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CS "Per-Strip (rychlé, nejméně přesné)"
#define OPTION_VAL_PER_TRIANGLE_NORMAL_CS "Per-Triangle (normální)"
#define OPTION_VAL_PER_PIXEL_ACCURATE_CS "Per-Pixel (přesné, ale nejpomalejší)"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CS "Velikost akumulační vyrovnávací paměti pixelů"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CS "Pro správný výstup ve vyšších rozlišeních mohou být nutné vyšší hodnoty."
#define OPTION_VAL_512MB_CS NULL
#define OPTION_VAL_1GB_CS NULL
#define OPTION_VAL_2GB_CS NULL
#define OPTION_VAL_4GB_CS NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_CS "Maximální počet průhledných vrstev"
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CS "U složitých scén mohou být nutné vyšší hodnoty."
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CS "Úplná emulace framebufferu"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CS "Povolení úplné emulace framebufferu v paměti VRAM. To je užitečné pro hry, které přímo čtou nebo zapisují framebuffer do VRAM. Pokud je tato funkce povolena, interní rozlišení je vynuceno na 640x480 a může dojít k výraznému snížení výkonu."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CS "Povolení Vyrovnávací Paměti RTT (Render To Texture)"
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CS "Kopírování vykreslených textur z GPU zpět do VRAM. Tato možnost je obvykle povolena u her, které ji vyžadují. Pokud je povolena, je vypnuto zvyšování rozlišení vykreslovaných textur a může dojít ke snížení výkonu."
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_CS "Mipmapování"
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_CS "Pokud je tato funkce povolena, textury použijí menší verzi sebe sama, když se objeví ve větší vzdálenosti, což může zvýšit výkon a snížit třpyt."
#define CORE_OPTION_NAME_FOG_LABEL_CS "Efekty Mlhy"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CS "Modifikátor Hlasitosti"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CS "Funkce grafického procesoru Dreamcast, která se obvykle používá ve hrách ke kreslení stínů objektů. Tato funkce by měla být normálně povolena - dopad na výkon je obvykle minimální až zanedbatelný."
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CS "Anizotropní Filtrování"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CS "Vylepšete kvalitu textur na površích, které jsou vůči kameře pod šikmým úhlem pohledu. Vyšší hodnoty jsou náročnější na grafický procesor. Změny tohoto nastavení se uplatní až po restartu."
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CS "Filtrování textur"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CS "Režim filtrování textur, který se má použít. Tento parametr lze použít k vynucení určitého režimu filtrování textur na všech texturách, abyste dosáhli ostřejšího (nebo hladšího) vzhledu než ve výchozím nastavení. Jiné hodnoty než výchozí mohou způsobit různé problémy s vykreslováním. Změny tohoto nastavení se uplatní až po restartu."
#define OPTION_VAL_1_CS "Vynucený Nearest-Neighbor"
#define OPTION_VAL_2_CS "Vynucený lineární"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CS "Výměna Zpožděných Snímků"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CS "Je užitečné vyhnout se blikajícím obrazovkám nebo poruchovým videím. Nedoporučuje se na pomalých platformách."
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CS "Detekce změn snímkové frekvence"
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CS "Upozornit frontend při změně interní snímkové frekvence (např. z 60 fps na 30 fps). Zlepšuje snímkovou frekvenci ve hrách, které běží s uzamčenou snímkovou frekvencí 30 fps nebo 20 fps, ale měl by být vypnut pro hry s odemčenou (nestabilní) snímkovou frekvencí (např. Ecco the Dolphin, Unreal Tournament). Poznámka: Není k dispozici, pokud je povoleno 'Automatické přeskakování snímků'."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CS "Postprocesní Filtr PowerVR2"
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CS "Následné zpracování vykresleného obrazu pro simulaci efektů specifických pro grafický procesor PowerVR2 a analogové video signály."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_CS "Vylepšení Textur (xBRZ)"
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CS "Vylepšete ručně kreslenou 2D pixelovou grafiku. Mělo by se používat pouze ve 2D pixelových hrách."
#define OPTION_VAL_2_O27_CS NULL
#define OPTION_VAL_4_CS NULL
#define OPTION_VAL_6_CS NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CS "Zvýšení Rozlišení Textur Max. Filtrovaná Velikost"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CS "Vyberte maximální hodnotu velikosti textury, která má být zvětšena, pokud je velikost textury větší než vybraná hodnota, nebude zvětšena."
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CS "Nativní interpolace hloubky"
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CS "Pomáhá řešit problémy s poškozením textur a hloubkou na grafických procesorech AMD. V některých případech může pomoci i GPU Intel."
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CS "Fix Upscalingu krvacející okraj"
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CS "Pomáhá v případě krvácení textur při upscalingu. Jeho vypnutí může pomoci, pokud se pixely při upscalingu ve 2D hrách (MVC2, CVS, KOF atd.) deformují."
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CS "Vykreslování Vláken"
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CS "Spouští GPU a CPU v různých vláknech. Důrazně doporučujeme."
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CS "Automatické Přeskočení Snímků"
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CS "Automatické přeskakování snímků při pomalém běhu emulátoru. Poznámka: Toto nastavení platí pouze tehdy, když je povoleno 'Vláknové Vykreslování'."
#define OPTION_VAL_SOME_CS "Normální"
#define OPTION_VAL_MORE_CS "Maximální"
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CS "Přeskočení Snímků"
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CS "Nastaví počet snímků, které se mají přeskočit mezi jednotlivými zobrazenými snímky."
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CS "Širokoúhlé Cheaty (Nutný Restart)"
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CS "Aktivuje cheaty, které umožňují zobrazení některých her v širokoúhlém formátu."
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CS "Hack Širokoúhleho Obrazu"
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CS "Kreslení geometrie mimo běžný poměr stran 4:3. Může způsobit grafické závady v odhalených oblastech."
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CS "Rychlé Načítání GD-ROM (nepřesné)"
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CS "Zrychluje načítání GD-ROM."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CS NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CS "Povoluje 32MB RAM Mod pro Dreamcast. Může ovlivnit kompatibilitu"
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_CS "Podtaktování/přetaktování procesoru SH4"
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_CS "Změňte takt hlavního procesoru SH4 z výchozích 200 MHz. Podtaktování může pomoci pomalým platformám. Přetaktování může u některých her zvýšit snímkovou frekvenci. Používejte s opatrností."
#define OPTION_VAL_100_CS NULL
#define OPTION_VAL_110_CS NULL
#define OPTION_VAL_120_CS NULL
#define OPTION_VAL_130_CS NULL
#define OPTION_VAL_140_CS NULL
#define OPTION_VAL_150_CS NULL
#define OPTION_VAL_160_CS NULL
#define OPTION_VAL_170_CS NULL
#define OPTION_VAL_180_CS NULL
#define OPTION_VAL_190_CS NULL
#define OPTION_VAL_200_CS NULL
#define OPTION_VAL_210_CS NULL
#define OPTION_VAL_220_CS NULL
#define OPTION_VAL_230_CS NULL
#define OPTION_VAL_240_CS NULL
#define OPTION_VAL_250_CS NULL
#define OPTION_VAL_260_CS NULL
#define OPTION_VAL_270_CS NULL
#define OPTION_VAL_280_CS NULL
#define OPTION_VAL_290_CS NULL
#define OPTION_VAL_300_CS NULL
#define OPTION_VAL_310_CS NULL
#define OPTION_VAL_320_CS NULL
#define OPTION_VAL_330_CS NULL
#define OPTION_VAL_340_CS NULL
#define OPTION_VAL_350_CS NULL
#define OPTION_VAL_360_CS NULL
#define OPTION_VAL_370_CS NULL
#define OPTION_VAL_380_CS NULL
#define OPTION_VAL_390_CS NULL
#define OPTION_VAL_400_CS NULL
#define OPTION_VAL_410_CS NULL
#define OPTION_VAL_420_CS NULL
#define OPTION_VAL_430_CS NULL
#define OPTION_VAL_440_CS NULL
#define OPTION_VAL_450_CS NULL
#define OPTION_VAL_460_CS NULL
#define OPTION_VAL_470_CS NULL
#define OPTION_VAL_480_CS NULL
#define OPTION_VAL_490_CS NULL
#define OPTION_VAL_500_CS NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CS "Načíst Vlastní Textury"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CS "Načtení vlastních textur umístěných ve složce 'system/dc/textures/<game-id>/'."
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CS "Skladiště Textur"
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CS "Pokaždé, když hra použije novou texturu, uloží ji jako soubor .png do složky 'system/dc/texdump/<game-id>/'."
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CS "Analogova Páčka Mrtvé Zóny"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CS "Zvolte, jak daleko musíte zatlačit na analogovou páčku, než se začne zpracovávat."
#define OPTION_VAL_0_CS NULL
#define OPTION_VAL_5_CS NULL
#define OPTION_VAL_10_CS NULL
#define OPTION_VAL_15_CS NULL
#define OPTION_VAL_20_CS NULL
#define OPTION_VAL_25_CS NULL
#define OPTION_VAL_30_CS NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CS "Spouštěč Mrtvé Zóny"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CS "Zvolte, jak dlouho musíte stisknout spoušť, než se začne zpracovávat."
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CS "Digitální Spouštěče"
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CS "Pokud je tato funkce povolena, budou se spouštěče chovat jako běžná tlačítka, což znamená, že budou zpracovávány buď jako plně stisknuté, nebo jako nestisknuté, bez mezistupně."
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CS "Digitální výstupy pro vysílání"
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CS "Vysílání digitálních výstupů a stavu vynucene zpětné vazby na portu TCP 8000. Kompatibilní s volbou MAME \"-výstupní síť\"."
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CS "Zobrazit Nastavení Světelné Pistole"
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CS "Povolení konfigurace možností zobrazení zaměřovacího kříže světelné pistole. POZNÁMKA: Aby se toto nastavení projevilo, může být nutné přepnout rychlou nabídku."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CS "Měřítko velikosti zaměřovacího kříže zbraně"
#define OPTION_VAL_50_CS NULL
#define OPTION_VAL_60_CS NULL
#define OPTION_VAL_70_CS NULL
#define OPTION_VAL_80_CS NULL
#define OPTION_VAL_90_CS NULL
#define OPTION_VAL_100_O46_CS NULL
#define OPTION_VAL_110_O46_CS NULL
#define OPTION_VAL_120_O46_CS NULL
#define OPTION_VAL_130_O46_CS NULL
#define OPTION_VAL_140_O46_CS NULL
#define OPTION_VAL_150_O46_CS NULL
#define OPTION_VAL_160_O46_CS NULL
#define OPTION_VAL_170_O46_CS NULL
#define OPTION_VAL_180_O46_CS NULL
#define OPTION_VAL_190_O46_CS NULL
#define OPTION_VAL_200_O46_CS NULL
#define OPTION_VAL_210_O46_CS NULL
#define OPTION_VAL_220_O46_CS NULL
#define OPTION_VAL_230_O46_CS NULL
#define OPTION_VAL_240_O46_CS NULL
#define OPTION_VAL_250_O46_CS NULL
#define OPTION_VAL_260_O46_CS NULL
#define OPTION_VAL_270_O46_CS NULL
#define OPTION_VAL_280_O46_CS NULL
#define OPTION_VAL_290_O46_CS NULL
#define OPTION_VAL_300_O46_CS NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CS "Zobrazení Kříže Zbraně 1"
#define OPTION_VAL_WHITE_CS "Bílá"
#define OPTION_VAL_RED_CS "Červený"
#define OPTION_VAL_GREEN_CS "Zelený"
#define OPTION_VAL_BLUE_CS "Modrý"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CS "Zobrazení Kříže Zbraně 2"
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CS "Zobrazení Kříže Zbraně 3"
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CS "Zobrazení Kříže Zbraně 4"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CS "Zařízení v rozšiřujícím slotu A1"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu A1 (port A slot 1)."
#define OPTION_VAL_VMU_CS NULL
#define OPTION_VAL_PURUPURU_CS "Balíček vibrací"
#define OPTION_VAL_NONE_CS "Žádné"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CS "Zařízení v rozšiřujícím slotu A2"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu A2 (port A slot 2)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CS "Zařízení v rozšiřujícím slotu B1"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu B1 (port B slot 1)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CS "Zařízení v rozšiřujícím slotu B2"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu B2 (port B slot 2)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CS "Zařízení v rozšiřujícím slotu C1"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu C1 (port C slot 1)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CS "Zařízení v rozšiřujícím slotu C2"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu C2 (port C slot 2)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CS "Zařízení v rozšiřujícím slotu D1"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu D1 (port D slot 1)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CS "Zařízení v rozšiřujícím slotu D2"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CS "Vyberte zařízení zapojené do rozšiřujícího slotu D2 (port D slot 2)."
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CS "Vizuální Paměťové Jednotky/Systémy pro Jednotlivé Hry (VMU)"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CS "VMUs Na-Hru"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CS "Pokud je vypnuto, všechny hry sdílejí až 8 souborů VMU (A1/A2/B1/B2/C1/C2/D1/D2) umístěných v systémové složce aplikace RetroArch.\nNastavení „VMU A1“ vytvoří pro každou spuštěnou hru jedinečný soubor VMU „A1“ ve složce uložení aplikace RetroArch.\nNastavení „Všechny VMU“ vytvoří pro každou spuštěnou hru až 8 jedinečných souborů VMU (A1/A2/B1/B2/C1/C2/D1/D2)."
#define OPTION_VAL_VMU_A1_CS NULL
#define OPTION_VAL_ALL_VMUS_CS NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CS "Vizuální paměťové jednotky/systémy (VMU) Zvuky"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CS "Zvuky VMU"
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_CS "Pokud je tato funkce povolena, přehrávají se zvukové signály VMU."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CS "Zobrazit Nastavení Displeje Vizuální Paměťové Jednotky/Systému (VMU)"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CS "Zobrazit Nastavení VMU Displeje"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CS "Umožňuje konfiguraci viditelnosti, velikosti, polohy a barvy obrazovky LCD emulovaného VMU. POZNÁMKA: Může být nutné přepnout Rychlé Menu, aby se toto nastavení projevilo."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CS "Displej Obrazovky VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CS "Pozice Obrazovky VMU 1"
#define OPTION_VAL_UPPER_LEFT_CS "Vlevo Nahoře"
#define OPTION_VAL_UPPER_RIGHT_CS "Vpravo Nahoře"
#define OPTION_VAL_LOWER_LEFT_CS "Vlevo Dole"
#define OPTION_VAL_LOWER_RIGHT_CS "Vpravo Dole"
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CS "Velikost Obrazovky VMU 1"
#define OPTION_VAL_1X_CS NULL
#define OPTION_VAL_3X_CS NULL
#define OPTION_VAL_5X_CS NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CS "Zapnout Barvu Pixelu Obrazovky VMU 1"
#define OPTION_VAL_DEFAULT_ON_00_CS "Výchozí ON"
#define OPTION_VAL_DEFAULT_OFF_01_CS "Výchozí OFF"
#define OPTION_VAL_BLACK_02_CS "Černá"
#define OPTION_VAL_LIGHT_BLUE_04_CS "Světle Modrá"
#define OPTION_VAL_CYAN_06_CS "Azurová"
#define OPTION_VAL_CYAN_BLUE_07_CS "Azurově Modrá"
#define OPTION_VAL_LIGHT_GREEN_08_CS "Světle Zelená"
#define OPTION_VAL_CYAN_GREEN_09_CS "Azurově Zelená"
#define OPTION_VAL_LIGHT_CYAN_10_CS "Světle Azurová"
#define OPTION_VAL_PURPLE_12_CS "Fialová"
#define OPTION_VAL_LIGHT_PURPLE_13_CS "Světle Fialová"
#define OPTION_VAL_YELLOW_14_CS "Žlutá"
#define OPTION_VAL_GRAY_15_CS "Šedá"
#define OPTION_VAL_LIGHT_PURPLE_2_16_CS "Světle Fialová (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_CS "Světle Zelená (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_CS "Světle Zelená (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_CS "Světle Azurová (2)"
#define OPTION_VAL_LIGHT_RED_2_20_CS "Světle Červená (2)"
#define OPTION_VAL_MAGENTA_21_CS "Purpurová"
#define OPTION_VAL_LIGHT_PURPLE_3_22_CS "Světle Fialová (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_CS "Světle Oranžová"
#define OPTION_VAL_ORANGE_24_CS "Oranžová"
#define OPTION_VAL_LIGHT_PURPLE_4_25_CS "Světle Fialová (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_CS "Světle Žlutá"
#define OPTION_VAL_LIGHT_YELLOW_2_27_CS "Světle Žlutá (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CS "Vypnout Barvu Pixelu Obrazovky VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CS "Průhlednost Obrazovky VMU 1"
#define OPTION_VAL_40_CS NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CS "Displej Obrazovky VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CS "Pozice Obrazovky VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CS "Velikost Obrazovky VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CS "Zapnout Barvu Pixelu Obrazovky VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CS "Vypnout Barvu Pixelu Obrazovky VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CS "Průhlednost Obrazovky VMU 2"
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CS "Displej Obrazovky VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CS "Pozice Obrazovky VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CS "Velikost Obrazovky VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CS "Zapnout Barvu Pixelu Obrazovky VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CS "Vypnout Barvu Pixelu Obrazovky VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CS "Průhlednost Obrazovky VMU 3"
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CS "Displej Obrazovky VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CS "Pozice Obrazovky VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CS "Velikost Obrazovky VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CS "Zapnout Barvu Pixelu Obrazovky VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CS "Vypnout Barvu Pixelu Obrazovky VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CS "Průhlednost Obrazovky VMU 4"

struct retro_core_option_v2_category option_cats_cs[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CS,
      CATEGORY_SYSTEM_INFO_0_CS
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CS,
      CATEGORY_VIDEO_INFO_0_CS
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_CS,
      CATEGORY_PERFORMANCE_INFO_0_CS
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CS,
      CATEGORY_HACKS_INFO_0_CS
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CS,
      CATEGORY_INPUT_INFO_0_CS
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_CS,
      CATEGORY_EXPANSIONS_INFO_0_CS
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_CS,
      CATEGORY_VMU_INFO_0_CS
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cs[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_CS,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_CS },
         { "USA",     OPTION_VAL_USA_CS },
         { "Europe",  OPTION_VAL_EUROPE_CS },
         { "Default", OPTION_VAL_DEFAULT_CS },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_CS,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_CS },
         { "English",  OPTION_VAL_ENGLISH_CS },
         { "German",   OPTION_VAL_GERMAN_CS },
         { "French",   OPTION_VAL_FRENCH_CS },
         { "Spanish",  OPTION_VAL_SPANISH_CS },
         { "Italian",  OPTION_VAL_ITALIAN_CS },
         { "Default",  OPTION_VAL_DEFAULT_CS },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_CS,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CS,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_CS },
         { "640x480",    OPTION_VAL_640X480_CS },
         { "800x600",    OPTION_VAL_800X600_CS },
         { "960x720",    OPTION_VAL_960X720_CS },
         { "1024x768",   OPTION_VAL_1024X768_CS },
         { "1280x960",   OPTION_VAL_1280X960_CS },
         { "1440x1080",  OPTION_VAL_1440X1080_CS },
         { "1600x1200",  OPTION_VAL_1600X1200_CS },
         { "1920x1440",  OPTION_VAL_1920X1440_CS },
         { "2560x1920",  OPTION_VAL_2560X1920_CS },
         { "2880x2160",  OPTION_VAL_2880X2160_CS },
         { "3200x2400",  OPTION_VAL_3200X2400_CS },
         { "3840x2880",  OPTION_VAL_3840X2880_CS },
         { "4480x3360",  OPTION_VAL_4480X3360_CS },
         { "5120x3840",  OPTION_VAL_5120X3840_CS },
         { "5760x4320",  OPTION_VAL_5760X4320_CS },
         { "6400x4800",  OPTION_VAL_6400X4800_CS },
         { "7040x5280",  OPTION_VAL_7040X5280_CS },
         { "7680x5760",  OPTION_VAL_7680X5760_CS },
         { "8320x6240",  OPTION_VAL_8320X6240_CS },
         { "8960x6720",  OPTION_VAL_8960X6720_CS },
         { "9600x7200",  OPTION_VAL_9600X7200_CS },
         { "10240x7680", OPTION_VAL_10240X7680_CS },
         { "10880x8160", OPTION_VAL_10880X8160_CS },
         { "11520x8640", OPTION_VAL_11520X8640_CS },
         { "12160x9120", OPTION_VAL_12160X9120_CS },
         { "12800x9600", OPTION_VAL_12800X9600_CS },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CS,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_CS },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_CS },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_CS },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_CS,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_CS },
         { "PAL",     OPTION_VAL_PAL_CS },
         { "PAL_N",   OPTION_VAL_PAL_N_CS },
         { "PAL_M",   OPTION_VAL_PAL_M_CS },
         { "Default", OPTION_VAL_DEFAULT_CS },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CS,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_CS },
         { "vertical",   OPTION_VAL_VERTICAL_CS },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CS,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CS },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_CS },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_CS },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CS,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_CS },
         { "1GB",   OPTION_VAL_1GB_CS },
         { "2GB",   OPTION_VAL_2GB_CS },
         { "4GB",   OPTION_VAL_4GB_CS },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CS,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_CS,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CS,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CS,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_CS },
         { "1",  OPTION_VAL_1_CS },
         { "2",  OPTION_VAL_2_CS },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CS,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CS,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_CS },
         { "4",  OPTION_VAL_4_CS },
         { "6",  OPTION_VAL_6_CS },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CS,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CS,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CS,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CS,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CS,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CS,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CS,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_CS },
         { "more", OPTION_VAL_MORE_CS },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CS,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CS },
         { "110", OPTION_VAL_110_CS },
         { "120", OPTION_VAL_120_CS },
         { "130", OPTION_VAL_130_CS },
         { "140", OPTION_VAL_140_CS },
         { "150", OPTION_VAL_150_CS },
         { "160", OPTION_VAL_160_CS },
         { "170", OPTION_VAL_170_CS },
         { "180", OPTION_VAL_180_CS },
         { "190", OPTION_VAL_190_CS },
         { "200", OPTION_VAL_200_CS },
         { "210", OPTION_VAL_210_CS },
         { "220", OPTION_VAL_220_CS },
         { "230", OPTION_VAL_230_CS },
         { "240", OPTION_VAL_240_CS },
         { "250", OPTION_VAL_250_CS },
         { "260", OPTION_VAL_260_CS },
         { "270", OPTION_VAL_270_CS },
         { "280", OPTION_VAL_280_CS },
         { "290", OPTION_VAL_290_CS },
         { "300", OPTION_VAL_300_CS },
         { "310", OPTION_VAL_310_CS },
         { "320", OPTION_VAL_320_CS },
         { "330", OPTION_VAL_330_CS },
         { "340", OPTION_VAL_340_CS },
         { "350", OPTION_VAL_350_CS },
         { "360", OPTION_VAL_360_CS },
         { "370", OPTION_VAL_370_CS },
         { "380", OPTION_VAL_380_CS },
         { "390", OPTION_VAL_390_CS },
         { "400", OPTION_VAL_400_CS },
         { "410", OPTION_VAL_410_CS },
         { "420", OPTION_VAL_420_CS },
         { "430", OPTION_VAL_430_CS },
         { "440", OPTION_VAL_440_CS },
         { "450", OPTION_VAL_450_CS },
         { "460", OPTION_VAL_460_CS },
         { "470", OPTION_VAL_470_CS },
         { "480", OPTION_VAL_480_CS },
         { "490", OPTION_VAL_490_CS },
         { "500", OPTION_VAL_500_CS },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CS,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CS,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CS },
         { "5%",  OPTION_VAL_5_CS },
         { "10%", OPTION_VAL_10_CS },
         { "15%", OPTION_VAL_15_CS },
         { "20%", OPTION_VAL_20_CS },
         { "25%", OPTION_VAL_25_CS },
         { "30%", OPTION_VAL_30_CS },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CS,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CS },
         { "5%",  OPTION_VAL_5_CS },
         { "10%", OPTION_VAL_10_CS },
         { "15%", OPTION_VAL_15_CS },
         { "20%", OPTION_VAL_20_CS },
         { "25%", OPTION_VAL_25_CS },
         { "30%", OPTION_VAL_30_CS },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CS,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CS,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_CS },
         { "60%",  OPTION_VAL_60_CS },
         { "70%",  OPTION_VAL_70_CS },
         { "80%",  OPTION_VAL_80_CS },
         { "90%",  OPTION_VAL_90_CS },
         { "100%", OPTION_VAL_100_O46_CS },
         { "110%", OPTION_VAL_110_O46_CS },
         { "120%", OPTION_VAL_120_O46_CS },
         { "130%", OPTION_VAL_130_O46_CS },
         { "140%", OPTION_VAL_140_O46_CS },
         { "150%", OPTION_VAL_150_O46_CS },
         { "160%", OPTION_VAL_160_O46_CS },
         { "170%", OPTION_VAL_170_O46_CS },
         { "180%", OPTION_VAL_180_O46_CS },
         { "190%", OPTION_VAL_190_O46_CS },
         { "200%", OPTION_VAL_200_O46_CS },
         { "210%", OPTION_VAL_210_O46_CS },
         { "220%", OPTION_VAL_220_O46_CS },
         { "230%", OPTION_VAL_230_O46_CS },
         { "240%", OPTION_VAL_240_O46_CS },
         { "250%", OPTION_VAL_250_O46_CS },
         { "260%", OPTION_VAL_260_O46_CS },
         { "270%", OPTION_VAL_270_O46_CS },
         { "280%", OPTION_VAL_280_O46_CS },
         { "290%", OPTION_VAL_290_O46_CS },
         { "300%", OPTION_VAL_300_O46_CS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CS },
         { "Red",      OPTION_VAL_RED_CS },
         { "Green",    OPTION_VAL_GREEN_CS },
         { "Blue",     OPTION_VAL_BLUE_CS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CS },
         { "Red",      OPTION_VAL_RED_CS },
         { "Green",    OPTION_VAL_GREEN_CS },
         { "Blue",     OPTION_VAL_BLUE_CS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CS },
         { "Red",      OPTION_VAL_RED_CS },
         { "Green",    OPTION_VAL_GREEN_CS },
         { "Blue",     OPTION_VAL_BLUE_CS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CS,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CS },
         { "Red",      OPTION_VAL_RED_CS },
         { "Green",    OPTION_VAL_GREEN_CS },
         { "Blue",     OPTION_VAL_BLUE_CS },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CS,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CS,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CS },
         { "Purupuru", OPTION_VAL_PURUPURU_CS },
         { "None",     OPTION_VAL_NONE_CS },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CS,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CS,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CS,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_CS },
         { "All VMUs", OPTION_VAL_ALL_VMUS_CS },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CS,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CS,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_CS,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CS,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CS,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CS,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CS },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CS },
         { "2x", OPTION_VAL_2_O27_CS },
         { "3x", OPTION_VAL_3X_CS },
         { "4x", OPTION_VAL_4_CS },
         { "5x", OPTION_VAL_5X_CS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CS },
         { "20%",  OPTION_VAL_20_CS },
         { "30%",  OPTION_VAL_30_CS },
         { "40%",  OPTION_VAL_40_CS },
         { "50%",  OPTION_VAL_50_CS },
         { "60%",  OPTION_VAL_60_CS },
         { "70%",  OPTION_VAL_70_CS },
         { "80%",  OPTION_VAL_80_CS },
         { "90%",  OPTION_VAL_90_CS },
         { "100%", OPTION_VAL_100_O46_CS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CS },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CS },
         { "2x", OPTION_VAL_2_O27_CS },
         { "3x", OPTION_VAL_3X_CS },
         { "4x", OPTION_VAL_4_CS },
         { "5x", OPTION_VAL_5X_CS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CS },
         { "20%",  OPTION_VAL_20_CS },
         { "30%",  OPTION_VAL_30_CS },
         { "40%",  OPTION_VAL_40_CS },
         { "50%",  OPTION_VAL_50_CS },
         { "60%",  OPTION_VAL_60_CS },
         { "70%",  OPTION_VAL_70_CS },
         { "80%",  OPTION_VAL_80_CS },
         { "90%",  OPTION_VAL_90_CS },
         { "100%", OPTION_VAL_100_O46_CS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CS },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CS },
         { "2x", OPTION_VAL_2_O27_CS },
         { "3x", OPTION_VAL_3X_CS },
         { "4x", OPTION_VAL_4_CS },
         { "5x", OPTION_VAL_5X_CS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CS },
         { "20%",  OPTION_VAL_20_CS },
         { "30%",  OPTION_VAL_30_CS },
         { "40%",  OPTION_VAL_40_CS },
         { "50%",  OPTION_VAL_50_CS },
         { "60%",  OPTION_VAL_60_CS },
         { "70%",  OPTION_VAL_70_CS },
         { "80%",  OPTION_VAL_80_CS },
         { "90%",  OPTION_VAL_90_CS },
         { "100%", OPTION_VAL_100_O46_CS },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CS },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CS },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CS },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CS },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CS },
         { "2x", OPTION_VAL_2_O27_CS },
         { "3x", OPTION_VAL_3X_CS },
         { "4x", OPTION_VAL_4_CS },
         { "5x", OPTION_VAL_5X_CS },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CS },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CS },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CS },
         { "BLUE 03",           OPTION_VAL_BLUE_CS },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CS },
         { "GREEN 05",          OPTION_VAL_GREEN_CS },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CS },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CS },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CS },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CS },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CS },
         { "RED 11",            OPTION_VAL_RED_CS },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CS },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CS },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CS },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CS },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CS },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CS },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CS },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CS },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CS },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CS },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CS },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CS },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CS },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CS },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CS },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CS },
         { "WHITE 28",          OPTION_VAL_WHITE_CS },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CS,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CS },
         { "20%",  OPTION_VAL_20_CS },
         { "30%",  OPTION_VAL_30_CS },
         { "40%",  OPTION_VAL_40_CS },
         { "50%",  OPTION_VAL_50_CS },
         { "60%",  OPTION_VAL_60_CS },
         { "70%",  OPTION_VAL_70_CS },
         { "80%",  OPTION_VAL_80_CS },
         { "90%",  OPTION_VAL_90_CS },
         { "100%", OPTION_VAL_100_O46_CS },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cs = {
   option_cats_cs,
   option_defs_cs
};

/* RETRO_LANGUAGE_CY */

#define CATEGORY_SYSTEM_LABEL_CY NULL
#define CATEGORY_SYSTEM_INFO_0_CY NULL
#define CATEGORY_VIDEO_LABEL_CY NULL
#define CATEGORY_VIDEO_INFO_0_CY NULL
#define CATEGORY_PERFORMANCE_LABEL_CY NULL
#define CATEGORY_PERFORMANCE_INFO_0_CY NULL
#define CATEGORY_HACKS_LABEL_CY NULL
#define CATEGORY_HACKS_INFO_0_CY NULL
#define CATEGORY_INPUT_LABEL_CY "Mewnbwn"
#define CATEGORY_INPUT_INFO_0_CY NULL
#define CATEGORY_EXPANSIONS_LABEL_CY NULL
#define CATEGORY_EXPANSIONS_INFO_0_CY NULL
#define CATEGORY_VMU_LABEL_CY NULL
#define CATEGORY_VMU_INFO_0_CY NULL
#define CORE_OPTION_NAME_REGION_LABEL_CY NULL
#define OPTION_VAL_JAPAN_CY NULL
#define OPTION_VAL_USA_CY NULL
#define OPTION_VAL_EUROPE_CY NULL
#define OPTION_VAL_DEFAULT_CY NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_CY NULL
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_CY NULL
#define OPTION_VAL_JAPANESE_CY NULL
#define OPTION_VAL_ENGLISH_CY NULL
#define OPTION_VAL_GERMAN_CY NULL
#define OPTION_VAL_FRENCH_CY NULL
#define OPTION_VAL_SPANISH_CY NULL
#define OPTION_VAL_ITALIAN_CY NULL
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_CY NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_CY NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CY NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CY NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_CY NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CY NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CY NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CY NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CY NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CY NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_CY NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CY NULL
#define CORE_OPTION_NAME_UPNP_LABEL_CY NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_CY NULL
#define CORE_OPTION_NAME_DCNET_LABEL_CY NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_CY NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CY NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CY NULL
#define OPTION_VAL_320X240_CY NULL
#define OPTION_VAL_640X480_CY NULL
#define OPTION_VAL_800X600_CY NULL
#define OPTION_VAL_960X720_CY NULL
#define OPTION_VAL_1024X768_CY NULL
#define OPTION_VAL_1280X960_CY NULL
#define OPTION_VAL_1440X1080_CY NULL
#define OPTION_VAL_1600X1200_CY NULL
#define OPTION_VAL_1920X1440_CY NULL
#define OPTION_VAL_2560X1920_CY NULL
#define OPTION_VAL_2880X2160_CY NULL
#define OPTION_VAL_3200X2400_CY NULL
#define OPTION_VAL_3840X2880_CY NULL
#define OPTION_VAL_4480X3360_CY NULL
#define OPTION_VAL_5120X3840_CY NULL
#define OPTION_VAL_5760X4320_CY NULL
#define OPTION_VAL_6400X4800_CY NULL
#define OPTION_VAL_7040X5280_CY NULL
#define OPTION_VAL_7680X5760_CY NULL
#define OPTION_VAL_8320X6240_CY NULL
#define OPTION_VAL_8960X6720_CY NULL
#define OPTION_VAL_9600X7200_CY NULL
#define OPTION_VAL_10240X7680_CY NULL
#define OPTION_VAL_10880X8160_CY NULL
#define OPTION_VAL_11520X8640_CY NULL
#define OPTION_VAL_12160X9120_CY NULL
#define OPTION_VAL_12800X9600_CY NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_CY NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CY NULL
#define OPTION_VAL_VGA_CY NULL
#define OPTION_VAL_TV_RGB_CY NULL
#define OPTION_VAL_TV_COMPOSITE_CY NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_CY NULL
#define OPTION_VAL_NTSC_CY NULL
#define OPTION_VAL_PAL_CY NULL
#define OPTION_VAL_PAL_N_CY NULL
#define OPTION_VAL_PAL_M_CY NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CY NULL
#define OPTION_VAL_HORIZONTAL_CY NULL
#define OPTION_VAL_VERTICAL_CY NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CY NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CY NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CY NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_CY NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_CY NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CY NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CY NULL
#define OPTION_VAL_512MB_CY NULL
#define OPTION_VAL_1GB_CY NULL
#define OPTION_VAL_2GB_CY NULL
#define OPTION_VAL_4GB_CY NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_CY NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CY NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CY NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CY NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CY NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CY NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_CY NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_CY NULL
#define CORE_OPTION_NAME_FOG_LABEL_CY NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CY NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CY NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CY NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CY NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CY NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CY NULL
#define OPTION_VAL_1_CY NULL
#define OPTION_VAL_2_CY NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CY NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CY NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CY NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CY NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CY NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CY NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_CY NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CY NULL
#define OPTION_VAL_2_O27_CY NULL
#define OPTION_VAL_4_CY NULL
#define OPTION_VAL_6_CY NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CY NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CY NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CY NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CY NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CY NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CY NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CY NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CY NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CY NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CY NULL
#define OPTION_VAL_SOME_CY NULL
#define OPTION_VAL_MORE_CY NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CY NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CY NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CY NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CY NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CY NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CY NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CY NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CY NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CY NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CY NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_CY NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_CY NULL
#define OPTION_VAL_100_CY NULL
#define OPTION_VAL_110_CY NULL
#define OPTION_VAL_120_CY NULL
#define OPTION_VAL_130_CY NULL
#define OPTION_VAL_140_CY NULL
#define OPTION_VAL_150_CY NULL
#define OPTION_VAL_160_CY NULL
#define OPTION_VAL_170_CY NULL
#define OPTION_VAL_180_CY NULL
#define OPTION_VAL_190_CY NULL
#define OPTION_VAL_200_CY NULL
#define OPTION_VAL_210_CY NULL
#define OPTION_VAL_220_CY NULL
#define OPTION_VAL_230_CY NULL
#define OPTION_VAL_240_CY NULL
#define OPTION_VAL_250_CY NULL
#define OPTION_VAL_260_CY NULL
#define OPTION_VAL_270_CY NULL
#define OPTION_VAL_280_CY NULL
#define OPTION_VAL_290_CY NULL
#define OPTION_VAL_300_CY NULL
#define OPTION_VAL_310_CY NULL
#define OPTION_VAL_320_CY NULL
#define OPTION_VAL_330_CY NULL
#define OPTION_VAL_340_CY NULL
#define OPTION_VAL_350_CY NULL
#define OPTION_VAL_360_CY NULL
#define OPTION_VAL_370_CY NULL
#define OPTION_VAL_380_CY NULL
#define OPTION_VAL_390_CY NULL
#define OPTION_VAL_400_CY NULL
#define OPTION_VAL_410_CY NULL
#define OPTION_VAL_420_CY NULL
#define OPTION_VAL_430_CY NULL
#define OPTION_VAL_440_CY NULL
#define OPTION_VAL_450_CY NULL
#define OPTION_VAL_460_CY NULL
#define OPTION_VAL_470_CY NULL
#define OPTION_VAL_480_CY NULL
#define OPTION_VAL_490_CY NULL
#define OPTION_VAL_500_CY NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CY NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CY NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CY NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CY NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CY NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CY NULL
#define OPTION_VAL_0_CY NULL
#define OPTION_VAL_5_CY NULL
#define OPTION_VAL_10_CY NULL
#define OPTION_VAL_15_CY NULL
#define OPTION_VAL_20_CY NULL
#define OPTION_VAL_25_CY NULL
#define OPTION_VAL_30_CY NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CY NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CY NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CY NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CY NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CY NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CY NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CY NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CY NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CY NULL
#define OPTION_VAL_50_CY NULL
#define OPTION_VAL_60_CY NULL
#define OPTION_VAL_70_CY NULL
#define OPTION_VAL_80_CY NULL
#define OPTION_VAL_90_CY NULL
#define OPTION_VAL_100_O46_CY NULL
#define OPTION_VAL_110_O46_CY NULL
#define OPTION_VAL_120_O46_CY NULL
#define OPTION_VAL_130_O46_CY NULL
#define OPTION_VAL_140_O46_CY NULL
#define OPTION_VAL_150_O46_CY NULL
#define OPTION_VAL_160_O46_CY NULL
#define OPTION_VAL_170_O46_CY NULL
#define OPTION_VAL_180_O46_CY NULL
#define OPTION_VAL_190_O46_CY NULL
#define OPTION_VAL_200_O46_CY NULL
#define OPTION_VAL_210_O46_CY NULL
#define OPTION_VAL_220_O46_CY NULL
#define OPTION_VAL_230_O46_CY NULL
#define OPTION_VAL_240_O46_CY NULL
#define OPTION_VAL_250_O46_CY NULL
#define OPTION_VAL_260_O46_CY NULL
#define OPTION_VAL_270_O46_CY NULL
#define OPTION_VAL_280_O46_CY NULL
#define OPTION_VAL_290_O46_CY NULL
#define OPTION_VAL_300_O46_CY NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CY NULL
#define OPTION_VAL_WHITE_CY NULL
#define OPTION_VAL_RED_CY "Coch"
#define OPTION_VAL_GREEN_CY NULL
#define OPTION_VAL_BLUE_CY NULL
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CY NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CY NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CY NULL
#define OPTION_VAL_VMU_CY NULL
#define OPTION_VAL_PURUPURU_CY NULL
#define OPTION_VAL_NONE_CY "Dim"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CY NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CY NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CY NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CY NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CY NULL
#define OPTION_VAL_VMU_A1_CY NULL
#define OPTION_VAL_ALL_VMUS_CY NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CY NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_CY NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CY NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CY NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CY NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CY NULL
#define OPTION_VAL_UPPER_LEFT_CY NULL
#define OPTION_VAL_UPPER_RIGHT_CY NULL
#define OPTION_VAL_LOWER_LEFT_CY NULL
#define OPTION_VAL_LOWER_RIGHT_CY NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CY NULL
#define OPTION_VAL_1X_CY NULL
#define OPTION_VAL_3X_CY NULL
#define OPTION_VAL_5X_CY NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CY NULL
#define OPTION_VAL_DEFAULT_ON_00_CY NULL
#define OPTION_VAL_DEFAULT_OFF_01_CY NULL
#define OPTION_VAL_BLACK_02_CY NULL
#define OPTION_VAL_LIGHT_BLUE_04_CY NULL
#define OPTION_VAL_CYAN_06_CY NULL
#define OPTION_VAL_CYAN_BLUE_07_CY NULL
#define OPTION_VAL_LIGHT_GREEN_08_CY NULL
#define OPTION_VAL_CYAN_GREEN_09_CY NULL
#define OPTION_VAL_LIGHT_CYAN_10_CY NULL
#define OPTION_VAL_PURPLE_12_CY NULL
#define OPTION_VAL_LIGHT_PURPLE_13_CY NULL
#define OPTION_VAL_YELLOW_14_CY NULL
#define OPTION_VAL_GRAY_15_CY NULL
#define OPTION_VAL_LIGHT_PURPLE_2_16_CY NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_CY NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_CY NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_CY NULL
#define OPTION_VAL_LIGHT_RED_2_20_CY NULL
#define OPTION_VAL_MAGENTA_21_CY NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_CY NULL
#define OPTION_VAL_LIGHT_ORANGE_23_CY NULL
#define OPTION_VAL_ORANGE_24_CY NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_CY NULL
#define OPTION_VAL_LIGHT_YELLOW_26_CY NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_CY NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CY NULL
#define OPTION_VAL_40_CY NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CY NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CY NULL

struct retro_core_option_v2_category option_cats_cy[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_CY,
      CATEGORY_SYSTEM_INFO_0_CY
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_CY,
      CATEGORY_VIDEO_INFO_0_CY
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_CY,
      CATEGORY_PERFORMANCE_INFO_0_CY
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_CY,
      CATEGORY_HACKS_INFO_0_CY
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_CY,
      CATEGORY_INPUT_INFO_0_CY
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_CY,
      CATEGORY_EXPANSIONS_INFO_0_CY
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_CY,
      CATEGORY_VMU_INFO_0_CY
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_cy[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_CY,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_CY },
         { "USA",     OPTION_VAL_USA_CY },
         { "Europe",  OPTION_VAL_EUROPE_CY },
         { "Default", OPTION_VAL_DEFAULT_CY },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_CY,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_CY },
         { "English",  OPTION_VAL_ENGLISH_CY },
         { "German",   OPTION_VAL_GERMAN_CY },
         { "French",   OPTION_VAL_FRENCH_CY },
         { "Spanish",  OPTION_VAL_SPANISH_CY },
         { "Italian",  OPTION_VAL_ITALIAN_CY },
         { "Default",  OPTION_VAL_DEFAULT_CY },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_CY,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_CY,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_CY },
         { "640x480",    OPTION_VAL_640X480_CY },
         { "800x600",    OPTION_VAL_800X600_CY },
         { "960x720",    OPTION_VAL_960X720_CY },
         { "1024x768",   OPTION_VAL_1024X768_CY },
         { "1280x960",   OPTION_VAL_1280X960_CY },
         { "1440x1080",  OPTION_VAL_1440X1080_CY },
         { "1600x1200",  OPTION_VAL_1600X1200_CY },
         { "1920x1440",  OPTION_VAL_1920X1440_CY },
         { "2560x1920",  OPTION_VAL_2560X1920_CY },
         { "2880x2160",  OPTION_VAL_2880X2160_CY },
         { "3200x2400",  OPTION_VAL_3200X2400_CY },
         { "3840x2880",  OPTION_VAL_3840X2880_CY },
         { "4480x3360",  OPTION_VAL_4480X3360_CY },
         { "5120x3840",  OPTION_VAL_5120X3840_CY },
         { "5760x4320",  OPTION_VAL_5760X4320_CY },
         { "6400x4800",  OPTION_VAL_6400X4800_CY },
         { "7040x5280",  OPTION_VAL_7040X5280_CY },
         { "7680x5760",  OPTION_VAL_7680X5760_CY },
         { "8320x6240",  OPTION_VAL_8320X6240_CY },
         { "8960x6720",  OPTION_VAL_8960X6720_CY },
         { "9600x7200",  OPTION_VAL_9600X7200_CY },
         { "10240x7680", OPTION_VAL_10240X7680_CY },
         { "10880x8160", OPTION_VAL_10880X8160_CY },
         { "11520x8640", OPTION_VAL_11520X8640_CY },
         { "12160x9120", OPTION_VAL_12160X9120_CY },
         { "12800x9600", OPTION_VAL_12800X9600_CY },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_CY,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_CY },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_CY },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_CY },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_CY,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_CY },
         { "PAL",     OPTION_VAL_PAL_CY },
         { "PAL_N",   OPTION_VAL_PAL_N_CY },
         { "PAL_M",   OPTION_VAL_PAL_M_CY },
         { "Default", OPTION_VAL_DEFAULT_CY },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_CY,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_CY },
         { "vertical",   OPTION_VAL_VERTICAL_CY },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_CY,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_CY },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_CY },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_CY },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_CY,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_CY },
         { "1GB",   OPTION_VAL_1GB_CY },
         { "2GB",   OPTION_VAL_2GB_CY },
         { "4GB",   OPTION_VAL_4GB_CY },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_CY,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_CY,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_CY,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_CY,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_CY },
         { "1",  OPTION_VAL_1_CY },
         { "2",  OPTION_VAL_2_CY },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_CY,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_CY,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_CY },
         { "4",  OPTION_VAL_4_CY },
         { "6",  OPTION_VAL_6_CY },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_CY,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_CY,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_CY,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_CY,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_CY,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_CY,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_CY,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_CY },
         { "more", OPTION_VAL_MORE_CY },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_CY,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_CY },
         { "110", OPTION_VAL_110_CY },
         { "120", OPTION_VAL_120_CY },
         { "130", OPTION_VAL_130_CY },
         { "140", OPTION_VAL_140_CY },
         { "150", OPTION_VAL_150_CY },
         { "160", OPTION_VAL_160_CY },
         { "170", OPTION_VAL_170_CY },
         { "180", OPTION_VAL_180_CY },
         { "190", OPTION_VAL_190_CY },
         { "200", OPTION_VAL_200_CY },
         { "210", OPTION_VAL_210_CY },
         { "220", OPTION_VAL_220_CY },
         { "230", OPTION_VAL_230_CY },
         { "240", OPTION_VAL_240_CY },
         { "250", OPTION_VAL_250_CY },
         { "260", OPTION_VAL_260_CY },
         { "270", OPTION_VAL_270_CY },
         { "280", OPTION_VAL_280_CY },
         { "290", OPTION_VAL_290_CY },
         { "300", OPTION_VAL_300_CY },
         { "310", OPTION_VAL_310_CY },
         { "320", OPTION_VAL_320_CY },
         { "330", OPTION_VAL_330_CY },
         { "340", OPTION_VAL_340_CY },
         { "350", OPTION_VAL_350_CY },
         { "360", OPTION_VAL_360_CY },
         { "370", OPTION_VAL_370_CY },
         { "380", OPTION_VAL_380_CY },
         { "390", OPTION_VAL_390_CY },
         { "400", OPTION_VAL_400_CY },
         { "410", OPTION_VAL_410_CY },
         { "420", OPTION_VAL_420_CY },
         { "430", OPTION_VAL_430_CY },
         { "440", OPTION_VAL_440_CY },
         { "450", OPTION_VAL_450_CY },
         { "460", OPTION_VAL_460_CY },
         { "470", OPTION_VAL_470_CY },
         { "480", OPTION_VAL_480_CY },
         { "490", OPTION_VAL_490_CY },
         { "500", OPTION_VAL_500_CY },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_CY,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_CY,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CY },
         { "5%",  OPTION_VAL_5_CY },
         { "10%", OPTION_VAL_10_CY },
         { "15%", OPTION_VAL_15_CY },
         { "20%", OPTION_VAL_20_CY },
         { "25%", OPTION_VAL_25_CY },
         { "30%", OPTION_VAL_30_CY },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_CY,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_CY },
         { "5%",  OPTION_VAL_5_CY },
         { "10%", OPTION_VAL_10_CY },
         { "15%", OPTION_VAL_15_CY },
         { "20%", OPTION_VAL_20_CY },
         { "25%", OPTION_VAL_25_CY },
         { "30%", OPTION_VAL_30_CY },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_CY,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_CY,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_CY,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_CY },
         { "60%",  OPTION_VAL_60_CY },
         { "70%",  OPTION_VAL_70_CY },
         { "80%",  OPTION_VAL_80_CY },
         { "90%",  OPTION_VAL_90_CY },
         { "100%", OPTION_VAL_100_O46_CY },
         { "110%", OPTION_VAL_110_O46_CY },
         { "120%", OPTION_VAL_120_O46_CY },
         { "130%", OPTION_VAL_130_O46_CY },
         { "140%", OPTION_VAL_140_O46_CY },
         { "150%", OPTION_VAL_150_O46_CY },
         { "160%", OPTION_VAL_160_O46_CY },
         { "170%", OPTION_VAL_170_O46_CY },
         { "180%", OPTION_VAL_180_O46_CY },
         { "190%", OPTION_VAL_190_O46_CY },
         { "200%", OPTION_VAL_200_O46_CY },
         { "210%", OPTION_VAL_210_O46_CY },
         { "220%", OPTION_VAL_220_O46_CY },
         { "230%", OPTION_VAL_230_O46_CY },
         { "240%", OPTION_VAL_240_O46_CY },
         { "250%", OPTION_VAL_250_O46_CY },
         { "260%", OPTION_VAL_260_O46_CY },
         { "270%", OPTION_VAL_270_O46_CY },
         { "280%", OPTION_VAL_280_O46_CY },
         { "290%", OPTION_VAL_290_O46_CY },
         { "300%", OPTION_VAL_300_O46_CY },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_CY,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CY },
         { "Red",      OPTION_VAL_RED_CY },
         { "Green",    OPTION_VAL_GREEN_CY },
         { "Blue",     OPTION_VAL_BLUE_CY },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_CY,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CY },
         { "Red",      OPTION_VAL_RED_CY },
         { "Green",    OPTION_VAL_GREEN_CY },
         { "Blue",     OPTION_VAL_BLUE_CY },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_CY,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CY },
         { "Red",      OPTION_VAL_RED_CY },
         { "Green",    OPTION_VAL_GREEN_CY },
         { "Blue",     OPTION_VAL_BLUE_CY },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_CY,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_CY },
         { "Red",      OPTION_VAL_RED_CY },
         { "Green",    OPTION_VAL_GREEN_CY },
         { "Blue",     OPTION_VAL_BLUE_CY },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_CY,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_CY,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_CY },
         { "Purupuru", OPTION_VAL_PURUPURU_CY },
         { "None",     OPTION_VAL_NONE_CY },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CY,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_CY,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_CY,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_CY },
         { "All VMUs", OPTION_VAL_ALL_VMUS_CY },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CY,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_CY,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_CY,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CY,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_CY,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_CY,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CY },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CY },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CY },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CY },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CY },
         { "2x", OPTION_VAL_2_O27_CY },
         { "3x", OPTION_VAL_3X_CY },
         { "4x", OPTION_VAL_4_CY },
         { "5x", OPTION_VAL_5X_CY },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CY },
         { "20%",  OPTION_VAL_20_CY },
         { "30%",  OPTION_VAL_30_CY },
         { "40%",  OPTION_VAL_40_CY },
         { "50%",  OPTION_VAL_50_CY },
         { "60%",  OPTION_VAL_60_CY },
         { "70%",  OPTION_VAL_70_CY },
         { "80%",  OPTION_VAL_80_CY },
         { "90%",  OPTION_VAL_90_CY },
         { "100%", OPTION_VAL_100_O46_CY },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CY },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CY },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CY },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CY },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CY },
         { "2x", OPTION_VAL_2_O27_CY },
         { "3x", OPTION_VAL_3X_CY },
         { "4x", OPTION_VAL_4_CY },
         { "5x", OPTION_VAL_5X_CY },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CY },
         { "20%",  OPTION_VAL_20_CY },
         { "30%",  OPTION_VAL_30_CY },
         { "40%",  OPTION_VAL_40_CY },
         { "50%",  OPTION_VAL_50_CY },
         { "60%",  OPTION_VAL_60_CY },
         { "70%",  OPTION_VAL_70_CY },
         { "80%",  OPTION_VAL_80_CY },
         { "90%",  OPTION_VAL_90_CY },
         { "100%", OPTION_VAL_100_O46_CY },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CY },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CY },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CY },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CY },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CY },
         { "2x", OPTION_VAL_2_O27_CY },
         { "3x", OPTION_VAL_3X_CY },
         { "4x", OPTION_VAL_4_CY },
         { "5x", OPTION_VAL_5X_CY },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CY },
         { "20%",  OPTION_VAL_20_CY },
         { "30%",  OPTION_VAL_30_CY },
         { "40%",  OPTION_VAL_40_CY },
         { "50%",  OPTION_VAL_50_CY },
         { "60%",  OPTION_VAL_60_CY },
         { "70%",  OPTION_VAL_70_CY },
         { "80%",  OPTION_VAL_80_CY },
         { "90%",  OPTION_VAL_90_CY },
         { "100%", OPTION_VAL_100_O46_CY },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_CY },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_CY },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_CY },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_CY },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_CY },
         { "2x", OPTION_VAL_2_O27_CY },
         { "3x", OPTION_VAL_3X_CY },
         { "4x", OPTION_VAL_4_CY },
         { "5x", OPTION_VAL_5X_CY },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_CY },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_CY },
         { "BLACK 02",          OPTION_VAL_BLACK_02_CY },
         { "BLUE 03",           OPTION_VAL_BLUE_CY },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_CY },
         { "GREEN 05",          OPTION_VAL_GREEN_CY },
         { "CYAN 06",           OPTION_VAL_CYAN_06_CY },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_CY },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_CY },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_CY },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_CY },
         { "RED 11",            OPTION_VAL_RED_CY },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_CY },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_CY },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_CY },
         { "GRAY 15",           OPTION_VAL_GRAY_15_CY },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_CY },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_CY },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_CY },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_CY },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_CY },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_CY },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_CY },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_CY },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_CY },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_CY },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_CY },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_CY },
         { "WHITE 28",          OPTION_VAL_WHITE_CY },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_CY,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_CY },
         { "20%",  OPTION_VAL_20_CY },
         { "30%",  OPTION_VAL_30_CY },
         { "40%",  OPTION_VAL_40_CY },
         { "50%",  OPTION_VAL_50_CY },
         { "60%",  OPTION_VAL_60_CY },
         { "70%",  OPTION_VAL_70_CY },
         { "80%",  OPTION_VAL_80_CY },
         { "90%",  OPTION_VAL_90_CY },
         { "100%", OPTION_VAL_100_O46_CY },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_cy = {
   option_cats_cy,
   option_defs_cy
};

/* RETRO_LANGUAGE_DA */

#define CATEGORY_SYSTEM_LABEL_DA NULL
#define CATEGORY_SYSTEM_INFO_0_DA NULL
#define CATEGORY_VIDEO_LABEL_DA NULL
#define CATEGORY_VIDEO_INFO_0_DA NULL
#define CATEGORY_PERFORMANCE_LABEL_DA NULL
#define CATEGORY_PERFORMANCE_INFO_0_DA NULL
#define CATEGORY_HACKS_LABEL_DA NULL
#define CATEGORY_HACKS_INFO_0_DA NULL
#define CATEGORY_INPUT_LABEL_DA NULL
#define CATEGORY_INPUT_INFO_0_DA NULL
#define CATEGORY_EXPANSIONS_LABEL_DA NULL
#define CATEGORY_EXPANSIONS_INFO_0_DA NULL
#define CATEGORY_VMU_LABEL_DA NULL
#define CATEGORY_VMU_INFO_0_DA NULL
#define CORE_OPTION_NAME_REGION_LABEL_DA NULL
#define OPTION_VAL_JAPAN_DA NULL
#define OPTION_VAL_USA_DA NULL
#define OPTION_VAL_EUROPE_DA NULL
#define OPTION_VAL_DEFAULT_DA NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_DA NULL
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_DA NULL
#define OPTION_VAL_JAPANESE_DA NULL
#define OPTION_VAL_ENGLISH_DA NULL
#define OPTION_VAL_GERMAN_DA NULL
#define OPTION_VAL_FRENCH_DA NULL
#define OPTION_VAL_SPANISH_DA NULL
#define OPTION_VAL_ITALIAN_DA NULL
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_DA NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_DA NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_DA NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_DA NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_DA NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_DA NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_DA NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_DA NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_DA NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_DA NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_DA NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_DA NULL
#define CORE_OPTION_NAME_UPNP_LABEL_DA NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_DA NULL
#define CORE_OPTION_NAME_DCNET_LABEL_DA NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_DA NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_DA NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_DA NULL
#define OPTION_VAL_320X240_DA NULL
#define OPTION_VAL_640X480_DA NULL
#define OPTION_VAL_800X600_DA NULL
#define OPTION_VAL_960X720_DA NULL
#define OPTION_VAL_1024X768_DA NULL
#define OPTION_VAL_1280X960_DA NULL
#define OPTION_VAL_1440X1080_DA NULL
#define OPTION_VAL_1600X1200_DA NULL
#define OPTION_VAL_1920X1440_DA NULL
#define OPTION_VAL_2560X1920_DA NULL
#define OPTION_VAL_2880X2160_DA NULL
#define OPTION_VAL_3200X2400_DA NULL
#define OPTION_VAL_3840X2880_DA NULL
#define OPTION_VAL_4480X3360_DA NULL
#define OPTION_VAL_5120X3840_DA NULL
#define OPTION_VAL_5760X4320_DA NULL
#define OPTION_VAL_6400X4800_DA NULL
#define OPTION_VAL_7040X5280_DA NULL
#define OPTION_VAL_7680X5760_DA NULL
#define OPTION_VAL_8320X6240_DA NULL
#define OPTION_VAL_8960X6720_DA NULL
#define OPTION_VAL_9600X7200_DA NULL
#define OPTION_VAL_10240X7680_DA NULL
#define OPTION_VAL_10880X8160_DA NULL
#define OPTION_VAL_11520X8640_DA NULL
#define OPTION_VAL_12160X9120_DA NULL
#define OPTION_VAL_12800X9600_DA NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_DA NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_DA NULL
#define OPTION_VAL_VGA_DA NULL
#define OPTION_VAL_TV_RGB_DA NULL
#define OPTION_VAL_TV_COMPOSITE_DA NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_DA NULL
#define OPTION_VAL_NTSC_DA NULL
#define OPTION_VAL_PAL_DA NULL
#define OPTION_VAL_PAL_N_DA NULL
#define OPTION_VAL_PAL_M_DA NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_DA NULL
#define OPTION_VAL_HORIZONTAL_DA NULL
#define OPTION_VAL_VERTICAL_DA NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_DA NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_DA NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_DA NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_DA NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_DA NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_DA NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_DA NULL
#define OPTION_VAL_512MB_DA NULL
#define OPTION_VAL_1GB_DA NULL
#define OPTION_VAL_2GB_DA NULL
#define OPTION_VAL_4GB_DA NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_DA NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_DA NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_DA NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_DA NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_DA NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_DA NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_DA NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_DA NULL
#define CORE_OPTION_NAME_FOG_LABEL_DA NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_DA NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_DA NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_DA NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_DA NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_DA NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_DA NULL
#define OPTION_VAL_1_DA NULL
#define OPTION_VAL_2_DA NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_DA NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_DA NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_DA NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_DA NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_DA NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_DA NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_DA NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_DA NULL
#define OPTION_VAL_2_O27_DA NULL
#define OPTION_VAL_4_DA NULL
#define OPTION_VAL_6_DA NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_DA NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_DA NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_DA NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_DA NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_DA NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_DA NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_DA NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_DA NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_DA NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_DA NULL
#define OPTION_VAL_SOME_DA NULL
#define OPTION_VAL_MORE_DA NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_DA NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_DA NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_DA NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_DA NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_DA NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_DA NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_DA NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_DA NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_DA NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_DA NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_DA NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_DA NULL
#define OPTION_VAL_100_DA NULL
#define OPTION_VAL_110_DA NULL
#define OPTION_VAL_120_DA NULL
#define OPTION_VAL_130_DA NULL
#define OPTION_VAL_140_DA NULL
#define OPTION_VAL_150_DA NULL
#define OPTION_VAL_160_DA NULL
#define OPTION_VAL_170_DA NULL
#define OPTION_VAL_180_DA NULL
#define OPTION_VAL_190_DA NULL
#define OPTION_VAL_200_DA NULL
#define OPTION_VAL_210_DA NULL
#define OPTION_VAL_220_DA NULL
#define OPTION_VAL_230_DA NULL
#define OPTION_VAL_240_DA NULL
#define OPTION_VAL_250_DA NULL
#define OPTION_VAL_260_DA NULL
#define OPTION_VAL_270_DA NULL
#define OPTION_VAL_280_DA NULL
#define OPTION_VAL_290_DA NULL
#define OPTION_VAL_300_DA NULL
#define OPTION_VAL_310_DA NULL
#define OPTION_VAL_320_DA NULL
#define OPTION_VAL_330_DA NULL
#define OPTION_VAL_340_DA NULL
#define OPTION_VAL_350_DA NULL
#define OPTION_VAL_360_DA NULL
#define OPTION_VAL_370_DA NULL
#define OPTION_VAL_380_DA NULL
#define OPTION_VAL_390_DA NULL
#define OPTION_VAL_400_DA NULL
#define OPTION_VAL_410_DA NULL
#define OPTION_VAL_420_DA NULL
#define OPTION_VAL_430_DA NULL
#define OPTION_VAL_440_DA NULL
#define OPTION_VAL_450_DA NULL
#define OPTION_VAL_460_DA NULL
#define OPTION_VAL_470_DA NULL
#define OPTION_VAL_480_DA NULL
#define OPTION_VAL_490_DA NULL
#define OPTION_VAL_500_DA NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_DA NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_DA NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_DA NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_DA NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_DA NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_DA NULL
#define OPTION_VAL_0_DA NULL
#define OPTION_VAL_5_DA NULL
#define OPTION_VAL_10_DA NULL
#define OPTION_VAL_15_DA NULL
#define OPTION_VAL_20_DA NULL
#define OPTION_VAL_25_DA NULL
#define OPTION_VAL_30_DA NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_DA NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_DA NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_DA NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_DA NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_DA NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_DA NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_DA NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_DA NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_DA NULL
#define OPTION_VAL_50_DA NULL
#define OPTION_VAL_60_DA NULL
#define OPTION_VAL_70_DA NULL
#define OPTION_VAL_80_DA NULL
#define OPTION_VAL_90_DA NULL
#define OPTION_VAL_100_O46_DA NULL
#define OPTION_VAL_110_O46_DA NULL
#define OPTION_VAL_120_O46_DA NULL
#define OPTION_VAL_130_O46_DA NULL
#define OPTION_VAL_140_O46_DA NULL
#define OPTION_VAL_150_O46_DA NULL
#define OPTION_VAL_160_O46_DA NULL
#define OPTION_VAL_170_O46_DA NULL
#define OPTION_VAL_180_O46_DA NULL
#define OPTION_VAL_190_O46_DA NULL
#define OPTION_VAL_200_O46_DA NULL
#define OPTION_VAL_210_O46_DA NULL
#define OPTION_VAL_220_O46_DA NULL
#define OPTION_VAL_230_O46_DA NULL
#define OPTION_VAL_240_O46_DA NULL
#define OPTION_VAL_250_O46_DA NULL
#define OPTION_VAL_260_O46_DA NULL
#define OPTION_VAL_270_O46_DA NULL
#define OPTION_VAL_280_O46_DA NULL
#define OPTION_VAL_290_O46_DA NULL
#define OPTION_VAL_300_O46_DA NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_DA NULL
#define OPTION_VAL_WHITE_DA NULL
#define OPTION_VAL_RED_DA NULL
#define OPTION_VAL_GREEN_DA NULL
#define OPTION_VAL_BLUE_DA NULL
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_DA NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_DA NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_DA NULL
#define OPTION_VAL_VMU_DA NULL
#define OPTION_VAL_PURUPURU_DA NULL
#define OPTION_VAL_NONE_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_DA NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_DA NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_DA NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_DA NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_DA NULL
#define OPTION_VAL_VMU_A1_DA NULL
#define OPTION_VAL_ALL_VMUS_DA NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_DA NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_DA NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_DA NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_DA NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_DA NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_DA NULL
#define OPTION_VAL_UPPER_LEFT_DA NULL
#define OPTION_VAL_UPPER_RIGHT_DA NULL
#define OPTION_VAL_LOWER_LEFT_DA NULL
#define OPTION_VAL_LOWER_RIGHT_DA NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_DA NULL
#define OPTION_VAL_1X_DA NULL
#define OPTION_VAL_3X_DA NULL
#define OPTION_VAL_5X_DA NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_DA NULL
#define OPTION_VAL_DEFAULT_ON_00_DA NULL
#define OPTION_VAL_DEFAULT_OFF_01_DA NULL
#define OPTION_VAL_BLACK_02_DA NULL
#define OPTION_VAL_LIGHT_BLUE_04_DA NULL
#define OPTION_VAL_CYAN_06_DA NULL
#define OPTION_VAL_CYAN_BLUE_07_DA NULL
#define OPTION_VAL_LIGHT_GREEN_08_DA NULL
#define OPTION_VAL_CYAN_GREEN_09_DA NULL
#define OPTION_VAL_LIGHT_CYAN_10_DA NULL
#define OPTION_VAL_PURPLE_12_DA NULL
#define OPTION_VAL_LIGHT_PURPLE_13_DA NULL
#define OPTION_VAL_YELLOW_14_DA NULL
#define OPTION_VAL_GRAY_15_DA NULL
#define OPTION_VAL_LIGHT_PURPLE_2_16_DA NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_DA NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_DA NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_DA NULL
#define OPTION_VAL_LIGHT_RED_2_20_DA NULL
#define OPTION_VAL_MAGENTA_21_DA NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_DA NULL
#define OPTION_VAL_LIGHT_ORANGE_23_DA NULL
#define OPTION_VAL_ORANGE_24_DA NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_DA NULL
#define OPTION_VAL_LIGHT_YELLOW_26_DA NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_DA NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_DA NULL
#define OPTION_VAL_40_DA NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_DA NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_DA NULL

struct retro_core_option_v2_category option_cats_da[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_DA,
      CATEGORY_SYSTEM_INFO_0_DA
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_DA,
      CATEGORY_VIDEO_INFO_0_DA
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_DA,
      CATEGORY_PERFORMANCE_INFO_0_DA
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DA,
      CATEGORY_HACKS_INFO_0_DA
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DA,
      CATEGORY_INPUT_INFO_0_DA
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_DA,
      CATEGORY_EXPANSIONS_INFO_0_DA
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_DA,
      CATEGORY_VMU_INFO_0_DA
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_da[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_DA,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_DA },
         { "USA",     OPTION_VAL_USA_DA },
         { "Europe",  OPTION_VAL_EUROPE_DA },
         { "Default", OPTION_VAL_DEFAULT_DA },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_DA,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_DA },
         { "English",  OPTION_VAL_ENGLISH_DA },
         { "German",   OPTION_VAL_GERMAN_DA },
         { "French",   OPTION_VAL_FRENCH_DA },
         { "Spanish",  OPTION_VAL_SPANISH_DA },
         { "Italian",  OPTION_VAL_ITALIAN_DA },
         { "Default",  OPTION_VAL_DEFAULT_DA },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_DA,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_DA,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_DA },
         { "640x480",    OPTION_VAL_640X480_DA },
         { "800x600",    OPTION_VAL_800X600_DA },
         { "960x720",    OPTION_VAL_960X720_DA },
         { "1024x768",   OPTION_VAL_1024X768_DA },
         { "1280x960",   OPTION_VAL_1280X960_DA },
         { "1440x1080",  OPTION_VAL_1440X1080_DA },
         { "1600x1200",  OPTION_VAL_1600X1200_DA },
         { "1920x1440",  OPTION_VAL_1920X1440_DA },
         { "2560x1920",  OPTION_VAL_2560X1920_DA },
         { "2880x2160",  OPTION_VAL_2880X2160_DA },
         { "3200x2400",  OPTION_VAL_3200X2400_DA },
         { "3840x2880",  OPTION_VAL_3840X2880_DA },
         { "4480x3360",  OPTION_VAL_4480X3360_DA },
         { "5120x3840",  OPTION_VAL_5120X3840_DA },
         { "5760x4320",  OPTION_VAL_5760X4320_DA },
         { "6400x4800",  OPTION_VAL_6400X4800_DA },
         { "7040x5280",  OPTION_VAL_7040X5280_DA },
         { "7680x5760",  OPTION_VAL_7680X5760_DA },
         { "8320x6240",  OPTION_VAL_8320X6240_DA },
         { "8960x6720",  OPTION_VAL_8960X6720_DA },
         { "9600x7200",  OPTION_VAL_9600X7200_DA },
         { "10240x7680", OPTION_VAL_10240X7680_DA },
         { "10880x8160", OPTION_VAL_10880X8160_DA },
         { "11520x8640", OPTION_VAL_11520X8640_DA },
         { "12160x9120", OPTION_VAL_12160X9120_DA },
         { "12800x9600", OPTION_VAL_12800X9600_DA },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_DA,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_DA },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_DA },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_DA },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_DA,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_DA },
         { "PAL",     OPTION_VAL_PAL_DA },
         { "PAL_N",   OPTION_VAL_PAL_N_DA },
         { "PAL_M",   OPTION_VAL_PAL_M_DA },
         { "Default", OPTION_VAL_DEFAULT_DA },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_DA,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_DA },
         { "vertical",   OPTION_VAL_VERTICAL_DA },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_DA,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_DA },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_DA },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_DA },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_DA,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_DA },
         { "1GB",   OPTION_VAL_1GB_DA },
         { "2GB",   OPTION_VAL_2GB_DA },
         { "4GB",   OPTION_VAL_4GB_DA },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_DA,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_DA,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_DA,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_DA,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_DA },
         { "1",  OPTION_VAL_1_DA },
         { "2",  OPTION_VAL_2_DA },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_DA,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_DA,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_DA },
         { "4",  OPTION_VAL_4_DA },
         { "6",  OPTION_VAL_6_DA },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_DA,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_DA,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_DA,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_DA,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_DA,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_DA,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_DA,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_DA },
         { "more", OPTION_VAL_MORE_DA },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_DA,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_DA },
         { "110", OPTION_VAL_110_DA },
         { "120", OPTION_VAL_120_DA },
         { "130", OPTION_VAL_130_DA },
         { "140", OPTION_VAL_140_DA },
         { "150", OPTION_VAL_150_DA },
         { "160", OPTION_VAL_160_DA },
         { "170", OPTION_VAL_170_DA },
         { "180", OPTION_VAL_180_DA },
         { "190", OPTION_VAL_190_DA },
         { "200", OPTION_VAL_200_DA },
         { "210", OPTION_VAL_210_DA },
         { "220", OPTION_VAL_220_DA },
         { "230", OPTION_VAL_230_DA },
         { "240", OPTION_VAL_240_DA },
         { "250", OPTION_VAL_250_DA },
         { "260", OPTION_VAL_260_DA },
         { "270", OPTION_VAL_270_DA },
         { "280", OPTION_VAL_280_DA },
         { "290", OPTION_VAL_290_DA },
         { "300", OPTION_VAL_300_DA },
         { "310", OPTION_VAL_310_DA },
         { "320", OPTION_VAL_320_DA },
         { "330", OPTION_VAL_330_DA },
         { "340", OPTION_VAL_340_DA },
         { "350", OPTION_VAL_350_DA },
         { "360", OPTION_VAL_360_DA },
         { "370", OPTION_VAL_370_DA },
         { "380", OPTION_VAL_380_DA },
         { "390", OPTION_VAL_390_DA },
         { "400", OPTION_VAL_400_DA },
         { "410", OPTION_VAL_410_DA },
         { "420", OPTION_VAL_420_DA },
         { "430", OPTION_VAL_430_DA },
         { "440", OPTION_VAL_440_DA },
         { "450", OPTION_VAL_450_DA },
         { "460", OPTION_VAL_460_DA },
         { "470", OPTION_VAL_470_DA },
         { "480", OPTION_VAL_480_DA },
         { "490", OPTION_VAL_490_DA },
         { "500", OPTION_VAL_500_DA },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_DA,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_DA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_DA },
         { "5%",  OPTION_VAL_5_DA },
         { "10%", OPTION_VAL_10_DA },
         { "15%", OPTION_VAL_15_DA },
         { "20%", OPTION_VAL_20_DA },
         { "25%", OPTION_VAL_25_DA },
         { "30%", OPTION_VAL_30_DA },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_DA,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_DA },
         { "5%",  OPTION_VAL_5_DA },
         { "10%", OPTION_VAL_10_DA },
         { "15%", OPTION_VAL_15_DA },
         { "20%", OPTION_VAL_20_DA },
         { "25%", OPTION_VAL_25_DA },
         { "30%", OPTION_VAL_30_DA },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_DA,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_DA,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_DA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_DA },
         { "60%",  OPTION_VAL_60_DA },
         { "70%",  OPTION_VAL_70_DA },
         { "80%",  OPTION_VAL_80_DA },
         { "90%",  OPTION_VAL_90_DA },
         { "100%", OPTION_VAL_100_O46_DA },
         { "110%", OPTION_VAL_110_O46_DA },
         { "120%", OPTION_VAL_120_O46_DA },
         { "130%", OPTION_VAL_130_O46_DA },
         { "140%", OPTION_VAL_140_O46_DA },
         { "150%", OPTION_VAL_150_O46_DA },
         { "160%", OPTION_VAL_160_O46_DA },
         { "170%", OPTION_VAL_170_O46_DA },
         { "180%", OPTION_VAL_180_O46_DA },
         { "190%", OPTION_VAL_190_O46_DA },
         { "200%", OPTION_VAL_200_O46_DA },
         { "210%", OPTION_VAL_210_O46_DA },
         { "220%", OPTION_VAL_220_O46_DA },
         { "230%", OPTION_VAL_230_O46_DA },
         { "240%", OPTION_VAL_240_O46_DA },
         { "250%", OPTION_VAL_250_O46_DA },
         { "260%", OPTION_VAL_260_O46_DA },
         { "270%", OPTION_VAL_270_O46_DA },
         { "280%", OPTION_VAL_280_O46_DA },
         { "290%", OPTION_VAL_290_O46_DA },
         { "300%", OPTION_VAL_300_O46_DA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_DA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DA },
         { "Red",      OPTION_VAL_RED_DA },
         { "Green",    OPTION_VAL_GREEN_DA },
         { "Blue",     OPTION_VAL_BLUE_DA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_DA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DA },
         { "Red",      OPTION_VAL_RED_DA },
         { "Green",    OPTION_VAL_GREEN_DA },
         { "Blue",     OPTION_VAL_BLUE_DA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_DA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DA },
         { "Red",      OPTION_VAL_RED_DA },
         { "Green",    OPTION_VAL_GREEN_DA },
         { "Blue",     OPTION_VAL_BLUE_DA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_DA,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DA },
         { "Red",      OPTION_VAL_RED_DA },
         { "Green",    OPTION_VAL_GREEN_DA },
         { "Blue",     OPTION_VAL_BLUE_DA },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_DA,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_DA,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DA },
         { "Purupuru", OPTION_VAL_PURUPURU_DA },
         { "None",     OPTION_VAL_NONE_DA },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_DA,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_DA,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_DA,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_DA },
         { "All VMUs", OPTION_VAL_ALL_VMUS_DA },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_DA,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_DA,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_DA,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_DA,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_DA,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_DA,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DA },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DA },
         { "2x", OPTION_VAL_2_O27_DA },
         { "3x", OPTION_VAL_3X_DA },
         { "4x", OPTION_VAL_4_DA },
         { "5x", OPTION_VAL_5X_DA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DA },
         { "20%",  OPTION_VAL_20_DA },
         { "30%",  OPTION_VAL_30_DA },
         { "40%",  OPTION_VAL_40_DA },
         { "50%",  OPTION_VAL_50_DA },
         { "60%",  OPTION_VAL_60_DA },
         { "70%",  OPTION_VAL_70_DA },
         { "80%",  OPTION_VAL_80_DA },
         { "90%",  OPTION_VAL_90_DA },
         { "100%", OPTION_VAL_100_O46_DA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DA },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DA },
         { "2x", OPTION_VAL_2_O27_DA },
         { "3x", OPTION_VAL_3X_DA },
         { "4x", OPTION_VAL_4_DA },
         { "5x", OPTION_VAL_5X_DA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DA },
         { "20%",  OPTION_VAL_20_DA },
         { "30%",  OPTION_VAL_30_DA },
         { "40%",  OPTION_VAL_40_DA },
         { "50%",  OPTION_VAL_50_DA },
         { "60%",  OPTION_VAL_60_DA },
         { "70%",  OPTION_VAL_70_DA },
         { "80%",  OPTION_VAL_80_DA },
         { "90%",  OPTION_VAL_90_DA },
         { "100%", OPTION_VAL_100_O46_DA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DA },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DA },
         { "2x", OPTION_VAL_2_O27_DA },
         { "3x", OPTION_VAL_3X_DA },
         { "4x", OPTION_VAL_4_DA },
         { "5x", OPTION_VAL_5X_DA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DA },
         { "20%",  OPTION_VAL_20_DA },
         { "30%",  OPTION_VAL_30_DA },
         { "40%",  OPTION_VAL_40_DA },
         { "50%",  OPTION_VAL_50_DA },
         { "60%",  OPTION_VAL_60_DA },
         { "70%",  OPTION_VAL_70_DA },
         { "80%",  OPTION_VAL_80_DA },
         { "90%",  OPTION_VAL_90_DA },
         { "100%", OPTION_VAL_100_O46_DA },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DA },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DA },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DA },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DA },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DA },
         { "2x", OPTION_VAL_2_O27_DA },
         { "3x", OPTION_VAL_3X_DA },
         { "4x", OPTION_VAL_4_DA },
         { "5x", OPTION_VAL_5X_DA },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DA },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DA },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DA },
         { "BLUE 03",           OPTION_VAL_BLUE_DA },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DA },
         { "GREEN 05",          OPTION_VAL_GREEN_DA },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DA },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DA },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DA },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DA },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DA },
         { "RED 11",            OPTION_VAL_RED_DA },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DA },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DA },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DA },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DA },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DA },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DA },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DA },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DA },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DA },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DA },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DA },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DA },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DA },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DA },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DA },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DA },
         { "WHITE 28",          OPTION_VAL_WHITE_DA },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_DA,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DA },
         { "20%",  OPTION_VAL_20_DA },
         { "30%",  OPTION_VAL_30_DA },
         { "40%",  OPTION_VAL_40_DA },
         { "50%",  OPTION_VAL_50_DA },
         { "60%",  OPTION_VAL_60_DA },
         { "70%",  OPTION_VAL_70_DA },
         { "80%",  OPTION_VAL_80_DA },
         { "90%",  OPTION_VAL_90_DA },
         { "100%", OPTION_VAL_100_O46_DA },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_da = {
   option_cats_da,
   option_defs_da
};

/* RETRO_LANGUAGE_DE */

#define CATEGORY_SYSTEM_LABEL_DE NULL
#define CATEGORY_SYSTEM_INFO_0_DE "Region, Sprache, BIOS und Basis-Hardware-Einstellungen konfigurieren."
#define CATEGORY_VIDEO_LABEL_DE NULL
#define CATEGORY_VIDEO_INFO_0_DE "Einstellungen für Auflösung, reihenfolgeunabhängige Transparenz und visuelle Effekte konfigurieren."
#define CATEGORY_PERFORMANCE_LABEL_DE "Leistung"
#define CATEGORY_PERFORMANCE_INFO_0_DE "Einstellungen für Threaded Rendering und Bilder überspringen ändern."
#define CATEGORY_HACKS_LABEL_DE "Emulations-Hacks"
#define CATEGORY_HACKS_INFO_0_DE "Breitbildüberschreibungen, GD-ROM-Ladegeschwindigkeit und Texturaustauscheinstellungen konfigurieren."
#define CATEGORY_INPUT_LABEL_DE "Eingabe"
#define CATEGORY_INPUT_INFO_0_DE "Gamepad- und Lightgun-Einstellungen konfigurieren."
#define CATEGORY_EXPANSIONS_LABEL_DE "Controllererweiterungsslots"
#define CATEGORY_EXPANSIONS_INFO_0_DE "Das Gerät (VMU, Rumpelgerät) auswählen, das am jeweiligen Controllererweiterungsslot angeschlossen ist."
#define CATEGORY_VMU_LABEL_DE NULL
#define CATEGORY_VMU_INFO_0_DE "Konfiguriert die VMU-Speicherdateien pro Spiel und die VMU-Sichtbarkeitseinstellungen auf dem Bildschirm."
#define CORE_OPTION_NAME_REGION_LABEL_DE NULL
#define OPTION_VAL_JAPAN_DE NULL
#define OPTION_VAL_USA_DE NULL
#define OPTION_VAL_EUROPE_DE "Europa"
#define OPTION_VAL_DEFAULT_DE "Standard"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_DE "Sprache"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_DE "Ändert die Sprache, die vom BIOS und von Spielen verwendet wird, die mehrere Sprachen enthalten."
#define OPTION_VAL_JAPANESE_DE "Japanisch"
#define OPTION_VAL_ENGLISH_DE "Englisch"
#define OPTION_VAL_GERMAN_DE "Deutsch"
#define OPTION_VAL_FRENCH_DE "Französisch"
#define OPTION_VAL_SPANISH_DE "Spanisch"
#define OPTION_VAL_ITALIAN_DE "Italienisch"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_DE "HLE BIOS (Neustart erforderlich)"
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_DE "Erzwingt die Verwendung von High-Level-Emulation-BIOS."
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_DE "BIOS starten (Neustart erforderlich)"
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_DE "Direkt ins Dreamcast-BIOS-Menü starten."
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_DE "DSP aktivieren"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_DE "Aktiviert Emulation von DSP des Dreamcasts (digitaler Signalprozessor). Verbessert die Genauigkeit des erzeugten Klanges, erhöht aber die Leistungsanforderungen."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_DE "Arcade-Servicetasten erlauben"
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_DE "Aktiviert den SERVICE-Knopf für Arcadespiele, um die Cabineteinstellungen aufzurufen."
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_DE "NAOMI-Spiele auf kostenloses Spiel setzen"
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_DE "Ändert die Münzeinstellungen des Spiels zu kostenlos."
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_DE "Breitbandadapter-Emulation"
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_DE "Den Ethernet-Breitbandadapter anstelle des Modems emulieren. (Neustart erforderlich)"
#define CORE_OPTION_NAME_UPNP_LABEL_DE "UPnP aktivieren"
#define CORE_OPTION_NAME_UPNP_INFO_0_DE "Verwendet UPnP, um den Internetrouter automatisch für Onlinespiele zu konfigurieren."
#define CORE_OPTION_NAME_DCNET_LABEL_DE "DCNet verwenden (Experimentell)"
#define CORE_OPTION_NAME_DCNET_INFO_0_DE "Mit dem experimentellen Cloud-Dienst DCNet verbinden."
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_DE "Interne Auflösung"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_DE "Rendering-Auflösung ändern."
#define OPTION_VAL_320X240_DE "320×240 (Halb)"
#define OPTION_VAL_640X480_DE "640×480 (Nativ)"
#define OPTION_VAL_800X600_DE "800×600 (×1,25)"
#define OPTION_VAL_960X720_DE "960×720 (×1,5)"
#define OPTION_VAL_1024X768_DE "1024×768 (×1,6)"
#define OPTION_VAL_1280X960_DE "1280×960 (×2)"
#define OPTION_VAL_1440X1080_DE "1440×1080 (×2,25)"
#define OPTION_VAL_1600X1200_DE "1600×1200 (×2,5)"
#define OPTION_VAL_1920X1440_DE "1920×1440 (×3)"
#define OPTION_VAL_2560X1920_DE "2560×1920 (×4)"
#define OPTION_VAL_2880X2160_DE "2880×2160 (×4,5)"
#define OPTION_VAL_3200X2400_DE "3200×2400 (×5)"
#define OPTION_VAL_3840X2880_DE "3840×2880 (×6)"
#define OPTION_VAL_4480X3360_DE "4480×3360 (×7)"
#define OPTION_VAL_5120X3840_DE "5120×3840 (×8)"
#define OPTION_VAL_5760X4320_DE "5760×4320 (×9)"
#define OPTION_VAL_6400X4800_DE "6400×4800 (×10)"
#define OPTION_VAL_7040X5280_DE "7040×5280 (×11)"
#define OPTION_VAL_7680X5760_DE "7680×5760 (×12)"
#define OPTION_VAL_8320X6240_DE "8320×6240 (×13)"
#define OPTION_VAL_8960X6720_DE "8960×6720 (×14)"
#define OPTION_VAL_9600X7200_DE "9600×7200 (×15)"
#define OPTION_VAL_10240X7680_DE "10240×7680 (×6)"
#define OPTION_VAL_10880X8160_DE "10880×8160 (×17)"
#define OPTION_VAL_11520X8640_DE "11520×8640 (×18)"
#define OPTION_VAL_12160X9120_DE "12160×9120 (×19)"
#define OPTION_VAL_12800X9600_DE "12800×9600 (×20)"
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_DE "Kabeltyp"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_DE "Das Ausgabesignalkabel: „TV (Composite)“ ist das am weitesten unterstützte."
#define OPTION_VAL_VGA_DE NULL
#define OPTION_VAL_TV_RGB_DE NULL
#define OPTION_VAL_TV_COMPOSITE_DE NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_DE "Ausgabe-Regions-Standard"
#define OPTION_VAL_NTSC_DE NULL
#define OPTION_VAL_PAL_DE "PAL (Welt)"
#define OPTION_VAL_PAL_N_DE "PAL-N (Argentinien, Paraguay, Uruguay)"
#define OPTION_VAL_PAL_M_DE "PAL-M (Brasilien)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_DE "Bildschirmausrichtung"
#define OPTION_VAL_HORIZONTAL_DE NULL
#define OPTION_VAL_VERTICAL_DE "Vertikal"
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_DE "Alpha-Sortierung"
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_DE "Wählen, wie die transparenten Polygone sortiert werden."
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_DE "Pro-Streifen (schnell, am wenigsten genau)"
#define OPTION_VAL_PER_TRIANGLE_NORMAL_DE "Pro-Dreieck (normal)"
#define OPTION_VAL_PER_PIXEL_ACCURATE_DE "Pro-Pixel (genau, aber langsamer)"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_DE "Anhäufung Pixel Puffergröße"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_DE "Für eine korrekte Ausgabe höherer Auflösungen sind möglicherweise höhere Werte erforderlich."
#define OPTION_VAL_512MB_DE "512 MB"
#define OPTION_VAL_1GB_DE "1 GB"
#define OPTION_VAL_2GB_DE "2 GB"
#define OPTION_VAL_4GB_DE "4 GB"
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_DE "Maximale transparente Ebenen"
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_DE "Höhere Werte könnten für komplexe Szenen erforderlich sein."
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_DE "Vollständige Bildspeicheremulation"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_DE "Vollständige Bildspeicheremulation in VRAM aktivieren. Dies ist für Spiele nützlich, die den Bildspeicher direkt in VRAM lesen oder schreiben. Wenn aktiviert, wird die interne Auflösung auf 640×480 erzwungen und die Leistung kann stark beeinträchtigt werden."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_DE "RTT-Puffer (Render-To-Texture) erlauben"
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_DE "Kopiert gerenderte Texturen zurück von der GPU in VRAM. Diese Option ist normalerweise für Spiele aktiviert, die dies erfordern. Wenn aktiviert, ist das Hochskalieren von Texturen deaktiviert und die Leistung kann beeinträchtigt werden."
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_DE NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_DE "Wenn aktivierte Texturen eine kleinere Version von sich selbst verwenden, sofern sie weiter entfernt erscheinen, kann dies die Leistung erhöhen und das Schimmern verringern."
#define CORE_OPTION_NAME_FOG_LABEL_DE "Nebeleffekte"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_DE "Volumen-Modifizierer"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_DE "Eine Dreamcast-GPU-Funktion, die typischerweise von Spielen benutzt wird, um Objektschatten zu zeichnen. Normalerweise sollte dies aktiviert werden – der Leistungsverlust ist in der Regel minimal bis vernachlässigbar."
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_DE "Anisotropes Filtern"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_DE "Verbessert die Qualität der Texturen auf Oberflächen, die in schrägen Blickwinkeln gegenüber der Kamera liegen. Höhere Werte sind anspruchsvoller für die GPU. Änderungen an dieser Einstellung gelten erst nach einem Neustart."
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_DE "Texturfilterung"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_DE "Der zu verwendende Texturfiltermodus. Dies kann verwendet werden, um einen bestimmten Texturfiltermodus für alle Texturen zu erzwingen, um ein klareres (oder glatteres) Erscheinungsbild als Standard zu erhalten. Andere Werte als Standardwerte können zu verschiedenen Rendering-Problemen führen. Änderungen an dieser Einstellung werden nur nach einem Neustart angewendet."
#define OPTION_VAL_1_DE "Nächste-Nachbarn erzwingen"
#define OPTION_VAL_2_DE "Linear erzwingen"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_DE "Bildaustausch verzögern"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_DE "Nützlich, um flackernden Bildschirm oder fehlerhafte Videos zu vermeiden. Nicht empfohlen auf langsamen Plattformen."
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_DE "Änderungen der Bildrate erkennen"
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_DE "Benachrichtigt das Frontend, wenn sich die interne Bildrate ändert (z. B. von 60 fps auf 30 fps). Verbessert das Bildtempo in Spielen, die mit gesperrten 30 bps oder 20 bps laufen, sollte aber für Spiele mit entsperrten (instabilen) Bildraten deaktiviert sein (z. B. Ecco the Dolphin, Unreal Tournament). Hinweis: Nicht verfügbar, wenn „Automatisches Bilder überspringen“ aktiviert ist."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_DE "PowerVR2-Nachbearbeitungsfilter"
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_DE "Nachbearbeitung des gerenderten Bildes zur Simulation von Effekten speziell für PowerVR2-GPU und analoge Videosignale."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_DE "Texturen hochskalieren (xBRZ)"
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_DE "Verbessert handgezeichnete 2D-Pixelgrafiken. Sollte nur mit 2D-Pixelspielen verwendet werden."
#define OPTION_VAL_2_O27_DE NULL
#define OPTION_VAL_4_DE "4×"
#define OPTION_VAL_6_DE "6×"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_DE "Texturhochskalierung Max. gefilterte Größe"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_DE "Einen Maximalwert für die Größe einer hochzuskalierenden Textur auswählen. Wenn die Texturgröße größer als der ausgewählte Wert ist, wird sie nicht hochskaliert."
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_DE "Native Tiefeninterpolation"
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_DE "Hilft bei Texturfehlern und tieferen Problemen mit AMD GPUs. Kann auch Intel GPUs in einigen Fällen helfen."
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_DE "Ausfransende Kanten beim Hochskalieren beheben"
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_DE "Hilft im Fall von Texture Bleeding beim Hochskalieren. Ein Deaktivieren kann helfen, wenn in 2D-Spielen Pixel beim Hochskalieren verformt werden (MVC2, CVS, KOF usw.)"
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_DE NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_DE "Führt die GPU und CPU in verschiedenen Prozessen aus. Sehr empfohlen."
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_DE "Automatisches Bilder überspringen"
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_DE "Überspringt Bilder automatisch, wenn der Emulator langsam läuft. Hinweis: Diese Einstellung gilt nur, wenn 'Threaded Rendering' aktiviert ist."
#define OPTION_VAL_SOME_DE NULL
#define OPTION_VAL_MORE_DE NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_DE "Bilder überspringen"
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_DE "Legt die Anzahl der Bilder fest, die zwischen jedem angezeigten Bild übersprungen werden sollen."
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_DE "Breitbild-Cheats (Neustart erforderlich)"
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_DE "Aktiviert Cheats, mit denen bestimmte Spiele im Breitbildformat angezeigt werden können."
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_DE "Breitbildmodus-Hack"
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_DE "Zeichnet Geometrie außerhalb des normalen 4:3-Seitenverhältnisses. Kann grafische Fehler in den aufgedeckten Bereichen erzeugen."
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_DE "GD-ROM schnelles Laden (ungenau)"
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_DE "Beschleunigt das Laden von GD-ROM."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_DE "Dreamcast 32 MB RAM Mod"
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_DE "Aktiviert 32 MB RAM Mod für Dreamcast.Kann die Kompatibilität beeinflussen"
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_DE "SH4 CPU unter-/übertakten"
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_DE "Ändert den Haupt-CPU-Takt des SH4 statt der standardmäßigen 200 MHz. Untertakten kann bei langsamen Plattformen helfen. Übertakten kann die Bildrate für einige Spiele erhöhen. Mit Vorsicht verwenden."
#define OPTION_VAL_100_DE NULL
#define OPTION_VAL_110_DE NULL
#define OPTION_VAL_120_DE NULL
#define OPTION_VAL_130_DE NULL
#define OPTION_VAL_140_DE NULL
#define OPTION_VAL_150_DE NULL
#define OPTION_VAL_160_DE NULL
#define OPTION_VAL_170_DE NULL
#define OPTION_VAL_180_DE NULL
#define OPTION_VAL_190_DE NULL
#define OPTION_VAL_200_DE NULL
#define OPTION_VAL_210_DE NULL
#define OPTION_VAL_220_DE NULL
#define OPTION_VAL_230_DE NULL
#define OPTION_VAL_240_DE NULL
#define OPTION_VAL_250_DE NULL
#define OPTION_VAL_260_DE NULL
#define OPTION_VAL_270_DE NULL
#define OPTION_VAL_280_DE NULL
#define OPTION_VAL_290_DE NULL
#define OPTION_VAL_300_DE NULL
#define OPTION_VAL_310_DE NULL
#define OPTION_VAL_320_DE NULL
#define OPTION_VAL_330_DE NULL
#define OPTION_VAL_340_DE NULL
#define OPTION_VAL_350_DE NULL
#define OPTION_VAL_360_DE NULL
#define OPTION_VAL_370_DE NULL
#define OPTION_VAL_380_DE NULL
#define OPTION_VAL_390_DE NULL
#define OPTION_VAL_400_DE NULL
#define OPTION_VAL_410_DE NULL
#define OPTION_VAL_420_DE NULL
#define OPTION_VAL_430_DE NULL
#define OPTION_VAL_440_DE NULL
#define OPTION_VAL_450_DE NULL
#define OPTION_VAL_460_DE NULL
#define OPTION_VAL_470_DE NULL
#define OPTION_VAL_480_DE NULL
#define OPTION_VAL_490_DE NULL
#define OPTION_VAL_500_DE NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_DE "Eigene Texturen laden"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_DE "Benutzerdefinierte Texturen aus dem Ordner „system/dc/textures/<game-id>/“ laden."
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_DE "Texturen dumpen"
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_DE "Jedes Mal, wenn eine neue Textur vom Spiel verwendet wird, wird sie als .png-Datei im Ordner „system/dc/texdump/<game-id>/“ gespeichert."
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_DE "Analog-Stick Totzone"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_DE "Auswählen, wie weit der analogen Stick gedrückt werden muss, bevor er verarbeitet wird."
#define OPTION_VAL_0_DE "0 %"
#define OPTION_VAL_5_DE "5 %"
#define OPTION_VAL_10_DE "10 %"
#define OPTION_VAL_15_DE "15 %"
#define OPTION_VAL_20_DE "20 %"
#define OPTION_VAL_25_DE "25 %"
#define OPTION_VAL_30_DE "30 %"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_DE "Trigger Totzone"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_DE "Auswählen, wie stark der Abzug gedrückt werden muss, bevor er verarbeitet wird."
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_DE "Digitale Trigger"
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_DE "Wenn aktiviert, reagiert ein Abzug wie eine normale Taste, d. h. entweder als vollständig gedrückt oder gar nicht gedrückt, ohne dass es ein Dazwischen gibt."
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_DE "Digitale Ausgänge übertragen"
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_DE "Digitale Ausgänge und Force-Feedback-Status auf TCP-Port 8000 übertragen. Kompatibel mit der MAME-Option „-output network“."
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_DE "Lightgun-Einstellungen anzeigen"
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_DE "Aktiviert die Konfiguration der Lightgun-Fadenkreuz-Anzeigeoptionen. HINWEIS: Schnellmenü muss eingeschaltet sein, damit diese Einstellung wirksam wird."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_DE "Skalierung der Fadenkreuzgröße"
#define OPTION_VAL_50_DE "50 %"
#define OPTION_VAL_60_DE "60 %"
#define OPTION_VAL_70_DE "70 %"
#define OPTION_VAL_80_DE "80 %"
#define OPTION_VAL_90_DE "90 %"
#define OPTION_VAL_100_O46_DE "100 %"
#define OPTION_VAL_110_O46_DE "110 %"
#define OPTION_VAL_120_O46_DE "120 %"
#define OPTION_VAL_130_O46_DE "130 %"
#define OPTION_VAL_140_O46_DE "140 %"
#define OPTION_VAL_150_O46_DE "150 %"
#define OPTION_VAL_160_O46_DE "160 %"
#define OPTION_VAL_170_O46_DE "170 %"
#define OPTION_VAL_180_O46_DE "180 %"
#define OPTION_VAL_190_O46_DE "190 %"
#define OPTION_VAL_200_O46_DE "200 %"
#define OPTION_VAL_210_O46_DE "210 %"
#define OPTION_VAL_220_O46_DE "220 %"
#define OPTION_VAL_230_O46_DE "230 %"
#define OPTION_VAL_240_O46_DE "240 %"
#define OPTION_VAL_250_O46_DE "250 %"
#define OPTION_VAL_260_O46_DE "260 %"
#define OPTION_VAL_270_O46_DE "270 %"
#define OPTION_VAL_280_O46_DE "280 %"
#define OPTION_VAL_290_O46_DE "290 %"
#define OPTION_VAL_300_O46_DE "300 %"
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_DE "Anzeige Pistolen-Fadenkreuz 1"
#define OPTION_VAL_WHITE_DE "Weiß"
#define OPTION_VAL_RED_DE "Rot"
#define OPTION_VAL_GREEN_DE "Grün"
#define OPTION_VAL_BLUE_DE "Blau"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_DE "Anzeige Pistolen-Fadenkreuz 2"
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_DE "Anzeige Pistolen-Fadenkreuz 3"
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_DE "Anzeige Pistolen-Fadenkreuz 4"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_DE "Gerät im Erweiterungsslot A1"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot A1 angeschlossen ist (Port A Slot 1)."
#define OPTION_VAL_VMU_DE NULL
#define OPTION_VAL_PURUPURU_DE "Vibrationspaket"
#define OPTION_VAL_NONE_DE "Nein"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_DE "Gerät im Erweiterungsslot A2"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot A2 angeschlossen ist (Port A Slot 2)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_DE "Gerät im Erweiterungsslot B1"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot B1 angeschlossen ist (Port B Slot 1)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_DE "Gerät im Erweiterungsslot B2"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot B2 angeschlossen ist (Port B Slot 2)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_DE "Gerät im Erweiterungsslot C1"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot C1 angeschlossen ist (Port C Slot 1)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_DE "Gerät im Erweiterungsslot C2"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot C2 angeschlossen ist (Port C Slot 2)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_DE "Gerät im Erweiterungsslot D1"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot D1 angeschlossen ist (Port D Slot 1)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_DE "Gerät im Erweiterungsslot D2"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_DE "Das Gerät auswählen, das im Erweiterungsslot D2 angeschlossen ist (Port D Slot 2)."
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_DE "Visual Memory Units/Systeme (VMU) pro Spiel"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_DE "VMUs pro Spiel"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_DE "Wenn deaktiviert, teilen alle Spiele bis zu 8 VMU-Speicherdateien (A1/A2/B1/B2/C1/C2/D1/D2) im Systemverzeichnis von RetroArch.\nDie Einstellung „VMU A1“ erzeugt für jedes Spiel, das gestartet wird, eine einzigartige VMU-„A1“-Datei im Speicherverzeichnis von RetroArch.\nDie Einstellung „Alle VMUs“ erzeugt bis zu 8 einzigartige VMU-Dateien (A1/A2/B1/B2/C1/C2/D1/D2) für jedes Spiel, das gestartet wird."
#define OPTION_VAL_VMU_A1_DE NULL
#define OPTION_VAL_ALL_VMUS_DE "Alle VMUs"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_DE NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_DE NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_DE "Wenn aktiviert, werden VMU-Signaltöne abgespielt."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_DE "Visual Memory Unit/System (VMU) Anzeigeeinstellungen anzeigen"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_DE "VMU-Bildschirmeinstellungen anzeigen"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_DE "Konfiguration von emulierten VMU LCD-Bildschirmen über Sichtbarkeit, Größe, Position und Farbe aktivieren. HINWEIS: Das Schnellmenü muss aktiviert sein, damit diese Einstellung wirksam wird."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_DE "Anzeige VMU-Bildschirm 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_DE "Position VMU-Bildschirm 1"
#define OPTION_VAL_UPPER_LEFT_DE "Oben links"
#define OPTION_VAL_UPPER_RIGHT_DE "Oben rechts"
#define OPTION_VAL_LOWER_LEFT_DE "Unten links"
#define OPTION_VAL_LOWER_RIGHT_DE "Unten rechts"
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_DE "Größe VMU-Bildschirm 1"
#define OPTION_VAL_1X_DE "1×"
#define OPTION_VAL_3X_DE "3×"
#define OPTION_VAL_5X_DE "5×"
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_DE "Pixel-an-Farbe VMU-Bildschirm 1"
#define OPTION_VAL_DEFAULT_ON_00_DE "Standard EIN"
#define OPTION_VAL_DEFAULT_OFF_01_DE "Standard AUS"
#define OPTION_VAL_BLACK_02_DE "Schwarz"
#define OPTION_VAL_LIGHT_BLUE_04_DE "Hellblau"
#define OPTION_VAL_CYAN_06_DE NULL
#define OPTION_VAL_CYAN_BLUE_07_DE "Zyanblau"
#define OPTION_VAL_LIGHT_GREEN_08_DE "Hellgrün"
#define OPTION_VAL_CYAN_GREEN_09_DE "Zyangrün"
#define OPTION_VAL_LIGHT_CYAN_10_DE "Hellzyan"
#define OPTION_VAL_PURPLE_12_DE "Lila"
#define OPTION_VAL_LIGHT_PURPLE_13_DE "Hellviolett"
#define OPTION_VAL_YELLOW_14_DE "Gelb"
#define OPTION_VAL_GRAY_15_DE "Grau"
#define OPTION_VAL_LIGHT_PURPLE_2_16_DE "Hellviolett (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_DE "Hellgrün (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_DE "Hellgrün (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_DE "Hellzyan (2)"
#define OPTION_VAL_LIGHT_RED_2_20_DE "Hellrot (2)"
#define OPTION_VAL_MAGENTA_21_DE NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_DE "Hellviolett (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_DE "Hellorange"
#define OPTION_VAL_ORANGE_24_DE NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_DE "Hellviolett (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_DE "Hellgelb"
#define OPTION_VAL_LIGHT_YELLOW_2_27_DE "Hellgelb (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_DE "Pixel-aus-Farbe VMU-Bildschirm 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_DE "Deckkraft VMU-Bildschirm 1"
#define OPTION_VAL_40_DE "40 %"
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_DE "Anzeige VMU-Bildschirm 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_DE "Position VMU-Bildschirm 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_DE "Größe VMU-Bildschirm 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_DE "Pixel-an-Farbe Bildschirm 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_DE "Pixel-aus-Farbe VMU-Bildschirm 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_DE "Deckkraft VMU-Bildschirm 2"
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_DE "Anzeige VMU-Bildschirm 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_DE "Position VMU-Bildschirm 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_DE "Größe VMU-Bildschirm 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_DE "Pixel-an-Farbe Bildschirm 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_DE "Pixel-aus-Farbe VMU-Bildschirm 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_DE "Deckkraft VMU-Bildschirm 3"
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_DE "Anzeige VMU-Bildschirm 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_DE "Position VMU-Bildschirm 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_DE "Größe VMU-Bildschirm 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_DE "Pixel-an-Farbe Bildschirm 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_DE "Pixel-aus-Farbe VMU-Bildschirm 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_DE "Deckkraft VMU-Bildschirm 4"

struct retro_core_option_v2_category option_cats_de[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_DE,
      CATEGORY_SYSTEM_INFO_0_DE
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_DE,
      CATEGORY_VIDEO_INFO_0_DE
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_DE,
      CATEGORY_PERFORMANCE_INFO_0_DE
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_DE,
      CATEGORY_HACKS_INFO_0_DE
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_DE,
      CATEGORY_INPUT_INFO_0_DE
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_DE,
      CATEGORY_EXPANSIONS_INFO_0_DE
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_DE,
      CATEGORY_VMU_INFO_0_DE
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_de[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_DE,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_DE },
         { "USA",     OPTION_VAL_USA_DE },
         { "Europe",  OPTION_VAL_EUROPE_DE },
         { "Default", OPTION_VAL_DEFAULT_DE },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_DE,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_DE },
         { "English",  OPTION_VAL_ENGLISH_DE },
         { "German",   OPTION_VAL_GERMAN_DE },
         { "French",   OPTION_VAL_FRENCH_DE },
         { "Spanish",  OPTION_VAL_SPANISH_DE },
         { "Italian",  OPTION_VAL_ITALIAN_DE },
         { "Default",  OPTION_VAL_DEFAULT_DE },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_DE,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_DE,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_DE },
         { "640x480",    OPTION_VAL_640X480_DE },
         { "800x600",    OPTION_VAL_800X600_DE },
         { "960x720",    OPTION_VAL_960X720_DE },
         { "1024x768",   OPTION_VAL_1024X768_DE },
         { "1280x960",   OPTION_VAL_1280X960_DE },
         { "1440x1080",  OPTION_VAL_1440X1080_DE },
         { "1600x1200",  OPTION_VAL_1600X1200_DE },
         { "1920x1440",  OPTION_VAL_1920X1440_DE },
         { "2560x1920",  OPTION_VAL_2560X1920_DE },
         { "2880x2160",  OPTION_VAL_2880X2160_DE },
         { "3200x2400",  OPTION_VAL_3200X2400_DE },
         { "3840x2880",  OPTION_VAL_3840X2880_DE },
         { "4480x3360",  OPTION_VAL_4480X3360_DE },
         { "5120x3840",  OPTION_VAL_5120X3840_DE },
         { "5760x4320",  OPTION_VAL_5760X4320_DE },
         { "6400x4800",  OPTION_VAL_6400X4800_DE },
         { "7040x5280",  OPTION_VAL_7040X5280_DE },
         { "7680x5760",  OPTION_VAL_7680X5760_DE },
         { "8320x6240",  OPTION_VAL_8320X6240_DE },
         { "8960x6720",  OPTION_VAL_8960X6720_DE },
         { "9600x7200",  OPTION_VAL_9600X7200_DE },
         { "10240x7680", OPTION_VAL_10240X7680_DE },
         { "10880x8160", OPTION_VAL_10880X8160_DE },
         { "11520x8640", OPTION_VAL_11520X8640_DE },
         { "12160x9120", OPTION_VAL_12160X9120_DE },
         { "12800x9600", OPTION_VAL_12800X9600_DE },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_DE,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_DE },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_DE },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_DE },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_DE,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_DE },
         { "PAL",     OPTION_VAL_PAL_DE },
         { "PAL_N",   OPTION_VAL_PAL_N_DE },
         { "PAL_M",   OPTION_VAL_PAL_M_DE },
         { "Default", OPTION_VAL_DEFAULT_DE },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_DE,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_DE },
         { "vertical",   OPTION_VAL_VERTICAL_DE },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_DE,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_DE },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_DE },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_DE },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_DE,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_DE },
         { "1GB",   OPTION_VAL_1GB_DE },
         { "2GB",   OPTION_VAL_2GB_DE },
         { "4GB",   OPTION_VAL_4GB_DE },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_DE,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_DE,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_DE,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_DE,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_DE },
         { "1",  OPTION_VAL_1_DE },
         { "2",  OPTION_VAL_2_DE },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_DE,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_DE,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_DE },
         { "4",  OPTION_VAL_4_DE },
         { "6",  OPTION_VAL_6_DE },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_DE,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_DE,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_DE,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_DE,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_DE,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_DE,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_DE,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_DE },
         { "more", OPTION_VAL_MORE_DE },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_DE,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_DE },
         { "110", OPTION_VAL_110_DE },
         { "120", OPTION_VAL_120_DE },
         { "130", OPTION_VAL_130_DE },
         { "140", OPTION_VAL_140_DE },
         { "150", OPTION_VAL_150_DE },
         { "160", OPTION_VAL_160_DE },
         { "170", OPTION_VAL_170_DE },
         { "180", OPTION_VAL_180_DE },
         { "190", OPTION_VAL_190_DE },
         { "200", OPTION_VAL_200_DE },
         { "210", OPTION_VAL_210_DE },
         { "220", OPTION_VAL_220_DE },
         { "230", OPTION_VAL_230_DE },
         { "240", OPTION_VAL_240_DE },
         { "250", OPTION_VAL_250_DE },
         { "260", OPTION_VAL_260_DE },
         { "270", OPTION_VAL_270_DE },
         { "280", OPTION_VAL_280_DE },
         { "290", OPTION_VAL_290_DE },
         { "300", OPTION_VAL_300_DE },
         { "310", OPTION_VAL_310_DE },
         { "320", OPTION_VAL_320_DE },
         { "330", OPTION_VAL_330_DE },
         { "340", OPTION_VAL_340_DE },
         { "350", OPTION_VAL_350_DE },
         { "360", OPTION_VAL_360_DE },
         { "370", OPTION_VAL_370_DE },
         { "380", OPTION_VAL_380_DE },
         { "390", OPTION_VAL_390_DE },
         { "400", OPTION_VAL_400_DE },
         { "410", OPTION_VAL_410_DE },
         { "420", OPTION_VAL_420_DE },
         { "430", OPTION_VAL_430_DE },
         { "440", OPTION_VAL_440_DE },
         { "450", OPTION_VAL_450_DE },
         { "460", OPTION_VAL_460_DE },
         { "470", OPTION_VAL_470_DE },
         { "480", OPTION_VAL_480_DE },
         { "490", OPTION_VAL_490_DE },
         { "500", OPTION_VAL_500_DE },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_DE,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_DE,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_DE },
         { "5%",  OPTION_VAL_5_DE },
         { "10%", OPTION_VAL_10_DE },
         { "15%", OPTION_VAL_15_DE },
         { "20%", OPTION_VAL_20_DE },
         { "25%", OPTION_VAL_25_DE },
         { "30%", OPTION_VAL_30_DE },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_DE,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_DE },
         { "5%",  OPTION_VAL_5_DE },
         { "10%", OPTION_VAL_10_DE },
         { "15%", OPTION_VAL_15_DE },
         { "20%", OPTION_VAL_20_DE },
         { "25%", OPTION_VAL_25_DE },
         { "30%", OPTION_VAL_30_DE },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_DE,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_DE,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_DE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_DE },
         { "60%",  OPTION_VAL_60_DE },
         { "70%",  OPTION_VAL_70_DE },
         { "80%",  OPTION_VAL_80_DE },
         { "90%",  OPTION_VAL_90_DE },
         { "100%", OPTION_VAL_100_O46_DE },
         { "110%", OPTION_VAL_110_O46_DE },
         { "120%", OPTION_VAL_120_O46_DE },
         { "130%", OPTION_VAL_130_O46_DE },
         { "140%", OPTION_VAL_140_O46_DE },
         { "150%", OPTION_VAL_150_O46_DE },
         { "160%", OPTION_VAL_160_O46_DE },
         { "170%", OPTION_VAL_170_O46_DE },
         { "180%", OPTION_VAL_180_O46_DE },
         { "190%", OPTION_VAL_190_O46_DE },
         { "200%", OPTION_VAL_200_O46_DE },
         { "210%", OPTION_VAL_210_O46_DE },
         { "220%", OPTION_VAL_220_O46_DE },
         { "230%", OPTION_VAL_230_O46_DE },
         { "240%", OPTION_VAL_240_O46_DE },
         { "250%", OPTION_VAL_250_O46_DE },
         { "260%", OPTION_VAL_260_O46_DE },
         { "270%", OPTION_VAL_270_O46_DE },
         { "280%", OPTION_VAL_280_O46_DE },
         { "290%", OPTION_VAL_290_O46_DE },
         { "300%", OPTION_VAL_300_O46_DE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_DE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DE },
         { "Red",      OPTION_VAL_RED_DE },
         { "Green",    OPTION_VAL_GREEN_DE },
         { "Blue",     OPTION_VAL_BLUE_DE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_DE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DE },
         { "Red",      OPTION_VAL_RED_DE },
         { "Green",    OPTION_VAL_GREEN_DE },
         { "Blue",     OPTION_VAL_BLUE_DE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_DE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DE },
         { "Red",      OPTION_VAL_RED_DE },
         { "Green",    OPTION_VAL_GREEN_DE },
         { "Blue",     OPTION_VAL_BLUE_DE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_DE,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_DE },
         { "Red",      OPTION_VAL_RED_DE },
         { "Green",    OPTION_VAL_GREEN_DE },
         { "Blue",     OPTION_VAL_BLUE_DE },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_DE,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_DE,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_DE },
         { "Purupuru", OPTION_VAL_PURUPURU_DE },
         { "None",     OPTION_VAL_NONE_DE },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_DE,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_DE,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_DE,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_DE },
         { "All VMUs", OPTION_VAL_ALL_VMUS_DE },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_DE,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_DE,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_DE,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_DE,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_DE,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_DE,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DE },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DE },
         { "2x", OPTION_VAL_2_O27_DE },
         { "3x", OPTION_VAL_3X_DE },
         { "4x", OPTION_VAL_4_DE },
         { "5x", OPTION_VAL_5X_DE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DE },
         { "20%",  OPTION_VAL_20_DE },
         { "30%",  OPTION_VAL_30_DE },
         { "40%",  OPTION_VAL_40_DE },
         { "50%",  OPTION_VAL_50_DE },
         { "60%",  OPTION_VAL_60_DE },
         { "70%",  OPTION_VAL_70_DE },
         { "80%",  OPTION_VAL_80_DE },
         { "90%",  OPTION_VAL_90_DE },
         { "100%", OPTION_VAL_100_O46_DE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DE },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DE },
         { "2x", OPTION_VAL_2_O27_DE },
         { "3x", OPTION_VAL_3X_DE },
         { "4x", OPTION_VAL_4_DE },
         { "5x", OPTION_VAL_5X_DE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DE },
         { "20%",  OPTION_VAL_20_DE },
         { "30%",  OPTION_VAL_30_DE },
         { "40%",  OPTION_VAL_40_DE },
         { "50%",  OPTION_VAL_50_DE },
         { "60%",  OPTION_VAL_60_DE },
         { "70%",  OPTION_VAL_70_DE },
         { "80%",  OPTION_VAL_80_DE },
         { "90%",  OPTION_VAL_90_DE },
         { "100%", OPTION_VAL_100_O46_DE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DE },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DE },
         { "2x", OPTION_VAL_2_O27_DE },
         { "3x", OPTION_VAL_3X_DE },
         { "4x", OPTION_VAL_4_DE },
         { "5x", OPTION_VAL_5X_DE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DE },
         { "20%",  OPTION_VAL_20_DE },
         { "30%",  OPTION_VAL_30_DE },
         { "40%",  OPTION_VAL_40_DE },
         { "50%",  OPTION_VAL_50_DE },
         { "60%",  OPTION_VAL_60_DE },
         { "70%",  OPTION_VAL_70_DE },
         { "80%",  OPTION_VAL_80_DE },
         { "90%",  OPTION_VAL_90_DE },
         { "100%", OPTION_VAL_100_O46_DE },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_DE },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_DE },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_DE },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_DE },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_DE },
         { "2x", OPTION_VAL_2_O27_DE },
         { "3x", OPTION_VAL_3X_DE },
         { "4x", OPTION_VAL_4_DE },
         { "5x", OPTION_VAL_5X_DE },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_DE },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_DE },
         { "BLACK 02",          OPTION_VAL_BLACK_02_DE },
         { "BLUE 03",           OPTION_VAL_BLUE_DE },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_DE },
         { "GREEN 05",          OPTION_VAL_GREEN_DE },
         { "CYAN 06",           OPTION_VAL_CYAN_06_DE },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_DE },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_DE },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_DE },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_DE },
         { "RED 11",            OPTION_VAL_RED_DE },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_DE },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_DE },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_DE },
         { "GRAY 15",           OPTION_VAL_GRAY_15_DE },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_DE },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_DE },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_DE },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_DE },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_DE },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_DE },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_DE },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_DE },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_DE },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_DE },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_DE },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_DE },
         { "WHITE 28",          OPTION_VAL_WHITE_DE },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_DE,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_DE },
         { "20%",  OPTION_VAL_20_DE },
         { "30%",  OPTION_VAL_30_DE },
         { "40%",  OPTION_VAL_40_DE },
         { "50%",  OPTION_VAL_50_DE },
         { "60%",  OPTION_VAL_60_DE },
         { "70%",  OPTION_VAL_70_DE },
         { "80%",  OPTION_VAL_80_DE },
         { "90%",  OPTION_VAL_90_DE },
         { "100%", OPTION_VAL_100_O46_DE },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_de = {
   option_cats_de,
   option_defs_de
};

/* RETRO_LANGUAGE_EL */

#define CATEGORY_SYSTEM_LABEL_EL "Σύστημα"
#define CATEGORY_SYSTEM_INFO_0_EL NULL
#define CATEGORY_VIDEO_LABEL_EL "Οδηγός Βίντεο"
#define CATEGORY_VIDEO_INFO_0_EL NULL
#define CATEGORY_PERFORMANCE_LABEL_EL "Επίδοση"
#define CATEGORY_PERFORMANCE_INFO_0_EL NULL
#define CATEGORY_HACKS_LABEL_EL NULL
#define CATEGORY_HACKS_INFO_0_EL NULL
#define CATEGORY_INPUT_LABEL_EL "Οδηγός Εισαγωγής"
#define CATEGORY_INPUT_INFO_0_EL NULL
#define CATEGORY_EXPANSIONS_LABEL_EL NULL
#define CATEGORY_EXPANSIONS_INFO_0_EL NULL
#define CATEGORY_VMU_LABEL_EL NULL
#define CATEGORY_VMU_INFO_0_EL NULL
#define CORE_OPTION_NAME_REGION_LABEL_EL "Περιοχή"
#define OPTION_VAL_JAPAN_EL NULL
#define OPTION_VAL_USA_EL NULL
#define OPTION_VAL_EUROPE_EL NULL
#define OPTION_VAL_DEFAULT_EL "Προκαθορισμένο"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_EL "Γλώσσα"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_EL NULL
#define OPTION_VAL_JAPANESE_EL "Ιαπωνικά"
#define OPTION_VAL_ENGLISH_EL "Αγγλικά"
#define OPTION_VAL_GERMAN_EL "Γερμανός"
#define OPTION_VAL_FRENCH_EL "Γαλλική γλώσσα"
#define OPTION_VAL_SPANISH_EL "Ισπανικά"
#define OPTION_VAL_ITALIAN_EL "Ιταλικά"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_EL NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_EL NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_EL NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_EL NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_EL NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_EL NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_EL NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_EL NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_EL NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_EL NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_EL NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_EL NULL
#define CORE_OPTION_NAME_UPNP_LABEL_EL NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_EL NULL
#define CORE_OPTION_NAME_DCNET_LABEL_EL NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_EL NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_EL NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_EL NULL
#define OPTION_VAL_320X240_EL NULL
#define OPTION_VAL_640X480_EL NULL
#define OPTION_VAL_800X600_EL NULL
#define OPTION_VAL_960X720_EL NULL
#define OPTION_VAL_1024X768_EL NULL
#define OPTION_VAL_1280X960_EL NULL
#define OPTION_VAL_1440X1080_EL NULL
#define OPTION_VAL_1600X1200_EL NULL
#define OPTION_VAL_1920X1440_EL NULL
#define OPTION_VAL_2560X1920_EL NULL
#define OPTION_VAL_2880X2160_EL NULL
#define OPTION_VAL_3200X2400_EL NULL
#define OPTION_VAL_3840X2880_EL NULL
#define OPTION_VAL_4480X3360_EL NULL
#define OPTION_VAL_5120X3840_EL NULL
#define OPTION_VAL_5760X4320_EL NULL
#define OPTION_VAL_6400X4800_EL NULL
#define OPTION_VAL_7040X5280_EL NULL
#define OPTION_VAL_7680X5760_EL NULL
#define OPTION_VAL_8320X6240_EL NULL
#define OPTION_VAL_8960X6720_EL NULL
#define OPTION_VAL_9600X7200_EL NULL
#define OPTION_VAL_10240X7680_EL NULL
#define OPTION_VAL_10880X8160_EL NULL
#define OPTION_VAL_11520X8640_EL NULL
#define OPTION_VAL_12160X9120_EL NULL
#define OPTION_VAL_12800X9600_EL NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_EL NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_EL NULL
#define OPTION_VAL_VGA_EL NULL
#define OPTION_VAL_TV_RGB_EL NULL
#define OPTION_VAL_TV_COMPOSITE_EL NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_EL NULL
#define OPTION_VAL_NTSC_EL NULL
#define OPTION_VAL_PAL_EL NULL
#define OPTION_VAL_PAL_N_EL NULL
#define OPTION_VAL_PAL_M_EL NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_EL "Περιστροφή οθόνης"
#define OPTION_VAL_HORIZONTAL_EL NULL
#define OPTION_VAL_VERTICAL_EL NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_EL NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_EL NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_EL NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_EL NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_EL NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_EL NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_EL NULL
#define OPTION_VAL_512MB_EL NULL
#define OPTION_VAL_1GB_EL NULL
#define OPTION_VAL_2GB_EL NULL
#define OPTION_VAL_4GB_EL NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_EL NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_EL NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_EL NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_EL NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_EL NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_EL NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_EL NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_EL NULL
#define CORE_OPTION_NAME_FOG_LABEL_EL NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_EL NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_EL NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_EL NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_EL NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_EL NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_EL NULL
#define OPTION_VAL_1_EL NULL
#define OPTION_VAL_2_EL NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_EL NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_EL NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_EL NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_EL NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_EL NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_EL NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_EL NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_EL NULL
#define OPTION_VAL_2_O27_EL NULL
#define OPTION_VAL_4_EL NULL
#define OPTION_VAL_6_EL NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_EL NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_EL NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_EL NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_EL NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_EL NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_EL NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_EL NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_EL NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_EL NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_EL NULL
#define OPTION_VAL_SOME_EL "Φυσιολογικά"
#define OPTION_VAL_MORE_EL NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_EL NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_EL NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_EL NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_EL NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_EL NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_EL NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_EL NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_EL NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_EL NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_EL NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_EL NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_EL NULL
#define OPTION_VAL_100_EL NULL
#define OPTION_VAL_110_EL NULL
#define OPTION_VAL_120_EL NULL
#define OPTION_VAL_130_EL NULL
#define OPTION_VAL_140_EL NULL
#define OPTION_VAL_150_EL NULL
#define OPTION_VAL_160_EL NULL
#define OPTION_VAL_170_EL NULL
#define OPTION_VAL_180_EL NULL
#define OPTION_VAL_190_EL NULL
#define OPTION_VAL_200_EL NULL
#define OPTION_VAL_210_EL NULL
#define OPTION_VAL_220_EL NULL
#define OPTION_VAL_230_EL NULL
#define OPTION_VAL_240_EL NULL
#define OPTION_VAL_250_EL NULL
#define OPTION_VAL_260_EL NULL
#define OPTION_VAL_270_EL NULL
#define OPTION_VAL_280_EL NULL
#define OPTION_VAL_290_EL NULL
#define OPTION_VAL_300_EL NULL
#define OPTION_VAL_310_EL NULL
#define OPTION_VAL_320_EL NULL
#define OPTION_VAL_330_EL NULL
#define OPTION_VAL_340_EL NULL
#define OPTION_VAL_350_EL NULL
#define OPTION_VAL_360_EL NULL
#define OPTION_VAL_370_EL NULL
#define OPTION_VAL_380_EL NULL
#define OPTION_VAL_390_EL NULL
#define OPTION_VAL_400_EL NULL
#define OPTION_VAL_410_EL NULL
#define OPTION_VAL_420_EL NULL
#define OPTION_VAL_430_EL NULL
#define OPTION_VAL_440_EL NULL
#define OPTION_VAL_450_EL NULL
#define OPTION_VAL_460_EL NULL
#define OPTION_VAL_470_EL NULL
#define OPTION_VAL_480_EL NULL
#define OPTION_VAL_490_EL NULL
#define OPTION_VAL_500_EL NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_EL NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_EL NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_EL NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_EL NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_EL NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_EL NULL
#define OPTION_VAL_0_EL NULL
#define OPTION_VAL_5_EL NULL
#define OPTION_VAL_10_EL NULL
#define OPTION_VAL_15_EL NULL
#define OPTION_VAL_20_EL NULL
#define OPTION_VAL_25_EL NULL
#define OPTION_VAL_30_EL NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_EL NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_EL NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_EL NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_EL NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_EL NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_EL NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_EL NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_EL NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_EL NULL
#define OPTION_VAL_50_EL NULL
#define OPTION_VAL_60_EL NULL
#define OPTION_VAL_70_EL NULL
#define OPTION_VAL_80_EL "το 80%"
#define OPTION_VAL_90_EL NULL
#define OPTION_VAL_100_O46_EL NULL
#define OPTION_VAL_110_O46_EL NULL
#define OPTION_VAL_120_O46_EL NULL
#define OPTION_VAL_130_O46_EL NULL
#define OPTION_VAL_140_O46_EL NULL
#define OPTION_VAL_150_O46_EL NULL
#define OPTION_VAL_160_O46_EL NULL
#define OPTION_VAL_170_O46_EL NULL
#define OPTION_VAL_180_O46_EL NULL
#define OPTION_VAL_190_O46_EL NULL
#define OPTION_VAL_200_O46_EL NULL
#define OPTION_VAL_210_O46_EL NULL
#define OPTION_VAL_220_O46_EL NULL
#define OPTION_VAL_230_O46_EL NULL
#define OPTION_VAL_240_O46_EL NULL
#define OPTION_VAL_250_O46_EL NULL
#define OPTION_VAL_260_O46_EL NULL
#define OPTION_VAL_270_O46_EL NULL
#define OPTION_VAL_280_O46_EL NULL
#define OPTION_VAL_290_O46_EL NULL
#define OPTION_VAL_300_O46_EL NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_EL NULL
#define OPTION_VAL_WHITE_EL NULL
#define OPTION_VAL_RED_EL "Κόκκινο"
#define OPTION_VAL_GREEN_EL "Πράσινο"
#define OPTION_VAL_BLUE_EL "Μπλε"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_EL NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_EL NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_EL NULL
#define OPTION_VAL_VMU_EL NULL
#define OPTION_VAL_PURUPURU_EL NULL
#define OPTION_VAL_NONE_EL "Κανείς"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_EL NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_EL NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_EL NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_EL NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_EL NULL
#define OPTION_VAL_VMU_A1_EL NULL
#define OPTION_VAL_ALL_VMUS_EL NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_EL NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_EL NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_EL NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_EL NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_EL NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_EL NULL
#define OPTION_VAL_UPPER_LEFT_EL NULL
#define OPTION_VAL_UPPER_RIGHT_EL NULL
#define OPTION_VAL_LOWER_LEFT_EL NULL
#define OPTION_VAL_LOWER_RIGHT_EL NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_EL NULL
#define OPTION_VAL_1X_EL NULL
#define OPTION_VAL_3X_EL NULL
#define OPTION_VAL_5X_EL NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_EL NULL
#define OPTION_VAL_DEFAULT_ON_00_EL NULL
#define OPTION_VAL_DEFAULT_OFF_01_EL NULL
#define OPTION_VAL_BLACK_02_EL NULL
#define OPTION_VAL_LIGHT_BLUE_04_EL NULL
#define OPTION_VAL_CYAN_06_EL NULL
#define OPTION_VAL_CYAN_BLUE_07_EL NULL
#define OPTION_VAL_LIGHT_GREEN_08_EL NULL
#define OPTION_VAL_CYAN_GREEN_09_EL NULL
#define OPTION_VAL_LIGHT_CYAN_10_EL NULL
#define OPTION_VAL_PURPLE_12_EL NULL
#define OPTION_VAL_LIGHT_PURPLE_13_EL NULL
#define OPTION_VAL_YELLOW_14_EL "Κίτρινο"
#define OPTION_VAL_GRAY_15_EL NULL
#define OPTION_VAL_LIGHT_PURPLE_2_16_EL NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_EL NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_EL NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_EL NULL
#define OPTION_VAL_LIGHT_RED_2_20_EL NULL
#define OPTION_VAL_MAGENTA_21_EL NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_EL NULL
#define OPTION_VAL_LIGHT_ORANGE_23_EL NULL
#define OPTION_VAL_ORANGE_24_EL NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_EL NULL
#define OPTION_VAL_LIGHT_YELLOW_26_EL NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_EL NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_EL NULL
#define OPTION_VAL_40_EL NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_EL NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_EL NULL

struct retro_core_option_v2_category option_cats_el[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EL,
      CATEGORY_SYSTEM_INFO_0_EL
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EL,
      CATEGORY_VIDEO_INFO_0_EL
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_EL,
      CATEGORY_PERFORMANCE_INFO_0_EL
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EL,
      CATEGORY_HACKS_INFO_0_EL
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EL,
      CATEGORY_INPUT_INFO_0_EL
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_EL,
      CATEGORY_EXPANSIONS_INFO_0_EL
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_EL,
      CATEGORY_VMU_INFO_0_EL
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_el[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_EL,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_EL },
         { "USA",     OPTION_VAL_USA_EL },
         { "Europe",  OPTION_VAL_EUROPE_EL },
         { "Default", OPTION_VAL_DEFAULT_EL },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_EL,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_EL },
         { "English",  OPTION_VAL_ENGLISH_EL },
         { "German",   OPTION_VAL_GERMAN_EL },
         { "French",   OPTION_VAL_FRENCH_EL },
         { "Spanish",  OPTION_VAL_SPANISH_EL },
         { "Italian",  OPTION_VAL_ITALIAN_EL },
         { "Default",  OPTION_VAL_DEFAULT_EL },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_EL,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_EL,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_EL },
         { "640x480",    OPTION_VAL_640X480_EL },
         { "800x600",    OPTION_VAL_800X600_EL },
         { "960x720",    OPTION_VAL_960X720_EL },
         { "1024x768",   OPTION_VAL_1024X768_EL },
         { "1280x960",   OPTION_VAL_1280X960_EL },
         { "1440x1080",  OPTION_VAL_1440X1080_EL },
         { "1600x1200",  OPTION_VAL_1600X1200_EL },
         { "1920x1440",  OPTION_VAL_1920X1440_EL },
         { "2560x1920",  OPTION_VAL_2560X1920_EL },
         { "2880x2160",  OPTION_VAL_2880X2160_EL },
         { "3200x2400",  OPTION_VAL_3200X2400_EL },
         { "3840x2880",  OPTION_VAL_3840X2880_EL },
         { "4480x3360",  OPTION_VAL_4480X3360_EL },
         { "5120x3840",  OPTION_VAL_5120X3840_EL },
         { "5760x4320",  OPTION_VAL_5760X4320_EL },
         { "6400x4800",  OPTION_VAL_6400X4800_EL },
         { "7040x5280",  OPTION_VAL_7040X5280_EL },
         { "7680x5760",  OPTION_VAL_7680X5760_EL },
         { "8320x6240",  OPTION_VAL_8320X6240_EL },
         { "8960x6720",  OPTION_VAL_8960X6720_EL },
         { "9600x7200",  OPTION_VAL_9600X7200_EL },
         { "10240x7680", OPTION_VAL_10240X7680_EL },
         { "10880x8160", OPTION_VAL_10880X8160_EL },
         { "11520x8640", OPTION_VAL_11520X8640_EL },
         { "12160x9120", OPTION_VAL_12160X9120_EL },
         { "12800x9600", OPTION_VAL_12800X9600_EL },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_EL,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_EL },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_EL },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_EL },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_EL,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_EL },
         { "PAL",     OPTION_VAL_PAL_EL },
         { "PAL_N",   OPTION_VAL_PAL_N_EL },
         { "PAL_M",   OPTION_VAL_PAL_M_EL },
         { "Default", OPTION_VAL_DEFAULT_EL },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_EL,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_EL },
         { "vertical",   OPTION_VAL_VERTICAL_EL },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_EL,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_EL },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_EL },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_EL },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_EL,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_EL },
         { "1GB",   OPTION_VAL_1GB_EL },
         { "2GB",   OPTION_VAL_2GB_EL },
         { "4GB",   OPTION_VAL_4GB_EL },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_EL,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_EL,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_EL,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_EL,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_EL },
         { "1",  OPTION_VAL_1_EL },
         { "2",  OPTION_VAL_2_EL },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_EL,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_EL,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_EL },
         { "4",  OPTION_VAL_4_EL },
         { "6",  OPTION_VAL_6_EL },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_EL,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_EL,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_EL,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_EL,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_EL,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_EL,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_EL,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_EL },
         { "more", OPTION_VAL_MORE_EL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_EL,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_EL },
         { "110", OPTION_VAL_110_EL },
         { "120", OPTION_VAL_120_EL },
         { "130", OPTION_VAL_130_EL },
         { "140", OPTION_VAL_140_EL },
         { "150", OPTION_VAL_150_EL },
         { "160", OPTION_VAL_160_EL },
         { "170", OPTION_VAL_170_EL },
         { "180", OPTION_VAL_180_EL },
         { "190", OPTION_VAL_190_EL },
         { "200", OPTION_VAL_200_EL },
         { "210", OPTION_VAL_210_EL },
         { "220", OPTION_VAL_220_EL },
         { "230", OPTION_VAL_230_EL },
         { "240", OPTION_VAL_240_EL },
         { "250", OPTION_VAL_250_EL },
         { "260", OPTION_VAL_260_EL },
         { "270", OPTION_VAL_270_EL },
         { "280", OPTION_VAL_280_EL },
         { "290", OPTION_VAL_290_EL },
         { "300", OPTION_VAL_300_EL },
         { "310", OPTION_VAL_310_EL },
         { "320", OPTION_VAL_320_EL },
         { "330", OPTION_VAL_330_EL },
         { "340", OPTION_VAL_340_EL },
         { "350", OPTION_VAL_350_EL },
         { "360", OPTION_VAL_360_EL },
         { "370", OPTION_VAL_370_EL },
         { "380", OPTION_VAL_380_EL },
         { "390", OPTION_VAL_390_EL },
         { "400", OPTION_VAL_400_EL },
         { "410", OPTION_VAL_410_EL },
         { "420", OPTION_VAL_420_EL },
         { "430", OPTION_VAL_430_EL },
         { "440", OPTION_VAL_440_EL },
         { "450", OPTION_VAL_450_EL },
         { "460", OPTION_VAL_460_EL },
         { "470", OPTION_VAL_470_EL },
         { "480", OPTION_VAL_480_EL },
         { "490", OPTION_VAL_490_EL },
         { "500", OPTION_VAL_500_EL },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_EL,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_EL,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_EL },
         { "5%",  OPTION_VAL_5_EL },
         { "10%", OPTION_VAL_10_EL },
         { "15%", OPTION_VAL_15_EL },
         { "20%", OPTION_VAL_20_EL },
         { "25%", OPTION_VAL_25_EL },
         { "30%", OPTION_VAL_30_EL },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_EL,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_EL },
         { "5%",  OPTION_VAL_5_EL },
         { "10%", OPTION_VAL_10_EL },
         { "15%", OPTION_VAL_15_EL },
         { "20%", OPTION_VAL_20_EL },
         { "25%", OPTION_VAL_25_EL },
         { "30%", OPTION_VAL_30_EL },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_EL,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_EL,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_EL,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_EL },
         { "60%",  OPTION_VAL_60_EL },
         { "70%",  OPTION_VAL_70_EL },
         { "80%",  OPTION_VAL_80_EL },
         { "90%",  OPTION_VAL_90_EL },
         { "100%", OPTION_VAL_100_O46_EL },
         { "110%", OPTION_VAL_110_O46_EL },
         { "120%", OPTION_VAL_120_O46_EL },
         { "130%", OPTION_VAL_130_O46_EL },
         { "140%", OPTION_VAL_140_O46_EL },
         { "150%", OPTION_VAL_150_O46_EL },
         { "160%", OPTION_VAL_160_O46_EL },
         { "170%", OPTION_VAL_170_O46_EL },
         { "180%", OPTION_VAL_180_O46_EL },
         { "190%", OPTION_VAL_190_O46_EL },
         { "200%", OPTION_VAL_200_O46_EL },
         { "210%", OPTION_VAL_210_O46_EL },
         { "220%", OPTION_VAL_220_O46_EL },
         { "230%", OPTION_VAL_230_O46_EL },
         { "240%", OPTION_VAL_240_O46_EL },
         { "250%", OPTION_VAL_250_O46_EL },
         { "260%", OPTION_VAL_260_O46_EL },
         { "270%", OPTION_VAL_270_O46_EL },
         { "280%", OPTION_VAL_280_O46_EL },
         { "290%", OPTION_VAL_290_O46_EL },
         { "300%", OPTION_VAL_300_O46_EL },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_EL,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EL },
         { "Red",      OPTION_VAL_RED_EL },
         { "Green",    OPTION_VAL_GREEN_EL },
         { "Blue",     OPTION_VAL_BLUE_EL },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_EL,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EL },
         { "Red",      OPTION_VAL_RED_EL },
         { "Green",    OPTION_VAL_GREEN_EL },
         { "Blue",     OPTION_VAL_BLUE_EL },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_EL,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EL },
         { "Red",      OPTION_VAL_RED_EL },
         { "Green",    OPTION_VAL_GREEN_EL },
         { "Blue",     OPTION_VAL_BLUE_EL },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_EL,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EL },
         { "Red",      OPTION_VAL_RED_EL },
         { "Green",    OPTION_VAL_GREEN_EL },
         { "Blue",     OPTION_VAL_BLUE_EL },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_EL,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_EL,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EL },
         { "Purupuru", OPTION_VAL_PURUPURU_EL },
         { "None",     OPTION_VAL_NONE_EL },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_EL,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_EL,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_EL,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_EL },
         { "All VMUs", OPTION_VAL_ALL_VMUS_EL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_EL,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_EL,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_EL,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_EL,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_EL,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_EL,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EL },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EL },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EL },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EL },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EL },
         { "2x", OPTION_VAL_2_O27_EL },
         { "3x", OPTION_VAL_3X_EL },
         { "4x", OPTION_VAL_4_EL },
         { "5x", OPTION_VAL_5X_EL },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EL },
         { "20%",  OPTION_VAL_20_EL },
         { "30%",  OPTION_VAL_30_EL },
         { "40%",  OPTION_VAL_40_EL },
         { "50%",  OPTION_VAL_50_EL },
         { "60%",  OPTION_VAL_60_EL },
         { "70%",  OPTION_VAL_70_EL },
         { "80%",  OPTION_VAL_80_EL },
         { "90%",  OPTION_VAL_90_EL },
         { "100%", OPTION_VAL_100_O46_EL },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EL },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EL },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EL },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EL },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EL },
         { "2x", OPTION_VAL_2_O27_EL },
         { "3x", OPTION_VAL_3X_EL },
         { "4x", OPTION_VAL_4_EL },
         { "5x", OPTION_VAL_5X_EL },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EL },
         { "20%",  OPTION_VAL_20_EL },
         { "30%",  OPTION_VAL_30_EL },
         { "40%",  OPTION_VAL_40_EL },
         { "50%",  OPTION_VAL_50_EL },
         { "60%",  OPTION_VAL_60_EL },
         { "70%",  OPTION_VAL_70_EL },
         { "80%",  OPTION_VAL_80_EL },
         { "90%",  OPTION_VAL_90_EL },
         { "100%", OPTION_VAL_100_O46_EL },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EL },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EL },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EL },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EL },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EL },
         { "2x", OPTION_VAL_2_O27_EL },
         { "3x", OPTION_VAL_3X_EL },
         { "4x", OPTION_VAL_4_EL },
         { "5x", OPTION_VAL_5X_EL },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EL },
         { "20%",  OPTION_VAL_20_EL },
         { "30%",  OPTION_VAL_30_EL },
         { "40%",  OPTION_VAL_40_EL },
         { "50%",  OPTION_VAL_50_EL },
         { "60%",  OPTION_VAL_60_EL },
         { "70%",  OPTION_VAL_70_EL },
         { "80%",  OPTION_VAL_80_EL },
         { "90%",  OPTION_VAL_90_EL },
         { "100%", OPTION_VAL_100_O46_EL },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EL },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EL },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EL },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EL },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EL },
         { "2x", OPTION_VAL_2_O27_EL },
         { "3x", OPTION_VAL_3X_EL },
         { "4x", OPTION_VAL_4_EL },
         { "5x", OPTION_VAL_5X_EL },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EL },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EL },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EL },
         { "BLUE 03",           OPTION_VAL_BLUE_EL },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EL },
         { "GREEN 05",          OPTION_VAL_GREEN_EL },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EL },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EL },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EL },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EL },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EL },
         { "RED 11",            OPTION_VAL_RED_EL },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EL },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EL },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EL },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EL },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EL },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EL },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EL },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EL },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EL },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EL },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EL },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EL },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EL },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EL },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EL },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EL },
         { "WHITE 28",          OPTION_VAL_WHITE_EL },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_EL,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EL },
         { "20%",  OPTION_VAL_20_EL },
         { "30%",  OPTION_VAL_30_EL },
         { "40%",  OPTION_VAL_40_EL },
         { "50%",  OPTION_VAL_50_EL },
         { "60%",  OPTION_VAL_60_EL },
         { "70%",  OPTION_VAL_70_EL },
         { "80%",  OPTION_VAL_80_EL },
         { "90%",  OPTION_VAL_90_EL },
         { "100%", OPTION_VAL_100_O46_EL },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_el = {
   option_cats_el,
   option_defs_el
};

/* RETRO_LANGUAGE_EN */

#define CATEGORY_SYSTEM_LABEL_EN NULL
#define CATEGORY_SYSTEM_INFO_0_EN NULL
#define CATEGORY_VIDEO_LABEL_EN NULL
#define CATEGORY_VIDEO_INFO_0_EN NULL
#define CATEGORY_PERFORMANCE_LABEL_EN NULL
#define CATEGORY_PERFORMANCE_INFO_0_EN NULL
#define CATEGORY_HACKS_LABEL_EN NULL
#define CATEGORY_HACKS_INFO_0_EN NULL
#define CATEGORY_INPUT_LABEL_EN NULL
#define CATEGORY_INPUT_INFO_0_EN NULL
#define CATEGORY_EXPANSIONS_LABEL_EN NULL
#define CATEGORY_EXPANSIONS_INFO_0_EN NULL
#define CATEGORY_VMU_LABEL_EN NULL
#define CATEGORY_VMU_INFO_0_EN NULL
#define CORE_OPTION_NAME_REGION_LABEL_EN NULL
#define OPTION_VAL_JAPAN_EN NULL
#define OPTION_VAL_USA_EN NULL
#define OPTION_VAL_EUROPE_EN NULL
#define OPTION_VAL_DEFAULT_EN NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_EN NULL
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_EN NULL
#define OPTION_VAL_JAPANESE_EN NULL
#define OPTION_VAL_ENGLISH_EN NULL
#define OPTION_VAL_GERMAN_EN NULL
#define OPTION_VAL_FRENCH_EN NULL
#define OPTION_VAL_SPANISH_EN NULL
#define OPTION_VAL_ITALIAN_EN NULL
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_EN NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_EN NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_EN NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_EN NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_EN NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_EN NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_EN NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_EN NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_EN NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_EN NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_EN NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_EN "Emulate the Ethernet broadband adapter instead of the modem. (Restart Required)"
#define CORE_OPTION_NAME_UPNP_LABEL_EN NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_EN NULL
#define CORE_OPTION_NAME_DCNET_LABEL_EN NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_EN NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_EN NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_EN NULL
#define OPTION_VAL_320X240_EN NULL
#define OPTION_VAL_640X480_EN NULL
#define OPTION_VAL_800X600_EN NULL
#define OPTION_VAL_960X720_EN NULL
#define OPTION_VAL_1024X768_EN NULL
#define OPTION_VAL_1280X960_EN NULL
#define OPTION_VAL_1440X1080_EN NULL
#define OPTION_VAL_1600X1200_EN NULL
#define OPTION_VAL_1920X1440_EN NULL
#define OPTION_VAL_2560X1920_EN NULL
#define OPTION_VAL_2880X2160_EN NULL
#define OPTION_VAL_3200X2400_EN NULL
#define OPTION_VAL_3840X2880_EN NULL
#define OPTION_VAL_4480X3360_EN NULL
#define OPTION_VAL_5120X3840_EN NULL
#define OPTION_VAL_5760X4320_EN NULL
#define OPTION_VAL_6400X4800_EN NULL
#define OPTION_VAL_7040X5280_EN NULL
#define OPTION_VAL_7680X5760_EN NULL
#define OPTION_VAL_8320X6240_EN NULL
#define OPTION_VAL_8960X6720_EN NULL
#define OPTION_VAL_9600X7200_EN NULL
#define OPTION_VAL_10240X7680_EN NULL
#define OPTION_VAL_10880X8160_EN NULL
#define OPTION_VAL_11520X8640_EN NULL
#define OPTION_VAL_12160X9120_EN NULL
#define OPTION_VAL_12800X9600_EN NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_EN NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_EN NULL
#define OPTION_VAL_VGA_EN NULL
#define OPTION_VAL_TV_RGB_EN NULL
#define OPTION_VAL_TV_COMPOSITE_EN NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_EN NULL
#define OPTION_VAL_NTSC_EN NULL
#define OPTION_VAL_PAL_EN NULL
#define OPTION_VAL_PAL_N_EN NULL
#define OPTION_VAL_PAL_M_EN NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_EN NULL
#define OPTION_VAL_HORIZONTAL_EN NULL
#define OPTION_VAL_VERTICAL_EN NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_EN NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_EN NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_EN NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_EN NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_EN NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_EN NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_EN NULL
#define OPTION_VAL_512MB_EN NULL
#define OPTION_VAL_1GB_EN NULL
#define OPTION_VAL_2GB_EN NULL
#define OPTION_VAL_4GB_EN NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_EN NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_EN NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_EN "Full frame-buffer emulation"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_EN "Enable full frame-buffer emulation in VRAM. This is useful for games that directly read or write the frame-buffer in VRAM. When enabled, Internal Resolution is forced to 640x480 and performance may be severely impacted."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_EN NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_EN NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_EN NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_EN NULL
#define CORE_OPTION_NAME_FOG_LABEL_EN NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_EN NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_EN NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_EN NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_EN NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_EN NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_EN NULL
#define OPTION_VAL_1_EN "Force Nearest-Neighbour"
#define OPTION_VAL_2_EN NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_EN NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_EN NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_EN NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_EN "Notify front-end when internal frame rate changes (e.g. from 60 fps to 30 fps). Improves frame pacing in games that run at a locked 30 fps or 20 fps, but should be disabled for games with unlocked (unstable) frame rates (e.g. Ecco the Dolphin, Unreal Tournament). Note: Unavailable when 'Auto Skip Frame' is enabled."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_EN NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_EN "Post-process the rendered image to simulate effects specific to the PowerVR2 GPU and analogue video signals."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_EN NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_EN NULL
#define OPTION_VAL_2_O27_EN NULL
#define OPTION_VAL_4_EN NULL
#define OPTION_VAL_6_EN NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_EN "Texture Upscaling Maximum Filtered Size"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_EN NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_EN NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_EN NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_EN NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_EN NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_EN NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_EN NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_EN NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_EN NULL
#define OPTION_VAL_SOME_EN NULL
#define OPTION_VAL_MORE_EN NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_EN NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_EN NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_EN NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_EN NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_EN NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_EN NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_EN NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_EN NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_EN NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_EN NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_EN NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_EN NULL
#define OPTION_VAL_100_EN NULL
#define OPTION_VAL_110_EN NULL
#define OPTION_VAL_120_EN NULL
#define OPTION_VAL_130_EN NULL
#define OPTION_VAL_140_EN NULL
#define OPTION_VAL_150_EN NULL
#define OPTION_VAL_160_EN NULL
#define OPTION_VAL_170_EN NULL
#define OPTION_VAL_180_EN NULL
#define OPTION_VAL_190_EN NULL
#define OPTION_VAL_200_EN NULL
#define OPTION_VAL_210_EN NULL
#define OPTION_VAL_220_EN NULL
#define OPTION_VAL_230_EN NULL
#define OPTION_VAL_240_EN NULL
#define OPTION_VAL_250_EN NULL
#define OPTION_VAL_260_EN NULL
#define OPTION_VAL_270_EN NULL
#define OPTION_VAL_280_EN NULL
#define OPTION_VAL_290_EN NULL
#define OPTION_VAL_300_EN NULL
#define OPTION_VAL_310_EN NULL
#define OPTION_VAL_320_EN NULL
#define OPTION_VAL_330_EN NULL
#define OPTION_VAL_340_EN NULL
#define OPTION_VAL_350_EN NULL
#define OPTION_VAL_360_EN NULL
#define OPTION_VAL_370_EN NULL
#define OPTION_VAL_380_EN NULL
#define OPTION_VAL_390_EN NULL
#define OPTION_VAL_400_EN NULL
#define OPTION_VAL_410_EN NULL
#define OPTION_VAL_420_EN NULL
#define OPTION_VAL_430_EN NULL
#define OPTION_VAL_440_EN NULL
#define OPTION_VAL_450_EN NULL
#define OPTION_VAL_460_EN NULL
#define OPTION_VAL_470_EN NULL
#define OPTION_VAL_480_EN NULL
#define OPTION_VAL_490_EN NULL
#define OPTION_VAL_500_EN NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_EN NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_EN NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_EN NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_EN NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_EN "Analogue Stick Dead-zone"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_EN "Select how far you have to push the analogue stick before it starts being processed."
#define OPTION_VAL_0_EN NULL
#define OPTION_VAL_5_EN NULL
#define OPTION_VAL_10_EN NULL
#define OPTION_VAL_15_EN NULL
#define OPTION_VAL_20_EN NULL
#define OPTION_VAL_25_EN NULL
#define OPTION_VAL_30_EN NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_EN "Trigger Dead-zone"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_EN NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_EN NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_EN NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_EN NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_EN NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_EN NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_EN "Enable configuration of light gun cross-hair display options. NOTE: Quick Menu may need to be toggled for this setting to take effect."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_EN NULL
#define OPTION_VAL_50_EN NULL
#define OPTION_VAL_60_EN NULL
#define OPTION_VAL_70_EN NULL
#define OPTION_VAL_80_EN NULL
#define OPTION_VAL_90_EN NULL
#define OPTION_VAL_100_O46_EN NULL
#define OPTION_VAL_110_O46_EN NULL
#define OPTION_VAL_120_O46_EN NULL
#define OPTION_VAL_130_O46_EN NULL
#define OPTION_VAL_140_O46_EN NULL
#define OPTION_VAL_150_O46_EN NULL
#define OPTION_VAL_160_O46_EN NULL
#define OPTION_VAL_170_O46_EN NULL
#define OPTION_VAL_180_O46_EN NULL
#define OPTION_VAL_190_O46_EN NULL
#define OPTION_VAL_200_O46_EN NULL
#define OPTION_VAL_210_O46_EN NULL
#define OPTION_VAL_220_O46_EN NULL
#define OPTION_VAL_230_O46_EN NULL
#define OPTION_VAL_240_O46_EN NULL
#define OPTION_VAL_250_O46_EN NULL
#define OPTION_VAL_260_O46_EN NULL
#define OPTION_VAL_270_O46_EN NULL
#define OPTION_VAL_280_O46_EN NULL
#define OPTION_VAL_290_O46_EN NULL
#define OPTION_VAL_300_O46_EN NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_EN NULL
#define OPTION_VAL_WHITE_EN NULL
#define OPTION_VAL_RED_EN NULL
#define OPTION_VAL_GREEN_EN NULL
#define OPTION_VAL_BLUE_EN NULL
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_EN NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_EN NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_EN NULL
#define OPTION_VAL_VMU_EN NULL
#define OPTION_VAL_PURUPURU_EN NULL
#define OPTION_VAL_NONE_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_EN NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_EN NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_EN NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_EN NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_EN NULL
#define OPTION_VAL_VMU_A1_EN NULL
#define OPTION_VAL_ALL_VMUS_EN NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_EN NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_EN NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_EN NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_EN NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_EN "Enable configuration of emulated VMU LCD screen visibility, size, position and colour. NOTE: Quick Menu may need to be toggled for this setting to take effect."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_EN NULL
#define OPTION_VAL_UPPER_LEFT_EN NULL
#define OPTION_VAL_UPPER_RIGHT_EN NULL
#define OPTION_VAL_LOWER_LEFT_EN NULL
#define OPTION_VAL_LOWER_RIGHT_EN NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_EN NULL
#define OPTION_VAL_1X_EN NULL
#define OPTION_VAL_3X_EN NULL
#define OPTION_VAL_5X_EN NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_EN NULL
#define OPTION_VAL_DEFAULT_ON_00_EN NULL
#define OPTION_VAL_DEFAULT_OFF_01_EN NULL
#define OPTION_VAL_BLACK_02_EN NULL
#define OPTION_VAL_LIGHT_BLUE_04_EN NULL
#define OPTION_VAL_CYAN_06_EN NULL
#define OPTION_VAL_CYAN_BLUE_07_EN NULL
#define OPTION_VAL_LIGHT_GREEN_08_EN NULL
#define OPTION_VAL_CYAN_GREEN_09_EN NULL
#define OPTION_VAL_LIGHT_CYAN_10_EN NULL
#define OPTION_VAL_PURPLE_12_EN NULL
#define OPTION_VAL_LIGHT_PURPLE_13_EN NULL
#define OPTION_VAL_YELLOW_14_EN NULL
#define OPTION_VAL_GRAY_15_EN "Grey"
#define OPTION_VAL_LIGHT_PURPLE_2_16_EN NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_EN NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_EN NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_EN NULL
#define OPTION_VAL_LIGHT_RED_2_20_EN NULL
#define OPTION_VAL_MAGENTA_21_EN NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_EN NULL
#define OPTION_VAL_LIGHT_ORANGE_23_EN NULL
#define OPTION_VAL_ORANGE_24_EN NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_EN NULL
#define OPTION_VAL_LIGHT_YELLOW_26_EN NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_EN NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_EN NULL
#define OPTION_VAL_40_EN NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_EN NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_EN NULL

struct retro_core_option_v2_category option_cats_en[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EN,
      CATEGORY_SYSTEM_INFO_0_EN
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EN,
      CATEGORY_VIDEO_INFO_0_EN
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_EN,
      CATEGORY_PERFORMANCE_INFO_0_EN
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EN,
      CATEGORY_HACKS_INFO_0_EN
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EN,
      CATEGORY_INPUT_INFO_0_EN
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_EN,
      CATEGORY_EXPANSIONS_INFO_0_EN
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_EN,
      CATEGORY_VMU_INFO_0_EN
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_en[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_EN,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_EN },
         { "USA",     OPTION_VAL_USA_EN },
         { "Europe",  OPTION_VAL_EUROPE_EN },
         { "Default", OPTION_VAL_DEFAULT_EN },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_EN,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_EN },
         { "English",  OPTION_VAL_ENGLISH_EN },
         { "German",   OPTION_VAL_GERMAN_EN },
         { "French",   OPTION_VAL_FRENCH_EN },
         { "Spanish",  OPTION_VAL_SPANISH_EN },
         { "Italian",  OPTION_VAL_ITALIAN_EN },
         { "Default",  OPTION_VAL_DEFAULT_EN },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_EN,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_EN,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_EN },
         { "640x480",    OPTION_VAL_640X480_EN },
         { "800x600",    OPTION_VAL_800X600_EN },
         { "960x720",    OPTION_VAL_960X720_EN },
         { "1024x768",   OPTION_VAL_1024X768_EN },
         { "1280x960",   OPTION_VAL_1280X960_EN },
         { "1440x1080",  OPTION_VAL_1440X1080_EN },
         { "1600x1200",  OPTION_VAL_1600X1200_EN },
         { "1920x1440",  OPTION_VAL_1920X1440_EN },
         { "2560x1920",  OPTION_VAL_2560X1920_EN },
         { "2880x2160",  OPTION_VAL_2880X2160_EN },
         { "3200x2400",  OPTION_VAL_3200X2400_EN },
         { "3840x2880",  OPTION_VAL_3840X2880_EN },
         { "4480x3360",  OPTION_VAL_4480X3360_EN },
         { "5120x3840",  OPTION_VAL_5120X3840_EN },
         { "5760x4320",  OPTION_VAL_5760X4320_EN },
         { "6400x4800",  OPTION_VAL_6400X4800_EN },
         { "7040x5280",  OPTION_VAL_7040X5280_EN },
         { "7680x5760",  OPTION_VAL_7680X5760_EN },
         { "8320x6240",  OPTION_VAL_8320X6240_EN },
         { "8960x6720",  OPTION_VAL_8960X6720_EN },
         { "9600x7200",  OPTION_VAL_9600X7200_EN },
         { "10240x7680", OPTION_VAL_10240X7680_EN },
         { "10880x8160", OPTION_VAL_10880X8160_EN },
         { "11520x8640", OPTION_VAL_11520X8640_EN },
         { "12160x9120", OPTION_VAL_12160X9120_EN },
         { "12800x9600", OPTION_VAL_12800X9600_EN },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_EN,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_EN },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_EN },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_EN },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_EN,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_EN },
         { "PAL",     OPTION_VAL_PAL_EN },
         { "PAL_N",   OPTION_VAL_PAL_N_EN },
         { "PAL_M",   OPTION_VAL_PAL_M_EN },
         { "Default", OPTION_VAL_DEFAULT_EN },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_EN,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_EN },
         { "vertical",   OPTION_VAL_VERTICAL_EN },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_EN,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_EN },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_EN },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_EN },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_EN,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_EN },
         { "1GB",   OPTION_VAL_1GB_EN },
         { "2GB",   OPTION_VAL_2GB_EN },
         { "4GB",   OPTION_VAL_4GB_EN },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_EN,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_EN,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_EN,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_EN,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_EN },
         { "1",  OPTION_VAL_1_EN },
         { "2",  OPTION_VAL_2_EN },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_EN,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_EN,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_EN },
         { "4",  OPTION_VAL_4_EN },
         { "6",  OPTION_VAL_6_EN },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_EN,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_EN,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_EN,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_EN,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_EN,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_EN,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_EN,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_EN },
         { "more", OPTION_VAL_MORE_EN },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_EN,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_EN },
         { "110", OPTION_VAL_110_EN },
         { "120", OPTION_VAL_120_EN },
         { "130", OPTION_VAL_130_EN },
         { "140", OPTION_VAL_140_EN },
         { "150", OPTION_VAL_150_EN },
         { "160", OPTION_VAL_160_EN },
         { "170", OPTION_VAL_170_EN },
         { "180", OPTION_VAL_180_EN },
         { "190", OPTION_VAL_190_EN },
         { "200", OPTION_VAL_200_EN },
         { "210", OPTION_VAL_210_EN },
         { "220", OPTION_VAL_220_EN },
         { "230", OPTION_VAL_230_EN },
         { "240", OPTION_VAL_240_EN },
         { "250", OPTION_VAL_250_EN },
         { "260", OPTION_VAL_260_EN },
         { "270", OPTION_VAL_270_EN },
         { "280", OPTION_VAL_280_EN },
         { "290", OPTION_VAL_290_EN },
         { "300", OPTION_VAL_300_EN },
         { "310", OPTION_VAL_310_EN },
         { "320", OPTION_VAL_320_EN },
         { "330", OPTION_VAL_330_EN },
         { "340", OPTION_VAL_340_EN },
         { "350", OPTION_VAL_350_EN },
         { "360", OPTION_VAL_360_EN },
         { "370", OPTION_VAL_370_EN },
         { "380", OPTION_VAL_380_EN },
         { "390", OPTION_VAL_390_EN },
         { "400", OPTION_VAL_400_EN },
         { "410", OPTION_VAL_410_EN },
         { "420", OPTION_VAL_420_EN },
         { "430", OPTION_VAL_430_EN },
         { "440", OPTION_VAL_440_EN },
         { "450", OPTION_VAL_450_EN },
         { "460", OPTION_VAL_460_EN },
         { "470", OPTION_VAL_470_EN },
         { "480", OPTION_VAL_480_EN },
         { "490", OPTION_VAL_490_EN },
         { "500", OPTION_VAL_500_EN },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_EN,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_EN,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_EN },
         { "5%",  OPTION_VAL_5_EN },
         { "10%", OPTION_VAL_10_EN },
         { "15%", OPTION_VAL_15_EN },
         { "20%", OPTION_VAL_20_EN },
         { "25%", OPTION_VAL_25_EN },
         { "30%", OPTION_VAL_30_EN },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_EN,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_EN },
         { "5%",  OPTION_VAL_5_EN },
         { "10%", OPTION_VAL_10_EN },
         { "15%", OPTION_VAL_15_EN },
         { "20%", OPTION_VAL_20_EN },
         { "25%", OPTION_VAL_25_EN },
         { "30%", OPTION_VAL_30_EN },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_EN,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_EN,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_EN,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_EN },
         { "60%",  OPTION_VAL_60_EN },
         { "70%",  OPTION_VAL_70_EN },
         { "80%",  OPTION_VAL_80_EN },
         { "90%",  OPTION_VAL_90_EN },
         { "100%", OPTION_VAL_100_O46_EN },
         { "110%", OPTION_VAL_110_O46_EN },
         { "120%", OPTION_VAL_120_O46_EN },
         { "130%", OPTION_VAL_130_O46_EN },
         { "140%", OPTION_VAL_140_O46_EN },
         { "150%", OPTION_VAL_150_O46_EN },
         { "160%", OPTION_VAL_160_O46_EN },
         { "170%", OPTION_VAL_170_O46_EN },
         { "180%", OPTION_VAL_180_O46_EN },
         { "190%", OPTION_VAL_190_O46_EN },
         { "200%", OPTION_VAL_200_O46_EN },
         { "210%", OPTION_VAL_210_O46_EN },
         { "220%", OPTION_VAL_220_O46_EN },
         { "230%", OPTION_VAL_230_O46_EN },
         { "240%", OPTION_VAL_240_O46_EN },
         { "250%", OPTION_VAL_250_O46_EN },
         { "260%", OPTION_VAL_260_O46_EN },
         { "270%", OPTION_VAL_270_O46_EN },
         { "280%", OPTION_VAL_280_O46_EN },
         { "290%", OPTION_VAL_290_O46_EN },
         { "300%", OPTION_VAL_300_O46_EN },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_EN,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EN },
         { "Red",      OPTION_VAL_RED_EN },
         { "Green",    OPTION_VAL_GREEN_EN },
         { "Blue",     OPTION_VAL_BLUE_EN },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_EN,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EN },
         { "Red",      OPTION_VAL_RED_EN },
         { "Green",    OPTION_VAL_GREEN_EN },
         { "Blue",     OPTION_VAL_BLUE_EN },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_EN,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EN },
         { "Red",      OPTION_VAL_RED_EN },
         { "Green",    OPTION_VAL_GREEN_EN },
         { "Blue",     OPTION_VAL_BLUE_EN },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_EN,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EN },
         { "Red",      OPTION_VAL_RED_EN },
         { "Green",    OPTION_VAL_GREEN_EN },
         { "Blue",     OPTION_VAL_BLUE_EN },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_EN,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_EN,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EN },
         { "Purupuru", OPTION_VAL_PURUPURU_EN },
         { "None",     OPTION_VAL_NONE_EN },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_EN,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_EN,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_EN,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_EN },
         { "All VMUs", OPTION_VAL_ALL_VMUS_EN },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_EN,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_EN,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_EN,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_EN,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_EN,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_EN,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EN },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EN },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EN },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EN },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EN },
         { "2x", OPTION_VAL_2_O27_EN },
         { "3x", OPTION_VAL_3X_EN },
         { "4x", OPTION_VAL_4_EN },
         { "5x", OPTION_VAL_5X_EN },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EN },
         { "20%",  OPTION_VAL_20_EN },
         { "30%",  OPTION_VAL_30_EN },
         { "40%",  OPTION_VAL_40_EN },
         { "50%",  OPTION_VAL_50_EN },
         { "60%",  OPTION_VAL_60_EN },
         { "70%",  OPTION_VAL_70_EN },
         { "80%",  OPTION_VAL_80_EN },
         { "90%",  OPTION_VAL_90_EN },
         { "100%", OPTION_VAL_100_O46_EN },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EN },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EN },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EN },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EN },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EN },
         { "2x", OPTION_VAL_2_O27_EN },
         { "3x", OPTION_VAL_3X_EN },
         { "4x", OPTION_VAL_4_EN },
         { "5x", OPTION_VAL_5X_EN },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EN },
         { "20%",  OPTION_VAL_20_EN },
         { "30%",  OPTION_VAL_30_EN },
         { "40%",  OPTION_VAL_40_EN },
         { "50%",  OPTION_VAL_50_EN },
         { "60%",  OPTION_VAL_60_EN },
         { "70%",  OPTION_VAL_70_EN },
         { "80%",  OPTION_VAL_80_EN },
         { "90%",  OPTION_VAL_90_EN },
         { "100%", OPTION_VAL_100_O46_EN },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EN },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EN },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EN },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EN },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EN },
         { "2x", OPTION_VAL_2_O27_EN },
         { "3x", OPTION_VAL_3X_EN },
         { "4x", OPTION_VAL_4_EN },
         { "5x", OPTION_VAL_5X_EN },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EN },
         { "20%",  OPTION_VAL_20_EN },
         { "30%",  OPTION_VAL_30_EN },
         { "40%",  OPTION_VAL_40_EN },
         { "50%",  OPTION_VAL_50_EN },
         { "60%",  OPTION_VAL_60_EN },
         { "70%",  OPTION_VAL_70_EN },
         { "80%",  OPTION_VAL_80_EN },
         { "90%",  OPTION_VAL_90_EN },
         { "100%", OPTION_VAL_100_O46_EN },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EN },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EN },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EN },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EN },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EN },
         { "2x", OPTION_VAL_2_O27_EN },
         { "3x", OPTION_VAL_3X_EN },
         { "4x", OPTION_VAL_4_EN },
         { "5x", OPTION_VAL_5X_EN },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EN },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EN },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EN },
         { "BLUE 03",           OPTION_VAL_BLUE_EN },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EN },
         { "GREEN 05",          OPTION_VAL_GREEN_EN },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EN },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EN },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EN },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EN },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EN },
         { "RED 11",            OPTION_VAL_RED_EN },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EN },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EN },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EN },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EN },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EN },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EN },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EN },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EN },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EN },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EN },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EN },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EN },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EN },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EN },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EN },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EN },
         { "WHITE 28",          OPTION_VAL_WHITE_EN },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_EN,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EN },
         { "20%",  OPTION_VAL_20_EN },
         { "30%",  OPTION_VAL_30_EN },
         { "40%",  OPTION_VAL_40_EN },
         { "50%",  OPTION_VAL_50_EN },
         { "60%",  OPTION_VAL_60_EN },
         { "70%",  OPTION_VAL_70_EN },
         { "80%",  OPTION_VAL_80_EN },
         { "90%",  OPTION_VAL_90_EN },
         { "100%", OPTION_VAL_100_O46_EN },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_en = {
   option_cats_en,
   option_defs_en
};

/* RETRO_LANGUAGE_EO */

#define CATEGORY_SYSTEM_LABEL_EO NULL
#define CATEGORY_SYSTEM_INFO_0_EO NULL
#define CATEGORY_VIDEO_LABEL_EO "Video Driver"
#define CATEGORY_VIDEO_INFO_0_EO NULL
#define CATEGORY_PERFORMANCE_LABEL_EO NULL
#define CATEGORY_PERFORMANCE_INFO_0_EO NULL
#define CATEGORY_HACKS_LABEL_EO NULL
#define CATEGORY_HACKS_INFO_0_EO NULL
#define CATEGORY_INPUT_LABEL_EO "Input Driver"
#define CATEGORY_INPUT_INFO_0_EO NULL
#define CATEGORY_EXPANSIONS_LABEL_EO NULL
#define CATEGORY_EXPANSIONS_INFO_0_EO NULL
#define CATEGORY_VMU_LABEL_EO NULL
#define CATEGORY_VMU_INFO_0_EO NULL
#define CORE_OPTION_NAME_REGION_LABEL_EO NULL
#define OPTION_VAL_JAPAN_EO NULL
#define OPTION_VAL_USA_EO NULL
#define OPTION_VAL_EUROPE_EO NULL
#define OPTION_VAL_DEFAULT_EO NULL
#define CORE_OPTION_NAME_LANGUAGE_LABEL_EO NULL
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_EO NULL
#define OPTION_VAL_JAPANESE_EO NULL
#define OPTION_VAL_ENGLISH_EO NULL
#define OPTION_VAL_GERMAN_EO NULL
#define OPTION_VAL_FRENCH_EO NULL
#define OPTION_VAL_SPANISH_EO NULL
#define OPTION_VAL_ITALIAN_EO NULL
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_EO NULL
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_EO NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_EO NULL
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_EO NULL
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_EO NULL
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_EO NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_EO NULL
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_EO NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_EO NULL
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_EO NULL
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_EO NULL
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_EO NULL
#define CORE_OPTION_NAME_UPNP_LABEL_EO NULL
#define CORE_OPTION_NAME_UPNP_INFO_0_EO NULL
#define CORE_OPTION_NAME_DCNET_LABEL_EO NULL
#define CORE_OPTION_NAME_DCNET_INFO_0_EO NULL
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_EO "Interna Rezolucio"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_EO NULL
#define OPTION_VAL_320X240_EO NULL
#define OPTION_VAL_640X480_EO NULL
#define OPTION_VAL_800X600_EO NULL
#define OPTION_VAL_960X720_EO NULL
#define OPTION_VAL_1024X768_EO NULL
#define OPTION_VAL_1280X960_EO NULL
#define OPTION_VAL_1440X1080_EO NULL
#define OPTION_VAL_1600X1200_EO NULL
#define OPTION_VAL_1920X1440_EO NULL
#define OPTION_VAL_2560X1920_EO NULL
#define OPTION_VAL_2880X2160_EO NULL
#define OPTION_VAL_3200X2400_EO NULL
#define OPTION_VAL_3840X2880_EO NULL
#define OPTION_VAL_4480X3360_EO NULL
#define OPTION_VAL_5120X3840_EO NULL
#define OPTION_VAL_5760X4320_EO NULL
#define OPTION_VAL_6400X4800_EO NULL
#define OPTION_VAL_7040X5280_EO NULL
#define OPTION_VAL_7680X5760_EO NULL
#define OPTION_VAL_8320X6240_EO NULL
#define OPTION_VAL_8960X6720_EO NULL
#define OPTION_VAL_9600X7200_EO NULL
#define OPTION_VAL_10240X7680_EO NULL
#define OPTION_VAL_10880X8160_EO NULL
#define OPTION_VAL_11520X8640_EO NULL
#define OPTION_VAL_12160X9120_EO NULL
#define OPTION_VAL_12800X9600_EO NULL
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_EO NULL
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_EO NULL
#define OPTION_VAL_VGA_EO NULL
#define OPTION_VAL_TV_RGB_EO NULL
#define OPTION_VAL_TV_COMPOSITE_EO NULL
#define CORE_OPTION_NAME_BROADCAST_LABEL_EO NULL
#define OPTION_VAL_NTSC_EO NULL
#define OPTION_VAL_PAL_EO NULL
#define OPTION_VAL_PAL_N_EO NULL
#define OPTION_VAL_PAL_M_EO NULL
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_EO NULL
#define OPTION_VAL_HORIZONTAL_EO NULL
#define OPTION_VAL_VERTICAL_EO NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_EO NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_EO NULL
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_EO NULL
#define OPTION_VAL_PER_TRIANGLE_NORMAL_EO NULL
#define OPTION_VAL_PER_PIXEL_ACCURATE_EO NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_EO NULL
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_EO NULL
#define OPTION_VAL_512MB_EO NULL
#define OPTION_VAL_1GB_EO NULL
#define OPTION_VAL_2GB_EO NULL
#define OPTION_VAL_4GB_EO NULL
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_EO NULL
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_EO NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_EO NULL
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_EO NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_EO NULL
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_EO NULL
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_EO NULL
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_EO NULL
#define CORE_OPTION_NAME_FOG_LABEL_EO NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_EO NULL
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_EO NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_EO NULL
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_EO NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_EO NULL
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_EO NULL
#define OPTION_VAL_1_EO NULL
#define OPTION_VAL_2_EO NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_EO NULL
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_EO NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_EO NULL
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_EO NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_EO NULL
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_EO NULL
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_EO NULL
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_EO NULL
#define OPTION_VAL_2_O27_EO NULL
#define OPTION_VAL_4_EO NULL
#define OPTION_VAL_6_EO NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_EO NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_EO NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_EO NULL
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_EO NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_EO NULL
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_EO NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_EO NULL
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_EO NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_EO NULL
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_EO NULL
#define OPTION_VAL_SOME_EO NULL
#define OPTION_VAL_MORE_EO NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_EO NULL
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_EO NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_EO NULL
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_EO NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_EO NULL
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_EO NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_EO NULL
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_EO NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_EO NULL
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_EO NULL
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_EO NULL
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_EO NULL
#define OPTION_VAL_100_EO NULL
#define OPTION_VAL_110_EO NULL
#define OPTION_VAL_120_EO NULL
#define OPTION_VAL_130_EO NULL
#define OPTION_VAL_140_EO NULL
#define OPTION_VAL_150_EO NULL
#define OPTION_VAL_160_EO NULL
#define OPTION_VAL_170_EO NULL
#define OPTION_VAL_180_EO NULL
#define OPTION_VAL_190_EO NULL
#define OPTION_VAL_200_EO NULL
#define OPTION_VAL_210_EO NULL
#define OPTION_VAL_220_EO NULL
#define OPTION_VAL_230_EO NULL
#define OPTION_VAL_240_EO NULL
#define OPTION_VAL_250_EO NULL
#define OPTION_VAL_260_EO NULL
#define OPTION_VAL_270_EO NULL
#define OPTION_VAL_280_EO NULL
#define OPTION_VAL_290_EO NULL
#define OPTION_VAL_300_EO NULL
#define OPTION_VAL_310_EO NULL
#define OPTION_VAL_320_EO NULL
#define OPTION_VAL_330_EO NULL
#define OPTION_VAL_340_EO NULL
#define OPTION_VAL_350_EO NULL
#define OPTION_VAL_360_EO NULL
#define OPTION_VAL_370_EO NULL
#define OPTION_VAL_380_EO NULL
#define OPTION_VAL_390_EO NULL
#define OPTION_VAL_400_EO NULL
#define OPTION_VAL_410_EO NULL
#define OPTION_VAL_420_EO NULL
#define OPTION_VAL_430_EO NULL
#define OPTION_VAL_440_EO NULL
#define OPTION_VAL_450_EO NULL
#define OPTION_VAL_460_EO NULL
#define OPTION_VAL_470_EO NULL
#define OPTION_VAL_480_EO NULL
#define OPTION_VAL_490_EO NULL
#define OPTION_VAL_500_EO NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_EO NULL
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_EO NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_EO NULL
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_EO NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_EO NULL
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_EO NULL
#define OPTION_VAL_0_EO NULL
#define OPTION_VAL_5_EO NULL
#define OPTION_VAL_10_EO NULL
#define OPTION_VAL_15_EO NULL
#define OPTION_VAL_20_EO NULL
#define OPTION_VAL_25_EO NULL
#define OPTION_VAL_30_EO NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_EO NULL
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_EO NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_EO NULL
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_EO NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_EO NULL
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_EO NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_EO NULL
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_EO NULL
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_EO NULL
#define OPTION_VAL_50_EO NULL
#define OPTION_VAL_60_EO NULL
#define OPTION_VAL_70_EO NULL
#define OPTION_VAL_80_EO NULL
#define OPTION_VAL_90_EO NULL
#define OPTION_VAL_100_O46_EO NULL
#define OPTION_VAL_110_O46_EO NULL
#define OPTION_VAL_120_O46_EO NULL
#define OPTION_VAL_130_O46_EO NULL
#define OPTION_VAL_140_O46_EO NULL
#define OPTION_VAL_150_O46_EO NULL
#define OPTION_VAL_160_O46_EO NULL
#define OPTION_VAL_170_O46_EO NULL
#define OPTION_VAL_180_O46_EO NULL
#define OPTION_VAL_190_O46_EO NULL
#define OPTION_VAL_200_O46_EO NULL
#define OPTION_VAL_210_O46_EO NULL
#define OPTION_VAL_220_O46_EO NULL
#define OPTION_VAL_230_O46_EO NULL
#define OPTION_VAL_240_O46_EO NULL
#define OPTION_VAL_250_O46_EO NULL
#define OPTION_VAL_260_O46_EO NULL
#define OPTION_VAL_270_O46_EO NULL
#define OPTION_VAL_280_O46_EO NULL
#define OPTION_VAL_290_O46_EO NULL
#define OPTION_VAL_300_O46_EO NULL
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_EO NULL
#define OPTION_VAL_WHITE_EO NULL
#define OPTION_VAL_RED_EO NULL
#define OPTION_VAL_GREEN_EO NULL
#define OPTION_VAL_BLUE_EO NULL
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_EO NULL
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_EO NULL
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_EO NULL
#define OPTION_VAL_VMU_EO NULL
#define OPTION_VAL_PURUPURU_EO NULL
#define OPTION_VAL_NONE_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_EO NULL
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_EO NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_EO NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_EO NULL
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_EO NULL
#define OPTION_VAL_VMU_A1_EO NULL
#define OPTION_VAL_ALL_VMUS_EO NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_EO NULL
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_EO NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_EO NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_EO NULL
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_EO NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_EO NULL
#define OPTION_VAL_UPPER_LEFT_EO NULL
#define OPTION_VAL_UPPER_RIGHT_EO NULL
#define OPTION_VAL_LOWER_LEFT_EO NULL
#define OPTION_VAL_LOWER_RIGHT_EO NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_EO NULL
#define OPTION_VAL_1X_EO NULL
#define OPTION_VAL_3X_EO NULL
#define OPTION_VAL_5X_EO NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_EO NULL
#define OPTION_VAL_DEFAULT_ON_00_EO NULL
#define OPTION_VAL_DEFAULT_OFF_01_EO NULL
#define OPTION_VAL_BLACK_02_EO NULL
#define OPTION_VAL_LIGHT_BLUE_04_EO NULL
#define OPTION_VAL_CYAN_06_EO NULL
#define OPTION_VAL_CYAN_BLUE_07_EO NULL
#define OPTION_VAL_LIGHT_GREEN_08_EO NULL
#define OPTION_VAL_CYAN_GREEN_09_EO NULL
#define OPTION_VAL_LIGHT_CYAN_10_EO NULL
#define OPTION_VAL_PURPLE_12_EO NULL
#define OPTION_VAL_LIGHT_PURPLE_13_EO NULL
#define OPTION_VAL_YELLOW_14_EO NULL
#define OPTION_VAL_GRAY_15_EO NULL
#define OPTION_VAL_LIGHT_PURPLE_2_16_EO NULL
#define OPTION_VAL_LIGHT_GREEN_2_17_EO NULL
#define OPTION_VAL_LIGHT_GREEN_3_18_EO NULL
#define OPTION_VAL_LIGHT_CYAN_2_19_EO NULL
#define OPTION_VAL_LIGHT_RED_2_20_EO NULL
#define OPTION_VAL_MAGENTA_21_EO NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_EO NULL
#define OPTION_VAL_LIGHT_ORANGE_23_EO NULL
#define OPTION_VAL_ORANGE_24_EO NULL
#define OPTION_VAL_LIGHT_PURPLE_4_25_EO NULL
#define OPTION_VAL_LIGHT_YELLOW_26_EO NULL
#define OPTION_VAL_LIGHT_YELLOW_2_27_EO NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_EO NULL
#define OPTION_VAL_40_EO NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_EO NULL
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_EO NULL

struct retro_core_option_v2_category option_cats_eo[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_EO,
      CATEGORY_SYSTEM_INFO_0_EO
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_EO,
      CATEGORY_VIDEO_INFO_0_EO
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_EO,
      CATEGORY_PERFORMANCE_INFO_0_EO
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_EO,
      CATEGORY_HACKS_INFO_0_EO
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_EO,
      CATEGORY_INPUT_INFO_0_EO
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_EO,
      CATEGORY_EXPANSIONS_INFO_0_EO
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_EO,
      CATEGORY_VMU_INFO_0_EO
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_eo[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_EO,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_EO },
         { "USA",     OPTION_VAL_USA_EO },
         { "Europe",  OPTION_VAL_EUROPE_EO },
         { "Default", OPTION_VAL_DEFAULT_EO },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_EO,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_EO },
         { "English",  OPTION_VAL_ENGLISH_EO },
         { "German",   OPTION_VAL_GERMAN_EO },
         { "French",   OPTION_VAL_FRENCH_EO },
         { "Spanish",  OPTION_VAL_SPANISH_EO },
         { "Italian",  OPTION_VAL_ITALIAN_EO },
         { "Default",  OPTION_VAL_DEFAULT_EO },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DCNET_INFO_0_EO,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },

   {
      CORE_OPTION_NAME "_internal_resolution",
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_EO,
      NULL,
      "video",
      {
         { "320x240",    OPTION_VAL_320X240_EO },
         { "640x480",    OPTION_VAL_640X480_EO },
         { "800x600",    OPTION_VAL_800X600_EO },
         { "960x720",    OPTION_VAL_960X720_EO },
         { "1024x768",   OPTION_VAL_1024X768_EO },
         { "1280x960",   OPTION_VAL_1280X960_EO },
         { "1440x1080",  OPTION_VAL_1440X1080_EO },
         { "1600x1200",  OPTION_VAL_1600X1200_EO },
         { "1920x1440",  OPTION_VAL_1920X1440_EO },
         { "2560x1920",  OPTION_VAL_2560X1920_EO },
         { "2880x2160",  OPTION_VAL_2880X2160_EO },
         { "3200x2400",  OPTION_VAL_3200X2400_EO },
         { "3840x2880",  OPTION_VAL_3840X2880_EO },
         { "4480x3360",  OPTION_VAL_4480X3360_EO },
         { "5120x3840",  OPTION_VAL_5120X3840_EO },
         { "5760x4320",  OPTION_VAL_5760X4320_EO },
         { "6400x4800",  OPTION_VAL_6400X4800_EO },
         { "7040x5280",  OPTION_VAL_7040X5280_EO },
         { "7680x5760",  OPTION_VAL_7680X5760_EO },
         { "8320x6240",  OPTION_VAL_8320X6240_EO },
         { "8960x6720",  OPTION_VAL_8960X6720_EO },
         { "9600x7200",  OPTION_VAL_9600X7200_EO },
         { "10240x7680", OPTION_VAL_10240X7680_EO },
         { "10880x8160", OPTION_VAL_10880X8160_EO },
         { "11520x8640", OPTION_VAL_11520X8640_EO },
         { "12160x9120", OPTION_VAL_12160X9120_EO },
         { "12800x9600", OPTION_VAL_12800X9600_EO },
         { NULL, NULL },
      },
#ifdef LOW_RES
      "320x240",
#else
      "640x480",
#endif
   },
   {
      CORE_OPTION_NAME "_cable_type",
      CORE_OPTION_NAME_CABLE_TYPE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_CABLE_TYPE_INFO_0_EO,
      NULL,
      "video",
      {
         { "VGA",	    	 OPTION_VAL_VGA_EO },
         { "TV (RGB)",       OPTION_VAL_TV_RGB_EO },
         { "TV (Composite)", OPTION_VAL_TV_COMPOSITE_EO },
         { NULL, NULL },
      },
      "TV (Composite)",
   },
   {
      CORE_OPTION_NAME "_broadcast",
      CORE_OPTION_NAME_BROADCAST_LABEL_EO,
      NULL,
      "",
      NULL,
      "video",
      {
         { "NTSC",    OPTION_VAL_NTSC_EO },
         { "PAL",     OPTION_VAL_PAL_EO },
         { "PAL_N",   OPTION_VAL_PAL_N_EO },
         { "PAL_M",   OPTION_VAL_PAL_M_EO },
         { "Default", OPTION_VAL_DEFAULT_EO },
         { NULL, NULL },
      },
      "NTSC",
   },
   {
      CORE_OPTION_NAME "_screen_rotation",
      CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_EO,
      NULL,
      "",
      NULL,
      "video",
      {
         { "horizontal", OPTION_VAL_HORIZONTAL_EO },
         { "vertical",   OPTION_VAL_VERTICAL_EO },
         { NULL, NULL },
      },
      "horizontal",
   },
   {/* TODO: needs better explanation? */
      CORE_OPTION_NAME "_alpha_sorting",
      CORE_OPTION_NAME_ALPHA_SORTING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_EO,
      NULL,
      "video",
      {
         { "per-strip (fast, least accurate)", OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_EO },
         { "per-triangle (normal)",            OPTION_VAL_PER_TRIANGLE_NORMAL_EO },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
         { "per-pixel (accurate)",             OPTION_VAL_PER_PIXEL_ACCURATE_EO },
#endif
         { NULL, NULL },
      },
#if defined(LOW_END)
      "per-strip (fast, least accurate)",
#else
      "per-triangle (normal)",
#endif
   },
#if defined(HAVE_OIT) || defined(HAVE_VULKAN) || defined(HAVE_D3D11)
   {
      CORE_OPTION_NAME "_oit_abuffer_size",
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_EO,
      NULL,
      "video",
      {
         { "512MB", OPTION_VAL_512MB_EO },
         { "1GB",   OPTION_VAL_1GB_EO },
         { "2GB",   OPTION_VAL_2GB_EO },
         { "4GB",   OPTION_VAL_4GB_EO },
         { NULL, NULL },
      },
      "512MB",
   },
   {
      CORE_OPTION_NAME "_oit_layers",
      CORE_OPTION_NAME_OIT_LAYERS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_OIT_LAYERS_INFO_0_EO,
      NULL,
      "video",
      {
         { "8", NULL },
         { "16",   NULL },
         { "32",   NULL },
         { "64",   NULL },
         { "96",   NULL },
         { "128",   NULL },
         { NULL, NULL },
      },
      "32",
   },
#endif
   {
      CORE_OPTION_NAME "_emulate_framebuffer",
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {/* TODO: needs explanation */
      CORE_OPTION_NAME "_enable_rttb",
      CORE_OPTION_NAME_ENABLE_RTTB_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_mipmapping",
      CORE_OPTION_NAME_MIPMAPPING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_MIPMAPPING_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_fog",
      CORE_OPTION_NAME_FOG_LABEL_EO,
      NULL,
      "",
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_volume_modifier_enable",
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_anisotropic_filtering",
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_EO,
      NULL,
      "video",
      {
         { "off", "disabled" },
         { "2",  NULL },
         { "4",  NULL },
         { "8",  NULL },
         { "16",  NULL },
         { NULL, NULL },
      },
      "4",
   },
   {
      CORE_OPTION_NAME "_texture_filtering",
      CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_EO,
      NULL,
      "video",
      {
         { "0", OPTION_VAL_DEFAULT_EO },
         { "1",  OPTION_VAL_1_EO },
         { "2",  OPTION_VAL_2_EO },
         { NULL, NULL },
      },
      "0",
   },
   {
      CORE_OPTION_NAME "_delay_frame_swapping",
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_detect_vsync_swap_interval",
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_pvr2_filtering",
      CORE_OPTION_NAME_PVR2_FILTERING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_EO,
      NULL,
      "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
#ifdef _OPENMP
   {
      CORE_OPTION_NAME "_texupscale",
      CORE_OPTION_NAME_TEXUPSCALE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_INFO_0_EO,
      NULL,
      "video",
      {
         { "1", "disabled" },
         { "2",  OPTION_VAL_2_O27_EO },
         { "4",  OPTION_VAL_4_EO },
         { "6",  OPTION_VAL_6_EO },
         { NULL, NULL },
      },
      "1",
   },
   {
      CORE_OPTION_NAME "_texupscale_max_filtered_texture_size",
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_EO,
      NULL,
      "video",
      {
         { "256",  NULL },
         { "512",  NULL },
         { "1024", NULL },
         { NULL, NULL },
      },
      "256",
   },
#endif
   {
      CORE_OPTION_NAME "_native_depth_interpolation",
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_EO,
	  NULL,
	  CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_EO,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_fix_upscale_bleeding_edge",
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_EO,
	  NULL,
	  CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_EO,
	  NULL,
	  "video",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_threaded_rendering",
      CORE_OPTION_NAME_THREADED_RENDERING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_EO,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_auto_skip_frame",
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_EO,
      NULL,
      "performance",
      {
         { "disabled", NULL },
         { "some", OPTION_VAL_SOME_EO },
         { "more", OPTION_VAL_MORE_EO },
         { NULL, NULL },
      },
#ifdef LOW_END
      "some",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_frame_skipping",
      CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_EO,
      NULL,
      "performance",
      {
         { "disabled",  NULL },
         { "1",         NULL },
         { "2",         NULL },
         { "3",         NULL },
         { "4",         NULL },
         { "5",         NULL },
         { "6",         NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_cheats",
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_widescreen_hack",
      CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_gdrom_fast_loading",
      CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "enabled",
#else
      "disabled",
#endif
   },
   {
      CORE_OPTION_NAME "_dc_32mb_mod",
      CORE_OPTION_NAME_DC_32MB_MOD_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled", NULL },
         {  NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_sh4clock",
      CORE_OPTION_NAME_SH4CLOCK_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_SH4CLOCK_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "100", OPTION_VAL_100_EO },
         { "110", OPTION_VAL_110_EO },
         { "120", OPTION_VAL_120_EO },
         { "130", OPTION_VAL_130_EO },
         { "140", OPTION_VAL_140_EO },
         { "150", OPTION_VAL_150_EO },
         { "160", OPTION_VAL_160_EO },
         { "170", OPTION_VAL_170_EO },
         { "180", OPTION_VAL_180_EO },
         { "190", OPTION_VAL_190_EO },
         { "200", OPTION_VAL_200_EO },
         { "210", OPTION_VAL_210_EO },
         { "220", OPTION_VAL_220_EO },
         { "230", OPTION_VAL_230_EO },
         { "240", OPTION_VAL_240_EO },
         { "250", OPTION_VAL_250_EO },
         { "260", OPTION_VAL_260_EO },
         { "270", OPTION_VAL_270_EO },
         { "280", OPTION_VAL_280_EO },
         { "290", OPTION_VAL_290_EO },
         { "300", OPTION_VAL_300_EO },
         { "310", OPTION_VAL_310_EO },
         { "320", OPTION_VAL_320_EO },
         { "330", OPTION_VAL_330_EO },
         { "340", OPTION_VAL_340_EO },
         { "350", OPTION_VAL_350_EO },
         { "360", OPTION_VAL_360_EO },
         { "370", OPTION_VAL_370_EO },
         { "380", OPTION_VAL_380_EO },
         { "390", OPTION_VAL_390_EO },
         { "400", OPTION_VAL_400_EO },
         { "410", OPTION_VAL_410_EO },
         { "420", OPTION_VAL_420_EO },
         { "430", OPTION_VAL_430_EO },
         { "440", OPTION_VAL_440_EO },
         { "450", OPTION_VAL_450_EO },
         { "460", OPTION_VAL_460_EO },
         { "470", OPTION_VAL_470_EO },
         { "480", OPTION_VAL_480_EO },
         { "490", OPTION_VAL_490_EO },
         { "500", OPTION_VAL_500_EO },
         { NULL, NULL },
      },
      "200",
   },
   {
      CORE_OPTION_NAME "_custom_textures",
      CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_dump_textures",
      CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_EO,
      NULL,
      "hacks",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_analog_stick_deadzone",
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_EO,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_EO },
         { "5%",  OPTION_VAL_5_EO },
         { "10%", OPTION_VAL_10_EO },
         { "15%", OPTION_VAL_15_EO },
         { "20%", OPTION_VAL_20_EO },
         { "25%", OPTION_VAL_25_EO },
         { "30%", OPTION_VAL_30_EO },
         { NULL, NULL },
      },
      "15%",
   },
   {
      CORE_OPTION_NAME "_trigger_deadzone",
      CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_EO,
      NULL,
      "input",
      {
         { "0%",  OPTION_VAL_0_EO },
         { "5%",  OPTION_VAL_5_EO },
         { "10%", OPTION_VAL_10_EO },
         { "15%", OPTION_VAL_15_EO },
         { "20%", OPTION_VAL_20_EO },
         { "25%", OPTION_VAL_25_EO },
         { "30%", OPTION_VAL_30_EO },
         { NULL, NULL },
      },
      "0%",
   },
   {
      CORE_OPTION_NAME "_digital_triggers",
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
	  CORE_OPTION_NAME "_network_output",
      CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_EO,
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_lightgun_settings",
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_EO,
      NULL,
      "input",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_lightgun_crosshair_size_scaling",
      CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_EO,
      NULL,
      "",
      NULL,
      "input",
      {
         { "50%",  OPTION_VAL_50_EO },
         { "60%",  OPTION_VAL_60_EO },
         { "70%",  OPTION_VAL_70_EO },
         { "80%",  OPTION_VAL_80_EO },
         { "90%",  OPTION_VAL_90_EO },
         { "100%", OPTION_VAL_100_O46_EO },
         { "110%", OPTION_VAL_110_O46_EO },
         { "120%", OPTION_VAL_120_O46_EO },
         { "130%", OPTION_VAL_130_O46_EO },
         { "140%", OPTION_VAL_140_O46_EO },
         { "150%", OPTION_VAL_150_O46_EO },
         { "160%", OPTION_VAL_160_O46_EO },
         { "170%", OPTION_VAL_170_O46_EO },
         { "180%", OPTION_VAL_180_O46_EO },
         { "190%", OPTION_VAL_190_O46_EO },
         { "200%", OPTION_VAL_200_O46_EO },
         { "210%", OPTION_VAL_210_O46_EO },
         { "220%", OPTION_VAL_220_O46_EO },
         { "230%", OPTION_VAL_230_O46_EO },
         { "240%", OPTION_VAL_240_O46_EO },
         { "250%", OPTION_VAL_250_O46_EO },
         { "260%", OPTION_VAL_260_O46_EO },
         { "270%", OPTION_VAL_270_O46_EO },
         { "280%", OPTION_VAL_280_O46_EO },
         { "290%", OPTION_VAL_290_O46_EO },
         { "300%", OPTION_VAL_300_O46_EO },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_lightgun1_crosshair",
      CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_EO,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EO },
         { "Red",      OPTION_VAL_RED_EO },
         { "Green",    OPTION_VAL_GREEN_EO },
         { "Blue",     OPTION_VAL_BLUE_EO },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun2_crosshair",
      CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_EO,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EO },
         { "Red",      OPTION_VAL_RED_EO },
         { "Green",    OPTION_VAL_GREEN_EO },
         { "Blue",     OPTION_VAL_BLUE_EO },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun3_crosshair",
      CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_EO,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EO },
         { "Red",      OPTION_VAL_RED_EO },
         { "Green",    OPTION_VAL_GREEN_EO },
         { "Blue",     OPTION_VAL_BLUE_EO },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_lightgun4_crosshair",
      CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_EO,
      NULL,
      "",
      NULL,
      "input",
      {
         { "disabled", NULL },
         { "White",    OPTION_VAL_WHITE_EO },
         { "Red",      OPTION_VAL_RED_EO },
         { "Green",    OPTION_VAL_GREEN_EO },
         { "Blue",     OPTION_VAL_BLUE_EO },
         { NULL,       NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot1",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port1_slot2",
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot1",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port2_slot2",
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot1",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port3_slot2",
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot1",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "VMU",
   },
   {
      CORE_OPTION_NAME "_device_port4_slot2",
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_EO,
      NULL,
      CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_EO,
      NULL,
      "expansions",
      {
         { "VMU",      OPTION_VAL_VMU_EO },
         { "Purupuru", OPTION_VAL_PURUPURU_EO },
         { "None",     OPTION_VAL_NONE_EO },
         { NULL, NULL },
      },
      "Purupuru",
   },
   {
      CORE_OPTION_NAME "_per_content_vmus",
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_EO,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_EO,
      CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_EO,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "VMU A1",   OPTION_VAL_VMU_A1_EO },
         { "All VMUs", OPTION_VAL_ALL_VMUS_EO },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu_sound",
      CORE_OPTION_NAME_VMU_SOUND_LABEL_EO,
      CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_EO,
      CORE_OPTION_NAME_VMU_SOUND_INFO_0_EO,
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",   NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_show_vmu_screen_settings",
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_EO,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_EO,
      CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_EO,
      NULL,
      "vmu",
      {
         { "enabled",  NULL },
         { "disabled", NULL },
         { NULL, NULL},
      },
      "disabled"
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_display",
      CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_position",
      CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EO },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EO },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EO },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EO },
         { NULL, NULL },
      },
      "Upper Left",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_size_mult",
      CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EO },
         { "2x", OPTION_VAL_2_O27_EO },
         { "3x", OPTION_VAL_3X_EO },
         { "4x", OPTION_VAL_4_EO },
         { "5x", OPTION_VAL_5X_EO },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_on_color",
      CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu1_pixel_off_color",
      CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu1_screen_opacity",
      CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EO },
         { "20%",  OPTION_VAL_20_EO },
         { "30%",  OPTION_VAL_30_EO },
         { "40%",  OPTION_VAL_40_EO },
         { "50%",  OPTION_VAL_50_EO },
         { "60%",  OPTION_VAL_60_EO },
         { "70%",  OPTION_VAL_70_EO },
         { "80%",  OPTION_VAL_80_EO },
         { "90%",  OPTION_VAL_90_EO },
         { "100%", OPTION_VAL_100_O46_EO },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_display",
      CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_position",
      CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EO },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EO },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EO },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EO },
         { NULL, NULL },
      },
      "Upper Right",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_size_mult",
      CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EO },
         { "2x", OPTION_VAL_2_O27_EO },
         { "3x", OPTION_VAL_3X_EO },
         { "4x", OPTION_VAL_4_EO },
         { "5x", OPTION_VAL_5X_EO },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_on_color",
      CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu2_pixel_off_color",
      CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu2_screen_opacity",
      CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EO },
         { "20%",  OPTION_VAL_20_EO },
         { "30%",  OPTION_VAL_30_EO },
         { "40%",  OPTION_VAL_40_EO },
         { "50%",  OPTION_VAL_50_EO },
         { "60%",  OPTION_VAL_60_EO },
         { "70%",  OPTION_VAL_70_EO },
         { "80%",  OPTION_VAL_80_EO },
         { "90%",  OPTION_VAL_90_EO },
         { "100%", OPTION_VAL_100_O46_EO },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_display",
      CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_position",
      CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EO },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EO },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EO },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EO },
         { NULL, NULL },
      },
      "Lower Left",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_size_mult",
      CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EO },
         { "2x", OPTION_VAL_2_O27_EO },
         { "3x", OPTION_VAL_3X_EO },
         { "4x", OPTION_VAL_4_EO },
         { "5x", OPTION_VAL_5X_EO },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_on_color",
      CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu3_pixel_off_color",
      CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu3_screen_opacity",
      CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EO },
         { "20%",  OPTION_VAL_20_EO },
         { "30%",  OPTION_VAL_30_EO },
         { "40%",  OPTION_VAL_40_EO },
         { "50%",  OPTION_VAL_50_EO },
         { "60%",  OPTION_VAL_60_EO },
         { "70%",  OPTION_VAL_70_EO },
         { "80%",  OPTION_VAL_80_EO },
         { "90%",  OPTION_VAL_90_EO },
         { "100%", OPTION_VAL_100_O46_EO },
         { NULL,   NULL },
      },
      "100%",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_display",
      CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_position",
      CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "Upper Left",  OPTION_VAL_UPPER_LEFT_EO },
         { "Upper Right", OPTION_VAL_UPPER_RIGHT_EO },
         { "Lower Left",  OPTION_VAL_LOWER_LEFT_EO },
         { "Lower Right", OPTION_VAL_LOWER_RIGHT_EO },
         { NULL, NULL },
      },
      "Lower Right",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_size_mult",
      CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "1x", OPTION_VAL_1X_EO },
         { "2x", OPTION_VAL_2_O27_EO },
         { "3x", OPTION_VAL_3X_EO },
         { "4x", OPTION_VAL_4_EO },
         { "5x", OPTION_VAL_5X_EO },
         { NULL, NULL },
      },
      "1x",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_on_color",
      CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_ON 00",
   },
   {
      CORE_OPTION_NAME "_vmu4_pixel_off_color",
      CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "DEFAULT_OFF 01", OPTION_VAL_DEFAULT_OFF_01_EO },
         { "DEFAULT_ON 00",  OPTION_VAL_DEFAULT_ON_00_EO },
         { "BLACK 02",          OPTION_VAL_BLACK_02_EO },
         { "BLUE 03",           OPTION_VAL_BLUE_EO },
         { "LIGHT_BLUE 04",     OPTION_VAL_LIGHT_BLUE_04_EO },
         { "GREEN 05",          OPTION_VAL_GREEN_EO },
         { "CYAN 06",           OPTION_VAL_CYAN_06_EO },
         { "CYAN_BLUE 07",      OPTION_VAL_CYAN_BLUE_07_EO },
         { "LIGHT_GREEN 08",    OPTION_VAL_LIGHT_GREEN_08_EO },
         { "CYAN_GREEN 09",     OPTION_VAL_CYAN_GREEN_09_EO },
         { "LIGHT_CYAN 10",     OPTION_VAL_LIGHT_CYAN_10_EO },
         { "RED 11",            OPTION_VAL_RED_EO },
         { "PURPLE 12",         OPTION_VAL_PURPLE_12_EO },
         { "LIGHT_PURPLE 13",   OPTION_VAL_LIGHT_PURPLE_13_EO },
         { "YELLOW 14",         OPTION_VAL_YELLOW_14_EO },
         { "GRAY 15",           OPTION_VAL_GRAY_15_EO },
         { "LIGHT_PURPLE_2 16", OPTION_VAL_LIGHT_PURPLE_2_16_EO },
         { "LIGHT_GREEN_2 17",  OPTION_VAL_LIGHT_GREEN_2_17_EO },
         { "LIGHT_GREEN_3 18",  OPTION_VAL_LIGHT_GREEN_3_18_EO },
         { "LIGHT_CYAN_2 19",   OPTION_VAL_LIGHT_CYAN_2_19_EO },
         { "LIGHT_RED_2 20",    OPTION_VAL_LIGHT_RED_2_20_EO },
         { "MAGENTA 21",        OPTION_VAL_MAGENTA_21_EO },
         { "LIGHT_PURPLE_3 22",   OPTION_VAL_LIGHT_PURPLE_3_22_EO },
         { "LIGHT_ORANGE 23",   OPTION_VAL_LIGHT_ORANGE_23_EO },
         { "ORANGE 24",         OPTION_VAL_ORANGE_24_EO },
         { "LIGHT_PURPLE_4 25", OPTION_VAL_LIGHT_PURPLE_4_25_EO },
         { "LIGHT_YELLOW 26",   OPTION_VAL_LIGHT_YELLOW_26_EO },
         { "LIGHT_YELLOW_2 27", OPTION_VAL_LIGHT_YELLOW_2_27_EO },
         { "WHITE 28",          OPTION_VAL_WHITE_EO },
         { NULL, NULL },
      },
      "DEFAULT_OFF 01",
   },
   {
      CORE_OPTION_NAME "_vmu4_screen_opacity",
      CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_EO,
      NULL,
      "",
      NULL,
      "vmu",
      {
         { "10%",  OPTION_VAL_10_EO },
         { "20%",  OPTION_VAL_20_EO },
         { "30%",  OPTION_VAL_30_EO },
         { "40%",  OPTION_VAL_40_EO },
         { "50%",  OPTION_VAL_50_EO },
         { "60%",  OPTION_VAL_60_EO },
         { "70%",  OPTION_VAL_70_EO },
         { "80%",  OPTION_VAL_80_EO },
         { "90%",  OPTION_VAL_90_EO },
         { "100%", OPTION_VAL_100_O46_EO },
         { NULL,   NULL },
      },
      "100%",
   },
   { NULL, NULL, NULL, NULL, NULL, NULL, {{0}}, NULL },
};
struct retro_core_options_v2 options_eo = {
   option_cats_eo,
   option_defs_eo
};

/* RETRO_LANGUAGE_ES */

#define CATEGORY_SYSTEM_LABEL_ES "Sistema"
#define CATEGORY_SYSTEM_INFO_0_ES "Cambia los ajustes de región, idioma, BIOS y del hardware base."
#define CATEGORY_VIDEO_LABEL_ES "Vídeo"
#define CATEGORY_VIDEO_INFO_0_ES "Cambia los ajustes de resolución, las transparencias independientes del orden y los efectos visuales."
#define CATEGORY_PERFORMANCE_LABEL_ES "Rendimiento"
#define CATEGORY_PERFORMANCE_INFO_0_ES "Configura los ajustes del renderizado multihilo y la omisión de fotogramas."
#define CATEGORY_HACKS_LABEL_ES "Arreglos de emulación"
#define CATEGORY_HACKS_INFO_0_ES "Cambia los ajustes de forzado de imagen panorámica, la velocidad de carga de GD-ROM y la sustitución de texturas."
#define CATEGORY_INPUT_LABEL_ES "Entrada"
#define CATEGORY_INPUT_INFO_0_ES "Cambia los ajustes de los mandos y las pistolas de luz."
#define CATEGORY_EXPANSIONS_LABEL_ES "Puertos de expansión de los mandos"
#define CATEGORY_EXPANSIONS_INFO_0_ES "Selecciona el dispositivo (Visual Memory/VMU/vibración) que irá conectado en cada puerto de expansión."
#define CATEGORY_VMU_LABEL_ES "Visual Memory"
#define CATEGORY_VMU_INFO_0_ES "Cambia los ajustes de los archivos de VMU individuales para cada juego y la visibilidad en pantalla de las mismas."
#define CORE_OPTION_NAME_REGION_LABEL_ES "Región"
#define OPTION_VAL_JAPAN_ES "Japón"
#define OPTION_VAL_USA_ES "Estados Unidos"
#define OPTION_VAL_EUROPE_ES "Europa"
#define OPTION_VAL_DEFAULT_ES "Valor predeterminado"
#define CORE_OPTION_NAME_LANGUAGE_LABEL_ES "Idioma"
#define CORE_OPTION_NAME_LANGUAGE_INFO_0_ES "Cambia el idioma que utilizará la BIOS y cualquier juego que contenga varios idiomas."
#define OPTION_VAL_JAPANESE_ES "Japonés"
#define OPTION_VAL_ENGLISH_ES "Inglés"
#define OPTION_VAL_GERMAN_ES "Alemán"
#define OPTION_VAL_FRENCH_ES "Francés"
#define OPTION_VAL_SPANISH_ES "Español"
#define OPTION_VAL_ITALIAN_ES "Italiano"
#define CORE_OPTION_NAME_HLE_BIOS_LABEL_ES "BIOS HLE (es necesario reiniciar)"
#define CORE_OPTION_NAME_HLE_BIOS_INFO_0_ES "Fuerza el uso de una BIOS creada con emulación de alto nivel."
#define CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_ES "Arrancar desde la BIOS (es necesario reiniciar)"
#define CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_ES "Arranca directamente el menú de la BIOS de Dreamcast."
#define CORE_OPTION_NAME_ENABLE_DSP_LABEL_ES "Activar DSP"
#define CORE_OPTION_NAME_ENABLE_DSP_INFO_0_ES "Habilita la emulación del DSP (procesador de señales digitales) de audio de Dreamcast. Mejora la precisión del sonido generado a costa de aumentar los requisitos."
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_ES "Activar botones de servicio de arcade"
#define CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_ES "Activa el botón SERVICE para los juegos para recreativas/arcades, con el que acceder a la configuración del mueble."
#define CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_ES "Partidas gratuitas en NAOMI"
#define CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_ES "Modifica la configuración de monedas del juego a partidas gratuitas."
#define CORE_OPTION_NAME_EMULATE_BBA_LABEL_ES "Emulación del Broadband Adapter (BBA)"
#define CORE_OPTION_NAME_EMULATE_BBA_INFO_0_ES "Emula el adaptador de banda ancha por Ethernet en lugar del módem (es necesario reiniciar)."
#define CORE_OPTION_NAME_UPNP_LABEL_ES "Activar UPnP"
#define CORE_OPTION_NAME_UPNP_INFO_0_ES "Utiliza UPnP para configurar automáticamente tu router/enrutador de Internet para poder conectarte a juegos online."
#define CORE_OPTION_NAME_DCNET_LABEL_ES "Utilizar DCNet (experimental)"
#define CORE_OPTION_NAME_DCNET_INFO_0_ES "Conectarse al servicio experimental de la nube de DCNet."
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_LABEL_ES "Resolución interna"
#define CORE_OPTION_NAME_INTERNAL_RESOLUTION_INFO_0_ES "Modifica la resolución de renderizado."
#define OPTION_VAL_320X240_ES "320 × 240 (50 %)"
#define OPTION_VAL_640X480_ES "640 × 480 (nativa)"
#define OPTION_VAL_800X600_ES "800 × 600 (125 %)"
#define OPTION_VAL_960X720_ES "960 × 720 (150 %)"
#define OPTION_VAL_1024X768_ES "1024 × 768 (160 %)"
#define OPTION_VAL_1280X960_ES "1280 × 960 (200 %)"
#define OPTION_VAL_1440X1080_ES "1440 × 1080 (225 %)"
#define OPTION_VAL_1600X1200_ES "1600 × 1200 (250 %)"
#define OPTION_VAL_1920X1440_ES "1920 × 1440 (300 %)"
#define OPTION_VAL_2560X1920_ES "2560 × 1920 (400 %)"
#define OPTION_VAL_2880X2160_ES "2880 × 2160 (450 %)"
#define OPTION_VAL_3200X2400_ES "3200 × 2400 (500 %)"
#define OPTION_VAL_3840X2880_ES "3840 × 2880 (600 %)"
#define OPTION_VAL_4480X3360_ES "4480 × 3360 (700 %)"
#define OPTION_VAL_5120X3840_ES "5120 × 3840 (800 %)"
#define OPTION_VAL_5760X4320_ES "5760 × 4320 (900 %)"
#define OPTION_VAL_6400X4800_ES "6400 × 4800 (1000 %)"
#define OPTION_VAL_7040X5280_ES "7040 × 5280 (1100 %)"
#define OPTION_VAL_7680X5760_ES "7680 × 5760 (1200 %)"
#define OPTION_VAL_8320X6240_ES "8320 × 6240 (1300 %)"
#define OPTION_VAL_8960X6720_ES "8960 × 6720 (1400 %)"
#define OPTION_VAL_9600X7200_ES "9600 × 7200 (1500 %)"
#define OPTION_VAL_10240X7680_ES "10240 × 7680 (1600 %)"
#define OPTION_VAL_10880X8160_ES "10880 × 8160 (1700 %)"
#define OPTION_VAL_11520X8640_ES "11520 × 8640 (1800 %)"
#define OPTION_VAL_12160X9120_ES "12160 × 9120 (1900 %)"
#define OPTION_VAL_12800X9600_ES "12800 × 9600 (2000 %)"
#define CORE_OPTION_NAME_CABLE_TYPE_LABEL_ES "Tipo de cable"
#define CORE_OPTION_NAME_CABLE_TYPE_INFO_0_ES "El tipo de señal de salida de la imagen. «TV (Compuesto)» es el formato más compatible de todos."
#define OPTION_VAL_VGA_ES NULL
#define OPTION_VAL_TV_RGB_ES NULL
#define OPTION_VAL_TV_COMPOSITE_ES "TV (Compuesto)"
#define CORE_OPTION_NAME_BROADCAST_LABEL_ES "Estándar de transmisión"
#define OPTION_VAL_NTSC_ES NULL
#define OPTION_VAL_PAL_ES "PAL (Resto del mundo)"
#define OPTION_VAL_PAL_N_ES NULL
#define OPTION_VAL_PAL_M_ES "PAL-M (Brasil)"
#define CORE_OPTION_NAME_SCREEN_ROTATION_LABEL_ES "Orientación de pantalla"
#define OPTION_VAL_HORIZONTAL_ES NULL
#define OPTION_VAL_VERTICAL_ES NULL
#define CORE_OPTION_NAME_ALPHA_SORTING_LABEL_ES "Ordenación de transparencias"
#define CORE_OPTION_NAME_ALPHA_SORTING_INFO_0_ES "Selecciona el orden de dibujado de los polígonos transparentes."
#define OPTION_VAL_PER_STRIP_FAST_LEAST_ACCURATE_ES "Por bandas (rápida, menos precisa)"
#define OPTION_VAL_PER_TRIANGLE_NORMAL_ES "Por triángulos (normal)"
#define OPTION_VAL_PER_PIXEL_ACCURATE_ES "Por píxeles (precisa, pero lenta)"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_LABEL_ES "Tamaño del búfer de acumulación de píxeles"
#define CORE_OPTION_NAME_OIT_ABUFFER_SIZE_INFO_0_ES "Es posible que sea necesario un valor alto para que la imagen se muestre bien a resoluciones superiores a la nativa."
#define OPTION_VAL_512MB_ES "512 MB"
#define OPTION_VAL_1GB_ES "1 GB"
#define OPTION_VAL_2GB_ES "2 GB"
#define OPTION_VAL_4GB_ES "4 GB"
#define CORE_OPTION_NAME_OIT_LAYERS_LABEL_ES "N.º máximo de capas transparentes"
#define CORE_OPTION_NAME_OIT_LAYERS_INFO_0_ES "Las escenas más complejas podrían necesitar un valor más alto."
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_LABEL_ES "Emulación completa del framebuffer"
#define CORE_OPTION_NAME_EMULATE_FRAMEBUFFER_INFO_0_ES "Activa la emulación completa del framebuffer dentro de la VRAM. Ideal para aquellos juegos que lean o escriban directamente al framebuffer en la VRAM. Al activar esta opción, se forzará una resolución interna de 640 × 480 y el rendimiento podría verse gravemente afectado."
#define CORE_OPTION_NAME_ENABLE_RTTB_LABEL_ES "Activar el búfer RTT (renderizado a texturas)"
#define CORE_OPTION_NAME_ENABLE_RTTB_INFO_0_ES "Copia las texturas renderizadas en la GPU de vuelta a la VRAM. Esta opción suele dejarse activada para aquellos juegos que la requieran. Al activar esta opción, se desactivará el escalado de texturas y el rendimiento podría verse afectado."
#define CORE_OPTION_NAME_MIPMAPPING_LABEL_ES "«Mipmapping»"
#define CORE_OPTION_NAME_MIPMAPPING_INFO_0_ES "Al activar esta opción, las texturas mostrarán una versión con un tamaño más reducido cuanto más lejos estén de la pantalla. Puede mejorar el rendimiento y reducir los efectos de distorsión."
#define CORE_OPTION_NAME_FOG_LABEL_ES "Efectos de niebla"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_LABEL_ES "Modificador de volúmenes"
#define CORE_OPTION_NAME_VOLUME_MODIFIER_ENABLE_INFO_0_ES "Una característica de la GPU de Dreamcast que suelen utilizar los juegos para dibujar las sombras de objetos. Esta opción debe activarse por norma general; apenas afecta al rendimiento."
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_LABEL_ES "Filtrado anisotrópico"
#define CORE_OPTION_NAME_ANISOTROPIC_FILTERING_INFO_0_ES "Mejora la calidad de las texturas en aquellas superficies que se encuentren en un ángulo oblicuo respecto a la cámara. Un valor muy alto necesitará de mayores recursos de la GPU. Es necesario reiniciar para aplicar los cambios en este ajuste."
#define CORE_OPTION_NAME_TEXTURE_FILTERING_LABEL_ES "Filtrado de texturas"
#define CORE_OPTION_NAME_TEXTURE_FILTERING_INFO_0_ES "Indica el modo de filtrado de texturas que se utilizará. Puede utilizarse para forzar un modo de filtrado concreto en todas las texturas con el fin de conseguir un aspecto más definido (o suavizado) que el valor predeterminado. Cualquier valor que no sea el predeterminado puede provocar problemas de renderizado. Es necesario reiniciar para aplicar los cambios en este ajuste."
#define OPTION_VAL_1_ES "Forzar vecino más cercano"
#define OPTION_VAL_2_ES "Forzar lineal"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_LABEL_ES "Retrasar cambio de fotogramas"
#define CORE_OPTION_NAME_DELAY_FRAME_SWAPPING_INFO_0_ES "Ideal para evitar parpadeos constantes o vídeos con fallos gráficos. No se recomienda su uso en plataformas lentas."
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_LABEL_ES "Detectar cambios en la frecuencia de actualización"
#define CORE_OPTION_NAME_DETECT_VSYNC_SWAP_INTERVAL_INFO_0_ES "Informa en el front-end cuando cambie la frecuencia de actualización interna (p. ej.: de 60 a 30 FPS). Mejora la cadencia de fotogramas en aquellos juegos que se ejecuten a 30 o 20 FPS fijos, pero esta opción debería desactivarse en aquellos juegos con frecuencias de fotogramas desbloqueadas (es decir, inestables, p. ej.: Ecco the Dolphin, Unreal Tournament...). NOTA: esta opción no estará disponible si se activa Omisión automática de fotogramas."
#define CORE_OPTION_NAME_PVR2_FILTERING_LABEL_ES "Filtro de posprocesamiento del PowerVR2"
#define CORE_OPTION_NAME_PVR2_FILTERING_INFO_0_ES "Posprocesa la imagen renderizada para simular los efectos dedicados de la GPU PowerVR2 y las señales de vídeo analógico."
#define CORE_OPTION_NAME_TEXUPSCALE_LABEL_ES "Reescalado de texturas (xBRZ)"
#define CORE_OPTION_NAME_TEXUPSCALE_INFO_0_ES "Mejora los gráficos 2D de corte «pixel art» dibujado a mano. Utilizar solo con juegos en 2D pixelado."
#define OPTION_VAL_2_O27_ES NULL
#define OPTION_VAL_4_ES NULL
#define OPTION_VAL_6_ES NULL
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_LABEL_ES "Tamaño máximo del escalado de texturas"
#define CORE_OPTION_NAME_TEXUPSCALE_MAX_FILTERED_TEXTURE_SIZE_INFO_0_ES "Selecciona un tamaño máximo para el escalado de texturas. Si el tamaño de una textura es superior al valor seleccionado, no se reescalará."
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_LABEL_ES "Interpolación nativa de profundidad"
#define CORE_OPTION_NAME_NATIVE_DEPTH_INTERPOLATION_INFO_0_ES "Mitiga la corrupción de texturas y los problemas de profundidad en GPU de AMD. En algunos casos podría ayudar también en GPU de Intel."
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_LABEL_ES "Corregir sangrado de bordes al escalar"
#define CORE_OPTION_NAME_FIX_UPSCALE_BLEEDING_EDGE_INFO_0_ES "Ayuda cuando las texturas muestren bordes sangrados al escalarlas. Desactivar esta opción puede ser útil si hay distorsión de píxeles al escalar juegos 2D (MVC2, CVS, KOF, etcétera)."
#define CORE_OPTION_NAME_THREADED_RENDERING_LABEL_ES "Renderizado multihilo"
#define CORE_OPTION_NAME_THREADED_RENDERING_INFO_0_ES "Ejecuta la GPU y la CPU en hilos distintos. Muy recomendado."
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_LABEL_ES "Omisión automática de fotogramas"
#define CORE_OPTION_NAME_AUTO_SKIP_FRAME_INFO_0_ES "Omite fotogramas de forma automática cuando el emulador se esté ejecutando lentamente. Nota: este ajuste solo surtirá efecto cuando la opción «Renderizado multihilo» esté activada."
#define OPTION_VAL_SOME_ES NULL
#define OPTION_VAL_MORE_ES "Valor máximo"
#define CORE_OPTION_NAME_FRAME_SKIPPING_LABEL_ES "Omisión de fotogramas"
#define CORE_OPTION_NAME_FRAME_SKIPPING_INFO_0_ES "Establece la cantidad de fotogramas que se omitirán tras cada fotograma que se muestre."
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_LABEL_ES "Trucos para pantallas panorámicas (es necesario reiniciar)"
#define CORE_OPTION_NAME_WIDESCREEN_CHEATS_INFO_0_ES "Activa los trucos que permiten a ciertos juegos mostrarse en formato panorámico."
#define CORE_OPTION_NAME_WIDESCREEN_HACK_LABEL_ES "Arreglo para pantallas panorámicas"
#define CORE_OPTION_NAME_WIDESCREEN_HACK_INFO_0_ES "Dibuja la geometría más allá de la relación de aspecto normal de 4:3. Puede producir fallos gráficos en las zonas reveladas."
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_LABEL_ES "Lectura rápida de GD-ROM (inexacta)"
#define CORE_OPTION_NAME_GDROM_FAST_LOADING_INFO_0_ES "Acelera la carga de los GD-ROM."
#define CORE_OPTION_NAME_DC_32MB_MOD_LABEL_ES "Mod de 32 MB de RAM para Dreamcast"
#define CORE_OPTION_NAME_DC_32MB_MOD_INFO_0_ES "Activa el mod de 32 MB de RAM para Dreamcast. Podría afectar a la compatibilidad."
#define CORE_OPTION_NAME_SH4CLOCK_LABEL_ES "Velocidad de la CPU SH4"
#define CORE_OPTION_NAME_SH4CLOCK_INFO_0_ES "Cambia la velocidad de reloj de la CPU SH4 principal de los 200 MHz predeterminados. Una bajada de velocidad podría ayudar a plataformas lentas. Una subida podría acelerar la velocidad de fotogramas en ciertos juegos. Utilizar con precaución."
#define OPTION_VAL_100_ES "100 MHz"
#define OPTION_VAL_110_ES "110 MHz"
#define OPTION_VAL_120_ES "120 MHz"
#define OPTION_VAL_130_ES "130 MHz"
#define OPTION_VAL_140_ES "140 MHz"
#define OPTION_VAL_150_ES "150 MHz"
#define OPTION_VAL_160_ES "160 MHz"
#define OPTION_VAL_170_ES "170 MHz"
#define OPTION_VAL_180_ES "180 MHz"
#define OPTION_VAL_190_ES "190 MHz"
#define OPTION_VAL_200_ES "200 MHz"
#define OPTION_VAL_210_ES "210 MHz"
#define OPTION_VAL_220_ES "220 MHz"
#define OPTION_VAL_230_ES "230 MHz"
#define OPTION_VAL_240_ES "240 MHz"
#define OPTION_VAL_250_ES "250 MHz"
#define OPTION_VAL_260_ES "260 MHz"
#define OPTION_VAL_270_ES "270 MHz"
#define OPTION_VAL_280_ES "280 MHz"
#define OPTION_VAL_290_ES "290 MHz"
#define OPTION_VAL_300_ES "300 MHz"
#define OPTION_VAL_310_ES "310 MHz"
#define OPTION_VAL_320_ES "320 MHz"
#define OPTION_VAL_330_ES "330 MHz"
#define OPTION_VAL_340_ES "340 MHz"
#define OPTION_VAL_350_ES "350 MHz"
#define OPTION_VAL_360_ES "360 MHz"
#define OPTION_VAL_370_ES "370 MHz"
#define OPTION_VAL_380_ES "380 MHz"
#define OPTION_VAL_390_ES "390 MHz"
#define OPTION_VAL_400_ES "400 MHz"
#define OPTION_VAL_410_ES "410 MHz"
#define OPTION_VAL_420_ES "420 MHz"
#define OPTION_VAL_430_ES "430 MHz"
#define OPTION_VAL_440_ES "440 MHz"
#define OPTION_VAL_450_ES "450 MHz"
#define OPTION_VAL_460_ES "460 MHz"
#define OPTION_VAL_470_ES "470 MHz"
#define OPTION_VAL_480_ES "480 MHz"
#define OPTION_VAL_490_ES "490 MHz"
#define OPTION_VAL_500_ES "500 MHz"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_LABEL_ES "Cargar texturas personalizadas"
#define CORE_OPTION_NAME_CUSTOM_TEXTURES_INFO_0_ES "Carga las texturas personalizadas que se encuentren en la carpeta «system/dc/textures/<id-del-juego>/»."
#define CORE_OPTION_NAME_DUMP_TEXTURES_LABEL_ES "Volcar texturas"
#define CORE_OPTION_NAME_DUMP_TEXTURES_INFO_0_ES "Cada vez que aparezca una textura nueva en el juego, se guardará en formato .PNG dentro de la carpeta «system/dc/texdump/<id-del-juego>/»."
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_LABEL_ES "Zona muerta del stick analógico"
#define CORE_OPTION_NAME_ANALOG_STICK_DEADZONE_INFO_0_ES "Selecciona la distancia a partir de la cual se empezará a reconocer el movimiento del stick analógico."
#define OPTION_VAL_0_ES "0 %"
#define OPTION_VAL_5_ES "5 %"
#define OPTION_VAL_10_ES "10 %"
#define OPTION_VAL_15_ES "15 %"
#define OPTION_VAL_20_ES "20 %"
#define OPTION_VAL_25_ES "25 %"
#define OPTION_VAL_30_ES "30 %"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_LABEL_ES "Zona muerta de los gatillos"
#define CORE_OPTION_NAME_TRIGGER_DEADZONE_INFO_0_ES "Selecciona la distancia a partir de la cual se empezará a reconocer la pulsación del gatillo."
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_LABEL_ES "Gatillos digitales"
#define CORE_OPTION_NAME_DIGITAL_TRIGGERS_INFO_0_ES "Al activar esta opción, los gatillos funcionarán como botones normales, lo que significa que se procesarán como o pulsados por completo o sin pulsar, sin término medio."
#define CORE_OPTION_NAME_NETWORK_OUTPUT_LABEL_ES "Transmitir salidas digitales"
#define CORE_OPTION_NAME_NETWORK_OUTPUT_INFO_0_ES "Transmite las salidas digitales y el estado de la vibración al puerto TCP 8000. Compatible con la opción de MAME «-output network»."
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_LABEL_ES "Mostrar ajustes de las pistolas de luz"
#define CORE_OPTION_NAME_SHOW_LIGHTGUN_SETTINGS_INFO_0_ES "Permite configurar los puntos de mira de las pistolas de luz. NOTA: es necesario salir y volver a entrar del menú rápido para que el cambio surta efecto."
#define CORE_OPTION_NAME_LIGHTGUN_CROSSHAIR_SIZE_SCALING_LABEL_ES "Escala del punto de mira de la pistola"
#define OPTION_VAL_50_ES "50 %"
#define OPTION_VAL_60_ES "60 %"
#define OPTION_VAL_70_ES "70 %"
#define OPTION_VAL_80_ES "80 %"
#define OPTION_VAL_90_ES "90 %"
#define OPTION_VAL_100_O46_ES "100 %"
#define OPTION_VAL_110_O46_ES "110 %"
#define OPTION_VAL_120_O46_ES "120 %"
#define OPTION_VAL_130_O46_ES "130 %"
#define OPTION_VAL_140_O46_ES "140 %"
#define OPTION_VAL_150_O46_ES "150 %"
#define OPTION_VAL_160_O46_ES "160 %"
#define OPTION_VAL_170_O46_ES "170 %"
#define OPTION_VAL_180_O46_ES "180 %"
#define OPTION_VAL_190_O46_ES "190 %"
#define OPTION_VAL_200_O46_ES "200 %"
#define OPTION_VAL_210_O46_ES "210 %"
#define OPTION_VAL_220_O46_ES "220 %"
#define OPTION_VAL_230_O46_ES "230 %"
#define OPTION_VAL_240_O46_ES "240 %"
#define OPTION_VAL_250_O46_ES "250 %"
#define OPTION_VAL_260_O46_ES "260 %"
#define OPTION_VAL_270_O46_ES "270 %"
#define OPTION_VAL_280_O46_ES "280 %"
#define OPTION_VAL_290_O46_ES "290 %"
#define OPTION_VAL_300_O46_ES "300 %"
#define CORE_OPTION_NAME_LIGHTGUN1_CROSSHAIR_LABEL_ES "Mostrar punto de mira del arma 1"
#define OPTION_VAL_WHITE_ES "Blanco"
#define OPTION_VAL_RED_ES "Rojo"
#define OPTION_VAL_GREEN_ES "Verde"
#define OPTION_VAL_BLUE_ES "Azul"
#define CORE_OPTION_NAME_LIGHTGUN2_CROSSHAIR_LABEL_ES "Mostrar punto de mira del arma 2"
#define CORE_OPTION_NAME_LIGHTGUN3_CROSSHAIR_LABEL_ES "Mostrar punto de mira del arma 3"
#define CORE_OPTION_NAME_LIGHTGUN4_CROSSHAIR_LABEL_ES "Mostrar punto de mira del arma 4"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_LABEL_ES "Dispositivo del puerto de expansión A1"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT1_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión A1 (puerto de mando A, ranura 1)."
#define OPTION_VAL_VMU_ES "Visual Memory (VMU)"
#define OPTION_VAL_PURUPURU_ES "Vibration Pack (vibración)"
#define OPTION_VAL_NONE_ES "No compartir"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_LABEL_ES "Dispositivo del puerto de expansión A2"
#define CORE_OPTION_NAME_DEVICE_PORT1_SLOT2_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión A2 (puerto de mando A, ranura 2)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_LABEL_ES "Dispositivo del puerto de expansión B1"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT1_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión B1 (puerto de mando B, ranura 1)."
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_LABEL_ES "Dispositivo del puerto de expansión B2"
#define CORE_OPTION_NAME_DEVICE_PORT2_SLOT2_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión B2 (puerto de mando B, ranura 2)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_LABEL_ES "Dispositivo del puerto de expansión C1"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT1_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión C1 (puerto de mando C, ranura 1)."
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_LABEL_ES "Dispositivo del puerto de expansión C2"
#define CORE_OPTION_NAME_DEVICE_PORT3_SLOT2_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión C2 (puerto de mando C, ranura 2)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_LABEL_ES "Dispositivo del puerto de expansión D1"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT1_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión D1 (puerto de mando D, ranura 1)."
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_LABEL_ES "Dispositivo del puerto de expansión D2"
#define CORE_OPTION_NAME_DEVICE_PORT4_SLOT2_INFO_0_ES "Selecciona el dispositivo conectado al puerto de expansión D2 (puerto de mando D, ranura 2)."
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_ES "Separar Visual Memory (VMU) por juego"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_LABEL_CAT_ES "VMUs individuales para cada juego"
#define CORE_OPTION_NAME_PER_CONTENT_VMUS_INFO_0_ES "Al desactivar esta opción, todos los juegos compartirán ocho archivos de guardado de VMU (A1/A2/B1/B2/C1/C2/D1/D2) que se encontrarán en la carpeta del sistema de RetroArch.\nEl ajuste «VMU A1» creará un archivo único de la VMU A1 en la carpeta de guardados de RetroArch para cada juego que se ejecute.\n«Todas las VMU» creará ocho archivos VMU únicos (A1/A2/B1/B2/C1/C2/D1/D2) para cada juego que se ejecute."
#define OPTION_VAL_VMU_A1_ES NULL
#define OPTION_VAL_ALL_VMUS_ES "Todas las VMUs"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_ES "Sonidos de las Visual Memory (VMU)"
#define CORE_OPTION_NAME_VMU_SOUND_LABEL_CAT_ES "Sonidos de Visual Memory/VMU"
#define CORE_OPTION_NAME_VMU_SOUND_INFO_0_ES "Al activar esta opción, se reproducirán los pitidos de las Visual Memory/VMU."
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_ES "Mostrar ajustes de visualización de las Visual Memory (VMU)"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_LABEL_CAT_ES "Mostrar ajustes de visualización de las VMU"
#define CORE_OPTION_NAME_SHOW_VMU_SCREEN_SETTINGS_INFO_0_ES "Permite configurar la visibilidad, tamaño, posición y color de las pantallas LCD emuladas de las VMU. NOTA: es necesario salir y volver a entrar del menú rápido para que el cambio surta efecto."
#define CORE_OPTION_NAME_VMU1_SCREEN_DISPLAY_LABEL_ES "Pantalla de la VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_POSITION_LABEL_ES "Posición de la pantalla de la VMU 1"
#define OPTION_VAL_UPPER_LEFT_ES "Esquina superior izquierda"
#define OPTION_VAL_UPPER_RIGHT_ES "Esquina superior derecha"
#define OPTION_VAL_LOWER_LEFT_ES "Esquina inferior izquierda"
#define OPTION_VAL_LOWER_RIGHT_ES "Esquina interior derecha"
#define CORE_OPTION_NAME_VMU1_SCREEN_SIZE_MULT_LABEL_ES "Tamaño de la pantalla de la VMU 1"
#define OPTION_VAL_1X_ES NULL
#define OPTION_VAL_3X_ES NULL
#define OPTION_VAL_5X_ES NULL
#define CORE_OPTION_NAME_VMU1_PIXEL_ON_COLOR_LABEL_ES "Color de píxeles encendidos de la VMU 1"
#define OPTION_VAL_DEFAULT_ON_00_ES "Predeterminado (encendido)"
#define OPTION_VAL_DEFAULT_OFF_01_ES "Predeterminado (apagado)"
#define OPTION_VAL_BLACK_02_ES "Negro"
#define OPTION_VAL_LIGHT_BLUE_04_ES "Azul claro"
#define OPTION_VAL_CYAN_06_ES "Cian"
#define OPTION_VAL_CYAN_BLUE_07_ES "Azul celeste"
#define OPTION_VAL_LIGHT_GREEN_08_ES "Verde claro"
#define OPTION_VAL_CYAN_GREEN_09_ES "Verde cian"
#define OPTION_VAL_LIGHT_CYAN_10_ES "Cian claro"
#define OPTION_VAL_PURPLE_12_ES "Violeta"
#define OPTION_VAL_LIGHT_PURPLE_13_ES "Violeta claro"
#define OPTION_VAL_YELLOW_14_ES "Amarillo"
#define OPTION_VAL_GRAY_15_ES "Gris"
#define OPTION_VAL_LIGHT_PURPLE_2_16_ES "Violeta claro (2)"
#define OPTION_VAL_LIGHT_GREEN_2_17_ES "Verde claro (2)"
#define OPTION_VAL_LIGHT_GREEN_3_18_ES "Verde claro (3)"
#define OPTION_VAL_LIGHT_CYAN_2_19_ES "Cian claro (2)"
#define OPTION_VAL_LIGHT_RED_2_20_ES "Rojo claro (2)"
#define OPTION_VAL_MAGENTA_21_ES NULL
#define OPTION_VAL_LIGHT_PURPLE_3_22_ES "Violeta claro (3)"
#define OPTION_VAL_LIGHT_ORANGE_23_ES "Naranja claro"
#define OPTION_VAL_ORANGE_24_ES "Naranja"
#define OPTION_VAL_LIGHT_PURPLE_4_25_ES "Violeta claro (4)"
#define OPTION_VAL_LIGHT_YELLOW_26_ES "Amarillo claro"
#define OPTION_VAL_LIGHT_YELLOW_2_27_ES "Amarillo claro (2)"
#define CORE_OPTION_NAME_VMU1_PIXEL_OFF_COLOR_LABEL_ES "Color de píxeles apagados de la VMU 1"
#define CORE_OPTION_NAME_VMU1_SCREEN_OPACITY_LABEL_ES "Opacidad de la pantalla de la VMU 1"
#define OPTION_VAL_40_ES "40 %"
#define CORE_OPTION_NAME_VMU2_SCREEN_DISPLAY_LABEL_ES "Pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_POSITION_LABEL_ES "Posición de la pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_SIZE_MULT_LABEL_ES "Tamaño de la pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_ON_COLOR_LABEL_ES "Color de píxeles encendidos de la VMU 2"
#define CORE_OPTION_NAME_VMU2_PIXEL_OFF_COLOR_LABEL_ES "Color de píxeles apagados de la VMU 2"
#define CORE_OPTION_NAME_VMU2_SCREEN_OPACITY_LABEL_ES "Opacidad de la pantalla de la VMU 2"
#define CORE_OPTION_NAME_VMU3_SCREEN_DISPLAY_LABEL_ES "Pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_POSITION_LABEL_ES "Posición de la pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_SIZE_MULT_LABEL_ES "Tamaño de la pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_ON_COLOR_LABEL_ES "Color de píxeles encendidos de la VMU 3"
#define CORE_OPTION_NAME_VMU3_PIXEL_OFF_COLOR_LABEL_ES "Color de píxeles apagados de la VMU 3"
#define CORE_OPTION_NAME_VMU3_SCREEN_OPACITY_LABEL_ES "Opacidad de la pantalla de la VMU 3"
#define CORE_OPTION_NAME_VMU4_SCREEN_DISPLAY_LABEL_ES "Pantalla de la VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_POSITION_LABEL_ES "Posición de la pantalla de la VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_SIZE_MULT_LABEL_ES "Tamaño de la pantalla de la VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_ON_COLOR_LABEL_ES "Color de píxeles encendidos de la VMU 4"
#define CORE_OPTION_NAME_VMU4_PIXEL_OFF_COLOR_LABEL_ES "Color de píxeles apagados de la VMU 4"
#define CORE_OPTION_NAME_VMU4_SCREEN_OPACITY_LABEL_ES "Opacidad de la pantalla de la VMU 4"

struct retro_core_option_v2_category option_cats_es[] = {
   {
      "system",
      CATEGORY_SYSTEM_LABEL_ES,
      CATEGORY_SYSTEM_INFO_0_ES
   },
   {
      "video",
      CATEGORY_VIDEO_LABEL_ES,
      CATEGORY_VIDEO_INFO_0_ES
   },
   {
      "performance",
      CATEGORY_PERFORMANCE_LABEL_ES,
      CATEGORY_PERFORMANCE_INFO_0_ES
   },
   {
      "hacks",
      CATEGORY_HACKS_LABEL_ES,
      CATEGORY_HACKS_INFO_0_ES
   },
   {
      "input",
      CATEGORY_INPUT_LABEL_ES,
      CATEGORY_INPUT_INFO_0_ES
   },
   {
      "expansions",
      CATEGORY_EXPANSIONS_LABEL_ES,
      CATEGORY_EXPANSIONS_INFO_0_ES
   },
   {
      "vmu",
      CATEGORY_VMU_LABEL_ES,
      CATEGORY_VMU_INFO_0_ES
   },
   { NULL, NULL, NULL },
};
struct retro_core_option_v2_definition option_defs_es[] = {
   {
      CORE_OPTION_NAME "_region",
      CORE_OPTION_NAME_REGION_LABEL_ES,
      NULL,
      "",
      NULL,
      "system",
      {
         { "Japan",   OPTION_VAL_JAPAN_ES },
         { "USA",     OPTION_VAL_USA_ES },
         { "Europe",  OPTION_VAL_EUROPE_ES },
         { "Default", OPTION_VAL_DEFAULT_ES },
         { NULL, NULL },
      },
      "USA",
   },
   {
      CORE_OPTION_NAME "_language",
      CORE_OPTION_NAME_LANGUAGE_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_LANGUAGE_INFO_0_ES,
      NULL,
      "system",
      {
         { "Japanese", OPTION_VAL_JAPANESE_ES },
         { "English",  OPTION_VAL_ENGLISH_ES },
         { "German",   OPTION_VAL_GERMAN_ES },
         { "French",   OPTION_VAL_FRENCH_ES },
         { "Spanish",  OPTION_VAL_SPANISH_ES },
         { "Italian",  OPTION_VAL_ITALIAN_ES },
         { "Default",  OPTION_VAL_DEFAULT_ES },
         { NULL, NULL },
      },
      "English",
   },
   {
      CORE_OPTION_NAME "_hle_bios",
      CORE_OPTION_NAME_HLE_BIOS_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_HLE_BIOS_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled",  NULL },
         { "enabled",  NULL },
         { NULL, NULL},
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_boot_to_bios",
      CORE_OPTION_NAME_BOOT_TO_BIOS_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_BOOT_TO_BIOS_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_enable_dsp",
      CORE_OPTION_NAME_ENABLE_DSP_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_ENABLE_DSP_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
#ifdef LOW_END
      "disabled",
#else
      "enabled",
#endif
   },
   {
      CORE_OPTION_NAME "_allow_service_buttons",
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_ALLOW_SERVICE_BUTTONS_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_force_freeplay",
      CORE_OPTION_NAME_FORCE_FREEPLAY_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_FORCE_FREEPLAY_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_emulate_bba",
      CORE_OPTION_NAME_EMULATE_BBA_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_EMULATE_BBA_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "disabled",
   },
   {
      CORE_OPTION_NAME "_upnp",
      CORE_OPTION_NAME_UPNP_LABEL_ES,
      NULL,
      CORE_OPTION_NAME_UPNP_INFO_0_ES,
      NULL,
      "system",
      {
         { "disabled", NULL },
         { "enabled",  NULL },
         { NULL, NULL },
      },
      "enabled",
   },
   {
      CORE_OPTION_NAME "_dcnet",
      CORE_OPTION_NAME_DCNET_LABEL_ES,
      NULL,
      CORE_