/*
	Copyright 2021 flyinghead

	Rom information from mame (https://github.com/mamedev/mame)
	license:LGPL-2.1+
	copyright-holders: Samuele Zannoli, R. Belmont, ElSemi, David Haywood, Angelo Salese, Olivier Galibert, MetalliC

	This file is part of Flycast.

    Flycast is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 2 of the License, or
    (at your option) any later version.

    Flycast is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Flycast.  If not, see <https://www.gnu.org/licenses/>.
 */
#include "naomi_roms.h"
#include "naomi_roms_eeprom.h"
#include "naomi_roms_input.h"

const BIOS_t BIOS[] =
{
	{
		"airlbios",
		{
			// Airline Pilots Deluxe (Export)
			{ 2, "epr-21802.ic27", 0x000000, 0x200000, 0xa77c6b1c },
			// Airline Pilots Deluxe (USA)
			{ 1, "epr-21801.ic27", 0x000000, 0x200000, 0xa21bef24 },
		}
	},
	{
		"awbios",
		{
			// Sammy version
			{ 0, "bios0.ic23", 0x000000, 0x020000 },
			//or
			//{ 0, "bios1.ic23", 0x000000, 0x020000 },
			// Sega version
			//{ 0, "fpr-24363.ic48", 0x000000, 0x020000 },
		}
	},
	{
		"f355bios",
		{
			// Ferrari F355 (Export)
			{ 2, "epr-22851.ic27", 0x000000, 0x200000, 0x62483677 },
			// Ferrari F355 (USA)
			{ 1, "epr-22850.ic27", 0x000000, 0x200000, 0x28aa539d },
			// Ferrari F355 (Japan)
			{ 0, "epr-22849.ic27", 0x000000, 0x200000, 0x121e009c },
		}
	},
	{
		"f355dlx",
		{
			// Ferrari F355 Deluxe (Export)
			{ 2, "epr-21864.ic27", 0x000000, 0x200000, 0x12ed7c66 },
			// Ferrari F355 Deluxe (USA)
			{ 1, "epr-21863.ic27", 0x000000, 0x200000, 0x0615a4d1 },
			// Ferrari F355 Deluxe (Japan)
			{ 0, "epr-21862.ic27", 0x000000, 0x200000, 0x1f630716 },
			// Ferrari F355 Deluxe (Export, prototype)
			//{ 2, "epr-21864p.ic27", 0x000000, 0x200000 },
			// Ferrari F355 Deluxe (Japan, prototype)
			//{ 0, "epr-21862p.ic27", 0x000000, 0x200000 },
		}
	},
	{
		"hod2bios",
		{
            // HOTD2 (Export)
            { 2, "epr-21331.ic27", 0x000000, 0x200000, 0x065f8500 },
            // HOTD2 (USA)
            { 1, "epr-21330.ic27", 0x000000, 0x200000, 0x9e3bfa1b },
            // HOTD2 (Japan)
            { 0, "epr-21329.ic27", 0x000000, 0x200000, 0xd99e5b9b },
		}
	},
	{
		"naomi",
		{
			//ROM_SYSTEM_BIOS( 0, "bios0",   "epr-21576h (Japan)" )
			{ 0, "epr-21576h.ic27", 0x000000, 0x200000, 0xd4895685 },
			//ROM_SYSTEM_BIOS( 1, "bios1",   "epr-21576g (Japan)" )
			{ 0, "epr-21576g.ic27", 0x000000, 0x200000, 0xd2a1c6bf },
			//ROM_SYSTEM_BIOS( 2, "bios2",   "epr-21576e (Japan)" )
			//{ 0, "epr-21576e.ic27", 0x000000, 0x200000, 0x08c0add7 },
			//ROM_SYSTEM_BIOS( 3, "bios3",   "epr-21576d (Japan)" )
			//{ 0, "epr-21576d.ic27", 0x000000, 0x200000, 0x3b2afa7b },
			//ROM_SYSTEM_BIOS( 4, "bios4",   "epr-21576c (Japan)" )
			//{ 0, "epr-21576c.ic27", 0x000000, 0x200000, 0x4599ad13 }, // BAD DUMP
			//ROM_SYSTEM_BIOS( 5, "bios5",   "epr-21576b (Japan)" )
			//{ 0, "epr-21576b.ic27", 0x000000, 0x200000, 0x755a6e07 },
			//ROM_SYSTEM_BIOS( 6, "bios6",   "epr-21576a (Japan)" )
			//{ 0, "epr-21576a.ic27", 0x000000, 0x200000, 0xcedfe439 },
			//ROM_SYSTEM_BIOS( 7, "bios7",   "epr-21576 (Japan)" )
			//{ 0, "epr-21576.ic27",  0x000000, 0x200000, 0x9dad3495 },
			//ROM_SYSTEM_BIOS( 8, "bios8",   "epr-21578h (Export)" )
			{ 2, "epr-21578h.ic27", 0x000000, 0x200000, 0x7b452946 },
			//ROM_SYSTEM_BIOS( 9, "bios9",   "epr-21578g (Export)" )
			{ 2, "epr-21578g.ic27", 0x000000, 0x200000, 0x55413214 },
			//ROM_SYSTEM_BIOS( 10, "bios10", "epr-21578f (Export)" )
			//{ 2, "epr-21578f.ic27", 0x000000, 0x200000, 0x628a27fd },
			//ROM_SYSTEM_BIOS( 11, "bios11", "epr-21578e (Export)" )
			//{ 2, "epr-21578e.ic27", 0x000000, 0x200000, 0x087f09a3 },
			//ROM_SYSTEM_BIOS( 12, "bios12", "epr-21578d (Export)" )
			//{ 2, "epr-21578d.ic27", 0x000000, 0x200000, 0xdfd5f42a },
			//ROM_SYSTEM_BIOS( 13, "bios13", "epr-21578a (Export)" )
			//{ 2, "epr-21578a.ic27", 0x000000, 0x200000, 0x6c9aad83 },
			//ROM_SYSTEM_BIOS( 14, "bios14", "epr-21577h (USA)" )
			{ 1, "epr-21577h.ic27", 0x000000, 0x200000, 0xfdf17452 },
			//ROM_SYSTEM_BIOS( 15, "bios15", "epr-21577g (USA)" )
			{ 1, "epr-21577g.ic27", 0x000000, 0x200000, 0x25f64af7 },
			//ROM_SYSTEM_BIOS( 16, "bios16", "epr-21577e (USA)" )
			//{ 1, "epr-21577e.ic27", 0x000000, 0x200000, 0xcf36e97b },
			//ROM_SYSTEM_BIOS( 17, "bios17", "epr-21577d (USA)" )
			//{ 1, "epr-21577d.ic27", 0x000000, 0x200000, 0x60ddcbbe },
			//ROM_SYSTEM_BIOS( 18, "bios18", "epr-21577a (USA)" )
			//{ 1, "epr-21577a.ic27", 0x000000, 0x200000, 0x969dc491 },
			//ROM_SYSTEM_BIOS( 19, "bios19", "epr-21579d (Korea)" )
			{ 3, "epr-21579d.ic27", 0x000000, 0x200000, 0x33513691 },
			//ROM_SYSTEM_BIOS( 20, "bios20", "epr-21579 (Korea)" )
			//{ 3, "epr-21579.ic27",  0x000000, 0x200000, 0x71f9c918 },
			//ROM_SYSTEM_BIOS( 21, "bios21", "Set4 Dev BIOS" )
			//{ 3, "boot_rom_64b8.ic606", 0x000000, 0x080000, 0x7a50fab9 },
			//ROM_SYSTEM_BIOS( 22, "bios22", "Dev BIOS v1.10" )
			//{ 3, "develop110.ic27", 0x000000, 0x200000, 0xde7cfdb0 },
			//ROM_SYSTEM_BIOS( 23, "bios23", "Dev BIOS (Nov 1998)" )
			//{ 3, "develop.ic27", 0x000000, 0x200000, 0x309a196a },
			//ROM_SYSTEM_BIOS( 24, "bios24", "Development ROM Board" )
			//{ 3, "zukinver0930.ic25", 0x000000, 0x200000, 0x58e17c23 },
			//ROM_SYSTEM_BIOS( 25, "bios25", "epr-21576h (multi-region hack)" )
			// The default dipswitch configuration selects Korea for the multiregion hacked BIOS
			// See hw/maple/maple_jvs.cpp
			{ 3, "epr-21576h_multi.ic27", 0x000000, 0x200000, 0xcce01f1f },
		}
	},
	{
		"naomidev",
		{
			//ROM_SYSTEM_BIOS( 21, "bios21", "Set4 Dev BIOS" )
			//{ 0, "boot_rom_64b8.ic606", 0x000000, 0x080000, 0x7a50fab9 },
			//ROM_SYSTEM_BIOS( 22, "bios22", "Dev BIOS v1.10" )
			{ 0, "develop110.ic27", 0x000000, 0x200000, 0xde7cfdb0 },
			//ROM_SYSTEM_BIOS( 23, "bios23", "Dev BIOS (Nov 1998)" )
			//{ 0, "develop.ic27", 0x000000, 0x200000, 0x309a196a },
		},
		"naomi",
	},
	{
		"naomigd",
		{
			//ROM_SYSTEM_BIOS( 2, "bios2", "epr-21576h (Japan)" )
			{ 0, "epr-21576h.ic27", 0x000000, 0x200000, 0xd4895685 },
			//ROM_SYSTEM_BIOS( 1, "bios1", "epr-21576g (Japan)" )
			{ 0, "epr-21576g.ic27", 0x000000, 0x200000, 0xd2a1c6bf },
			//ROM_SYSTEM_BIOS( 0, "bios0", "epr-21576e (Japan)" )
			{ 0, "epr-21576e.ic27", 0x000000, 0x200000, 0x08c0add7 },

			//ROM_SYSTEM_BIOS( 3, "bios3", "epr-21578h (Export)" )
			{ 2, "epr-21578h.ic27", 0x000000, 0x200000, 0x7b452946 },
			//ROM_SYSTEM_BIOS( 4, "bios4", "epr-21578g (Export)" )
			{ 2, "epr-21578g.ic27", 0x000000, 0x200000, 0x55413214 },
			//ROM_SYSTEM_BIOS( 5, "bios5", "epr-21578e (Export)" )
			{ 2, "epr-21578e.ic27", 0x000000, 0x200000, 0x087f09a3 },

			//ROM_SYSTEM_BIOS( 6, "bios6", "epr-21577h (USA)" )
			{ 1, "epr-21577h.ic27", 0x000000, 0x200000, 0xfdf17452 },
			//ROM_SYSTEM_BIOS( 7, "bios7", "epr-21577g (USA)" )
			{ 1, "epr-21577g.ic27", 0x000000, 0x200000, 0x25f64af7 },
			//ROM_SYSTEM_BIOS( 8, "bios8", "epr-21577e (USA)" )
			{ 1, "epr-21577e.ic27", 0x000000, 0x200000, 0xcf36e97b },
		},
	},
	{
		"naomi2",
		{
			// epr-23605c (Japan)
			{ 0, "epr-23605c.ic27", 0x000000, 0x200000, 0x297ea6ed },
			// epr-23605b (Japan)
			{ 0, "epr-23605b.ic27", 0x000000, 0x200000, 0x3a3242d4 },
			// epr-23607c (USA)
			{ 1, "epr-23607c.ic27", 0x000000, 0x200000, 0x750e254b },
			// epr-23607b (USA)
			{ 1, "epr-23607b.ic27", 0x000000, 0x200000, 0xf308c5e9 },
			// epr-23608c (Export)
			{ 2, "epr-23608c.ic27", 0x000000, 0x200000, 0x6ef1dd8e },
			// epr-23608b (Export)
			{ 2, "epr-23608b.ic27", 0x000000, 0x200000, 0xa554b1e3 },
			// epr-23609b (Korea)
			{ 3, "epr-23609b.ic27", 0x000000, 0x200000, 0x99e3751f },
			// epr-23605c (multi-region hack)
			{ 3, "epr-23605c_multi.ic27", 0x000000, 0x200000, 0x353fdbcd },
		}
	},
	{
		"segasp",
		{
			// BOOT VER 2.01
			{ 0, "epr-24328a.ic50", 0x000000, 0x200000, 0x03ec3805 },
			{ 1, "epr-24328a.ic50", 0x000000, 0x200000, 0x03ec3805 },
			{ 2, "epr-24328a.ic50", 0x000000, 0x200000, 0x03ec3805 },
			// BOOT VER 2.00
			//{ 0, "epr-24328.ic50", 0x000000, 0x200000, 0x25f2ef00 },
			// BOOT VER 1.01
			//{ 0, "epr-24236a.ic50", 0x000000, 0x200000, 0xca7df0de },

			{ 1, "mb_eeprom_us.ic54s", 0x000, 0x800, 0x4186d7ab, EepromBE16 },
			{ 2, "mb_eeprom_exp.ic54s", 0x000, 0x800, 0x947ddfad, EepromBE16 },
		},
	},
	{
		"naomi-jp-d",	// for marstv
		{
			//ROM_SYSTEM_BIOS( 3, "bios3",   "epr-21576d (Japan)" )
			{ 0, "epr-21576d.ic27", 0x000000, 0x200000, 0x3b2afa7b },
			{ 1, "epr-21576d.ic27", 0x000000, 0x200000, 0x3b2afa7b },
			{ 2, "epr-21576d.ic27", 0x000000, 0x200000, 0x3b2afa7b },
			{ 3, "epr-21576d.ic27", 0x000000, 0x200000, 0x3b2afa7b },
		},
		"naomi",
	},
	{
		nullptr
	}
};

const Game Games[] =
{
    // Naomi M1 Roms
    // Giant Gram 2000 (JPN, USA, EXP, KOR, AUS)
    {
        "gram2000",
        NULL,
        "Giant Gram 2000",
        0x0b000000,
        0x7f805c3f,
        "naomi",
        M1,
        ROT0,
        {
            { "epr-23377.ic11",  0x0000000, 0x0400000 },
            { "mpr-23357.ic17s", 0x1000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23358.ic18",  0x1000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23359.ic19s", 0x2000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23360.ic20",  0x2000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23361.ic21s", 0x3000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23362.ic22",  0x3000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23363.ic23s", 0x4000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23364.ic24",  0x4000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23365.ic25s", 0x5000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23366.ic26",  0x5000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23367.ic27s", 0x6000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23368.ic28",  0x6000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23369.ic29",  0x7000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23370.ic30s", 0x7000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23371.ic31",  0x8000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23372.ic32s", 0x8000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23373.ic33",  0x9000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23374.ic34s", 0x9000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23375.ic35",  0xa000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23376.ic36s", 0xa000002, 0x0800000,  0x0000000, InterleavedWord },
            { NULL, 0, 0 },
        },
		nullptr,
		&giant_gram_inputs,
    },
    // Kick '4' Cash (Export)
    {
        "kick4csh",
		nullptr,
        "Kick '4' Cash (Export)",
        0x9000000,
        0x820857c9,
        "naomi",    // Needs Export BIOS
        M1,
        ROT0,
        {
            { "epr-24212.ic11",   0x0000000, 0x400000 },
            { "opr-24213a.ic17s", 0x1000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24214a.ic18",  0x1000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24215a.ic19s", 0x2000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24216a.ic20",  0x2000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24224a.ic21s", 0x3000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24225a.ic22",  0x3000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24226a.ic23s", 0x4000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24227a.ic24",  0x4000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24228a.ic25s", 0x5000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24229a.ic26",  0x5000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24230a.ic27s", 0x6000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24231a.ic28",  0x6000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24232a.ic29",  0x7000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24233a.ic30s", 0x7000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24234a.ic31",  0x8000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24235a.ic32s", 0x8000002, 0x800000,  0x0000000, InterleavedWord },
            { "copy",             0x400000, 0xc00000,  0x0000000, Copy, 0x1000000 },

            //ROM_REGION(0x200, "some_eeprom", 0)
            //ROM_LOAD( "25lc040.ic13s", 0, 0x200, CRC(1576366a) SHA1(3e8bf3dbc8a248a6863242b78d5c6e53a869e951) )

            //ROM_REGION(0x220000, "hopper_board", 0)
            //ROM_LOAD( "fpr-24150.ic6",   0x0000000, 0x200000, CRC(3845c34c) SHA1(027b17bac64482ee152773d5fab30fcbc6e2bcb7) ) // SH4 code
            //ROM_LOAD( "6372a.ic3",       0x0200000, 0x020000, CRC(f30839ad) SHA1(ea1a32c4da1ed9745300bcdd7964a7c0964e3221) ) // FPGA config
        },
		nullptr,
		&kick4csh_inputs,
        kick4csh_eeprom_dump
    },
    // Marvel vs. Capcom 2 New Age of Heroes (Export, Korea, Rev A)
    {
        "mvsc2",
		nullptr,
        "Marvel vs. Capcom 2 New Age of Heroes (Export, Korea)",
        0x08800000,
        0xc18b6e7c,
		"naomi",
        M1,
        ROT0,
        {
            { "epr-23085a.ic11", 0x0000000, 0x0400000 },
            { "mpr-23048.ic17s", 0x0800000, 0x0800000 },
            { "mpr-23049.ic18",  0x1000000, 0x0800000 },
            { "mpr-23050.ic19s", 0x1800000, 0x0800000 },
            { "mpr-23051.ic20",  0x2000000, 0x0800000 },
            { "mpr-23052.ic21s", 0x2800000, 0x0800000 },
            { "mpr-23053.ic22",  0x3000000, 0x0800000 },
            { "mpr-23054.ic23s", 0x3800000, 0x0800000 },
            { "mpr-23055.ic24",  0x4000000, 0x0800000 },
            { "mpr-23056.ic25s", 0x4800000, 0x0800000 },
            { "mpr-23057.ic26",  0x5000000, 0x0800000 },
            { "mpr-23058.ic27s", 0x5800000, 0x0800000 },
            { "mpr-23059.ic28",  0x6000000, 0x0800000 },
            { "mpr-23060.ic29",  0x6800000, 0x0800000 },
            { "mpr-23061.ic30s", 0x7000000, 0x0800000 },
            { "mpr-23083.ic31",  0x7800000, 0x0400000 },

            // 32 bit area starts here
            { "mpr-23083.ic31",  0x8000000, 0x0400000,  0x0000000, InterleavedWord },
            { "mpr-23084.ic32s", 0x8000002, 0x0400000,  0x0000000, InterleavedWord },
            { "copy",            0x0400000, 0x0400000,  0x0000000, Copy, 0x1200000 },

            //ROM_REGION(0x200, "some_eeprom", 0)
            //ROM_LOAD( "25lc040.ic13s", 0x000000, 0x200, CRC(dc449637) SHA1(6cab09f61be1498271a36bff6a114a4eeeb00e1a) )
        },
		nullptr,
        &mvsc2_inputs,
		mvsc2_eeprom_dump,
    },
    // Mushiking The King Of Beetle (2K3 2ND, World)
    {
        "mushike",
        nullptr,
        "Mushiking The King Of Beetle (2K3 2ND Ver. 1.003-, World)",
        0x4000000,
        0x3892fb3a,
        "naomi",
        M1,
        ROT0,
        {
            { "epr-24217.ic11",  0x0000000, 0x0400000 },
            { "mpr-24218.ic17s", 0x1000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24219.ic18",  0x1000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24220.ic19s", 0x2000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24221.ic20",  0x2000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24222.ic21s", 0x3000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24223.ic22",  0x3000002, 0x0800000,  0x0000000, InterleavedWord },
            { "copy",            0x400000,  0xc00000,  0x0000000,  Copy, 0x1000000 },

            //ROM_REGION(0x200, "some_eeprom", 0)
            //{ "25lc040.ic13s", 0, 0x200, CRC(9adb86c2) SHA1(682d06b2004809c3c7ff2f4f9bc0bde0e51885c0) )

            // MUSHIKING
            // The King of Beetle
            // TYPE-1
            // 800
            // note: this dump from "empty/dead" Management Chip with no game run count left
            //ROM_REGION( 0x80, "rf_tag", 0 )
            //{ "mushi_type1.bin", 0, 0x80, CRC(8f36572b) SHA1(87e00e56d07a961e9180c7da02e35f7fd216dbae) )
        },
		nullptr,
		&mushik_inputs,
    },
    // Quiz Ah Megamisama (JPN, USA, EXP, KOR, AUS)
    {
        "qmegamis",
        NULL,
        "Quiz Ah Megamisama",
        0x9000200,
        0xcd9b4896,
        NULL,
        M1,
        ROT0,
        {
            { "epr-23227.ic11",  0x0000000, 0x0400000 },
            { "mpr-23211.ic17s", 0x1000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23212.ic18",  0x1000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23213.ic19s", 0x2000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23214.ic20",  0x2000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23215.ic21s", 0x3000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23216.ic22",  0x3000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23217.ic23s", 0x4000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23218.ic24",  0x4000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23219.ic25s", 0x5000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23220.ic26",  0x5000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23221.ic27s", 0x6000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23222.ic28",  0x6000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23223.ic29",  0x7000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23224.ic30s", 0x7000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23225.ic31",  0x8000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23226.ic32s", 0x8000002, 0x0800000,  0x0000000, InterleavedWord },
        }
    },
    // Shootout Pool
    {
        "shootopl",
        NULL,
        "Shootout Pool",
        0x3000000,
        0xa0f37ca7,
        NULL,
        M1,
        ROT0,
        {
            { "epr-23844.ic11",  0x0000000, 0x400000 },
            { "mtp-23840.ic17s", 0x1000000, 0x800000,  0x0000000, InterleavedWord },
            { "mtp-23841.ic18",  0x1000002, 0x800000,  0x0000000, InterleavedWord },
            { "mtp-23842.ic19s", 0x2000000, 0x800000,  0x0000000, InterleavedWord },
            { "mtp-23843.ic20",  0x2000002, 0x800000,  0x0000000, InterleavedWord },
            { "copy",            0x400000, 0xc00000,  0x0000000, Copy, 0x1000000 },
        },
		nullptr,
		&shootout_inputs,
    },
    // Shootout Pool The Medal / Shootout Pool Prize (Rev A)
    {
        "shootpl",
        NULL,
        "Shootout Pool Prize (Export) / Shootout Pool The Medal (Japan, Rev A)",
        0x3000000,
        0x9dbde9cd,
        NULL,
        M1,
        ROT0,
        {
            { "epr-24065a.ic11", 0x0000000, 0x0400000 },
            { "opr-24060.ic17s", 0x1000000, 0x0800000,  0x0000000, InterleavedWord },
            { "opr-24061.ic18",  0x1000002, 0x0800000,  0x0000000, InterleavedWord },
            { "opr-24062.ic19s", 0x2000000, 0x0800000,  0x0000000, InterleavedWord },
            { "opr-24063.ic20",  0x2000002, 0x0800000,  0x0000000, InterleavedWord },
            { "copy",            0x400000, 0xc00000,  0x0000000, Copy, 0x1000000 },

            //ROM_REGION(0x200, "some_eeprom", 0)
            //ROM_LOAD( "25lc040.ic13s", 0, 0x200, CRC(d11312d3) SHA1(c444012954f58a9af283ab8439f31cb89de9c14d) )
        },
		nullptr,
		&shootout_inputs,
    },
    // Shootout Pool The Medal Ver. B / Shootout Pool Prize Ver. B
    {
        "shootplm",
        NULL,
        "Shootout Pool Prize (Export) / Shootout Pool The Medal (Japan) Version B",
        0x3000000,
        0x9dbde9cd,
        NULL,
        M1,
        ROT0,
        {
            { "epr-24148.ic11",  0x0000000, 0x400000 },
            { "opr-24174.ic17s", 0x1000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24175.ic18",  0x1000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24176.ic19s", 0x2000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-24177.ic20",  0x2000002, 0x800000,  0x0000000, InterleavedWord },
            { "copy",            0x400000, 0xc00000,  0x0000000, Copy, 0x1000000 },
        },
		nullptr,
		&shootout_inputs,
    },
    // Shootout Pool Prize (Export) / Shootout Pool The Medal (Japan) Version B (prototype)
    {
        "shootplmp",
        "shootplm",
        "Shootout Pool Prize (Export) / Shootout Pool The Medal (Japan) Version B (prototype)",
        0x3000000,
        0x9dbde9cd,
        NULL,
        M1,
        ROT0,
        {
            { "rom0.ic22", 0x0000000, 0x400000 },
            { "rom1.ic1s", 0x0800000, 0x800000 },
            { "rom2.ic2s", 0x1000000, 0x800000 },
            { "rom3.ic3s", 0x1800000, 0x800000 },
            { "rom4.ic4s", 0x2000000, 0x800000 },
            // IC5 - IC21 populated, empty.
        },
		nullptr,
		&shootout_inputs,
    },

    // Touch de Uno! 2 (Japan)
    {
        "tduno2",
        NULL,
        "Touch de Uno! 2",
        0x4000000,
        0x2f6f0f8d,
        NULL,
        M1,
        ROT0,
        {
            { "epr-23071.ic11",  0x0000000, 0x0200000 },
            { "epr-23071.ic11",  0x0200000, 0x0200000 }, // reload
            { "mpr-23063.ic17s", 0x1000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23064.ic18",  0x1000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23065.ic19s", 0x2000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23066.ic20",  0x2000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23067.ic21s", 0x3000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-23068.ic22",  0x3000002, 0x0800000,  0x0000000, InterleavedWord },
            { "copy",            0x400000 , 0xc00000,  0x0000000,  Copy, 0x1000000 },

            //ROM_REGION(0x200, "some_eeprom", 0)
            //ROM_LOAD( "25lc040.ic13s", 0, 0x200, CRC(6291605c) SHA1(44f757da4814b08108d1a4f431c9a39c38acecb2) )
        },
		nullptr,
		&service_btns_inputs,
		tduno2_eeprom_dump,
    },
    // Virtua Tennis 2 / Power Smash 2 (Rev A)
    {
        "vtenis2c",
        NULL,
        "Virtua Tennis 2 / Power Smash 2",
        0x0a000000,
        0x2d2d4743,
        NULL,
        M1,
        ROT0,
        {
            { "epr-22327a.ic11", 0x0000000, 0x400000 },
            { "mpr-22307.ic17s", 0x1000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22308.ic18",  0x1000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22309.ic19s", 0x2000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22310.ic20",  0x2000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22311.ic21s", 0x3000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22312.ic22",  0x3000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22313.ic23s", 0x4000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22314.ic24",  0x4000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22315.ic25s", 0x5000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22316.ic26",  0x5000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22317.ic27s", 0x6000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22318.ic28",  0x6000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22319.ic29",  0x7000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22320.ic30s", 0x7000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22321.ic31",  0x8000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22322.ic32s", 0x8000002, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22323.ic33",  0x9000000, 0x800000,  0x0000000, InterleavedWord },
            { "mpr-22324.ic34s", 0x9000002, 0x800000,  0x0000000, InterleavedWord },
            { "copy",             0x0400000, 0xc00000,  0x0000000, Copy, 0x1000000 }, // changed
        },
        nullptr,
        &shot12_inputs
    },
    // Star Horse 2002
    {
        "shors2k2",
        NULL,
        "Star Horse 2002 (sound, Export/Taiwan)",
        0x04000000,
        0x403431d2,
        NULL,
        M1,
        ROT0,
        {
            { "epr-23964.ic11",  0x0000000, 0x400000 },
            { "opr-23965.ic17s", 0x1000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-23966.ic18",  0x1000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-23967.ic19s", 0x2000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-23968.ic20",  0x2000002, 0x800000,  0x0000000, InterleavedWord },
            { "opr-23969.ic21s", 0x3000000, 0x800000,  0x0000000, InterleavedWord },
            { "opr-23970.ic22",  0x3000002, 0x800000,  0x0000000, InterleavedWord },
        }
    },
	// Soreike! Anpanman Popcorn Koujou 2 (Rev C)
    {
        "anpanman2",
        nullptr,
        "Soreike! Anpanman Popcorn Koujou 2",
		0x03000000,
        0x2f68b225,
		nullptr,
        M1,
        ROT0,
        {
            { "epr-24049b.ic11", 0x0000000, 0x0400000, 0x7c810603 },
            { "opr-24038.ic17s", 0x1000000, 0x0800000, 0x7addc59b, InterleavedWord },
            { "opr-24039.ic18",  0x1000002, 0x0800000, 0x97e16543, InterleavedWord },
            { "opr-24040.ic19s", 0x2000000, 0x0800000, 0x59a8d850, InterleavedWord },
            { "opr-24041.ic20",  0x2000002, 0x0800000, 0xd0e6dfd0, InterleavedWord },
            { "copy",            0x0400000, 0x0c00000, 0x0000000, Copy, 0x1000000 },

			// some eeprom
			//{ "at25010.ic13s", 0, 0x84, 0xbd5d61f3, Eeprom },
        },
    },
	// Soreike! Anpanman Popcorn Koujou 2 (Rev A)
    {
        "anpanman2a",
		"anpanman2",
        "Soreike! Anpanman Popcorn Koujou 2 (Rev A)",
		0x03000000,
        0x2f68b225,
		nullptr,
        M1,
        ROT0,
        {
            { "epr-24049a.ic11", 0x0000000, 0x0400000, 0xef7fe4ba },
            { "opr-24038.ic17s", 0x1000000, 0x0800000, 0x7addc59b, InterleavedWord },
            { "opr-24039.ic18",  0x1000002, 0x0800000, 0x97e16543, InterleavedWord },
            { "opr-24040.ic19s", 0x2000000, 0x0800000, 0x59a8d850, InterleavedWord },
            { "opr-24041.ic20",  0x2000002, 0x0800000, 0xd0e6dfd0, InterleavedWord },
            { "copy",            0x0400000, 0x0c00000, 0x0000000, Copy, 0x1000000 },

			// some eeprom
			//{ "at25010.ic13s", 0, 0x84, 0xbd5d61f3, Eeprom },
        },
    },
    // Mushiking The King Of Beetle (2K3 2ND Ver. 1.002-, World)
    {
        "mushikeo",
        "mushike",
        "Mushiking The King Of Beetle (2K3 2ND Ver. 1.002-, World)",
        0x04000000,
        0x3892fb3a,
        "naomi",
        M1,
        ROT0,
        {
            { "epr-24217-1002.ic11", 0x0000000, 0x0400000 },
            { "mpr-24218.ic17s",     0x1000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24219.ic18",      0x1000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24220.ic19s",     0x2000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24221.ic20",      0x2000002, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24222.ic21s",     0x3000000, 0x0800000,  0x0000000, InterleavedWord },
            { "mpr-24223.ic22",      0x3000002, 0x0800000,  0x0000000, InterleavedWord },
            { "copy",                0x400000,  0xc00000,  0x0000000,  Copy, 0x1000000 },

            //ROM_REGION(0x200, "some_eeprom", 0)
            //{ "25lc040.ic13s", 0, 0x200, CRC(9adb86c2) SHA1(682d06b2004809c3c7ff2f4f9bc0bde0e51885c0) )

            // MUSHIKING
            // The King of Beetle
            // TYPE-1
            // 800
            // note: this dump from "empty/dead" Management Chip with no game run count left
            //ROM_REGION( 0x80, "rf_tag", 0 )
            //{ "mushi_type1.bin", 0, 0x80, CRC(8f36572b) SHA1(87e00e56d07a961e9180c7da02e35f7fd216dbae) )
        },
		nullptr,
		&mushik_inputs,
    },
	// Mushiking The King Of Beetle (2K3 2ND Ver. 1.000-, Korea)
    {
        "mushikk",
        "mushike",
        "Mushiking The King Of Beetle (2K3 2ND Ver. 1.000-, Korea)",
        0x04000000,
        0x3892fb3a,
        "naomi",
        M1,
        ROT0,
        {
            { "epr-24265.ic11",      0x0000000, 0x0400000,  0xdccb210b },
            { "opr-24266.ic17s",     0x1000000, 0x0800000,  0x293e5350, InterleavedWord },
            { "opr-24267.ic18",      0x1000002, 0x0800000,  0x80798f9a, InterleavedWord },
            { "opr-24268.ic19s",     0x2000000, 0x0800000,  0xb512c772, InterleavedWord },
            { "opr-24269.ic20",      0x2000002, 0x0800000,  0x25d4a162, InterleavedWord },
            { "opr-24270.ic21s",     0x3000000, 0x0800000,  0x02a513ad, InterleavedWord },
            { "opr-24271.ic22",      0x3000002, 0x0800000,  0x7e5c745c, InterleavedWord },
            { "copy",                0x0400000, 0x0c00000,  0, Copy, 0x1000000 },
        },
		nullptr,
		&mushik_inputs,
    },
	// Mushiking The King Of Beetle (2K3 2ND Ver. 1.000-, China)
    {
        "mushikc",
        "mushik2e",	// mame says mushike but the key pic is missing
        "Mushiking The King Of Beetle (2K3 2ND Ver. 1.000-, China)",
        0x04000000,
        0x5501,
        "naomi",
        M4,
        ROT0,
        {
        	{ "ic8.bin", 0x00000000, 0x04000000, 0x5edc61fb },
            { "317-0437-com.ic3", 0, 0x800, 0x3b6fcee8, Key },
        },
		nullptr,
		&mushik_inputs,
    },
	// Mushiking The King Of Beetles - Mushiking II / III / III+ (Ver. 1.000-) (Korea)
	// require rev.H Korea BIOS, not dumped
    {
        "mushik2k",
        "mushik2e",
        "Mushiking The King Of Beetles - Mushiking II / III / III+ (Ver. 1.000-) (Korea)",
		0x08000000,
        0x5502,
        "naomi",
        M4,
        ROT0,
        {
        	{ "fpr-24355.ic8", 0x00000000, 0x04000000, 0x8bd89229 },
        	{ "fpr-24356.ic9", 0x04000000, 0x04000000, 0xed649c81 },
            { "317-0437-com.ic3", 0, 0x800, 0x3b6fcee8, Key },
        },
		nullptr,
		&mushik_inputs,
    },
    // Naomi M2/M3 Roms
    // 18 Wheeler (deluxe) (Rev A)
    {
        "18wheelr",
        NULL,
        "18 Wheeler (deluxe, Rev A)",
        0x0a800000,
        0x2807cf54,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22185a.ic22", 0x0000000, 0x400000 },
            { "mpr-22164.ic1",   0x0800000, 0x800000 },
            { "mpr-22165.ic2",   0x1000000, 0x800000 },
            { "mpr-22166.ic3",   0x1800000, 0x800000 },
            { "mpr-22167.ic4",   0x2000000, 0x800000 },
            { "mpr-22168.ic5",   0x2800000, 0x800000 },
            { "mpr-22169.ic6",   0x3000000, 0x800000 },
            { "mpr-22170.ic7",   0x3800000, 0x800000 },
            { "mpr-22171.ic8",   0x4000000, 0x800000 },
            { "mpr-22172.ic9",   0x4800000, 0x800000 },
            { "mpr-22173.ic10",  0x5000000, 0x800000 },
            { "mpr-22174.ic11",  0x5800000, 0x800000 },
            { "mpr-22175.ic12s", 0x6000000, 0x800000 },
            { "mpr-22176.ic13s", 0x6800000, 0x800000 },
            { "mpr-22177.ic14s", 0x7000000, 0x800000 },
            { "mpr-22178.ic15s", 0x7800000, 0x800000 },
            { "mpr-22179.ic16s", 0x8000000, 0x800000 },
            { "mpr-22180.ic17s", 0x8800000, 0x800000 },
            { "mpr-22181.ic18s", 0x9000000, 0x800000 },
            { "mpr-22182.ic19s", 0x9800000, 0x800000 },
            { "mpr-22183.ic20s", 0xa000000, 0x800000 },
        },
        NULL,
        &_18wheelr_inputs,
		_18wheelr_eeprom_dump,
    },
    // 18 Wheeler (deluxe)
    {
        "18wheelro",
        "18wheelr",
        "18 Wheeler (deluxe)",
        0x0a800000,
        0x2807cf54,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22185.ic22",  0x0000000, 0x400000 },
            { "mpr-22164.ic1",   0x0800000, 0x800000 },
            { "mpr-22165.ic2",   0x1000000, 0x800000 },
            { "mpr-22166.ic3",   0x1800000, 0x800000 },
            { "mpr-22167.ic4",   0x2000000, 0x800000 },
            { "mpr-22168.ic5",   0x2800000, 0x800000 },
            { "mpr-22169.ic6",   0x3000000, 0x800000 },
            { "mpr-22170.ic7",   0x3800000, 0x800000 },
            { "mpr-22171.ic8",   0x4000000, 0x800000 },
            { "mpr-22172.ic9",   0x4800000, 0x800000 },
            { "mpr-22173.ic10",  0x5000000, 0x800000 },
            { "mpr-22174.ic11",  0x5800000, 0x800000 },
            { "mpr-22175.ic12s", 0x6000000, 0x800000 },
            { "mpr-22176.ic13s", 0x6800000, 0x800000 },
            { "mpr-22177.ic14s", 0x7000000, 0x800000 },
            { "mpr-22178.ic15s", 0x7800000, 0x800000 },
            { "mpr-22179.ic16s", 0x8000000, 0x800000 },
            { "mpr-22180.ic17s", 0x8800000, 0x800000 },
            { "mpr-22181.ic18s", 0x9000000, 0x800000 },
            { "mpr-22182.ic19s", 0x9800000, 0x800000 },
            { "mpr-22183.ic20s", 0xa000000, 0x800000 },

            // JVS I/O board 837-13844, external Z80 code for Sega 315-6146 "MIE" MCU
            //ROM_REGION( 0x20000, "jvsio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-21868.ic7", 0x000000, 0x010000, CRC(c306a51f) SHA1(7833b73dc34c4c62401a30637968f46b949ceac0) )

            // later version of the same I/O board (temporary, we'll handle this properly later)
            //ROM_LOAD( "epr-22082.ic7", 0x010000, 0x010000, CRC(de26fc6c) SHA1(cf8ef7969770fff8697299c3e3152413b898a967) )

            // 837-14645 JVS I/O, uses same PCB as 837-13844
            //ROM_LOAD( "epr-24354.ic7", 0x000000, 0x010000, CRC(0ce43505) SHA1(7700e3acfb756dfbf95f3ff14786d1bcb57e2f7d) )

            // 18 Wheeler motor controller 838-13992, code is for a TMPZ84C015 which is Z80 compatible
            //ROM_REGION( 0x10000, "motorio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-23000.ic8", 0x000000, 0x010000, CRC(e3b162f7) SHA1(52c7ad759c3c4a3148764e14d77ba5006bc8af48) )
        },
        NULL,
        &_18wheelr_inputs,
		_18wheelr_eeprom_dump,
    },
    // 18 Wheeler (deluxe) (Rev T)
    {
        "18wheelrt",
        "18wheelr",
        "18 Wheeler (deluxe, Rev T)",
        0x0a800000,
        0x2807cf54,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22185t.ic22", 0x0000000, 0x400000 },
            { "mpr-22164.ic1",   0x0800000, 0x800000 },
            { "mpr-22165.ic2",   0x1000000, 0x800000 },
            { "mpr-22166.ic3",   0x1800000, 0x800000 },
            { "mpr-22167.ic4",   0x2000000, 0x800000 },
            { "mpr-22168.ic5",   0x2800000, 0x800000 },
            { "mpr-22169.ic6",   0x3000000, 0x800000 },
            { "mpr-22170.ic7",   0x3800000, 0x800000 },
            { "mpr-22171.ic8",   0x4000000, 0x800000 },
            { "mpr-22172.ic9",   0x4800000, 0x800000 },
            { "mpr-22173.ic10",  0x5000000, 0x800000 },
            { "mpr-22174.ic11",  0x5800000, 0x800000 },
            { "mpr-22175.ic12s", 0x6000000, 0x800000 },
            { "mpr-22176.ic13s", 0x6800000, 0x800000 },
            { "mpr-22177.ic14s", 0x7000000, 0x800000 },
            { "mpr-22178.ic15s", 0x7800000, 0x800000 },
            { "mpr-22179.ic16s", 0x8000000, 0x800000 },
            { "mpr-22180.ic17s", 0x8800000, 0x800000 },
            { "mpr-22181.ic18s", 0x9000000, 0x800000 },
            { "mpr-22182.ic19s", 0x9800000, 0x800000 },
            { "mpr-22183.ic20s", 0xa000000, 0x800000 },

            // JVS I/O board 837-13844, external Z80 code for Sega 315-6146 "MIE" MCU
            //ROM_REGION( 0x20000, "jvsio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-21868.ic7", 0x000000, 0x010000, CRC(c306a51f) SHA1(7833b73dc34c4c62401a30637968f46b949ceac0) )

            // later version of the same I/O board (temporary, we'll handle this properly later)
            //ROM_LOAD( "epr-22082.ic7", 0x010000, 0x010000, CRC(de26fc6c) SHA1(cf8ef7969770fff8697299c3e3152413b898a967) )

            // 837-14645 JVS I/O, uses same PCB as 837-13844
            //ROM_LOAD( "epr-24354.ic7", 0x000000, 0x010000, CRC(0ce43505) SHA1(7700e3acfb756dfbf95f3ff14786d1bcb57e2f7d) )

            // 18 Wheeler motor controller 838-13992, code is for a TMPZ84C015 which is Z80 compatible
            //ROM_REGION( 0x10000, "motorio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-23000.ic8", 0x000000, 0x010000, CRC(e3b162f7) SHA1(52c7ad759c3c4a3148764e14d77ba5006bc8af48) )
        },
        NULL,
        &_18wheelr_inputs,
		_18wheelr_eeprom_dump,
    },
    // 18 Wheeler (standard)
    {
        "18wheels",
        "18wheelr",
        "18 Wheeler (standard)",
        0x0a800000,
        0x2807cf54,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23298.ic22",  0x0000000, 0x400000 },
            { "mpr-22164.ic1",   0x0800000, 0x800000 },
            { "mpr-22165.ic2",   0x1000000, 0x800000 },
            { "mpr-22166.ic3",   0x1800000, 0x800000 },
            { "mpr-22167.ic4",   0x2000000, 0x800000 },
            { "mpr-22168.ic5",   0x2800000, 0x800000 },
            { "mpr-22169.ic6",   0x3000000, 0x800000 },
            { "mpr-22170.ic7",   0x3800000, 0x800000 },
            { "mpr-22171.ic8",   0x4000000, 0x800000 },
            { "mpr-22172.ic9",   0x4800000, 0x800000 },
            { "mpr-22173.ic10",  0x5000000, 0x800000 },
            { "mpr-22174.ic11",  0x5800000, 0x800000 },
            { "mpr-22175.ic12s", 0x6000000, 0x800000 },
            { "mpr-22176.ic13s", 0x6800000, 0x800000 },
            { "mpr-22177.ic14s", 0x7000000, 0x800000 },
            { "mpr-22178.ic15s", 0x7800000, 0x800000 },
            { "mpr-22179.ic16s", 0x8000000, 0x800000 },
            { "mpr-22180.ic17s", 0x8800000, 0x800000 },
            { "mpr-22181.ic18s", 0x9000000, 0x800000 },
            { "mpr-22182.ic19s", 0x9800000, 0x800000 },
            { "mpr-22183.ic20s", 0xa000000, 0x800000 },

            // JVS I/O board 837-13844, code is for a Z80 of unknown type (it's inside the big Sega ASIC)
            //ROM_REGION( 0x20000, "jvsio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-21868.ic7", 0x000000, 0x010000, CRC(c306a51f) SHA1(7833b73dc34c4c62401a30637968f46b949ceac0) )

            // later version of the same I/O board (temporary, we'll handle this properly later)
            //ROM_LOAD( "epr-22082.ic7", 0x010000, 0x010000, CRC(de26fc6c) SHA1(cf8ef7969770fff8697299c3e3152413b898a967) )

            // 18 Wheeler motor controller 838-13992, code is for a TMPZ84C015 which is Z80 compatible
            //ROM_REGION( 0x10000, "motorio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-23000.ic8", 0x000000, 0x010000, CRC(e3b162f7) SHA1(52c7ad759c3c4a3148764e14d77ba5006bc8af48) )
        },
        NULL,
        &_18wheelr_inputs,
		_18wheelr_eeprom_dump,
    },
    // 18 Wheeler (upright)
    {
        "18wheelu",
        "18wheelr",
        "18 Wheeler (upright)",
        0x0a800000,
        0x2807cf54,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23299.ic22",  0x0000000, 0x400000 },
            { "mpr-22164.ic1",   0x0800000, 0x800000 },
            { "mpr-22165.ic2",   0x1000000, 0x800000 },
            { "mpr-22166.ic3",   0x1800000, 0x800000 },
            { "mpr-22167.ic4",   0x2000000, 0x800000 },
            { "mpr-22168.ic5",   0x2800000, 0x800000 },
            { "mpr-22169.ic6",   0x3000000, 0x800000 },
            { "mpr-22170.ic7",   0x3800000, 0x800000 },
            { "mpr-22171.ic8",   0x4000000, 0x800000 },
            { "mpr-22172.ic9",   0x4800000, 0x800000 },
            { "mpr-22173.ic10",  0x5000000, 0x800000 },
            { "mpr-22174.ic11",  0x5800000, 0x800000 },
            { "mpr-22175.ic12s", 0x6000000, 0x800000 },
            { "mpr-22176.ic13s", 0x6800000, 0x800000 },
            { "mpr-22177.ic14s", 0x7000000, 0x800000 },
            { "mpr-22178.ic15s", 0x7800000, 0x800000 },
            { "mpr-22179.ic16s", 0x8000000, 0x800000 },
            { "mpr-22180.ic17s", 0x8800000, 0x800000 },
            { "mpr-22181.ic18s", 0x9000000, 0x800000 },
            { "mpr-22182.ic19s", 0x9800000, 0x800000 },
            { "mpr-22183.ic20s", 0xa000000, 0x800000 },

            // JVS I/O board 837-13844, code is for a Z80 of unknown type (it's inside the big Sega ASIC)
            //ROM_REGION( 0x20000, "jvsio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-21868.ic7", 0x000000, 0x010000, CRC(c306a51f) SHA1(7833b73dc34c4c62401a30637968f46b949ceac0) )

            // later version of the same I/O board (temporary, we'll handle this properly later)
            //ROM_LOAD( "epr-22082.ic7", 0x010000, 0x010000, CRC(de26fc6c) SHA1(cf8ef7969770fff8697299c3e3152413b898a967) )

            // 840-0023    2000     317-0273-COM   Naomi
            //ROM_PARAMETER( ":rom_board:segam2crypt:key", "2807cf54" )
        },
        NULL,
        &_18wheelr_inputs, // no issue with wheel range on this version
		_18wheelr_eeprom_dump,
    },
    // Airline Pilots (Rev B)
    {
        "alpilot",
        NULL,
        "Airline Pilots (World, Rev B)",
        0x0b000000,
        0x28070e41,
        "airlbios",
        M2,
        ROT0,
        {
            { "epr-21787b.ic22", 0x0000000, 0x400000 },
            { "mpr-21728.ic1",   0x0800000, 0x800000 },
            { "mpr-21729.ic2",   0x1000000, 0x800000 },
            { "mpr-21730.ic3",   0x1800000, 0x800000 },
            { "mpr-21731.ic4",   0x2000000, 0x800000 },
            { "mpr-21732.ic5",   0x2800000, 0x800000 },
            { "mpr-21733.ic6",   0x3000000, 0x800000 },
            { "mpr-21734.ic7",   0x3800000, 0x800000 },
            { "mpr-21735.ic8",   0x4000000, 0x800000 },
            { "mpr-21736.ic9",   0x4800000, 0x800000 },
            { "mpr-21737.ic10",  0x5000000, 0x800000 },
            { "mpr-21738.ic11",  0x5800000, 0x800000 },

            // on-cart X76F100 eeprom contents
			{ "airlinepdx.sf",  0x000000, 0x000084, 0x404b2add, Eeprom },
        },
        NULL,
        &alpilot_inputs,
        alpilot_eeprom_dump,
		2,
    },
    // Airline Pilots (Japan, Rev A)
    {
        "alpilotj",
        NULL,
        "Airline Pilots (Japan, Rev A)",
        0x0b000000,
        0x28070e41,
        "airlbios",
        M2,
        ROT0,
        {
            { "epr-21739a.ic22", 0x000000,  0x400000 },
            { "mpr-21728.ic1",   0x0800000, 0x800000 },
            { "mpr-21729.ic2",   0x1000000, 0x800000 },
            { "mpr-21730.ic3",   0x1800000, 0x800000 },
            { "mpr-21731.ic4",   0x2000000, 0x800000 },
            { "mpr-21732.ic5",   0x2800000, 0x800000 },
            { "mpr-21733.ic6",   0x3000000, 0x800000 },
            { "mpr-21734.ic7",   0x3800000, 0x800000 },
            { "mpr-21735.ic8",   0x4000000, 0x800000 },
            { "mpr-21736.ic9",   0x4800000, 0x800000 },
            { "mpr-21737.ic10",  0x5000000, 0x800000 },
            { "mpr-21738.ic11",  0x5800000, 0x800000 },
        },
        NULL,
        &alpilot_inputs,
        alpilot_eeprom_dump,
		2,
    },
    // Alien Front (Rev T)
    {
        "alienfnt",
        NULL,
        "Alien Front (Rev T)",
        0x05800000,
        0x28174343,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23586t.ic22", 0x0000000, 0x0400000 },
            { "mpr-23581.ic1",   0x0800000, 0x1000000 },
            { "mpr-23582.ic2",   0x1800000, 0x1000000 },
            { "mpr-23583.ic3",   0x2800000, 0x1000000 },
            { "mpr-23584.ic4",   0x3800000, 0x1000000 },
            { "mpr-23585.ic5",   0x4800000, 0x1000000 },
        },
        NULL,
        &alienfnt_inputs,
        alienfnt_eeprom_dump
    },
    // Alien Front (Rev A)
    {
        "alienfnta",
        "alienfnt",
        "Alien Front (Rev A)",
        0x05800000,
        0x28174343,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23586a.ic22", 0x0000000, 0x0400000 },
            { "mpr-23581.ic1",   0x0800000, 0x1000000 },
            { "mpr-23582.ic2",   0x1800000, 0x1000000 },
            { "mpr-23583.ic3",   0x2800000, 0x1000000 },
            { "mpr-23584.ic4",   0x3800000, 0x1000000 },
            { "mpr-23585.ic5",   0x4800000, 0x1000000 },
        },
        NULL,
        &alienfnt_inputs,
        alienfnt_eeprom_dump
    },
    // Capcom vs. SNK Millennium Fight 2000 (JPN, USA, EXP, KOR, AUS) (Rev C)
    {
        "capsnk",
        NULL,
        "Capcom vs. SNK Millennium Fight 2000 (Rev C)",
        0x07800000,
        0x00000000,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23511c.ic22", 0x0000000, 0x0400000 },
            { "mpr-23504.ic1",   0x0800000, 0x1000000 },
            { "mpr-23505.ic2",   0x1800000, 0x1000000 },
            { "mpr-23506.ic3",   0x2800000, 0x1000000 },
            { "mpr-23507.ic4",   0x3800000, 0x1000000 },
            { "mpr-23508.ic5",   0x4800000, 0x1000000 },
            { "mpr-23509.ic6",   0x5800000, 0x1000000 },
            { "mpr-23510.ic7",   0x6800000, 0x1000000 },
            { NULL, 0, 0 },
        },
        NULL,
        &capcom_4btn_inputs,
		capsnk_eeprom_dump,
    },
    // Capcom vs. SNK Millennium Fight 2000 (Rev A)
    {
        "capsnka",
        "capsnk",
        "Capcom vs. SNK Millennium Fight 2000 (Rev A)",
        0x07800000,
        0x00000000,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23511a.ic22", 0x000000,  0x400000  },
            { "mpr-23504.ic1",   0x0800000, 0x1000000 },
            { "mpr-23505.ic2",   0x1800000, 0x1000000 },
            { "mpr-23506.ic3",   0x2800000, 0x1000000 },
            { "mpr-23507.ic4",   0x3800000, 0x1000000 },
            { "mpr-23508.ic5",   0x4800000, 0x1000000 },
            { "mpr-23509.ic6",   0x5800000, 0x1000000 },
            { "mpr-23510.ic7",   0x6800000, 0x1000000 },
            { NULL, 0, 0 },
        },
        NULL,
        &capcom_4btn_inputs,
		capsnk_eeprom_dump,
    },
    // Capcom vs. SNK Millennium Fight 2000
    {
        "capsnkb",
        "capsnk",
        "Capcom vs. SNK Millennium Fight 2000",
        0x07800000,
        0x00000000,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23511.ic22", 0x000000,  0x400000  },
            { "mpr-23504.ic1",  0x0800000, 0x1000000 },
            { "mpr-23505.ic2",  0x1800000, 0x1000000 },
            { "mpr-23506.ic3",  0x2800000, 0x1000000 },
            { "mpr-23507.ic4",  0x3800000, 0x1000000 },
            { "mpr-23508.ic5",  0x4800000, 0x1000000 },
            { "mpr-23509.ic6",  0x5800000, 0x1000000 },
            { "mpr-23510.ic7",  0x6800000, 0x1000000 },
            { NULL, 0, 0 },
        },
        NULL,
        &capcom_4btn_inputs,
		capsnk_eeprom_dump,
    },
    // Crackin' DJ
    {
        "crackndj",
		nullptr,
        "Crackin' DJ",
        0x0a800000,
        0x281c2347,
		nullptr,
        M2,
        ROT0,
        {
            { "epr-23450.ic22", 0x0000000, 0x0400000 },
            { "mpr-23525.ic1",  0x0800000, 0x1000000 },
            { "mpr-23526.ic2",  0x1800000, 0x1000000 },
            { "mpr-23527.ic3",  0x2800000, 0x1000000 },
            { "mpr-23528.ic4",  0x3800000, 0x1000000 },
            { "mpr-23529.ic5",  0x4800000, 0x1000000 },
            { "mpr-23530.ic6",  0x5800000, 0x1000000 },
            { "mpr-23531.ic7",  0x6800000, 0x1000000 },
            { "mpr-23532.ic8",  0x7800000, 0x1000000 },
            { "mpr-23533.ic9",  0x8800000, 0x1000000 },
            { "mpr-23534.ic10", 0x9800000, 0x1000000 },
        },
		nullptr,
		&crackindj_inputs,
		crackndj_eeprom_dump,
    },
    // Crackin' DJ Part 2 (Japan)
    {
        "crakndj2",
		nullptr,
        "Crackin' DJ Part 2",
        0x0a800000,
        0x28428247,
		nullptr,
        M2,
        ROT0,
        {
            { "epr-23674.ic22", 0x0000000, 0x400000 },
            { "rom1.ic1s",      0x0800000, 0x800000 },
            { "rom2.ic2s",      0x1000000, 0x800000 },
            { "rom3.ic3s",      0x1800000, 0x800000 },
            { "rom4.ic4s",      0x2000000, 0x800000 },
            { "rom5.ic5s",      0x2800000, 0x800000 },
            { "rom6.ic6s",      0x3000000, 0x800000 },
            { "rom7.ic7s",      0x3800000, 0x800000 },
            { "rom8.ic8s",      0x4000000, 0x800000 },
            { "rom9.ic9s",      0x4800000, 0x800000 },
            { "rom10.ic10s",    0x5000000, 0x800000 },
            { "rom11.ic11s",    0x5800000, 0x800000 },
            { "rom12.ic12s",    0x6000000, 0x800000 },
            { "rom13.ic13s",    0x6800000, 0x800000 },
            { "rom14.ic14s",    0x7000000, 0x800000 },
            { "rom15.ic15s",    0x7800000, 0x800000 },
            { "rom16.ic16s",    0x8000000, 0x800000 },
            { "rom17.ic17s",    0x8800000, 0x800000 },
            { "rom18.ic18s",    0x9000000, 0x800000 },
            { "rom19.ic19s",    0x9800000, 0x800000 },
            { "rom20.ic20s",    0xa000000, 0x800000 },

            //ROM_REGION(0x84, "some_eeprom", 0)
            //ROM_LOAD("sflash.ic37", 0x000000, 0x000084, CRC(08f27149) SHA1(3b8d53dcf2c09035b318022906c444cf8504d7fa) )
        },
		nullptr,
		&crackindj_inputs,
		crakndj2_eeprom_dump,
    },
    // Crazy Taxi
    {
        "crzytaxi",
        NULL,
        "Crazy Taxi",
        0x08800000,
        0x280d2f45,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21684.ic22",  0x0000000, 0x400000 },
            { "mpr-21671.ic1",   0x0800000, 0x800000 },
            { "mpr-21672.ic2",   0x1000000, 0x800000 },
            { "mpr-21673.ic3",   0x1800000, 0x800000 },
            { "mpr-21674.ic4",   0x2000000, 0x800000 },
            { "mpr-21675.ic5",   0x2800000, 0x800000 },
            { "mpr-21676.ic6",   0x3000000, 0x800000 },
            { "mpr-21677.ic7",   0x3800000, 0x800000 },
            { "mpr-21678.ic10",  0x5000000, 0x800000 },
            { "mpr-21679.ic11",  0x5800000, 0x800000 },
            { "mpr-21680.ic12s", 0x6000000, 0x800000 },
            { "mpr-21681.ic13s", 0x6800000, 0x800000 },
            { "mpr-21682.ic14s", 0x7000000, 0x800000 },
            { "mpr-21683.ic15s", 0x7800000, 0x800000 },
        },
        NULL,
        &crzytaxi_inputs,
		crzytaxi_eeprom_dump,
    },
    // Cosmic Smash (Rev A)
    {
        "csmash",
        NULL,
        "Cosmic Smash (Rev A)",
        0x04800000,
        0x28103347,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23428a.ic22", 0x0000000, 0x0400000 },
            { "mpr-23420.ic1",   0x0800000, 0x0800000 },
            { "mpr-23421.ic2",   0x1000000, 0x0800000 },
            { "mpr-23422.ic3",   0x1800000, 0x0800000 },
            { "mpr-23423.ic4",   0x2000000, 0x0800000 },
            { "mpr-23424.ic5",   0x2800000, 0x0800000 },
            { "mpr-23425.ic6",   0x3000000, 0x0800000 },
            { "mpr-23426.ic7",   0x3800000, 0x0800000 },
            { "mpr-23427.ic8",   0x4000000, 0x0800000 },
        },
		nullptr,
		&csmash_inputs,
    },
    // Cosmic Smash
    {
        "csmasho",
        "csmash",
        "Cosmic Smash",
        0x04800000,
        0x28103347,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23428.ic22", 0x0000000, 0x400000  },
            { "mpr-23420.ic1",  0x0800000, 0x0800000 },
            { "mpr-23421.ic2",  0x1000000, 0x0800000 },
            { "mpr-23422.ic3",  0x1800000, 0x0800000 },
            { "mpr-23423.ic4",  0x2000000, 0x0800000 },
            { "mpr-23424.ic5",  0x2800000, 0x0800000 },
            { "mpr-23425.ic6",  0x3000000, 0x0800000 },
            { "mpr-23426.ic7",  0x3800000, 0x0800000 },
            { "mpr-23427.ic8",  0x4000000, 0x0800000 },
        },
		nullptr,
		&csmash_inputs,
    },
    // Cannon Spike / Gun Spike
    {
        "cspike",
        NULL,
        "Cannon Spike / Gun Spike",
        0x06800000,
        0x000e2010,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23210.ic22",  0x0000000, 0x0400000 },
            { "mpr-23198.ic1",   0x0800000, 0x0800000 },
            { "mpr-23199.ic2",   0x1000000, 0x0800000 },
            { "mpr-23200.ic3",   0x1800000, 0x0800000 },
            { "mpr-23201.ic4",   0x2000000, 0x0800000 },
            { "mpr-23202.ic5",   0x2800000, 0x0800000 },
            { "mpr-23203.ic6",   0x3000000, 0x0800000 },
            { "mpr-23204.ic7",   0x3800000, 0x0800000 },
            { "mpr-23205.ic8",   0x4000000, 0x0800000 },
            { "mpr-23206.ic9",   0x4800000, 0x0800000 },
            { "mpr-23207.ic10",  0x5000000, 0x0800000 },
            { "mpr-23208.ic11",  0x5800000, 0x0800000 },
            { "mpr-23209.ic12s", 0x6000000, 0x0800000 },
        },
        NULL,
        &cspike_inputs
    },
    // Death Crimson OX (JPN, USA, EXP, KOR, AUS)
    {
        "deathcoxj",
		"deathcox",
        "Death Crimson OX (Japan, Rev A)",
        0x05800000,
        0x000b64d0,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23524a.ic22", 0x0000000, 0x0400000 },
            { "mpr-23514.ic1",   0x0800000, 0x0800000 },
            { "mpr-23515.ic2",   0x1000000, 0x0800000 },
            { "mpr-23516.ic3",   0x1800000, 0x0800000 },
            { "mpr-23517.ic4",   0x2000000, 0x0800000 },
            { "mpr-23518.ic5",   0x2800000, 0x0800000 },
            { "mpr-23519.ic6",   0x3000000, 0x0800000 },
            { "mpr-23520.ic7",   0x3800000, 0x0800000 },
            { "mpr-23521.ic8",   0x4000000, 0x0800000 },
            { "mpr-23522.ic9",   0x4800000, 0x0800000 },
            { "mpr-23523.ic10",  0x5000000, 0x0800000 },
        },
        NULL,
        &lightgun_inputs
    },
    // Death Crimson OX (USA)
    {
        "deathcox",
        NULL,
        "Death Crimson OX (USA)",
        0x05800000,
        0x000b64d0,
        NULL,
        M2,
        ROT0,
        {
            { "dcox_us.ic22",  0x0000000, 0x0400000, 0x0580a27e },
			{ "mpr-23514.ic1", 0x0800000, 0x0800000, 0x1f2b090e },
			{ "mpr-23515.ic2", 0x1000000, 0x0800000, 0xdc8557eb },
			{ "mpr-23516.ic3", 0x1800000, 0x0800000, 0x94494cbb },
			{ "mpr-23517.ic4", 0x2000000, 0x0800000, 0x69ba6a41 },
			{ "mpr-23518.ic5", 0x2800000, 0x0800000, 0x49882766 },
			{ "mpr-23519.ic6", 0x3000000, 0x0800000, 0xcdc82805 },
			{ "mpr-23520.ic7", 0x3800000, 0x0800000, 0x1a268360 },
			{ "mpr-23521.ic8", 0x4000000, 0x0800000, 0xcf8674b8 },
			{ "mpr-23522.ic9", 0x4800000, 0x0800000, 0x7ae6716e },
			{ "mpr-23523.ic10",0x5000000, 0x0800000, 0xc91efb67 },
        },
        NULL,
        &lightgun_inputs
    },
    // Death Crimson OX
    {
        "deathcoxo",
        "deathcox",
        "Death Crimson OX (Japan)",
        0x05800000,
        0x000b64d0,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23524.ic22", 0x0000000, 0x0400000 },
            { "mpr-23514.ic1",  0x0800000, 0x0800000 },
            { "mpr-23515.ic2",  0x1000000, 0x0800000 },
            { "mpr-23516.ic3",  0x1800000, 0x0800000 },
            { "mpr-23517.ic4",  0x2000000, 0x0800000 },
            { "mpr-23518.ic5",  0x2800000, 0x0800000 },
            { "mpr-23519.ic6",  0x3000000, 0x0800000 },
            { "mpr-23520.ic7",  0x3800000, 0x0800000 },
            { "mpr-23521.ic8",  0x4000000, 0x0800000 },
            { "mpr-23522.ic9",  0x4800000, 0x0800000 },
            { "mpr-23523.ic10", 0x5000000, 0x0800000 },
        },
        NULL,
        &lightgun_inputs
    },
    // Derby Owners Club 2000 (Rev A)
    {
        "derbyo2k",
        NULL,
        "Derby Owners Club 2000 Ver.2 (Japan, Rev A)",
        0x8800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22284a.ic22", 0x0000000, 0x400000 },
            { "mpr-22223.ic1",   0x0800000, 0x800000 },
            { "mpr-22224.ic2",   0x1000000, 0x800000 },
            { "mpr-22225.ic3",   0x1800000, 0x800000 },
            { "mpr-22226.ic4",   0x2000000, 0x800000 },
            { "mpr-22227.ic5",   0x2800000, 0x800000 },
            { "mpr-22228.ic6",   0x3000000, 0x800000 },
            { "mpr-22229.ic7",   0x3800000, 0x800000 },
            { "mpr-22230.ic8",   0x4000000, 0x800000 },
            { "mpr-22231.ic9",   0x4800000, 0x800000 },
            { "mpr-22232.ic10",  0x5000000, 0x800000 },
            { "mpr-22233.ic11",  0x5800000, 0x800000 },
            { "mpr-22234.ic12s", 0x6000000, 0x800000 },
            { "mpr-22235.ic13s", 0x6800000, 0x800000 },
            { "mpr-22236.ic14s", 0x7000000, 0x800000 },
            { "mpr-22237.ic15s", 0x7800000, 0x800000 },
            { "mpr-22238.ic16s", 0x8000000, 0x800000 },
            { NULL, 0, 0 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club (JPN, USA, EXP, KOR, AUS) (Rev B)
    {
        "derbyoc",
        NULL,
        "Derby Owners Club (Japan, Rev B)",
        0x07800000,
        0x280fee35,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22099b.ic22", 0x0000000, 0x0400000 },
            { "mpr-22085.ic1",   0x0800000, 0x0800000 },
            { "mpr-22086.ic2",   0x1000000, 0x0800000 },
            { "mpr-22087.ic3",   0x1800000, 0x0800000 },
            { "mpr-22088.ic4",   0x2000000, 0x0800000 },
            { "mpr-22089.ic5",   0x2800000, 0x0800000 },
            { "mpr-22090.ic6",   0x3000000, 0x0800000 },
            { "mpr-22091.ic7",   0x3800000, 0x0800000 },
            { "mpr-22092.ic8",   0x4000000, 0x0800000 },
            { "mpr-22093.ic9",   0x4800000, 0x0800000 },
            { "mpr-22094.ic10",  0x5000000, 0x0800000 },
            { "mpr-22095.ic11",  0x5800000, 0x0800000 },
            { "mpr-22096.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22097.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22098.ic14s", 0x7000000, 0x0800000 },
            { NULL, 0, 0 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club II (JPN, USA, EXP, KOR, AUS) (Rev B)
    {
        "derbyoc2",
        NULL,
        "Derby Owners Club II Ver.2.1 (Japan, Rev B)",
        0x0b800000,
        0x2a436bb7,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22306b.ic22", 0x0000000, 0x0400000 },
            { "mpr-22295.ic1",   0x0800000, 0x1000000 },
            { "mpr-22296.ic2",   0x1800000, 0x1000000 },
            { "mpr-22297.ic3",   0x2800000, 0x1000000 },
            { "mpr-22298.ic4",   0x3800000, 0x1000000 },
            { "mpr-22299.ic5",   0x4800000, 0x1000000 },
            { "mpr-22300.ic6",   0x5800000, 0x1000000 },
            { "mpr-22301.ic7",   0x6800000, 0x1000000 },
            { "mpr-22302.ic8",   0x7800000, 0x1000000 },
            { "mpr-22303.ic9",   0x8800000, 0x1000000 },
            { "mpr-22304.ic10",  0x9800000, 0x1000000 },
            { "mpr-22305.ic11",  0xa800000, 0x1000000 },
            { NULL, 0, 0 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club World Edition (JPN, USA, EXP, KOR, AUS) (Rev D)
    {
        "derbyocw",
        NULL,
        "Derby Owners Club World Edition EX (Rev D)",
        0x07800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22336d.ic22", 0x0000000, 0x0400000, 0xe6c0cb0c },
            { "mpr-22328.ic1",   0x0800000, 0x1000000, 0x179cec02 },
            { "mpr-22329.ic2",   0x1800000, 0x1000000, 0xe0d5b98c },
            { "mpr-22330.ic3",   0x2800000, 0x1000000, 0x6737cd62 },
            { "mpr-22331.ic4",   0x3800000, 0x1000000, 0x8fb5cbcf },
            { "mpr-22332.ic5",   0x4800000, 0x1000000, 0xc5e365a8 },
            { "mpr-22337.ic6",   0x5800000, 0x1000000, 0x87ca3a2f },
            { "mpr-22338.ic7",   0x6800000, 0x1000000, 0x4bda7303 },
            { NULL, 0, 0, 0x00000000 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club World Edition (Rev A)
    {
        "drbyocwa",
        "derbyocw",
        "Derby Owners Club World Edition (Rev A)",
        0x7800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22336a.ic22", 0x0000000, 0x0400000, 0x56dee69a },
            { "mpr-22328.ic1",   0x0800000, 0x1000000, 0x179cec02 },
            { "mpr-22329.ic2",   0x1800000, 0x1000000, 0xe0d5b98c },
            { "mpr-22330.ic3",   0x2800000, 0x1000000, 0x6737cd62 },
            { "mpr-22331.ic4",   0x3800000, 0x1000000, 0x8fb5cbcf },
            { "mpr-22332.ic5",   0x4800000, 0x1000000, 0xc5e365a8 },
            { "mpr-22333.ic6",   0x5800000, 0x1000000, 0x96f324aa },
            { "mpr-22334.ic7",   0x6800000, 0x1000000, 0x5389b05a },
            { NULL, 0, 0, 0x00000000 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club World Edition (Rev B)
    {
        "drbyocwb",
        "derbyocw",
        "Derby Owners Club World Edition (Rev B)",
        0x7800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22336b.ic22", 0x0000000, 0x0400000, 0x8df5434b },
            { "mpr-22328.ic1",   0x0800000, 0x1000000, 0x179cec02 },
            { "mpr-22329.ic2",   0x1800000, 0x1000000, 0xe0d5b98c },
            { "mpr-22330.ic3",   0x2800000, 0x1000000, 0x6737cd62 },
            { "mpr-22331.ic4",   0x3800000, 0x1000000, 0x8fb5cbcf },
            { "mpr-22332.ic5",   0x4800000, 0x1000000, 0xc5e365a8 },
            { "mpr-22333.ic6",   0x5800000, 0x1000000, 0x96f324aa },
            { "mpr-22334.ic7",   0x6800000, 0x1000000, 0x5389b05a },
            { NULL, 0, 0, 0x00000000 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club World Edition (Rev C)
    {
        "drbyocwc",
        "derbyocw",
        "Derby Owners Club World Edition (Rev C)",
        0x7800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22336c.ic22", 0x0000000, 0x0400000, 0x50053f82 },
            { "mpr-22328.ic1",   0x0800000, 0x1000000, 0x179cec02 },
            { "mpr-22329.ic2",   0x1800000, 0x1000000, 0xe0d5b98c },
            { "mpr-22330.ic3",   0x2800000, 0x1000000, 0x6737cd62 },
            { "mpr-22331.ic4",   0x3800000, 0x1000000, 0x8fb5cbcf },
            { "mpr-22332.ic5",   0x4800000, 0x1000000, 0xc5e365a8 },
            { "mpr-22333.ic6",   0x5800000, 0x1000000, 0x96f324aa },
            { "mpr-22334.ic7",   0x6800000, 0x1000000, 0x5389b05a },
            { NULL, 0, 0, 0x00000000 },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Derby Owners Club World Edition (Rev T)
    {
        "drbyocwt",
        "derbyocw",
        "Derby Owners Club World Edition (Rev T)",
        0x7800000,
        0xffffffff, // not populated
		nullptr,
        M2,
        ROT0,
        {
            { "epr-22336t.ic22", 0x0000000, 0x0400000, 0x18dc46b7 },
            { "mpr-22328.ic1",   0x0800000, 0x1000000, 0x179cec02 },
            { "mpr-22329.ic2",   0x1800000, 0x1000000, 0xe0d5b98c },
            { "mpr-22330.ic3",   0x2800000, 0x1000000, 0x6737cd62 },
            { "mpr-22331.ic4",   0x3800000, 0x1000000, 0x8fb5cbcf },
            { "mpr-22332.ic5",   0x4800000, 0x1000000, 0xc5e365a8 },
            { "mpr-22333.ic6",   0x5800000, 0x1000000, 0x96f324aa },
            { "mpr-22334.ic7",   0x6800000, 0x1000000, 0x5389b05a },
        },
		nullptr,
		nullptr,
		nullptr,
		1,
    },
    // Dead or Alive 2 (JPN, USA, EXP, KOR, AUS)
    {
        "doa2",
        "doa2m",
        "Dead or Alive 2",
        0xb000000,
        0x0008ad01,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22207.ic22", 0x0000000, 0x0400000 },
            { "mpr-22100.ic1",   0x0800000, 0x0800000 },
            { "mpr-22101.ic2",   0x1000000, 0x0800000 },
            { "mpr-22102.ic3",   0x1800000, 0x0800000 },
            { "mpr-22103.ic4",   0x2000000, 0x0800000 },
            { "mpr-22104.ic5",   0x2800000, 0x0800000 },
            { "mpr-22105.ic6",   0x3000000, 0x0800000 },
            { "mpr-22106.ic7",   0x3800000, 0x0800000 },
            { "mpr-22107.ic8",   0x4000000, 0x0800000 },
            { "mpr-22108.ic9",   0x4800000, 0x0800000 },
            { "mpr-22109.ic10",  0x5000000, 0x0800000 },
            { "mpr-22110.ic11",  0x5800000, 0x0800000 },
            { "mpr-22111.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22112.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22113.ic14s", 0x7000000, 0x0800000 },
            { "mpr-22114.ic15s", 0x7800000, 0x0800000 },
            { "mpr-22115.ic16s", 0x8000000, 0x0800000 },
            { "mpr-22116.ic17s", 0x8800000, 0x0800000 },
            { "mpr-22117.ic18s", 0x9000000, 0x0800000 },
            { "mpr-22118.ic19s", 0x9800000, 0x0800000 },
            { "mpr-22119.ic20s", 0xa000000, 0x0800000 },
            { "mpr-22120.ic21s", 0xa800000, 0x0800000 },

            // on-cart X76F100 eeprom contents
			{ "841-0003.sf",  0x000000, 0x000084, 0x3a119a17, Eeprom },
        },
		nullptr,
		&doa2_inputs,
		doa2_eeprom_dump,
    },
    // Dead or Alive 2 (Rev A)
    {
        "doa2a",
        "doa2m",
        "Dead or Alive 2 (Rev A)",
        0xb000000,
        0x0008ad01,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22121a.ic22", 0x0000000, 0x0400000 },
            { "mpr-22100.ic1",   0x0800000, 0x0800000 },
            { "mpr-22101.ic2",   0x1000000, 0x0800000 },
            { "mpr-22102.ic3",   0x1800000, 0x0800000 },
            { "mpr-22103.ic4",   0x2000000, 0x0800000 },
            { "mpr-22104.ic5",   0x2800000, 0x0800000 },
            { "mpr-22105.ic6",   0x3000000, 0x0800000 },
            { "mpr-22106.ic7",   0x3800000, 0x0800000 },
            { "mpr-22107.ic8",   0x4000000, 0x0800000 },
            { "mpr-22108.ic9",   0x4800000, 0x0800000 },
            { "mpr-22109.ic10",  0x5000000, 0x0800000 },
            { "mpr-22110.ic11",  0x5800000, 0x0800000 },
            { "mpr-22111.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22112.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22113.ic14s", 0x7000000, 0x0800000 },
            { "mpr-22114.ic15s", 0x7800000, 0x0800000 },
            { "mpr-22115.ic16s", 0x8000000, 0x0800000 },
            { "mpr-22116.ic17s", 0x8800000, 0x0800000 },
            { "mpr-22117.ic18s", 0x9000000, 0x0800000 },
            { "mpr-22118.ic19s", 0x9800000, 0x0800000 },
            { "mpr-22119.ic20s", 0xa000000, 0x0800000 },
            { "mpr-22120.ic21s", 0xa800000, 0x0800000 },

            // on-cart X76F100 eeprom contents
			{ "841-0003.sf",  0x000000, 0x000084, 0x3a119a17, Eeprom },
        },
		nullptr,
		&doa2_inputs,
		doa2_eeprom_dump,
    },
    // Dead or Alive 2 Millennium (JPN, USA, EXP, KOR, AUS)
    {
        "doa2m",
        NULL,
        "Dead or Alive 2 Millennium",
        0xb000000,
        0x0008ad01,
        NULL,
        M2,
        ROT0,
        {
            { "doa2verm.ic22",   0x0000000, 0x0400000 },
            { "mpr-22100.ic1",  0x0800000, 0x0800000 },
            { "mpr-22101.ic2",  0x1000000, 0x0800000 },
            { "mpr-22102.ic3",  0x1800000, 0x0800000 },
            { "mpr-22103.ic4",  0x2000000, 0x0800000 },
            { "mpr-22104.ic5",  0x2800000, 0x0800000 },
            { "mpr-22105.ic6",  0x3000000, 0x0800000 },
            { "mpr-22106.ic7",  0x3800000, 0x0800000 },
            { "mpr-22107.ic8",  0x4000000, 0x0800000 },
            { "mpr-22108.ic9",  0x4800000, 0x0800000 },
            { "mpr-22109.ic10", 0x5000000, 0x0800000 },
            { "mpr-22110.ic11", 0x5800000, 0x0800000 },
            { "mpr-22111.ic12s",0x6000000, 0x0800000 },
            { "mpr-22112.ic13s",0x6800000, 0x0800000 },
            { "mpr-22113.ic14s",0x7000000, 0x0800000 },
            { "mpr-22114.ic15s",0x7800000, 0x0800000 },
            { "mpr-22115.ic16s",0x8000000, 0x0800000 },
            { "mpr-22116.ic17s",0x8800000, 0x0800000 },
            { "mpr-22117.ic18s",0x9000000, 0x0800000 },
            { "mpr-22118.ic19s",0x9800000, 0x0800000 },
            { "mpr-22119.ic20s",0xa000000, 0x0800000 },
            { "mpr-22120.ic21s",0xa800000, 0x0800000 },

            // on-cart X76F100 eeprom contents
			{ "841-0003.sf",  0x000000, 0x000084, 0x3a119a17, Eeprom },
        },
		nullptr,
		&doa2_inputs,
		doa2_eeprom_dump,
    },
    // Dynamite Baseball '99 (JPN) / World Series '99 (USA, EXP, KOR, AUS) (Rev B) ***
    {
        "dybb99",
        NULL,
        "Dynamite Baseball '99 / World Series '99",
        0x0a000000,
        0x2804ae71,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22141b.ic22", 0x0000000, 0x0200000 },
            { "epr-22141b.ic22", 0x0200000, 0x0200000 }, // reload
            { "mpr-22122.ic1",   0x0800000, 0x0800000 },
            { "mpr-22123.ic2",   0x1000000, 0x0800000 },
            { "mpr-22124.ic3",   0x1800000, 0x0800000 },
            { "mpr-22125.ic4",   0x2000000, 0x0800000 },
            { "mpr-22126.ic5",   0x2800000, 0x0800000 },
            { "mpr-22127.ic6",   0x3000000, 0x0800000 },
            { "mpr-22128.ic7",   0x3800000, 0x0800000 },
            { "mpr-22129.ic8",   0x4000000, 0x0800000 },
            { "mpr-22130.ic9",   0x4800000, 0x0800000 },
            { "mpr-22131.ic10",  0x5000000, 0x0800000 },
            { "mpr-22132.ic11",  0x5800000, 0x0800000 },
            { "mpr-22133.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22134.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22135.ic14s", 0x7000000, 0x0800000 },
            { "mpr-22136.ic15s", 0x7800000, 0x0800000 },
            { "mpr-22137.ic16s", 0x8000000, 0x0800000 },
            { "mpr-22138.ic17s", 0x8800000, 0x0800000 },
            { "mpr-22139.ic18s", 0x9000000, 0x0800000 },
            { "mpr-22140.ic19s", 0x9800000, 0x0800000 },
        },
		nullptr,
		&wsbb_inputs,
    },
    // Dynamite Baseball NAOMI (Japan)
    {
        "dybbnao",
        NULL,
        "Dynamite Baseball NAOMI",
        0x0b000000,
        0x280e6ae1,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21575.ic22",  0x0000000, 0x0200000 },
            { "epr-21575.ic22",  0x0200000, 0x0200000 }, // reload
            { "mpr-21554.ic1",   0x0800000, 0x0800000 },
            { "mpr-21555.ic2",   0x1000000, 0x0800000 },
            { "mpr-21556.ic3",   0x1800000, 0x0800000 },
            { "mpr-21557.ic4",   0x2000000, 0x0800000 },
            { "mpr-21558.ic5",   0x2800000, 0x0800000 },
            { "mpr-21559.ic6",   0x3000000, 0x0800000 },
            { "mpr-21560.ic7",   0x3800000, 0x0800000 },
            { "mpr-21561.ic8",   0x4000000, 0x0800000 },
            { "mpr-21562.ic9",   0x4800000, 0x0800000 },
            { "mpr-21563.ic10",  0x5000000, 0x0800000 },
            { "mpr-21564.ic11",  0x5800000, 0x0800000 },
            { "mpr-21565.ic12s", 0x6000000, 0x0800000 },
            { "mpr-21566.ic13s", 0x6800000, 0x0800000 },
            { "mpr-21567.ic14s", 0x7000000, 0x0800000 },
            { "mpr-21568.ic15s", 0x7800000, 0x0800000 },
            { "mpr-21569.ic16s", 0x8000000, 0x0800000 },
            { "mpr-21570.ic17s", 0x8800000, 0x0800000 },
            { "mpr-21571.ic18s", 0x9000000, 0x0800000 },
            { "mpr-21572.ic19s", 0x9800000, 0x0800000 },
            { "mpr-21573.ic20s", 0xa000000, 0x0800000 },
            { "mpr-21574.ic21s", 0xa800000, 0x0800000 },
        },
		nullptr,
		&wsbb_inputs,
    },
#ifdef NAOMI_MULTIBOARD
    // Ferrari F355 Challenge (deluxe)
    {
        "f355",
        NULL,
        "Ferrari F355 Challenge (deluxe, no link)",
        0x0b000000,
        0x280e8f84,
        "f355dlx",
        M2,
        ROT0,
        {
            { "epr-21902.ic22",  0x0000000, 0x0400000 },

            { "mpr-21881.ic1",   0x0800000, 0x0800000 },
            { "mpr-21882.ic2",   0x1000000, 0x0800000 },
            { "mpr-21883.ic3",   0x1800000, 0x0800000 },
            { "mpr-21884.ic4",   0x2000000, 0x0800000 },
            { "mpr-21885.ic5",   0x2800000, 0x0800000 },
            { "mpr-21886.ic6",   0x3000000, 0x0800000 },
            { "mpr-21887.ic7",   0x3800000, 0x0800000 },
            { "mpr-21888.ic8",   0x4000000, 0x0800000 },
            { "mpr-21889.ic9",   0x4800000, 0x0800000 },
            { "mpr-21890.ic10",  0x5000000, 0x0800000 },
            { "mpr-21891.ic11",  0x5800000, 0x0800000 },
            { "mpr-21892.ic12s", 0x6000000, 0x0800000 },
            { "mpr-21893.ic13s", 0x6800000, 0x0800000 },
            { "mpr-21894.ic14s", 0x7000000, 0x0800000 },
            { "mpr-21895.ic15s", 0x7800000, 0x0800000 },
            { "mpr-21896.ic16s", 0x8000000, 0x0800000 },
            { "mpr-21897.ic17s", 0x8800000, 0x0800000 },
            { "mpr-21898.ic18s", 0x9000000, 0x0800000 },
            { "mpr-21899.ic19s", 0x9800000, 0x0800000 },
            { "mpr-21900.ic20s", 0xa000000, 0x0800000 },
            { "mpr-21901.ic21s", 0xa800000, 0x0800000 },

            //ROM_REGION( 0x10000, "drivebd", 0 ) // drive board ROM
            //ROM_LOAD( "epr-21867p.bin", 0x000000, 0x010000, CRC(6143b911) SHA1(360ebc53696da7a29e6404376c82947563274835) ) // prototype preview
            //ROM_LOAD( "epr-21867.bin", 0x000000, 0x010000, CRC(4f93a2a0) SHA1(875907e7fcfc44850e2c60c12268ac61c742f217) )
        },
		nullptr,
		&f355_inputs,
		nullptr,
		3,
    },
    // Ferrari F355 Challenge (twin)
    {
        "f355twin",
        NULL,
        "Ferrari F355 Challenge (twin/deluxe)",
        0x0b000000,
        0x2806efd4,
        "f355bios",
        M2,
        ROT0,
        {
            { "epr-22848.ic22",  0x0000000, 0x400000, 0xa29edec2 },
            { "mpr-22827.ic1",   0x0800000, 0x800000, 0xeeb1b975 },
            { "mpr-22828.ic2",   0x1000000, 0x800000, 0x691d246a },
            { "mpr-22829.ic3",   0x1800000, 0x800000, 0x00719c9c },
            { "mpr-22830.ic4",   0x2000000, 0x800000, 0xbfeb0e95 },
            { "mpr-22831.ic5",   0x2800000, 0x800000, 0x697e60a8 },
            { "mpr-22832.ic6",   0x3000000, 0x800000, 0x78e146a0 },
            { "mpr-22833.ic7",   0x3800000, 0x800000, 0xcbd847ea },
            { "mpr-22834.ic8",   0x4000000, 0x800000, 0x3bfc6571 },
            { "mpr-22835.ic9",   0x4800000, 0x800000, 0xc0a14f8e },
            { "mpr-22836.ic10",  0x5000000, 0x800000, 0xee68d756 },
            { "mpr-22837.ic11",  0x5800000, 0x800000, 0x3b53f0c9 },
            { "mpr-22838.ic12s", 0x6000000, 0x800000, 0xc17a2228 },
            { "mpr-22839.ic13s", 0x6800000, 0x800000, 0x31ab7352 },
            { "mpr-22840.ic14s", 0x7000000, 0x800000, 0xaf4c757b },
            { "mpr-22841.ic15s", 0x7800000, 0x800000, 0x7adceb6b },
            { "mpr-22842.ic16s", 0x8000000, 0x800000, 0x1ce2ec11 },
            { "mpr-22843.ic17s", 0x8800000, 0x800000, 0x1c659384 },
            { "mpr-22844.ic18s", 0x9000000, 0x800000, 0x361ea725 },
            { "mpr-22845.ic19s", 0x9800000, 0x800000, 0x3327aed1 },
            { "mpr-22846.ic20s", 0xa000000, 0x800000, 0xd4148f39 },
            { "mpr-22847.ic21s", 0xa800000, 0x800000, 0x955ad42e },
        },
		nullptr,
		&f355_inputs,
		nullptr,
		3,
    },
    // Ferrari F355 Challenge (twin/deluxe, preview)
    {
        "f355twinp",
        "f355twin",
        "Ferrari F355 Challenge (twin/deluxe, preview)",
        0x0b000000,
        0x2806efd4,
        "f355bios",
        M2,
        ROT0,
        {
            { "epr-22848p.ic22", 0x0000000, 0x400000, 0x2c43b053 },
            { "rom1.ic1s",       0x0800000, 0x800000, 0xeeb1b975 },
            { "rom2.ic2s",       0x1000000, 0x800000, 0x691d246a },
            { "rom3.ic3s",       0x1800000, 0x800000, 0x00719c9c },
            { "rom4.ic4s",       0x2000000, 0x800000, 0xbfeb0e95 },
            { "rom5.ic5s",       0x2800000, 0x800000, 0x697e60a8 },
            { "rom6.ic6s",       0x3000000, 0x800000, 0x78e146a0 },
            { "rom7.ic7s",       0x3800000, 0x800000, 0xcbd847ea },
            { "rom8.ic8s",       0x4000000, 0x800000, 0x3bfc6571 },
            { "rom9.ic9s",       0x4800000, 0x800000, 0xc0a14f8e },
            { "rom10.ic10s",     0x5000000, 0x800000, 0xee68d756 },
            { "rom11.ic11s",     0x5800000, 0x800000, 0x3b53f0c9 },
            { "rom12.ic12s",     0x6000000, 0x800000, 0xc17a2228 },
            { "rom13.ic13s",     0x6800000, 0x800000, 0x31ab7352 },
            { "rom14.ic14s",     0x7000000, 0x800000, 0xaf4c757b },
            { "rom15.ic15s",     0x7800000, 0x800000, 0x7adceb6b },
            { "rom16.ic16s",     0x8000000, 0x800000, 0x1ce2ec11 },
            { "rom17.ic17s",     0x8800000, 0x800000, 0x1c659384 },
            { "rom18.ic18s",     0x9000000, 0x800000, 0x361ea725 },
            { "rom19.ic19s",     0x9800000, 0x800000, 0x3327aed1 },
            { "rom20.ic20s",     0xa000000, 0x800000, 0xd4148f39 },
            { "rom21.ic21s",     0xa800000, 0x800000, 0x955ad42e },
        },
		nullptr,
		&f355_inputs,
		nullptr,
		3,
    },
    // Ferrari F355 Challenge 2 (twin)
    {
        "f355twn2",
        NULL,
        "Ferrari F355 Challenge 2 - International Course Edition (twin/deluxe)",
        0xb000000,
        0x281666c6,
        "f355bios",
        M2,
        ROT0,
        {
            { "epr-23399.ic22",  0x0000000, 0x400000 },
            //{ "epr-23399_alt.ic22", 0x0000000, 0x400000 },
            { "mpr-23378.ic1",   0x0800000, 0x800000 },
            { "mpr-23379.ic2",   0x1000000, 0x800000 },
            { "mpr-23380.ic3",   0x1800000, 0x800000 },
            { "mpr-23381.ic4",   0x2000000, 0x800000 },
            { "mpr-23382.ic5",   0x2800000, 0x800000 },
            { "mpr-23383.ic6",   0x3000000, 0x800000 },
            { "mpr-23384.ic7",   0x3800000, 0x800000 },
            { "mpr-23385.ic8",   0x4000000, 0x800000 },
            { "mpr-23386.ic9",   0x4800000, 0x800000 },
            { "mpr-23387.ic10",  0x5000000, 0x800000 },
            { "mpr-23388.ic11",  0x5800000, 0x800000 },
            { "mpr-23389.ic12s", 0x6000000, 0x800000 },
            { "mpr-23390.ic13s", 0x6800000, 0x800000 },
            { "mpr-23391.ic14s", 0x7000000, 0x800000 },
            { "mpr-23392.ic15s", 0x7800000, 0x800000 },
            { "mpr-23393.ic16s", 0x8000000, 0x800000 },
            { "mpr-23394.ic17s", 0x8800000, 0x800000 },
            { "mpr-23395.ic18s", 0x9000000, 0x800000 },
            { "mpr-23396.ic19s", 0x9800000, 0x800000 },
            { "mpr-23397.ic20s", 0xa000000, 0x800000 },
            { "mpr-23398.ic21s", 0xa800000, 0x800000 },
        },
		nullptr,
		&f355_inputs,
		nullptr,
		3,
    },
#endif
    // Giant Gram: All Japan Pro Wrestling 2 (JPN, USA, EXP, KOR, AUS)
    {
        "ggram2",
        NULL,
        "Giant Gram: All Japan Pro Wrestling 2",
        0x06000000,
        0x28074a61,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21820.ic22", 0x0000000, 0x0200000 },
            { "epr-21820.ic22", 0x0200000, 0x0200000 }, // reload
            { "mpr-21821.ic1",  0x0800000, 0x0800000 },
            // IC2 empty
            { "mpr-21823.ic3",  0x1800000, 0x0800000 },
            { "mpr-21824.ic4",  0x2000000, 0x0800000 },
            { "mpr-21825.ic5",  0x2800000, 0x0800000 },
            { "mpr-21826.ic6",  0x3000000, 0x0800000 },
            { "mpr-21827.ic7",  0x3800000, 0x0800000 },
            // IC8 empty
            { "mpr-21829.ic9",  0x4800000, 0x0800000 },
            { "mpr-21830.ic10", 0x5000000, 0x0800000 },
            { "mpr-21831.ic11", 0x5800000, 0x0800000 },
        },
		nullptr,
        &giant_gram_inputs,
    },
    // Guilty Gear X (JPN)
    {
        "ggx",
        NULL,
        "Guilty Gear X",
        0x07800000,
        0x00076110,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23356.ic22",  0x0000000, 0x0400000 },
            { "mpr-23342.ic1",   0x0800000, 0x0800000 },
            { "mpr-23343.ic2",   0x1000000, 0x0800000 },
            { "mpr-23344.ic3",   0x1800000, 0x0800000 },
            { "mpr-23345.ic4",   0x2000000, 0x0800000 },
            { "mpr-23346.ic5",   0x2800000, 0x0800000 },
            { "mpr-23347.ic6",   0x3000000, 0x0800000 },
            { "mpr-23348.ic7",   0x3800000, 0x0800000 },
            { "mpr-23349.ic8",   0x4000000, 0x0800000 },
            { "mpr-23350.ic9",   0x4800000, 0x0800000 },
            { "mpr-23351.ic10",  0x5000000, 0x0800000 },
            { "mpr-23352.ic11",  0x5800000, 0x0800000 },
            { "mpr-23353.ic12s", 0x6000000, 0x0800000 },
            { "mpr-23354.ic13s", 0x6800000, 0x0800000 },
            { "mpr-23355.ic14s", 0x7000000, 0x0800000 },
        },
		nullptr,
		&ggx_inputs,
		// error message at boot with free play eeprom
    },
    // Mobile Suit Gundam: Federation vs. Zeon
    {
        "gundmct",
        NULL,
        "Mobile Suit Gundam: Federation vs. Zeon",
        0x0a800000,
        0x000e8010,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23638.ic22", 0x0000000, 0x0400000 },
            { "mpr-23628.ic1",  0x0800000, 0x1000000 },
            { "mpr-23629.ic2",  0x1800000, 0x1000000 },
            { "mpr-23630.ic3",  0x2800000, 0x1000000 },
            { "mpr-23631.ic4",  0x3800000, 0x1000000 },
            { "mpr-23632.ic5",  0x4800000, 0x1000000 },
            { "mpr-23633.ic6",  0x5800000, 0x1000000 },
            { "mpr-23634.ic7",  0x6800000, 0x1000000 },
            { "mpr-23635.ic8",  0x7800000, 0x1000000 },
            { "mpr-23636.ic9",  0x8800000, 0x1000000 },
            { "mpr-23637.ic10", 0x9800000, 0x1000000 },
        },
        NULL,
        &shot1234_inputs,
        gundmct_eeprom_dump
    },
    // Gun Survivor 2 Biohazard Code: Veronica (BHF2 Ver. E)
    {
        "gunsur2",
        NULL,
        "Gun Survivor 2 Biohazard Code: Veronica (World)",
        0x10000000,
        0x000680d0,
        NULL,
        M2,
        ROT0,
        {
            { "bhf2vere.2f", 0x0000000, 0x0800000, 0x756e0de6 },
            { "bhf1ma2.4m",  0x2000000, 0x1000000, 0x8073dec7 },
            { "bhf1ma3.4l",  0x3000000, 0x1000000, 0x43cd16a4 },
            { "bhf1ma4.4k",  0x4000000, 0x1000000, 0xf6aebed8 },
            { "bhf1ma5.4j",  0x5000000, 0x1000000, 0xb5e1b582 },
            { "bhf1ma6.4h",  0x6000000, 0x1000000, 0x345fd824 },
            { "bhf1ma7.4f",  0x7000000, 0x1000000, 0x465ecff1 },
            { "bhf1ma8.4e",  0x8000000, 0x1000000, 0x76c92354 },
            { "bhf1ma9.4d",  0x9000000, 0x1000000, 0xd45a46ee },
            { "bhf1ma10.4c", 0xa000000, 0x1000000, 0x8c38d1f7 },
            { "bhf1ma11.4b", 0xb000000, 0x1000000, 0xf49153c4 },
            { "bhf1ma12.6p", 0xc000000, 0x1000000, 0x0e2bdd9a },
            { "bhf1ma13.6n", 0xd000000, 0x1000000, 0x055718ad },
            { "bhf1ma14.6m", 0xe000000, 0x1000000, 0xd06c9bd7 },
            { "bhf1ma15.6l", 0xf000000, 0x1000000, 0xdb3c396b },
        },
        NULL,
        &gunsur2_inputs,
		// no free play with eeprom
    },
    // Gun Survivor 2 Biohazard Code: Veronica (Japan, BHF1 Ver.E)
    {
        "gunsur2j",
        "gunsur2",
        "Gun Survivor 2 Biohazard Code: Veronica (Japan)",
        0x10000000,
        0x000680d0,
        NULL,
        M2,
        ROT0,
        {
            { "bhf1vere.2f", 0x0000000, 0x0800000, 0x121ea283 },
            { "bhf1ma2.4m",  0x2000000, 0x1000000, 0x8073dec7 },
            { "bhf1ma3.4l",  0x3000000, 0x1000000, 0x43cd16a4 },
            { "bhf1ma4.4k",  0x4000000, 0x1000000, 0xf6aebed8 },
            { "bhf1ma5.4j",  0x5000000, 0x1000000, 0xb5e1b582 },
            { "bhf1ma6.4h",  0x6000000, 0x1000000, 0x345fd824 },
            { "bhf1ma7.4f",  0x7000000, 0x1000000, 0x465ecff1 },
            { "bhf1ma8.4e",  0x8000000, 0x1000000, 0x76c92354 },
            { "bhf1ma9.4d",  0x9000000, 0x1000000, 0xd45a46ee },
            { "bhf1ma10.4c", 0xa000000, 0x1000000, 0x8c38d1f7 },
            { "bhf1ma11.4b", 0xb000000, 0x1000000, 0xf49153c4 },
            { "bhf1ma12.6p", 0xc000000, 0x1000000, 0x0e2bdd9a },
            { "bhf1ma13.6n", 0xd000000, 0x1000000, 0x055718ad },
            { "bhf1ma14.6m", 0xe000000, 0x1000000, 0xd06c9bd7 },
            { "bhf1ma15.6l", 0xf000000, 0x1000000, 0xdb3c396b },
        },
        NULL,
        &gunsur2_inputs,
		// no free play with eeprom
    },
    // Giga Wing 2
    {
        "gwing2",
        NULL,
        "Giga Wing 2",
        0x05800000,
        0x000b25d0,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22270.ic22", 0x0000000, 0x0200000 },
            { "epr-22270.ic22", 0x0200000, 0x0200000 }, // reload
            { "mpr-22271.ic1", 0x0800000, 0x1000000 },
            { "mpr-22272.ic2", 0x1800000, 0x1000000 },
            { "mpr-22273.ic3", 0x2800000, 0x1000000 },
            { "mpr-22274.ic4", 0x3800000, 0x1000000 },
            { "mpr-22275.ic5", 0x4800000, 0x1000000 },
        },
        nullptr,
        &shot12_inputs,
    },
    // Heavy Metal: Geomatrix (JPN, USA, EUR, ASI, AUS) (Rev B)
    {
        "hmgeo",
        NULL,
        "Heavy Metal: Geomatrix",
        0x06000000,
        0x00038510,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23716a.ic22", 0x0000000, 0x0400000 },
            { "mpr-23705.ic1",   0x0800000, 0x0800000 },
            { "mpr-23706.ic2",   0x1000000, 0x0800000 },
            { "mpr-23707.ic3",   0x1800000, 0x0800000 },
            { "mpr-23708.ic4",   0x2000000, 0x0800000 },
            { "mpr-23709.ic5",   0x2800000, 0x0800000 },
            { "mpr-23710.ic6",   0x3000000, 0x0800000 },
            { "mpr-23711.ic7",   0x3800000, 0x0800000 },
            { "mpr-23712.ic8",   0x4000000, 0x0800000 },
            { "mpr-23713.ic9",   0x4800000, 0x0800000 },
            { "mpr-23714.ic10",  0x5000000, 0x0800000 },
            { "mpr-23715.ic11",  0x5800000, 0x0800000 },
        },
        NULL,
		&hmgeo_inputs,
        hmgeo_eeprom_dump,
    },
    // House of the Dead 2
    {
        "hotd2",
        NULL,
        "The House of the Dead 2 (USA)",
        0xa800000,
        0xfffffff, // not populated
        "hod2bios",
        M2,
        ROT0,
        {
            { "epr-21585.ic22",  0x0000000, 0x200000 },
            { "epr-21585.ic22",  0x0200000, 0x200000 }, // reload
            { "mpr-21386.ic1",   0x0800000, 0x800000 },
            { "mpr-21387.ic2",   0x1000000, 0x800000 },
            { "mpr-21388.ic3",   0x1800000, 0x800000 },
            { "mpr-21389.ic4",   0x2000000, 0x800000 },
            { "mpr-21390.ic5",   0x2800000, 0x800000 },
            { "mpr-21391.ic6",   0x3000000, 0x800000 },
            { "mpr-21392.ic7",   0x3800000, 0x800000 },
            { "mpr-21393.ic8",   0x4000000, 0x800000 },
            { "mpr-21394.ic9",   0x4800000, 0x800000 },
            { "mpr-21395.ic10",  0x5000000, 0x800000 },
            { "mpr-21396.ic11",  0x5800000, 0x800000 },
            { "mpr-21397.ic12s", 0x6000000, 0x800000 },
            { "mpr-21398.ic13s", 0x6800000, 0x800000 },
            { "mpr-21399.ic14s", 0x7000000, 0x800000 },
            { "mpr-21400.ic15s", 0x7800000, 0x800000 },
            { "mpr-21401.ic16s", 0x8000000, 0x800000 },
            { "mpr-21402.ic17s", 0x8800000, 0x800000 },
            { "mpr-21403.ic18s", 0x9000000, 0x800000 },
            { "mpr-21404.ic19s", 0x9800000, 0x800000 },
            { "mpr-21405.ic20s", 0xa000000, 0x800000 },
        },
		nullptr,
		&lightgun_inputs,
		// no free play with eeprom
    },
    // The House of the Dead 2
    {
        "hotd2o",
        "hotd2",
        "The House of the Dead 2",
        0xa800000,
        0xfffffff, // not populated
        "hod2bios",
        M2,
        ROT0,
        {
            { "epr-21385.ic22",  0x0000000, 0x200000 },
            { "epr-21385.ic22",  0x0200000, 0x200000 }, //reload
            { "mpr-21386.ic1",   0x0800000, 0x800000 },
            { "mpr-21387.ic2",   0x1000000, 0x800000 },
            { "mpr-21388.ic3",   0x1800000, 0x800000 },
            { "mpr-21389.ic4",   0x2000000, 0x800000 },
            { "mpr-21390.ic5",   0x2800000, 0x800000 },
            { "mpr-21391.ic6",   0x3000000, 0x800000 },
            { "mpr-21392.ic7",   0x3800000, 0x800000 },
            { "mpr-21393.ic8",   0x4000000, 0x800000 },
            { "mpr-21394.ic9",   0x4800000, 0x800000 },
            { "mpr-21395.ic10",  0x5000000, 0x800000 },
            { "mpr-21396.ic11",  0x5800000, 0x800000 },
            { "mpr-21397.ic12s", 0x6000000, 0x800000 },
            { "mpr-21398.ic13s", 0x6800000, 0x800000 },
            { "mpr-21399.ic14s", 0x7000000, 0x800000 },
            { "mpr-21400.ic15s", 0x7800000, 0x800000 },
            { "mpr-21401.ic16s", 0x8000000, 0x800000 },
            { "mpr-21402.ic17s", 0x8800000, 0x800000 },
            { "mpr-21403.ic18s", 0x9000000, 0x800000 },
            { "mpr-21404.ic19s", 0x9800000, 0x800000 },
            { "mpr-21405.ic20s", 0xa000000, 0x800000 },
        },
		nullptr,
		&lightgun_inputs,
		// no free play with eeprom
    },
    // The House of the Dead 2 (Export)
    {
        "hotd2e",
        "hotd2",
        "The House of the Dead 2 (Export)",
        0xa800000,
        0xfffffff, // not populated
        "hod2bios",
        M2,
        ROT0,
        {
            { "epr-21805.ic22",  0x0000000, 0x200000 },
            { "epr-21805.ic22",  0x0200000, 0x200000 }, //reload
            { "mpr-21386.ic1",   0x0800000, 0x800000 },
            { "mpr-21387.ic2",   0x1000000, 0x800000 },
            { "mpr-21388.ic3",   0x1800000, 0x800000 },
            { "mpr-21389.ic4",   0x2000000, 0x800000 },
            { "mpr-21390.ic5",   0x2800000, 0x800000 },
            { "mpr-21391.ic6",   0x3000000, 0x800000 },
            { "mpr-21392.ic7",   0x3800000, 0x800000 },
            { "mpr-21393.ic8",   0x4000000, 0x800000 },
            { "mpr-21394.ic9",   0x4800000, 0x800000 },
            { "mpr-21395.ic10",  0x5000000, 0x800000 },
            { "mpr-21396.ic11",  0x5800000, 0x800000 },
            { "mpr-21397.ic12s", 0x6000000, 0x800000 },
            { "mpr-21398.ic13s", 0x6800000, 0x800000 },
            { "mpr-21399.ic14s", 0x7000000, 0x800000 },
            { "mpr-21400.ic15s", 0x7800000, 0x800000 },
            { "mpr-21401.ic16s", 0x8000000, 0x800000 },
            { "mpr-21402.ic17s", 0x8800000, 0x800000 },
            { "mpr-21403.ic18s", 0x9000000, 0x800000 },
            { "mpr-21404.ic19s", 0x9800000, 0x800000 },
            { "mpr-21405.ic20s", 0xa000000, 0x800000 },
        },
		nullptr,
		&lightgun_inputs,
		// no free play with eeprom
    },
    // The House of the Dead 2 (prototype)
    {
        "hotd2p",
        "hotd2",
        "The House of the Dead 2 (prototype)",
        0xb000000,
        0xfffffff, // not populated
        "hod2bios",
        M2,
        ROT0,
        {
            { "hotd2proto.ic22", 0x000000,  0x200000 },
            { "hotd2proto.ic22", 0x200000,  0x200000 },
            { "mpr-21386.ic1",   0x0800000, 0x800000 },
            { "mpr-21387.ic2",   0x1000000, 0x800000 },
            { "mpr-21388.ic3",   0x1800000, 0x800000 },
            { "mpr-21389.ic4",   0x2000000, 0x800000 },
            { "mpr-21390.ic5",   0x2800000, 0x800000 },
            { "mpr-21391.ic6",   0x3000000, 0x800000 },
            { "mpr-21392.ic7",   0x3800000, 0x800000 },
            { "mpr-21393.ic8",   0x4000000, 0x800000 },
            { "mpr-21394.ic9",   0x4800000, 0x800000 },
            { "mpr-21395.ic10",  0x5000000, 0x800000 },
            { "mpr-21396.ic11",  0x5800000, 0x800000 },
            { "mpr-21397.ic12s", 0x6000000, 0x800000 },
            { "mpr-21398.ic13s", 0x6800000, 0x800000 },
            { "mpr-21399.ic14s", 0x7000000, 0x800000 },
            { "mpr-21400.ic15s", 0x7800000, 0x800000 },
            { "mpr-21401.ic16s", 0x8000000, 0x800000 },
            { "mpr-21402.ic17s", 0x8800000, 0x800000 },
            { "mpr-21403.ic18s", 0x9000000, 0x800000 },
            { "mpr-21404.ic19s", 0x9800000, 0x800000 },
            { "mpr-21405.ic20s", 0xa000000, 0x800000 },
            { "rom21.ic21s",     0xa800000, 0x800000, 0x256603d7 },
        },
		nullptr,
		&lightgun_inputs,
		// no free play with eeprom
    },
    // Inu No Osanpo / Dog Walking (Japan, Export, Rev A)
    {
        "inunoos",
        NULL,
        "Inu no Osanpo / Dog Walking",
        0x08800000,
        0x294bc3e3,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22294a.ic22", 0x0000000, 0x400000 },
            { "rom1.ic1s",       0x0800000, 0x800000 },
            { "rom2.ic2s",       0x1000000, 0x800000 },
            { "rom3.ic3s",       0x1800000, 0x800000 },
            { "rom4.ic4s",       0x2000000, 0x800000 },
            { "rom5.ic5s",       0x2800000, 0x800000 },
            { "rom6.ic6s",       0x3000000, 0x800000 },
            { "rom7.ic7s",       0x3800000, 0x800000 },
            { "rom8.ic8s",       0x4000000, 0x800000 },
            { "rom9.ic9s",       0x4800000, 0x800000 },
            { "rom10.ic10s",     0x5000000, 0x800000 },
            { "rom11.ic11s",     0x5800000, 0x800000 },
            { "rom12.ic12s",     0x6000000, 0x800000 },
            { "rom13.ic13s",     0x6800000, 0x800000 },
            { "rom14.ic14s",     0x7000000, 0x800000 },
            { "rom15.ic15s",     0x7800000, 0x800000 },
            { "rom16.ic16s",     0x8000000, 0x800000 },
        }
    },
    // Jambo! Safari (Rev A)
    {
        "jambo",
        NULL,
        "Jambo! Safari",
        0x08800000,
        0x280fab95,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22826a.ic22", 0x0000000, 0x400000 },
            { "mpr-22818.ic1",  0x0800000, 0x800000 },
            { "mpr-22819.ic2",  0x1000000, 0x800000 },
            { "mpr-22820.ic3",  0x1800000, 0x800000 },
            { "mpr-22821.ic4",  0x2000000, 0x800000 },
            { "mpr-22822.ic5",  0x2800000, 0x800000 },
            { "mpr-22823.ic6",  0x3000000, 0x800000 },
            { "mpr-22824.ic7",  0x3800000, 0x800000 },
            { "mpr-22825.ic8",  0x4000000, 0x800000 },
        },
        NULL,
        &jambo_inputs
    },
    // Mars TV (JPN)
    {
        "marstv",
		nullptr,
        "Mars TV",
        0x08000000,
        0x280b8ef5,
		"naomi-jp-d",
        M2,
        ROT0,
        {
            { "epr-22993.ic22",  0x0000000, 0x200000 },
            { "epr-22993.ic22",  0x0200000, 0x200000 }, // reload
            { "mpr-22978.ic1",   0x0800000, 0x800000 },
            { "mpr-22979.ic2",   0x1000000, 0x800000 },
            { "mpr-22980.ic3",   0x1800000, 0x800000 },
            { "mpr-22981.ic4",   0x2000000, 0x800000 },
            { "mpr-22982.ic5",   0x2800000, 0x800000 },
            { "mpr-22983.ic6",   0x3000000, 0x800000 },
            { "mpr-22984.ic7",   0x3800000, 0x800000 },
            { "mpr-22985.ic8",   0x4000000, 0x800000 },
            { "mpr-22986.ic9",   0x4800000, 0x800000 },
            { "mpr-22987.ic10",  0x5000000, 0x800000 },
            { "mpr-22988.ic11",  0x5800000, 0x800000 },
            { "mpr-22989.ic12s", 0x6000000, 0x800000 },
            { "mpr-22990.ic13s", 0x6800000, 0x800000 },
            { "mpr-22991.ic14s", 0x7000000, 0x800000 },
            { "mpr-22992.ic15s", 0x7800000, 0x800000 },
        },
		nullptr,
		nullptr,	// TODO
    },
    // Mazan: Flash of the Blade (MAZ2 Ver. A)
    {
        "mazan",
        NULL,
        "Mazan: Flash of the Blade (World)",
        0x10000000,
        0x280fea94,
		nullptr,
        M2,
        ROT0,
        {
            { "maz2vera.2d", 0x0800000, 0x0800000, 0x620cdbb6 },
            { "maz1ma1.4m",  0x1000000, 0x1000000, 0x68e12189 },
            { "maz1ma2.4l",  0x2000000, 0x1000000, 0xc7a05b44 },
            { "maz1ma3.4k",  0x3000000, 0x1000000, 0x48e1a8a5 },
            { "maz1ma4.4j",  0x4000000, 0x1000000, 0x0187cdab },
            { "maz1ma5.4h",  0x5000000, 0x1000000, 0xc6885ee7 },
            { "maz1ma6.4f",  0x6000000, 0x1000000, 0xa6593c36 },
            { "maz1ma7.4e",  0x7000000, 0x1000000, 0x6103ad9c },
            { "maz1ma8.4d",  0x8000000, 0x1000000, 0xd46c9f40 },
        },
		nullptr,
		&mazan_inputs,
		// no free play with eeprom
    },
    // Mazan: Flash of the Blade (US, MAZ3 Ver.A)
    {
        "mazanu",
        "mazan",
        "Mazan: Flash of the Blade (US)",
        0x10000000,
        0x280fea94,
		nullptr,
        M2,
        ROT0,
        {
            { "maz3vera.2d", 0x0800000, 0x0800000, 0xa4344ec9 },
            { "maz1ma1.4m",  0x1000000, 0x1000000, 0x68e12189 },
            { "maz1ma2.4l",  0x2000000, 0x1000000, 0xc7a05b44 },
            { "maz1ma3.4k",  0x3000000, 0x1000000, 0x48e1a8a5 },
            { "maz1ma4.4j",  0x4000000, 0x1000000, 0x0187cdab },
            { "maz1ma5.4h",  0x5000000, 0x1000000, 0xc6885ee7 },
            { "maz1ma6.4f",  0x6000000, 0x1000000, 0xa6593c36 },
            { "maz1ma7.4e",  0x7000000, 0x1000000, 0x6103ad9c },
            { "maz1ma8.4d",  0x8000000, 0x1000000, 0xd46c9f40 },
        },
		nullptr,
		&mazan_inputs,
		// no free play with eeprom
    },
    // Mazan: Flash of the Blade (Japan, MAZ1 Ver.A)
    {
        "mazanj",
        "mazan",
        "Mazan: Flash of the Blade (Japan)",
        0x10000000,
        0x280fea94,
		nullptr,
        M2,
        ROT0,
        {
            { "maz1vera.2d", 0x0800000, 0x0800000, 0xd157f771 },
            { "maz1ma1.4m",  0x1000000, 0x1000000, 0x68e12189 },
            { "maz1ma2.4l",  0x2000000, 0x1000000, 0xc7a05b44 },
            { "maz1ma3.4k",  0x3000000, 0x1000000, 0x48e1a8a5 },
            { "maz1ma4.4j",  0x4000000, 0x1000000, 0x0187cdab },
            { "maz1ma5.4h",  0x5000000, 0x1000000, 0xc6885ee7 },
            { "maz1ma6.4f",  0x6000000, 0x1000000, 0xa6593c36 },
            { "maz1ma7.4e",  0x7000000, 0x1000000, 0x6103ad9c },
            { "maz1ma8.4d",  0x8000000, 0x1000000, 0xd46c9f40 },
        },
		nullptr,
		&mazan_inputs,
		// no free play with eeprom
    },
    // Mushiking The King Of Beetles 2004 Second (Japan)
    {
        "mushi2k4",
        nullptr,
        "Mushiking The King Of Beetles 2004 Second (Japan)",
        0x5800000,
        0xffffffff, // not populated
        "naomi",
        M2,
        ROT0,
        {
            { "epr-24241.ic22", 0x00000000, 0x00400000 },
            { "mpr-24242.ic1",  0x00800000, 0x01000000 },
            { "mpr-24243.ic2",  0x01800000, 0x01000000 },
            { "mpr-24244.ic3",  0x02800000, 0x01000000 },
            { "mpr-24245.ic4",  0x03800000, 0x01000000 },
            { "mpr-24246.ic5",  0x04800000, 0x01000000 },
        },
		nullptr,
		&mushik_inputs,
    },
    // Mushiking The King Of Beetles 2005 First (Japan)
    {
        "mushi2k5",
        nullptr,
        "Mushiking The King Of Beetles 2005 First (Japan)",
        0x7800000,
        0xffffffff, // not populated
        "naomi",
        M2,
        ROT0,
        {
            { "epr-24286.ic22", 0x0000000, 0x0400000, 0x00000000 },
            { "mpr-24276.ic1",  0x0800000, 0x1000000, 0x00000000 },
            { "mpr-24277.ic2",  0x1800000, 0x1000000, 0x00000000 },
            { "mpr-24278.ic3",  0x2800000, 0x1000000, 0x00000000 },
            { "mpr-24279.ic4",  0x3800000, 0x1000000, 0x00000000 },
            { "mpr-24280.ic5",  0x4800000, 0x1000000, 0x00000000 },
            { "mpr-24281.ic6",  0x5800000, 0x1000000, 0x00000000 },
            { "mpr-24282.ic7",  0x6800000, 0x1000000, 0x00000000 },
        },
		nullptr,
		&mushik_inputs,
    },
    // Mushiking The King Of Beetle (MUSHIUSA '04 1ST, Prototype)
    {
        "mushikep",
        "mushike",
        "Mushiking The King Of Beetle (MUSHIUSA '04 1ST, Prototype)",
        0x07800000,
        0xffffffff, // not populated
        "naomi",
        M2,
        ROT0,
        {
            { "rom1.ic1s", 0x0800000, 0x800000, 0x9cdc8dcb },
            { "rom2.ic2s", 0x1000000, 0x800000, 0x7b637bb6 },
            { "rom3.ic3s", 0x1800000, 0x800000, 0x6c6ddfbf },
            { "rom4.ic4s", 0x2000000, 0x800000, 0xa427002d },
            { "rom5.ic5s", 0x2800000, 0x800000, 0x7076a50e },
            { "rom6.ic6s", 0x3000000, 0x800000, 0xd7143066 },
            { "rom7.ic7s", 0x3800000, 0x800000, 0x98839bab },
        },
		nullptr,
		&mushik_inputs,
    },
    // Marvel vs. Capcom 2 New Age of Heroes (USA, Rev A)
    {
        "mvsc2u",
        "mvsc2",
        "Marvel vs. Capcom 2 New Age of Heroes (USA)",
        0x07800000,
        0x0002c840,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23062a.ic22", 0x0000000, 0x0400000, 0x96038276 },
            { "mpr-23048.ic1",   0x0800000, 0x0800000, 0x93d7a63a },
            { "mpr-23049.ic2",   0x1000000, 0x0800000, 0x003dcce0 },
            { "mpr-23050.ic3",   0x1800000, 0x0800000, 0x1d6b88a7 },
            { "mpr-23051.ic4",   0x2000000, 0x0800000, 0x01226aaa },
            { "mpr-23052.ic5",   0x2800000, 0x0800000, 0x74bee120 },
            { "mpr-23053.ic6",   0x3000000, 0x0800000, 0xd92d4401 },
            { "mpr-23054.ic7",   0x3800000, 0x0800000, 0x78ba02e8 },
            { "mpr-23055.ic8",   0x4000000, 0x0800000, 0x84319604 },
            { "mpr-23056.ic9",   0x4800000, 0x0800000, 0xd7386034 },
            { "mpr-23057.ic10",  0x5000000, 0x0800000, 0xa3f087db },
            { "mpr-23058.ic11",  0x5800000, 0x0800000, 0x61a6cc5d },
            { "mpr-23059.ic12s", 0x6000000, 0x0800000, 0x64808024 },
            { "mpr-23060.ic13s", 0x6800000, 0x0800000, 0x67519942 },
            { "mpr-23061.ic14s", 0x7000000, 0x0800000, 0xfb1844c4 },

            //ROM_REGION(0x84, "some_eeprom", 0)
            //ROM_LOAD("sflash.ic37", 0x000000, 0x000084, CRC(37a66f3c) SHA1(df6cd2cdc2813caa5da4dc9f171998485bcbdc44))
        },
        NULL,
        &mvsc2_inputs,
		mvsc2_eeprom_dump,
    },
    // Ninja Assault (NJA3 Ver. A)
    {
        "ninjaslt",
        NULL,
        "Ninja Assault (World, NJA2 Ver.A)",
        0xb000000,
        0x000ca510,
        NULL,
        M2,
        ROT0,
        {
            { "nja2vera.2d", 0x0800000, 0x0800000 },
            { "nja1vera.2c", 0x1000000, 0x0800000 },
            { "nja1vera.2b", 0x1800000, 0x0800000 },
            { "nja1ma2.4l",      0x2000000, 0x1000000 },
            { "nja1ma3.4k",      0x3000000, 0x1000000 },
            { "nja1ma4.4j",      0x4000000, 0x1000000 },
            { "nja1ma5.4h",      0x5000000, 0x1000000 },
            { "nja1ma6.4f",      0x6000000, 0x1000000 },
            { "nja1ma7.4e",      0x7000000, 0x1000000 },
            { "nja1ma8.4d",      0x8000000, 0x1000000 },
            { "nja1ma9.4c",      0x9000000, 0x1000000 },
            { "nja1ma10.4b",     0xa000000, 0x1000000 },
            //ROM_REGION( 0x20000, "jyu_io", 0 )  // H8/3334-based I/O board ROM, eventually should be separated out
            //ROM_LOAD( "jyu1_prg0a.ic3", 0x000000, 0x020000, CRC(aec4dbc1) SHA1(bddd4f345baf7f594998a39c09da18b3834f0ac2) )
        },
        NULL,
        &ninjaslt_inputs,
		// no free play with eeprom
    },
    // Ninja Assault (Asia, NJA4 Ver.A)
    {
        "ninjaslta",
        "ninjaslt",
        "Ninja Assault (Asia, NJA4 Ver.A)",
        0xb000000,
        0x000ca510,
        NULL,
        M2,
        ROT0,
        {
            { "nja4vera.2d",     0x0800000, 0x0800000 },
            { "nja1vera.2c",     0x1000000, 0x0800000 },
            { "nja1vera.2b",     0x1800000, 0x0800000 },
            { "nja1ma2.4l",      0x2000000, 0x1000000 },
            { "nja1ma3.4k",      0x3000000, 0x1000000 },
            { "nja1ma4.4j",      0x4000000, 0x1000000 },
            { "nja1ma5.4h",      0x5000000, 0x1000000 },
            { "nja1ma6.4f",      0x6000000, 0x1000000 },
            { "nja1ma7.4e",      0x7000000, 0x1000000 },
            { "nja1ma8.4d",      0x8000000, 0x1000000 },
            { "nja1ma9.4c",      0x9000000, 0x1000000 },
            { "nja1ma10.4b",     0xa000000, 0x1000000 },

            //ROM_REGION( 0x20000, "jyu_io", 0 )  // H8/3334-based I/O board ROM, eventually should be separated out
            //ROM_LOAD( "jyu1_prg0a.ic3", 0x000000, 0x020000, CRC(aec4dbc1) SHA1(bddd4f345baf7f594998a39c09da18b3834f0ac2) )
        },
        NULL,
        &ninjaslt_inputs,
		// no free play with eeprom
    },
    // Ninja Assault (Japan, NJA1 Ver.A)
    {
        "ninjasltj",
        "ninjaslt",
        "Ninja Assault (Japan, NJA1 Ver.A)",
        0xb000000,
        0x000ca510,
        NULL,
        M2,
        ROT0,
        {
            { "nja1vera.2d",     0x0800000, 0x0800000 },
            { "nja1vera.2c",     0x1000000, 0x0800000 },
            { "nja1vera.2b",     0x1800000, 0x0800000 },
            { "nja1ma2.4l",      0x2000000, 0x1000000 },
            { "nja1ma3.4k",      0x3000000, 0x1000000 },
            { "nja1ma4.4j",      0x4000000, 0x1000000 },
            { "nja1ma5.4h",      0x5000000, 0x1000000 },
            { "nja1ma6.4f",      0x6000000, 0x1000000 },
            { "nja1ma7.4e",      0x7000000, 0x1000000 },
            { "nja1ma8.4d",      0x8000000, 0x1000000 },
            { "nja1ma9.4c",      0x9000000, 0x1000000 },
            { "nja1ma10.4b",     0xa000000, 0x1000000 },

            //ROM_REGION( 0x20000, "jyu_io", 0 )  // H8/3334-based I/O board ROM, eventually should be separated out
            //ROM_LOAD( "jyu1_prg0a.ic3", 0x000000, 0x020000, CRC(aec4dbc1) SHA1(bddd4f345baf7f594998a39c09da18b3834f0ac2) )
        },
        NULL,
        &ninjaslt_inputs,
		// no free play with eeprom
    },
    // Ninja Assault (US, NJA3 Ver.A)
    {
        "ninjasltu",
        "ninjaslt",
        "Ninja Assault (US, NJA3 Ver.A)",
        0xb000000,
        0x000ca510,
        NULL,
        M2,
        ROT0,
        {
            { "nja3vera.2d", 0x0800000, 0x0800000 },
            { "nja1vera.2c", 0x1000000, 0x0800000 },
            { "nja1vera.2b", 0x1800000, 0x0800000 },
            { "nja1ma2.4l",  0x2000000, 0x1000000 },
            { "nja1ma3.4k",  0x3000000, 0x1000000 },
            { "nja1ma4.4j",  0x4000000, 0x1000000 },
            { "nja1ma5.4h",  0x5000000, 0x1000000 },
            { "nja1ma6.4f",  0x6000000, 0x1000000 },
            { "nja1ma7.4e",  0x7000000, 0x1000000 },
            { "nja1ma8.4d",  0x8000000, 0x1000000 },
            { "nja1ma9.4c",  0x9000000, 0x1000000 },
            { "nja1ma10.4b", 0xa000000, 0x1000000 },

            //ROM_REGION( 0x20000, "jyu_io", 0 )  // H8/3334-based I/O board ROM, eventually should be separated out
            //ROM_LOAD( "jyu1_prg0a.ic3", 0x000000, 0x020000, CRC(aec4dbc1) SHA1(bddd4f345baf7f594998a39c09da18b3834f0ac2) )
        },
        NULL,
        &ninjaslt_inputs,
		// no free play with eeprom
    },
    // Oinori-daimyoujin Matsuri
    {
        "oinori",
        NULL,
        "Oinori-daimyoujin Matsuri",
        0x05800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-24053.ic22", 0x0000000, 0x0400000 },
            { "mpr-24054.ic1",  0x0800000, 0x1000000 },
            { "mpr-24055.ic2",  0x1800000, 0x1000000 },
            { "mpr-24056.ic3",  0x2800000, 0x1000000 },
            { "mpr-24057.ic4",  0x3800000, 0x1000000 },
            { "mpr-24058.ic5",  0x4800000, 0x1000000 },
        }
    },
    // OutTrigger (JPN, USA, EXP, KOR, AUS)
    {
        "otrigger",
        NULL,
        "OutTrigger",
        0xa000000,
        0x280fea94,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22163.ic22", 0x0000000, 0x0400000 },
            { "mpr-22142.ic1",  0x0800000, 0x0800000 },
            { "mpr-22143.ic2",  0x1000000, 0x0800000 },
            { "mpr-22144.ic3",  0x1800000, 0x0800000 },
            { "mpr-22145.ic4",  0x2000000, 0x0800000 },
            { "mpr-22146.ic5",  0x2800000, 0x0800000 },
            { "mpr-22147.ic6",  0x3000000, 0x0800000 },
            { "mpr-22148.ic7",  0x3800000, 0x0800000 },
            { "mpr-22149.ic8",  0x4000000, 0x0800000 },
            { "mpr-22150.ic9",  0x4800000, 0x0800000 },
            { "mpr-22151.ic10", 0x5000000, 0x0800000 },
            { "mpr-22152.ic11", 0x5800000, 0x0800000 },
            { "mpr-22153.ic12s",0x6000000, 0x0800000 },
            { "mpr-22154.ic13s",0x6800000, 0x0800000 },
            { "mpr-22155.ic14s",0x7000000, 0x0800000 },
            { "mpr-22156.ic15s",0x7800000, 0x0800000 },
            { "mpr-22157.ic16s",0x8000000, 0x0800000 },
            { "mpr-22158.ic17s",0x8800000, 0x0800000 },
            { "mpr-22159.ic18s",0x9000000, 0x0800000 },
            { "mpr-22160.ic19s",0x9800000, 0x0800000 },
            //ROM_REGION( 0x10000, "io_board", 0)
            //ROM_LOAD("epr-22084.ic3", 0x0000, 0x10000, CRC(18cf58bb) SHA1(1494f8215231929e41bbe2a133658d01882fbb0f) )
        },
		nullptr,
		&otrigger_inputs,
		otrigger_eeprom_dump,
    },
    // Moero! Justice Gakuen (JPN) / Project Justice (USA, EXP, KOR, AUS) (Rev A)
    {
        "pjustica",
        "pjustic",
        "Project Justice / Moero! Justice Gakuen (Rev A)",
        0x0b800000,
        0x000725d0,
		"naomi",
        M2,
        ROT0,
        {
            { "epr-23548a.ic22", 0x0000000, 0x0400000, 0xf4ccf1ec },
            { "mpr-23537.ic1",   0x0800000, 0x1000000, 0xa2462770 },
            { "mpr-23538.ic2",   0x1800000, 0x1000000, 0xe4480832 },
            { "mpr-23539.ic3",   0x2800000, 0x1000000, 0x97e3f7f5 },
            { "mpr-23540.ic4",   0x3800000, 0x1000000, 0xb9e92d21 },
            { "mpr-23541.ic5",   0x4800000, 0x1000000, 0x95b8a9c6 },
            { "mpr-23542.ic6",   0x5800000, 0x1000000, 0xdfd490f5 },
            { "mpr-23543.ic7",   0x6800000, 0x1000000, 0x66847ebd },
            { "mpr-23544.ic8",   0x7800000, 0x1000000, 0xd1f5b460 },
            { "mpr-23545.ic9",   0x8800000, 0x1000000, 0x60bd692f },
            { "mpr-23546.ic10",  0x9800000, 0x1000000, 0x85db2248 },
            { "mpr-23547.ic11",  0xa800000, 0x1000000, 0x18b369c7 },
        },
		nullptr,
		&capcom_4btn_inputs,
    },
    // Moero! Justice Gakuen (JPN) / Project Justice (USA, EXP, KOR, AUS) (Rev B)
    {
        "pjustic",
		nullptr,
        "Project Justice / Moero! Justice Gakuen",
        0x0b800000,
        0x000725d0,
		"naomi",
        M2,
        ROT0,
        {
            { "epr-23548b.ic22", 0x0000000, 0x0400000, 0xd0dbdf40 },
            { "mpr-23537.ic1",   0x0800000, 0x1000000, 0xa2462770 },
            { "mpr-23538.ic2",   0x1800000, 0x1000000, 0xe4480832 },
            { "mpr-23539.ic3",   0x2800000, 0x1000000, 0x97e3f7f5 },
            { "mpr-23540.ic4",   0x3800000, 0x1000000, 0xb9e92d21 },
            { "mpr-23541.ic5",   0x4800000, 0x1000000, 0x95b8a9c6 },
            { "mpr-23542.ic6",   0x5800000, 0x1000000, 0xdfd490f5 },
            { "mpr-23543.ic7",   0x6800000, 0x1000000, 0x66847ebd },
            { "mpr-23544.ic8",   0x7800000, 0x1000000, 0xd1f5b460 },
            { "mpr-23545.ic9",   0x8800000, 0x1000000, 0x60bd692f },
            { "mpr-23546.ic10",  0x9800000, 0x1000000, 0x85db2248 },
            { "mpr-23547.ic11",  0xa800000, 0x1000000, 0x18b369c7 },
        },
		nullptr,
		&capcom_4btn_inputs,
    },
    // Power Stone
    {
        "pstone",
        NULL,
        "Power Stone",
        0x04800000,
        0x000e69c1,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21597.ic22",0x0000000, 0x0200000 },
            { "epr-21597.ic22", 0x0200000, 0x0200000 }, // reload
            { "mpr-21589.ic1", 0x0800000, 0x0800000 },
            { "mpr-21590.ic2", 0x1000000, 0x0800000 },
            { "mpr-21591.ic3", 0x1800000, 0x0800000 },
            { "mpr-21592.ic4", 0x2000000, 0x0800000 },
            { "mpr-21593.ic5", 0x2800000, 0x0800000 },
            { "mpr-21594.ic6", 0x3000000, 0x0800000 },
            { "mpr-21595.ic7", 0x3800000, 0x0800000 },
            { "mpr-21596.ic8", 0x4000000, 0x0800000 },
        },
		nullptr,
		&pstone_inputs,
    },
    // Power Stone 2
    {
        "pstone2",
        NULL,
        "Power Stone 2",
        0x05000000,
        0x000b8dc0,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23127.ic22", 0x0000000, 0x0400000 },
            { "mpr-23118.ic1", 0x0800000, 0x0800000 },
            { "mpr-23119.ic2", 0x1000000, 0x0800000 },
            { "mpr-23120.ic3", 0x1800000, 0x0800000 },
            { "mpr-23121.ic4", 0x2000000, 0x0800000 },
            { "mpr-23122.ic5", 0x2800000, 0x0800000 },
            { "mpr-23123.ic6", 0x3000000, 0x0800000 },
            { "mpr-23124.ic7", 0x3800000, 0x0800000 },
            { "mpr-23125.ic8", 0x4000000, 0x0800000 },
            { "mpr-23126.ic9", 0x4800000, 0x0800000 },
        },
		nullptr,
		&pstone2_inputs,
    },
    // Power Stone 2 (bootleg)
    {
        "pstone2b",
        "pstone2",
        "Power Stone 2 (bootleg)",
        0x05000000,
        0x000b8dc0,
        NULL,
        M2,
        ROT0,
        {
            { "00.ic1",  0x0000000, 0x0800000 },
            { "01.ic2",  0x0800000, 0x0800000 },
            { "02.ic3",  0x1000000, 0x0800000 },
            { "03.ic4",  0x1800000, 0x0800000 },
            { "04.ic5",  0x2000000, 0x0800000 },
            { "05.ic6",  0x2800000, 0x0800000 },
            { "06.ic7",  0x3000000, 0x0800000 },
            { "07.ic8",  0x3800000, 0x0800000 },
            { "08.ic9",  0x4000000, 0x0800000 },
            { "09.ic10", 0x4800000, 0x0800000 },
        },
		nullptr,
		&pstone2_inputs,
    },
    // Puyo Puyo Da! (Japan)
    {
        "puyoda",
        NULL,
        "Puyo Puyo Da!",
        0x0a800000,
        0x000acd40,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22206.ic22", 0x0000000, 0x400000 },
            { "mpr-22186.ic1",   0x0800000, 0x800000 },
            { "mpr-22187.ic2",   0x1000000, 0x800000 },
            { "mpr-22188.ic3",   0x1800000, 0x800000 },
            { "mpr-22189.ic4",   0x2000000, 0x800000 },
            { "mpr-22190.ic5",   0x2800000, 0x800000 },
            { "mpr-22191.ic6",   0x3000000, 0x800000 },
            { "mpr-22192.ic7",   0x3800000, 0x800000 },
            { "mpr-22193.ic8",   0x4000000, 0x800000 },
            { "mpr-22194.ic9",   0x4800000, 0x800000 },
            { "mpr-22195.ic10",  0x5000000, 0x800000 },
            { "mpr-22196.ic11",  0x5800000, 0x800000 },
            { "mpr-22197.ic12s", 0x6000000, 0x800000 },
            { "mpr-22198.ic13s", 0x6800000, 0x800000 },
            { "mpr-22199.ic14s", 0x7000000, 0x800000 },
            { "mpr-22200.ic15s", 0x7800000, 0x800000 },
            { "mpr-22201.ic16s", 0x8000000, 0x800000 },
            { "mpr-22202.ic17s", 0x8800000, 0x800000 },
            { "mpr-22203.ic18s", 0x9000000, 0x800000 },
            { "mpr-22204.ic19s", 0x9800000, 0x800000 },
            { "mpr-22205.ic20s", 0xa000000, 0x800000 },
        },
		nullptr,
		&puyoda_inputs,
    },
    // Ring Out 4x4 (Rev A)
    {
        "ringout",
        NULL,
        "Ring Out 4x4 (Rev A)",
        0x05800000,
        0x280b1e40,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21779a.ic22", 0x0000000, 0x400000 },
            { "mpr-21761.ic1",  0x0800000, 0x800000 },
            { "mpr-21762.ic2",  0x1000000, 0x800000 },
            { "mpr-21763.ic3",  0x1800000, 0x800000 },
            { "mpr-21764.ic4",  0x2000000, 0x800000 },
            { "mpr-21765.ic5",  0x2800000, 0x800000 },
            { "mpr-21766.ic6",  0x3000000, 0x800000 },
            { "mpr-21767.ic7",  0x3800000, 0x800000 },
            { "mpr-21768.ic8",  0x4000000, 0x800000 },
            { "mpr-21769.ic9",  0x4800000, 0x800000 },
            { "mpr-21770.ic10", 0x5000000, 0x800000 },
        },
        NULL,
		&ringout_inputs,
    },
    // Ring Out 4x4
    {
        "ringouto",
        "ringout",
        "Ring Out 4x4",
        0x05800000,
        0x280b1e40,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21779.ic22", 0x0000000, 0x400000 },
            { "mpr-21761.ic1",  0x0800000, 0x800000 },
            { "mpr-21762.ic2",  0x1000000, 0x800000 },
            { "mpr-21763.ic3",  0x1800000, 0x800000 },
            { "mpr-21764.ic4",  0x2000000, 0x800000 },
            { "mpr-21765.ic5",  0x2800000, 0x800000 },
            { "mpr-21766.ic6",  0x3000000, 0x800000 },
            { "mpr-21767.ic7",  0x3800000, 0x800000 },
            { "mpr-21768.ic8",  0x4000000, 0x800000 },
            { "mpr-21769.ic9",  0x4800000, 0x800000 },
            { "mpr-21770.ic10", 0x5000000, 0x800000 },
        },
        NULL,
		&ringout_inputs,
    },
    // Samba De Amigo (Rev B)
    {
        "samba",
        NULL,
        "Samba De Amigo (Rev B)",
        0x08800000,
        0x280a8b5d,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22966b.ic22",0x0000000, 0x0400000 }, // was also found in cartridge with Rev.A case label
            { "mpr-22950.ic1",  0x0800000, 0x0800000 },
            { "mpr-22951.ic2",  0x1000000, 0x0800000 },
            { "mpr-22952.ic3",  0x1800000, 0x0800000 },
            { "mpr-22953.ic4",  0x2000000, 0x0800000 },
            { "mpr-22954.ic5",  0x2800000, 0x0800000 },
            { "mpr-22955.ic6",  0x3000000, 0x0800000 },
            { "mpr-22956.ic7",  0x3800000, 0x0800000 },
            { "mpr-22957.ic8",  0x4000000, 0x0800000 },
            { "mpr-22958.ic9",  0x4800000, 0x0800000 },
            { "mpr-22959.ic10", 0x5000000, 0x0800000 },
            { "mpr-22960.ic11", 0x5800000, 0x0800000 },
            { "mpr-22961.ic12s",0x6000000, 0x0800000 },
            { "mpr-22962.ic13s",0x6800000, 0x0800000 },
            { "mpr-22963.ic14s",0x7000000, 0x0800000 },
            { "mpr-22964.ic15s",0x7800000, 0x0800000 },
            { "mpr-22965.ic16s",0x8000000, 0x0800000 },
        },
		nullptr,
		&samba_inputs,
    },
    // Samba De Amigo (Rev A)
    {
        "sambaa",
        "samba",
        "Samba De Amigo (Rev A)",
        0x08800000,
        0x280a8b5d,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22966a.ic22", 0x0000000, 0x0400000 },
            { "mpr-22950.ic1",   0x0800000, 0x0800000 },
            { "mpr-22951.ic2",   0x1000000, 0x0800000 },
            { "mpr-22952.ic3",   0x1800000, 0x0800000 },
            { "mpr-22953.ic4",   0x2000000, 0x0800000 },
            { "mpr-22954.ic5",   0x2800000, 0x0800000 },
            { "mpr-22955.ic6",   0x3000000, 0x0800000 },
            { "mpr-22956.ic7",   0x3800000, 0x0800000 },
            { "mpr-22957.ic8",   0x4000000, 0x0800000 },
            { "mpr-22958.ic9",   0x4800000, 0x0800000 },
            { "mpr-22959.ic10",  0x5000000, 0x0800000 },
            { "mpr-22960.ic11",  0x5800000, 0x0800000 },
            { "mpr-22961.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22962.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22963.ic14s", 0x7000000, 0x0800000 },
            { "mpr-22964.ic15s", 0x7800000, 0x0800000 },
            { "mpr-22965.ic16s", 0x8000000, 0x0800000 },
        },
		nullptr,
		&samba_inputs,
    },
    // Samba De Amigo (USA, prototype)
    {
        "sambap",
        "samba",
        "Samba De Amigo (USA, prototype)",
        0x08800000,
        0x280a8b5d,
        NULL,
        M2,
        ROT0,
        {
            { "sambaproto.ic22", 0x000000,   0x0400000  },
            { "rom1.ic1s",       0x00800000, 0x00800000 },
            { "rom2.ic2s",       0x01000000, 0x00800000 },
            { "rom3.ic3s",       0x01800000, 0x00800000 },
            { "rom4.ic4s",       0x02000000, 0x00800000 },
            { "rom5.ic5s",       0x02800000, 0x00800000 },
            { "rom6.ic6s",       0x03000000, 0x00800000 },
            { "rom7.ic7s",       0x03800000, 0x00800000 },
            { "rom8.ic8s",       0x04000000, 0x00800000 },
            { "rom9.ic9s",       0x04800000, 0x00800000 },
            { "rom10.ic10s",     0x05000000, 0x00800000 },
            { "rom11.ic11s",     0x05800000, 0x00800000 },
            { "rom12.ic12s",     0x06000000, 0x00800000 },
            { "rom13.ic13s",     0x06800000, 0x00800000 },
            { "rom14.ic14s",     0x07000000, 0x00800000 },
        },
		nullptr,
		&samba_inputs,
    },
    //Samba de Amigo ver. 2000 (Japan)
    {
        "samba2k",
        NULL,
        "Samba de Amigo ver. 2000 (Japan)",
        0x0b800000,
        0x281702cf,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23600.ic22", 0x00000000, 0x0400000 },
            { "mpr-23589.ic1",  0x00800000, 0x1000000 },
            { "mpr-23590.ic2",  0x01800000, 0x1000000 },
            { "mpr-23591.ic3",  0x02800000, 0x1000000 },
            { "mpr-23592.ic4",  0x03800000, 0x1000000 },
            { "mpr-23593.ic5",  0x04800000, 0x1000000 },
            { "mpr-23594.ic6",  0x05800000, 0x1000000 },
            { "mpr-23595.ic7",  0x06800000, 0x1000000 },
            { "mpr-23596.ic8",  0x07800000, 0x1000000 },
            { "mpr-23597.ic9",  0x08800000, 0x1000000 },
            { "mpr-23598.ic10", 0x09800000, 0x1000000 },
            { "mpr-23599.ic11", 0x0a800000, 0x1000000 },
        },
		nullptr,
		&samba_inputs,
    },
    // Sega Tetris
    {
        "sgtetris",
        NULL,
        "Sega Tetris",
        0x03800000,
        0x2808ae51,
        NULL,
        M2,
        ROT0,
        {
            {  "epr-22909.ic22", 0x0000000, 0x200000 },
            {  "epr-22909.ic22", 0x0200000, 0x200000 }, // reload
            {  "mpr-22910.ic1", 0x0800000, 0x800000 },
            {  "mpr-22911.ic2", 0x1000000, 0x800000 },
            {  "mpr-22912.ic3", 0x1800000, 0x800000 },
            {  "mpr-22913.ic4", 0x2000000, 0x800000 },
            {  "mpr-22914.ic5", 0x2800000, 0x800000 },
            {  "mpr-22915.ic6", 0x3000000, 0x800000 },
        },
		nullptr,
		&sgtetris_inputs,
    },
    // Dengen Tenshi Taisen Janshi Shangri-la (JPN, USA, EXP, KOR, AUS)
    {
        "shangril",
        NULL,
        "Dengen Tenshi Taisen Janshi Shangri-la",
        0x06800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22060.ic22",  0x0000000, 0x0400000 },
            { "mpr-22061.ic1",   0x0800000, 0x0800000 },
            { "mpr-22062.ic2",   0x1000000, 0x0800000 },
            { "mpr-22063.ic3",   0x1800000, 0x0800000 },
            { "mpr-22064.ic4",   0x2000000, 0x0800000 },
            { "mpr-22065.ic5",   0x2800000, 0x0800000 },
            { "mpr-22066.ic6",   0x3000000, 0x0800000 },
            { "mpr-22067.ic7",   0x3800000, 0x0800000 },
            { "mpr-22068.ic8",   0x4000000, 0x0800000 },
            { "mpr-22069.ic9",   0x4800000, 0x0800000 },
            { "mpr-22070.ic10",  0x5000000, 0x0800000 },
            { "mpr-22071.ic11",  0x5800000, 0x0800000 },
            { "mpr-22072.ic12s", 0x6000000, 0x0800000 },
        }
    },
    // Star Horse (satellite)
    {
        "shorse",
        NULL,
        "Star Horse (satellite)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT270,
        {
            { "epr-23627.ic22", 0x0000000, 0x0400000 },
            { "mpr-23275.ic1",  0x0800000, 0x1000000 },
            { "mpr-23276.ic2",  0x1800000, 0x1000000 },
            { "mpr-23277.ic3",  0x2800000, 0x1000000 },
            { "mpr-23278.ic4",  0x3800000, 0x1000000 },
            { "mpr-23279.ic5",  0x4800000, 0x1000000 },
            { "mpr-23280.ic6",  0x5800000, 0x1000000 },
            { "mpr-23281.ic7",  0x6800000, 0x0800000 },

            //ROM_REGION(0x84, "some_eeprom", 0)
            //ROM_LOAD( "sflash.ic46",   0x000000, 0x000084, CRC(4929e940) SHA1(f8c4277ca0ae5e36b2eed033cc731b8fc4fccafc) )
        }
    },
    // Star Horse (live and backup)
    {
        "shorsel",
        "shorse",
        "Star Horse (live and backup)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-23626.ic22", 0x0000000, 0x200000 },
            { "epr-23626.ic22", 0x0200000, 0x200000 }, //reload
            { "rom1.ic1s",      0x0800000, 0x800000 },
            { "rom2.ic2s",      0x1000000, 0x800000 },
            { "rom3.ic3s",      0x1800000, 0x800000 },
            { "rom4.ic4s",      0x2000000, 0x800000 },
            { "rom5.ic5s",      0x2800000, 0x800000 },
            { "rom6.ic6s",      0x3000000, 0x800000 },
            { "rom7.ic7s",      0x3800000, 0x800000 },
            { "rom8.ic8s",      0x4000000, 0x800000 },
            { "rom9.ic9s",      0x4800000, 0x800000 },
            { "rom10.ic10s",    0x5000000, 0x800000 },
            { "rom11.ic11s",    0x5800000, 0x800000 },
            { "rom12.ic12s",    0x6000000, 0x800000 },
            { "rom13.ic13s",    0x6800000, 0x800000 },
            { "rom14.ic14s",    0x7000000, 0x800000 },
            { "rom15.ic15s",    0x7800000, 0x800000 },
            { "rom16.ic16s",    0x8000000, 0x800000 },
            { "rom17.ic17s",    0x8800000, 0x800000 },
            // .18s chip is not present but is tested for an FF fill (pull-up resistors on the PCB's data bus presumably accomplish this)

            //ROM_REGION(0x84, "some_eeprom", 0)
            //ROM_LOAD( "sflash.ic37",   0x000000, 0x000084, CRC(1557297e) SHA1(41e8a7a8eaf5076b124d378afdf97e328d100e72) )
        }
    },
    // Star Horse (main screens)
    {
        "shorsem",
        "shorse",
        "Star Horse (main screens)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-23625.ic22", 0x0000000, 0x0400000 },
            { "mpr-23231.ic1",  0x0800000, 0x1000000 },
            { "mpr-23232.ic2",  0x1800000, 0x1000000 },
            { "mpr-23233.ic3",  0x2800000, 0x1000000 },
            { "mpr-23234.ic4",  0x3800000, 0x1000000 },

            //ROM_REGION(0x84, "some_eeprom", 0)
            //ROM_LOAD( "sflash.ic46",   0x000000, 0x000084, CRC(951684e4) SHA1(0beaf5827064252293223b946c04b8698e7207bb) )
        }
    },
    // Star Horse Progress (satellite, Rev A)
    {
        "shorsep",
        NULL,
        "Star Horse Progress (satellite, Rev A)",
        0x7800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT270,
        {
            { "epr-24122a.ic22", 0x0000000, 0x0400000 },
            { "mpr-24123.ic1",   0x0800000, 0x1000000 },
            { "mpr-24124.ic2",   0x1800000, 0x1000000 },
            { "mpr-24125.ic3",   0x2800000, 0x1000000 },
            { "mpr-24126.ic4",   0x3800000, 0x1000000 },
            { "mpr-24127.ic5",   0x4800000, 0x1000000 },
            { "mpr-24128.ic6",   0x5800000, 0x1000000 },
            { "mpr-24129.ic7",   0x6800000, 0x1000000 },
        }
    },
    // Star Horse Progress (backup data)
    {
        "shorsepb",
        "shorsep",
        "Star Horse Progress (backup data)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "rom1.ic1s",   0x00800000, 0x00800000 },
            { "rom2.ic2s",   0x01000000, 0x00800000 },

            //ROM_REGION(0x84, "some_eeprom", 0)
            //ROM_LOAD( "sflash.ic37",   0x000000, 0x000084, CRC(fe8f8f5c) SHA1(839461ab736e0228dec7e2512e1692d6ecc4e664) )
        }
    },
    // Star Horse Progress (live, Rev A)
    {
        "shorsepl",
        "shorsep",
        "Star Horse Progress (live, Rev A)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-24107a.ic22", 0x00000000, 0x00400000 },
            { "mpr-24108.ic1",   0x00800000, 0x01000000 },
            { "mpr-24109.ic2",   0x01800000, 0x01000000 },
            { "mpr-24110.ic3",   0x02800000, 0x01000000 },
            { "mpr-24111.ic4",   0x03800000, 0x01000000 },
            { "mpr-24112.ic5",   0x04800000, 0x01000000 },
            { "mpr-24113.ic6",   0x05800000, 0x01000000 },
            { "mpr-24114.ic7",   0x06800000, 0x01000000 },
            { "mpr-24115.ic8",   0x07800000, 0x01000000 },
            { "mpr-24116.ic9",   0x08800000, 0x01000000 },
            { "mpr-24117.ic10",  0x09800000, 0x01000000 },
            { "mpr-24118.ic11",  0x0a800000, 0x01000000 },
        }
    },
    // Star Horse Progress (main screens)
    {
        "shorsepm",
        "shorsep",
        "Star Horse Progress (main screens, Rev B)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-24087b.ic22", 0x00000000, 0x00400000 },
            { "mpr-24088.ic1",   0x00800000, 0x01000000 },
            { "mpr-24089.ic2",   0x01800000, 0x01000000 },
            { "mpr-24090.ic3",   0x02800000, 0x01000000 },
            { "mpr-24091.ic4",   0x03800000, 0x01000000 },
            { "mpr-24092.ic5",   0x04800000, 0x01000000 },
            { "mpr-24093.ic6",   0x05800000, 0x01000000 },
        }
    },
    // Star Horse Progress (sound & backup)
    {
        "shorseps",
        "shorsep",
        "Star Horse Progress (sound & backup, Rev A)",
        0x7000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-24097a.ic22", 0x00000000, 0x00400000 },
            { "mpr-24098.ic1",   0x00800000, 0x01000000 },
            { "mpr-24099.ic2",   0x01800000, 0x01000000 },
            { "mpr-24100.ic3",   0x02800000, 0x01000000 },
            { "mpr-24101.ic4",   0x03800000, 0x01000000 },
            { "mpr-24102.ic5",   0x04800000, 0x01000000 },
            { "mpr-24103.ic6",   0x05800000, 0x01000000 },
        }
    },
    // Star Horse 2001 (satellite, Rev B)
    {
        "shors2k1",
        NULL,
        "Star Horse 2001 (satellite, Rev B)",
        0x7800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT270,
        {
            { "epr-23739b.ic22", 0x00000000, 0x00400000 },
            { "mpr-23740.ic1",   0x00800000, 0x01000000 },
            { "mpr-23741.ic2",   0x01800000, 0x01000000 },
            { "mpr-23742.ic3",   0x02800000, 0x01000000 },
            { "mpr-23743.ic4",   0x03800000, 0x01000000 },
            { "mpr-23744.ic5",   0x04800000, 0x01000000 },
            { "mpr-23745.ic6",   0x05800000, 0x01000000 },
            { "mpr-23746.ic7",   0x06800000, 0x01000000 },
        }
    },
    // Star Horse 2002 (main screens)
    {
        "shors2k2m",
        nullptr,
        "Star Horse 2002 (main screens)",
		0x6800000,
        0xffffffff, // not populated
		nullptr,
        M2,
		ROT0,
		{
			{ "epr-23851.ic22",  0x00000000, 0x00400000, 0x23dbad62 },
			{ "mpr-23852.ic1",   0x00800000, 0x01000000, 0xb289b968 },
    		{ "mpr-23853.ic2",   0x01800000, 0x01000000, 0xef43b551 },
    		{ "mpr-23854.ic3",   0x02800000, 0x01000000, 0x1bb65979 },
    		{ "mpr-23855.ic4",   0x03800000, 0x01000000, 0x04b725d8 },
    		{ "mpr-23856.ic5",   0x04800000, 0x01000000, 0x8ef1691e },
    		{ "mpr-23857.ic6",   0x05800000, 0x01000000, 0xb2900844 },
        },
    },
    // Star Horse 2002 (sound and backup, Rev A)
    {
        "shors2k2s",
        nullptr,
        "Star Horse 2002 (sound and backup)",
		0x5800000,
        0xffffffff, // not populated
		nullptr,
        M2,
		ROT0,
		{
			{ "epr-23866a.ic22", 0x00000000, 0x00400000, 0xabf21b86 },
			{ "mpr-23888.ic1",   0x00800000, 0x01000000, 0xc55b45be },
			{ "mpr-23889.ic2",   0x01800000, 0x01000000, 0xe3f0f02e },
			{ "mpr-23890.ic3",   0x02800000, 0x01000000, 0x187eca4e },
			{ "mpr-23891.ic4",   0x03800000, 0x01000000, 0x24783524 },
			{ "mpr-23892.ic5",   0x04800000, 0x01000000, 0xc8785077 },
        },
    },
    // Star Horse 2002 (live)
    {
        "shors2k2l",
        nullptr,
        "Star Horse 2002 (live)",
		0x9800000,
        0xffffffff, // not populated
		nullptr,
        M2,
		ROT0,
		{
			{ "epr-23867.ic22",  0x00000000, 0x00400000, 0x25fbbf6e },
			{ "mpr-23894.ic1",   0x00800000, 0x01000000, 0xfb87d357 },
			{ "mpr-23895.ic2",   0x01800000, 0x01000000, 0x519743f5 },
			{ "mpr-23896.ic3",   0x02800000, 0x01000000, 0xb0c597f5 },
			{ "mpr-23897.ic4",   0x03800000, 0x01000000, 0x8e7a4d58 },
			{ "mpr-23898.ic5",   0x04800000, 0x01000000, 0xc9bb098b },
			{ "mpr-23899.ic6",   0x05800000, 0x01000000, 0x99a3f8c4 },
			{ "mpr-23900.ic7",   0x06800000, 0x01000000, 0xe4b3a767 },
			{ "mpr-23901.ic8",   0x07800000, 0x01000000, 0xd05001ce },
			{ "mpr-23902.ic9",   0x08800000, 0x01000000, 0x48eb5457 },
        },
    },
    // Star Horse 2002 (sound, Export/Taiwan)
    {
        "shors2k2",
        nullptr,
        "Star Horse 2002 (sound, Export/Taiwan)",
		0x4000000,
        0x403431d2,
		nullptr,
        M1,
		ROT0,
		{
			{ "epr-23964.ic11",  0x0000000, 0x0400000, 0x26c53dac },
	        { "opr-23965.ic17s", 0x1000000, 0x0800000, 0x28fceb93, InterleavedWord },
	        { "opr-23966.ic18",  0x1000002, 0x0800000, 0xd3bb88b4, InterleavedWord },
	        { "opr-23967.ic19s", 0x2000000, 0x0800000, 0x7dae177e, InterleavedWord },
	        { "opr-23968.ic20",  0x2000002, 0x0800000, 0x20b3b237, InterleavedWord },
	        { "opr-23969.ic21s", 0x3000000, 0x0800000, 0x1d8644b6, InterleavedWord },
	        { "opr-23970.ic22",  0x3000002, 0x0800000, 0xdd0201a8, InterleavedWord },
			{ "copy",            0x0400000, 0x0c00000, 0x00000000, Copy, 0x1000000 },
        },
    },
    // Super Major League '99
    {
        "smlg99",
        NULL,
        "World Series 99 / Super Major League 99",
        0x0b000000,
        0x28048a01,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22059.ic22",  0x0000000, 0x200000 },
            { "epr-22059.ic22",  0x0200000, 0x200000 }, // reload
            { "mpr-22038.ic1",   0x0800000, 0x800000 },
            { "mpr-22039.ic2",   0x1000000, 0x800000 },
            { "mpr-22040.ic3",   0x1800000, 0x800000 },
            { "mpr-22041.ic4",   0x2000000, 0x800000 },
            { "mpr-22042.ic5",   0x2800000, 0x800000 },
            { "mpr-22043.ic6",   0x3000000, 0x800000 },
            { "mpr-22044.ic7",   0x3800000, 0x800000 },
            { "mpr-22045.ic8",   0x4000000, 0x800000 },
            { "mpr-22046.ic9",   0x4800000, 0x800000 },
            { "mpr-22047.ic10",  0x5000000, 0x800000 },
            { "mpr-22048.ic11",  0x5800000, 0x800000 },
            { "mpr-22049.ic12s", 0x6000000, 0x800000 },
            { "mpr-22050.ic13s", 0x6800000, 0x800000 },
            { "mpr-22051.ic14s", 0x7000000, 0x800000 },
            { "mpr-22052.ic15s", 0x7800000, 0x800000 },
            { "mpr-22053.ic16s", 0x8000000, 0x800000 },
            { "mpr-22054.ic17s", 0x8800000, 0x800000 },
            { "mpr-22055.ic18s", 0x9000000, 0x800000 },
            { "mpr-22056.ic19s", 0x9800000, 0x800000 },
            { "mpr-22057.ic20s", 0xa000000, 0x800000 },
            { "mpr-22058.ic21s", 0xa800000, 0x800000 },
        },
		NULL,
		&wsbb_inputs,
    },
    // Slashout
    {
        "slasho",
        NULL,
        "Slashout",
        0x09000000,
        0x281a66ca,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23341.ic22", 0x0000000, 0x0400000 },
            { "mpr-23324.ic1",  0x0800000, 0x0800000 },
            { "mpr-23325.ic2",  0x1000000, 0x0800000 },
            { "mpr-23326.ic3",  0x1800000, 0x0800000 },
            { "mpr-23327.ic4",  0x2000000, 0x0800000 },
            { "mpr-23328.ic5",  0x2800000, 0x0800000 },
            { "mpr-23329.ic6",  0x3000000, 0x0800000 },
            { "mpr-23330.ic7",  0x3800000, 0x0800000 },
            { "mpr-23331.ic8",  0x4000000, 0x0800000 },
            { "mpr-23332.ic9",  0x4800000, 0x0800000 },
            { "mpr-23333.ic10", 0x5000000, 0x0800000 },
            { "mpr-23334.ic11", 0x5800000, 0x0800000 },
            { "mpr-23335.ic12s",0x6000000, 0x0800000 },
            { "mpr-23336.ic13s",0x6800000, 0x0800000 },
            { "mpr-23337.ic14s",0x7000000, 0x0800000 },
            { "mpr-23338.ic15s",0x7800000, 0x0800000 },
            { "mpr-23339.ic16s",0x8000000, 0x0800000 },
            { "mpr-23340.ic17s",0x8800000, 0x0800000 },
        },
		NULL,
		&slashout_inputs,
		slashout_eeprom_dump
    },
    // Sega Marine Fishing
    {
        "smarinef",
        NULL,
        "Sega Marine Fishing",
        0x06800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-22221.ic22",  0x0000000, 0x0400000 },
            { "mpr-22208.ic1",   0x0800000, 0x0800000 },
            { "mpr-22209.ic2",   0x1000000, 0x0800000 },
            // IC3 empty
            // IC4 empty
            { "mpr-22212.ic5",   0x2800000, 0x0800000 },
            { "mpr-22213.ic6",   0x3000000, 0x0800000 },
            { "mpr-22214.ic7",   0x3800000, 0x0800000 },
            { "mpr-22215.ic8",   0x4000000, 0x0800000 },
            { "mpr-22216.ic9",   0x4800000, 0x0800000 },
            { "mpr-22217.ic10",  0x5000000, 0x0800000 },
            { "mpr-22218.ic11",  0x5800000, 0x0800000 },
            { "mpr-22219.ic12s", 0x6000000, 0x0800000 },
        },
		NULL,
		&marine_fishing_inputs,
    },
    // Spawn: In the Demon's Hand (JPN, USA, EUR, ASI, AUS) (Rev B)
    {
        "spawn",
        NULL,
        "Spawn: In the Demon's Hand",
        0x05800000,
        0x00078d01,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22977b.ic22", 0x0000000, 0x0400000 },
            { "mpr-22967.ic1",   0x0800000, 0x0800000 },
            { "mpr-22968.ic2",   0x1000000, 0x0800000 },
            { "mpr-22969.ic3",   0x1800000, 0x0800000 },
            { "mpr-22970.ic4",   0x2000000, 0x0800000 },
            { "mpr-22971.ic5",   0x2800000, 0x0800000 },
            { "mpr-22972.ic6",   0x3000000, 0x0800000 },
            { "mpr-22973.ic7",   0x3800000, 0x0800000 },
            { "mpr-22974.ic8",   0x4000000, 0x0800000 },
            { "mpr-22975.ic9",   0x4800000, 0x0800000 },
            { "mpr-22976.ic10",  0x5000000, 0x0800000 },
        },
        NULL,
		&shot1234_inputs,
        spawn_eeprom_dump
    },
    // Sega Strike Fighter (Rev A)
    {
        "sstrkfgt",
        NULL,
        "Sega Strike Fighter",
        0x0b000000,
        0x28132303,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23323a.ic22", 0x0000000, 0x400000 },
            { "mpr-23302.ic1",   0x0800000, 0x800000 },
            { "mpr-23303.ic2",   0x1000000, 0x800000 },
            { "mpr-23304.ic3",   0x1800000, 0x800000 },
            { "mpr-23305.ic4",   0x2000000, 0x800000 },
            { "mpr-23306.ic5",   0x2800000, 0x800000 },
            { "mpr-23307.ic6",   0x3000000, 0x800000 },
            { "mpr-23308.ic7",   0x3800000, 0x800000 },
            { "mpr-23309.ic8",   0x4000000, 0x800000 },
            { "mpr-23310.ic9",   0x4800000, 0x800000 },
            { "mpr-23311.ic10",  0x5000000, 0x800000 },
            { "mpr-23312.ic11",  0x5800000, 0x800000 },
            { "mpr-23313.ic12s", 0x6000000, 0x800000 },
            { "mpr-23314.ic13s", 0x6800000, 0x800000 },
            { "mpr-23315.ic14s", 0x7000000, 0x800000 },
            { "mpr-23316.ic15s", 0x7800000, 0x800000 },
            { "mpr-23317.ic16s", 0x8000000, 0x800000 },
            { "mpr-23318.ic17s", 0x8800000, 0x800000 },
            { "mpr-23319.ic18s", 0x9000000, 0x800000 },
            { "mpr-23320.ic19s", 0x9800000, 0x800000 },
            { "mpr-23321.ic20s", 0xa000000, 0x800000 },
        },
		nullptr,
		&sstrkfgt_inputs,
		nullptr,
		2,
    },
    // Sega Strike Fighter (Rev A, no training mode)
    {
        "sstrkfgta",
        "sstrkfgt",
        "Sega Strike Fighter (no training mode)",
        0x0b000000,
        0x28132303,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23786a.ic22", 0x0000000, 0x400000 },
            { "mpr-23302.ic1",   0x0800000, 0x800000 },
            { "mpr-23303.ic2",   0x1000000, 0x800000 },
            { "mpr-23304.ic3",   0x1800000, 0x800000 },
            { "mpr-23305.ic4",   0x2000000, 0x800000 },
            { "mpr-23306.ic5",   0x2800000, 0x800000 },
            { "mpr-23307.ic6",   0x3000000, 0x800000 },
            { "mpr-23308.ic7",   0x3800000, 0x800000 },
            { "mpr-23309.ic8",   0x4000000, 0x800000 },
            { "mpr-23310.ic9",   0x4800000, 0x800000 },
            { "mpr-23311.ic10",  0x5000000, 0x800000 },
            { "mpr-23312.ic11",  0x5800000, 0x800000 },
            { "mpr-23313.ic12s", 0x6000000, 0x800000 },
            { "mpr-23314.ic13s", 0x6800000, 0x800000 },
            { "mpr-23315.ic14s", 0x7000000, 0x800000 },
            { "mpr-23316.ic15s", 0x7800000, 0x800000 },
            { "mpr-23317.ic16s", 0x8000000, 0x800000 },
            { "mpr-23318.ic17s", 0x8800000, 0x800000 },
            { "mpr-23319.ic18s", 0x9000000, 0x800000 },
            { "mpr-23320.ic19s", 0x9800000, 0x800000 },
            { "mpr-23321.ic20s", 0xa000000, 0x800000 },
        },
		nullptr,
		&sstrkfgt_inputs,
		nullptr,
		2,
    },
    // Idol Janshi Suchie-Pai 3 (JPN)
    {
        "suchie3",
        NULL,
        "Idol Janshi Suchie-Pai 3",
        0x07800000,
        0x000368e1,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21979.ic22", 0x0000000, 0x0200000 },
            { "epr-21979.ic22", 0x0200000, 0x0200000 }, // reload
            { "mpr-21980.ic1",  0x0800000, 0x0800000 },
            { "mpr-21981.ic2",  0x1000000, 0x0800000 },
            { "mpr-21982.ic3",  0x1800000, 0x0800000 },
            { "mpr-21983.ic4",  0x2000000, 0x0800000 },
            { "mpr-21984.ic5",  0x2800000, 0x0800000 },
            { "mpr-21985.ic6",  0x3000000, 0x0800000 },
            { "mpr-21986.ic7",  0x3800000, 0x0800000 },
            { "mpr-21987.ic8",  0x4000000, 0x0800000 },
            { "mpr-21988.ic9",  0x4800000, 0x0800000 },
            { "mpr-21989.ic10", 0x5000000, 0x0800000 },
            { "mpr-21990.ic11", 0x5800000, 0x0800000 },
            { "mpr-21991.ic12s",0x6000000, 0x0800000 },
            { "mpr-21992.ic13s",0x6800000, 0x0800000 },
            { "mpr-21993.ic14s",0x7000000, 0x0400000 },
        }
    },
    // Touch de Uno! / Unou Nouryoku Check Machine (Japan)
    {
        "tduno",
        NULL,
        "Touch de Uno! / Unou Nouryoku Check Machine",
        0x04000000,
        0x28028ea5,
        NULL,
        M2,
        ROT0,
        {
            //ROM_REGION16_BE( 0x80, "main_eeprom", 0 )
            //ROM_LOAD16_WORD("main_eeprom.bin", 0x0000, 0x0080, CRC(fea29cbb) SHA1(4099f1747aafa07db34f6e072cd9bfaa83bae10e) )

            { "epr-22073.ic22", 0x0000000, 0x200000 },
            { "epr-22073.ic22", 0x0200000, 0x200000 }, // reload
            { "mpr-22074.ic1",  0x0800000, 0x800000 },
            { "mpr-22075.ic2",  0x1000000, 0x800000 },
            { "mpr-22076.ic3",  0x1800000, 0x800000 },
            { "mpr-22077.ic4",  0x2000000, 0x400000 },

            // on-cart X76F100 eeprom contents
			{ "x76f100.ic37", 0x000000, 0x000084, 0xc79251d5, Eeprom },
        },
		nullptr,
		&service_btns_inputs,
		tduno_eeprom_dump,
    },
	// Tokyo Bus (Rev A)
	{
		"tokyobus",
		NULL,
		"Tokyo Bus Guide",
		0x09800000,
		0x281e1242,
		NULL,
		M2,
		ROT0,
		{
			{ "epr-23468a.ic22", 0x0000000, 0x0400000 },
			{ "rom1.ic1s",       0x0800000, 0x0800000 },
			{ "rom2.ic2s",       0x1000000, 0x0800000 },
			{ "rom3.ic3s",       0x1800000, 0x0800000 },
			{ "rom4.ic4s",       0x2000000, 0x0800000 },
			{ "rom5.ic5s",       0x2800000, 0x0800000 },
			{ "rom6.ic6s",       0x3000000, 0x0800000 },
			{ "rom7.ic7s",       0x3800000, 0x0800000 },
			{ "rom8.ic8s",       0x4000000, 0x0800000 },
			{ "rom9.ic9s",       0x4800000, 0x0800000 },
			{ "rom10.ic10s",     0x5000000, 0x0800000 },
			{ "rom11.ic11s",     0x5800000, 0x0800000 },
			{ "rom12.ic12s",     0x6000000, 0x0800000 },
			{ "rom13.ic13s",     0x6800000, 0x0800000 },
			{ "rom14.ic14s",     0x7000000, 0x0800000 },
			{ "rom15.ic15s",     0x7800000, 0x0800000 },
			{ "rom16.ic16s",     0x8000000, 0x0800000 },
			{ "rom17.ic17s",     0x8800000, 0x0800000 },
			{ "rom18.ic18s",     0x9000000, 0x0800000 },
		},
		NULL,
		&tokyobus_inputs,
	},
    // The Typing of the Dead (Rev A)
    {
        "totd",
        NULL,
        "The Typing of the Dead (Rev A)",
        0x0b000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-23021a.ic22", 0x0000000, 0x0400000 },

            { "mpr-23001.ic1",   0x0800000, 0x0800000 },
            { "mpr-23002.ic2",   0x1000000, 0x0800000 },
            { "mpr-23003.ic3",   0x1800000, 0x0800000 },
            { "mpr-23004.ic4",   0x2000000, 0x0800000 },
            { "mpr-23005.ic5",   0x2800000, 0x0800000 },
            // IC6 not populated
            { "mpr-23007.ic7",   0x3800000, 0x0800000 },
            { "mpr-23008.ic8",   0x4000000, 0x0800000 },
            { "mpr-23009.ic9",   0x4800000, 0x0800000 },
            { "mpr-23010.ic10",  0x5000000, 0x0800000 },
            { "mpr-23011.ic11",  0x5800000, 0x0800000 },
            { "mpr-23012.ic12s", 0x6000000, 0x0800000 },
            // IC13S not populated
            { "mpr-23014.ic14s", 0x7000000, 0x0800000 },
            { "mpr-23015.ic15s", 0x7800000, 0x0800000 },
            { "mpr-23016.ic16s", 0x8000000, 0x0800000 },
            { "mpr-23017.ic17s", 0x8800000, 0x0800000 },
            { "mpr-23018.ic18s", 0x9000000, 0x0800000 },
            { "mpr-23019.ic19s", 0x9800000, 0x0800000 },
            { "mpr-23020.ic20s", 0xa000000, 0x0800000 },
            // IC21s not populated
        },
		nullptr,
		nullptr,
		totd_eeprom_dump,
    },
    // The Typing of the Dead
    {
        "totdo",
        "totd",
        "The Typing of the Dead",
        0x0b000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-23021.ic22",  0x0000000, 0x0400000 },
            { "mpr-23001.ic1",   0x0800000, 0x0800000 },
            { "mpr-23002.ic2",   0x1000000, 0x0800000 },
            { "mpr-23003.ic3",   0x1800000, 0x0800000 },
            { "mpr-23004.ic4",   0x2000000, 0x0800000 },
            { "mpr-23005.ic5",   0x2800000, 0x0800000 },
            // IC6 not populated
            { "mpr-23007.ic7",   0x3800000, 0x0800000 },
            { "mpr-23008.ic8",   0x4000000, 0x0800000 },
            { "mpr-23009.ic9",   0x4800000, 0x0800000 },
            { "mpr-23010.ic10",  0x5000000, 0x0800000 },
            { "mpr-23011.ic11",  0x5800000, 0x0800000 },
            { "mpr-23012.ic12s", 0x6000000, 0x0800000 },
            // IC13S not populated
            { "mpr-23014.ic14s", 0x7000000, 0x0800000 },
            { "mpr-23015.ic15s", 0x7800000, 0x0800000 },
            { "mpr-23016.ic16s", 0x8000000, 0x0800000 },
            { "mpr-23017.ic17s", 0x8800000, 0x0800000 },
            { "mpr-23018.ic18s", 0x9000000, 0x0800000 },
            { "mpr-23019.ic19s", 0x9800000, 0x0800000 },
            { "mpr-23020.ic20s", 0xa000000, 0x0800000 },
            // IC21S not populated
        },
		nullptr,
		nullptr,
		totd_eeprom_dump,
    },
    // Shin Nihon Pro Wrestling Toukon Retsuden 4 Arcade Edition (TRF1 Ver. A)
    {
        "toukon4",
        NULL,
        "Shin Nihon Pro Wrestling Toukon Retsuden 4 Arcade Edition (Japan, TRF1 Ver.A)",
        0x10000000,
        0x052e2901,
        NULL,
        M2,
        ROT0,
        {
            { "trf1vera.2f", 0x0000000, 0x0800000 },
            { "trf1vera.2d", 0x0800000, 0x0800000 },
            { "trf1ma1.4n",  0x1000000, 0x1000000 },
            { "trf1ma2.4m",  0x2000000, 0x1000000 },
            { "trf1ma3.4l",  0x3000000, 0x1000000 },
            { "trf1ma4.4k",  0x4000000, 0x1000000 },
            { "trf1ma5.4j",  0x5000000, 0x1000000 },
            { "trf1ma6.4h",  0x6000000, 0x1000000 },
            { "trf1ma7.4f",  0x7000000, 0x1000000 },
            { "trf1ma8.4e",  0x8000000, 0x1000000 },
            { "trf1ma9.4d",  0x9000000, 0x1000000 },
            { "trf1ma10.4c", 0xa000000, 0x1000000 },
            { "trf1ma11.4b", 0xb000000, 0x1000000 },
            { "trf1ma12.6p", 0xc000000, 0x1000000 },
            { "trf1ma13.6n", 0xd000000, 0x1000000 },
            { "trf1ma14.6m", 0xe000000, 0x1000000 },
            { "trf1ma15.6l", 0xf000000, 0x1000000 },
        },
		nullptr,
		&toukon4_inputs,
    },
    // Toy Fighter
    {
        "toyfight",
        NULL,
        "Toy Fighter",
        0x08000000,
        0x2802ca85,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22035.ic22",0x0000000, 0x0400000 },
            { "mpr-22025.ic1", 0x0800000, 0x0800000 },
            { "mpr-22026.ic2", 0x1000000, 0x0800000 },
            { "mpr-22027.ic3", 0x1800000, 0x0800000 },
            { "mpr-22028.ic4", 0x2000000, 0x0800000 },
            { "mpr-22029.ic5", 0x2800000, 0x0800000 },
            { "mpr-22030.ic6", 0x3000000, 0x0800000 },
            { "mpr-22031.ic7", 0x3800000, 0x0800000 },
            { "mpr-22032.ic8", 0x4000000, 0x0800000 },
            { "mpr-22033.ic9", 0x4800000, 0x0800000 },
            { "mpr-22034.ic10",0x5000000, 0x0800000 },
        },
		nullptr,
		&toyfight_inputs,
		toyfight_eeprom_dump,
    },
    // Virtua NBA (USA)
    {
        "virnba",
        NULL,
        "Virtua NBA (USA)",
        0x0b000000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-23073.ic22",  0x0000000, 0x0400000 },
            { "mpr-22928.ic1",   0x0800000, 0x0800000 },
            { "mpr-22929.ic2",   0x1000000, 0x0800000 },
            { "mpr-22930.ic3",   0x1800000, 0x0800000 },
            { "mpr-22931.ic4",   0x2000000, 0x0800000 },
            { "mpr-22932.ic5",   0x2800000, 0x0800000 },
            { "mpr-22933.ic6",   0x3000000, 0x0800000 },
            { "mpr-22934.ic7",   0x3800000, 0x0800000 },
            { "mpr-22935.ic8",   0x4000000, 0x0800000 },
            { "mpr-22936.ic9",   0x4800000, 0x0800000 },
            { "mpr-22937.ic10",  0x5000000, 0x0800000 },
            { "mpr-22938.ic11",  0x5800000, 0x0800000 },
            { "mpr-22939.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22940.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22941.ic14s", 0x7000000, 0x0800000 },
            { "mpr-22942.ic15s", 0x7800000, 0x0800000 },
            { "mpr-22943.ic16s", 0x8000000, 0x0800000 },
            { "mpr-22944.ic17s", 0x8800000, 0x0800000 },
            { "mpr-22945.ic18s", 0x9000000, 0x0800000 },
            { "mpr-22946.ic19s", 0x9800000, 0x0800000 },
            { "mpr-22947.ic20s", 0xa000000, 0x0800000 },
            { "mpr-22948.ic21s", 0xa800000, 0x0800000 },
        },
		nullptr,
		&virnba_inputs,
    },
    // Virtua NBA
    {
        "virnbao",
        "virnba",
        "Virtua NBA",
        0x0b000000,
        0x28068b58,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22949.ic22",  0x0000000, 0x0400000 },
            { "mpr-22928.ic1",   0x0800000, 0x0800000 },
            { "mpr-22929.ic2",   0x1000000, 0x0800000 },
            { "mpr-22930.ic3",   0x1800000, 0x0800000 },
            { "mpr-22931.ic4",   0x2000000, 0x0800000 },
            { "mpr-22932.ic5",   0x2800000, 0x0800000 },
            { "mpr-22933.ic6",   0x3000000, 0x0800000 },
            { "mpr-22934.ic7",   0x3800000, 0x0800000 },
            { "mpr-22935.ic8",   0x4000000, 0x0800000 },
            { "mpr-22936.ic9",   0x4800000, 0x0800000 },
            { "mpr-22937.ic10",  0x5000000, 0x0800000 },
            { "mpr-22938.ic11",  0x5800000, 0x0800000 },
            { "mpr-22939.ic12s", 0x6000000, 0x0800000 },
            { "mpr-22940.ic13s", 0x6800000, 0x0800000 },
            { "mpr-22941.ic14s", 0x7000000, 0x0800000 },
            { "mpr-22942.ic15s", 0x7800000, 0x0800000 },
            { "mpr-22943.ic16s", 0x8000000, 0x0800000 },
            { "mpr-22944.ic17s", 0x8800000, 0x0800000 },
            { "mpr-22945.ic18s", 0x9000000, 0x0800000 },
            { "mpr-22946.ic19s", 0x9800000, 0x0800000 },
            { "mpr-22947.ic20s", 0xa000000, 0x0800000 },
            { "mpr-22948.ic21s", 0xa800000, 0x0800000 },
        },
		nullptr,
		&virnba_inputs,
    },
    // Virtua NBA (prototype)
    {
        "virnbap",
        "virnba",
        "Virtua NBA (prototype)",
        0x0b000000,
        0x28068b58,
        nullptr,
        M2,
        ROT0,
        {
        	{ "vnbaearly.ic22",  0x0000000, 0x0400000, 0x5bbf7a45 },
			{ "rom1.ic1s",       0x0800000, 0x0800000, 0x0ea48727 },
			{ "rom2.ic2s",       0x1000000, 0x0800000, 0x2941a358 },
			{ "rom3.ic3s",       0x1800000, 0x0800000, 0x0fa29eef },
			{ "rom4.ic4s",       0x2000000, 0x0800000, 0x5cbcd7a5 },
			{ "rom5.ic5s",       0x2800000, 0x0800000, 0xf026bf67 },
			{ "rom6.ic6s",       0x3000000, 0x0800000, 0x91c452ab },
			{ "rom7.ic7s",       0x3800000, 0x0800000, 0x11e4c24b },
			{ "rom8.ic8s",       0x4000000, 0x0800000, 0x72629663 },
			{ "rom9.ic9s",       0x4800000, 0x0800000, 0x54b660e6 },
			{ "rom10.ic10s",     0x5000000, 0x0800000, 0x8fc00425 },
			{ "rom11.ic11s",     0x5800000, 0x0800000, 0xd55234c4 },
			{ "rom12.ic12s",     0x6000000, 0x0800000, 0x4b42b46d },
			{ "rom13.ic13s",     0x6800000, 0x0800000, 0x6edbb058 },
			{ "rom14.ic14s",     0x7000000, 0x0800000, 0xaa3885d5 },
			{ "rom15.ic15s",     0x7800000, 0x0800000, 0xe4d59ed3 },
			{ "rom16.ic16s",     0x8000000, 0x0800000, 0x9f7a587b },
			{ "rom17.ic17s",     0x8800000, 0x0800000, 0x18b7df45 },
			{ "rom18.ic18s",     0x9000000, 0x0800000, 0x27eae4d8 },
			{ "rom19.ic19s",     0x9800000, 0x0800000, 0x7bb7ff29 },
			{ "rom20.ic20s",     0xa000000, 0x0800000, 0x9a08015e },
			{ "rom21.ic21s",     0xa800000, 0x0800000, 0x194594f2 },
        },
		nullptr,
		&virnba_inputs,
    },
    // Virtua NBA (prototype, 15.11)
    {
        "virnbapa",
        "virnba",
        "Virtua NBA (prototype, 15.11)",
        0x0b000000,
        0x28068b58,
        NULL,
        M2,
        ROT0,
        {
            { "11-15.ic22",      0x0000000, 0x0400000 },
            { "rom1.ic1s",       0x0800000, 0x0800000 },
            { "rom2.ic2s",       0x1000000, 0x0800000 },
            { "rom3.ic3s",       0x1800000, 0x0800000 },
            { "rom4.ic4s",       0x2000000, 0x0800000 },
            { "rom5.ic5s",       0x2800000, 0x0800000 },
            { "rom6.ic6s",       0x3000000, 0x0800000 },
            { "rom7.ic7s",       0x3800000, 0x0800000 },
            { "rom8.ic8s",       0x4000000, 0x0800000 },
            { "rom9.ic9s",       0x4800000, 0x0800000 },
            { "rom10.ic10s",     0x5000000, 0x0800000 },
            { "rom11.ic11s",     0x5800000, 0x0800000 },
            { "rom12.ic12s",     0x6000000, 0x0800000 },
            { "rom13.ic13s",     0x6800000, 0x0800000 },
            { "rom14.ic14s",     0x7000000, 0x0800000 },
            { "rom15.ic15s",     0x7800000, 0x0800000 },
            { "rom16.ic16s",     0x8000000, 0x0800000 },
            { "rom17.ic17s",     0x8800000, 0x0800000 },
            { "rom18.ic18s",     0x9000000, 0x0800000 },
            { "rom19.ic19s",     0x9800000, 0x0800000 },
            { "rom20.ic20s",     0xa000000, 0x0800000 },
            { "rom21.ic21s",     0xa800000, 0x0800000 },
        },
		nullptr,
		&virnba_inputs,
    },
    // Virtual On Oratorio Tangram M.S.B.S. ver5.66 2000 Edition
    {
        "vonot",
        NULL,
        "Virtual-On Oratorio Tangram M.S.B.S. Ver. 5.66",
        0x07000000,
        0x28010715,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23198.ic22",  0x0000000, 0x400000 },
            { "mpr-23182.ic1",   0x0800000, 0x800000 },
            { "mpr-23183.ic2",   0x1000000, 0x800000 },
            { "mpr-23184.ic3",   0x1800000, 0x800000 },
            { "mpr-23185.ic4",   0x2000000, 0x800000 },
            { "mpr-23186.ic5",   0x2800000, 0x800000 },
            { "mpr-23187.ic6",   0x3000000, 0x800000 },
            { "mpr-23188.ic7",   0x3800000, 0x800000 },
            { "mpr-23189.ic8",   0x4000000, 0x800000 },
            { "mpr-23190.ic9",   0x4800000, 0x800000 },
            { "mpr-23191.ic10",  0x5000000, 0x800000 },
            { "mpr-23192.ic11",  0x5800000, 0x800000 },
            { "mpr-23193.ic12s", 0x6000000, 0x800000 },
            { "mpr-23194.ic13s", 0x6800000, 0x800000 },
        },
        NULL,
        &vonot_inputs,
		vonot_eeprom_dump
    },
    // Virtua Striker 2 Ver. 2000 (JPN, USA, EXP, KOR, AUS) (Rev C)
    {
        "vs2_2k",
        NULL,
        "Virtua Striker 2 Ver. 2000 (Rev C)",
        0x8000000,
        0x28088b08,
        NULL,
        M2,
        ROT0,
        {
            { "epr-21929c.ic22",0x0000000, 0x0400000 },
            { "mpr-21924.ic1",  0x0800000, 0x0800000 },
            { "mpr-21925.ic2",  0x1000000, 0x0800000 },
            { "mpr-21911.ic3",  0x1800000, 0x0800000 },
            { "mpr-21926.ic4",  0x2000000, 0x0800000 },
            { "mpr-21913.ic5",  0x2800000, 0x0800000 },
            { "mpr-21914.ic6",  0x3000000, 0x0800000 },
            { "mpr-21915.ic7",  0x3800000, 0x0800000 },
            { "mpr-21916.ic8",  0x4000000, 0x0800000 },
            { "mpr-21917.ic9",  0x4800000, 0x0800000 },
            { "mpr-21918.ic10", 0x5000000, 0x0800000 },
            { "mpr-21919.ic11", 0x5800000, 0x0800000 },
            { "mpr-21920.ic12s",0x6000000, 0x0800000 },
            { "mpr-21921.ic13s",0x6800000, 0x0800000 },
            { "mpr-21922.ic14s",0x7000000, 0x0800000 },
            { "mpr-21923.ic15s",0x7800000, 0x0400000 },
        },
		nullptr,
		&vs2_2k_inputs,
    },
    // Virtua Striker 2 Ver. 2000
    {
        "vs2_2ko",
        "vs2_2k",
        "Virtua Striker 2 Ver. 2000",
        0x8000000,
        0x28088b08,
        NULL,
        M2,
        ROT0,
        {
            {"epr-21929.ic22",   0x0000000, 0x0400000 },
            { "mpr-21924.ic1",   0x0800000, 0x0800000 },
            { "mpr-21925.ic2",   0x1000000, 0x0800000 },
            { "mpr-21911.ic3",   0x1800000, 0x0800000 },
            { "mpr-21926.ic4",   0x2000000, 0x0800000 },
            { "mpr-21913.ic5",   0x2800000, 0x0800000 },
            { "mpr-21914.ic6",   0x3000000, 0x0800000 },
            { "mpr-21915.ic7",   0x3800000, 0x0800000 },
            { "mpr-21916.ic8",   0x4000000, 0x0800000 },
            { "mpr-21917.ic9",   0x4800000, 0x0800000 },
            { "mpr-21918.ic10",  0x5000000, 0x0800000 },
            { "mpr-21919.ic11",  0x5800000, 0x0800000 },
            { "mpr-21920.ic12s", 0x6000000, 0x0800000 },
            { "mpr-21921.ic13s", 0x6800000, 0x0800000 },
            { "mpr-21922.ic14s", 0x7000000, 0x0800000 },
            { "mpr-21923.ic15s", 0x7800000, 0x0400000 },
        },
		nullptr,
		&vs2_2k_inputs,
    },
    // Virtua Tennis (USA, EXP, KOR, AUS) / Power Smash (JPN)
    {
        "vtennis",
        NULL,
        "Virtua Tennis / Power Smash",
        0x06000000,
        0x2803eb15,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22927.ic22", 0x0000000, 0x0400000 },
            { "mpr-22916.ic1", 0x0800000, 0x0800000 },
            { "mpr-22917.ic2", 0x1000000, 0x0800000 },
            { "mpr-22918.ic3", 0x1800000, 0x0800000 },
            { "mpr-22919.ic4", 0x2000000, 0x0800000 },
            { "mpr-22920.ic5", 0x2800000, 0x0800000 },
            { "mpr-22921.ic6", 0x3000000, 0x0800000 },
            { "mpr-22922.ic7", 0x3800000, 0x0800000 },
            { "mpr-22923.ic8", 0x4000000, 0x0800000 },
            { "mpr-22924.ic9", 0x4800000, 0x0800000 },
            { "mpr-22925.ic10",0x5000000, 0x0800000 },
            { "mpr-22926.ic11",0x5800000, 0x0800000 },
        },
		nullptr,
        &shot12_inputs,
		vtennis_eeprom_dump,
    },
    // Wave Runner GP
    {
        "wrungp",
        NULL,
        "Wave Runner GP",
        0x06800000,
        0xffffffff, // not populated
        NULL,
        M2,
        ROT0,
        {
            { "epr-24059.ic22", 0x0000000, 0x0400000 },
            { "mpr-23719.ic1",  0x0800000, 0x1000000 },
            { "mpr-23720.ic2",  0x1800000, 0x1000000 },
            { "mpr-23721.ic3",  0x2800000, 0x1000000 },
            { "mpr-23722.ic4",  0x3800000, 0x1000000 },
            { "mpr-23723.ic5",  0x4800000, 0x1000000 },
            { "mpr-23724.ic6",  0x5800000, 0x1000000 },
        },
		NULL,
		&wrungp_inputs,
		wrungp_eeprom_dump
    },
    // Wave Runner GP (USA, Rev A)
    {
        "wrungpo",
        "wrungp",
        "Wave Runner GP (USA, Rev A)",
        0x06800000,
		0x284ae7c3,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23725a.ic22", 0x0000000, 0x400000  },
            { "mpr-23719.ic1",   0x0800000, 0x1000000 },
            { "mpr-23720.ic2",   0x1800000, 0x1000000 },
            { "mpr-23721.ic3",   0x2800000, 0x1000000 },
            { "mpr-23722.ic4",   0x3800000, 0x1000000 },
            { "mpr-23723.ic5",   0x4800000, 0x1000000 },
            { "mpr-23724.ic6",   0x5800000, 0x1000000 },
            // note: origin ROM board have 12x8MB FlashROMs with same contents as above

            // 838-12801 DRIVE BD WAVERUNNER
            //ROM_REGION( 0x10000, "motorio", ROMREGION_ERASEFF)
            //ROM_LOAD( "epr-19250.ic8", 0x000000, 0x010000, CRC(542d3836) SHA1(128cb0bfaf05791d219437653002f6bb948a4ad5) )
        },
		NULL,
		&wrungp_inputs,
		wrungp_eeprom_dump
    },
    // World Kicks (WK2 Ver. A)
    {
        "wldkicks",
        NULL,
        "World Kicks (World, WK2 Ver.A)",
        0xb000000,
        0x052e2901,
        NULL,
        M2,
        ROT0,
        {
            { "wk2vera.2d",  0x0800000, 0x0800000 },
            { "wk2vera.2c",  0x1000000, 0x0800000 },
            { "wk1ma2.4m",   0x2000000, 0x1000000 },
            { "wk1ma3.4l",   0x3000000, 0x1000000 },
            { "wk1ma4.4k",   0x4000000, 0x1000000 },
            { "wk1ma5.4j",   0x5000000, 0x1000000 },
            { "wk1ma6.4h",   0x6000000, 0x1000000 },
            { "wk1ma7.4f",   0x7000000, 0x1000000 },
            { "wk1ma8.4e",   0x8000000, 0x1000000 },
            { "wk1ma9.4d",   0x9000000, 0x1000000 },
            { "wk1ma10.4c",  0xa000000, 0x1000000 },
        },
		nullptr,
		&wldkicks_inputs,	// TODO some default eeprom/nvram would help
    },
    // World Kicks (Japan, WK1 Ver.A)
    {
        "wldkicksj",
        "wldkicks",
        "World Kicks (Japan, WK1 Ver.A)",
        0xb000000,
        0x052e2901,
        NULL,
        M2,
        ROT0,
        {
            { "wk1vera.2d",  0x0800000, 0x0800000 },
            { "wk2vera.2c",  0x1000000, 0x0800000 },
            { "wk1ma2.4m",   0x2000000, 0x1000000 },
            { "wk1ma3.4l",   0x3000000, 0x1000000 },
            { "wk1ma4.4k",   0x4000000, 0x1000000 },
            { "wk1ma5.4j",   0x5000000, 0x1000000 },
            { "wk1ma6.4h",   0x6000000, 0x1000000 },
            { "wk1ma7.4f",   0x7000000, 0x1000000 },
            { "wk1ma8.4e",   0x8000000, 0x1000000 },
            { "wk1ma9.4d",   0x9000000, 0x1000000 },
            { "wk1ma10.4c",  0xa000000, 0x1000000 },
        },
		nullptr,
		&wldkicks_inputs,
    },
    // World Kicks (US, WK3 Ver.A)
    {
        "wldkicksu",
        "wldkicks",
        "World Kicks (US, WK3 Ver.A)",
        0xb000000,
        0x052e2901,
        NULL,
        M2,
        ROT0,
        {
            { "wk3vera.2d", 0x0800000, 0x0800000 },
            { "wk2vera.2c", 0x1000000, 0x0800000 },
            { "wk1ma2.4m",  0x2000000, 0x1000000 },
            { "wk1ma3.4l",  0x3000000, 0x1000000 },
            { "wk1ma4.4k",  0x4000000, 0x1000000 },
            { "wk1ma5.4j",  0x5000000, 0x1000000 },
            { "wk1ma6.4h",  0x6000000, 0x1000000 },
            { "wk1ma7.4f",  0x7000000, 0x1000000 },
            { "wk1ma8.4e",  0x8000000, 0x1000000 },
            { "wk1ma9.4d",  0x9000000, 0x1000000 },
            { "wk1ma10.4c", 0xa000000, 0x1000000 },
        },
		nullptr,
		&wldkicks_inputs,
    },
    // World Kicks PCB (Japan, WKC1 Ver.A)
    {
        "wldkickspj",
        "wldkicks",
        "World Kicks (PCB, Japan, WKC1 Ver.A)",
        0xb000000,
        0x052e2901,
        NULL,
        M2,
        ROT0,
        {
            { "wkc1vera.2d", 0x0800000, 0x0800000 },
            { "wkc1vera.2c", 0x1000000, 0x0800000 },
            { "wk1ma2.4m",   0x2000000, 0x1000000 },
            { "wk1ma3.4l",   0x3000000, 0x1000000 },
            { "wk1ma4.4k",   0x4000000, 0x1000000 },
            { "wk1ma5.4j",   0x5000000, 0x1000000 },
            { "wk1ma6.4h",   0x6000000, 0x1000000 },
            { "wk1ma7.4f",   0x7000000, 0x1000000 },
            { "wk1ma8.4e",   0x8000000, 0x1000000 },
            { "wk1ma9.4d",   0x9000000, 0x1000000 },
            { "wk1ma10.4c",  0xa000000, 0x1000000 },
        },
		nullptr,
		&wldkickspcb_inputs,	// TODO some default eeprom/nvram would help
    },
    // World Kicks PCB (World, WKC2 Ver.A)
    {
        "wldkickspw",
        "wldkicks",
        "World Kicks (PCB, World, WKC2 Ver.A)",
        0xb000000,
        0x052e2901,
        NULL,
        M2,
        ROT0,
        {
            { "wkc2vera.2d", 0x0800000, 0x0800000 },
            { "wkc1vera.2c", 0x1000000, 0x0800000 },
            { "wk1ma2.4m",   0x2000000, 0x1000000 },
            { "wk1ma3.4l",   0x3000000, 0x1000000 },
            { "wk1ma4.4k",   0x4000000, 0x1000000 },
            { "wk1ma5.4j",   0x5000000, 0x1000000 },
            { "wk1ma6.4h",   0x6000000, 0x1000000 },
            { "wk1ma7.4f",   0x7000000, 0x1000000 },
            { "wk1ma8.4e",   0x8000000, 0x1000000 },
            { "wk1ma9.4d",   0x9000000, 0x1000000 },
            { "wk1ma10.4c",  0xa000000, 0x1000000 },
        },
		nullptr,
		&wldkickspcb_inputs,
    },
    // WWF Royal Rumble (JPN, USA, EXP, KOR, AUS)
    {
        "wwfroyal",
        NULL,
        "WWF Royal Rumble",
        0x08800000,
        0x281627c3,
        NULL,
        M2,
        ROT0,
        {
            { "epr-22261.ic22", 0x0000000, 0x0400000 },
            { "mpr-22262.ic1",  0x0800000, 0x1000000 },
            { "mpr-22263.ic2",  0x1800000, 0x1000000 },
            { "mpr-22264.ic3",  0x2800000, 0x1000000 },
            { "mpr-22265.ic4",  0x3800000, 0x1000000 },
            { "mpr-22266.ic5",  0x4800000, 0x1000000 },
            { "mpr-22267.ic6",  0x5800000, 0x1000000 },
            { "mpr-22268.ic7",  0x6800000, 0x1000000 },
            { "mpr-22269.ic8",  0x7800000, 0x1000000 },
        },
		nullptr,
		&wwfroyal_inputs,
    },
    // Zero Gunner 2
    {
        "zerogu2",
        NULL,
        "Zero Gunner 2",
        0x05800000,
        0x0007c010,
        NULL,
        M2,
        ROT0,
        {
            { "epr-23689.ic22", 0x0000000, 0x0400000 },
            { "mpr-23684.ic1",  0x0800000, 0x1000000 },
            { "mpr-23685.ic2",  0x1800000, 0x1000000 },
            { "mpr-23686.ic3",  0x2800000, 0x1000000 },
            { "mpr-23687.ic4",  0x3800000, 0x1000000 },
            { "mpr-23688.ic5",  0x4800000, 0x1000000 },
        },
        nullptr,
		&shot12_inputs,
    },
    // Zombie Revenge (Rev A)
    {
        "zombrvn",
        nullptr,
        "Zombie Revenge (Rev A)",
        0xa000000,
        0x28012b41,
        nullptr,
        M2,
        ROT0,
        {
			{ "epr-21707a.ic22", 0x0000000, 0x0200000, 0xc067af92 },
			{ "epr-21707a.ic22", 0x0200000, 0x0200000, 0xc067af92 }, // reload
			{ "mpr-21708.ic1",   0x0800000, 0x0800000, 0xb1ca1ca0 },
			{ "mpr-21709.ic2",   0x1000000, 0x0800000, 0x1ccc22bb },
			{ "mpr-21710.ic3",   0x1800000, 0x0800000, 0x954f49ba },
			{ "mpr-21711.ic4",   0x2000000, 0x0800000, 0xbda785e2 },
			{ "mpr-21712.ic5",   0x2800000, 0x0800000, 0x38309255 },
			{ "mpr-21713.ic6",   0x3000000, 0x0800000, 0x7c66c88e },
			{ "mpr-21714.ic7",   0x3800000, 0x0800000, 0xdd8db07e },
			{ "mpr-21715.ic8",   0x4000000, 0x0800000, 0x7243da2e },
			{ "mpr-21716.ic9",   0x4800000, 0x0800000, 0x01dd88c2 },
			{ "mpr-21717.ic10",  0x5000000, 0x0800000, 0x95139ec0 },
			{ "mpr-21718.ic11",  0x5800000, 0x0800000, 0x4d36a24a },
			{ "mpr-21719.ic12s", 0x6000000, 0x0800000, 0x2b86df0a },
			{ "mpr-21720.ic13s", 0x6800000, 0x0800000, 0xff681ece },
			{ "mpr-21721.ic14s", 0x7000000, 0x0800000, 0x216abba6 },
			{ "mpr-21722.ic15s", 0x7800000, 0x0800000, 0xb2de7e5f },
			{ "mpr-21723.ic16s", 0x8000000, 0x0800000, 0x515932ae },
			{ "mpr-21724.ic17s", 0x8800000, 0x0800000, 0xf048aeb7 },
			{ "mpr-21725.ic18s", 0x9000000, 0x0800000, 0x2202077b },
			{ "mpr-21726.ic19s", 0x9800000, 0x0800000, 0x429bf290 },
        },
		nullptr,
		&zombie_inputs,
		zombrvn_eeprom_dump,
    },
    // Zombie Revenge
    {
        "zombrvno",
        "zombrvn",
        "Zombie Revenge",
        0x0a000000,
        0x28012b41,
		nullptr,
        M2,
        ROT0,
        {
			{ "epr-21707.ic22", 0x0000000, 0x0200000, 0x4daa11e9 },
			{ "epr-21707.ic22", 0x0200000, 0x0200000, 0x4daa11e9 },    // Reload
			{ "mpr-21708.ic1",  0x0800000, 0x0800000, 0xb1ca1ca0 },
			{ "mpr-21709.ic2",  0x1000000, 0x0800000, 0x1ccc22bb },
			{ "mpr-21710.ic3",  0x1800000, 0x0800000, 0x954f49ba },
			{ "mpr-21711.ic4",  0x2000000, 0x0800000, 0xbda785e2 },
			{ "mpr-21712.ic5",  0x2800000, 0x0800000, 0x38309255 },
			{ "mpr-21713.ic6",  0x3000000, 0x0800000, 0x7c66c88e },
			{ "mpr-21714.ic7",  0x3800000, 0x0800000, 0xdd8db07e },
			{ "mpr-21715.ic8",  0x4000000, 0x0800000, 0x7243da2e },
			{ "mpr-21716.ic9",  0x4800000, 0x0800000, 0x01dd88c2 },
			{ "mpr-21717.ic10", 0x5000000, 0x0800000, 0x95139ec0 },
			{ "mpr-21718.ic11", 0x5800000, 0x0800000, 0x4d36a24a },
			{ "mpr-21719.ic12s",0x6000000, 0x0800000, 0x2b86df0a },
			{ "mpr-21720.ic13s",0x6800000, 0x0800000, 0xff681ece },
			{ "mpr-21721.ic14s",0x7000000, 0x0800000, 0x216abba6 },
			{ "mpr-21722.ic15s",0x7800000, 0x0800000, 0xb2de7e5f },
			{ "mpr-21723.ic16s",0x8000000, 0x0800000, 0x515932ae },
			{ "mpr-21724.ic17s",0x8800000, 0x0800000, 0xf048aeb7 },
			{ "mpr-21725.ic18s",0x9000000, 0x0800000, 0x2202077b },
			{ "mpr-21726.ic19s",0x9800000, 0x0800000, 0x429bf290 },
        },
		nullptr,
		&zombie_inputs,
		zombrvn_eeprom_dump,
    },
	{
		"zombrvne",
		"zombrvn",
		"Zombie Revenge (Export)",
        0x0a000000,
        0x28012b41,
		nullptr,
        M2,
        ROT0,
		{
			{ "epr-21834.ic22", 0x0000000, 0x0200000, 0xecb299ea },
			{ "epr-21834.ic22", 0x0200000, 0x0200000, 0xecb299ea },		// Reload
			{ "mpr-21708.ic1",  0x0800000, 0x0800000, 0xb1ca1ca0 },
			{ "mpr-21709.ic2",  0x1000000, 0x0800000, 0x1ccc22bb },
			{ "mpr-21710.ic3",  0x1800000, 0x0800000, 0x954f49ba },
			{ "mpr-21711.ic4",  0x2000000, 0x0800000, 0xbda785e2 },
			{ "mpr-21712.ic5",  0x2800000, 0x0800000, 0x38309255 },
			{ "mpr-21713.ic6",  0x3000000, 0x0800000, 0x7c66c88e },
			{ "mpr-21714.ic7",  0x3800000, 0x0800000, 0xdd8db07e },
			{ "mpr-21715.ic8",  0x4000000, 0x0800000, 0x7243da2e },
			{ "mpr-21716.ic9",  0x4800000, 0x0800000, 0x01dd88c2 },
			{ "mpr-21717.ic10", 0x5000000, 0x0800000, 0x95139ec0 },
			{ "mpr-21718.ic11", 0x5800000, 0x0800000, 0x4d36a24a },
			{ "mpr-21719.ic12s",0x6000000, 0x0800000, 0x2b86df0a },
			{ "mpr-21720.ic13s",0x6800000, 0x0800000, 0xff681ece },
			{ "mpr-21721.ic14s",0x7000000, 0x0800000, 0x216abba6 },
			{ "mpr-21722.ic15s",0x7800000, 0x0800000, 0xb2de7e5f },
			{ "mpr-21723.ic16s",0x8000000, 0x0800000, 0x515932ae },
			{ "mpr-21724.ic17s",0x8800000, 0x0800000, 0xf048aeb7 },
			{ "mpr-21725.ic18s",0x9000000, 0x0800000, 0x2202077b },
			{ "mpr-21726.ic19s",0x9800000, 0x0800000, 0x429bf290 },
		},
		nullptr,
		&zombie_inputs,
		zombrvne_eeprom_dump,
	},
	{
		"hopper",
		nullptr,
		"SWP Hopper Board",
		0x0b000000,
		0x1e5bb0cd,
		NULL,
		M2,
		ROT0,
		{
			{ "epr-24083.ic11", 0x000000, 0x400000, 0x2733e65a },
		},
	},
    // Virtua Golf / Dynamic Golf (prototype)
    {
        "dygolfp",
		"dygolf",
        "Virtua Golf / Dynamic Golf (prototype)",
		0xb000000,
		0xffffffff, // not populated
        "naomi",
        M2,
        ROT0,
        {
        	{ "rom0.ic22",   0x00000000, 0x00400000, 0x2f391fdf },
			{ "rom1.ic1s",   0x00800000, 0x00800000, 0x2c683edd },
			{ "rom2.ic2s",   0x01000000, 0x00800000, 0x1795e6f4 },
			{ "rom3.ic3s",   0x01800000, 0x00800000, 0x9b45cc32 },
			{ "rom4.ic4s",   0x02000000, 0x00800000, 0x2c5a570a },
			{ "rom5.ic5s",   0x02800000, 0x00800000, 0x48cc544e },
			{ "rom6.ic6s",   0x03000000, 0x00800000, 0xe12db83b },
			{ "rom7.ic7s",   0x03800000, 0x00800000, 0x36c313a6 },
			{ "rom8.ic8s",   0x04000000, 0x00800000, 0x9868d078 },
			{ "rom9.ic9s",   0x04800000, 0x00800000, 0x032cca1a },
			{ "rom10.ic10s", 0x05000000, 0x00800000, 0x6d094477 },
			{ "rom11.ic11s", 0x05800000, 0x00800000, 0x6c803ca0 },
		},
		nullptr,
		&dygolf_inputs,
    },
	// Nittere Shiki! Mirai Yosou Studio / NTV Future Forecast Studio (Japan)
    {
        "ntvmys",
		nullptr,
        "Nittere Shiki! Mirai Yosou Studio / NTV Future Forecast Studio",
		0x9800000,
		0x281a6263,
        "naomi",
        M2,
        ROT0,
        {
        	{ "epr-23419a.ic22",   0x00000000, 0x00400000, 0x8639d1e5 },
			{ "rom1.ic1s",   0x00800000, 0x00800000, 0x5f11a3ec },
			{ "rom2.ic2s",   0x01000000, 0x00800000, 0x0d46bfe5 },
			{ "rom3.ic3s",   0x01800000, 0x00800000, 0xac5c846e },
			{ "rom4.ic4s",   0x02000000, 0x00800000, 0x6cb2153f },
			{ "rom5.ic5s",   0x02800000, 0x00800000, 0xfd70ef17 },
			{ "rom6.ic6s",   0x03000000, 0x00800000, 0xe52afefa },
			{ "rom7.ic7s",   0x03800000, 0x00800000, 0x976b929d },
			{ "rom8.ic8s",   0x04000000, 0x00800000, 0x7914b241 },
			{ "rom9.ic9s",   0x04800000, 0x00800000, 0x2c50b20c },
			{ "rom10.ic10s", 0x05000000, 0x00800000, 0xa4b8fbc8 },
			{ "rom11.ic11s", 0x05800000, 0x00800000, 0x8a7dbf32 },
			// ic 12s populated, empty (ff)
			{ "rom11.ic11s", 0x06800000, 0x00800000, 0x523a20f9 },
			{ "rom11.ic11s", 0x07000000, 0x00800000, 0x5ddf6931 },
			{ "rom11.ic11s", 0x07800000, 0x00800000, 0x1ef1cbed },
			{ "rom11.ic11s", 0x08000000, 0x00800000, 0x82fa259a },
			{ "rom11.ic11s", 0x08800000, 0x00800000, 0x6c1207d4 },
			{ "rom11.ic11s", 0x09000000, 0x00800000, 0xeb8201b0 },
			//	ROM_REGION( 0x84, "some_eeprom", 0 )
			//	ROM_LOAD( "sflash.ic37", 0x000000, 0x000084, CRC(44c05f0c) SHA1(daf3687282d2665837025261aadc4ac477bb43a1) )
		},
    },

	// Naomi M4 Roms
    // Akatsuki Blitzkampf Ausf. Achse (Japan)
    {
        "ausfache",
        NULL,
        "Akatsuki Blitzkampf Ausf. Achse",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT0,
        {
            { "ic8.bin", 0x0000000, 0x4000000 },
            { "ic9.bin", 0x4000000, 0x4000000 },
            // IC10 and IC11 Populated, Empty
            { "317-05130-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		&ausfache_inputs,
		ausfache_eeprom_dump,
    },
    // Asian Dynamite
    {
        "asndynmt",
        NULL,
        "Asian Dynamite / Dynamite Deka EX",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24382.ic8",  0x0000000, 0x4000000, 0x4daefde5 },
            { "fpr-24383.ic9",  0x4000000, 0x4000000, 0x8ac2fe5d },
            { "fpr-24384.ic10", 0x8000000, 0x4000000, 0x2e9116c4 },
            { "fpr-24385.ic11", 0xc000000, 0x4000000, 0x2b79f45d },
            { "317-0495-com.ic3", 0, 0x800, 0xc229a59b, Key },
        },
		nullptr,
		&asndynmt_inputs,
    },
    // Asian Dynamite / Dynamite Deka EX (older)
    {
        "asndynmto",
        "asndynmt",
        "Asian Dynamite / Dynamite Deka EX (older)",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24382.ic8",  0x0000000, 0x4000000, 0x5b4763fc },
            { "fpr-24383.ic9",  0x4000000, 0x4000000, 0x8ac2fe5d },
            { "fpr-24384.ic10", 0x8000000, 0x4000000, 0x2e9116c4 },
            { "fpr-24385.ic11", 0xc000000, 0x4000000, 0x2b79f45d },
            { "317-0495-com.ic3", 0, 0x800, 0xc229a59b, Key },
        },
		nullptr,
		&asndynmt_inputs,
    },
    // Illvelo (Illmatic Envelope) (Japan)
    {
        "illvelo",
        NULL,
        "Illvelo (Illmatic Envelope)",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT270,
        {
            { "fpr-24437.ic8",  0x0000000, 0x4000000 },
            { "fpr-24438.ic9",  0x4000000, 0x4000000 },
            { "fpr-24439.ic10", 0x8000000, 0x4000000 },
            { "317-5131-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		&illvelo_inputs,
        illvelo_eeprom_dump
    },
    // Manic Panic Ghosts! *** BAD DUMP ***
    {
        "manicpnc",
        NULL,
        "Manic Panic Ghosts!",
        0x14000000,
        0x5505,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24408.ic8",  0x00000000, 0x4000000 },
            { "fpr-24372.ic9",  0x04000000, 0x4000000 },
            { "fpr-24373.ic10", 0x08000000, 0x4000000 },
            { "fpr-24374.ic11", 0x0c000000, 0x4000000 },
            { "fpr-24375.ic12", 0x10000000, 0x4000000 },

            //ROM_REGION( 0x800, "pic_readout", 0 )
            //ROM_LOAD( "317-0461-com.ic3", 0, 0x800, BAD_DUMP CRC(c9282cdd) SHA1(23933e489d763515428e2714cc6e7676df1d5323) )
            { "317-0461-com.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		nullptr,
		manicpnc_eeprom_dump,
    },
    // Mamoru-kun wa Norowarete Shimatta! (Japan)
    {
        "mamonoro",
        NULL,
        "Mamoru-kun wa Norowarete Shimatta!",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT270,
        {
            { "ic8.bin",  0x0000000, 0x4000000 },
            { "ic9.bin",  0x4000000, 0x4000000 },
            { "ic10.bin", 0x8000000, 0x4000000 },
            { "317-5132-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
        NULL,
        &mamonoro_inputs,
        mamonoro_eeprom_dump
    },
    // Melty Blood Actress Again Version A (Japan, Rev A)
    {
        "mbaa",
        NULL,
        "Melty Blood Actress Again (Ver. A, Rev A)",
        0x18000000,
        0x5586,
        "naomi",
        M4,
        ROT0,
        {
            { "ic8.bin",       0x00000000, 0x4000000 },
            { "epr-24455.ic7", 0x00000000, 0x0400000 }, // EPR mode, overwrite FPR data
            { "ic9.bin",       0x04000000, 0x4000000 },
            { "ic10.bin",      0x08000000, 0x4000000 },
            { "ic11.bin",      0x0c000000, 0x4000000 },
            { "ic12.bin",      0x10000000, 0x4000000 },
            { "ic13.bin",      0x14000000, 0x4000000 },
            { "317-5133-jpn.ic3", 0, 0x800,  0x0000000, Key }, // pic_readout
        },
        nullptr,
		&meltyb_inputs,
		mbaa_eeprom_dump,
    },
    // Melty Blood Actress Again (Japan) (Clone)
    {
        "mbaao",
        "mbaa",
        "Melty Blood Actress Again",
        0x18000000,
        0x5506,
        "naomi",
        M4,
        ROT0,
        {
            { "ic8.bin",       0x00000000, 0x4000000 },
            { "ic9.bin",       0x04000000, 0x4000000 },
            { "ic10.bin",      0x08000000, 0x4000000 },
            { "ic11.bin",      0x0c000000, 0x4000000 },
            { "ic12.bin",      0x10000000, 0x4000000 },
            { "ic13.bin",      0x14000000, 0x4000000 },
            { "317-5133-jpn.ic3", 0, 0x800,  0x0000000, Key }, // pic_readout
        },
        nullptr,
		&meltyb_inputs,
		mbaa_eeprom_dump,
    },
    // Mushiking The King Of Beetles - Mushiking II / III / III+ (Ver. 1.001) (World)
    {
        "mushi2eo",
        "mushik2e",
        "Mushiking The King Of Beetles - Mushiking II / III / III+ (World, Ver. 1.001)",
        0x8000000,
        0x5502,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24333.ic8", 0x0000000, 0x4000000 },
            { "fpr-24334.ic9", 0x4000000, 0x4000000 },
            { "317-0437-com.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		&mushik_inputs,
    },
    // Mushiking The King Of Beetles - Mushiking II / III / III+ (World, Ver. 2.001)
    {
        "mushik2e",
        nullptr,
        "Mushiking The King Of Beetles - Mushiking II / III / III+ (World, Ver. 2.001)",
        0x8000000,
        0x5582,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24333.ic8", 0x0000000, 0x4000000 },
            { "epr-24357.ic7", 0x0000000, 0x0400000 },
            { "fpr-24334.ic9", 0x4000000, 0x4000000 },

            //ROM_REGION( 0x800, "pic_readout", 0 )
            //ROM_LOAD( "317-0437-com.ic3", 0, 0x800, CRC(3b6fcee8) SHA1(65fbdd3b8c61a4b5ccb6389b25483a7ecdc0794d) )
            { "317-0437-com.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		&mushik_inputs,
    },
    // Mushiking The King Of Beetles - Mushiking IV / V / VI (World)
    // change game version (4/5/6): in BACKUP DATA CLEAR menu hold P1 and P2 buttons 1 for 3 seconds, then change version number in appeared menu and select YES(CLEAR)
	// ~equivalent of Japanese 2K6 versions
    {
        "mushik4e",
        nullptr,
        "Mushiking The King Of Beetles - Mushiking IV / V / VI (World)",
        0x8000000,
        0x5502,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24417.ic8", 0x0000000, 0x4000000, 0x01278cbb },
            { "fpr-24418.ic9", 0x4000000, 0x4000000, 0x7c8d7687 },

            //ROM_REGION( 0x800, "pic_readout", 0 )
            { "317-0437-com.ic3", 0, 0x800,  0x3b6fcee8, Key },
        },
		nullptr,
		&mushik_inputs,
    },
	// Mushiking The King Of Beetles - Mushiking IV / V / VI (Taiwan)
    // change game version (4/5/6): in BACKUP DATA CLEAR menu hold P1 and P2 buttons 1 for 3 seconds, then change version number in appeared menu and select YES(CLEAR)
	// ~equivalent of Japanese 2K6 versions
    {
        "mushik4t",
        "mushik4e",
        "Mushiking The King Of Beetles - Mushiking IV / V / VI (Taiwan)",
        0x8000000,
        0x5502,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24420.ic8", 0x0000000, 0x4000000, 0x4a44a604 },
            { "fpr-24421.ic9", 0x4000000, 0x4000000, 0xaf137021 },	// BAD DUMP

            //ROM_REGION( 0x800, "pic_readout", 0 )
            { "317-0437-com.ic3", 0, 0x800,  0x3b6fcee8, Key },
        },
		nullptr,
		&mushik_inputs,
    },
	{
		"mushi2k61",
		nullptr,
		"Mushiking The King Of Beetles 2006 First (Japan)",
		0x8000000,
		0x5502,
		"naomi",
		M4,
		ROT0,
		{
			{ "fpr-24340.ic8", 0x0000000, 0x4000000, 0xd348a3a7 },
			{ "fpr-24341.ic9", 0x4000000, 0x4000000, 0xbde9547c },

            { "317-0444-jpn.ic3", 0, 0x800,  0x6ded35a2, Key },
		},
		nullptr,
		&mushik_inputs,
	},
	{
		"mushi2k62",
		nullptr,
		"Mushiking The King Of Beetles 2006 Second (Japan)",
		0x8000000,
		0x5502,
		"naomi",
		M4,
		ROT0,
		{
			{ "fpr-24360.ic8", 0x0000000, 0x4000000, 0x6e6c6633 },
			{ "fpr-24361.ic9", 0x4000000, 0x4000000, 0xce2a9720 },

            { "317-0444-jpn.ic3", 0, 0x800,  0x6ded35a2, Key },
		},
		nullptr,
		&mushik_inputs,
	},
    // Pokasuka Ghost *** BAD DUMP ***
    {
        "pokasuka",
		"manicpnc",
        "Pokasuka Ghost!",
        0x14000000,
        0x5505,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24365.ic8",  0x00000000, 0x4000000, 0x11489cda },
            { "fpr-24366.ic9",  0x04000000, 0x4000000, 0x7429714a },
            { "fpr-24367.ic10", 0x08000000, 0x4000000, 0xdee87bab },
            { "fpr-24368.ic11", 0x0c000000, 0x4000000, 0x124f55e2 },
            { "fpr-24369.ic12", 0x10000000, 0x4000000, 0x35b544ab },

            //ROM_REGION( 0x800, "pic_readout", 0 )
            //ROM_LOAD( "317-0461-com.ic3", 0, 0x800, BAD_DUMP CRC(c9282cdd) SHA1(23933e489d763515428e2714cc6e7676df1d5323) )
            { "317-0461-com.ic3", 0, 0x800,  0xc9282cdd, Key },
        },
		nullptr,
		nullptr,
		manicpnc_eeprom_dump,
    },
    // Radirgy Noa
    {
        "radirgyn",
        NULL,
        "Radirgy Noa",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT0,
        {
            { "ic8.bin", 0x0000000, 0x4000000 },
            { "ic9.bin", 0x4000000, 0x4000000 },
            { "317-5138-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
        NULL,
        &radirgy_inputs,
    },
    // Rhythm Tengoku
    {
        "rhytngk",
        NULL,
        "Rhythm Tengoku",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24423.ic8",  0x00000000, 0x4000000 },
            { "fpr-24424.ic9",  0x04000000, 0x4000000 },
            { "fpr-24425.ic10", 0x08000000, 0x4000000 },
            { "fpr-24426.ic11", 0x0c000000, 0x4000000 },
            { "317-0503-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		&rhytngk_inputs,
    },
    // Shooting Love 2007 (Japan)
    {
        "sl2007",
        NULL,
        "Shooting Love 2007",
        0x10000000,
        0x5504,
        "naomi",
        M4,
        ROT270,
        {
            { "fpr-24413.ic8",  0x0000000, 0x4000000 },
            { "fpr-24414.ic9",  0x4000000, 0x4000000 },
            { "fpr-24415.ic10", 0x8000000, 0x4000000 },
            { "fpr-24416.ic11", 0xc000000, 0x4000000 },
            { "317-5129-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		&sl2007_inputs,
        sl2007_eeprom_dump
    },
    // Touch De Zunou (Rev A) *** BAD DUMP ***
    {
        "zunou",
        NULL,
        "Touch De Zunou (Rev A)",
        0x8000000,
        0x5502,
        "naomi",
        M4,
        ROT0,
        {
            { "fpr-24338.ic8", 0x0000000, 0x4000000 },
            { "fpr-24339.ic9", 0x4000000, 0x4000000 },

            //ROM_REGION( 0x800, "pic_readout", 0 )
            //ROM_LOAD( "317-0435-jpn.ic3", 0, 0x800, BAD_DUMP CRC(b553d900) SHA1(ed1c3c2053f2c0e98cb5c4d99f93143a66c29e5c) )
            { "317-0435-jpn.ic3", 0, 0x800,  0x0000000, Key },
        },
		nullptr,
		nullptr,
    },
    // Star Horse Progress Returns (satellite)
    {
        "shorsepr",
        NULL,
        "Star Horse Progress Returns (satellite)",
        0x8000000,
        0x5502,
        "naomi",
        M4,
        ROT270,
        {
            { "fpr-24489.ic8",  0x00000000, 0x4000000 },
            { "fpr-24490.ic9",  0x04000000, 0x4000000 },
        }
    },
    // Naomi GD Roms

    // Azumanga Daioh Puzzle Bobble
    {
        "azumanga",
        nullptr,
        "Azumanga Daioh Puzzle Bobble",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5091-jpn.pic", 0, 0x4000, 0xb71ede16 },
        },
        "gdl-0018",
		&azumanga_inputs,
	},
    // Border Down (Rev A)
    {
        "bdrdown",
		nullptr,
        "Border Down",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5097-jpn.pic", 0, 0x4000, 0x16d2a748 },
            { "bdrdown-default-eeprom.bin", 0, 0x80,  0x5b19727c, Eeprom },
        },
        "gdl-0023a",
		&bdrdown_inputs,
    },
    // Chaos Field (Japan)
    {
        "cfield",
		nullptr,
        "Chaos Field",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5102-com.pic", 0, 0x4000, 0x8f1d8387 },
            { "cfield-default-eeprom.bin", 0, 0x80,  0xa7acb6bf, Eeprom },
        },
        "gdl-0025",
		&cfield_inputs,
    },
    // Musapey's Choco Marker (Rev A)
    {
        "chocomk",
		nullptr,
        "Musapey's Choco Marker (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5085-jpn.pic", 0, 0x4000, 0x677fd544 },
        },
        "gdl-0014a",
		&button12_inputs,
    },
    // Cleopatra Fortune Plus
    {
        "cleoftp",
		nullptr,
        "Cleopatra Fortune Plus",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5083-com.pic", 0, 0x4000, 0x096a0fc2 },
        },
        "gdl-0012",
		&button12_inputs,
    },
    // Confidential Mission
    {
        "confmiss",
		nullptr,
        "Confidential Mission",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0298-com.pic",  0, 0x4000, 0x15971bf6 },
        },
        "gds-0001",
		&lightgun_inputs,
		confmiss_eeprom_dump,
    },
    // Capcom vs. SNK Millennium Fight 2000 Pro (Japan)
    {
        "cvsgd",
		nullptr,
        "Capcom vs. SNK Millennium Fight 2000 Pro (Japan)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5076-jpn.pic", 0, 0x4000, 0x7c125b10 },
        },
        "gdl-0004",
		&capcom_4btn_inputs,
		cvsgd_eeprom_dump,
    },
    // Capcom vs. SNK 2 Mark Of The Millennium 2001
    // ver 010804
    // with Japan BIOS will be shown 010705, likely forgot / was not cared to update it
    {
        "cvs2",
		nullptr,
        "Capcom vs. SNK 2 Mark Of The Millennium 2001 (USA)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5078-com.pic", 0, 0x4000, 0xe7bb621d },
        },
        "gdl-0008",
        &capcom_6btn_inputs,
		cvs2_eeprom_dump,
    },
    // Capcom vs. SNK 2 Millionaire Fighting 2001 (Rev A)
    // ver 010705
    {
        "cvs2mf",
        "cvs2",
        "Capcom vs. SNK 2 Millionaire Fighting 2001 (Japan, Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5078-com.pic", 0, 0x4000, 0xe7bb621d },
        },
        "gdl-0007a",
        &capcom_6btn_inputs,
		cvs2_eeprom_dump,
    },
    // Dragon Treasure (Rev B)
    {
        "dragntr",
		nullptr,
        "Dragon Treasure (Rev B)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0363-com.pic", 0, 0x4000, 0xffecccf8 },
            //{ "317-0364-com.pic", 0, 0x4000, 0x82975008 },
        },
        "gds-0030b",
    },
    // Dragon Treasure (Rev A)
    {
        "dragntra",
        "dragntr",
        "Dragon Treasure (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0363-com.pic", 0, 0x4000, 0xffecccf8 },
            //{ "317-0364-com.pic", 0, 0x4000, 0x82975008 },
        },
        "gds-0030a",
    },
    // Dragon Treasure 2 (Rev A)
    {
        "dragntr2",
		nullptr,
        "Dragon Treasure 2 (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0389-com.pic", 0, 0x4000, 0x35c511f9 },
            //{ "317-0390-com.pic", 0, 0x4000, 0x92183b60 },
        },
        "gds-0037a",
    },
    // Dragon Treasure 3 (Rev A)
    {
        "dragntr3",
		nullptr,
        "Dragon Treasure 3 (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0426-jpn.pic", 0, 0x4000, 0x8df4d33a },
            //{ "317-0390-com.pic", 0, 0x4000, 0x92183b60 },
        },
        "gds-0041a",
    },
    // Virtua Golf / Dynamic Golf (Rev A)
    {
        "dygolf",
		nullptr,
        "Virtua Golf / Dynamic Golf",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0308-com.pic", 0, 0x4000, 0x5e1ef2c4 },
        },
        "gds-0009a",
		&dygolf_inputs,
    },
    // Guilty Gear XX
    {
        "ggxx",
		nullptr,
        "Guilty Gear XX",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5082-com.pic", 0, 0x4000, 0x1b41189b },
        },
        "gdl-0011",
		&guilty_gear_inputs,
    },
    // Guilty Gear XX Accent Core (Japan)
    {
        "ggxxac",
		nullptr,
        "Guilty Gear XX Accent Core",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5126-jpn.pic", 0, 0x4000, 0x87c44284 },
        },
        "gdl-0041",
		&guilty_gear_inputs,
		ggxxac_eeprom_dump,
    },
    // Guilty Gear XX #Reload (Japan, Rev A)
    {
        "ggxxrl",
		nullptr,
        "Guilty Gear XX #Reload (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5092-jpn.pic", 0, 0x4000, 0x7ad7b541 },
        },
        "gdl-0019a",
		&guilty_gear_inputs,
    },
    // Guilty Gear XX #Reload (Japan)
    {
        "ggxxrlo",
        "ggxxrl",
        "Guilty Gear XX #Reload",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5092-jpn.pic" , 0, 0x4000, 0x7ad7b541 },
        },
        "gdl-0019",
		&guilty_gear_inputs,
    },
    // Guilty Gear XX Slash (Japan, Rev A)
    {
        "ggxxsla",
		nullptr,
        "Guilty Gear XX Slash (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5111-jpn.pic", 0, 0x4000, 0x96bcbd42 },
        },
        "gdl-0033a",
		&guilty_gear_inputs,
		ggxxsla_eeprom_dump,
    },
    // Mobile Suit Gundam: Federation vs. Zeon
    {
        "gundmgd",
		nullptr,
        "Mobile Suit Gundam: Federation vs. Zeon",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5069-com.pic", 0, 0x4000, 0x44d0b242 },
            //{ "gundmgd-default-eeprom.bin", 0, 0x80,  0xdc80fa1e, Eeprom },
        },
        "gdl-0001",
		&shot1234_inputs,
		gundmct_eeprom_dump
    },
    // Mobile Suit Gundam: Federation vs. Zeon DX (USA, Japan)
    {
        "gundmxgd",
		nullptr,
        "Mobile Suit Gundam: Federation vs. Zeon DX",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5079-com.pic", 0, 0x4000, 0x8f9fb55d },
            //{ "gundmxgd-default-eeprom.bin", 0, 0x80,  0xdc0e8d45, Eeprom },
        },
        "gdl-0006",
		&shot1234_inputs,
		gundmxgd_eeprom_dump
    },
    // Ikaruga
    {
        "ikaruga",
		nullptr,
        "Ikaruga",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5081-jpn.pic", 0, 0x4000, 0x72ca4579 },
        },
        "gdl-0010",
		&ikaruga_inputs,
		nullptr,
    },
    // Jingi Storm - The Arcade (Japan)
    {
        "jingystm",
		nullptr,
        "Jingi Storm - The Arcade",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5122-jpn.pic", 0, 0x4000, 0x88983220 },
        },
        "gdl-0037",
		&jingystm_inputs,
		jingystm_eeprom_dump,
    },
    // Karous (Japan)
    {
        "karous",
		nullptr,
        "Karous",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5125-com.pic", 0, 0x4000, 0x918efc4f },
            { "karous-default-eeprom.bin", 0, 0x80,  0xb017451c, Eeprom },
        },
        "gdl-0040",
		&radirgy_inputs,
    },
    // La Keyboard
    {
        "keyboard",
		nullptr,
        "La Keyboard",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0323-com.pic", 0, 0x4000, 0xc8854ef2 },
            { "keyboard-default-eeprom.bin", 0, 0x80,  0x9262fc90, Eeprom },
        },
        "gds-0017",
    },
    // Kurukuru Chameleon (Japan)
    {
        "kurucham",
		nullptr,
        "Kurukuru Chameleon",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5115-jpn.pic", 0, 0x4000, 0xe5435e85 },
        },
        "gdl-0034",
		nullptr,	// TODO
    },
    // Lupin The Third - The Shooting (Rev A)
    {
        "lupinsho",
		nullptr,
        "Lupin The Third - The Shooting (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0325-jpn.pic", 0, 0x4000, 0xf71cb2fc },
        },
        "gds-0018a",
		&lightgun_inputs,
		lupinsho_eeprom_dump,
    },
    // Lupin The Third - The Shooting
    {
        "lupinshoo",
        "lupinsho",
        "Lupin The Third - The Shooting",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0325-jpn.pic", 0, 0x4000, 0xf71cb2fc },
        },
        "gds-0018",
		&lightgun_inputs,
		lupinsho_eeprom_dump,
    },
    // Lupin The Third - The Typing (Rev A)
    {
        "luptype",
		nullptr,
        "Lupin The Third - The Typing",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0332-jpn.pic", 0, 0x4000, 0x43e78ecf },
        },
        "gds-0021a",
		nullptr,
		luptype_eeprom_dump,
    },
    // Melty Blood Act Cadenza Version B2 (Japan)
    {
        "meltyb",
		nullptr,
        "Melty Blood Act Cadenza (Ver. B2)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5124-jpn.pic", 0, 0x4000, 0xad162bfa },
        },
        "gdl-0039a",
		&meltyb_inputs,
		meltyb_eeprom_dump,
    },
    // Melty Blood Act Cadenza Ver. A (Japan)
    {
        "meltybld",
		nullptr,
        "Melty Blood Act Cadenza (Ver. A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5104-jpn.pic", 0, 0x4000, 0xafa5e709 },
        },
        "gdl-0028c",
		&meltyb_inputs,
		meltybld_eeprom_dump,
    },
    // Melty Blood Act Cadenza (Japan)
    {
        "meltyblo",
        "meltybld",
        "Melty Blood Act Cadenza",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5104-jpn.pic", 0, 0x4000, 0xafa5e709 },
        },
        "gdl-0028",
		&meltyb_inputs,
		meltybld_eeprom_dump,
    },
    // Melty Blood Act Cadenza Version B (Japan)
    {
        "meltybo",
        "meltyb",
        "Melty Blood Act Cadenza (Ver. B)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5124-jpn.pic", 0, 0x4000, 0xad162bfa },
        },
        "gdl-0039",
		&meltyb_inputs,
		meltyb_eeprom_dump,
    },
    // Moeru Casinyo (Japan)
    {
        "moeru",
		nullptr,
        "Moeru Casinyo",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5084-jpn.pic", 0, 0x4000, 0xdb7dac1e },
            { "moeru-default-eeprom.bin", 0, 0x80,  0x50ca079f, Eeprom },
        },
        "gdl-0013",
		nullptr,	// TODO
    },
    // The Maze of the Kings
    {
        "mok",
		nullptr,
        "The Maze of the Kings",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0333-com.pic", 0, 0x4000, 0x15fb7792 },
        },
        "gds-0022",
		&lightgun_inputs,
		mok_eeprom_dump,
    },
    // Monkey Ball
    {
        "monkeyba",
		nullptr,
        "Monkey Ball",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0307-com.pic", 0, 0x4000, 0x4046de19 },
        },
        "gds-0008",
        &monkeyba_inputs,
		monkeyba_eeprom_dump,
    },
    // Psyvariar 2 - The Will To Fabricate (Japan)
    {
        "psyvar2",
		nullptr,
        "Psyvariar 2 - The Will To Fabricate",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5100-jpn.pic", 0, 0x4000, 0xf37a1dbe },
            // { "psyvar2-default-eeprom.bin", 0, 0x80, 0x9d8661f3, Eeprom },
        },
        "gdl-0024",
		&psyvariar_inputs,
		psyvar2_eeprom_dump,
    },
    // Puyo Pop Fever (World)
    {
        "puyofev",
		nullptr,
        "Puyo Pop Fever (World)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0375-com.pic", 0, 0x4000, 0x52b56b52 },
            // { "puyofev-default-eeprom.bin", 0, 0x80, 0x42e5fd40, Eeprom },
        },
        "gds-0034",
		&puyofev_inputs,
		puyofev_eeprom_dump,
    },
    // Puyo Puyo Fever (Japan)
    {
        "puyofevj",
        "puyofev",
        "Puyo Puyo Fever (Japan)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0375-com.pic", 0, 0x4000, 0x52b56b52 },
            // { "puyofev-default-eeprom.bin", 0, 0x80, 0x42e5fd40, Eeprom },
        },
        "gds-0031",
		&puyofev_inputs,
		puyofev_eeprom_dump,
    },
	// Puyo Puyo Fever (Prototype)
	{
		"puyofevp", // FIXME bootid
		"puyofev",
		"Puyo Puyo Fever (Prototype)",
		0x0c000000,
		0xff9d4d3c,
		"naomi",
		M1,
		ROT0,
		{
				{ "ic17s.bin", 0x01000000, 0x800000, 0xf51ce63b, InterleavedWord },
				{ "ic18s.bin", 0x01000002, 0x800000, 0x7109decc, InterleavedWord },
				{ "ic19s.bin", 0x02000000, 0x800000, 0xa58efa9c, InterleavedWord },
				{ "ic20s.bin", 0x02000002, 0x800000, 0x6dee24b2, InterleavedWord },
				{ "ic21s.bin", 0x03000000, 0x800000, 0x9a0564c2, InterleavedWord },
				{ "ic22s.bin", 0x03000002, 0x800000, 0xdf692133, InterleavedWord },
				{ "ic23s.bin", 0x04000000, 0x800000, 0x61c98256, InterleavedWord },
				{ "ic24s.bin", 0x04000002, 0x800000, 0xc7e8ec24, InterleavedWord },
				{ "ic25s.bin", 0x05000000, 0x800000, 0x2cb47ef5, InterleavedWord },
				{ "ic26s.bin", 0x05000002, 0x800000, 0xf5b477d5, InterleavedWord },
				{ "ic27s.bin", 0x06000000, 0x800000, 0x22c07470, InterleavedWord },
				{ "ic28s.bin", 0x06000002, 0x800000, 0x018233e0, InterleavedWord },
				{ "ic29s.bin", 0x07000000, 0x800000, 0x96101b95, InterleavedWord },
				{ "ic30s.bin", 0x07000002, 0x800000, 0x16dff39b, InterleavedWord },
				{ "ic31s.bin", 0x08000000, 0x800000, 0x510c03dd, InterleavedWord },
				{ "ic32s.bin", 0x08000002, 0x800000, 0xb184e263, InterleavedWord },
				{ "ic33s.bin", 0x09000000, 0x800000, 0xbe2a164b, InterleavedWord },
				{ "ic34s.bin", 0x09000002, 0x800000, 0x01e0a163, InterleavedWord },
				{ "ic35s.bin", 0x0a000000, 0x800000, 0xae0c1caa, InterleavedWord },
				{ "ic36s.bin", 0x0a000002, 0x800000, 0x6de8d5c7, InterleavedWord },
				{ "ic37s.bin", 0x0b000000, 0x800000, 0xfc89454c, InterleavedWord },
				{ "ic38s.bin", 0x0b000002, 0x800000, 0x86954476, InterleavedWord },
	            { "copy",      0x00400000, 0xc00000, 0x0000000, Copy, 0x1000000 },
		},
		nullptr,
		&puyofev_inputs,
		puyofev_eeprom_dump,
	},
    // Quiz Keitai Q mode
    {
        "quizqgd",
		nullptr,
        "Quiz Keitai Q mode",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5090-jpn.pic", 0, 0x4000, 0x141cced2 },
            { "quizqgd-default-eeprom.bin", 0, 0x80, 0x46c10aa3, Eeprom },
        },
        "gdl-0017",
		nullptr,	// TODO
    },
    // Radirgy (Japan, Rev A)
    {
        "radirgy",
		nullptr,
        "Radirgy (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5110-jpn.pic", 0, 0x4000, 0x829d06e2 },
            { "radirgy-default-eeprom.bin", 0, 0x80, 0x8d60a282, Eeprom },
        },
        "gdl-0032a",
		&radirgy_inputs,
    },
    // Radirgy (Japan)
    {
        "radirgyo",
        "radirgy",
        "Radirgy",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5110-jpn.pic", 0, 0x4000, 0x829d06e2 },
            { "radirgy-default-eeprom.bin", 0, 0x80, 0x8d60a282, Eeprom },
        },
        "gdl-0032",
		&radirgy_inputs,
    },
    // Senko No Ronde (Japan, Rev A)
    {
        "senko",
		nullptr,
        "Senko no Ronde (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5107-jpn.pic", 0, 0x4000, 0x6bc3fad0 },
            // { "senko-default-eeprom.bin", 0, 0x80, 0xb3d3be09, Eeprom },
        },
        "gdl-0030a",
		&senko_inputs,
		senko_eeprom_dump,
    },
    // Senko No Ronde (Japan)
    {
        "senkoo",
        "senko",
        "Senko no Ronde",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5107-jpn.pic", 0, 0x4000, 0x6bc3fad0 },
            // { "senkoo-default-eeprom.bin", 0, 0x80, 0xa2203a7f, Eeprom },
        },
        "gdl-0030",
		&senko_inputs,
		senko_eeprom_dump,
    },
    // Senko No Ronde Special (Export, Japan)
    {
        "senkosp",
		nullptr,
        "Senko no Ronde Special",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5123-com.pic", 0, 0x4000, 0x7340df6e },
        },
        "gdl-0038",
		&senkosp_inputs,
		senkosp_eeprom_dump,
    },
    // Street Fighter Zero 3 Upper (Japan)
    {
        "sfz3ugd",
		nullptr,
        "Street Fighter Zero 3 Upper",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5072-com.pic", 0, 0x4000, 0x3238ba01 },
            // { "sfz3ugd-default-eeprom.bin", 0, 0x80, 0x699dd01b, Eeprom },
        },
        "gdl-0002",
        &capcom_6btn_inputs,
		sfz3ugd_eeprom_dump,
    },
    // Shakatto Tambourine (Rev B)
    {
        "shaktam",
		nullptr,
        "Shakatto Tambourine (Rev B)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0299-com.pic", 0, 0x4000, 0x9e1a8971 },
        },
        "gds-0002b",
		&shaktam_inputs,
    },
    // Shakatto Tambourine Cho Powerup Chu (2K1 AUT)
    {
        "shaktamb",
		nullptr,
        "Shakatto Tambourine Cho Powerup Chu (2K1 AUT)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0321-com.pic", 0, 0x4000, 0x81519e71 },
        },
        "gds-0016",
		&shaktam_inputs,
    },
    // Shakatto Tambourine Motto Norinori Shinkyoku Tsuika (2K1 SPR)
    {
        "shaktmsp",
		nullptr,
        "Shakatto Tambourine Motto Norinori Shinkyoku Tsuika (2K1 SPR)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0315-com.pic", 0, 0x4000, 0xc225b08b },
        },
        "gds-0013",
		&shaktam_inputs,
    },
    // Shikigami No Shiro II / The Castle of Shikigami II
    {
        "shikgam2",
		nullptr,
        "Shikigami no Shiro II / The Castle of Shikigami II",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5095-jpn.pic", 0, 0x4000, 0x7c25cb5c },
            { "shikgam2-default-eeprom.bin", 0, 0x80, 0x5fb60e27, Eeprom },
        },
        "gdl-0021",
		&sl2007_inputs,
    },
    // Slashout
    {
        "slashout",
		nullptr,
        "Slashout",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0302-com.pic",  0, 0x4000, 0xfa290329 },
        },
        "gds-0004",
		&slashout_inputs,
		slashout_eeprom_dump
    },
    // Spikers Battle
    {
        "spkrbtl",
		nullptr,
        "Spikers Battle",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0303-com.pic", 0, 0x4000, 0xb42999dd },
        },
        "gds-0005",
		&spkrbtl_inputs,
		spkrbtl_eeprom_dump
    },
    // Sports Jam
    {
        "sprtjam",
		nullptr,
        "Sports Jam",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0300-com.pic", 0, 0x4000, 0x19a97214 },
        },
        "gds-0003",
		&shot12_inputs,
    },
    // Super Shanghai 2005 (Japan, Rev A)
    {
        "ss2005",
		nullptr,
        "Super Shanghai 2005 (Rev A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5108-jpn.pic", 0, 0x4000, 0x4fa7dede },
            { "ss2005-default-eeprom.bin", 0, 0x80, 0x26bd9003, Eeprom },
        },
        "gdl-0031a",
    },
    // Super Shanghai 2005 (Japan)
    {
        "ss2005o",
        "ss2005",
        "Super Shanghai 2005",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5108-jpn.pic", 0, 0x4000, 0x4fa7dede },
            { "ss2005-default-eeprom.bin", 0, 0x80, 0x26bd9003, Eeprom },
        },
        "gdl-0031",
    },
    // Doki Doki Idol Star Seeker
    {
        "starseek",
		nullptr,
        "Doki Doki Idol Star Seeker",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5077-jpn.pic", 0, 0x4000, 0x19f8d4d0 },
        },
        "gdl-0005",
    },
    // Noukone Puzzle Takoron (Japan)
    {
        "takoron",
		nullptr,
        "Noukone Puzzle Takoron",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5127-jpn.pic", 0, 0x4000, 0x870c55eb },
        },
        "gdl-0042",
    },
    // Tetris Kiwamemichi (Japan)
    {
        "tetkiwam",
		nullptr,
        "Tetris Kiwamemichi",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5093-jpn.pic", 0, 0x4000, 0xa61e1e2a },
            { "tetkiwam-default-eeprom.bin", 0, 0x80, 0x843f2a99, Eeprom },
        },
        "gdl-0020",
    },
    // Trigger Heart Exelica Ver.A (Japan)
    {
        "trgheart",
		nullptr,
        "Trigger Heart Exelica (Ver. A)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5121-jpn.pic", 0, 0x4000, 0xcdb9b179 },
            // { "trgheart-default-eeprom.bin", 0, 0x80, 0x7faff313, Eeprom },
        },
        "gdl-0036a",
		&trgheart_inputs,
		trgheart_eeprom_dump,
    },
    // Trigger Heart Exelica (Japan)
    {
        "trghearto",
        "trgheart",
        "Trigger Heart Exelica",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5121-jpn.pic", 0, 0x4000, 0xcdb9b179 },
            // { "trgheart-default-eeprom.bin", 0, 0x80, 0x7faff313, Eeprom },
        },
        "gdl-0036",
		&trgheart_inputs,
		trgheart_eeprom_dump,
    },
    // Trizeal (Japan)
    {
        "trizeal",
		nullptr,
        "Trizeal",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5103-jpn.pic", 0, 0x4000, 0x93feaff4 },
            // { "trizeal-default-eeprom.bin", 0, 0x80, 0xac0847ce, Eeprom },
        },
        "gdl-0026",
		&sl2007_inputs,
		trizeal_eeprom_dump,
    },
    // Under Defeat (Japan)
    {
        "undefeat",
		nullptr,
        "Under Defeat",
        0x4000,
        0,
        "naomi",
        GD,
        ROT270,
        {
            { "317-5117-jpn.pic", 0, 0x4000, 0x61e65ca8 },
			// { "undefeat-default-eeprom.bin", 0, 0x80, 0x9d2b071c, Eeprom },
        },
        "gdl-0035",
		&psyvariar_inputs,
		undefeat_eeprom_dump,
    },
    // Usagi - Yamashiro Mahjong Hen (Japan)
    {
        "usagiym",
		nullptr,
        "Usagi - Yamashiro Mahjong Hen",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-5096-jpn.pic", 0, 0x4000, 0x2d16887b },
            { "usagiym-default-eeprom.bin", 0, 0x80, 0x1fbdf0ca, Eeprom },
        },
        "gdl-0022",
    },
    // Virtua Athletics / Virtua Athlete
    {
        "vathlete",
		nullptr,
        "Virtua Athletics / Virtua Athlete",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0330-com.pic", 0, 0x4000, 0x33ccf2d1 },
        },
        "gds-0019",
		&vathlete_inputs,
    },
    // Virtua Tennis 2 / Power Smash 2 (Rev A)
    {
        "vtennis2",
		nullptr,
        "Virtua Tennis 2 / Power Smash 2",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0318-com.pic", 0, 0x4000, 0x83de4047 },
        },
        "gds-0015a",
        &shot12_inputs,
		vtennis2_eeprom_dump,
    },
    // Virtua Tennis / Power Smash
    {
        "vtennisg",
		nullptr,
        "Virtua Tennis / Power Smash",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0312-com.pic", 0, 0x4000, 0x7213684e },
        },
        "gds-0011",
        &shot12_inputs,
		vtennisg_eeprom_dump,
    },
    // World Series Baseball / Super Major League
    {
        "wsbbgd",
		nullptr,
        "World Series Baseball / Super Major League",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0309-com.pic", 0, 0x4000, 0x62d760bf },
        },
        "gds-0010",
		&wsbb_inputs,
    },
    // Sega Yonin Uchi Mahjong MJ (セガ四人打ち麻雀MJ), "Sega The 4Players Mah-Jong"
    // uses CRP-1231 card RW connected via 838-13661 RS422/RS232C converter BD, and 2x JVS I/O boards (or one special I/O ?).
    {
        "mj1",
		nullptr,
        "Sega Yonin Uchi Mahjong MJ (Update Disc Ver.1.008, Japan) (CDP-10002B)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0352-jpn.pic", 0, 0x4000, 0xc2c45f9c },
        },
        "cdp-10002b",
    },
	// World Club Champion Football Serie A 2001-2002 Ver.2 (Japan) (CDP-10001C)
	{
		"wccf116",
        nullptr,
        "World Club Champion Football Serie A 2001-2002",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0329-jpn.pic", 0, 0x4000, 0x097f5f92 },
        },
        "cdp-10001c",
	},
	// World Club Champion Football Serie A 2001-2002 DIMM FIRM Ver.3.03 (CDP-10003)
	{
		"wccf1dup",
        nullptr,
        "World Club Champion Football Serie A 2001-2002 DIMM FIRM Ver.3.03",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0329-jpn.pic", 0, 0x4000, 0x097f5f92 },
        },
        "cdp-10003",
	},
	// World Club Champion Football Serie A 2002-2003 Ver.2.12 (Italy) (CDV-10002)
	{
		"wccf212e",
        nullptr,
        "World Club Champion Football Serie A 2002-2003 (Italy)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0369-exp.pic", 0, 0x4000, 0xadf2d113 },
	        // 837-14229 "IC BD FLAT READER"
	        // SH4-based camera sensor board connected to MAPLE CN7
        },
        "cdv-10002",
	},
	// World Club Champion Football Serie A 2002-2003 Ver.2.34 (Japan) (CDV-10008)
	{
		"wccf234j",
        nullptr,
        "World Club Champion Football Serie A 2002-2003 (Japan)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0369-jpn.pic", 0, 0x4000, 0xfb3672ba },
        },
        "cdv-10008",
	},
	// World Club Champion Football European Clubs 2004-2005 (Asia) (CDV-10013)
	{
		"wccf310j",
        nullptr,
        "World Club Champion Football European Clubs 2004-2005 (Asia)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0419-jpn.pic", 0, 0x4000, 0x04fae86b },
        },
        "cdv-10013",
	},
	// World Club Champion Football European Clubs 2004-2005 Ver.1.1 (Export) (CDV-10015)
	{
		"wccf331e",
        "wccf322e",
        "World Club Champion Football European Clubs 2004-2005 v1.1 (Export)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0419-exp.pic", 0, 0x4000, 0x3f5e1445 },
        },
        "cdv-10015",
	},
	// World Club Champion Football European Clubs 2004-2005 Ver.3.22 (Export) (CDV-10015P)
	{
		"wccf322e",
        nullptr,
        "World Club Champion Football European Clubs 2004-2005 (Export)",
        0x4000,
        0,
        "naomi",
        GD,
        ROT0,
        {
            { "317-0419-exp.pic", 0, 0x4000, 0x3f5e1445 },
        },
        "cdv-10015p",
	},
	// World Club Champion Football European Clubs 2004-2005 Ver.1.1 (Japan) (CDV-10020)
	{
		"wccf331j",
		"wccf341j",
		"World Club Champion Football European Clubs 2004-2005 v1.1 (Japan)",
		0x4000,
		0,
		"naomi",
		GD,
		ROT0,
		{
			{ "317-unk-jpn.pic", 0, 0x4000, 0xa4abd76b },
		},
		"cdv-10020",
	},
	// World Club Champion Football European Clubs 2004-2005 Ver.1.2 (Japan) (CDV-10021)
	{
		"wccf341j",
		nullptr,
		"World Club Champion Football European Clubs 2004-2005 (Japan)",
		0x4000,
		0,
		"naomi",
		GD,
		ROT0,
		{
			{ "317-unk-jpn.pic", 0, 0x4000, 0xa4abd76b },
		},
		"cdv-10021",
	},
	// World Club Champion Football European Clubs 2005-2006 (Japan) (CDV-10025)
	{
		"wccf400j",
		nullptr,
		"World Club Champion Football European Clubs 2005-2006 (Japan)",
		0x4000,
		0,
		"naomi",
		GD,
		ROT0,
		{
			{ "317-0456-jpn.pic", 0, 0x4000, 0xcf3bd834 },
		},
		"cdv-10025",
	},
	// World Club Champion Football European Clubs 2005-2006 (Export) (CDV-10027)
	{
		"wccf420e",
		nullptr,
		"World Club Champion Football European Clubs 2005-2006 (Export)",
		0x4000,
		0,
		"naomi",
		GD,
		ROT0,
		{
			{ "317-0456-exp.pic", 0, 0x4000, 0xfb7dd592 },
		},
		"cdv-10027",
	},

    // AtomisWave Roms

    // Animal Basket (24 Jan 2005)
    {
        "anmlbskt",
        nullptr,
        "Animal Basket",
        0x4000000,
        0x45,
        "awbios",
        AW,
        ROT270,
        {
            { "vm2001f01.u3",  0x0000000, 0x800000, 0x4fb33380 },
            { "vm2001f01.u4",  0x1000000, 0x800000, 0x7cb2e7c3 },
            { "vm2001f01.u2",  0x1800000, 0x800000, 0x386070a1 },
            { "vm2001f01.u15", 0x2000000, 0x800000, 0x2bb1be28 },
        }
    },
    // Animal Basket (19 Jan 2005)
    {
        "anmlbskta",
        "anmlbskt",
        "Animal Basket (19 Jan 2005)",
        0x4000000,
        0x45,
        "awbios",
        AW,
        ROT270,
        {
            { "u3",  0x0000000, 0x1000000, 0xcd082af3 },
            { "u1",  0x1000000, 0x1000000, 0x4a2a01d3 },
            { "u4",  0x2000000, 0x1000000, 0x646e9773 },
            { "u2",  0x3000000, 0x1000000, 0xb9162d97 },
            // U14-U17 not populated
        }
    },
    // Sega Bass Fishing Challenge (Version A)
    {
        "basschal",
        nullptr,
        "Sega Bass Fishing Challenge (Ver. A)",
        0x8000000,
        0x2a,
        "awbios",
        AW,
        ROT0,
        {
            { "vera.u3",      0x00000000, 0x01000000, 0x8cbec9d7 },
            { "vera.u1",      0x01000000, 0x01000000, 0xcfef27e5 },
            { "vera.u4",      0x02000000, 0x01000000, 0xbd1f13aa },
            { "vera.u2",      0x03000000, 0x01000000, 0x0a463c37 },
            { "vera.u15",     0x04000000, 0x01000000, 0xe588afd1 },
            { "vera.u17",     0x05000000, 0x01000000, 0xd78389a4 },
            { "vera.u14",     0x06000000, 0x01000000, 0x35df044f },
            { "vera.u16",     0x07000000, 0x01000000, 0x3590072d },
        },
		nullptr,
		&basschal_inputs,
    },
    // Sega Bass Fishing Challenge
    {
        "basschalo",
        "basschal",
        "Sega Bass Fishing Challenge",
        0x8000000,
        0x2a,
        "awbios",
        AW,
        ROT0,
        {
            { "610-0811.u3",  0x00000000, 0x01000000, 0xef31abe7 },
            { "610-0811.u1",  0x01000000, 0x01000000, 0x44c3cf90 },
            { "vera.u4",      0x02000000, 0x01000000, 0xbd1f13aa },
            { "610-0811.u2",  0x03000000, 0x01000000, 0x1c61ed69 },
            { "610-0811.u15", 0x04000000, 0x01000000, 0xe8f02238 },
            { "610-0811.u17", 0x05000000, 0x01000000, 0xdb799f5a },
            { "610-0811.u14", 0x06000000, 0x01000000, 0xf2769383 },
            { "vera.u16",     0x07000000, 0x01000000, 0x3590072d },
        },
		nullptr,
		&basschal_inputs,
    },
    // Block Pong-Pong
    {
        "blokpong",
        nullptr,
        "Block Pong-Pong",
        0x4000000,
        0x45,
        "awbios",
        AW,
        ROT270,
        {
            { "u3", 0x0000000, 0x1000000, 0xdebaf8bd },
            { "u1", 0x1000000, 0x1000000, 0xca097a3f },
            { "u4", 0x2000000, 0x1000000, 0xd235dd29 },
			//{ "u2",  0x3000000, 0x1000000, 0xb9162d97 }, // garbage data not used by this game, match anmlbskta U2
            // U14-U17 not populated
        },
        nullptr,
        &blokpong_inputs,
    },
    // Sega Clay Challenge
    {
        "claychal",
		nullptr,
        "Sega Clay Challenge",
        0x8000100,
        0x2a,
        "awbios",
        AW,
        ROT0,
        {
            { "608-2161.u3",  0x0000000, 0x1000100, 0x5bb65194 },
            { "608-2161.u1",  0x1000000, 0x1000100, 0x526fc1af },
            { "608-2161.u4",  0x2000000, 0x1000100, 0x55f4e762 },
            { "608-2161.u2",  0x3000000, 0x1000100, 0xc40dae68 },
            { "608-2161.u15", 0x4000000, 0x1000100, 0xb82dcb0a },
            { "608-2161.u17", 0x5000000, 0x1000100, 0x2f973eb4 },
            { "608-2161.u14", 0x6000000, 0x1000100, 0x2e7d966f },
            { "608-2161.u16", 0x7000000, 0x1000100, 0x14f8ca87 },
        },
		nullptr,
		&aw_lightgun_inputs,
    },
    // Demolish Fist
    {
        "demofist",
        nullptr,
        "Demolish Fist",
        0x8000000,
        0x90,
        "awbios",
        AW,
        ROT0,
        {
            { "ax0601p01.ic18", 0x0000000, 0x0800000, 0x0efb38ad },
            { "ax0601m01.ic11", 0x1000000, 0x1000000, 0x12fda2c7 },
            { "ax0602m01.ic12", 0x2000000, 0x1000000, 0xaea61fdf },
            { "ax0603m01.ic13", 0x3000000, 0x1000000, 0xd5879d35 },
            { "ax0604m01.ic14", 0x4000000, 0x1000000, 0xa7b09048 },
            { "ax0605m01.ic15", 0x5000000, 0x1000000, 0x18d8437e },
            { "ax0606m01.ic16", 0x6000000, 0x1000000, 0x42c81617 },
            { "ax0607m01.ic17", 0x7000000, 0x1000000, 0x96e5aa84 },
        },
        nullptr,
        &demofist_inputs,
    },
    // Dirty Pigskin Football
    {
        "dirtypig",
		nullptr,
        "Dirty Pigskin Football",
        0x8000000,
        0x2a,
        "awbios",
        AW,
        ROT0,
        {
            { "695-0014.u3",  0x0000000, 0x1000000, 0x9fdd7d07 },
            { "695-0014.u1",  0x1000000, 0x1000000, 0xa91d2fcb },
            { "695-0014.u4",  0x2000000, 0x1000000, 0x3342f237 },
            { "695-0014.u2",  0x3000000, 0x1000000, 0x4d82152f },
            { "695-0014.u15", 0x4000000, 0x1000000, 0xd239a549 },
            { "695-0014.u17", 0x5000000, 0x1000000, 0x16bb5992 },
            { "695-0014.u14", 0x6000000, 0x1000000, 0x55470242 },
            { "695-0014.u16", 0x7000000, 0x1000000, 0x730180a4 },
        },
		nullptr,
		&aw_shot123_inputs,
    },
    // Dolphin Blue
    {
        "dolphin",
        nullptr,
        "Dolphin Blue",
        0x8000000,
        0x40,
        "awbios",
        AW,
        ROT0,
        {
            { "ax0401p01.ic18", 0x0000000, 0x0800000, 0x195d6328 },
            { "ax0401m01.ic11", 0x1000000, 0x1000000, 0x5e5dca57 },
            { "ax0402m01.ic12", 0x2000000, 0x1000000, 0x77dd4771 },
            { "ax0403m01.ic13", 0x3000000, 0x1000000, 0x911d0674 },
            { "ax0404m01.ic14", 0x4000000, 0x1000000, 0xf82a4ca3 },
            { "ax0405m01.ic15", 0x5000000, 0x1000000, 0xb88298d7 },
        },
        nullptr,
        &dolphin_inputs,
    },
    // Fist Of The North Star
    {
        "fotns",
        nullptr,
        "Fist Of The North Star",
        0x8000000,
        0xc2,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1901p01.ic18", 0x0000000, 0x0800000, 0xa06998b0 },
            { "ax1901m01.ic11", 0x1000000, 0x1000000, 0xff5a1642 },
            { "ax1902m01.ic12", 0x2000000, 0x1000000, 0xd9aae8a9 },
            { "ax1903m01.ic13", 0x3000000, 0x1000000, 0x1711b23d },
            { "ax1904m01.ic14", 0x4000000, 0x1000000, 0x443bfb26 },
            { "ax1905m01.ic15", 0x5000000, 0x1000000, 0xeb1cada0 },
            { "ax1906m01.ic16", 0x6000000, 0x1000000, 0xfe6da168 },
            { "ax1907m01.ic17", 0x7000000, 0x1000000, 0x9d3a0520 },
        },
		nullptr,
		&fotns_inputs,
    },
    // Faster Than Speed
    {
        "ftspeed",
		nullptr,
        "Faster Than Speed",
        0x9000000,
        0x6b,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1701p01.ic18", 0x0000000, 0x0800000, 0x480cade7 },
            { "ax1701m01.ic11", 0x1000000, 0x1000000, 0x7dcdc784 },
            { "ax1702m01.ic12", 0x2000000, 0x1000000, 0x06c9bf85 },
            { "ax1703m01.ic13", 0x3000000, 0x1000000, 0x8f8e0224 },
            { "ax1704m01.ic14", 0x4000000, 0x1000000, 0xfbb4bb16 },
            { "ax1705m01.ic15", 0x5000000, 0x1000000, 0x996f68e1 },
            { "ax1706m01.ic16", 0x6000000, 0x1000000, 0x804b2eb2 },
        },
		nullptr,
        &ftspeed_inputs,
    },
    // Guilty Gear Isuka
    {
        "ggisuka",
		nullptr,
        "Guilty Gear Isuka",
        0x9000000,
        0xed,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1201p01.ic18", 0x0000000, 0x0800000, 0x0a78d52c },
            { "ax1201m01.ic10", 0x0800000, 0x1000000, 0xdf96ce30 },
            { "ax1202m01.ic11", 0x1000000, 0x1000000, 0xdfc6fd67 },
            { "ax1203m01.ic12", 0x2000000, 0x1000000, 0xbf623df9 },
            { "ax1204m01.ic13", 0x3000000, 0x1000000, 0xc80c3930 },
            { "ax1205m01.ic14", 0x4000000, 0x1000000, 0xe99a269d },
            { "ax1206m01.ic15", 0x5000000, 0x1000000, 0x807ab795 },
            { "ax1207m01.ic16", 0x6000000, 0x1000000, 0x6636d1b8 },
            { "ax1208m01.ic17", 0x7000000, 0x1000000, 0x38bda476 },
        },
        nullptr,
		&guilty_gear_aw_inputs,
    },
    // Guilty Gear X ver. 1.5
    {
        "ggx15",
		nullptr,
        "Guilty Gear X ver. 1.5",
        0x8000000,
        0xc9,
        "awbios",
        AW,
        ROT0,
        {
            { "ax0801p01.ic18", 0x0000000, 0x0800000, 0xd920c6bb },
            { "ax0801m01.ic11", 0x1000000, 0x1000000, 0x61879b2d },
            { "ax0802m01.ic12", 0x2000000, 0x1000000, 0xc0ff124d },
            { "ax0803m01.ic13", 0x3000000, 0x1000000, 0x4400c89a },
            { "ax0804m01.ic14", 0x4000000, 0x1000000, 0x70f58ab4 },
            { "ax0805m01.ic15", 0x5000000, 0x1000000, 0x72740e45 },
            { "ax0806m01.ic16", 0x6000000, 0x1000000, 0x3bf8ecba },
            { "ax0807m01.ic17", 0x7000000, 0x1000000, 0xe397dd79 },
        },
		nullptr,
        &ggx15_inputs,
    },
    // The King of Fighters Neowave
    {
        "kofnw",
		nullptr,
        "The King of Fighters Neowave",
        0x8000000,
        0x99,
        "awbios",
        AW,
        ROT0,
        {
            { "ax2201en_p01.ic18", 0x0000000, 0x0800000, 0x27aab918 },
            { "ax2201m01.ic11",    0x1000000, 0x1000000, 0x22ea665b },
            { "ax2202m01.ic12",    0x2000000, 0x1000000, 0x7fad1bea },
            { "ax2203m01.ic13",    0x3000000, 0x1000000, 0x78986ca4 },
            { "ax2204m01.ic14",    0x4000000, 0x1000000, 0x6ffbeb04 },
            { "ax2205m01.ic15",    0x5000000, 0x1000000, 0x2851b791 },
            { "ax2206m01.ic16",    0x6000000, 0x1000000, 0xe53eb965 },
        },
		nullptr,
        &kofnw_inputs,
    },
    // The King of Fighters Neowave (Japan)
    {
        "kofnwj",
        "kofnw",
        "The King of Fighters Neowave (Japan)",
        0x8000000,
        0x99,
        "awbios",
        AW,
        ROT0,
        {
            { "ax2201jp_p01.ic18", 0x0000000, 0x0800000, 0xecc4a5c7 },
            // these are taken from the above set, game *seems* to work fine with these
            { "ax2201m01.ic11",    0x1000000, 0x1000000, 0x22ea665b },
            { "ax2202m01.ic12",    0x2000000, 0x1000000, 0x7fad1bea },
            { "ax2203m01.ic13",    0x3000000, 0x1000000, 0x78986ca4 },
            { "ax2204m01.ic14",    0x4000000, 0x1000000, 0x6ffbeb04 },
            { "ax2205m01.ic15",    0x5000000, 0x1000000, 0x2851b791 },
            { "ax2206m01.ic16",    0x6000000, 0x1000000, 0xe53eb965 },
        },
		nullptr,
        &kofnw_inputs,
    },
    // The King of Fighters XI
    {
        "kofxi",
		nullptr,
        "The King of Fighters XI",
        0x14000000,
        0xd3,
        "awbios",
        AW,
        ROT0,
        {
            { "ax3201p01.fmem1", 0x00000000, 0x0800000, 0x6dbdd71b },
            { "ax3201m01.mrom1", 0x02000000, 0x2000000, 0x7f9d6af9},
            { "ax3202m01.mrom2", 0x04000000, 0x2000000, 0x1ae40afa },
            { "ax3203m01.mrom3", 0x06000000, 0x2000000, 0x8c5e3bfd },
            { "ax3204m01.mrom4", 0x0a000000, 0x2000000, 0xba97f80c },
            { "ax3205m01.mrom5", 0x0c000000, 0x2000000, 0x3c747067 },
            { "ax3206m01.mrom6", 0x0e000000, 0x2000000, 0xcb81e5f5 },
            { "ax3207m01.mrom7", 0x12000000, 0x2000000, 0x164f6329 },
        },
		nullptr,
        &kofxi_inputs,
    },
    // Knights of Valour - The Seven Spirits
    {
        "kov7sprt",
		nullptr,
        "Knights of Valour - The Seven Spirits",
        0x8000000,
        0x35,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1301p01.ic18", 0x0000000, 0x0800000, 0x6833a334 },
            { "ax1301m01.ic11", 0x1000000, 0x1000000, 0x58ae7ca1 },
            { "ax1301m02.ic12", 0x2000000, 0x1000000, 0x871ea03f },
            { "ax1301m03.ic13", 0x3000000, 0x1000000, 0xabc328bc },
            { "ax1301m04.ic14", 0x4000000, 0x1000000, 0x25a176d1 },
            { "ax1301m05.ic15", 0x5000000, 0x1000000, 0xe6573a93 },
            { "ax1301m06.ic16", 0x6000000, 0x1000000, 0xcb8cacb4 },
            { "ax1301m07.ic17", 0x7000000, 0x1000000, 0x0ca92213 },
        },
		nullptr,
        &kov7sprt_inputs,
    },
    // Maximum Speed
    {
        "maxspeed",
		nullptr,
        "Maximum Speed",
        0x9000000,
        0x55,
        "awbios",
        AW,
        ROT0,
        {
            { "ax0501p01.ic18", 0x0000000, 0x0800000, 0xe1651867 },
            { "ax0501m01.ic11", 0x1000000, 0x1000000, 0x4a847a59 },
            { "ax0502m01.ic12", 0x2000000, 0x1000000, 0x2580237f },
            { "ax0503m01.ic13", 0x3000000, 0x1000000, 0xe5a3766b },
            { "ax0504m01.ic14", 0x4000000, 0x1000000, 0x7955b55a },
            { "ax0505m01.ic15", 0x5000000, 0x1000000, 0xe8ccc660 },
        },
		nullptr,
        &maxspeed_inputs
    },
    // Metal Slug 6
    {
        "mslug6",
		nullptr,
        "Metal Slug 6",
        0xc000000,
        0x82,
        "awbios",
        AW,
        ROT0,
        {
            { "ax3001p01.fmem1", 0x0000000, 0x0800000, 0xaf67dbce },
            { "ax3001m01.mrom1", 0x2000000, 0x2000000, 0xe56417ee },
            { "ax3002m01.mrom2", 0x4000000, 0x2000000, 0x1be3bbc1 },
            { "ax3003m01.mrom3", 0x6000000, 0x2000000, 0x4fe37370 },
            { "ax3004m01.mrom4", 0xa000000, 0x2000000, 0x2f4c4c6f },
        },
		nullptr,
		&mslug6_inputs,
    },
    // NeoGeo Battle Coliseum
    {
        "ngbc",
		nullptr,
        "NeoGeo Battle Coliseum",
        0x14000000,
        0xa0,
        "awbios",
        AW,
        ROT0,
        {
            { "ax3301en_p01.fmem1", 0x00000000, 0x0800000, 0xf7e24e67 },
            { "ax3301m01.mrom1",    0x02000000, 0x2000000, 0xe6013de9 },
            { "ax3302m01.mrom2",    0x04000000, 0x2000000, 0xf7cfef6c },
            { "ax3303m01.mrom3",    0x06000000, 0x2000000, 0x0cdf8647 },
            { "ax3304m01.mrom4",    0x0a000000, 0x2000000, 0x2f031db0 },
            { "ax3305m01.mrom5",    0x0c000000, 0x2000000, 0xf6668aaa },
            { "ax3306m01.mrom6",    0x0e000000, 0x2000000, 0x5cf32fbd },
            { "ax3307m01.mrom7",    0x12000000, 0x2000000, 0x26d9da53 },
        },
        nullptr,
        &ngbc_inputs,
    },
    // NeoGeo Battle Coliseum (Japan)
    {
        "ngbcj",
        "ngbc",
        "NeoGeo Battle Coliseum (Japan)",
        0x14000000,
        0xa0,
        "awbios",
        AW,
        ROT0,
        {
            { "ax3301p01.fmem1", 0x00000000, 0x0800000, 0x6dd78275 },
            { "ax3301m01.mrom1", 0x02000000, 0x2000000, 0xe6013de9 },
            { "ax3302m01.mrom2", 0x04000000, 0x2000000, 0xf7cfef6c },
            { "ax3303m01.mrom3", 0x06000000, 0x2000000, 0x0cdf8647 },
            { "ax3304m01.mrom4", 0x0a000000, 0x2000000, 0x2f031db0 },
            { "ax3305m01.mrom5", 0x0c000000, 0x2000000, 0xf6668aaa },
            { "ax3306m01.mrom6", 0x0e000000, 0x2000000, 0x5cf32fbd },
            { "ax3307m01.mrom7", 0x12000000, 0x2000000, 0x26d9da53 },
        },
		nullptr,
        &ngbc_inputs,
    },
    // Ranger Mission
    {
        "rangrmsn",
        nullptr,
        "Ranger Mission",
        0x8000000,
        0x88,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1601p01.ic18", 0x0000000, 0x0800000, 0x00a74fbb },
            { "ax1601m01.ic11", 0x1000000, 0x1000000, 0xf34eed33 },
            { "ax1602m01.ic12", 0x2000000, 0x1000000, 0xa7d59efb },
            { "ax1603m01.ic13", 0x3000000, 0x1000000, 0x7c0aa241 },
            { "ax1604m01.ic14", 0x4000000, 0x1000000, 0xd2369144 },
            { "ax1605m01.ic15", 0x5000000, 0x1000000, 0x0c11c1f9 },
        },
		nullptr,
		&aw_lightgun_inputs,
    },
    // The Rumble Fish
    {
        "rumblef",
        nullptr,
        "The Rumble Fish",
        0x8000000,
        0xaa,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1801p01.ic18", 0x0000000, 0x0800000, 0x2f7fb163 },
            { "ax1801m01.ic11", 0x1000000, 0x1000000, 0xc38aa61c },
            { "ax1802m01.ic12", 0x2000000, 0x1000000, 0x72e0ebc8 },
            { "ax1803m01.ic13", 0x3000000, 0x1000000, 0xd0f59d98 },
            { "ax1804m01.ic14", 0x4000000, 0x1000000, 0x15595cba },
            { "ax1805m01.ic15", 0x5000000, 0x1000000, 0x3d3f8e0d },
            { "ax1806m01.ic16", 0x6000000, 0x1000000, 0xac2751bb },
            { "ax1807m01.ic17", 0x7000000, 0x1000000, 0x3b2fbdb0 },
        },
		nullptr,
		&rumblef_inputs,
    },
    // The Rumble Fish (prototype)
    {
        "rumblefp",
        "rumblef",
        "The Rumble Fish (prototype)",
        0x8000000,
        0x25,
        "awbios",
        AW,
        ROT0,
        {
            { "ic12", 0x00000000, 0x00800000, 0x79866072 },
            { "ic13", 0x00800000, 0x00800000, 0x5630bc83 },
            { "ic14", 0x01000000, 0x00800000, 0xbcd49846 },
            { "ic15", 0x01800000, 0x00800000, 0x61257cfb },
            { "ic16", 0x02000000, 0x00800000, 0xc2eb7c61 },
            { "ic17", 0x02800000, 0x00800000, 0xdcf673d3 },
            { "ic18", 0x03000000, 0x00800000, 0x72c066bb },
            { "ic19", 0x03800000, 0x00800000, 0xb20bf301 },
            { "ic20", 0x04000000, 0x00800000, 0xd27e7393 },
            { "ic21", 0x04800000, 0x00800000, 0xc2da1ecf },
            { "ic22", 0x05000000, 0x00800000, 0x730e0e1c },
            { "ic23", 0x05800000, 0x00800000, 0xd93afcac },
            { "ic24", 0x06000000, 0x00800000, 0x262d97b9 },
            { "ic25", 0x06800000, 0x00800000, 0xe45cf169 },
            { "ic26", 0x07000000, 0x00800000, 0x6421720d },
            // IC27 populated, empty
        },
		nullptr,
		&rumblef_inputs,
    },
    // The Rumble Fish 2
    {
        "rumblef2",
		nullptr,
        "The Rumble Fish 2",
        0xe000000,
        0x07,
        "awbios",
        AW,
        ROT0,
        {
            { "ax3401p01.fmem1", 0x0000000, 0x0800000, 0xa33601cf },
            { "ax3401m01.mrom1", 0x2000000, 0x2000000, 0x60894d4c },
            { "ax3402m01.mrom2", 0x4000000, 0x2000000, 0xe4224cc9 },
            { "ax3403m01.mrom3", 0x6000000, 0x2000000, 0x081c0edb },
            { "ax3404m01.mrom4", 0xa000000, 0x2000000, 0xa426b443 },
            { "ax3405m01.mrom5", 0xc000000, 0x2000000, 0x4766ce56 },
        },
		nullptr,
		&rumblef_inputs,
    },
    // The Rumble Fish 2 (prototype)
    {
        "rumblf2p",
        "rumblef2",
        "The Rumble Fish 2 (prototype)",
        0xe000000,
        0x25,
        "awbios",
        AW,
        ROT0,
        {
            { "ic12", 0x00000000, 0x00800000, 0x1a0e74ab },
            { "ic13", 0x00800000, 0x00800000, 0x5630bc83 },
            { "ic14", 0x01000000, 0x00800000, 0x7fcfc59c },
            { "ic15", 0x01800000, 0x00800000, 0xeee00692 },
            { "ic16", 0x02000000, 0x00800000, 0xcd029db9 },
            { "ic17", 0x02800000, 0x00800000, 0x223a5b58 },
            { "ic18", 0x03000000, 0x00800000, 0x5e2d2f67 },
            { "ic19", 0x03800000, 0x00800000, 0x3cfb2adc },
            { "ic20", 0x04000000, 0x00800000, 0x2c216a05 },
            { "ic21", 0x04800000, 0x00800000, 0x79540865 },
            { "ic22", 0x05000000, 0x00800000, 0xc91d95a0 },
            { "ic23", 0x05800000, 0x00800000, 0x5c39ca18 },
            { "ic24", 0x06000000, 0x00800000, 0x858d2775 },
            { "ic25", 0x06800000, 0x00800000, 0x975d35fb },
            { "ic26", 0x07000000, 0x00800000, 0xff9a2c4c },
            // IC27 populated, empty
        },
		nullptr,
		&rumblef_inputs,
    },
    // Net Select: Salaryman Kintaro
    {
        "salmankt",
		nullptr,
        "Net Select: Salaryman Kintaro",
        0x9000000,
        0x77,
        "awbios",
        AW,
        ROT0,
        {
            { "ax1401p01.ic18", 0x0000000, 0x0800000, 0x28d779e0 },
            { "ax1401m01.ic11", 0x1000000, 0x1000000, 0xfd7af845 },
            { "ax1402m01.ic12", 0x2000000, 0x1000000, 0xf6006f85 },
            { "ax1403m01.ic13", 0x3000000, 0x1000000, 0x074f7c4b },
            { "ax1404m01.ic14", 0x4000000, 0x1000000, 0xaf4e3829 },
            { "ax1405m01.ic15", 0x5000000, 0x1000000, 0xb548446f },
            { "ax1406m01.ic16", 0x6000000, 0x1000000, 0x437673e6 },
            { "ax1407m01.ic17", 0x7000000, 0x1000000, 0x6b6acc0a },
        },
		nullptr,
		nullptr,	// TODO
    },
    // Samurai Shodown VI / Samurai Spirits Tenkaichi Kenkakuden
    {
        "samsptk",
		nullptr,
        "Samurai Shodown VI",
        0x14000000,
        0x1d,
        "awbios",
        AW,
        ROT0,
        {
            { "ax2901p01.fmem1", 0x00000000, 0x0800000, 0x58e0030b },
            { "ax2901m01.mrom1", 0x02000000, 0x2000000, 0xdbbbd90d },
            { "ax2902m01.mrom2", 0x04000000, 0x2000000, 0xa3bd7890 },
            { "ax2903m01.mrom3", 0x06000000, 0x2000000, 0x56f50fdd },
            { "ax2904m01.mrom4", 0x0a000000, 0x2000000, 0x8a3ae175 },
            { "ax2905m01.mrom5", 0x0c000000, 0x2000000, 0x429877ba },
            { "ax2906m01.mrom6", 0x0e000000, 0x2000000, 0xcb95298d },
            { "ax2907m01.mrom7", 0x12000000, 0x2000000, 0x48015081 },
        },
		nullptr,
        &samsptk_inputs,
    },
    // Sports Shooting USA
    {
        "sprtshot",
        nullptr,
        "Sports Shooting USA",
        0x8000000,
        0x64,
        "awbios",
        AW,
        ROT0,
        {
            { "ax0101p01.ic18", 0x0000000, 0x0800000, 0xb3642b5d },
            { "ax0101m01.ic11", 0x1000000, 0x1000000, 0x1e39184d },
            { "ax0102m01.ic12", 0x2000000, 0x1000000, 0x700764d1 },
            { "ax0103m01.ic13", 0x3000000, 0x1000000, 0x6144e7a8 },
            { "ax0104m01.ic14", 0x4000000, 0x1000000, 0xccb72150 },
        },
		nullptr,
		&aw_lightgun_inputs,	// PUMP is mercury sensor when gun is pointing down
    },
    // Sushi Bar
    {
        "sushibar",
		nullptr,
        "Sushi Bar",
        0x8000000,
        0x25,
        "awbios",
        AW,
        ROT0,
        {
            { "ic12", 0x00000000, 0x00800000, 0x06a2ed58 },
			// IC 13 populated, empty
            { "ic14", 0x01000000, 0x00800000, 0x4860f944 },
            { "ic15", 0x01800000, 0x00800000, 0x7113506c },
            { "ic16", 0x02000000, 0x00800000, 0x77e8e39e },
            { "ic17", 0x02800000, 0x00800000, 0x0eba54ea },
            { "ic18", 0x03000000, 0x00800000, 0xb9957c76 },
        }
    },
    // Net Select Horse Racing: Victory Furlong"
    {
        "vfurlong",
        nullptr,
        "Net Select Horse Racing: Victory Furlong",
        0x9000000,
        0xdb,
        "awbios",
        AW,
        ROT0,
        {
            { "ax2001p01.ic18", 0x0000000, 0x0800000, 0x17ea9aa9 },
			// same as above except for Customer ID, included for reference
			// { "ax2001p01_alt.ic18", 0x0000000, 0x0800000, 0x845399dd },
            { "ax2001m01.ic11", 0x1000000, 0x1000000, 0x64460b24 },
            { "ax2002m01.ic12", 0x2000000, 0x1000000, 0xd4da357f },
            { "ax2003m01.ic13", 0x3000000, 0x1000000, 0xaa1e1246 },
            { "ax2004m01.ic14", 0x4000000, 0x1000000, 0x4d555d7c },
            { "ax2005m01.ic15", 0x5000000, 0x1000000, 0x785208e2 },
            { "ax2006m01.ic16", 0x6000000, 0x1000000, 0x8134ec55 },
            { "ax2007m01.ic17", 0x7000000, 0x1000000, 0xd0557e8a },
        },
    },
    // WaiWai Drive
    {
        "waidrive",
		nullptr,
        "WaiWai Drive",
        0x4000000,
        0x45,
        "awbios",
        AW,
        ROT270,
        {
            { "u3", 0x0000000, 0x1000000, 0x7acfb499 },
            { "u1", 0x1000000, 0x1000000, 0xb3c1c3bb },
        }
    },
    // Extreme Hunting
    {
        "xtrmhunt",
        nullptr,
        "Extreme Hunting",
        0x8000000,
        0xe4,
        "awbios",
        AW,
        ROT0,
        {
            { "ax2401p01.ic18", 0x0000000, 0x0800000, 0x8e2a11f5 },
            { "ax2401m01.ic11", 0x1000000, 0x1000000, 0x76dbc286 },
            { "ax2402m01.ic12", 0x2000000, 0x1000000, 0xcd590ea2 },
            { "ax2403m01.ic13", 0x3000000, 0x1000000, 0x06f62eb5 },
            { "ax2404m01.ic14", 0x4000000, 0x1000000, 0x759ef5cb },
            { "ax2405m01.ic15", 0x5000000, 0x1000000, 0x940d77f1 },
            { "ax2406m01.ic16", 0x6000000, 0x1000000, 0xcbcf2c5d },
        },
		nullptr,
		&aw_lightgun_inputs,
    },
    // Extreme Hunting 2
    {
        "xtrmhnt2",
        nullptr,
        "Extreme Hunting 2",
        0x8000000,
        0x2a,
        "awbios",
        AW,
        ROT0,
        {
            { "610-0752.u3",    0x0000000, 0x1000000, 0xbab6182e },
            { "610-0752.u1",    0x1000000, 0x1000000, 0x3086bc47 },
            { "610-0752.u4",    0x2000000, 0x1000000, 0x9787f145 },
            { "610-0752.u2",    0x3000000, 0x1000000, 0xd3a88b31 },
            { "610-0752.u15",   0x4000000, 0x1000000, 0x864a6342 },
            { "610-0752.u17",   0x5000000, 0x1000000, 0xa79fb1fa },
            { "610-0752.u14",   0x6000000, 0x1000000, 0xce83bcc7 },
            { "610-0752.u16",   0x7000000, 0x1000000, 0x8ac71c76 },

            //ROM_REGION( 0x1400000, "network", 0)    // network board
            //ROM_LOAD( "fpr-24330a.ic2", 0x000000, 0x400000, CRC(8d89877e) SHA1(6caafc49114eb0358e217bc2d1a3ab58a93c8d19) )
            //ROM_LOAD( "flash128.ic4s", 0x400000, 0x1000000, CRC(866ed675) SHA1(2c4c06935b7ab1876e640cede51713b841833567) )
        },
		nullptr,
		&aw_lightgun_inputs,
    },
	//
	// Naomi 2
	//
    {
    	"vstrik3co",
		"vstrik3c",
		"Virtua Striker 3 (World)",
		0xb000000,
		0x2cee834a,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23663.ic22", 0x0000000, 0x0400000, 0x6910a008 },
			{ "mpr-23652.ic1",  0x0800000, 0x1000000, 0x992758a2 },
			{ "mpr-23653.ic2",  0x1800000, 0x1000000, 0xe210e932 },
			{ "mpr-23654.ic3",  0x2800000, 0x1000000, 0x91335971 },
			{ "mpr-23655.ic4",  0x3800000, 0x1000000, 0x1afe03b2 },
			{ "mpr-23656.ic5",  0x4800000, 0x1000000, 0x5e5fca1c },
			{ "mpr-23657.ic6",  0x5800000, 0x1000000, 0xd97602bf },
			{ "mpr-23658.ic7",  0x6800000, 0x1000000, 0xc912eacb },
			{ "mpr-23659.ic8",  0x7800000, 0x1000000, 0xdb87ff9a },
			{ "mpr-23660.ic9",  0x8800000, 0x1000000, 0xe49e65f5 },
			{ "mpr-23661.ic10", 0x9800000, 0x1000000, 0x7d44dc74 },
			{ "mpr-23662.ic11", 0xa800000, 0x0800000, 0xd6ef7d68 },
        },
		nullptr,
		&vs2_2k_inputs,
    },
	{
		"vstrik3c",
		nullptr,
		"Virtua Striker 3 (World, Rev B)",
		0xb000000,
		0x2cee834a,
		"naomi2",
		M2,
		ROT0,
		{
			{ "epr-23663b.ic22", 0x0000000, 0x0400000, 0x15733e44 },
			{ "mpr-23652.ic1",   0x0800000, 0x1000000, 0x992758a2 },
			{ "mpr-23653.ic2",   0x1800000, 0x1000000, 0xe210e932 },
			{ "mpr-23654.ic3",   0x2800000, 0x1000000, 0x91335971 },
			{ "mpr-23655.ic4",   0x3800000, 0x1000000, 0x1afe03b2 },
			{ "mpr-23656.ic5",   0x4800000, 0x1000000, 0x5e5fca1c },
			{ "mpr-23657.ic6",   0x5800000, 0x1000000, 0xd97602bf },
			{ "mpr-23658.ic7",   0x6800000, 0x1000000, 0xc912eacb },
			{ "mpr-23659.ic8",   0x7800000, 0x1000000, 0xdb87ff9a },
			{ "mpr-23660.ic9",   0x8800000, 0x1000000, 0xe49e65f5 },
			{ "mpr-23661.ic10",  0x9800000, 0x1000000, 0x7d44dc74 },
			{ "mpr-23662.ic11",  0xa800000, 0x0800000, 0xd6ef7d68 },
		},
		nullptr,
		&vs2_2k_inputs,
	},
    {
    	"wldrider",
		nullptr,
		"Wild Riders",
		0xa800000,
		0x2ce7a703,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23622.ic22", 0x0000000, 0x0400000, 0x8acafa5b },
			{ "mpr-23611.ic1",  0x0800000, 0x1000000, 0x943bc32a },
			{ "mpr-23612.ic2",  0x1800000, 0x1000000, 0xf71d87e5 },
			{ "mpr-23613.ic3",  0x2800000, 0x1000000, 0x689e783e },
			{ "mpr-23614.ic4",  0x3800000, 0x1000000, 0xe5b8c5e5 },
			{ "mpr-23615.ic5",  0x4800000, 0x1000000, 0x95c35866 },
			{ "mpr-23616.ic6",  0x5800000, 0x1000000, 0x6288848f },
			{ "mpr-23617.ic7",  0x6800000, 0x1000000, 0x19298892 },
			{ "mpr-23618.ic8",  0x7800000, 0x1000000, 0x67d7b659 },
			{ "mpr-23619.ic9",  0x8800000, 0x1000000, 0xa5f4f6af },
			{ "mpr-23620.ic10", 0x9800000, 0x1000000, 0x67aa15a9 },
        },
		nullptr,
		&wldrider_inputs,
    },
    {
    	"vf4cart",
		nullptr,
		"Virtua Fighter 4 (World)",
		0xb800000,
		0x2eef2f96,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23785.ic22", 0x0000000, 0x0400000, 0x9bd98d4b },
			{ "mpr-23774.ic1",  0x0800000, 0x1000000, 0x0fe7b864 },
			{ "mpr-23775.ic2",  0x1800000, 0x1000000, 0xa11cd9e5 },
			{ "mpr-23776.ic3",  0x2800000, 0x1000000, 0x44b8429e },
			{ "mpr-23777.ic4",  0x3800000, 0x1000000, 0x78a4264e },
			{ "mpr-23778.ic5",  0x4800000, 0x1000000, 0x02dee78b },
			{ "mpr-23779.ic6",  0x5800000, 0x1000000, 0x6e458eea },
			{ "mpr-23780.ic7",  0x6800000, 0x1000000, 0xa775a51c },
			{ "mpr-23781.ic8",  0x7800000, 0x1000000, 0x401bca00 },
			{ "mpr-23782.ic9",  0x8800000, 0x1000000, 0x4f72e901 },
			{ "mpr-23783.ic10", 0x9800000, 0x1000000, 0xc8d4f6f9 },
			{ "mpr-23784.ic11", 0xa800000, 0x1000000, 0xf74f2fee },
        },
		nullptr,
		&vf4_inputs,
    },
    {
    	"kingrt66",
		nullptr,
		"The King of Route 66 (Rev A)",
		0xa800000,
		0xffffffff,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23819a.ic22", 0x0000000, 0x00400000, 0x92f11b29 },
			{ "mpr-23808.ic1",  0x00800000,  0x01000000, 0xe911bc86 },
			{ "mpr-23809.ic2",  0x01800000,  0x01000000, 0x2716aba0 },
			{ "mpr-23810.ic3",  0x02800000,  0x01000000, 0x2226accb },
			{ "mpr-23811.ic4",  0x03800000,  0x01000000, 0xbbad4a93 },
			{ "mpr-23812.ic5",  0x04800000,  0x01000000, 0x7beabe22 },
			{ "mpr-23813.ic6",  0x05800000,  0x01000000, 0xfe0b94ea },
			{ "mpr-23814.ic7",  0x06800000,  0x01000000, 0x0cdf7325 },
			{ "mpr-23815.ic8",  0x07800000,  0x01000000, 0xef327ab8 },
			{ "mpr-23816.ic9",  0x08800000,  0x01000000, 0xbbaf0765 },
			{ "mpr-23817.ic10", 0x09800000,  0x01000000, 0xe179cfb6 },
        },
		nullptr,
		&kingrt66_inputs,
		kingrt66_eeprom_dump,
    },
    {
    	"kingrt66p",
		"kingrt66",
		"The King of Route 66 (prototype)",
		0xa800000,
		0xffffffff,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23819-1-11.ic22", 0x0000000, 0x00400000, 0xa9602240 },
			{ "mpr-23808.ic1",  0x00800000,  0x01000000, 0xe911bc86 },
			{ "mpr-23809.ic2",  0x01800000,  0x01000000, 0x2716aba0 },
			{ "mpr-23810.ic3",  0x02800000,  0x01000000, 0x2226accb },
			{ "mpr-23811.ic4",  0x03800000,  0x01000000, 0xbbad4a93 },
			{ "mpr-23812.ic5",  0x04800000,  0x01000000, 0x7beabe22 },
			{ "mpr-23813.ic6",  0x05800000,  0x01000000, 0xfe0b94ea },
			{ "mpr-23814.ic7",  0x06800000,  0x01000000, 0x0cdf7325 },
			{ "mpr-23815.ic8",  0x07800000,  0x01000000, 0xef327ab8 },
			{ "mpr-23816.ic9",  0x08800000,  0x01000000, 0xbbaf0765 },
			{ "mpr-23817.ic10", 0x09800000,  0x01000000, 0xe179cfb6 },
        },
		nullptr,
		&kingrt66_inputs,
    },
    {
    	"soulsurf",
		nullptr,
		"Soul Surfer (Rev A)",
		0xb000000,
		0xffffffff,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23838c.ic22", 0x000000, 0x400000, 0x5e5fb00f },
			{ "rom1.ic1s",   0x0800000, 0x800000, 0x4f12f789 },
			{ "rom2.ic2s",   0x1000000, 0x800000, 0xa255d41a },
			{ "rom3.ic3s",   0x1800000, 0x800000, 0x0f8d6577 },
			{ "rom4.ic4s",   0x2000000, 0x800000, 0xbdf25bd0 },
			{ "rom5.ic5s",   0x2800000, 0x800000, 0xa74b3bb4 },
			{ "rom6.ic6s",   0x3000000, 0x800000, 0x3cd1f5d5 },
			{ "rom7.ic7s",   0x3800000, 0x800000, 0x00d240f5 },
			{ "rom8.ic8s",   0x4000000, 0x800000, 0xd4907fa1 },
			{ "rom9.ic9s",   0x4800000, 0x800000, 0x6327d49e },
			{ "rom10.ic10s", 0x5000000, 0x800000, 0x7975dc80 },
			{ "rom11.ic11s", 0x5800000, 0x800000, 0xa242f682 },
			{ "rom12.ic12s", 0x6000000, 0x800000, 0x45fa259e },
			{ "rom13.ic13s", 0x6800000, 0x800000, 0xe9578063 },
			{ "rom14.ic14s", 0x7000000, 0x800000, 0x2edc1311 },
			{ "rom15.ic15s", 0x7800000, 0x800000, 0x416db320 },
			{ "rom16.ic16s", 0x8000000, 0x800000, 0x2530cc04 },
			{ "rom17.ic17s", 0x8800000, 0x800000, 0x9e6afcc2 },
			{ "rom18.ic18s", 0x9000000, 0x800000, 0x854ed5e5 },
			{ "rom19.ic19s", 0x9800000, 0x800000, 0x4f8ec86a },
			{ "rom20.ic20s", 0xa000000, 0x800000, 0xc90b960d },
			{ "rom21.ic21s", 0xa800000, 0x800000, 0x1477c064 },
        },
		nullptr,
    	&soulsurfer_inputs,
    },
    {
    	"vf4evoct",
		nullptr,
		"Virtua Fighter 4 Evolution (World)",
		0xb000000,
		0x1e5bb0cd,
		"naomi2",
		M1,
		ROT0,
        {
			{ "epr-23934.ic11",  0x0000000, 0x400000, 0x656a7d84 },
			{ "mpr-23912.ic17s", 0x1000000, 0x800000, 0xb2b13d97, InterleavedWord },
			{ "mpr-23913.ic18",  0x1000002, 0x800000, 0x560de9d2, InterleavedWord },
			{ "mpr-23914.ic19s", 0x2000000, 0x800000, 0xa2104728, InterleavedWord },
			{ "mpr-23915.ic20",  0x2000002, 0x800000, 0x295d32f0, InterleavedWord },
			{ "mpr-23916.ic21s", 0x3000000, 0x800000, 0xd725fdd3, InterleavedWord },
			{ "mpr-23917.ic22",  0x3000002, 0x800000, 0x8794c8e8, InterleavedWord },
			{ "mpr-23918.ic23s", 0x4000000, 0x800000, 0x7a3da170, InterleavedWord },
			{ "mpr-23919.ic24",  0x4000002, 0x800000, 0x59601746, InterleavedWord },
			{ "mpr-23920.ic25s", 0x5000000, 0x800000, 0x6ae07021, InterleavedWord },
			{ "mpr-23921.ic26",  0x5000002, 0x800000, 0x42028253, InterleavedWord },
			{ "mpr-23922.ic27s", 0x6000000, 0x800000, 0xbaf47df2, InterleavedWord },
			{ "mpr-23923.ic28",  0x6000002, 0x800000, 0x5c31b7e7, InterleavedWord },
			{ "mpr-23924.ic29",  0x7000000, 0x800000, 0x6dfe19d9, InterleavedWord },
			{ "mpr-23925.ic30s", 0x7000002, 0x800000, 0xe9ec870a, InterleavedWord },
			{ "mpr-23926.ic31",  0x8000000, 0x800000, 0x2c650728, InterleavedWord },
			{ "mpr-23927.ic32s", 0x8000002, 0x800000, 0xf36a765b, InterleavedWord },
			{ "mpr-23928.ic33",  0x9000000, 0x800000, 0x0ee92b02, InterleavedWord },
			{ "mpr-23929.ic34s", 0x9000002, 0x800000, 0xd768f242, InterleavedWord },
			{ "mpr-23930.ic35",  0xa000000, 0x800000, 0x0e45e4c4, InterleavedWord },
			{ "mpr-23931.ic36s", 0xa000002, 0x800000, 0x12ecd2f0, InterleavedWord },
            { "copy",            0x400000,  0xc00000, 0x00000000, Copy, 0x1000000 },
        },
		nullptr,
		&vf4_inputs,
		vf4evo_eeprom_dump,
    },
    {
    	"clubkrto",
		"clubkrt",
		"Club Kart: European Session",
		0xb800000,
		0x2ce7d742,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23704.ic22", 0x0000000, 0x0400000, 0xff700a0d },
			{ "mpr-23693.ic1",  0x0800000, 0x1000000, 0x28995764 },
			{ "mpr-23694.ic2",  0x1800000, 0x1000000, 0x37d30111 },
			{ "mpr-23695.ic3",  0x2800000, 0x1000000, 0x41ac1510 },
			{ "mpr-23696.ic4",  0x3800000, 0x1000000, 0x6f2da455 },
			{ "mpr-23697.ic5",  0x4800000, 0x1000000, 0x1383c742 },
			{ "mpr-23698.ic6",  0x5800000, 0x1000000, 0xda79cd06 },
			{ "mpr-23699.ic7",  0x6800000, 0x1000000, 0xea77f000 },
			{ "mpr-23700.ic8",  0x7800000, 0x1000000, 0xdb9e5c1d },
			{ "mpr-23701.ic9",  0x8800000, 0x1000000, 0x0fa92fd7 },
			{ "mpr-23702.ic10", 0x9800000, 0x1000000, 0xe302b582 },
			{ "mpr-23703.ic11", 0xa800000, 0x1000000, 0x702b8b4a },
        },
		nullptr,
		&clubkart_inputs,
		nullptr,
    },
	{
    	"clubkrta",
		"clubkrt",
		"Club Kart: European Session (Rev A)",
		0xb800000,
		0x2ce7d742,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23704a.ic22", 0x0000000, 0x0400000, 0x45ea13c3 },
			{ "mpr-23693.ic1",  0x0800000, 0x1000000, 0x28995764 },
			{ "mpr-23694.ic2",  0x1800000, 0x1000000, 0x37d30111 },
			{ "mpr-23695.ic3",  0x2800000, 0x1000000, 0x41ac1510 },
			{ "mpr-23696.ic4",  0x3800000, 0x1000000, 0x6f2da455 },
			{ "mpr-23697.ic5",  0x4800000, 0x1000000, 0x1383c742 },
			{ "mpr-23698.ic6",  0x5800000, 0x1000000, 0xda79cd06 },
			{ "mpr-23699.ic7",  0x6800000, 0x1000000, 0xea77f000 },
			{ "mpr-23700.ic8",  0x7800000, 0x1000000, 0xdb9e5c1d },
			{ "mpr-23701.ic9",  0x8800000, 0x1000000, 0x0fa92fd7 },
			{ "mpr-23702.ic10", 0x9800000, 0x1000000, 0xe302b582 },
			{ "mpr-23703.ic11", 0xa800000, 0x1000000, 0x702b8b4a },
        },
		nullptr,
		&clubkart_inputs,
		nullptr,
    },
    {
    	"clubkrtc",
		"clubkrt",
		"Club Kart: European Session (Rev C)",
		0xb800000,
		0x2ce7d742,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23704c.ic22", 0x0000000, 0x0400000, 0x9aaba862 },
			{ "mpr-23693.ic1",  0x0800000, 0x1000000, 0x28995764 },
			{ "mpr-23694.ic2",  0x1800000, 0x1000000, 0x37d30111 },
			{ "mpr-23695.ic3",  0x2800000, 0x1000000, 0x41ac1510 },
			{ "mpr-23696.ic4",  0x3800000, 0x1000000, 0x6f2da455 },
			{ "mpr-23697.ic5",  0x4800000, 0x1000000, 0x1383c742 },
			{ "mpr-23698.ic6",  0x5800000, 0x1000000, 0xda79cd06 },
			{ "mpr-23699.ic7",  0x6800000, 0x1000000, 0xea77f000 },
			{ "mpr-23700.ic8",  0x7800000, 0x1000000, 0xdb9e5c1d },
			{ "mpr-23701.ic9",  0x8800000, 0x1000000, 0x0fa92fd7 },
			{ "mpr-23702.ic10", 0x9800000, 0x1000000, 0xe302b582 },
			{ "mpr-23703.ic11", 0xa800000, 0x1000000, 0x702b8b4a },
        },
		nullptr,
		&clubkart_inputs,
		nullptr,
    },
    {
    	"clubkrt",
		nullptr,
		"Club Kart: European Session (Rev D)",
		0xb800000,
		0x2ce7d742,
		"naomi2",
		M2,
		ROT0,
        {
			{ "epr-23704d.ic22", 0x0000000, 0x0400000, 0x60ac770c },
			{ "mpr-23693.ic1",  0x0800000, 0x1000000, 0x28995764 },
			{ "mpr-23694.ic2",  0x1800000, 0x1000000, 0x37d30111 },
			{ "mpr-23695.ic3",  0x2800000, 0x1000000, 0x41ac1510 },
			{ "mpr-23696.ic4",  0x3800000, 0x1000000, 0x6f2da455 },
			{ "mpr-23697.ic5",  0x4800000, 0x1000000, 0x1383c742 },
			{ "mpr-23698.ic6",  0x5800000, 0x1000000, 0xda79cd06 },
			{ "mpr-23699.ic7",  0x6800000, 0x1000000, 0xea77f000 },
			{ "mpr-23700.ic8",  0x7800000, 0x1000000, 0xdb9e5c1d },
			{ "mpr-23701.ic9",  0x8800000, 0x1000000, 0x0fa92fd7 },
			{ "mpr-23702.ic10", 0x9800000, 0x1000000, 0xe302b582 },
			{ "mpr-23703.ic11", 0xa800000, 0x1000000, 0x702b8b4a },
        },
		nullptr,
		&clubkart_inputs,
		nullptr,
    },
    {
    	"clubkprz",
		nullptr,
		"Club Kart Prize (Rev A)",
		0x9000000,
		0x997681fe,
		"naomi2",
		M1,
		ROT0,
        {
			{ "epr-24082a.ic11", 0x000000, 0x400000, 0x7c331cb8 },
			{ "opr-24066.17s", 0x1000000, 0x800000, 0xb22cfa7b, InterleavedWord },
			{ "opr-24067.18",  0x1000002, 0x800000, 0x0d2d1290, InterleavedWord },
			{ "opr-24068.19s", 0x2000000, 0x800000, 0xd320009b, InterleavedWord },
			{ "opr-24069.20",  0x2000002, 0x800000, 0x56145c73, InterleavedWord },
			{ "opr-24070.21s", 0x3000000, 0x800000, 0x10a0c315, InterleavedWord },
			{ "opr-24071.22",  0x3000002, 0x800000, 0x040e1329, InterleavedWord },
			{ "opr-24072.23s", 0x4000000, 0x800000, 0x1e9834e4, InterleavedWord },
			{ "opr-24073.24",  0x4000002, 0x800000, 0x51fb7d42, InterleavedWord },
			{ "opr-24074.25s", 0x5000000, 0x800000, 0x636625fe, InterleavedWord },
			{ "opr-24075.26",  0x5000002, 0x800000, 0x9eee9689, InterleavedWord },
			{ "opr-24076.27s", 0x6000000, 0x800000, 0xa89a5555, InterleavedWord },
			{ "opr-24077.28",  0x6000002, 0x800000, 0x1e11d0aa, InterleavedWord },
			{ "opr-24078.29",  0x7000000, 0x800000, 0xa83f5f88, InterleavedWord },
			{ "opr-24079.30s", 0x7000002, 0x800000, 0x57efa68f, InterleavedWord },
			{ "opr-24080.31",  0x8000000, 0x800000, 0x307c480e, InterleavedWord },
			{ "opr-24081.32s", 0x8000002, 0x800000, 0x61085bdc, InterleavedWord },
            { "copy",          0x400000,  0xc00000, 0x00000000, Copy, 0x1000000 },
        },
		nullptr,
		&clubkart_inputs,
    },
    {
    	"clubkpzb",
		nullptr,
		"Club Kart Prize (Ver. B)",
		0x9000000,
		0x997681fe,
		"naomi2",
		M1,
		ROT0,
        {
			{ "epr-24149.ic11", 0x000000, 0x400000, 0x175b57a5 },
			{ "opr-24178.ic17s", 0x1000000, 0x800000, 0x836764ca, InterleavedWord },
			{ "opr-24179.ic18",  0x1000002, 0x800000, 0x03a0eb5b, InterleavedWord },
			{ "opr-24180.ic19s", 0x2000000, 0x800000, 0x6a6c41f4, InterleavedWord },
			{ "opr-24181.ic20",  0x2000002, 0x800000, 0x38fd96fd, InterleavedWord },
			{ "opr-24182.ic21s", 0x3000000, 0x800000, 0xb1116d71, InterleavedWord },
			{ "opr-24183.ic22",  0x3000002, 0x800000, 0xc1aef164, InterleavedWord },
			{ "opr-24184.ic23s", 0x4000000, 0x800000, 0x4ce1b902, InterleavedWord },
			{ "opr-24185.ic24",  0x4000002, 0x800000, 0x94a4e6ab, InterleavedWord },
			{ "opr-24186.ic25s", 0x5000000, 0x800000, 0x6884d0e9, InterleavedWord },
			{ "opr-24187.ic26",  0x5000002, 0x800000, 0x87c79534, InterleavedWord },
			{ "opr-24188.ic27s", 0x6000000, 0x800000, 0xcfe107a2, InterleavedWord },
			{ "opr-24189.ic28",  0x6000002, 0x800000, 0x302de147, InterleavedWord },
			{ "opr-24190.ic29",  0x7000000, 0x800000, 0x71551313, InterleavedWord },
			{ "opr-24191.ic30s", 0x7000002, 0x800000, 0x200cbeaf, InterleavedWord },
			{ "opr-24192.ic31",  0x8000000, 0x800000, 0x869ef0ce, InterleavedWord },
			{ "opr-24193.ic32s", 0x8000002, 0x800000, 0xfb39946d, InterleavedWord },
            { "copy",            0x400000,  0xc00000, 0x00000000, Copy, 0x1000000 },
        },
		nullptr,
		&clubkart_inputs,
    },
    {
    	"clubkpzbp",
		"clubkpzb",
		"Club Kart Prize (Ver. B prototype)",
		0xa000000,
		0xffffffff,
		"naomi2",
		M2,
		ROT0,
        {
			{ "rom0.ic22",   0x0000000, 0x400000, 0xe958f9e0 },
			{ "rom2.ic2s",   0x1000000, 0x800000, 0xd4ef582c },
			{ "rom3.ic3s",   0x1800000, 0x800000, 0x6302239e },
			{ "rom4.ic4s",   0x2000000, 0x800000, 0x4f5e9426 },
			{ "rom5.ic5s",   0x2800000, 0x800000, 0x7bb189ea },
			{ "rom6.ic6s",   0x3000000, 0x800000, 0x5a256041 },
			{ "rom7.ic7s",   0x3800000, 0x800000, 0x82bc57c3 },
			{ "rom8.ic8s",   0x4000000, 0x800000, 0x71d7259a },
			{ "rom9.ic9s",   0x4800000, 0x800000, 0x98663de6 },
			{ "rom10.ic10s", 0x5000000, 0x800000, 0x0786f88e },
			{ "rom11.ic11s", 0x5800000, 0x800000, 0x259b7dd5 },
			{ "rom12.ic12s", 0x6000000, 0x800000, 0xf2de41b8 },
			{ "rom13.ic13s", 0x6800000, 0x800000, 0x2e00966e },
			{ "rom14.ic14s", 0x7000000, 0x800000, 0xc428e593 },
			{ "rom15.ic15s", 0x7800000, 0x800000, 0xc196ac29 },
			{ "rom16.ic16s", 0x8000000, 0x800000, 0x538827ca },
			{ "rom17.ic17s", 0x8800000, 0x800000, 0xfbff0538 },
        },
		nullptr,
		&clubkart_inputs,
    },
    {
    	"clubk2k3",
		nullptr,
		"Club Kart: European Session (2003, Rev A)",
		0xa000000,
		0xd8b0fa4c,
		"naomi2",
		M1,
		ROT0,
        {
			{ "epr-24173a.ic11", 0x0000000, 0x400000, 0xd35ae42a },
			{ "opr-24151.ic17s", 0x1000000, 0x800000, 0x91594439, InterleavedWord },
			{ "opr-24152.ic18",  0x1000002, 0x800000, 0xfd131f88, InterleavedWord },
			{ "opr-24153.ic19s", 0x2000000, 0x800000, 0x795df2a6, InterleavedWord },
			{ "opr-24154.ic20",  0x2000002, 0x800000, 0x7bba9a33, InterleavedWord },
			{ "opr-24155.ic21s", 0x3000000, 0x800000, 0x9e3b358d, InterleavedWord },
			{ "opr-24156.ic22",  0x3000002, 0x800000, 0xdd5286f7, InterleavedWord },
			{ "opr-24157.ic23s", 0x4000000, 0x800000, 0x7edc4a7d, InterleavedWord },
			{ "opr-24158.ic24",  0x4000002, 0x800000, 0x4d546427, InterleavedWord },
			{ "opr-24159.ic25s", 0x5000000, 0x800000, 0xae8d7de1, InterleavedWord },
			{ "opr-24160.ic26",  0x5000002, 0x800000, 0xe75210c9, InterleavedWord },
			{ "opr-24161.ic27s", 0x6000000, 0x800000, 0xaeecf812, InterleavedWord },
			{ "opr-24162.ic28",  0x6000002, 0x800000, 0x0e349c02, InterleavedWord },
			{ "opr-24163.ic29",  0x7000000, 0x800000, 0xdab7f365, InterleavedWord },
			{ "opr-24164.ic30s", 0x7000002, 0x800000, 0x03be6b1d, InterleavedWord },
			{ "opr-24165.ic31",  0x8000000, 0x800000, 0x8fdb66a5, InterleavedWord },
			{ "opr-24166.ic32s", 0x8000002, 0x800000, 0x790a1b5e, InterleavedWord },
			{ "opr-24167.ic33",  0x9000000, 0x800000, 0x15de1d97, InterleavedWord },
			{ "opr-24168.ic34s", 0x9000002, 0x800000, 0x90dfdd5a, InterleavedWord },
            { "copy",            0x400000,  0xc00000, 0x00000000, Copy, 0x1000000 },
        },
		nullptr,
		&clubkart_inputs,
		clubk2k3_eeprom_dump,
    },
    {
    	"clubk2kp",
		"clubk2k3",
		"Club Kart: European Session (2003, prototype, set 1)",
		0xa000000,
		0xffffffff,
		"naomi2",
		M2,
		ROT0,
        {
        	{ "ic22.bin",    0x0000000, 0x400000, 0x334fc561 }, // flash ROM module
			{ "rom1.ic1s",   0x0800000, 0x800000, 0x63bd7915 },
			{ "rom2.ic2s",   0x1000000, 0x800000, 0x9d0d5e68 },
			{ "rom3.ic3s",   0x1800000, 0x800000, 0xead5f480 },
			{ "rom4.ic4s",   0x2000000, 0x800000, 0xc9b21961 },
			{ "rom5.ic5s",   0x2800000, 0x800000, 0xb42b5bdf },
			{ "rom6.ic6s",   0x3000000, 0x800000, 0x6e69792e },
			{ "rom7.ic7s",   0x3800000, 0x800000, 0x0956796e },
			{ "rom8.ic8s",   0x4000000, 0x800000, 0x9dba44f5 },
			{ "rom9.ic9s",   0x4800000, 0x800000, 0x1307b6a1 },
			{ "rom10.ic10s", 0x5000000, 0x800000, 0x4ec15b61 },
			{ "rom11.ic11s", 0x5800000, 0x800000, 0x3c4a2f34 },
			{ "rom12.ic12s", 0x6000000, 0x800000, 0x55548b90 },
			{ "rom13.ic13s", 0x6800000, 0x800000, 0x373097e5 },
			{ "rom14.ic14s", 0x7000000, 0x800000, 0x7297efb8 },
			{ "rom15.ic15s", 0x7800000, 0x800000, 0x42dd18db },
			{ "rom16.ic16s", 0x8000000, 0x800000, 0xaaaa39cf },
			{ "rom17.ic17s", 0x8800000, 0x800000, 0x382fc4cb },
			{ "rom18.ic18s", 0x9000000, 0x800000, 0xcdd71385 },
			{ "rom19.ic19s", 0x9800000, 0x800000, 0x7ee9743b },
        },
		nullptr,
		&clubkart_inputs,
    },
    {
    	"clubk2kpa",
		"clubk2k3",
		"Club Kart: European Session (2003, prototype, set 2)",
		0xb000000,
		0xffffffff,
		"naomi2",
		M2,
		ROT0,
        {
           	{ "rom0.ic22",   0x0000000, 0x400000, 0x8514f0bf }, // one of ROM header bytes was clearly bad, manually fixed, but there might be more
			// game data ROMs confirmed good, despite the fact they shown as all BAD in BIOS ROM TEST
			{ "rom1.ic1s",   0x0800000, 0x800000, 0x63bd7915 },
			{ "rom2.ic2s",   0x1000000, 0x800000, 0x9d0d5e68 },
			{ "rom3.ic3s",   0x1800000, 0x800000, 0xead5f480 },
			{ "rom4.ic4s",   0x2000000, 0x800000, 0xc9b21961 },
			{ "rom5.ic5s",   0x2800000, 0x800000, 0xb42b5bdf },
			{ "rom6.ic6s",   0x3000000, 0x800000, 0x6e69792e },
			{ "rom7.ic7s",   0x3800000, 0x800000, 0x0956796e },
			{ "rom8.ic8s",   0x4000000, 0x800000, 0x9dba44f5 },
			{ "rom9.ic9s",   0x4800000, 0x800000, 0x1307b6a1 },
			{ "rom10.ic10s", 0x5000000, 0x800000, 0x4ec15b61 },
			{ "rom11.ic11s", 0x5800000, 0x800000, 0x3c4a2f34 },
			{ "rom12.ic12s", 0x6000000, 0x800000, 0x55548b90 },
			{ "rom13.ic13s", 0x6800000, 0x800000, 0x373097e5 },
			{ "rom14.ic14s", 0x7000000, 0x800000, 0x7297efb8 },
			{ "rom15.ic15s", 0x7800000, 0x800000, 0x42dd18db },
			{ "rom16.ic16s", 0x8000000, 0x800000, 0xaaaa39cf },
			{ "rom17.ic17s", 0x8800000, 0x800000, 0x382fc4cb },
			{ "rom18.ic18s", 0x9000000, 0x800000, 0xcdd71385 },
			{ "rom19.ic19s", 0x9800000, 0x800000, 0x7ee9743b },
			{ "rom20.ic20s", 0xa000000, 0x800000, 0x99ef6bb7 }, // not used by game, garbage
			{ "rom21.ic21s", 0xa800000, 0x800000, 0x21bd0a9c }, // not used by game, garbage
        },
		nullptr,
		&clubkart_inputs,
    },
#ifdef NAOMI_MULTIBOARD
    {
    	"sgdrvsim",
		nullptr,
		"Sega Driving Simulator",
		0x20000000,
		0x5508,
		"naomi2",
		M4,
		ROT0,
        {
        	{ "ic8.bin",  0x00000000, 0x4000000, 0x3ef5e62f },
        	{ "ic9.bin",  0x04000000, 0x4000000, 0x4edf67df },
        	{ "ic10.bin", 0x08000000, 0x4000000, 0xa3b0f436 },
        	{ "ic11.bin", 0x0c000000, 0x4000000, 0x200ad72c },
        	{ "ic12.bin", 0x10000000, 0x4000000, 0x90d192a4 },
        	{ "ic13.bin", 0x14000000, 0x4000000, 0xeed33acc },
        	{ "ic14.bin", 0x18000000, 0x4000000, 0x349267e9 },
        	{ "ic15.bin", 0x1c000000, 0x4000000, 0xacc0c039 },

			{ "317-0502-jpn.ic3", 0, 0x800, 0x528ad9e7, Key },
        },
		nullptr,
		&drvsim_inputs,
		sgdrvsim_eeprom_dump,
    },
#endif
	//
	// Naomi 2 GD-ROM
	//
    {
    	"vstrik3",
		nullptr,
		"Virtua Striker 3",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0304-com.bin", 0, 0x4000, 0x8e82d17a },
		},
		"gds-0006",
		&vs2_2k_inputs,
    },
    {
    	"vf4o",
		"vf4",
		"Virtua Fighter 4",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0314-com.pic", 0, 0x4000, 0xfa0b6c70 },
		},
		"gds-0012",
		&vf4_inputs,
		vf4_eeprom_dump
    },
    {
    	"vf4b",
		"vf4",
		"Virtua Fighter 4 (Rev B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0314-com.pic", 0, 0x4000, 0xfa0b6c70 },
		},
		"gds-0012b",
		&vf4_inputs,
		vf4_eeprom_dump
    },
    {
    	"vf4",
		nullptr,
		"Virtua Fighter 4 (Ver. C)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0314-com.pic", 0, 0x4000, 0xfa0b6c70 },
		},
		"gds-0012c",
		&vf4_inputs,
		vf4_eeprom_dump
    },
    {
    	"beachspi",
		nullptr,
		"Beach Spikers",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0317-com.pic", 0, 0x4000, 0xef65fe73 },
		},
		"gds-0014",
		&beachspi_inputs,
    },
    {
    	"initd",
		nullptr,
		"Initial D Arcade Stage (Japan, Rev B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0331-jpn.pic", 0, 0x4000, 0x0a3bf606 },
		},
		"gds-0020b",
		&initd_inputs,
    },
    {
    	"initdo",
		"initd",
		"Initial D Arcade Stage (Japan)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0331-jpn.pic", 0, 0x4000, 0x0a3bf606 },
		},
		"gds-0020",
		&initd_inputs,
    },
    {
    	"vf4evo",
		nullptr,
		"Virtua Fighter 4 Evolution (Japan, Ver. B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0338-jpn.pic", 0, 0x4000, 0xb177ba7d },
		},
		"gds-0024c",
		&vf4_inputs,
		vf4evo_eeprom_dump,
    },
    {
    	"vf4evob",
		"vf4evo",
		"Virtua Fighter 4 Evolution (Japan, Ver. B, GDS-0024B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0338-jpn.pic", 0, 0x4000, 0xb177ba7d },
		},
		"gds-0024b",
		&vf4_inputs,
		vf4evo_eeprom_dump,
    },
    {
    	"vf4evoa",
		"vf4evo",
		"Virtua Fighter 4 Evolution (Japan)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0338-jpn.pic", 0, 0x4000, 0xb177ba7d },
		},
		"gds-0024a",
		&vf4_inputs,
		vf4evo_eeprom_dump,
    },
    {
    	"initdexp",
		nullptr,
		"Initial D Arcade Stage (Export, Rev A)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0343-com.pic", 0, 0x4000, 0x80eea4eb },
		},
		"gds-0025a",
		&initd_inputs,
    },
    {
    	"initdexpo",
		"initdexp",
		"Initial D Arcade Stage (Export)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0343-com.pic", 0, 0x4000, 0x80eea4eb },
		},
		"gds-0025",
		&initd_inputs,
    },
    {
    	"initdv2j",
		nullptr,
		"Initial D Arcade Stage 2 (Japan, Rev B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0345-jpn.pic", 0, 0x4000, 0x56e1274a },
		},
		"gds-0026b",
		&initd_inputs,
    },
    {
    	"initdv2jo",
		"initdv2j",
		"Initial D Arcade Stage 2 (Japan)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0345-jpn.pic", 0, 0x4000, 0x56e1274a },
		},
		"gds-0026",
		&initd_inputs,
    },
    {
    	"initdv2ja",
		"initdv2j",
		"Initial D Arcade Stage 2 (Japan, Rev A)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0345-jpn.pic", 0, 0x4000, 0x56e1274a },
		},
		"gds-0026a",
		&initd_inputs,
    },
    {
    	"initdv2e",
		"initdv2j",
		"Initial D Arcade Stage 2 (Export)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0357-exp.pic", 0, 0x4000, 0x38f84b4d },
		},
		"gds-0027",
		&initd_inputs,
    },
    {
    	"clubkcyco",
		"clubkcyc",
		"Club Kart for Cycraft",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0358-com.pic", 0, 0x4000, 0xdd33e50f },
		},
		"gds-0029",
		&clubkart_inputs,
    },
    {
    	"clubkcyc",
		nullptr,
		"Club Kart for Cycraft (Rev A)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0358-com.pic", 0, 0x4000, 0xdd33e50f },
		},
		"gds-0029a",
		&clubkart_inputs,
    },
    {
    	"initdv3j",
		nullptr,
		"Initial D Arcade Stage 3 (Japan, Rev C)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0379-jpn.pic", 0, 0x4000, 0x7f024ff6 },
		},
		"gds-0032c",
		&initd_inputs,
    },
    {
    	"initdv3jb",
		"initdv3j",
		"Initial D Arcade Stage 3 (Japan, Rev B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0379-jpn.pic", 0, 0x4000, 0x7f024ff6 },
		},
		"gds-0032b",
		&initd_inputs,
    },
    {
    	"initdv3e",
		nullptr,
		"Initial D Arcade Stage 3 (Export)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0384-com.pic", 0, 0x4000, 0x081ccd51 },
		},
		"gds-0033",
		&initd_inputs,
    },
    {
    	"vf4tuned",
		nullptr,
		"Virtua Fighter 4 Final Tuned (Ver. B)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0387-com.pic", 0, 0x4000, 0x8728aeaa },
		},
		"gds-0036f",
		&vf4_inputs,
		vf4tuned_eeprom_dump,
    },
    {
    	"vf4tunedd",
		"vf4tuned",
		"Virtua Fighter 4 Final Tuned (Ver. A)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0387-com.pic", 0, 0x4000, 0x8728aeaa },
		},
		"gds-0036d",
		&vf4_inputs,
		vf4tuned_eeprom_dump,
    },
    {
    	"vf4tuneda",
		"vf4tuned",
		"Virtua Fighter 4 Final Tuned (Rev A)",
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0387-com.pic", 0, 0x4000, 0x8728aeaa },
		},
		"gds-0036a",
		&vf4_inputs,
		vf4tuned_eeprom_dump,
    },
    {
    	"inidv3cy",
		nullptr,
		"Initial D Arcade Stage 3 Cycraft Edition (Rev B)", // Export
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0406-com.pic", 0, 0x4000, 0xfe91a7af },
		},
		"gds-0039b",
		&initd_inputs,
    },
    {
    	"inidv3ca",
		"inidv3cy",
		"Initial D Arcade Stage 3 Cycraft Edition (Rev A)", // Export
		0x4000,
		0,
		"naomi2",
		GD,
		ROT0,
        {
			{ "317-0406-com.pic", 0, 0x4000, 0xfe91a7af },
		},
		"gds-0039a",
		&initd_inputs,
    },
	//
	// System SP Games
	//
	{
		// Brick People / Block PeePoo (Ver 1.002)
		"brickppl",
		nullptr,
		"Brick People / Block PeePoo",
		0x20000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x4000000, 0xd79afdb6 },
	        { "ic63",  0x04000000, 0x4000000, 0x4f3c0937 },
			{ "ic64",  0x08000000, 0x4000000, 0x383e90d9 },
	        { "ic65",  0x0c000000, 0x4000000, 0x4c29b5ac },
			{ "317-0558-com.ic15", 0, 0x800, 0x7592d004, Key },
		},
	},
	{
		"bingogal",
		nullptr,
		"Bingo Galaxy (main)",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x01000000, 0xc07d9870 },
	        { "ic63",  0x01000000, 0x01000000, 0x5d85e6c0 },
			{ "ic64",  0x02000000, 0x01000000, 0x73134f52 },
	        { "ic65",  0x03000000, 0x01000000, 0x1e4ae511 },
	        { "ic66s", 0x04000000, 0x01000000, 0x810d5dfc },
	        { "ic67s", 0x05000000, 0x01000000, 0x92014e31 },
	        { "ic68s", 0x06000000, 0x01000000, 0x0640172c },
	        { "ic69s", 0x07000000, 0x01000000, 0xca26fbf9 },
			{ "317-0513-jpn.ic15", 0, 0x800, 0x778dc297, Key },
		},
	},
	{
		"bingogals",
		nullptr,
		"Bingo Galaxy (satellite)",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x01000000, 0x880eb905 },
	        { "ic63",  0x01000000, 0x01000000, 0x41dab407 },
			{ "ic64",  0x02000000, 0x01000000, 0x97dfb2ab },
		},
	},
	{
		"dinoking",
		nullptr,
		"Dinosaur King (USA)",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x01000000, 0x8bd18bf7 },
			{ "ic63",  0x01000000, 0x01000000, 0x8e8c8d1b },
			{ "ic64",  0x02000000, 0x01000000, 0x01b32ff7 },
			{ "ic65",  0x03000000, 0x01000000, 0x4b60cdb3 },
			{ "ic66s", 0x04000000, 0x01000000, 0xee3c278e },
			{ "ic67s", 0x05000000, 0x01000000, 0x42441393 },
			{ "ic68s", 0x06000000, 0x01000000, 0x4a787a44 },
			{ "ic69s", 0x07000000, 0x01000000, 0xc78e46c2 },
			{ "317-0408-com.ic15", 0, 0x800, 0xf77c49dc, Key },
		},
		nullptr,
		&dinok_inputs,
	},
	{
		"galilfac",
		nullptr,
		"Galileo Factory (main)",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x4000000, 0x37fda864 },
			{ "ic63",  0x04000000, 0x4000000, 0xc16707a7 },
			{ "317-unk-jpn.ic15", 0, 0x800, 0xf2233b04, Key },
		},
	},
	{
		"isshoni",
		nullptr,
		"Isshoni Wanwan Waiwai Puppy 2008",
		0x20000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x4000000, 0x82a71af8 },
			{ "ic63",  0x04000000, 0x4000000, 0xd4f65679 },
			{ "ic64",  0x08000000, 0x4000000, 0x28c764c8 },
			{ "ic65",  0x0c000000, 0x4000000, 0x906e7df8 },
			{ "ic66s", 0x10000000, 0x4000000, 0x7815e178 },
			{ "ic67s", 0x14000000, 0x4000000, 0x8d2c6567 },
			{ "ic68s", 0x18000000, 0x4000000, 0xd8213da3 },
			{ "317-0496-jpn.ic15", 0, 0x800, 0x7bca4250, Key },
		},
	},
	{
		// Yataimura Kingyosukui (1-player, Japan, Ver 1.005)
		"kingyo",
		nullptr,
		"Yataimura Kingyosukui",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x01000000, 0x02f8ee37 },
			{ "ic63",  0x01000000, 0x01000000, 0x98b1738a },
			{ "ic64",  0x02000000, 0x01000000, 0x27998de0 },
			{ "ic65",  0x03000000, 0x01000000, 0x548b3a81 },
			{ "317-5151-jpn.ic15", 0, 0x800, 0xd29c911a, Key },
		},
	},
	{
		// Love And Berry - 1st-2nd Collection (Export, v2.000)
		"lovebery",
		nullptr,
		"Love And Berry - 1st-2nd Collection (Export)",
		0x20000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x4000000, 0x1bd80ed0 },
			{ "ic63",  0x04000000, 0x4000000, 0xd3870287 },
			{ "317-0446-com.ic15", 0, 0x800, 0x9e519dc6, Key },
		},
		nullptr,
		&lovebery_inputs,
	},
	{
		"lovebero",
		"lovebery",
		"Love And Berry - 1st-2nd Collection (Export, v1.003)",
		0x20000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
		{
			{ "ic62",  0x00000000, 0x4000000, 0X0a23cea3 },
			{ "ic63",  0x04000000, 0x4000000, 0xd3870287 },
			{ "317-0446-com.ic15", 0, 0x800, 0x9e519dc6, Key },
		},
		nullptr,
		&lovebery_inputs,
	},
    {
    	"magicpop",
		nullptr,
		"Magical Poppins",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x4000000, 0xf52306db },
			{ "ic63",  0x04000000, 0x4000000, 0x1e5bad78 },
			{ "317-0474-jpn.ic15", 0, 0x800, 0x711ba0aa, Key },
        },
    },
    {
    	"manpuku",
		nullptr,
		"Manpuku Suizokukan",
		0x08000000,
		0x5502, // mame has 5508
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x04000000, 0xa6712d70 },
			{ "317-0640-jpn.ic15", 0, 0x800, 0x2fe1e48c, Key },
        },
    },
    {
    	"ochaken",
		nullptr,
		"Ocha-Ken Hot Medal",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x4000000, 0x7eb89b69 },
			{ "ic63",  0x04000000, 0x4000000, 0xe52d7885 },
			{ "317-unknown.ic15", 0, 0x800, 0x0a6e8627, Key },
        },
    },
    {
    	"puyomedal",
		nullptr,
		"Puyo Puyo! The Medal Edition",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x4000000, 0x4fcfb8c7 },
			{ "ic63",  0x04000000, 0x4000000, 0x0db8a64a },
			{ "317-0568-jpn.ic15", 0, 0x800, 0x313e6987, Key },
        },
    },
    {
    	// Yataimura Shateki (1-player, Japan, Ver 1.000)
    	"shateki",
		nullptr,
		"Yataimura Shateki",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x01000000, 0xc463ae32 },
			{ "ic63",  0x01000000, 0x01000000, 0x2acf1456 },
			{ "ic64",  0x02000000, 0x01000000, 0xfd04ebf8 },
			{ "ic65",  0x03000000, 0x01000000, 0x0c0ed06b },
			{ "ic66s", 0x04000000, 0x01000000, 0x3a9f33cc },
			{ "ic67s", 0x05000000, 0x01000000, 0x8e08cf8b },
			{ "ic68s", 0x06000000, 0x01000000, 0x14734999 },
			{ "ic69s", 0x07000000, 0x01000000, 0x6c0cd4c5 },
			{ "317-0628-jpn.ic15", 0, 0x800, 0xc02f7424, Key },
        },
    },
    {
    	// Tetris Giant / Tetris Dekaris (Ver.2.000)
    	"tetgiant",
		nullptr,
		"Tetris Giant / Tetris Dekaris",
		0x20000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62", 0x00000000, 0x4000000, 0x31ba1938 },
			{ "ic63", 0x04000000, 0x4000000, 0xcb946213 },
			{ "317-0604-com.ic15", 0, 0x800, 0xa46dfd47, Key },
        },
		nullptr,
		&tetgiant_inputs,
    },
    {
    	"unomedal",
		nullptr,
		"UNO the Medal",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x4000000, 0x2af0cfb3 },
			{ "ic63",  0x04000000, 0x4000000, 0xfe375da9 },
			{ "317-0526-jpn.ic15", 0, 0x800, 0x14232fb7, Key },
        },
    },
    {
    	"westdrmg",
		nullptr,
		"Western Dream Gold",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "ic62",  0x00000000, 0x4000000, 0x67bde24c },
			{ "ic63",  0x04000000, 0x4000000, 0xf5901eab },
			{ "317-0473-jpn.ic15", 0, 0x800, 0x8ec686b0, Key },
        },
    },
	// Compact Flash roms
	{
		// Dinosaur King - Operation: Dinosaur Rescue (USA, Export)
		"dinokior",
		nullptr,
		"Dinosaur King - Operation: Dinosaur Rescue (USA, Export)",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "317-0408-com.ic15", 0, 0x800, 0xf77c49dc, Key },
		},
		"mda-c0021",
		&dinok_inputs,
	},
	{
		// Dinosaur King - D-Team VS. the Alpha Fortress (Export, Ver 2.500)
		"dinoki25",
		nullptr,
		"Dinosaur King - D-Team VS. the Alpha Fortress (Export)",
		0x08000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
		{
			{ "317-0408-com.ic15", 0, 0x800, 0xf77c49dc, Key },
		},
		"mda-c0047",
		&dinok_inputs,
	},
	{
		// Konglongwang - D-Kids VS Alpha Yaosai (China, Ver 2.501)
		// This game's protection uses contact IC card reader made by Hirocon, with 2 IC card slots, cards probably SLE4428 or SLE5528.
		"dinokich",
		"dinoki25",
		"Konglongwang - D-Kids VS Alpha Yaosai (China)",
		0x08000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
		{
			{ "317-0408-com.ic15", 0, 0x800, 0xf77c49dc, Key },
		},
		"mda-c0081",
		&dinok_inputs,
	},
	{
		// Kodai Ouja Kyouryuu King - Mezame yo! Arata-naru Chikara!! (Japan, Ver 4.000)
		// This version does not use RFID readers and Management chips.
		"dinoki4",
		nullptr,
		"Ancient Ruler Dinosaur King - Wake up! New Power!! (Japan)",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
		{
			{ "317-0408-com.ic15", 0, 0x800, 0xf77c49dc, Key },
		},
		"mda-c0061",
		&dinok_inputs,
	},
    {
    	// Heat Up Hockey Image (Ver.1.003R)
    	"huhimage",
		nullptr,
		"Heat Up Hockey Image",
		0x08000000,
		0x5502, // mame has 5508 (8 * 512 Mb) but size is 128 MB
		"segasp",
		M4,
		ROT270,
        {
			{ "317-0606-jpn.ic15", 0, 0x800, 0x75638f59, Key },
        },
		"tsb0-sega00001",
    },
    {
    	// Yataimura Kingyosukui (4-player, China, Ver 1.000)
    	"kingyoch",
		"kingyo",
		"Yataimura Kingyosukui (China)",
		0x08000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
        {
			{ "317-0563-jpn.ic15", 0, 0x800, 0x8af67833, Key },
        },
		"kingyo",
    },
    {
    	// Love And Berry - 3rd-5th Collection (USA, Export, Ver 1.002)
    	"loveber3",
		nullptr,
		"Love And Berry - 3rd-5th Collection (USA, Export)",
		0x08000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
        {
			{ "317-0446-com.ic15", 0, 0x800, 0x9e519dc6, Key },
        },
		"mda-c0042",
		&lovebery_inputs,
    },
    {
    	// Love And Berry - 3rd-5th Collection (China, Ver 1.001)
    	// This game's protection uses contact IC card reader made by Hirocon, with 2 IC card slots, cards probably SLE4428 or SLE5528.
    	"loveber3cn",
		"loveber3",
		"Love And Berry - 3rd-5th Collection (China)",
		0x08000000,
		0x5508,
		"segasp",
		M4,
		ROT0,
        {
			{ "317-0446-com.ic15", 0, 0x800, 0x9e519dc6, Key },
        },
		"mda-c0071",
		&lovebery_inputs,
    },
    {
    	"tetgiano",
		"tetgiant",
		"Tetris Giant / Tetris Dekaris",
		0x08000000,
		0x5502,
		"segasp",
		M4,
		ROT0,
        {
			{ "317-0604-com.ic15", 0, 0x800, 0xa46dfd47, Key },
        },
		"mda-c0076",
		&tetgiant_inputs,
    },
	{
		nullptr
	}
};
