# ==============================================================================
# PMBS fragment for CLI utility
#
# SPDX-FileType: SOURCE
# SPDX-FileCopyrightText: Michael Bäuerle
# SPDX-License-Identifier: BSD-2-Clause

# Object files for library
UCIC0_CLI_OBJS=ucic0_iconv.o

# Installation directories
UCIC0_INSTALL_DIRS=bin

# Clear suffix list for inference rules
.SUFFIXES:

.SUFFIXES: .c .o

# If nothing is specified, make will use the first rule
all: cli

install: cli
	($(PMBS_SH) -c 'for dir in $(UCIC0_INSTALL_DIRS) ; \
             do mkdir -p "$(DESTDIR)$(PMBS_PREFIX)/$$dir" ; done')
	($(PMBS_SH) ../tool/install -c -m 755 ./$(PMBS_CLI_NAME) \
            "$(DESTDIR)$(PMBS_PREFIX)/bin/$(PMBS_CLI_NAME)")

uninstall:
	-(command -p rm "$(DESTDIR)$(PMBS_PREFIX)/bin/$(PMBS_CLI_NAME)")

cli: $(PMBS_CLI_NAME) $(PMBS_CLI_NAME).1

$(PMBS_CLI_NAME): $(UCIC0_CLI_OBJS)
	$(CC) -o $@ -L ../src $(LDFLAGS) $(UCIC0_CLI_OBJS) -luciconv-0 \
            -lbasexx-0

$(PMBS_CLI_NAME).1: $(PMBS_CLI_NAME).1.in
	sed -e 's,@package@,$(PMBS_LIB_NAME_BASE),g' \
            -e 's,@version@,$(PMBS_RELEASE_VERSION),g' \
            -e 's,@name@,$(PMBS_CLI_NAME),g' \
            <$(PMBS_CLI_NAME).1.in >$(PMBS_CLI_NAME).1

.c.o:
	$(CC) -I../include $(CPPFLAGS) $(CFLAGS) -c -o $@ $*.c
