/*
 * SPDX-FileType: SOURCE
 * SPDX-FileCopyrightText: Michael Bäuerle
 * SPDX-License-Identifier: BSD-2-Clause
 */

#ifndef BXX0_BASE64_URL_H
#define BXX0_BASE64_URL_H  1

#include <stddef.h>


/*! Library header for libbasexx Base 64 URL conversion module
 *
 * \file      base64_url.h
 * \author    Michael Bäuerle
 * \date      2024
 * \copyright BSD-2-Clause
 *
 * Public API (compatible between all versions with same major number).
 *
 * API documentation: \ref BASE64_URL
 */


/*! \defgroup BASE64_URL Base 64 URL conversion
 *
 * Convert Base 64 to or from URL encoding (RFC 4648).
 *
 * Replace the character plus with minus and slash with underscore (encode)
 * and vice versa (decode).
 *
 * \attention
 * This module works with US-ASCII data. EBCDIC data must be converted to
 * US-ASCII first with \ref EBCDIC module.
 */
/*! \{ */


/*! Convert data from Base 64 to URL and Filename Safe Alphabet
 *
 * \param[out] buf  Pointer to buffer
 * \param[in]  len  Size of data to convert in buffer \e buf
 */
void bxx0_base64_url_to(unsigned char *buf, size_t len);


/*! Convert data from URL and Filename Safe Alphabet to Base 64
 *
 * \param[out] buf  Pointer to buffer
 * \param[in]  len  Size of data to convert in buffer \e buf
 */
void bxx0_base64_url_from(unsigned char *buf, size_t len);


/*! \} */


#endif  /* BXX0_BASE64_URL_H */
