/* ========================================================================== */
/*! \file
 * \brief Test of \c enc_mime_encode_base64() implementation
 *
 * Copyright (c) 2012-2024 by the developers. See the LICENSE file for details.
 */


/* ========================================================================== */
/* Include headers */

#include "posix.h"  /* Include this first because of feature test macros */

#include <stdio.h>

#include "encoding.h"
#include "test.h"
#include "test_base64.h"


/* ========================================================================== */
/*! \addtogroup TEST */
/*! @{ */


/* ========================================================================== */
/*! \brief Test \c enc_mime_encode_base64() implementation
 *
 * The following cases are tested:
 * - Data size is a multiple of 3 bytes
 * - One padding character required
 * - Two padding characters required
 *
 * \return
 * - \c EXIT_SUCCESS on success
 * - \c EXIT_FAILURE on error
 */

int  test_base64(void)
{
#define TS_NUM  (size_t) 4  /* Number of test strings */
   static const char*  ts[TS_NUM] =
   {
      "This is a test!",
      "This is a test!!",
      "This is a test!!!",
      "0123456789.0123456789.00000000"
   };
   static const char*  rs[TS_NUM] =  {
      "VGhpcyBpcyBhIHRlc3Qh",
      "VGhpcyBpcyBhIHRlc3QhIQ==",
      "VGhpcyBpcyBhIHRlc3QhISE=",
      "MDEyMzQ1Njc4OS4wMTIzNDU2Nzg5LjAwMDAwMDAw"
   };
   int  res = API_POSIX_EXIT_SUCCESS;
   int  rv;
   size_t  i;
   const char*  buf = NULL;

   for(i = 0; i < TS_NUM; ++i)
   {
      rv = enc_mime_encode_base64(&buf, ts[i], strlen(ts[i]));
      if(rv)
      {
         print_error("Base64 encoder failed");
         res = API_POSIX_EXIT_FAILURE;
         break;
      }
      if(strcmp(rs[i], buf))
      {
         print_error("Result is not correct");
         /* For debugging */
         fprintf(stderr, TEST_TAB "Input data: \"%s\"\n", ts[i]);
         fprintf(stderr, TEST_TAB "Result is : \"%s\"\n", buf);
         fprintf(stderr, TEST_TAB "Should be : \"%s\"\n", rs[i]);
         res = API_POSIX_EXIT_FAILURE;
         break;
      }
      enc_free((void*) buf);
   }

   return(res);
}


/*! @} */

/* EOF */
