// Copyright (c) Pablo Halpern, 1999
// Permission is granted to use, modify, and redistribute freely

// This file contains an implementation of a number of I/O manipulators
// that are missing in the library supplied with the egcs 1.1.2 compiler.

#ifndef iomanipfixes_dot_h
#define iomanipfixes_dot_h 1

// I/O manipulators missing from <iostream>

#include <iostream>

namespace std
{
  
inline ios& showbase(ios& i) { i.setf(ios::showbase); return i; }
inline ios& showpoint(ios& i) { i.setf(ios::showpoint); return i; }
inline ios& showpos(ios& i) { i.setf(ios::showpos); return i; }
inline ios& skipws(ios& i) { i.setf(ios::skipws); return i; }
inline ios& uppercase(ios& i) { i.setf(ios::uppercase); return i; }
inline ios& unitbuf(ios& i) { i.setf(ios::unitbuf); return i; }

inline ios& noshowbase(ios& i) { i.unsetf(ios::showbase); return i; }
inline ios& noshowpoint(ios& i) { i.unsetf(ios::showpoint); return i; }
inline ios& noshowpos(ios& i) { i.unsetf(ios::showpos); return i; }
inline ios& noskipws(ios& i) { i.unsetf(ios::skipws); return i; }
inline ios& nouppercase(ios& i) { i.unsetf(ios::uppercase); return i; }
inline ios& nounitbuf(ios& i) { i.unsetf(ios::unitbuf); return i; }

inline ios& left(ios& i) { i.setf(ios::left, ios::adjustfield); return i; }
inline ios& right(ios& i) { i.setf(ios::right, ios::adjustfield); return i; }
inline ios& internal(ios& i)
  { i.setf(ios::internal, ios::adjustfield); return i; }

inline ios& scientific(ios& i)
  { i.setf(ios::scientific, ios::floatfield); return i; }
inline ios& fixed(ios& i) { i.setf(ios::fixed, ios::floatfield); return i; }

} // End namepace std

#endif /* iomanipfixes_dot_h */
