/*  Frog.h - Representation of a frog, its tongue, its splash, etc.

    batrachians - A robot-killing video game.
    Copyright (C) 2001-2024 Pierre Sarrazin <http://sarrazip.com/>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#ifndef _H_Frog
#define _H_Frog

#include <flatzebra/RSprite.h>

#include "util.h"

#include <stdlib.h>


class Frog
{
public:

    // RSprite pointers must come from new.
    // This object owns the RSprite objects.
    //
    Frog(flatzebra::RSprite *_frogSprite,
         flatzebra::RSprite *_tongueSprite,
         flatzebra::PixmapArray *_digitPixmapArray,
         SDL_Color _color);

    // Destroys the RSprite objects.
    //
    ~Frog();

    void setTicksBeforeNextJump();


    flatzebra::RSprite *frogSprite;  // owned by this object
    flatzebra::RSprite *splashSprite;  // owned by this object
    flatzebra::RSprite *tongueSprite;  // owned by this object
    flatzebra::PixmapArray *digitPixmapArray;  // NOT owned by this object
    SDL_Color color;
    long score;
    int ticksBeforeNextJump;
    int tongueTicksLeft;

private:

    // Forbidden operators:
    Frog(const Frog &);
    Frog &operator = (const Frog &);

};


#endif  /* _H_Frog */
