/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverLineG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverRectangleG2d;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

public class DriverEllipseG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;
    private static final double ROU = 5.0;

    public DriverEllipseG2d(double dpiFactor, EnsureVisible visible) {
        this.dpiFactor = dpiFactor;
        this.visible = visible;
    }

    @Override
    public void draw(UShape ushape, double x, double y, ColorMapper mapper, UParam param, Graphics2D g2d) {
        UEllipse shape = (UEllipse)ushape;
        g2d.setStroke(new BasicStroke((float)param.getStroke().getThickness()));
        this.visible.ensureVisible(x, y);
        this.visible.ensureVisible(x + shape.getWidth(), y + shape.getHeight());
        if (shape.getStart() == 0.0 && shape.getExtend() == 0.0) {
            HtmlColor back;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(x, y, shape.getWidth(), shape.getHeight());
            if (shape.getDeltaShadow() != 0.0) {
                this.drawShadow(g2d, ellipse, shape.getDeltaShadow(), this.dpiFactor);
            }
            if ((back = param.getBackcolor()) instanceof HtmlColorGradient) {
                GradientPaint paint = this.getPaintGradient(x, y, mapper, shape, back);
                g2d.setPaint(paint);
                g2d.fill(ellipse);
                if (param.getColor() != null) {
                    g2d.setColor(mapper.getMappedColor(param.getColor()));
                    DriverLineG2d.manageStroke(param, g2d);
                    g2d.draw(ellipse);
                }
            } else {
                if (back != null) {
                    g2d.setColor(mapper.getMappedColor(param.getBackcolor()));
                    DriverRectangleG2d.managePattern(param, g2d);
                    g2d.fill(ellipse);
                }
                if (param.getColor() != null && !param.getColor().equals(param.getBackcolor())) {
                    g2d.setColor(mapper.getMappedColor(param.getColor()));
                    DriverLineG2d.manageStroke(param, g2d);
                    g2d.draw(ellipse);
                }
            }
        } else {
            Arc2D.Double arc = new Arc2D.Double(x, y, shape.getWidth(), shape.getHeight(), DriverEllipseG2d.round(shape.getStart()), DriverEllipseG2d.round(shape.getExtend()), 0);
            if (param.getColor() != null) {
                g2d.setColor(mapper.getMappedColor(param.getColor()));
                g2d.draw(arc);
            }
        }
    }

    private GradientPaint getPaintGradient(double x, double y, ColorMapper mapper, UEllipse shape, HtmlColor back) {
        HtmlColorGradient gr = (HtmlColorGradient)back;
        char policy = gr.getPolicy();
        GradientPaint paint = policy == '|' ? new GradientPaint((float)x, (float)(y + shape.getHeight()) / 2.0f, mapper.getMappedColor(gr.getColor1()), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()) / 2.0f, mapper.getMappedColor(gr.getColor2())) : (policy == '\\' ? new GradientPaint((float)x, (float)(y + shape.getHeight()), mapper.getMappedColor(gr.getColor1()), (float)(x + shape.getWidth()), (float)y, mapper.getMappedColor(gr.getColor2())) : (policy == '-' ? new GradientPaint((float)(x + shape.getWidth()) / 2.0f, (float)y, mapper.getMappedColor(gr.getColor1()), (float)(x + shape.getWidth()) / 2.0f, (float)(y + shape.getHeight()), mapper.getMappedColor(gr.getColor2())) : new GradientPaint((float)x, (float)y, mapper.getMappedColor(gr.getColor1()), (float)(x + shape.getWidth()), (float)(y + shape.getHeight()), mapper.getMappedColor(gr.getColor2()))));
        return paint;
    }

    static double round(double value) {
        return value;
    }
}

