/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.swing.ImageHelper;
import net.sourceforge.plantuml.swing.ImageSelection;
import net.sourceforge.plantuml.swing.MainWindow2;
import net.sourceforge.plantuml.swing.ScrollablePicture;
import net.sourceforge.plantuml.swing.SimpleLine2;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.version.PSystemVersion;

class ImageWindow2
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(ImageWindow2.class);
    private static final String KEY_ZOOM_FIT = "zoomfit";
    private SimpleLine2 simpleLine2;
    private final JScrollPane scrollPane;
    private final JButton next = new JButton("Next");
    private final JButton copy = new JButton("Copy");
    private final JButton previous = new JButton("Previous");
    private final JCheckBox zoomFitButt = new JCheckBox("Zoom fit");
    private final ListModel listModel;
    private int index;
    private SizeMode sizeMode = SizeMode.FULL_SIZE;

    public ImageWindow2(SimpleLine2 simpleLine, final MainWindow2 main, ListModel listModel, int index) {
        super(simpleLine.toString());
        this.setIconImage(PSystemVersion.getPlantumlSmallIcon2());
        this.simpleLine2 = simpleLine;
        this.listModel = listModel;
        this.index = index;
        JPanel north = new JPanel();
        north.add(this.previous);
        north.add(this.copy);
        north.add(this.next);
        north.add(this.zoomFitButt);
        this.copy.setFocusable(false);
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.copy();
            }
        });
        this.next.setFocusable(false);
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.next();
            }
        });
        this.previous.setFocusable(false);
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.previous();
            }
        });
        this.zoomFitButt.setFocusable(false);
        this.zoomFitButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ImageWindow2.this.zoomFit();
            }
        });
        this.scrollPane = new JScrollPane(this.buildScrollablePicture());
        this.getContentPane().add((Component)north, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(640, 400);
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                main.closing(ImageWindow2.this);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                ImageWindow2.this.refreshImage();
            }
        });
        boolean zoomChecked = prefs.getBoolean(KEY_ZOOM_FIT, false);
        this.zoomFitButt.setSelected(zoomChecked);
        if (zoomChecked) {
            this.sizeMode = SizeMode.ZOOM_FIT;
        }
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.isControlDown() && evt.getKeyCode() == 39) {
                    ImageWindow2.this.next();
                } else if (evt.isControlDown() && evt.getKeyCode() == 37) {
                    ImageWindow2.this.previous();
                } else if (evt.isAltDown() && evt.getKeyCode() == 39) {
                    ImageWindow2.this.next();
                } else if (evt.isAltDown() && evt.getKeyCode() == 37) {
                    ImageWindow2.this.previous();
                } else if (evt.getKeyCode() == 39) {
                    ImageWindow2.this.imageRight();
                } else if (evt.getKeyCode() == 37) {
                    ImageWindow2.this.imageLeft();
                } else if (evt.getKeyCode() == 40) {
                    ImageWindow2.this.imageDown();
                } else if (evt.getKeyCode() == 38) {
                    ImageWindow2.this.imageUp();
                } else if (evt.getKeyCode() == 67) {
                    ImageWindow2.this.copy();
                } else if (evt.getKeyCode() == 90) {
                    ImageWindow2.this.zoomFitButt.setSelected(!ImageWindow2.this.zoomFitButt.isSelected());
                    ImageWindow2.this.zoomFit();
                }
            }
        });
    }

    private void next() {
        ++this.index;
        this.updateSimpleLine();
    }

    private void previous() {
        --this.index;
        this.updateSimpleLine();
    }

    private void imageDown() {
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getValue() + bar.getBlockIncrement());
    }

    private void imageUp() {
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        bar.setValue(bar.getValue() - bar.getBlockIncrement());
    }

    private void imageLeft() {
        JScrollBar bar = this.scrollPane.getHorizontalScrollBar();
        bar.setValue(bar.getValue() - bar.getBlockIncrement());
    }

    private void imageRight() {
        JScrollBar bar = this.scrollPane.getHorizontalScrollBar();
        bar.setValue(bar.getValue() + bar.getBlockIncrement());
    }

    private void zoomFit() {
        boolean selected = this.zoomFitButt.isSelected();
        prefs.putBoolean(KEY_ZOOM_FIT, selected);
        this.sizeMode = selected ? SizeMode.ZOOM_FIT : SizeMode.FULL_SIZE;
        this.refreshImage();
    }

    private void updateSimpleLine() {
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > this.listModel.getSize() - 1) {
            this.index = this.listModel.getSize() - 1;
        }
        this.simpleLine2 = (SimpleLine2)this.listModel.getElementAt(this.index);
        this.setTitle(this.simpleLine2.toString());
        this.refreshImage();
    }

    private ScrollablePicture buildScrollablePicture() {
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return null;
        }
        File png = generatedImage.getPngFile();
        BufferedImage image = null;
        try {
            image = ImageIO.read(new File(png.getAbsolutePath()));
            if (this.sizeMode == SizeMode.ZOOM_FIT) {
                Dimension imageDim = new Dimension(image.getWidth(), image.getHeight());
                Dimension newImgDim = ImageHelper.getScaledDimension(imageDim, this.scrollPane.getViewport().getSize());
                RenderingHints hints = new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                image = ImageHelper.getScaledInstance(image, newImgDim, hints, true);
            }
        }
        catch (IOException ex) {
            String msg = "Error reading file: " + ex.toString();
            GraphicStrings error = GraphicStrings.createDefault(Arrays.asList(msg), false);
            ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, error.getBackcolor(), null, null, 0.0, 0.0, null, false);
            imageBuilder.addUDrawable(error);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                imageBuilder.writeImageTOBEMOVED(new FileFormatOption(FileFormat.PNG), baos);
                baos.close();
                image = ImageIO.read(new ByteArrayInputStream(baos.toByteArray()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ImageIcon imageIcon = new ImageIcon(image, this.simpleLine2.toString());
        ScrollablePicture scrollablePicture = new ScrollablePicture(imageIcon, 1);
        return scrollablePicture;
    }

    private void copy() {
        GeneratedImage generatedImage = this.simpleLine2.getGeneratedImage();
        if (generatedImage == null) {
            return;
        }
        File png = generatedImage.getPngFile();
        Image image = Toolkit.getDefaultToolkit().createImage(png.getAbsolutePath());
        ImageSelection imgSel = new ImageSelection(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
    }

    public SimpleLine2 getSimpleLine() {
        return this.simpleLine2;
    }

    public void refreshImage() {
        this.scrollPane.setViewportView(this.buildScrollablePicture());
        this.force();
    }

    private void force() {
        this.repaint();
    }

    private static enum SizeMode {
        FULL_SIZE,
        ZOOM_FIT;

    }
}

