/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public final class InnerActivity
extends AbstractTextBlock
implements IEntityImage {
    private final IEntityImage im;
    private final HtmlColor borderColor;
    private final boolean shadowing;
    private final HtmlColor backColor;
    public static final double THICKNESS_BORDER = 1.5;

    public InnerActivity(IEntityImage im, HtmlColor borderColor, HtmlColor backColor, boolean shadowing) {
        this.im = im;
        this.backColor = backColor;
        this.borderColor = borderColor;
        this.shadowing = shadowing;
    }

    @Override
    public void drawU(UGraphic ug) {
        Dimension2D total = this.calculateDimension(ug.getStringBounder());
        ug = ug.apply(new UChangeBackColor(this.backColor)).apply(new UChangeColor(this.borderColor)).apply(new UStroke(1.5));
        URectangle rect = new URectangle(total.getWidth(), total.getHeight(), 25.0, 25.0);
        if (this.shadowing) {
            rect.setDeltaShadow(4.0);
        }
        ug.draw(rect);
        ug = ug.apply(new UStroke());
        this.im.drawU(ug);
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.im.getBackcolor();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D img = this.im.calculateDimension(stringBounder);
        return img;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }
}

