/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseLine
extends AbstractComponent {
    private final HtmlColor color;
    private final boolean continueLine;
    private final UStroke stroke;

    public ComponentRoseLine(HtmlColor color, boolean continueLine, UStroke stroke) {
        this.color = color;
        this.continueLine = continueLine;
        this.stroke = stroke;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(new UChangeColor(this.color));
        ug = this.continueLine ? ug.apply(new UStroke()) : this.stroke(ug, 5.0, 5.0, this.stroke.getThickness());
        int x = (int)(dimensionToUse.getWidth() / 2.0);
        ug.apply(new UTranslate(x, 0.0)).draw(new ULine(0.0, dimensionToUse.getHeight()));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

