/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.sequencediagram.ParticipantType;

public class Participant
implements SpecificBackcolorable {
    private final String code;
    private Display display;
    private final ParticipantType type;
    private int initialLife = 0;
    private Stereotype stereotype;
    private SymbolContext liveBackcolors;
    private HtmlColor specificBackcolor;
    private Url url;

    public Participant(ParticipantType type, String code, Display display) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (code == null || code.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (Display.isNull(display) || display.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.code = code;
        this.type = type;
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public String toString() {
        return this.getCode();
    }

    public Display getDisplay(boolean underlined) {
        if (underlined) {
            return this.display.underlined();
        }
        return this.display;
    }

    public ParticipantType getType() {
        return this.type;
    }

    public final void setStereotype(Stereotype stereotype, boolean stereotypePositionTop) {
        if (this.stereotype != null) {
            throw new IllegalStateException();
        }
        if (stereotype == null) {
            throw new IllegalArgumentException();
        }
        this.stereotype = stereotype;
        this.display = stereotypePositionTop ? this.display.addFirst(stereotype) : this.display.add(stereotype);
    }

    public final int getInitialLife() {
        return this.initialLife;
    }

    public final void incInitialLife(SymbolContext colors) {
        ++this.initialLife;
        this.liveBackcolors = colors;
    }

    public SymbolContext getLiveSpecificBackColors() {
        return this.liveBackcolors;
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor color) {
        this.specificBackcolor = color;
    }

    public final Url getUrl() {
        return this.url;
    }

    public final void setUrl(Url url) {
        this.url = url;
    }

    public final Stereotype getStereotype() {
        return this.stereotype;
    }

    public ColorParam getBackgroundColorParam() {
        return this.type.getBackgroundColorParam();
    }

    public SkinParamBackcolored getSkinParamBackcolored(ISkinParam skinParam) {
        HtmlColor specificBackColor = this.getSpecificBackColor();
        boolean clickable = this.getUrl() != null;
        HtmlColor stereoBackColor = skinParam.getHtmlColor(this.getBackgroundColorParam(), this.getStereotype(), clickable);
        if (stereoBackColor != null && specificBackColor == null) {
            specificBackColor = stereoBackColor;
        }
        return new SkinParamBackcolored(skinParam, specificBackColor, clickable);
    }
}

