/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.project2.Day;
import net.sourceforge.plantuml.project2.Knowledge;
import net.sourceforge.plantuml.project2.Task;
import net.sourceforge.plantuml.project2.TaskAttribute;
import net.sourceforge.plantuml.project2.TaskContainer;
import net.sourceforge.plantuml.project2.TaskImpl;
import net.sourceforge.plantuml.project2.TaskMerge;
import net.sourceforge.plantuml.project2.TimeConverter;
import net.sourceforge.plantuml.project2.TimeConverterDay;
import net.sourceforge.plantuml.project2.TimeHeaderDay;
import net.sourceforge.plantuml.project2.TimeHeaderMonth;
import net.sourceforge.plantuml.project2.TimeLine;
import net.sourceforge.plantuml.project2.TimeLineDay;
import net.sourceforge.plantuml.project2.Value;
import net.sourceforge.plantuml.project2.ValueInt;
import net.sourceforge.plantuml.project2.ValueTime;

public class Project2
implements TaskContainer {
    private final TimeLine timeline;
    private final Knowledge knowledge;
    private final List<TaskImpl> tasks = new ArrayList<TaskImpl>();

    public Project2() {
        this.timeline = new TimeLineDay();
        this.knowledge = new Knowledge(this, this.timeline);
    }

    public TimeConverter getTimeConverter(double dayWith) {
        return new TimeConverterDay(this.timeline, this.getStart(), dayWith);
    }

    public Value getExpression(String exp) {
        return this.knowledge.evaluate(exp);
    }

    public boolean affectation(String var, Value exp) {
        int idx = var.indexOf(36);
        if (idx != -1) {
            return this.affectationTask(var.substring(0, idx), var.substring(idx + 1), exp);
        }
        if (var.startsWith("^")) {
            return this.affectationJalon(var.substring(1), exp);
        }
        this.knowledge.set(var, exp);
        return true;
    }

    private boolean affectationJalon(String taskCode, Value exp) {
        TaskImpl result = new TaskImpl(this.timeline, taskCode);
        result.setStart(((ValueTime)exp).getValue());
        result.setDuration(0);
        this.tasks.add(result);
        this.knowledge.set(taskCode, exp);
        return true;
    }

    private boolean affectationTask(String taskCode, String attribute, Value exp) {
        TaskImpl t = this.getOrCreateTask(taskCode);
        TaskAttribute att = TaskAttribute.fromString(attribute);
        if (att == TaskAttribute.START) {
            t.setStart(((ValueTime)exp).getValue());
            return true;
        }
        if (att == TaskAttribute.DURATION) {
            t.setDuration(((ValueInt)exp).getValue());
            return true;
        }
        if (att == TaskAttribute.LOAD) {
            t.setLoad(((ValueInt)exp).getValue());
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private TaskImpl getOrCreateTask(String taskCode) {
        TaskImpl result = (TaskImpl)this.getTask(taskCode);
        if (result != null) {
            return result;
        }
        result = new TaskImpl(this.timeline, taskCode);
        this.tasks.add(result);
        return result;
    }

    public final List<Task> getTasks() {
        ArrayList<TaskImpl> result = new ArrayList<TaskImpl>(this.tasks);
        return Collections.unmodifiableList(result);
    }

    @Override
    public Task getTask(String code) {
        for (TaskImpl t : this.tasks) {
            if (!t.getCode().equals(code)) continue;
            return t;
        }
        Task result = null;
        for (Task task : this.tasks) {
            if (!task.getCode().startsWith(code)) continue;
            if (result == null) {
                result = task;
                continue;
            }
            result = new TaskMerge(result.getCode(), result.getName(), result, task);
        }
        return result;
    }

    public TextBlock getTimeHeader(double dayWith) {
        TimeHeaderDay day = new TimeHeaderDay(this.getStart(), this.getEnd(), this.timeline, dayWith);
        TimeHeaderMonth month = new TimeHeaderMonth(this.getStart(), this.getEnd(), this.timeline, dayWith);
        return TextBlockUtils.mergeTB(month, day, HorizontalAlignment.CENTER);
    }

    private Day getStart() {
        Day result = null;
        for (Task task : this.tasks) {
            if (result != null && result.compareTo(task.getStart()) <= 0) continue;
            result = (Day)task.getStart();
        }
        return result;
    }

    private Day getEnd() {
        Day result = null;
        for (Task task : this.tasks) {
            if (result != null && result.compareTo(task.getEnd()) >= 0) continue;
            result = (Day)task.getEnd();
        }
        return result;
    }
}

