/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.graphic;

import java.util.Map;
import java.util.SortedMap;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.project.Instant;
import net.sourceforge.plantuml.project.Item;
import net.sourceforge.plantuml.project.Jalon;
import net.sourceforge.plantuml.project.Project;
import net.sourceforge.plantuml.project.graphic.ItemHeader;
import net.sourceforge.plantuml.project.graphic.TimeScale;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttDiagram {
    private final Project project;
    private final TimeScale timeScale;
    private final ItemHeader itemHeader;
    private final HtmlColor lightGray = new HtmlColorSetSimple().getColorIfValid("#C8C8C8");

    public GanttDiagram(Project project) {
        this.project = project;
        this.timeScale = new TimeScale(project);
        this.itemHeader = new ItemHeader(project);
    }

    public void draw(UGraphic ug, double x, double y) {
        StringBounder stringBounder = ug.getStringBounder();
        double x0start = this.itemHeader.getWidth(stringBounder);
        double timeScaleHeight = this.timeScale.getHeight(stringBounder);
        SortedMap<Instant, Double> pos = this.timeScale.getAbscisse(stringBounder);
        for (Item it : this.project.getValidItems()) {
            AbstractShadowable rect;
            Instant start = it.getBegin();
            Instant completed = it.getCompleted();
            if (pos.get(start) == null || pos.get(completed) == null) {
                Log.println("PB " + it);
                continue;
            }
            double x1 = (Double)pos.get(start) + 3.0;
            double x2 = (Double)pos.get(completed) - 3.0;
            double yitem = timeScaleHeight + this.itemHeader.getPosition(stringBounder, it) + 3.0;
            if (it instanceof Jalon) {
                rect = new UPolygon();
                ((UPolygon)rect).addPoint(0.0, 3.0);
                ((UPolygon)rect).addPoint(3.0, 0.0);
                ((UPolygon)rect).addPoint(6.0, 3.0);
                ((UPolygon)rect).addPoint(3.0, 6.0);
            } else {
                rect = new URectangle(x2 - x1, 3.0);
            }
            ug = ug.apply(new UChangeColor(HtmlColorUtils.GREEN));
            ug = ug.apply(new UChangeBackColor(HtmlColorUtils.GRAY));
            ug.apply(new UTranslate(x0start + x1, yitem)).draw(rect);
        }
        this.drawGrid(ug, x + x0start, y + timeScaleHeight, pos);
        ug = ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
        ug = ug.apply(new UChangeBackColor(null));
        this.timeScale.draw(ug, x + x0start, y);
        this.itemHeader.draw(ug, x, y + timeScaleHeight);
    }

    private void drawGrid(UGraphic ug, double x, double y, SortedMap<Instant, Double> pos) {
        ULine line = new ULine(0.0, this.itemHeader.getHeight(ug.getStringBounder()));
        Instant last = null;
        for (Map.Entry<Instant, Double> ent : pos.entrySet()) {
            double xcur = ent.getValue();
            ug = last == null || last.next(null).equals(ent.getKey()) ? ug.apply(new UChangeColor(this.lightGray)) : ug.apply(new UChangeColor(HtmlColorUtils.BLACK));
            ug.apply(new UTranslate(x + xcur, y)).draw(line);
            last = ent.getKey();
        }
    }

    public double getWidth(StringBounder stringBounder) {
        return this.itemHeader.getWidth(stringBounder) + this.timeScale.getWidth(stringBounder) + 3.0;
    }

    public double getHeight(StringBounder stringBounder) {
        return this.itemHeader.getHeight(stringBounder) + this.timeScale.getHeight(stringBounder) + 3.0;
    }
}

