/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png;

import com.sun.imageio.plugins.png.PNGMetadata;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import net.sourceforge.plantuml.Log;

public class PngIOMetadata {
    private static final String copyleft = "Generated by http://plantuml.sourceforge.net";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithMetadata(RenderedImage image, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        PNGMetadata pngMetadata = new PNGMetadata();
        if (dpi != 96) {
            pngMetadata.pHYs_present = true;
            pngMetadata.pHYs_unitSpecifier = 1;
            pngMetadata.pHYs_pixelsPerUnitYAxis = pngMetadata.pHYs_pixelsPerUnitXAxis = (int)Math.round((double)dpi / 0.0254 + 0.5);
        }
        if (metadata != null) {
            pngMetadata.zTXt_keyword.add("plantuml");
            pngMetadata.zTXt_compressionMethod.add(new Integer(0));
            pngMetadata.zTXt_text.add(metadata);
        }
        if (debugData != null) {
            pngMetadata.tEXt_keyword.add("debug");
            pngMetadata.tEXt_text.add(debugData);
        }
        pngMetadata.tEXt_keyword.add("copyleft");
        pngMetadata.tEXt_text.add(copyleft);
        Log.debug("PngIOMetadata pngMetadata=" + pngMetadata);
        IIOImage iioImage = new IIOImage(image, null, (IIOMetadata)pngMetadata);
        Log.debug("PngIOMetadata iioImage=" + iioImage);
        ImageWriter imagewriter = PngIOMetadata.getImageWriter();
        Log.debug("PngIOMetadata imagewriter=" + imagewriter);
        ImageWriter imageWriter = imagewriter;
        synchronized (imageWriter) {
            imagewriter.setOutput(ImageIO.createImageOutputStream(os));
            imagewriter.write(null, iioImage, null);
            os.flush();
            imagewriter.reset();
            imagewriter.dispose();
        }
    }

    private static ImageWriter getImageWriter() {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix("png");
        Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix("png");
        while (it.hasNext()) {
            ImageWriter imagewriter = iterator.next();
            Log.debug("PngIOMetadata countImageWriter = " + it.next());
            if (!imagewriter.getClass().getName().equals("com.sun.imageio.plugins.png.PNGImageWriter")) continue;
            Log.debug("PngIOMetadata Found sun PNGImageWriter");
            return imagewriter;
        }
        Log.debug("Using first one");
        return ImageIO.getImageWritersBySuffix("png").next();
    }
}

