/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jungle;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.graphic.UDrawableUtils;
import net.sourceforge.plantuml.jungle.GNode;
import net.sourceforge.plantuml.jungle.GTileOneLevelFactory;
import net.sourceforge.plantuml.jungle.Needle;
import net.sourceforge.plantuml.jungle.Rendering;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.LimitFinder;

public class PSystemTree
extends AbstractPSystem {
    private GNode root;
    private List<GNode> stack = new ArrayList<GNode>();
    private final Rendering rendering = Rendering.NEEDLE;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Tree)", this.getClass());
    }

    @Override
    public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        ImageBuilder builder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, null, null, 5.0, 5.0, null, false);
        if (this.rendering == Rendering.NEEDLE) {
            UDrawable tmp = Needle.getNeedle(this.root, 200.0, 0.0, 60.0);
            LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
            tmp.drawU(limitFinder);
            double minY = limitFinder.getMinY();
            builder.addUDrawable(UDrawableUtils.move(tmp, 0.0, -minY));
        } else {
            builder.addUDrawable(new GTileOneLevelFactory().createGTile(this.root));
        }
        return builder.writeImageTOBEMOVED(fileFormat, os);
    }

    public CommandExecutionResult addParagraph(int level, String label) {
        if (level == 1 && this.root == null) {
            this.root = new GNode(Display.create(label));
            this.stack.add(this.root);
            return CommandExecutionResult.ok();
        }
        if (level == 1 && this.root != null) {
            return CommandExecutionResult.error("Not allowed 1");
        }
        GNode parent = this.stack.get(level - 2);
        GNode newNode = parent.addChild(Display.create(label));
        if (level > this.stack.size() + 1) {
            return CommandExecutionResult.error("Not allowed 2");
        }
        if (level - 1 == this.stack.size()) {
            this.stack.add(newNode);
        } else {
            this.stack.set(level - 1, newNode);
        }
        return CommandExecutionResult.ok();
    }
}

