/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic.color;

import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;

public class ColorParser {
    private static final String COLOR_REGEXP = "#\\w+[-\\\\|/]?\\w+";
    private final RegexLeaf regex;
    private final String name;

    private ColorParser(String name, RegexLeaf regex) {
        this.regex = regex;
        this.name = name;
    }

    public HtmlColor getColor(RegexResult arg, IHtmlColorSet set) {
        return set.getColorIfValid(arg.get("COLOR", 0));
    }

    public static RegexLeaf exp1() {
        return ColorParser.simpleColor().regex;
    }

    public static ColorParser simpleColor() {
        return new ColorParser("COLOR", new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"));
    }

    public static RegexLeaf exp2() {
        return new RegexLeaf("BACKCOLOR", "(#\\w+[-\\\\|/]?\\w+)?");
    }

    public static RegexLeaf exp3() {
        return new RegexLeaf("BACKCOLOR2", "(#\\w+[-\\\\|/]?\\w+)?");
    }

    public static RegexLeaf exp4() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+):)?");
    }

    public static RegexLeaf exp5() {
        return new RegexLeaf("COLOR", "(?::?(#\\w+[-\\\\|/]?\\w+))?");
    }

    public static RegexLeaf exp6() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+)\\|)?");
    }

    public static RegexLeaf exp7() {
        return new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+))?");
    }

    public RegexLeaf getRegex() {
        return this.regex;
    }
}

