/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlockSimple;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TextBlockSpotted
extends TextBlockSimple {
    private final CircledCharacter circledCharacter;

    public TextBlockSpotted(CircledCharacter circledCharacter, Display texts, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        super(texts, fontConfiguration, horizontalAlignment, spriteContainer, 0.0);
        this.circledCharacter = circledCharacter;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double widthCircledCharacter = this.getCircledCharacterWithAndMargin(stringBounder);
        double heightCircledCharacter = this.circledCharacter.getPreferredHeight(stringBounder);
        Dimension2D dim = super.calculateDimension(stringBounder);
        return new Dimension2DDouble(dim.getWidth() + widthCircledCharacter, Math.max(heightCircledCharacter, dim.getHeight()));
    }

    private double getCircledCharacterWithAndMargin(StringBounder stringBounder) {
        return this.circledCharacter.getPreferredWidth(stringBounder) + 6.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        this.circledCharacter.drawU(ug);
        double widthCircledCharacter = this.getCircledCharacterWithAndMargin(stringBounder);
        super.drawU(ug.apply(new UTranslate(widthCircledCharacter, 0.0)));
    }
}

