/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class TextBlockHorizontal
extends AbstractTextBlock
implements TextBlock {
    private final TextBlock b1;
    private final TextBlock b2;
    private final VerticalAlignment alignment;

    public TextBlockHorizontal(TextBlock b1, TextBlock b2, VerticalAlignment alignment) {
        this.b1 = b1;
        this.b2 = b2;
        this.alignment = alignment;
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dim1 = this.b1.calculateDimension(stringBounder);
        Dimension2D dim2 = this.b2.calculateDimension(stringBounder);
        return Dimension2DDouble.mergeLR(dim1, dim2);
    }

    @Override
    public void drawU(UGraphic ug) {
        Dimension2D dim = this.calculateDimension(ug.getStringBounder());
        Dimension2D dimb1 = this.b1.calculateDimension(ug.getStringBounder());
        Dimension2D dimb2 = this.b2.calculateDimension(ug.getStringBounder());
        Dimension2D dim1 = this.b1.calculateDimension(ug.getStringBounder());
        if (this.alignment == VerticalAlignment.CENTER) {
            this.b1.drawU(ug.apply(new UTranslate(0.0, (dim.getHeight() - dimb1.getHeight()) / 2.0)));
            this.b2.drawU(ug.apply(new UTranslate(dim1.getWidth(), (dim.getHeight() - dimb2.getHeight()) / 2.0)));
        } else {
            this.b1.drawU(ug);
            this.b2.drawU(ug.apply(new UTranslate(dim1.getWidth(), 0.0)));
        }
    }
}

