/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class SymbolContext {
    private final HtmlColor backColor;
    private final HtmlColor foreColor;
    private final UStroke stroke;
    private final boolean shadowing;
    private final double deltaShadow;

    private SymbolContext(HtmlColor backColor, HtmlColor foreColor, UStroke stroke, boolean shadowing, double deltaShadow) {
        this.backColor = backColor;
        this.foreColor = foreColor;
        this.stroke = stroke;
        this.shadowing = shadowing;
        this.deltaShadow = deltaShadow;
    }

    public String toString() {
        return super.toString() + " backColor=" + this.backColor + " foreColor=" + this.foreColor;
    }

    public final UGraphic apply(UGraphic ug) {
        return this.applyStroke(this.applyColors(ug));
    }

    public UGraphic applyColors(UGraphic ug) {
        return ug.apply(new UChangeColor(this.foreColor)).apply(new UChangeBackColor(this.backColor));
    }

    public UGraphic applyStroke(UGraphic ug) {
        return ug.apply(this.stroke);
    }

    public SymbolContext(HtmlColor backColor, HtmlColor foreColor) {
        this(backColor, foreColor, new UStroke(), false, 0.0);
    }

    public SymbolContext withShadow(boolean newShadow) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, newShadow, this.deltaShadow);
    }

    public SymbolContext withDeltaShadow(double deltaShadow) {
        return new SymbolContext(this.backColor, this.foreColor, this.stroke, this.shadowing, deltaShadow);
    }

    public SymbolContext withStroke(UStroke newStroke) {
        return new SymbolContext(this.backColor, this.foreColor, newStroke, this.shadowing, this.deltaShadow);
    }

    public SymbolContext withBackColor(HtmlColor backColor) {
        return new SymbolContext(backColor, this.foreColor, this.stroke, this.shadowing, this.deltaShadow);
    }

    public HtmlColor getBackColor() {
        return this.backColor;
    }

    public HtmlColor getForeColor() {
        return this.foreColor;
    }

    public UStroke getStroke() {
        return this.stroke;
    }

    public boolean isShadowing() {
        return this.shadowing || this.deltaShadow > 0.0;
    }

    public double getDeltaShadow() {
        return this.deltaShadow;
    }
}

