/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.geom.InflationTransform;
import net.sourceforge.plantuml.geom.Kingdom;
import net.sourceforge.plantuml.geom.LineSegmentInt;
import net.sourceforge.plantuml.geom.Point2DInt;
import net.sourceforge.plantuml.geom.Pointable;
import net.sourceforge.plantuml.geom.Polyline;
import net.sourceforge.plantuml.geom.PolylineImpl;
import net.sourceforge.plantuml.geom.XMoveable;
import net.sourceforge.plantuml.geom.kinetic.Frame;
import net.sourceforge.plantuml.geom.kinetic.Path;
import net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import net.sourceforge.plantuml.geom.kinetic.World;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;

public class Graph3 {
    private static final Graphics2D dummyGraphics2D;
    private final int spaceWidth = 40;
    private final int spaceHeight = 40;
    private final int minDistBetweenPoint = 20;
    private final double margin = 30.0;
    private final Board board;
    private final List<PolylineImpl> polylines = new ArrayList<PolylineImpl>();
    private final Map<ANode, ANodePoint> nodePoints = new LinkedHashMap<ANode, ANodePoint>();
    private int maxRow;
    private int maxCol;
    private int addedWidth = 0;
    private int addedHeight = 0;
    private final World world = new World();
    private final Map<ANodePoint, Frame> frames = new LinkedHashMap<ANodePoint, Frame>();
    private static final int STEP = 1;

    private Collection<XMoveable> convertANodeSet(Set<ANode> nodesSet) {
        HashSet<XMoveable> result = new HashSet<XMoveable>();
        for (ANode n : nodesSet) {
            assert (this.nodePoints.get(n) != null);
            result.add(this.nodePoints.get(n));
        }
        return result;
    }

    public Graph3(Board board) {
        board.normalize();
        this.board = board;
        for (ANode aNode : board.getNodes()) {
            this.maxRow = Math.max(this.maxRow, aNode.getRow());
            this.maxCol = Math.max(this.maxCol, board.getCol(aNode));
        }
        for (ANode aNode : board.getNodes()) {
            this.nodePoints.put(aNode, new ANodePoint(aNode));
        }
        this.computePolylines(board);
        InflationTransform inflationTransform = new InflationTransform();
        for (ANodePoint nodePoint : this.nodePoints.values()) {
            Point2DInt p = nodePoint.getPosition();
            AbstractEntityImage image = this.getImage(nodePoint.getNode());
            int widthCell = (int)image.getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getWidth();
            int heightCell = (int)image.getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D)).getHeight();
            if (widthCell % 2 == 1) {
                ++widthCell;
            }
            if (heightCell % 2 == 1) {
                ++heightCell;
            }
            inflationTransform.addInflationX(p.getXint(), widthCell);
            this.addedWidth += widthCell;
            inflationTransform.addInflationY(p.getYint(), heightCell);
            this.addedHeight += heightCell;
        }
        for (PolylineImpl p : this.polylines) {
            p.inflate(inflationTransform);
        }
        for (ANodePoint nodePoint : this.nodePoints.values()) {
            Point2DInt pos = nodePoint.getPosition();
            Point2DInt pos2 = inflationTransform.inflatePoint2DInt(pos);
            nodePoint.moveX(pos2.getXint() - pos.getXint());
            nodePoint.moveY(pos2.getYint() - pos.getYint());
        }
        for (ANodePoint point : this.nodePoints.values()) {
            double x = point.getPosition().getX();
            double y = point.getPosition().getY();
            Dimension2D dim = this.getImage(point.getNode()).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            Frame frame = new Frame(x, y, (int)dim.getWidth(), (int)dim.getHeight());
            this.frames.put(point, frame);
            this.world.addFrame(frame);
        }
        for (PolylineImpl polyline : this.polylines) {
            Frame f1 = this.frames.get(polyline.getStart());
            Frame f2 = this.frames.get(polyline.getEnd());
            Path path = new Path(f1, f2);
            for (Point2DInt pt : polyline.getIntermediates()) {
                path.addIntermediate(new Point2DCharge(pt.getX(), pt.getY()));
            }
            this.world.addPath(path);
        }
        this.world.renderContinue();
        Log.info("Starting moving");
        long l = System.currentTimeMillis();
        int limit = 100;
        for (int i = 0; i < 100; ++i) {
            Log.info("i=" + i);
            double move = this.world.onePass();
            if (move < 1.0) {
                Log.info("i=" + i + " " + move);
            }
            if (i != 99) continue;
            Log.info("Aborting");
        }
        long duration = System.currentTimeMillis() - l;
        Log.info("Ending moving (" + duration + " ms)");
    }

    private void computePolylines(Board board) {
        Pointable pp2;
        Pointable pp1;
        ArrayList<ALink> latter = new ArrayList<ALink>();
        Kingdom kingdom = new Kingdom();
        ArrayList<? extends ALink> links = new ArrayList<ALink>(board.getLinks());
        Collections.sort(links, board.getLinkComparator());
        for (ALink aLink : links) {
            pp1 = this.nodePoints.get(aLink.getNode1());
            pp2 = this.nodePoints.get(aLink.getNode2());
            if (kingdom.isSimpleSegmentPossible(pp1.getPosition(), pp2.getPosition())) {
                Log.println("OK for " + aLink);
                kingdom.addDirectLink(pp1.getPosition(), pp2.getPosition());
                this.polylines.add(new PolylineImpl(pp1, pp2));
                continue;
            }
            Log.println("Latter for " + aLink);
            latter.add(aLink);
        }
        Log.println("latters=" + latter.size());
        for (ALink aLink : latter) {
            Log.println("Alatter=" + aLink);
        }
        for (ALink aLink : latter) {
            Log.println("Blatter=" + aLink);
            pp1 = this.nodePoints.get(aLink.getNode1());
            pp2 = this.nodePoints.get(aLink.getNode2());
            this.polylines.add((PolylineImpl)kingdom.getPath(pp1, pp2));
        }
    }

    private void manyPasses(Board board) {
        boolean changed;
        Collection<Collection<XMoveable>> xmoveableGroups = this.getXMoveables(board);
        Log.println("COST_INIT=" + this.getCost());
        for (int i = 0; i < 300 && (changed = this.onePass(xmoveableGroups)); ++i) {
        }
        Log.println("COST_FIN=" + this.getCost());
    }

    private Collection<Collection<XMoveable>> getXMoveables(Board board) {
        HashSet<Set<ANode>> nodesGroups = new HashSet<Set<ANode>>();
        Collection<ANode> nodes = board.getNodes();
        for (ANode root : nodes) {
            for (int i = 0; i < board.getLinks().size(); ++i) {
                Set<ANode> group = board.getConnectedNodes(root, i);
                if (group.size() >= nodes.size()) continue;
                nodesGroups.add(group);
            }
        }
        ArrayList<Collection<XMoveable>> xmoveableGroups = new ArrayList<Collection<XMoveable>>();
        for (Set set : nodesGroups) {
            xmoveableGroups.add(this.convertANodeSet(set));
        }
        return xmoveableGroups;
    }

    private void moveX(Collection<XMoveable> boxes, int delta) {
        for (XMoveable b : boxes) {
            b.moveX(delta);
        }
    }

    private boolean onePass(Collection<? extends Collection<XMoveable>> subLists) {
        boolean changed = false;
        for (Collection<XMoveable> collection : subLists) {
            double initCost = this.getCost();
            assert (this.reversable(initCost, collection));
            this.moveX(collection, 1);
            if (this.getCost() < initCost) {
                changed = true;
            } else {
                this.moveX(collection, -1);
                this.moveX(collection, -1);
                if (this.getCost() < initCost) {
                    changed = true;
                } else {
                    this.moveX(collection, 1);
                    assert (this.getCost() == initCost) : "c1=" + this.getCost() + " init=" + initCost;
                }
            }
            assert (this.getCost() <= initCost);
        }
        return changed;
    }

    private boolean reversable(double initCost, Collection<XMoveable> toMove) {
        this.moveX(toMove, 1);
        this.moveX(toMove, -1);
        assert (this.getCost() == initCost);
        this.moveX(toMove, 1);
        this.moveX(toMove, -2);
        this.moveX(toMove, 1);
        assert (this.getCost() == initCost);
        return true;
    }

    private double getCostOld() {
        if (!this.mindistRespected()) {
            return Double.MAX_VALUE;
        }
        double result = 0.0;
        for (PolylineImpl p : this.polylines) {
            result += this.getLength(p);
            for (PolylineImpl other : this.polylines) {
                if (other == p || !p.doesTouch(other)) continue;
                result += this.getLength(other);
            }
        }
        return result;
    }

    private double getCost() {
        double result = 0.0;
        for (PolylineImpl p1 : this.polylines) {
            for (PolylineImpl p2 : this.polylines) {
                result += this.getCost(p1, p2);
            }
        }
        ArrayList<ANodePoint> all = new ArrayList<ANodePoint>(this.nodePoints.values());
        for (int i = 0; i < all.size() - 1; ++i) {
            for (int j = i + 1; j < all.size(); ++j) {
                double len = new LineSegmentInt(((ANodePoint)all.get(i)).getPosition(), ((ANodePoint)all.get(j)).getPosition()).getLength();
                result += 400.0 / len / len;
            }
        }
        return result;
    }

    private double getCost(PolylineImpl p1, PolylineImpl p2) {
        assert (p1.nbSegments() == 1);
        assert (p2.nbSegments() == 1);
        LineSegmentInt seg1 = p1.getFirst();
        LineSegmentInt seg2 = p2.getFirst();
        double len1 = seg1.getLength();
        if (p1 == p2) {
            return len1 / 20.0;
        }
        double len2 = seg2.getLength();
        return len1 * len2 / seg1.getDistance(seg2) / 20.0 / 20.0;
    }

    private boolean mindistRespected() {
        ArrayList<ANodePoint> all = new ArrayList<ANodePoint>(this.nodePoints.values());
        for (int i = 0; i < all.size() - 1; ++i) {
            for (int j = i + 1; j < all.size(); ++j) {
                double len = new LineSegmentInt(((ANodePoint)all.get(i)).getPosition(), ((ANodePoint)all.get(j)).getPosition()).getLength();
                if (!(len <= 20.0)) continue;
                return false;
            }
        }
        return true;
    }

    private double getLength(Polyline p) {
        double len = p.getLength();
        assert (len > 0.0);
        return Math.log(1.0 + len);
    }

    public Dimension2D getDimension() {
        double width = 40 * this.maxCol;
        int height = 40 * this.maxRow;
        return new Dimension2DDouble(width + 60.0 + (double)this.addedWidth, (double)height + 60.0 + (double)this.addedHeight);
    }

    public void draw(Graphics2D g2d) {
        g2d.translate(30.0, 30.0);
        for (Path p : this.world.getPaths()) {
            for (Line2D seg : p.segments()) {
                g2d.setColor(Color.BLUE);
                g2d.draw(seg);
                g2d.setColor(Color.RED);
                g2d.drawOval((int)seg.getX1(), (int)seg.getY1(), 1, 1);
            }
        }
        g2d.setColor(Color.GREEN);
        for (ANodePoint nodePoint : this.nodePoints.values()) {
            Frame frame = this.frames.get(nodePoint);
            AbstractEntityImage image = this.getImage(nodePoint.getNode());
            double width = image.getDimension(StringBounderUtils.asStringBounder(g2d)).getWidth();
            double height = image.getDimension(StringBounderUtils.asStringBounder(g2d)).getHeight();
            g2d.translate(frame.getX() - width / 2.0, frame.getY() - height / 2.0);
            image.draw(new ColorMapperIdentity(), g2d);
            g2d.translate(-frame.getX() + width / 2.0, -frame.getY() + height / 2.0);
        }
    }

    public void draw2(Graphics2D g2d) {
        g2d.translate(30.0, 30.0);
        g2d.setColor(Color.BLUE);
        for (Polyline polyline : this.polylines) {
            if (polyline == null) {
                Log.println("Polyline NULL!!");
                continue;
            }
            for (LineSegmentInt seg : polyline.segments()) {
                g2d.drawLine(seg.getP1().getXint(), seg.getP1().getYint(), seg.getP2().getXint(), seg.getP2().getYint());
            }
        }
        g2d.setColor(Color.GREEN);
        for (ANodePoint aNodePoint : this.nodePoints.values()) {
            Point2DInt p = aNodePoint.getPosition();
            AbstractEntityImage image = this.getImage(aNodePoint.getNode());
            int width = (int)image.getDimension(StringBounderUtils.asStringBounder(g2d)).getWidth();
            int height = (int)image.getDimension(StringBounderUtils.asStringBounder(g2d)).getHeight();
            g2d.translate(p.getXint() - width / 2, p.getYint() - height / 2);
            image.draw(new ColorMapperIdentity(), g2d);
            g2d.translate(-p.getXint() + width / 2, -p.getYint() + height / 2);
        }
    }

    private AbstractEntityImage getImage(ANode n) {
        return new EntityImageFactory().createEntityImage((IEntity)n.getUserData());
    }

    static {
        EmptyImageBuilder builder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = builder.getGraphics2D();
    }

    class ANodePoint
    implements Pointable,
    XMoveable {
        private final ANode node;
        private int deltaX = 0;
        private int deltaY = 0;

        public ANodePoint(ANode node) {
            this.node = node;
        }

        @Override
        public Point2DInt getPosition() {
            return new Point2DInt(Graph3.this.board.getCol(this.node) * 40 + this.deltaX, this.node.getRow() * 40 + this.deltaY);
        }

        @Override
        public void moveX(int delta) {
            this.deltaX += delta;
        }

        public void moveY(int delta) {
            this.deltaY += delta;
        }

        public ANode getNode() {
            return this.node;
        }
    }
}

