/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ditaa;

import net.sourceforge.plantuml.command.PSystemBasicFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.ditaa.PSystemDitaa;

public class PSystemDitaaFactory
extends PSystemBasicFactory<PSystemDitaa> {
    public PSystemDitaaFactory(DiagramType diagramType) {
        super(diagramType);
    }

    @Override
    public PSystemDitaa init(String startLine) {
        boolean performSeparationOfCommonEdges = true;
        if (startLine != null && (startLine.contains("-E") || startLine.contains("--no-separation"))) {
            performSeparationOfCommonEdges = false;
        }
        boolean dropShadows = true;
        if (startLine != null && (startLine.contains("-S") || startLine.contains("--no-shadows"))) {
            dropShadows = false;
        }
        if (this.getDiagramType() == DiagramType.UML) {
            return null;
        }
        if (this.getDiagramType() == DiagramType.DITAA) {
            return new PSystemDitaa("", performSeparationOfCommonEdges, dropShadows);
        }
        throw new IllegalStateException(this.getDiagramType().name());
    }

    @Override
    public PSystemDitaa executeLine(PSystemDitaa system, String line) {
        if (system == null && (line.equals("ditaa") || line.startsWith("ditaa("))) {
            boolean performSeparationOfCommonEdges = true;
            if (line.contains("-E") || line.contains("--no-separation")) {
                performSeparationOfCommonEdges = false;
            }
            boolean dropShadows = true;
            if (line.contains("-S") || line.contains("--no-shadows")) {
                dropShadows = false;
            }
            return new PSystemDitaa("", performSeparationOfCommonEdges, dropShadows);
        }
        if (system == null) {
            return null;
        }
        return system.add(line);
    }
}

