/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.cucadiagram.dot.OS;

class OSWindows
extends OS {
    OSWindows() {
    }

    @Override
    File getExecutable(GraphvizLayoutStrategy strategy) {
        File result = strategy.getSystemForcedExecutable();
        if (result != null) {
            return result;
        }
        result = this.searchInDir(new File("c:/Program Files"), strategy);
        if (result != null) {
            return result;
        }
        result = this.searchInDir(new File("c:/Program Files (x86)"), strategy);
        return result;
    }

    private File searchInDir(File programFile, GraphvizLayoutStrategy strategy) {
        if (!programFile.exists() || !programFile.isDirectory()) {
            return null;
        }
        ArrayList<File> dots = new ArrayList<File>();
        for (File f : programFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.getName().startsWith("Graphviz");
            }
        })) {
            File result = new File(new File(f, "bin"), this.getFileName(strategy));
            if (!result.exists() || !result.canRead()) continue;
            dots.add(result.getAbsoluteFile());
        }
        return OSWindows.higherVersion(dots);
    }

    static File higherVersion(List<File> dots) {
        if (dots.size() == 0) {
            return null;
        }
        Collections.sort(dots, Collections.reverseOrder());
        return dots.get(0);
    }

    @Override
    String getFileName(GraphvizLayoutStrategy strategy) {
        return StringUtils.goLowerCase(strategy.name()) + ".exe";
    }

    @Override
    public String getCommand(GraphvizLayoutStrategy strategy) {
        return "\"" + this.getExecutable(strategy).getAbsolutePath() + "\"";
    }
}

