/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;

public class EntityGenderUtils {
    public static EntityGender byEntityType(final LeafType type) {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return test.getEntityType() == type;
            }
        };
    }

    public static EntityGender byEntityAlone(final IEntity entity) {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return test.getUid().equals(entity.getUid());
            }
        };
    }

    public static EntityGender byStereotype(final String stereotype) {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                if (test.getStereotype() == null) {
                    return false;
                }
                return stereotype.equals(test.getStereotype().getLabel(false));
            }
        };
    }

    public static EntityGender byPackage(final IGroup group) {
        if (EntityUtils.groupRoot(group)) {
            throw new IllegalArgumentException();
        }
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                if (EntityUtils.groupRoot(test.getParentContainer())) {
                    return false;
                }
                return group == test.getParentContainer();
            }
        };
    }

    public static EntityGender and(final EntityGender g1, final EntityGender g2) {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return g1.contains(test) && g2.contains(test);
            }
        };
    }

    public static EntityGender all() {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return true;
            }
        };
    }

    public static EntityGender emptyMethods() {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return test.getBodier().getMethodsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyFields() {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return test.getBodier().getFieldsToDisplay().size() == 0;
            }
        };
    }

    public static EntityGender emptyMembers() {
        return new EntityGender(){

            @Override
            public boolean contains(IEntity test) {
                return test.getBodier().getMethodsToDisplay().size() == 0 && test.getBodier().getFieldsToDisplay().size() == 0;
            }
        };
    }
}

