/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MemberImpl;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public class Bodier {
    private final List<String> rawBody = new ArrayList<String>();
    private final Set<VisibilityModifier> hides;
    private final LeafType type;
    private List<Member> methodsToDisplay;
    private List<Member> fieldsToDisplay;
    private final boolean manageModifier;

    public Bodier(LeafType type, Set<VisibilityModifier> hides) {
        this.hides = hides;
        this.type = type;
        this.manageModifier = type == null ? false : type.manageModifier();
    }

    public void addFieldOrMethod(String s) {
        this.methodsToDisplay = null;
        this.fieldsToDisplay = null;
        this.rawBody.add(s);
    }

    private boolean isBodyEnhanced() {
        for (String s : this.rawBody) {
            if (!BodyEnhanced.isBlockSeparator(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethod(String s) {
        if (this.type == LeafType.ANNOTATION || this.type == LeafType.ABSTRACT_CLASS || this.type == LeafType.CLASS || this.type == LeafType.INTERFACE || this.type == LeafType.ENUM) {
            return MemberImpl.isMethod(s);
        }
        return false;
    }

    public List<Member> getMethodsToDisplay() {
        if (this.methodsToDisplay == null) {
            this.methodsToDisplay = new ArrayList<Member>();
            for (int i = 0; i < this.rawBody.size(); ++i) {
                String s = this.rawBody.get(i);
                if (!this.isMethod(i, this.rawBody) || s.length() == 0 && this.methodsToDisplay.size() == 0) continue;
                MemberImpl m = new MemberImpl(s, true, this.manageModifier, true);
                if (this.hides != null && this.hides.contains((Object)m.getVisibilityModifier())) continue;
                this.methodsToDisplay.add(m);
            }
            this.removeFinalEmptyMembers(this.methodsToDisplay);
        }
        return Collections.unmodifiableList(this.methodsToDisplay);
    }

    private boolean isMethod(int i, List<String> rawBody) {
        if (i > 0 && i < rawBody.size() - 1 && rawBody.get(i).length() == 0 && this.isMethod(rawBody.get(i - 1)) && this.isMethod(rawBody.get(i + 1))) {
            return true;
        }
        return this.isMethod(rawBody.get(i));
    }

    public List<Member> getFieldsToDisplay() {
        if (this.fieldsToDisplay == null) {
            this.fieldsToDisplay = new ArrayList<Member>();
            for (String s : this.rawBody) {
                if (this.isMethod(s) || s.length() == 0 && this.fieldsToDisplay.size() == 0) continue;
                MemberImpl m = new MemberImpl(s, false, this.manageModifier, true);
                if (this.hides != null && this.hides.contains((Object)m.getVisibilityModifier())) continue;
                this.fieldsToDisplay.add(m);
            }
            this.removeFinalEmptyMembers(this.fieldsToDisplay);
        }
        return Collections.unmodifiableList(this.fieldsToDisplay);
    }

    private void removeFinalEmptyMembers(List<Member> result) {
        while (result.size() > 0 && StringUtils.trin(result.get(result.size() - 1).getDisplay(false)).length() == 0) {
            result.remove(result.size() - 1);
        }
    }

    public boolean hasUrl() {
        for (Member m : this.getFieldsToDisplay()) {
            if (!m.hasUrl()) continue;
            return true;
        }
        for (Member m : this.getMethodsToDisplay()) {
            if (!m.hasUrl()) continue;
            return true;
        }
        return true;
    }

    public TextBlock getBody(FontParam fontParam, ISkinParam skinParam, boolean showMethods, boolean showFields) {
        if (this.type.isLikeClass() && this.isBodyEnhanced()) {
            if (showMethods || showFields) {
                return new BodyEnhanced(this.rawBody, fontParam, skinParam, this.manageModifier);
            }
            return null;
        }
        MethodsOrFieldsArea fields = new MethodsOrFieldsArea(this.getFieldsToDisplay(), fontParam, skinParam);
        if (this.type == LeafType.OBJECT) {
            return fields.asBlockMemberImpl();
        }
        if (!this.type.isLikeClass()) {
            throw new UnsupportedOperationException();
        }
        MethodsOrFieldsArea methods = new MethodsOrFieldsArea(this.getMethodsToDisplay(), fontParam, skinParam);
        if (showFields && !showMethods) {
            return fields.asBlockMemberImpl();
        }
        if (showMethods && !showFields) {
            return methods.asBlockMemberImpl();
        }
        if (!showFields && !showMethods) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        TextBlock bb1 = fields.asBlockMemberImpl();
        TextBlock bb2 = methods.asBlockMemberImpl();
        return new TextBlockVertical2(bb1, bb2, HorizontalAlignment.LEFT);
    }
}

