/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.utils.UniqueSequence;

public class CommandPackage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackage() {
        super(CommandPackage.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^package[%s]+"), new RegexLeaf("NAME", "([%g][^%g]+[%g]|[^#%s{}]*)"), new RegexLeaf("AS", "(?:[%s]+as[%s]+([\\p{L}0-9_.]+))?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*\\{$"));
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram diagram, RegexResult arg) {
        String color;
        String urlString;
        String display;
        Code code;
        String name = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        if (arg.get("AS", 0) == null) {
            if (name.length() == 0) {
                code = Code.of("##" + UniqueSequence.getValue());
                display = null;
            } else {
                code = Code.of(name);
                display = code.getFullName();
            }
        } else {
            display = name;
            code = Code.of(arg.get("AS", 0));
        }
        IGroup currentPackage = diagram.getCurrentGroup();
        IGroup p = diagram.getOrCreateGroup(code, Display.getWithNewlines(display), GroupType.PACKAGE, currentPackage);
        String stereotype = arg.get("STEREOTYPE", 0);
        if (stereotype != null) {
            USymbol usymbol = USymbol.getFromString(stereotype);
            if (usymbol == null) {
                p.setStereotype(new Stereotype(stereotype));
            } else {
                p.setUSymbol(usymbol);
            }
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            p.addUrl(url);
        }
        if ((color = arg.get("COLOR", 0)) != null) {
            p.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(color));
        }
        return CommandExecutionResult.ok();
    }
}

