/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

public abstract class CommandMultilinesBracket<S extends Diagram>
implements Command<S> {
    private final Pattern starting;

    public CommandMultilinesBracket(String patternStart) {
        if (!patternStart.startsWith("(?i)^") || !patternStart.endsWith("$")) {
            throw new IllegalArgumentException("Bad pattern " + patternStart);
        }
        this.starting = MyPattern.cmpile(patternStart);
    }

    protected boolean isCommandForbidden() {
        return false;
    }

    @Override
    public String[] getDescription() {
        return new String[]{"BRACKET: " + this.starting.pattern()};
    }

    protected void actionIfCommandValid() {
    }

    protected final Pattern getStartingPattern() {
        return this.starting;
    }

    @Override
    public final CommandControl isValid(BlocLines lines) {
        if (this.isCommandForbidden()) {
            return CommandControl.NOT_OK;
        }
        Matcher m1 = this.starting.matcher(StringUtils.trin(lines.getFirst499()));
        if (!m1.matches()) {
            return CommandControl.NOT_OK;
        }
        if (lines.size() == 1) {
            return CommandControl.OK_PARTIAL;
        }
        int level = 1;
        for (CharSequence cs : lines.subExtract(1, 0)) {
            String s = StringUtils.trin(cs);
            if (!this.isLineConsistent(s, level)) {
                return CommandControl.NOT_OK;
            }
            if (s.endsWith("{")) {
                ++level;
            }
            if (s.endsWith("}")) {
                --level;
            }
            if (level >= 0) continue;
            return CommandControl.NOT_OK;
        }
        if (level != 0) {
            return CommandControl.OK_PARTIAL;
        }
        this.actionIfCommandValid();
        return CommandControl.OK;
    }

    protected abstract boolean isLineConsistent(String var1, int var2);
}

