/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;

public class CommandHideShowSpecificClass
extends SingleLineCommand2<ClassDiagram> {
    public CommandHideShowSpecificClass() {
        super(CommandHideShowSpecificClass.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("CODE", "([^%s{}%g<>]+)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult arg) {
        String codeString = arg.get("CODE", 0);
        if (codeString.equals("class")) {
            classDiagram.hideOrShow(LeafType.CLASS, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else if (codeString.equals("interface")) {
            classDiagram.hideOrShow(LeafType.INTERFACE, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else {
            Code code = Code.of(codeString);
            ILeaf leaf = classDiagram.getEntityFactory().getLeafs().get(code);
            if (leaf == null) {
                return CommandExecutionResult.error("Class does not exist : " + code.getFullName());
            }
            classDiagram.hideOrShow(leaf, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        }
        return CommandExecutionResult.ok();
    }
}

