/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.classdiagram.command.GenericRegexProducer;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;

public class CommandCreateClass
extends SingleLineCommand2<ClassDiagram> {
    public static final String CODE = "[^%s{}%g<>]+";
    public static final String CODE_NO_DOTDOT = "[^%s{}%g<>:]+";

    public CommandCreateClass() {
        super(CommandCreateClass.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("TYPE", "(interface|enum|annotation|abstract[%s]+class|abstract|class)[%s]+"), new RegexOr(new RegexConcat(new RegexLeaf("DISPLAY1", "[%g](.+)[%g]"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("CODE1", "([^%s{}%g<>]+)")), new RegexConcat(new RegexLeaf("CODE2", "([^%s{}%g<>]+)"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("DISPLAY2", "[%g](.+)[%g]")), new RegexLeaf("CODE3", "([^%s{}%g<>]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexLeaf("GENERIC", "(?:[%s]*\\<(" + GenericRegexProducer.PATTERN + ")\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), CommandCreateClass.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("EXTENDS", "([%s]+(extends)[%s]+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*(?:\\s*,\\s*(?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*)*))?"), new RegexLeaf("IMPLEMENTS", "([%s]+(implements)[%s]+((?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*(?:\\s*,\\s*(?:\\.|::)?[\\p{L}0-9_]+(?:(?:\\.|::)[\\p{L}0-9_]+)*)*))?"), new RegexLeaf("$"));
    }

    public static ColorParser color() {
        return ColorParser.simpleColor();
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram diagram, RegexResult arg) {
        String urlString;
        ILeaf entity;
        LeafType type = LeafType.getLeafType(StringUtils.goUpperCase(arg.get("TYPE", 0)));
        Code code = Code.of(arg.getLazzy("CODE", 0)).eventuallyRemoveStartingAndEndingDoubleQuote("\"([:");
        String display = arg.getLazzy("DISPLAY", 0);
        String stereotype = arg.get("STEREO", 0);
        String generic = arg.get("GENERIC", 0);
        if (diagram.leafExist(code)) {
            entity = diagram.getOrCreateLeaf(code, type, null);
            entity.muteToType(type, null);
        } else {
            entity = diagram.createLeaf(code, Display.getWithNewlines(display), type, null);
        }
        if (stereotype != null) {
            entity.setStereotype(new Stereotype(stereotype, diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null, false), diagram.getSkinParam().getIHtmlColorSet()));
        }
        if (generic != null) {
            entity.setGeneric(generic);
        }
        if ((urlString = arg.get("URL", 0)) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = urlBuilder.getUrl(urlString);
            entity.addUrl(url);
        }
        entity.setSpecificBackcolor(CommandCreateClass.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        entity.setSpecificLineColor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("LINECOLOR", 1)));
        CommandCreateClassMultilines.applyStroke(entity, arg.get("LINECOLOR", 0));
        CommandCreateClassMultilines.manageExtends("EXTENDS", diagram, arg, entity);
        CommandCreateClassMultilines.manageExtends("IMPLEMENTS", diagram, arg, entity);
        return CommandExecutionResult.ok();
    }

    static enum Mode {
        EXTENDS,
        IMPLEMENTS;

    }
}

