/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextLine
extends AbstractComponentText {
    private final FileFormat fileFormat;

    public ComponentTextLine(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawVLine('\u2502', (width - 1) / 2, 0, height - 1);
        } else {
            charArea.drawVLine('|', (width - 1) / 2, 0, height - 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 3.0;
    }
}

