/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;

public class CommandPartition3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandPartition3() {
        super(CommandPartition3.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("partition"), new RegexLeaf("[%s]+"), new RegexLeaf("BACKCOLOR", "(?:(#\\w+)[%s]+)?"), new RegexLeaf("TITLECOLOR", "(?:(#\\w+)[%s]+)?"), new RegexLeaf("NAME", "([%g][^%g]+[%g]|\\S+)"), new RegexLeaf("[%s]*\\{?$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, RegexResult arg) {
        String partitionTitle = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get("NAME", 0));
        HtmlColor backColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("BACKCOLOR", 0));
        HtmlColor titleColor = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("TITLECOLOR", 0));
        diagram.startGroup(Display.getWithNewlines(partitionTitle), backColor, titleColor);
        return CommandExecutionResult.ok();
    }
}

