/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;

public class CommandPartition
extends SingleLineCommand<ActivityDiagram> {
    public CommandPartition() {
        super("(?i)^partition[%s]+([%g][^%g]+[%g]|\\S+)[%s]*(#[0-9a-fA-F]{6}|#?\\w+)?[%s]*\\{?$");
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram diagram, List<String> arg) {
        Code code = Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(arg.get(0)));
        IGroup currentPackage = diagram.getCurrentGroup();
        IGroup p = diagram.getOrCreateGroup(code, Display.getWithNewlines(code), GroupType.PACKAGE, currentPackage);
        String color = arg.get(1);
        if (color != null) {
            p.setSpecificBackcolor(diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(color));
        }
        return CommandExecutionResult.ok();
    }
}

