/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.command.regex.MyPattern;

public class UrlBuilder {
    private static final String URL_PATTERN = "\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{([^{}]+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]";
    private final String topurl;
    private ModeUrl mode;

    public UrlBuilder(String topurl, ModeUrl mode) {
        this.topurl = topurl;
        this.mode = mode;
    }

    public Url getUrl(String s) {
        Pattern p;
        if (this.mode == ModeUrl.STRICT) {
            p = MyPattern.cmpile("(?i)^\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{([^{}]+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]$");
        } else if (this.mode == ModeUrl.AT_START) {
            p = MyPattern.cmpile("(?i)^\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{([^{}]+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\].*");
        } else if (this.mode == ModeUrl.AT_END) {
            p = MyPattern.cmpile("(?i).*\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{([^{}]+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\]$");
        } else if (this.mode == ModeUrl.ANYWHERE) {
            p = MyPattern.cmpile("(?i).*\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{([^{}]+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\].*");
        } else {
            throw new IllegalStateException();
        }
        Matcher m = p.matcher(StringUtils.trinNoTrace(s));
        if (!m.matches()) {
            return null;
        }
        String url = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(m.group(1));
        if (!url.startsWith("http:") && !url.startsWith("https:") && this.topurl != null) {
            url = this.topurl + url;
        }
        return new Url(url, m.group(2), m.group(3));
    }

    public static String getRegexp() {
        return URL_PATTERN;
    }

    public static String purgeUrl(String label) {
        Pattern p = MyPattern.cmpile("[%s]*\\[\\[([%g][^%g]+[%g]|[^{}%s\\]\\[]*)(?:[%s]*\\{([^{}]+)\\})?(?:[%s]*([^\\]\\[]+))?\\]\\][%s]*");
        Matcher m = p.matcher(label);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String url = m.group(0);
        int x = label.indexOf(url);
        return label.substring(0, x) + label.substring(x + url.length());
    }

    public static enum ModeUrl {
        STRICT,
        AT_START,
        ANYWHERE,
        AT_END;

    }
}

