/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;

public class FileUtils {
    private static AtomicInteger counter;

    public static void resetCounter() {
        counter = new AtomicInteger(0);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File f;
        if (!suffix.startsWith(".")) {
            throw new IllegalArgumentException();
        }
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (counter == null) {
            f = File.createTempFile(prefix, suffix);
        } else {
            String name = prefix + counter.addAndGet(1) + suffix;
            f = new File(name);
        }
        Log.info("Creating temporary file: " + f);
        if (!OptionFlags.getInstance().isKeepTmpFiles()) {
            f.deleteOnExit();
        }
        return f;
    }

    private static void copyInternal(InputStream fis, OutputStream fos) throws IOException {
        int len;
        byte[] buf = new byte[10240];
        while ((len = fis.read(buf)) > 0) {
            fos.write(buf, 0, len);
        }
        fos.close();
        fis.close();
    }

    public static void copyToFile(File src, File dest) throws IOException {
        if (dest.isDirectory()) {
            dest = new File(dest, src.getName());
        }
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dest));
        FileUtils.copyInternal(fis, fos);
    }

    public static void copyToStream(File src, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos);
    }

    public static void copyToStream(InputStream is, OutputStream os) throws IOException {
        BufferedInputStream fis = new BufferedInputStream(is);
        BufferedOutputStream fos = new BufferedOutputStream(os);
        FileUtils.copyInternal(fis, fos);
    }

    public static void copyToFile(byte[] src, File dest) throws IOException {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dest));
        ((OutputStream)fos).write(src);
        ((OutputStream)fos).close();
    }
}

