/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class EmptyImageBuilder {
    private final BufferedImage im;
    private final Graphics2D g2d;

    public EmptyImageBuilder(double width, double height, Color background) {
        this((int)width, (int)height, background);
    }

    public EmptyImageBuilder(int width, int height, Color background) {
        Log.info("Creating image " + width + "x" + height);
        this.im = new BufferedImage(width, height, background == null ? 2 : 1);
        this.g2d = this.im.createGraphics();
        UAntiAliasing.ANTI_ALIASING_ON.apply(this.g2d);
        if (background != null) {
            this.g2d.setColor(background);
            this.g2d.fillRect(0, 0, width, height);
        }
    }

    public EmptyImageBuilder(int width, int height, Color background, double dpiFactor) {
        this((double)width * dpiFactor, (double)height * dpiFactor, background);
        if (dpiFactor != 1.0) {
            this.g2d.setTransform(AffineTransform.getScaleInstance(dpiFactor, dpiFactor));
        }
    }

    public BufferedImage getBufferedImage() {
        return this.im;
    }

    public Graphics2D getGraphics2D() {
        return this.g2d;
    }

    public UGraphicG2d getUGraphicG2d() {
        UGraphicG2d result = new UGraphicG2d(new ColorMapperIdentity(), this.g2d, 1.0);
        result.setBufferedImage(this.im);
        return result;
    }
}

