/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.CharSequence2Impl;
import net.sourceforge.plantuml.LineLocationImpl;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemBuilder;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.core.Diagram;

public class BlockUml {
    private final List<CharSequence2> data;
    private final int startLine;
    private Diagram system;
    private static final Pattern patternFilename = MyPattern.cmpile("^@start[^%s{}%g]+[%s{][%s%g]*([^%g]*?)[%s}%g]*$");

    BlockUml(String ... strings) {
        this(BlockUml.convert(strings), 0);
    }

    public String getFlashData() {
        StringBuilder sb = new StringBuilder();
        for (CharSequence2 line : this.data) {
            sb.append(line);
            sb.append('\r');
            sb.append('\n');
        }
        return sb.toString();
    }

    public static List<CharSequence2> convert(String ... strings) {
        return BlockUml.convert(Arrays.asList(strings));
    }

    public static List<CharSequence2> convert(List<String> strings) {
        ArrayList<CharSequence2> result = new ArrayList<CharSequence2>();
        LineLocationImpl location = new LineLocationImpl("block", null);
        for (String s : strings) {
            location = location.oneLineRead();
            result.add(new CharSequence2Impl(s, location));
        }
        return result;
    }

    public BlockUml(List<CharSequence2> strings, int startLine) {
        this.startLine = startLine;
        CharSequence2 s0 = strings.get(0).trin();
        if (!s0.startsWith("@start")) {
            throw new IllegalArgumentException();
        }
        this.data = new ArrayList<CharSequence2>(strings);
    }

    public String getFileOrDirname() {
        if (OptionFlags.getInstance().isWord()) {
            return null;
        }
        Matcher m = patternFilename.matcher(StringUtils.trin(this.data.get(0).toString()));
        boolean ok = m.find();
        if (!ok) {
            return null;
        }
        String result = m.group(1);
        int x = result.indexOf(44);
        if (x != -1) {
            result = result.substring(0, x);
        }
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if ("<>|".indexOf(c) == -1) continue;
            return null;
        }
        if (result.startsWith("file://")) {
            result = result.substring("file://".length());
        }
        return result;
    }

    public Diagram getDiagram() {
        if (this.system == null) {
            this.system = new PSystemBuilder().createPSystem(this.data);
        }
        return this.system;
    }

    public final int getStartLine() {
        return this.startLine;
    }
}

