/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Properties;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ProtectedCommand;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.Version;

public abstract class AbstractPSystem
implements Diagram {
    private UmlSource source;

    private String getVersion() {
        StringBuilder toAppend = new StringBuilder();
        toAppend.append("PlantUML version ");
        toAppend.append(Version.versionString());
        toAppend.append("(" + Version.compileTimeString() + ")\n");
        toAppend.append("(" + (Object)((Object)License.getCurrent()) + " source distribution)\n");
        Properties p = System.getProperties();
        toAppend.append(p.getProperty("java.runtime.name"));
        toAppend.append('\n');
        toAppend.append(p.getProperty("java.vm.name"));
        toAppend.append('\n');
        toAppend.append(p.getProperty("java.runtime.version"));
        toAppend.append('\n');
        toAppend.append(p.getProperty("os.name"));
        return toAppend.toString();
    }

    @Override
    public final String getMetadata() {
        if (this.source == null) {
            return this.getVersion();
        }
        return this.source.getPlainString() + "\n" + this.getVersion();
    }

    @Override
    public final UmlSource getSource() {
        return this.source;
    }

    public final void setSource(UmlSource source) {
        this.source = source;
    }

    @Override
    public int getNbImages() {
        return 1;
    }

    public Display getTitle() {
        if (this.source == null) {
            return Display.empty();
        }
        return this.source.getTitle();
    }

    @Override
    public String getWarningOrError() {
        return null;
    }

    public void makeDiagramReady() {
    }

    public boolean isOk() {
        return true;
    }

    public CommandExecutionResult executeCommand(Command cmd, BlocLines lines) {
        cmd = new ProtectedCommand(cmd);
        return cmd.execute(this, lines);
    }

    @Override
    public boolean hasUrl() {
        return false;
    }
}

