<!-- SPDX-License-Identifier: CC-BY-4.0 -->
<!-- Copyright Contributors to the OpenColorIO Project. -->

September 8, 2020

Host: Michael Dolan

Attendees:
  * [X] Mark Boorer (_TSC_) - Industrial Light & Magic
  * [] Sean Cooper (_TSC ACES TAC Rep_) - DNEG
  * [X] Michael Dolan (_TSC Chair_) - Epic Games
  * [X] Carol Payne (_TSC_) - Netflix
  * [X] Doug Walker (_TSC Chief Architect_) - Autodesk
  * [X] Kevin Wheatley (_TSC_) - Framestore
  * [X] Matthias Scharfenberg - Industrial Light & Magic
  * [X] Dennis Adams - Sony
  * [X] Thomas Mansencal - Weta Digital

Apologies:
  * Sean Cooper

# **OCIO Configs Working Group Meeting Notes**

* PR #5 - “aces-dev” Reference Config Generator:
    - Thomas: In progress. Big missing piece is transforms, which are not 
      mapped yet, but color spaces should all be there.
    - Michael: Question about "undefined" display. Can that be named?
    - Thomas: Trying to massage CTL to get names. aces-dev not ready to be 
      ingested like this. Transform IDs are busted. Display is "undefined" 
      since it contains transforms that are not categorized. Scott will 
      classify these.
    - Michael: HDR most likely?
    - Doug: Ideally classified as P3-D65, ST2084, etc.
    - Thomas: BuiltinTransform next piece. Then talk about what to do for 
      displays, display reference space, etc. Doing some string massaging, 
      which prevents matching old ACES config. Should keep names consistent 
      where possible.
    - Doug: There is an issue in OCIO GH talking about improved way to deal 
      with aliases. Current ACES config  has many aliases for including in 
      file paths, but it’s a maintenance problem since the color spaces are 
      duplicated. Could add an alias feature to color space in core OCIO.
    - Michael: Have written code to alias by duplicating color spaces in the 
      past. Alias feature would be useful.
    - Doug: Without fallback mechanism, will create unhappy users.
    - Michael: Would create clutter trying to be backwards compatible without 
      that.
    - Thomas: Maybe we can create a shim, or document/tool for migration. 
      Otherwise we're building on dirty foundation.
    - Mark: Also missing the new color space name formatting. Had discussed 
      move to transfer function and gamut convention. If we were to move 
      forward, would be good to make ground truth adhere to that first.
    - Thomas: Tried to be consistent, but we can change the way things are 
      named.
    - Michael: Tricky because would require scripts to edit DCC scene files. 
      Maybe just provide data for mapping in implemented pipeline code.
    - Thomas: It won't just be names. There is stuff that needs to go away to 
      clean up config. Mapping doesn't cost much, can have it.
    - Kevin: What has been generated makes sense for core ACES, since it 
      follows CTL. The more encompassing config could follow the old naming to 
      help with migration. Could be fit into generator. Color space names 
      issues should be fixed on ACES side, if users want to adhere to ACES.
    - Thomas: Problem is if we allow users to stick to old naming it will 
      prevent migration. Maybe provide method, but not direct support.
    - Doug: If we had ability to define alias with color space, a DCC would use 
      the official name, so if someone opens something that uses the old name, 
      the DCC could do conversion automatically through alias system.
    - Mark: Don’t think it will matter much. Not great when DCC writes color 
      space name to file. Can use roles now to accomplish this.
    - Matthias: Roles would perpetuate the old names.
    - Mark: Don’t think DCC needs to be considered as long as names resolve to 
      the correct color space.
    - Doug: Our DCCs do need to store color space names to save color 
      management behavior. Could be manageable to convert names though.
    - Matthias: Would this lookup be provided as a separate file? Or would this 
      be provided as part of a color space definition? And DCC would see that 
      it’s an alias and update the string value to the actual color space?
    - Doug: The proposal on GH is just to add alias attribute with list of 
      strings. Haven't figured out details, but an API call could be added to 
      check if a name is an alias or not, to get the canonical name.
    - Mark: That would help the DCC but not the user. If the old name had a 
      different family for example, would that require family aliases, etc?
    - Matthias: Trying to avoid users perpetuating old names. Can put that in 
      documentation somewhere. 
    - Mark: How to handle the months during transition. Is it worth the effort, 
      or do we encourage starting fresh?
    - Doug: Wasn’t clear to me that aliases need to show up in UI at all. 
      Internal convention.
    - All: Agree that aliases don't need to show up in UI.
    - Mark: It’s mostly so that a DCC that saved with the old name can continue 
      to work with the new name.
    - Carol: People will want to know what the changed color space names mean.
    - Mark: Only way to describe is with description string, or in name.
    - Doug: Was thinking most of these changes would be fairly clear, subtle 
      renames. Different, but similar. Names are informed from string. Previous 
      aliases were for convenience for filename and commandline tools.
    - Carol: Yes, would be cool to have that as alias, but not color space 
      name.
    - Mark: Think all color space names should be clear, short names, and put 
      more data in description.
    - Kevin: Also issue of AMF files referring to color spaces by name from 
      ACES. 
    - Thomas: We could also store full ACES transform ID as alias. Ground 
      truth.
    - Mark: That’s AMF consideration though. Nothing to do with us.
    - Carol: Has to do with us if we need to relate AMF to OCIO config. 
    - Mark: There’s been little coordination from AMF team about how that 
      information is supposed to flow into VFX world. Will be responsibility 
      of AMF reading tool and authors to handle these details.
    - Carol: If we’re designing an ACES reference config, AMF is part of ACES, 
      so we need to consider how the whole ACES pipeline works together.
    - Kevin: Agree with Mark that we won't use this internally, but we will 
      have to deal with it with vendors who we need to hand files off to.
    - Mark: We’re supposed to represent ACES in a way that works well for OCIO, 
      which may not be perfectly inline with how ACES community names and 
      structures their files. Much more concerned with how this config will 
      work as OCIO config. Less about AMF and Academy structure decisions. 
    - Thomas: It is an ACES config though.
    - Carol: Be better if we worked together rather than working in silo. We 
      can work with ACES to make a better OCIO config.
    - Doug: at the end of day, naming discussions are contentious. The 
      transform ID strings are a bit missed up, but Scott will probably fix 
      that. This may be a logo requirement too. To be product partner we’ll 
      need to follow logo guidelines. The name that shows up in UI is under 
      their purview. Open to our participation, but not realistic to sway 
      their naming based on our limitations (i.e. name in filename).
    - Carol: Think the alias solution is a good solution. Pretty elegant and 
      don't think people would have a lot of issue with it.
    - Thomas. Yeah, at end of the day its a UI issue. DCC can choose to switch 
      the display of color space on their end.
    - Doug: From a DCC perspective, we’re trying to let the config author 
      decide that. At the end of the day the config should define the names in 
      menus, but maybe DCC could add option to see aliases for canonical name. 
      More a DCC specific choice based on requests from user base.
    - Mark: If we make blanket statement that alias never shows up in DCC, then 
      they have to be entered as separate color spaces with duplicate entries 
      in config.
    - Doug: Would be possible to get alias reference from API.
    - Mark: Think it would be better for aliases to be only for backwards 
      compatibility.
    - Doug: Yes agree. If you need something to show up in menu, should be 
      added as duplicate color space.
    - Carol: From a user perspective, the general user may not understand that 
      the canonical and alias names are the same and can be used 
      interchangeably. That’s a concern we hear a lot.
    - Matthias: Could aliases show up in description string in tooltip in DCC?
    - Dennis: Is there a recommendation on creating hierarchy based on 
      separators?
    - Doug: Family can be used for that and some code in OCIO helpers will help 
      do that. Now a 'family_separator' property to help standardize.

* BuiltinTransform skeleton, implementations:
    - Michael: Now that the config skeleton is created, will need to create 
      skeletons for BuiltinTransform in core OCIO. Thoughts on how to proceed?
    - Doug: Builtin transform accessed with a name string. Ideally with this 
      mechanism in place to pull names from ACES, would be cool if those 
      strings could match up in core OCIO to avoid manual interventions.
    - Thomas: All the strings you see here are programmatically generated from 
      CTL transform ID. Can be used to call transform. Could use CTL transform 
      ID. Will try adding transforms next week to see how config generates. 
    - Michael: Wait for config update to touch C++?
    - Thomas: Yes, in next two weeks will find some time.
    - Michael: Will all builtin transforms use existing ops? Is anything 
      missing algorithm-wise needed to support ACES?
    - Doug: Some, like PQ will be represented with LUT, but can be generated 
      internally.
    - Thomas: Maybe the current generator could generate core skeleton from 
      aces-dev. Instead of manually going through and adding everything. Maybe 
      could generate the files. Just a suggestion.
    - Mark: Think we want to keep those things separate. Be human added.
    - Thomas: Could be a lot of files.
    - Mark: Want someone to vet them.
    - Thomas: Agree. Generation code could just generate them, and then review 
      that code manually. Think will need a discreet file per edge in the 
      graph, and there are a ton of edges in graph. If you want to reference 
      implementation, we need a transform for each edge.
    - Mark: Your current PR is more than we would consider in the library. 
      Current config has camera transforms.
    - Thomas: Yes, IDTs can be removed. Let’s talk just about output 
      transforms. Think we need a builtin transform for each discreet ODT.
    - Doug: For output transforms, it’s a bit of a separate case. Will make 
      proposal of how to use display reference space and view transforms to 
      reduce the builtin transform requirement.
    - Kevin: Could write a parser for CTL to generate OCIO properly. Detect 
      matrix operator, etc.
    - Mark: Working on CTL parser for OpenColorMath, which was hoping could be 
      used here. Then could reference CTL directly.
    - Michael: Can always update implementation later.
    - Doug: Want something in near term to help people use new OCIO. Going to 
      update config writing to not write default values, which will reduce 
      config size.
    - Mark: If no equality groups, entire config is a no-op. That will need to 
      be addressed.
