<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;"> <!ENTITY lf "&#10;">]>

<!-- $NetBSD: listmaintports.xsl,v 1.3 2025/07/24 18:09:59 martin Exp $ -->

<!-- Copyright (c) 2007
	The NetBSD Foundation, Inc.  ALL RIGHTS RESERVED. -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:vendor="http://exslt.org/common"
		exclude-result-prefixes="vendor"
                version="1.0">

  <xsl:strip-space elements="people"/>

  <xsl:template mode="listports" match="*|/">
    <xsl:apply-templates mode="listports"/>
  </xsl:template>


  <xsl:template match="people/developer/portmaster" mode="listports">
    <port>
      <xsl:attribute name="name">
	<xsl:value-of select="."/>
      </xsl:attribute>
      <maintainer>
	<xsl:copy-of select="../name"/>
	<xsl:copy-of select="../email"/>
	<xsl:copy-of select="../url"/>
      </maintainer>
    </port><xsl:text>&lf;</xsl:text>
  </xsl:template>

  <xsl:template match="developer" mode="listports">
    <xsl:apply-templates mode="listports" select="portmaster"/>
  </xsl:template>

  <xsl:template name="sortuniqports">
    <xsl:param name="duplicports"/>
    <xsl:for-each select="$duplicports[not(@name=preceding-sibling::port/@name)]">
	 <xsl:sort select="./@name" data-type="text"/>
          <xsl:copy>
	    <xsl:copy-of select="@*"/>
	  </xsl:copy>
     </xsl:for-each>
  </xsl:template>

  <!-- 
    Returns the port list as created from the developer database by
    the update-portcache.xsl template.  Result of that template is
    expected to be cached in the portlist.xml file to avoid processing
    the huge developerdb.xml file every time.
  -->
  <xsl:template name="devdb2ports">
    <xsl:copy-of select="document('../../people/portlist.xml')"/>
  </xsl:template>

  <xsl:template name="listmaintports">
    <xsl:variable name="duplicports">
      <xsl:call-template name="devdb2ports"/>
    </xsl:variable>
    <xsl:call-template name="sortuniqports">
      <xsl:with-param name="duplicports" select="vendor:node-set($duplicports)/ports/port"/>
    </xsl:call-template>
  </xsl:template>

</xsl:stylesheet>
