## Submitting issues

### Reduced test case required

All bug reports and problem issues require a [**reduced test case**](https://css-tricks.com/reduced-test-cases/). Create one by forking any one of the [CodePen demos](https://codepen.io/desandro/pens/tags/?grid_type=list&selected_tag=flickity-docs&sort_order=asc) from [the docs](https://flickity.metafizzy.co).

**CodePens**

+ [Basic](https://codepen.io/desandro/pen/azqbop)
+ [imagesLoaded](https://codepen.io/desandro/pen/MYQWEe)
+ [lazyLoad](https://codepen.io/desandro/pen/vOeGzL)
+ [autoPlay](https://codepen.io/desandro/pen/RNQwaB)

**Test cases**

+ A reduced test case clearly demonstrates the bug or issue.
+ It contains the bare minimum HTML, CSS, and JavaScript required to demonstrate the bug.
+ A link to your production site is **not** a reduced test case.

Providing a reduced test case is the best way to get your issue addressed. They help you point out the problem. They help me verify and debug the problem. They help others understand the problem. Without a reduced test case, your issue may be closed.

## Pull requests

Contributions are welcome! 

+ **For typos and one-line fixes,** send those right in.
+ **For larger features,** open an issue before starting any significant work. Let's discuss to see how your feature fits within Flickity's vision.
+ **Follow the code style.** Spaces in brackets, semicolons, trailing commas.
+ **Do not edit `dist/` files.** Make your edits to source files in `js/` and `css/`.
+ **Do not run `gulp` to update `dist/` files.** I'll take care of this when I create a new release.

Your code will be used as part of a commercial product if merged. By submitting a Pull Request, you are giving your consent for your code to be integrated into Flickity as part of a commercial product. 
