/*	$NetBSD: $	*/

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

struct fec_rxframe {
	uint8_t		rx_rcvcnt;
	uint8_t		rx_rcvsts;
	uint8_t		rx_rntpc;
	uint8_t		rx_rcvcc;
	uint8_t		*rx_frame;
};

struct fec_softc {
	device_t	sc_dev;		/* base device glue */
	struct ethercom	sc_ethercom;	/* Ethernet common part */
#define	sc_if		sc_ethercom.ec_if
	struct mii_data	sc_mii;
	struct callout	sc_tick_ch;
	struct ifmedia	sc_media;

	short		sc_if_flags;
	uint8_t		sc_enaddr[ETHER_ADDR_LEN];
	int		sc_havecarrier; /* carrier status */

	void		(*sc_bus_init)(struct mc_softc *);
	void		(*sc_putpacket)(struct mc_softc *, u_int);
	int		(*sc_mediachange)(struct mc_softc *);
	void		(*sc_mediastatus)(struct mc_softc *,
				struct ifmediareq *);

	bus_space_tag_t	sc_regt;
	bus_space_handle_t sc_regh;

	u_char		*sc_txbuf, *sc_rxbuf;
	int		sc_txbuf_phys, sc_rxbuf_phys;
	int		sc_tail;

	int		sc_tx_task;
	int		sc_rx_task;
};

int fec_init(struct fec_softc *, uint8_t *);
void fecintr(void *);
