/*	$NetBSD: $ */

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Robert Swindells
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: $");

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/conf.h>
#include <sys/device.h>
#include <sys/malloc.h>
#include <sys/kernel.h>

#include <dev/ofw/openfirm.h>

#include <machine/autoconf.h>
#include <machine/bus.h>

#include <arch/powerpc/mpc5200/mpc5200reg.h>
#include <arch/powerpc/mpc5200/mpc5200var.h>

static int cdm_match(device_t, cfdata_t, void *);
static void cdm_attach(device_t, device_t, void *);

struct cdm_softc {
	device_t		sc_dev;
	bus_space_tag_t		sc_iot;
	bus_space_handle_t	sc_ioh;
};

CFATTACH_DECL_NEW(cdm, sizeof(struct cdm_softc),
	cdm_match, cdm_attach, NULL, NULL);

static int
cdm_match(device_t parent, cfdata_t cf, void *aux)
{
	struct confargs *ca = aux;
	char name[32];

	if (strcmp(ca->ca_name, "cdm") != 0)
		return 0;

	OF_getprop(ca->ca_node, "compatible", name, sizeof(name));
	aprint_normal("cdm_match name: %s\n", name);
#if 0
	if (strcmp(name, "mpc5200-ata") != 0)
		return 0;
#endif

	return 1;
}

static void
cdm_attach(device_t parent, device_t self, void *aux)
{
	struct cdm_softc *sc = device_private(self);
	struct confargs *ca = aux;
	struct reg {
		uint32_t addr;
		uint32_t size;
	} range, *rp = &range;

	aprint_normal("\n");

	sc->sc_dev = self;
	sc->sc_iot = ca->ca_tag;

	if (OF_getprop(ca->ca_node, "reg", rp, sizeof(range))
	    != sizeof(range))
		return;

	if (bus_space_map(sc->sc_iot, rp->addr, rp->size, 0, &sc->sc_ioh) != 0)
		aprint_normal_dev(self, "map failed\n");


	aprint_normal_dev(self, "Fractional Divider %x\n",
			  bus_space_read_4(sc->sc_iot, sc->sc_ioh, CDM_FRAC_DIV));
	aprint_normal_dev(self, "Clock Enable %x\n",
			  bus_space_read_4(sc->sc_iot, sc->sc_ioh, CDM_CLK_ENABLE));

}
