/*	$NetBSD: imx53-pinfunc.h,v 1.1.1.3 2020/01/03 14:33:17 skrll Exp $	*/

/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright 2013 Freescale Semiconductor, Inc.
 */

#ifndef __DTS_IMX53_PINFUNC_H
#define __DTS_IMX53_PINFUNC_H

/*
 * The pin function ID is a tuple of
 * <mux_reg conf_reg input_reg mux_mode input_val>
 */
#define MX53_PAD_GPIO_19__KPP_COL_5				0x020 0x348 0x840 0x0 0x0
#define MX53_PAD_GPIO_19__GPIO4_5				0x020 0x348 0x000 0x1 0x0
#define MX53_PAD_GPIO_19__CCM_CLKO				0x020 0x348 0x000 0x2 0x0
#define MX53_PAD_GPIO_19__SPDIF_OUT1				0x020 0x348 0x000 0x3 0x0
#define MX53_PAD_GPIO_19__RTC_CE_RTC_EXT_TRIG2			0x020 0x348 0x000 0x4 0x0
#define MX53_PAD_GPIO_19__ECSPI1_RDY				0x020 0x348 0x000 0x5 0x0
#define MX53_PAD_GPIO_19__FEC_TDATA_3				0x020 0x348 0x000 0x6 0x0
#define MX53_PAD_GPIO_19__SRC_INT_BOOT				0x020 0x348 0x000 0x7 0x0
#define MX53_PAD_KEY_COL0__KPP_COL_0				0x024 0x34c 0x000 0x0 0x0
#define MX53_PAD_KEY_COL0__GPIO4_6				0x024 0x34c 0x000 0x1 0x0
#define MX53_PAD_KEY_COL0__AUDMUX_AUD5_TXC			0x024 0x34c 0x758 0x2 0x0
#define MX53_PAD_KEY_COL0__UART4_TXD_MUX			0x024 0x34c 0x000 0x4 0x0
#define MX53_PAD_KEY_COL0__ECSPI1_SCLK				0x024 0x34c 0x79c 0x5 0x0
#define MX53_PAD_KEY_COL0__FEC_RDATA_3				0x024 0x34c 0x000 0x6 0x0
#define MX53_PAD_KEY_COL0__SRC_ANY_PU_RST			0x024 0x34c 0x000 0x7 0x0
#define MX53_PAD_KEY_ROW0__KPP_ROW_0				0x028 0x350 0x000 0x0 0x0
#define MX53_PAD_KEY_ROW0__GPIO4_7				0x028 0x350 0x000 0x1 0x0
#define MX53_PAD_KEY_ROW0__AUDMUX_AUD5_TXD			0x028 0x350 0x74c 0x2 0x0
#define MX53_PAD_KEY_ROW0__UART4_RXD_MUX			0x028 0x350 0x890 0x4 0x1
#define MX53_PAD_KEY_ROW0__ECSPI1_MOSI				0x028 0x350 0x7a4 0x5 0x0
#define MX53_PAD_KEY_ROW0__FEC_TX_ER				0x028 0x350 0x000 0x6 0x0
#define MX53_PAD_KEY_COL1__KPP_COL_1				0x02c 0x354 0x000 0x0 0x0
#define MX53_PAD_KEY_COL1__GPIO4_8				0x02c 0x354 0x000 0x1 0x0
#define MX53_PAD_KEY_COL1__AUDMUX_AUD5_TXFS			0x02c 0x354 0x75c 0x2 0x0
#define MX53_PAD_KEY_COL1__UART5_TXD_MUX			0x02c 0x354 0x000 0x4 0x0
#define MX53_PAD_KEY_COL1__ECSPI1_MISO				0x02c 0x354 0x7a0 0x5 0x0
#define MX53_PAD_KEY_COL1__FEC_RX_CLK				0x02c 0x354 0x808 0x6 0x0
#define MX53_PAD_KEY_COL1__USBPHY1_TXREADY			0x02c 0x354 0x000 0x7 0x0
#define MX53_PAD_KEY_ROW1__KPP_ROW_1				0x030 0x358 0x000 0x0 0x0
#define MX53_PAD_KEY_ROW1__GPIO4_9				0x030 0x358 0x000 0x1 0x0
#define MX53_PAD_KEY_ROW1__AUDMUX_AUD5_RXD			0x030 0x358 0x748 0x2 0x0
#define MX53_PAD_KEY_ROW1__UART5_RXD_MUX			0x030 0x358 0x898 0x4 0x1
#define MX53_PAD_KEY_ROW1__ECSPI1_SS0				0x030 0x358 0x7a8 0x5 0x0
#define MX53_PAD_KEY_ROW1__FEC_COL				0x030 0x358 0x800 0x6 0x0
#define MX53_PAD_KEY_ROW1__USBPHY1_RXVALID			0x030 0x358 0x000 0x7 0x0
#define MX53_PAD_KEY_COL2__KPP_COL_2				0x034 0x35c 0x000 0x0 0x0
#define MX53_PAD_KEY_COL2__GPIO4_10				0x034 0x35c 0x000 0x1 0x0
#define MX53_PAD_KEY_COL2__CAN1_TXCAN				0x034 0x35c 0x000 0x2 0x0
#define MX53_PAD_KEY_COL2__FEC_MDIO				0x034 0x35c 0x804 0x4 0x0
#define MX53_PAD_KEY_COL2__ECSPI1_SS1				0x034 0x35c 0x7ac 0x5 0x0
#define MX53_PAD_KEY_COL2__FEC_RDATA_2				0x034 0x35c 0x000 0x6 0x0
#define MX53_PAD_KEY_COL2__USBPHY1_RXACTIVE			0x034 0x35c 0x000 0x7 0x0
#define MX53_PAD_KEY_ROW2__KPP_ROW_2				0x038 0x360 0x000 0x0 0x0
#define MX53_PAD_KEY_ROW2__GPIO4_11				0x038 0x360 0x000 0x1 0x0
#define MX53_PAD_KEY_ROW2__CAN1_RXCAN				0x038 0x360 0x760 0x2 0x0
#define MX53_PAD_KEY_ROW2__FEC_MDC				0x038 0x360 0x000 0x4 0x0
#define MX53_PAD_KEY_ROW2__ECSPI1_SS2				0x038 0x360 0x7b0 0x5 0x0
#define MX53_PAD_KEY_ROW2__FEC_TDATA_2				0x038 0x360 0x000 0x6 0x0
#define MX53_PAD_KEY_ROW2__USBPHY1_RXERROR			0x038 0x360 0x000 0x7 0x0
#define MX53_PAD_KEY_COL3__KPP_COL_3				0x03c 0x364 0x000 0x0 0x0
#define MX53_PAD_KEY_COL3__GPIO4_12				0x03c 0x364 0x000 0x1 0x0
#define MX53_PAD_KEY_COL3__USBOH3_H2_DP				0x03c 0x364 0x000 0x2 0x0
#define MX53_PAD_KEY_COL3__SPDIF_IN1				0x03c 0x364 0x870 0x3 0x0
#define MX53_PAD_KEY_COL3__I2C2_SCL				0x03c 0x364 0x81c 0x4 0x0
#define MX53_PAD_KEY_COL3__ECSPI1_SS3				0x03c 0x364 0x7b4 0x5 0x0
#define MX53_PAD_KEY_COL3__FEC_CRS				0x03c 0x364 0x000 0x6 0x0
#define MX53_PAD_KEY_COL3__USBPHY1_SIECLOCK			0x03c 0x364 0x000 0x7 0x0
#define MX53_PAD_KEY_ROW3__KPP_ROW_3				0x040 0x368 0x000 0x0 0x0
#define MX53_PAD_KEY_ROW3__GPIO4_13				0x040 0x368 0x000 0x1 0x0
#define MX53_PAD_KEY_ROW3__USBOH3_H2_DM				0x040 0x368 0x000 0x2 0x0
#define MX53_PAD_KEY_ROW3__CCM_ASRC_EXT_CLK			0x040 0x368 0x768 0x3 0x0
#define MX53_PAD_KEY_ROW3__I2C2_SDA				0x040 0x368 0x820 0x4 0x0
#define MX53_PAD_KEY_ROW3__OSC32K_32K_OUT			0x040 0x368 0x000 0x5 0x0
#define MX53_PAD_KEY_ROW3__CCM_PLL4_BYP				0x040 0x368 0x77c 0x6 0x0
#define MX53_PAD_KEY_ROW3__USBPHY1_LINESTATE_0			0x040 0x368 0x000 0x7 0x0
#define MX53_PAD_KEY_COL4__KPP_COL_4				0x044 0x36c 0x000 0x0 0x0
#define MX53_PAD_KEY_COL4__GPIO4_14				0x044 0x36c 0x000 0x1 0x0
#define MX53_PAD_KEY_COL4__CAN2_TXCAN				0x044 0x36c 0x000 0x2 0x0
#define MX53_PAD_KEY_COL4__IPU_SISG_4				0x044 0x36c 0x000 0x3 0x0
#define MX53_PAD_KEY_COL4__UART5_RTS				0x044 0x36c 0x894 0x4 0x0
#define MX53_PAD_KEY_COL4__USBOH3_USBOTG_OC			0x044 0x36c 0x89c 0x5 0x0
#define MX53_PAD_KEY_COL4__USBPHY1_LINESTATE_1			0x044 0x36c 0x000 0x7 0x0
#define MX53_PAD_KEY_ROW4__KPP_ROW_4				0x048 0x370 0x000 0x0 0x0
#define MX53_PAD_KEY_ROW4__GPIO4_15				0x048 0x370 0x000 0x1 0x0
#define MX53_PAD_KEY_ROW4__CAN2_RXCAN				0x048 0x370 0x764 0x2 0x0
#define MX53_PAD_KEY_ROW4__IPU_SISG_5				0x048 0x370 0x000 0x3 0x0
#define MX53_PAD_KEY_ROW4__UART5_CTS				0x048 0x370 0x000 0x4 0x0
#define MX53_PAD_KEY_ROW4__USBOH3_USBOTG_PWR			0x048 0x370 0x000 0x5 0x0
#define MX53_PAD_KEY_ROW4__USBPHY1_VBUSVALID			0x048 0x370 0x000 0x7 0x0
#define MX53_PAD_DI0_DISP_CLK__IPU_DI0_DISP_CLK			0x04c 0x378 0x000 0x0 0x0
#define MX53_PAD_DI0_DISP_CLK__GPIO4_16				0x04c 0x378 0x000 0x1 0x0
#define MX53_PAD_DI0_DISP_CLK__USBOH3_USBH2_DIR			0x04c 0x378 0x000 0x2 0x0
#define MX53_PAD_DI0_DISP_CLK__SDMA_DEBUG_CORE_STATE_0		0x04c 0x378 0x000 0x5 0x0
#define MX53_PAD_DI0_DISP_CLK__EMI_EMI_DEBUG_0			0x04c 0x378 0x000 0x6 0x0
#define MX53_PAD_DI0_DISP_CLK__USBPHY1_AVALID			0x04c 0x378 0x000 0x7 0x0
#define MX53_PAD_DI0_PIN15__IPU_DI0_PIN15			0x050 0x37c 0x000 0x0 0x0
#define MX53_PAD_DI0_PIN15__GPIO4_17				0x050 0x37c 0x000 0x1 0x0
#define MX53_PAD_DI0_PIN15__AUDMUX_AUD6_TXC			0x050 0x37c 0x000 0x2 0x0
#define MX53_PAD_DI0_PIN15__SDMA_DEBUG_CORE_STATE_1		0x050 0x37c 0x000 0x5 0x0
#define MX53_PAD_DI0_PIN15__EMI_EMI_DEBUG_1			0x050 0x37c 0x000 0x6 0x0
#define MX53_PAD_DI0_PIN15__USBPHY1_BVALID			0x050 0x37c 0x000 0x7 0x0
#define MX53_PAD_DI0_PIN2__IPU_DI0_PIN2				0x054 0x380 0x000 0x0 0x0
#define MX53_PAD_DI0_PIN2__GPIO4_18				0x054 0x380 0x000 0x1 0x0
#define MX53_PAD_DI0_PIN2__AUDMUX_AUD6_TXD			0x054 0x380 0x000 0x2 0x0
#define MX53_PAD_DI0_PIN2__SDMA_DEBUG_CORE_STATE_2		0x054 0x380 0x000 0x5 0x0
#define MX53_PAD_DI0_PIN2__EMI_EMI_DEBUG_2			0x054 0x380 0x000 0x6 0x0
#define MX53_PAD_DI0_PIN2__USBPHY1_ENDSESSION			0x054 0x380 0x000 0x7 0x0
#define MX53_PAD_DI0_PIN3__IPU_DI0_PIN3				0x058 0x384 0x000 0x0 0x0
#define MX53_PAD_DI0_PIN3__GPIO4_19				0x058 0x384 0x000 0x1 0x0
#define MX53_PAD_DI0_PIN3__AUDMUX_AUD6_TXFS			0x058 0x384 0x000 0x2 0x0
#define MX53_PAD_DI0_PIN3__SDMA_DEBUG_CORE_STATE_3		0x058 0x384 0x000 0x5 0x0
#define MX53_PAD_DI0_PIN3__EMI_EMI_DEBUG_3			0x058 0x384 0x000 0x6 0x0
#define MX53_PAD_DI0_PIN3__USBPHY1_IDDIG			0x058 0x384 0x000 0x7 0x0
#define MX53_PAD_DI0_PIN4__IPU_DI0_PIN4				0x05c 0x388 0x000 0x0 0x0
#define MX53_PAD_DI0_PIN4__GPIO4_20				0x05c 0x388 0x000 0x1 0x0
#define MX53_PAD_DI0_PIN4__AUDMUX_AUD6_RXD			0x05c 0x388 0x000 0x2 0x0
#define MX53_PAD_DI0_PIN4__ESDHC1_WP				0x05c 0x388 0x7fc 0x3 0x0
#define MX53_PAD_DI0_PIN4__SDMA_DEBUG_YIELD			0x05c 0x388 0x000 0x5 0x0
#define MX53_PAD_DI0_PIN4__EMI_EMI_DEBUG_4			0x05c 0x388 0x000 0x6 0x0
#define MX53_PAD_DI0_PIN4__USBPHY1_HOSTDISCONNECT		0x05c 0x388 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT0__IPU_DISP0_DAT_0			0x060 0x38c 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT0__GPIO4_21				0x060 0x38c 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT0__CSPI_SCLK				0x060 0x38c 0x780 0x2 0x0
#define MX53_PAD_DISP0_DAT0__USBOH3_USBH2_DATA_0		0x060 0x38c 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT0__SDMA_DEBUG_CORE_RUN		0x060 0x38c 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT0__EMI_EMI_DEBUG_5			0x060 0x38c 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT0__USBPHY2_TXREADY			0x060 0x38c 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT1__IPU_DISP0_DAT_1			0x064 0x390 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT1__GPIO4_22				0x064 0x390 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT1__CSPI_MOSI				0x064 0x390 0x788 0x2 0x0
#define MX53_PAD_DISP0_DAT1__USBOH3_USBH2_DATA_1		0x064 0x390 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT1__SDMA_DEBUG_EVENT_CHANNEL_SEL	0x064 0x390 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT1__EMI_EMI_DEBUG_6			0x064 0x390 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT1__USBPHY2_RXVALID			0x064 0x390 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT2__IPU_DISP0_DAT_2			0x068 0x394 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT2__GPIO4_23				0x068 0x394 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT2__CSPI_MISO				0x068 0x394 0x784 0x2 0x0
#define MX53_PAD_DISP0_DAT2__USBOH3_USBH2_DATA_2		0x068 0x394 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT2__SDMA_DEBUG_MODE			0x068 0x394 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT2__EMI_EMI_DEBUG_7			0x068 0x394 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT2__USBPHY2_RXACTIVE			0x068 0x394 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT3__IPU_DISP0_DAT_3			0x06c 0x398 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT3__GPIO4_24				0x06c 0x398 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT3__CSPI_SS0				0x06c 0x398 0x78c 0x2 0x0
#define MX53_PAD_DISP0_DAT3__USBOH3_USBH2_DATA_3		0x06c 0x398 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT3__SDMA_DEBUG_BUS_ERROR		0x06c 0x398 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT3__EMI_EMI_DEBUG_8			0x06c 0x398 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT3__USBPHY2_RXERROR			0x06c 0x398 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT4__IPU_DISP0_DAT_4			0x070 0x39c 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT4__GPIO4_25				0x070 0x39c 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT4__CSPI_SS1				0x070 0x39c 0x790 0x2 0x0
#define MX53_PAD_DISP0_DAT4__USBOH3_USBH2_DATA_4		0x070 0x39c 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT4__SDMA_DEBUG_BUS_RWB			0x070 0x39c 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT4__EMI_EMI_DEBUG_9			0x070 0x39c 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT4__USBPHY2_SIECLOCK			0x070 0x39c 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT5__IPU_DISP0_DAT_5			0x074 0x3a0 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT5__GPIO4_26				0x074 0x3a0 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT5__CSPI_SS2				0x074 0x3a0 0x794 0x2 0x0
#define MX53_PAD_DISP0_DAT5__USBOH3_USBH2_DATA_5		0x074 0x3a0 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT5__SDMA_DEBUG_MATCHED_DMBUS		0x074 0x3a0 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT5__EMI_EMI_DEBUG_10			0x074 0x3a0 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT5__USBPHY2_LINESTATE_0		0x074 0x3a0 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT6__IPU_DISP0_DAT_6			0x078 0x3a4 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT6__GPIO4_27				0x078 0x3a4 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT6__CSPI_SS3				0x078 0x3a4 0x798 0x2 0x0
#define MX53_PAD_DISP0_DAT6__USBOH3_USBH2_DATA_6		0x078 0x3a4 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT6__SDMA_DEBUG_RTBUFFER_WRITE		0x078 0x3a4 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT6__EMI_EMI_DEBUG_11			0x078 0x3a4 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT6__USBPHY2_LINESTATE_1		0x078 0x3a4 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT7__IPU_DISP0_DAT_7			0x07c 0x3a8 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT7__GPIO4_28				0x07c 0x3a8 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT7__CSPI_RDY				0x07c 0x3a8 0x000 0x2 0x0
#define MX53_PAD_DISP0_DAT7__USBOH3_USBH2_DATA_7		0x07c 0x3a8 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT7__SDMA_DEBUG_EVENT_CHANNEL_0		0x07c 0x3a8 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT7__EMI_EMI_DEBUG_12			0x07c 0x3a8 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT7__USBPHY2_VBUSVALID			0x07c 0x3a8 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT8__IPU_DISP0_DAT_8			0x080 0x3ac 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT8__GPIO4_29				0x080 0x3ac 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT8__PWM1_PWMO				0x080 0x3ac 0x000 0x2 0x0
#define MX53_PAD_DISP0_DAT8__WDOG1_WDOG_B			0x080 0x3ac 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT8__SDMA_DEBUG_EVENT_CHANNEL_1		0x080 0x3ac 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT8__EMI_EMI_DEBUG_13			0x080 0x3ac 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT8__USBPHY2_AVALID			0x080 0x3ac 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT9__IPU_DISP0_DAT_9			0x084 0x3b0 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT9__GPIO4_30				0x084 0x3b0 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT9__PWM2_PWMO				0x084 0x3b0 0x000 0x2 0x0
#define MX53_PAD_DISP0_DAT9__WDOG2_WDOG_B			0x084 0x3b0 0x000 0x3 0x0
#define MX53_PAD_DISP0_DAT9__SDMA_DEBUG_EVENT_CHANNEL_2		0x084 0x3b0 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT9__EMI_EMI_DEBUG_14			0x084 0x3b0 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT9__USBPHY2_VSTATUS_0			0x084 0x3b0 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT10__IPU_DISP0_DAT_10			0x088 0x3b4 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT10__GPIO4_31				0x088 0x3b4 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT10__USBOH3_USBH2_STP			0x088 0x3b4 0x000 0x2 0x0
#define MX53_PAD_DISP0_DAT10__SDMA_DEBUG_EVENT_CHANNEL_3	0x088 0x3b4 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT10__EMI_EMI_DEBUG_15			0x088 0x3b4 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT10__USBPHY2_VSTATUS_1			0x088 0x3b4 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT11__IPU_DISP0_DAT_11			0x08c 0x3b8 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT11__GPIO5_5				0x08c 0x3b8 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT11__USBOH3_USBH2_NXT			0x08c 0x3b8 0x000 0x2 0x0
#define MX53_PAD_DISP0_DAT11__SDMA_DEBUG_EVENT_CHANNEL_4	0x08c 0x3b8 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT11__EMI_EMI_DEBUG_16			0x08c 0x3b8 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT11__USBPHY2_VSTATUS_2			0x08c 0x3b8 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT12__IPU_DISP0_DAT_12			0x090 0x3bc 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT12__GPIO5_6				0x090 0x3bc 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT12__USBOH3_USBH2_CLK			0x090 0x3bc 0x000 0x2 0x0
#define MX53_PAD_DISP0_DAT12__SDMA_DEBUG_EVENT_CHANNEL_5	0x090 0x3bc 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT12__EMI_EMI_DEBUG_17			0x090 0x3bc 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT12__USBPHY2_VSTATUS_3			0x090 0x3bc 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT13__IPU_DISP0_DAT_13			0x094 0x3c0 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT13__GPIO5_7				0x094 0x3c0 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT13__AUDMUX_AUD5_RXFS			0x094 0x3c0 0x754 0x3 0x0
#define MX53_PAD_DISP0_DAT13__SDMA_DEBUG_EVT_CHN_LINES_0	0x094 0x3c0 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT13__EMI_EMI_DEBUG_18			0x094 0x3c0 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT13__USBPHY2_VSTATUS_4			0x094 0x3c0 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT14__IPU_DISP0_DAT_14			0x098 0x3c4 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT14__GPIO5_8				0x098 0x3c4 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT14__AUDMUX_AUD5_RXC			0x098 0x3c4 0x750 0x3 0x0
#define MX53_PAD_DISP0_DAT14__SDMA_DEBUG_EVT_CHN_LINES_1	0x098 0x3c4 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT14__EMI_EMI_DEBUG_19			0x098 0x3c4 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT14__USBPHY2_VSTATUS_5			0x098 0x3c4 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT15__IPU_DISP0_DAT_15			0x09c 0x3c8 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT15__GPIO5_9				0x09c 0x3c8 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT15__ECSPI1_SS1			0x09c 0x3c8 0x7ac 0x2 0x1
#define MX53_PAD_DISP0_DAT15__ECSPI2_SS1			0x09c 0x3c8 0x7c8 0x3 0x0
#define MX53_PAD_DISP0_DAT15__SDMA_DEBUG_EVT_CHN_LINES_2	0x09c 0x3c8 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT15__EMI_EMI_DEBUG_20			0x09c 0x3c8 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT15__USBPHY2_VSTATUS_6			0x09c 0x3c8 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT16__IPU_DISP0_DAT_16			0x0a0 0x3cc 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT16__GPIO5_10				0x0a0 0x3cc 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT16__ECSPI2_MOSI			0x0a0 0x3cc 0x7c0 0x2 0x0
#define MX53_PAD_DISP0_DAT16__AUDMUX_AUD5_TXC			0x0a0 0x3cc 0x758 0x3 0x1
#define MX53_PAD_DISP0_DAT16__SDMA_EXT_EVENT_0			0x0a0 0x3cc 0x868 0x4 0x0
#define MX53_PAD_DISP0_DAT16__SDMA_DEBUG_EVT_CHN_LINES_3	0x0a0 0x3cc 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT16__EMI_EMI_DEBUG_21			0x0a0 0x3cc 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT16__USBPHY2_VSTATUS_7			0x0a0 0x3cc 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT17__IPU_DISP0_DAT_17			0x0a4 0x3d0 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT17__GPIO5_11				0x0a4 0x3d0 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT17__ECSPI2_MISO			0x0a4 0x3d0 0x7bc 0x2 0x0
#define MX53_PAD_DISP0_DAT17__AUDMUX_AUD5_TXD			0x0a4 0x3d0 0x74c 0x3 0x1
#define MX53_PAD_DISP0_DAT17__SDMA_EXT_EVENT_1			0x0a4 0x3d0 0x86c 0x4 0x0
#define MX53_PAD_DISP0_DAT17__SDMA_DEBUG_EVT_CHN_LINES_4	0x0a4 0x3d0 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT17__EMI_EMI_DEBUG_22			0x0a4 0x3d0 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT18__IPU_DISP0_DAT_18			0x0a8 0x3d4 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT18__GPIO5_12				0x0a8 0x3d4 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT18__ECSPI2_SS0			0x0a8 0x3d4 0x7c4 0x2 0x0
#define MX53_PAD_DISP0_DAT18__AUDMUX_AUD5_TXFS			0x0a8 0x3d4 0x75c 0x3 0x1
#define MX53_PAD_DISP0_DAT18__AUDMUX_AUD4_RXFS			0x0a8 0x3d4 0x73c 0x4 0x0
#define MX53_PAD_DISP0_DAT18__SDMA_DEBUG_EVT_CHN_LINES_5	0x0a8 0x3d4 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT18__EMI_EMI_DEBUG_23			0x0a8 0x3d4 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT18__EMI_WEIM_CS_2			0x0a8 0x3d4 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT19__IPU_DISP0_DAT_19			0x0ac 0x3d8 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT19__GPIO5_13				0x0ac 0x3d8 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT19__ECSPI2_SCLK			0x0ac 0x3d8 0x7b8 0x2 0x0
#define MX53_PAD_DISP0_DAT19__AUDMUX_AUD5_RXD			0x0ac 0x3d8 0x748 0x3 0x1
#define MX53_PAD_DISP0_DAT19__AUDMUX_AUD4_RXC			0x0ac 0x3d8 0x738 0x4 0x0
#define MX53_PAD_DISP0_DAT19__SDMA_DEBUG_EVT_CHN_LINES_6	0x0ac 0x3d8 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT19__EMI_EMI_DEBUG_24			0x0ac 0x3d8 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT19__EMI_WEIM_CS_3			0x0ac 0x3d8 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT20__IPU_DISP0_DAT_20			0x0b0 0x3dc 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT20__GPIO5_14				0x0b0 0x3dc 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT20__ECSPI1_SCLK			0x0b0 0x3dc 0x79c 0x2 0x1
#define MX53_PAD_DISP0_DAT20__AUDMUX_AUD4_TXC			0x0b0 0x3dc 0x740 0x3 0x0
#define MX53_PAD_DISP0_DAT20__SDMA_DEBUG_EVT_CHN_LINES_7	0x0b0 0x3dc 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT20__EMI_EMI_DEBUG_25			0x0b0 0x3dc 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT20__SATA_PHY_TDI			0x0b0 0x3dc 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT21__IPU_DISP0_DAT_21			0x0b4 0x3e0 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT21__GPIO5_15				0x0b4 0x3e0 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT21__ECSPI1_MOSI			0x0b4 0x3e0 0x7a4 0x2 0x1
#define MX53_PAD_DISP0_DAT21__AUDMUX_AUD4_TXD			0x0b4 0x3e0 0x734 0x3 0x0
#define MX53_PAD_DISP0_DAT21__SDMA_DEBUG_BUS_DEVICE_0		0x0b4 0x3e0 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT21__EMI_EMI_DEBUG_26			0x0b4 0x3e0 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT21__SATA_PHY_TDO			0x0b4 0x3e0 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT22__IPU_DISP0_DAT_22			0x0b8 0x3e4 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT22__GPIO5_16				0x0b8 0x3e4 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT22__ECSPI1_MISO			0x0b8 0x3e4 0x7a0 0x2 0x1
#define MX53_PAD_DISP0_DAT22__AUDMUX_AUD4_TXFS			0x0b8 0x3e4 0x744 0x3 0x0
#define MX53_PAD_DISP0_DAT22__SDMA_DEBUG_BUS_DEVICE_1		0x0b8 0x3e4 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT22__EMI_EMI_DEBUG_27			0x0b8 0x3e4 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT22__SATA_PHY_TCK			0x0b8 0x3e4 0x000 0x7 0x0
#define MX53_PAD_DISP0_DAT23__IPU_DISP0_DAT_23			0x0bc 0x3e8 0x000 0x0 0x0
#define MX53_PAD_DISP0_DAT23__GPIO5_17				0x0bc 0x3e8 0x000 0x1 0x0
#define MX53_PAD_DISP0_DAT23__ECSPI1_SS0			0x0bc 0x3e8 0x7a8 0x2 0x1
#define MX53_PAD_DISP0_DAT23__AUDMUX_AUD4_RXD			0x0bc 0x3e8 0x730 0x3 0x0
#define MX53_PAD_DISP0_DAT23__SDMA_DEBUG_BUS_DEVICE_2		0x0bc 0x3e8 0x000 0x5 0x0
#define MX53_PAD_DISP0_DAT23__EMI_EMI_DEBUG_28			0x0bc 0x3e8 0x000 0x6 0x0
#define MX53_PAD_DISP0_DAT23__SATA_PHY_TMS			0x0bc 0x3e8 0x000 0x7 0x0
#define MX53_PAD_CSI0_PIXCLK__IPU_CSI0_PIXCLK			0x0c0 0x3ec 0x000 0x0 0x0
#define MX53_PAD_CSI0_PIXCLK__GPIO5_18				0x0c0 0x3ec 0x000 0x1 0x0
#define MX53_PAD_CSI0_PIXCLK__SDMA_DEBUG_PC_0			0x0c0 0x3ec 0x000 0x5 0x0
#define MX53_PAD_CSI0_PIXCLK__EMI_EMI_DEBUG_29			0x0c0 0x3ec 0x000 0x6 0x0
#define MX53_PAD_CSI0_MCLK__IPU_CSI0_HSYNC			0x0c4 0x3f0 0x000 0x0 0x0
#define MX53_PAD_CSI0_MCLK__GPIO5_19				0x0c4 0x3f0 0x000 0x1 0x0
#define MX53_PAD_CSI0_MCLK__CCM_CSI0_MCLK			0x0c4 0x3f0 0x000 0x2 0x0
#define MX53_PAD_CSI0_MCLK__SDMA_DEBUG_PC_1			0x0c4 0x3f0 0x000 0x5 0x0
#define MX53_PAD_CSI0_MCLK__EMI_EMI_DEBUG_30			0x0c4 0x3f0 0x000 0x6 0x0
#define MX53_PAD_CSI0_MCLK__TPIU_TRCTL				0x0c4 0x3f0 0x000 0x7 0x0
#define MX53_PAD_CSI0_DATA_EN__IPU_CSI0_DATA_EN			0x0c8 0x3f4 0x000 0x0 0x0
#define MX53_PAD_CSI0_DATA_EN__GPIO5_20				0x0c8 0x3f4 0x000 0x1 0x0
#define MX53_PAD_CSI0_DATA_EN__SDMA_DEBUG_PC_2			0x0c8 0x3f4 0x000 0x5 0x0
#define MX53_PAD_CSI0_DATA_EN__EMI_EMI_DEBUG_31			0x0c8 0x3f4 0x000 0x6 0x0
#define MX53_PAD_CSI0_DATA_EN__TPIU_TRCLK			0x0c8 0x3f4 0x000 0x7 0x0
#define MX53_PAD_CSI0_VSYNC__IPU_CSI0_VSYNC			0x0cc 0x3f8 0x000 0x0 0x0
#define MX53_PAD_CSI0_VSYNC__GPIO5_21				0x0cc 0x3f8 0x000 0x1 0x0
#define MX53_PAD_CSI0_VSYNC__SDMA_DEBUG_PC_3			0x0cc 0x3f8 0x000 0x5 0x0
#define MX53_PAD_CSI0_VSYNC__EMI_EMI_DEBUG_32			0x0cc 0x3f8 0x000 0x6 0x0
#define MX53_PAD_CSI0_VSYNC__TPIU_TRACE_0			0x0cc 0x3f8 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT4__IPU_CSI0_D_4			0x0d0 0x3fc 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT4__GPIO5_22				0x0d0 0x3fc 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT4__KPP_COL_5				0x0d0 0x3fc 0x840 0x2 0x1
#define MX53_PAD_CSI0_DAT4__ECSPI1_SCLK				0x0d0 0x3fc 0x79c 0x3 0x2
#define MX53_PAD_CSI0_DAT4__USBOH3_USBH3_STP			0x0d0 0x3fc 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT4__AUDMUX_AUD3_TXC			0x0d0 0x3fc 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT4__EMI_EMI_DEBUG_33			0x0d0 0x3fc 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT4__TPIU_TRACE_1			0x0d0 0x3fc 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT5__IPU_CSI0_D_5			0x0d4 0x400 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT5__GPIO5_23				0x0d4 0x400 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT5__KPP_ROW_5				0x0d4 0x400 0x84c 0x2 0x0
#define MX53_PAD_CSI0_DAT5__ECSPI1_MOSI				0x0d4 0x400 0x7a4 0x3 0x2
#define MX53_PAD_CSI0_DAT5__USBOH3_USBH3_NXT			0x0d4 0x400 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT5__AUDMUX_AUD3_TXD			0x0d4 0x400 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT5__EMI_EMI_DEBUG_34			0x0d4 0x400 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT5__TPIU_TRACE_2			0x0d4 0x400 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT6__IPU_CSI0_D_6			0x0d8 0x404 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT6__GPIO5_24				0x0d8 0x404 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT6__KPP_COL_6				0x0d8 0x404 0x844 0x2 0x0
#define MX53_PAD_CSI0_DAT6__ECSPI1_MISO				0x0d8 0x404 0x7a0 0x3 0x2
#define MX53_PAD_CSI0_DAT6__USBOH3_USBH3_CLK			0x0d8 0x404 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT6__AUDMUX_AUD3_TXFS			0x0d8 0x404 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT6__EMI_EMI_DEBUG_35			0x0d8 0x404 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT6__TPIU_TRACE_3			0x0d8 0x404 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT7__IPU_CSI0_D_7			0x0dc 0x408 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT7__GPIO5_25				0x0dc 0x408 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT7__KPP_ROW_6				0x0dc 0x408 0x850 0x2 0x0
#define MX53_PAD_CSI0_DAT7__ECSPI1_SS0				0x0dc 0x408 0x7a8 0x3 0x2
#define MX53_PAD_CSI0_DAT7__USBOH3_USBH3_DIR			0x0dc 0x408 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT7__AUDMUX_AUD3_RXD			0x0dc 0x408 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT7__EMI_EMI_DEBUG_36			0x0dc 0x408 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT7__TPIU_TRACE_4			0x0dc 0x408 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT8__IPU_CSI0_D_8			0x0e0 0x40c 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT8__GPIO5_26				0x0e0 0x40c 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT8__KPP_COL_7				0x0e0 0x40c 0x848 0x2 0x0
#define MX53_PAD_CSI0_DAT8__ECSPI2_SCLK				0x0e0 0x40c 0x7b8 0x3 0x1
#define MX53_PAD_CSI0_DAT8__USBOH3_USBH3_OC			0x0e0 0x40c 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT8__I2C1_SDA				0x0e0 0x40c 0x818 0x5 0x0
#define MX53_PAD_CSI0_DAT8__EMI_EMI_DEBUG_37			0x0e0 0x40c 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT8__TPIU_TRACE_5			0x0e0 0x40c 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT9__IPU_CSI0_D_9			0x0e4 0x410 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT9__GPIO5_27				0x0e4 0x410 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT9__KPP_ROW_7				0x0e4 0x410 0x854 0x2 0x0
#define MX53_PAD_CSI0_DAT9__ECSPI2_MOSI				0x0e4 0x410 0x7c0 0x3 0x1
#define MX53_PAD_CSI0_DAT9__USBOH3_USBH3_PWR			0x0e4 0x410 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT9__I2C1_SCL				0x0e4 0x410 0x814 0x5 0x0
#define MX53_PAD_CSI0_DAT9__EMI_EMI_DEBUG_38			0x0e4 0x410 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT9__TPIU_TRACE_6			0x0e4 0x410 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT10__IPU_CSI0_D_10			0x0e8 0x414 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT10__GPIO5_28				0x0e8 0x414 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT10__UART1_TXD_MUX			0x0e8 0x414 0x000 0x2 0x0
#define MX53_PAD_CSI0_DAT10__ECSPI2_MISO			0x0e8 0x414 0x7bc 0x3 0x1
#define MX53_PAD_CSI0_DAT10__AUDMUX_AUD3_RXC			0x0e8 0x414 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT10__SDMA_DEBUG_PC_4			0x0e8 0x414 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT10__EMI_EMI_DEBUG_39			0x0e8 0x414 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT10__TPIU_TRACE_7			0x0e8 0x414 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT11__IPU_CSI0_D_11			0x0ec 0x418 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT11__GPIO5_29				0x0ec 0x418 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT11__UART1_RXD_MUX			0x0ec 0x418 0x878 0x2 0x1
#define MX53_PAD_CSI0_DAT11__ECSPI2_SS0				0x0ec 0x418 0x7c4 0x3 0x1
#define MX53_PAD_CSI0_DAT11__AUDMUX_AUD3_RXFS			0x0ec 0x418 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT11__SDMA_DEBUG_PC_5			0x0ec 0x418 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT11__EMI_EMI_DEBUG_40			0x0ec 0x418 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT11__TPIU_TRACE_8			0x0ec 0x418 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT12__IPU_CSI0_D_12			0x0f0 0x41c 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT12__GPIO5_30				0x0f0 0x41c 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT12__UART4_TXD_MUX			0x0f0 0x41c 0x000 0x2 0x0
#define MX53_PAD_CSI0_DAT12__USBOH3_USBH3_DATA_0		0x0f0 0x41c 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT12__SDMA_DEBUG_PC_6			0x0f0 0x41c 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT12__EMI_EMI_DEBUG_41			0x0f0 0x41c 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT12__TPIU_TRACE_9			0x0f0 0x41c 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT13__IPU_CSI0_D_13			0x0f4 0x420 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT13__GPIO5_31				0x0f4 0x420 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT13__UART4_RXD_MUX			0x0f4 0x420 0x890 0x2 0x3
#define MX53_PAD_CSI0_DAT13__USBOH3_USBH3_DATA_1		0x0f4 0x420 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT13__SDMA_DEBUG_PC_7			0x0f4 0x420 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT13__EMI_EMI_DEBUG_42			0x0f4 0x420 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT13__TPIU_TRACE_10			0x0f4 0x420 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT14__IPU_CSI0_D_14			0x0f8 0x424 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT14__GPIO6_0				0x0f8 0x424 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT14__UART5_TXD_MUX			0x0f8 0x424 0x000 0x2 0x0
#define MX53_PAD_CSI0_DAT14__USBOH3_USBH3_DATA_2		0x0f8 0x424 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT14__SDMA_DEBUG_PC_8			0x0f8 0x424 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT14__EMI_EMI_DEBUG_43			0x0f8 0x424 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT14__TPIU_TRACE_11			0x0f8 0x424 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT15__IPU_CSI0_D_15			0x0fc 0x428 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT15__GPIO6_1				0x0fc 0x428 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT15__UART5_RXD_MUX			0x0fc 0x428 0x898 0x2 0x3
#define MX53_PAD_CSI0_DAT15__USBOH3_USBH3_DATA_3		0x0fc 0x428 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT15__SDMA_DEBUG_PC_9			0x0fc 0x428 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT15__EMI_EMI_DEBUG_44			0x0fc 0x428 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT15__TPIU_TRACE_12			0x0fc 0x428 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT16__IPU_CSI0_D_16			0x100 0x42c 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT16__GPIO6_2				0x100 0x42c 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT16__UART4_RTS				0x100 0x42c 0x88c 0x2 0x0
#define MX53_PAD_CSI0_DAT16__USBOH3_USBH3_DATA_4		0x100 0x42c 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT16__SDMA_DEBUG_PC_10			0x100 0x42c 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT16__EMI_EMI_DEBUG_45			0x100 0x42c 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT16__TPIU_TRACE_13			0x100 0x42c 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT17__IPU_CSI0_D_17			0x104 0x430 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT17__GPIO6_3				0x104 0x430 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT17__UART4_CTS				0x104 0x430 0x000 0x2 0x0
#define MX53_PAD_CSI0_DAT17__USBOH3_USBH3_DATA_5		0x104 0x430 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT17__SDMA_DEBUG_PC_11			0x104 0x430 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT17__EMI_EMI_DEBUG_46			0x104 0x430 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT17__TPIU_TRACE_14			0x104 0x430 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT18__IPU_CSI0_D_18			0x108 0x434 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT18__GPIO6_4				0x108 0x434 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT18__UART5_RTS				0x108 0x434 0x894 0x2 0x2
#define MX53_PAD_CSI0_DAT18__USBOH3_USBH3_DATA_6		0x108 0x434 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT18__SDMA_DEBUG_PC_12			0x108 0x434 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT18__EMI_EMI_DEBUG_47			0x108 0x434 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT18__TPIU_TRACE_15			0x108 0x434 0x000 0x7 0x0
#define MX53_PAD_CSI0_DAT19__IPU_CSI0_D_19			0x10c 0x438 0x000 0x0 0x0
#define MX53_PAD_CSI0_DAT19__GPIO6_5				0x10c 0x438 0x000 0x1 0x0
#define MX53_PAD_CSI0_DAT19__UART5_CTS				0x10c 0x438 0x000 0x2 0x0
#define MX53_PAD_CSI0_DAT19__USBOH3_USBH3_DATA_7		0x10c 0x438 0x000 0x4 0x0
#define MX53_PAD_CSI0_DAT19__SDMA_DEBUG_PC_13			0x10c 0x438 0x000 0x5 0x0
#define MX53_PAD_CSI0_DAT19__EMI_EMI_DEBUG_48			0x10c 0x438 0x000 0x6 0x0
#define MX53_PAD_CSI0_DAT19__USBPHY2_BISTOK			0x10c 0x438 0x000 0x7 0x0
#define MX53_PAD_EIM_A25__EMI_WEIM_A_25				0x110 0x458 0x000 0x0 0x0
#define MX53_PAD_EIM_A25__GPIO5_2				0x110 0x458 0x000 0x1 0x0
#define MX53_PAD_EIM_A25__ECSPI2_RDY				0x110 0x458 0x000 0x2 0x0
#define MX53_PAD_EIM_A25__IPU_DI1_PIN12				0x110 0x458 0x000 0x3 0x0
#define MX53_PAD_EIM_A25__CSPI_SS1				0x110 0x458 0x790 0x4 0x1
#define MX53_PAD_EIM_A25__IPU_DI0_D1_CS				0x110 0x458 0x000 0x6 0x0
#define MX53_PAD_EIM_A25__USBPHY1_BISTOK			0x110 0x458 0x000 0x7 0x0
#define MX53_PAD_EIM_EB2__EMI_WEIM_EB_2				0x114 0x45c 0x000 0x0 0x0
#define MX53_PAD_EIM_EB2__GPIO2_30				0x114 0x45c 0x000 0x1 0x0
#define MX53_PAD_EIM_EB2__CCM_DI1_EXT_CLK			0x114 0x45c 0x76c 0x2 0x0
#define MX53_PAD_EIM_EB2__IPU_SER_DISP1_CS			0x114 0x45c 0x000 0x3 0x0
#define MX53_PAD_EIM_EB2__ECSPI1_SS0				0x114 0x45c 0x7a8 0x4 0x3
#define MX53_PAD_EIM_EB2__I2C2_SCL				0x114 0x45c 0x81c 0x5 0x1
#define MX53_PAD_EIM_D16__EMI_WEIM_D_16				0x118 0x460 0x000 0x0 0x0
#define MX53_PAD_EIM_D16__GPIO3_16				0x118 0x460 0x000 0x1 0x0
#define MX53_PAD_EIM_D16__IPU_DI0_PIN5				0x118 0x460 0x000 0x2 0x0
#define MX53_PAD_EIM_D16__IPU_DISPB1_SER_CLK			0x118 0x460 0x000 0x3 0x0
#define MX53_PAD_EIM_D16__ECSPI1_SCLK				0x118 0x460 0x79c 0x4 0x3
#define MX53_PAD_EIM_D16__I2C2_SDA				0x118 0x460 0x820 0x5 0x1
#define MX53_PAD_EIM_D17__EMI_WEIM_D_17				0x11c 0x464 0x000 0x0 0x0
#define MX53_PAD_EIM_D17__GPIO3_17				0x11c 0x464 0x000 0x1 0x0
#define MX53_PAD_EIM_D17__IPU_DI0_PIN6				0x11c 0x464 0x000 0x2 0x0
#define MX53_PAD_EIM_D17__IPU_DISPB1_SER_DIN			0x11c 0x464 0x830 0x3 0x0
#define MX53_PAD_EIM_D17__ECSPI1_MISO				0x11c 0x464 0x7a0 0x4 0x3
#define MX53_PAD_EIM_D17__I2C3_SCL				0x11c 0x464 0x824 0x5 0x0
#define MX53_PAD_EIM_D18__EMI_WEIM_D_18				0x120 0x468 0x000 0x0 0x0
#define MX53_PAD_EIM_D18__GPIO3_18				0x120 0x468 0x000 0x1 0x0
#define MX53_PAD_EIM_D18__IPU_DI0_PIN7				0x120 0x468 0x000 0x2 0x0
#define MX53_PAD_EIM_D18__IPU_DISPB1_SER_DIO			0x120 0x468 0x830 0x3 0x1
#define MX53_PAD_EIM_D18__ECSPI1_MOSI				0x120 0x468 0x7a4 0x4 0x3
#define MX53_PAD_EIM_D18__I2C3_SDA				0x120 0x468 0x828 0x5 0x0
#define MX53_PAD_EIM_D18__IPU_DI1_D0_CS				0x120 0x468 0x000 0x6 0x0
#define MX53_PAD_EIM_D19__EMI_WEIM_D_19				0x124 0x46c 0x000 0x0 0x0
#define MX53_PAD_EIM_D19__GPIO3_19				0x124 0x46c 0x000 0x1 0x0
#define MX53_PAD_EIM_D19__IPU_DI0_PIN8				0x124 0x46c 0x000 0x2 0x0
#define MX53_PAD_EIM_D19__IPU_DISPB1_SER_RS			0x124 0x46c 0x000 0x3 0x0
#define MX53_PAD_EIM_D19__ECSPI1_SS1				0x124 0x46c 0x7ac 0x4 0x2
#define MX53_PAD_EIM_D19__EPIT1_EPITO				0x124 0x46c 0x000 0x5 0x0
#define MX53_PAD_EIM_D19__UART1_CTS				0x124 0x46c 0x000 0x6 0x0
#define MX53_PAD_EIM_D19__USBOH3_USBH2_OC			0x124 0x46c 0x8a4 0x7 0x0
#define MX53_PAD_EIM_D20__EMI_WEIM_D_20				0x128 0x470 0x000 0x0 0x0
#define MX53_PAD_EIM_D20__GPIO3_20				0x128 0x470 0x000 0x1 0x0
#define MX53_PAD_EIM_D20__IPU_DI0_PIN16				0x128 0x470 0x000 0x2 0x0
#define MX53_PAD_EIM_D20__IPU_SER_DISP0_CS			0x128 0x470 0x000 0x3 0x0
#define MX53_PAD_EIM_D20__CSPI_SS0				0x128 0x470 0x78c 0x4 0x1
#define MX53_PAD_EIM_D20__EPIT2_EPITO				0x128 0x470 0x000 0x5 0x0
#define MX53_PAD_EIM_D20__UART1_RTS				0x128 0x470 0x874 0x6 0x1
#define MX53_PAD_EIM_D20__USBOH3_USBH2_PWR			0x128 0x470 0x000 0x7 0x0
#define MX53_PAD_EIM_D21__EMI_WEIM_D_21				0x12c 0x474 0x000 0x0 0x0
#define MX53_PAD_EIM_D21__GPIO3_21				0x12c 0x474 0x000 0x1 0x0
#define MX53_PAD_EIM_D21__IPU_DI0_PIN17				0x12c 0x474 0x000 0x2 0x0
#define MX53_PAD_EIM_D21__IPU_DISPB0_SER_CLK			0x12c 0x474 0x000 0x3 0x0
#define MX53_PAD_EIM_D21__CSPI_SCLK				0x12c 0x474 0x780 0x4 0x1
#define MX53_PAD_EIM_D21__I2C1_SCL				0x12c 0x474 0x814 0x5 0x1
#define MX53_PAD_EIM_D21__USBOH3_USBOTG_OC			0x12c 0x474 0x89c 0x6 0x1
#define MX53_PAD_EIM_D22__EMI_WEIM_D_22				0x130 0x478 0x000 0x0 0x0
#define MX53_PAD_EIM_D22__GPIO3_22				0x130 0x478 0x000 0x1 0x0
#define MX53_PAD_EIM_D22__IPU_DI0_PIN1				0x130 0x478 0x000 0x2 0x0
#define MX53_PAD_EIM_D22__IPU_DISPB0_SER_DIN			0x130 0x478 0x82c 0x3 0x0
#define MX53_PAD_EIM_D22__CSPI_MISO				0x130 0x478 0x784 0x4 0x1
#define MX53_PAD_EIM_D22__USBOH3_USBOTG_PWR			0x130 0x478 0x000 0x6 0x0
#define MX53_PAD_EIM_D23__EMI_WEIM_D_23				0x134 0x47c 0x000 0x0 0x0
#define MX53_PAD_EIM_D23__GPIO3_23				0x134 0x47c 0x000 0x1 0x0
#define MX53_PAD_EIM_D23__UART3_CTS				0x134 0x47c 0x000 0x2 0x0
#define MX53_PAD_EIM_D23__UART1_DCD				0x134 0x47c 0x000 0x3 0x0
#define MX53_PAD_EIM_D23__IPU_DI0_D0_CS				0x134 0x47c 0x000 0x4 0x0
#define MX53_PAD_EIM_D23__IPU_DI1_PIN2				0x134 0x47c 0x000 0x5 0x0
#define MX53_PAD_EIM_D23__IPU_CSI1_DATA_EN			0x134 0x47c 0x834 0x6 0x0
#define MX53_PAD_EIM_D23__IPU_DI1_PIN14				0x134 0x47c 0x000 0x7 0x0
#define MX53_PAD_EIM_EB3__EMI_WEIM_EB_3				0x138 0x480 0x000 0x0 0x0
#define MX53_PAD_EIM_EB3__GPIO2_31				0x138 0x480 0x000 0x1 0x0
#define MX53_PAD_EIM_EB3__UART3_RTS				0x138 0x480 0x884 0x2 0x1
#define MX53_PAD_EIM_EB3__UART1_RI				0x138 0x480 0x000 0x3 0x0
#define MX53_PAD_EIM_EB3__IPU_DI1_PIN3				0x138 0x480 0x000 0x5 0x0
#define MX53_PAD_EIM_EB3__IPU_CSI1_HSYNC			0x138 0x480 0x838 0x6 0x0
#define MX53_PAD_EIM_EB3__IPU_DI1_PIN16				0x138 0x480 0x000 0x7 0x0
#define MX53_PAD_EIM_D24__EMI_WEIM_D_24				0x13c 0x484 0x000 0x0 0x0
#define MX53_PAD_EIM_D24__GPIO3_24				0x13c 0x484 0x000 0x1 0x0
#define MX53_PAD_EIM_D24__UART3_TXD_MUX				0x13c 0x484 0x000 0x2 0x0
#define MX53_PAD_EIM_D24__ECSPI1_SS2				0x13c 0x484 0x7b0 0x3 0x1
#define MX53_PAD_EIM_D24__CSPI_SS2				0x13c 0x484 0x794 0x4 0x1
#define MX53_PAD_EIM_D24__AUDMUX_AUD5_RXFS			0x13c 0x484 0x754 0x5 0x1
#define MX53_PAD_EIM_D24__ECSPI2_SS2				0x13c 0x484 0x000 0x6 0x0
#define MX53_PAD_EIM_D24__UART1_DTR				0x13c 0x484 0x000 0x7 0x0
#define MX53_PAD_EIM_D25__EMI_WEIM_D_25				0x140 0x488 0x000 0x0 0x0
#define MX53_PAD_EIM_D25__GPIO3_25				0x140 0x488 0x000 0x1 0x0
#define MX53_PAD_EIM_D25__UART3_RXD_MUX				0x140 0x488 0x888 0x2 0x1
#define MX53_PAD_EIM_D25__ECSPI1_SS3				0x140 0x488 0x7b4 0x3 0x1
#define MX53_PAD_EIM_D25__CSPI_SS3				0x140 0x488 0x798 0x4 0x1
#define MX53_PAD_EIM_D25__AUDMUX_AUD5_RXC			0x140 0x488 0x750 0x5 0x1
#define MX53_PAD_EIM_D25__ECSPI2_SS3				0x140 0x488 0x000 0x6 0x0
#define MX53_PAD_EIM_D25__UART1_DSR				0x140 0x488 0x000 0x7 0x0
#define MX53_PAD_EIM_D26__EMI_WEIM_D_26				0x144 0x48c 0x000 0x0 0x0
#define MX53_PAD_EIM_D26__GPIO3_26				0x144 0x48c 0x000 0x1 0x0
#define MX53_PAD_EIM_D26__UART2_RXD_MUX				0x144 0x48c 0x880 0x2 0x0
#define MX53_PAD_EIM_D26__UART2_TXD_MUX				0x144 0x48c 0x000 0x2 0x0
#define MX53_PAD_EIM_D26__FIRI_RXD				0x144 0x48c 0x80c 0x3 0x0
#define MX53_PAD_EIM_D26__IPU_CSI0_D_1				0x144 0x48c 0x000 0x4 0x0
#define MX53_PAD_EIM_D26__IPU_DI1_PIN11				0x144 0x48c 0x000 0x5 0x0
#define MX53_PAD_EIM_D26__IPU_SISG_2				0x144 0x48c 0x000 0x6 0x0
#define MX53_PAD_EIM_D26__IPU_DISP1_DAT_22			0x144 0x48c 0x000 0x7 0x0
#define MX53_PAD_EIM_D27__EMI_WEIM_D_27				0x148 0x490 0x000 0x0 0x0
#define MX53_PAD_EIM_D27__GPIO3_27				0x148 0x490 0x000 0x1 0x0
#define MX53_PAD_EIM_D27__UART2_RXD_MUX				0x148 0x490 0x880 0x2 0x1
#define MX53_PAD_EIM_D27__UART2_TXD_MUX				0x148 0x490 0x000 0x2 0x0
#define MX53_PAD_EIM_D27__FIRI_TXD				0x148 0x490 0x000 0x3 0x0
#define MX53_PAD_EIM_D27__IPU_CSI0_D_0				0x148 0x490 0x000 0x4 0x0
#define MX53_PAD_EIM_D27__IPU_DI1_PIN13				0x148 0x490 0x000 0x5 0x0
#define MX53_PAD_EIM_D27__IPU_SISG_3				0x148 0x490 0x000 0x6 0x0
#define MX53_PAD_EIM_D27__IPU_DISP1_DAT_23			0x148 0x490 0x000 0x7 0x0
#define MX53_PAD_EIM_D28__EMI_WEIM_D_28				0x14c 0x494 0x000 0x0 0x0
#define MX53_PAD_EIM_D28__GPIO3_28				0x14c 0x494 0x000 0x1 0x0
#define MX53_PAD_EIM_D28__UART2_CTS				0x14c 0x494 0x000 0x2 0x0
#define MX53_PAD_EIM_D28__UART2_RTS				0x14c 0x494 0x87c 0x2 0x0
#define MX53_PAD_EIM_D28__IPU_DISPB0_SER_DIO			0x14c 0x494 0x82c 0x3 0x1
#define MX53_PAD_EIM_D28__CSPI_MOSI				0x14c 0x494 0x788 0x4 0x1
#define MX53_PAD_EIM_D28__I2C1_SDA				0x14c 0x494 0x818 0x5 0x1
#define MX53_PAD_EIM_D28__IPU_EXT_TRIG				0x14c 0x494 0x000 0x6 0x0
#define MX53_PAD_EIM_D28__IPU_DI0_PIN13				0x14c 0x494 0x000 0x7 0x0
#define MX53_PAD_EIM_D29__EMI_WEIM_D_29				0x150 0x498 0x000 0x0 0x0
#define MX53_PAD_EIM_D29__GPIO3_29				0x150 0x498 0x000 0x1 0x0
#define MX53_PAD_EIM_D29__UART2_CTS				0x150 0x498 0x000 0x2 0x0
#define MX53_PAD_EIM_D29__UART2_RTS				0x150 0x498 0x87c 0x2 0x1
#define MX53_PAD_EIM_D29__IPU_DISPB0_SER_RS			0x150 0x498 0x000 0x3 0x0
#define MX53_PAD_EIM_D29__CSPI_SS0				0x150 0x498 0x78c 0x4 0x2
#define MX53_PAD_EIM_D29__IPU_DI1_PIN15				0x150 0x498 0x000 0x5 0x0
#define MX53_PAD_EIM_D29__IPU_CSI1_VSYNC			0x150 0x498 0x83c 0x6 0x0
#define MX53_PAD_EIM_D29__IPU_DI0_PIN14				0x150 0x498 0x000 0x7 0x0
#define MX53_PAD_EIM_D30__EMI_WEIM_D_30				0x154 0x49c 0x000 0x0 0x0
#define MX53_PAD_EIM_D30__GPIO3_30				0x154 0x49c 0x000 0x1 0x0
#define MX53_PAD_EIM_D30__UART3_CTS				0x154 0x49c 0x000 0x2 0x0
#define MX53_PAD_EIM_D30__IPU_CSI0_D_3				0x154 0x49c 0x000 0x3 0x0
#define MX53_PAD_EIM_D30__IPU_DI0_PIN11				0x154 0x49c 0x000 0x4 0x0
#define MX53_PAD_EIM_D30__IPU_DISP1_DAT_21			0x154 0x49c 0x000 0x5 0x0
#define MX53_PAD_EIM_D30__USBOH3_USBH1_OC			0x154 0x49c 0x8a0 0x6 0x0
#define MX53_PAD_EIM_D30__USBOH3_USBH2_OC			0x154 0x49c 0x8a4 0x7 0x1
#define MX53_PAD_EIM_D31__EMI_WEIM_D_31				0x158 0x4a0 0x000 0x0 0x0
#define MX53_PAD_EIM_D31__GPIO3_31				0x158 0x4a0 0x000 0x1 0x0
#define MX53_PAD_EIM_D31__UART3_RTS				0x158 0x4a0 0x884 0x2 0x3
#define MX53_PAD_EIM_D31__IPU_CSI0_D_2				0x158 0x4a0 0x000 0x3 0x0
#define MX53_PAD_EIM_D31__IPU_DI0_PIN12				0x158 0x4a0 0x000 0x4 0x0
#define MX53_PAD_EIM_D31__IPU_DISP1_DAT_20			0x158 0x4a0 0x000 0x5 0x0
#define MX53_PAD_EIM_D31__USBOH3_USBH1_PWR			0x158 0x4a0 0x000 0x6 0x0
#define MX53_PAD_EIM_D31__USBOH3_USBH2_PWR			0x158 0x4a0 0x000 0x7 0x0
#define MX53_PAD_EIM_A24__EMI_WEIM_A_24				0x15c 0x4a8 0x000 0x0 0x0
#define MX53_PAD_EIM_A24__GPIO5_4				0x15c 0x4a8 0x000 0x1 0x0
#define MX53_PAD_EIM_A24__IPU_DISP1_DAT_19			0x15c 0x4a8 0x000 0x2 0x0
#define MX53_PAD_EIM_A24__IPU_CSI1_D_19				0x15c 0x4a8 0x000 0x3 0x0
#define MX53_PAD_EIM_A24__IPU_SISG_2				0x15c 0x4a8 0x000 0x6 0x0
#define MX53_PAD_EIM_A24__USBPHY2_BVALID			0x15c 0x4a8 0x000 0x7 0x0
#define MX53_PAD_EIM_A23__EMI_WEIM_A_23				0x160 0x4ac 0x000 0x0 0x0
#define MX53_PAD_EIM_A23__GPIO6_6				0x160 0x4ac 0x000 0x1 0x0
#define MX53_PAD_EIM_A23__IPU_DISP1_DAT_18			0x160 0x4ac 0x000 0x2 0x0
#define MX53_PAD_EIM_A23__IPU_CSI1_D_18				0x160 0x4ac 0x000 0x3 0x0
#define MX53_PAD_EIM_A23__IPU_SISG_3				0x160 0x4ac 0x000 0x6 0x0
#define MX53_PAD_EIM_A23__USBPHY2_ENDSESSION			0x160 0x4ac 0x000 0x7 0x0
#define MX53_PAD_EIM_A22__EMI_WEIM_A_22				0x164 0x4b0 0x000 0x0 0x0
#define MX53_PAD_EIM_A22__GPIO2_16				0x164 0x4b0 0x000 0x1 0x0
#define MX53_PAD_EIM_A22__IPU_DISP1_DAT_17			0x164 0x4b0 0x000 0x2 0x0
#define MX53_PAD_EIM_A22__IPU_CSI1_D_17				0x164 0x4b0 0x000 0x3 0x0
#define MX53_PAD_EIM_A22__SRC_BT_CFG1_7				0x164 0x4b0 0x000 0x7 0x0
#define MX53_PAD_EIM_A21__EMI_WEIM_A_21				0x168 0x4b4 0x000 0x0 0x0
#define MX53_PAD_EIM_A21__GPIO2_17				0x168 0x4b4 0x000 0x1 0x0
#define MX53_PAD_EIM_A21__IPU_DISP1_DAT_16			0x168 0x4b4 0x000 0x2 0x0
#define MX53_PAD_EIM_A21__IPU_CSI1_D_16				0x168 0x4b4 0x000 0x3 0x0
#define MX53_PAD_EIM_A21__SRC_BT_CFG1_6				0x168 0x4b4 0x000 0x7 0x0
#define MX53_PAD_EIM_A20__EMI_WEIM_A_20				0x16c 0x4b8 0x000 0x0 0x0
#define MX53_PAD_EIM_A20__GPIO2_18				0x16c 0x4b8 0x000 0x1 0x0
#define MX53_PAD_EIM_A20__IPU_DISP1_DAT_15			0x16c 0x4b8 0x000 0x2 0x0
#define MX53_PAD_EIM_A20__IPU_CSI1_D_15				0x16c 0x4b8 0x000 0x3 0x0
#define MX53_PAD_EIM_A20__SRC_BT_CFG1_5				0x16c 0x4b8 0x000 0x7 0x0
#define MX53_PAD_EIM_A19__EMI_WEIM_A_19				0x170 0x4bc 0x000 0x0 0x0
#define MX53_PAD_EIM_A19__GPIO2_19				0x170 0x4bc 0x000 0x1 0x0
#define MX53_PAD_EIM_A19__IPU_DISP1_DAT_14			0x170 0x4bc 0x000 0x2 0x0
#define MX53_PAD_EIM_A19__IPU_CSI1_D_14				0x170 0x4bc 0x000 0x3 0x0
#define MX53_PAD_EIM_A19__SRC_BT_CFG1_4				0x170 0x4bc 0x000 0x7 0x0
#define MX53_PAD_EIM_A18__EMI_WEIM_A_18				0x174 0x4c0 0x000 0x0 0x0
#define MX53_PAD_EIM_A18__GPIO2_20				0x174 0x4c0 0x000 0x1 0x0
#define MX53_PAD_EIM_A18__IPU_DISP1_DAT_13			0x174 0x4c0 0x000 0x2 0x0
#define MX53_PAD_EIM_A18__IPU_CSI1_D_13				0x174 0x4c0 0x000 0x3 0x0
#define MX53_PAD_EIM_A18__SRC_BT_CFG1_3				0x174 0x4c0 0x000 0x7 0x0
#define MX53_PAD_EIM_A17__EMI_WEIM_A_17				0x178 0x4c4 0x000 0x0 0x0
#define MX53_PAD_EIM_A17__GPIO2_21				0x178 0x4c4 0x000 0x1 0x0
#define MX53_PAD_EIM_A17__IPU_DISP1_DAT_12			0x178 0x4c4 0x000 0x2 0x0
#define MX53_PAD_EIM_A17__IPU_CSI1_D_12				0x178 0x4c4 0x000 0x3 0x0
#define MX53_PAD_EIM_A17__SRC_BT_CFG1_2				0x178 0x4c4 0x000 0x7 0x0
#define MX53_PAD_EIM_A16__EMI_WEIM_A_16				0x17c 0x4c8 0x000 0x0 0x0
#define MX53_PAD_EIM_A16__GPIO2_22				0x17c 0x4c8 0x000 0x1 0x0
#define MX53_PAD_EIM_A16__IPU_DI1_DISP_CLK			0x17c 0x4c8 0x000 0x2 0x0
#define MX53_PAD_EIM_A16__IPU_CSI1_PIXCLK			0x17c 0x4c8 0x000 0x3 0x0
#define MX53_PAD_EIM_A16__SRC_BT_CFG1_1				0x17c 0x4c8 0x000 0x7 0x0
#define MX53_PAD_EIM_CS0__EMI_WEIM_CS_0				0x180 0x4cc 0x000 0x0 0x0
#define MX53_PAD_EIM_CS0__GPIO2_23				0x180 0x4cc 0x000 0x1 0x0
#define MX53_PAD_EIM_CS0__ECSPI2_SCLK				0x180 0x4cc 0x7b8 0x2 0x2
#define MX53_PAD_EIM_CS0__IPU_DI1_PIN5				0x180 0x4cc 0x000 0x3 0x0
#define MX53_PAD_EIM_CS1__EMI_WEIM_CS_1				0x184 0x4d0 0x000 0x0 0x0
#define MX53_PAD_EIM_CS1__GPIO2_24				0x184 0x4d0 0x000 0x1 0x0
#define MX53_PAD_EIM_CS1__ECSPI2_MOSI				0x184 0x4d0 0x7c0 0x2 0x2
#define MX53_PAD_EIM_CS1__IPU_DI1_PIN6				0x184 0x4d0 0x000 0x3 0x0
#define MX53_PAD_EIM_OE__EMI_WEIM_OE				0x188 0x4d4 0x000 0x0 0x0
#define MX53_PAD_EIM_OE__GPIO2_25				0x188 0x4d4 0x000 0x1 0x0
#define MX53_PAD_EIM_OE__ECSPI2_MISO				0x188 0x4d4 0x7bc 0x2 0x2
#define MX53_PAD_EIM_OE__IPU_DI1_PIN7				0x188 0x4d4 0x000 0x3 0x0
#define MX53_PAD_EIM_OE__USBPHY2_IDDIG				0x188 0x4d4 0x000 0x7 0x0
#define MX53_PAD_EIM_RW__EMI_WEIM_RW				0x18c 0x4d8 0x000 0x0 0x0
#define MX53_PAD_EIM_RW__GPIO2_26				0x18c 0x4d8 0x000 0x1 0x0
#define MX53_PAD_EIM_RW__ECSPI2_SS0				0x18c 0x4d8 0x7c4 0x2 0x2
#define MX53_PAD_EIM_RW__IPU_DI1_PIN8				0x18c 0x4d8 0x000 0x3 0x0
#define MX53_PAD_EIM_RW__USBPHY2_HOSTDISCONNECT			0x18c 0x4d8 0x000 0x7 0x0
#define MX53_PAD_EIM_LBA__EMI_WEIM_LBA				0x190 0x4dc 0x000 0x0 0x0
#define MX53_PAD_EIM_LBA__GPIO2_27				0x190 0x4dc 0x000 0x1 0x0
#define MX53_PAD_EIM_LBA__ECSPI2_SS1				0x190 0x4dc 0x7c8 0x2 0x1
#define MX53_PAD_EIM_LBA__IPU_DI1_PIN17				0x190 0x4dc 0x000 0x3 0x0
#define MX53_PAD_EIM_LBA__SRC_BT_CFG1_0				0x190 0x4dc 0x000 0x7 0x0
#define MX53_PAD_EIM_EB0__EMI_WEIM_EB_0				0x194 0x4e4 0x000 0x0 0x0
#define MX53_PAD_EIM_EB0__GPIO2_28				0x194 0x4e4 0x000 0x1 0x0
#define MX53_PAD_EIM_EB0__IPU_DISP1_DAT_11			0x194 0x4e4 0x000 0x3 0x0
#define MX53_PAD_EIM_EB0__IPU_CSI1_D_11				0x194 0x4e4 0x000 0x4 0x0
#define MX53_PAD_EIM_EB0__GPC_PMIC_RDY				0x194 0x4e4 0x810 0x5 0x0
#define MX53_PAD_EIM_EB0__SRC_BT_CFG2_7				0x194 0x4e4 0x000 0x7 0x0
#define MX53_PAD_EIM_EB1__EMI_WEIM_EB_1				0x198 0x4e8 0x000 0x0 0x0
#define MX53_PAD_EIM_EB1__GPIO2_29				0x198 0x4e8 0x000 0x1 0x0
#define MX53_PAD_EIM_EB1__IPU_DISP1_DAT_10			0x198 0x4e8 0x000 0x3 0x0
#define MX53_PAD_EIM_EB1__IPU_CSI1_D_10				0x198 0x4e8 0x000 0x4 0x0
#define MX53_PAD_EIM_EB1__SRC_BT_CFG2_6				0x198 0x4e8 0x000 0x7 0x0
#define MX53_PAD_EIM_DA0__EMI_NAND_WEIM_DA_0			0x19c 0x4ec 0x000 0x0 0x0
#define MX53_PAD_EIM_DA0__GPIO3_0				0x19c 0x4ec 0x000 0x1 0x0
#define MX53_PAD_EIM_DA0__IPU_DISP1_DAT_9			0x19c 0x4ec 0x000 0x3 0x0
#define MX53_PAD_EIM_DA0__IPU_CSI1_D_9				0x19c 0x4ec 0x000 0x4 0x0
#define MX53_PAD_EIM_DA0__SRC_BT_CFG2_5				0x19c 0x4ec 0x000 0x7 0x0
#define MX53_PAD_EIM_DA1__EMI_NAND_WEIM_DA_1			0x1a0 0x4f0 0x000 0x0 0x0
#define MX53_PAD_EIM_DA1__GPIO3_1				0x1a0 0x4f0 0x000 0x1 0x0
#define MX53_PAD_EIM_DA1__IPU_DISP1_DAT_8			0x1a0 0x4f0 0x000 0x3 0x0
#define MX53_PAD_EIM_DA1__IPU_CSI1_D_8				0x1a0 0x4f0 0x000 0x4 0x0
#define MX53_PAD_EIM_DA1__SRC_BT_CFG2_4				0x1a0 0x4f0 0x000 0x7 0x0
#define MX53_PAD_EIM_DA2__EMI_NAND_WEIM_DA_2			0x1a4 0x4f4 0x000 0x0 0x0
#define MX53_PAD_EIM_DA2__GPIO3_2				0x1a4 0x4f4 0x000 0x1 0x0
#define MX53_PAD_EIM_DA2__IPU_DISP1_DAT_7			0x1a4 0x4f4 0x000 0x3 0x0
#define MX53_PAD_EIM_DA2__IPU_CSI1_D_7				0x1a4 0x4f4 0x000 0x4 0x0
#define MX53_PAD_EIM_DA2__SRC_BT_CFG2_3				0x1a4 0x4f4 0x000 0x7 0x0
#define MX53_PAD_EIM_DA3__EMI_NAND_WEIM_DA_3			0x1a8 0x4f8 0x000 0x0 0x0
#define MX53_PAD_EIM_DA3__GPIO3_3				0x1a8 0x4f8 0x000 0x1 0x0
#define MX53_PAD_EIM_DA3__IPU_DISP1_DAT_6			0x1a8 0x4f8 0x000 0x3 0x0
#define MX53_PAD_EIM_DA3__IPU_CSI1_D_6				0x1a8 0x4f8 0x000 0x4 0x0
#define MX53_PAD_EIM_DA3__SRC_BT_CFG2_2				0x1a8 0x4f8 0x000 0x7 0x0
#define MX53_PAD_EIM_DA4__EMI_NAND_WEIM_DA_4			0x1ac 0x4fc 0x000 0x0 0x0
#define MX53_PAD_EIM_DA4__GPIO3_4				0x1ac 0x4fc 0x000 0x1 0x0
#define MX53_PAD_EIM_DA4__IPU_DISP1_DAT_5			0x1ac 0x4fc 0x000 0x3 0x0
#define MX53_PAD_EIM_DA4__IPU_CSI1_D_5				0x1ac 0x4fc 0x000 0x4 0x0
#define MX53_PAD_EIM_DA4__SRC_BT_CFG3_7				0x1ac 0x4fc 0x000 0x7 0x0
#define MX53_PAD_EIM_DA5__EMI_NAND_WEIM_DA_5			0x1b0 0x500 0x000 0x0 0x0
#define MX53_PAD_EIM_DA5__GPIO3_5				0x1b0 0x500 0x000 0x1 0x0
#define MX53_PAD_EIM_DA5__IPU_DISP1_DAT_4			0x1b0 0x500 0x000 0x3 0x0
#define MX53_PAD_EIM_DA5__IPU_CSI1_D_4				0x1b0 0x500 0x000 0x4 0x0
#define MX53_PAD_EIM_DA5__SRC_BT_CFG3_6				0x1b0 0x500 0x000 0x7 0x0
#define MX53_PAD_EIM_DA6__EMI_NAND_WEIM_DA_6			0x1b4 0x504 0x000 0x0 0x0
#define MX53_PAD_EIM_DA6__GPIO3_6				0x1b4 0x504 0x000 0x1 0x0
#define MX53_PAD_EIM_DA6__IPU_DISP1_DAT_3			0x1b4 0x504 0x000 0x3 0x0
#define MX53_PAD_EIM_DA6__IPU_CSI1_D_3				0x1b4 0x504 0x000 0x4 0x0
#define MX53_PAD_EIM_DA6__SRC_BT_CFG3_5				0x1b4 0x504 0x000 0x7 0x0
#define MX53_PAD_EIM_DA7__EMI_NAND_WEIM_DA_7			0x1b8 0x508 0x000 0x0 0x0
#define MX53_PAD_EIM_DA7__GPIO3_7				0x1b8 0x508 0x000 0x1 0x0
#define MX53_PAD_EIM_DA7__IPU_DISP1_DAT_2			0x1b8 0x508 0x000 0x3 0x0
#define MX53_PAD_EIM_DA7__IPU_CSI1_D_2				0x1b8 0x508 0x000 0x4 0x0
#define MX53_PAD_EIM_DA7__SRC_BT_CFG3_4				0x1b8 0x508 0x000 0x7 0x0
#define MX53_PAD_EIM_DA8__EMI_NAND_WEIM_DA_8			0x1bc 0x50c 0x000 0x0 0x0
#define MX53_PAD_EIM_DA8__GPIO3_8				0x1bc 0x50c 0x000 0x1 0x0
#define MX53_PAD_EIM_DA8__IPU_DISP1_DAT_1			0x1bc 0x50c 0x000 0x3 0x0
#define MX53_PAD_EIM_DA8__IPU_CSI1_D_1				0x1bc 0x50c 0x000 0x4 0x0
#define MX53_PAD_EIM_DA8__SRC_BT_CFG3_3				0x1bc 0x50c 0x000 0x7 0x0
#define MX53_PAD_EIM_DA9__EMI_NAND_WEIM_DA_9			0x1c0 0x510 0x000 0x0 0x0
#define MX53_PAD_EIM_DA9__GPIO3_9				0x1c0 0x510 0x000 0x1 0x0
#define MX53_PAD_EIM_DA9__IPU_DISP1_DAT_0			0x1c0 0x510 0x000 0x3 0x0
#define MX53_PAD_EIM_DA9__IPU_CSI1_D_0				0x1c0 0x510 0x000 0x4 0x0
#define MX53_PAD_EIM_DA9__SRC_BT_CFG3_2				0x1c0 0x510 0x000 0x7 0x0
#define MX53_PAD_EIM_DA10__EMI_NAND_WEIM_DA_10			0x1c4 0x514 0x000 0x0 0x0
#define MX53_PAD_EIM_DA10__GPIO3_10				0x1c4 0x514 0x000 0x1 0x0
#define MX53_PAD_EIM_DA10__IPU_DI1_PIN15			0x1c4 0x514 0x000 0x3 0x0
#define MX53_PAD_EIM_DA10__IPU_CSI1_DATA_EN			0x1c4 0x514 0x834 0x4 0x1
#define MX53_PAD_EIM_DA10__SRC_BT_CFG3_1			0x1c4 0x514 0x000 0x7 0x0
#define MX53_PAD_EIM_DA11__EMI_NAND_WEIM_DA_11			0x1c8 0x518 0x000 0x0 0x0
#define MX53_PAD_EIM_DA11__GPIO3_11				0x1c8 0x518 0x000 0x1 0x0
#define MX53_PAD_EIM_DA11__IPU_DI1_PIN2				0x1c8 0x518 0x000 0x3 0x0
#define MX53_PAD_EIM_DA11__IPU_CSI1_HSYNC			0x1c8 0x518 0x838 0x4 0x1
#define MX53_PAD_EIM_DA12__EMI_NAND_WEIM_DA_12			0x1cc 0x51c 0x000 0x0 0x0
#define MX53_PAD_EIM_DA12__GPIO3_12				0x1cc 0x51c 0x000 0x1 0x0
#define MX53_PAD_EIM_DA12__IPU_DI1_PIN3				0x1cc 0x51c 0x000 0x3 0x0
#define MX53_PAD_EIM_DA12__IPU_CSI1_VSYNC			0x1cc 0x51c 0x83c 0x4 0x1
#define MX53_PAD_EIM_DA13__EMI_NAND_WEIM_DA_13			0x1d0 0x520 0x000 0x0 0x0
#define MX53_PAD_EIM_DA13__GPIO3_13				0x1d0 0x520 0x000 0x1 0x0
#define MX53_PAD_EIM_DA13__IPU_DI1_D0_CS			0x1d0 0x520 0x000 0x3 0x0
#define MX53_PAD_EIM_DA13__CCM_DI1_EXT_CLK			0x1d0 0x520 0x76c 0x4 0x1
#define MX53_PAD_EIM_DA14__EMI_NAND_WEIM_DA_14			0x1d4 0x524 0x000 0x0 0x0
#define MX53_PAD_EIM_DA14__GPIO3_14				0x1d4 0x524 0x000 0x1 0x0
#define MX53_PAD_EIM_DA14__IPU_DI1_D1_CS			0x1d4 0x524 0x000 0x3 0x0
#define MX53_PAD_EIM_DA14__CCM_DI0_EXT_CLK			0x1d4 0x524 0x000 0x4 0x0
#define MX53_PAD_EIM_DA15__EMI_NAND_WEIM_DA_15			0x1d8 0x528 0x000 0x0 0x0
#define MX53_PAD_EIM_DA15__GPIO3_15				0x1d8 0x528 0x000 0x1 0x0
#define MX53_PAD_EIM_DA15__IPU_DI1_PIN1				0x1d8 0x528 0x000 0x3 0x0
#define MX53_PAD_EIM_DA15__IPU_DI1_PIN4				0x1d8 0x528 0x000 0x4 0x0
#define MX53_PAD_NANDF_WE_B__EMI_NANDF_WE_B			0x1dc 0x52c 0x000 0x0 0x0
#define MX53_PAD_NANDF_WE_B__GPIO6_12				0x1dc 0x52c 0x000 0x1 0x0
#define MX53_PAD_NANDF_RE_B__EMI_NANDF_RE_B			0x1e0 0x530 0x000 0x0 0x0
#define MX53_PAD_NANDF_RE_B__GPIO6_13				0x1e0 0x530 0x000 0x1 0x0
#define MX53_PAD_EIM_WAIT__EMI_WEIM_WAIT			0x1e4 0x534 0x000 0x0 0x0
#define MX53_PAD_EIM_WAIT__GPIO5_0				0x1e4 0x534 0x000 0x1 0x0
#define MX53_PAD_EIM_WAIT__EMI_WEIM_DTACK_B			0x1e4 0x534 0x000 0x2 0x0
#define MX53_PAD_LVDS1_TX3_P__GPIO6_22				0x1ec 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS1_TX3_P__LDB_LVDS1_TX3			0x1ec 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS1_TX2_P__GPIO6_24				0x1f0 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS1_TX2_P__LDB_LVDS1_TX2			0x1f0 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS1_CLK_P__GPIO6_26				0x1f4 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS1_CLK_P__LDB_LVDS1_CLK			0x1f4 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS1_TX1_P__GPIO6_28				0x1f8 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS1_TX1_P__LDB_LVDS1_TX1			0x1f8 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS1_TX0_P__GPIO6_30				0x1fc 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS1_TX0_P__LDB_LVDS1_TX0			0x1fc 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS0_TX3_P__GPIO7_22				0x200 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS0_TX3_P__LDB_LVDS0_TX3			0x200 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS0_CLK_P__GPIO7_24				0x204 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS0_CLK_P__LDB_LVDS0_CLK			0x204 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS0_TX2_P__GPIO7_26				0x208 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS0_TX2_P__LDB_LVDS0_TX2			0x208 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS0_TX1_P__GPIO7_28				0x20c 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS0_TX1_P__LDB_LVDS0_TX1			0x20c 0x000 0x000 0x1 0x0
#define MX53_PAD_LVDS0_TX0_P__GPIO7_30				0x210 0x000 0x000 0x0 0x0
#define MX53_PAD_LVDS0_TX0_P__LDB_LVDS0_TX0			0x210 0x000 0x000 0x1 0x0
#define MX53_PAD_GPIO_10__GPIO4_0				0x214 0x540 0x000 0x0 0x0
#define MX53_PAD_GPIO_10__OSC32k_32K_OUT			0x214 0x540 0x000 0x1 0x0
#define MX53_PAD_GPIO_11__GPIO4_1				0x218 0x544 0x000 0x0 0x0
#define MX53_PAD_GPIO_12__GPIO4_2				0x21c 0x548 0x000 0x0 0x0
#define MX53_PAD_GPIO_13__GPIO4_3				0x220 0x54c 0x000 0x0 0x0
#define MX53_PAD_GPIO_14__GPIO4_4				0x224 0x550 0x000 0x0 0x0
#define MX53_PAD_NANDF_CLE__EMI_NANDF_CLE			0x228 0x5a0 0x000 0x0 0x0
#define MX53_PAD_NANDF_CLE__GPIO6_7				0x228 0x5a0 0x000 0x1 0x0
#define MX53_PAD_NANDF_CLE__USBPHY1_VSTATUS_0			0x228 0x5a0 0x000 0x7 0x0
#define MX53_PAD_NANDF_ALE__EMI_NANDF_ALE			0x22c 0x5a4 0x000 0x0 0x0
#define MX53_PAD_NANDF_ALE__GPIO6_8				0x22c 0x5a4 0x000 0x1 0x0
#define MX53_PAD_NANDF_ALE__USBPHY1_VSTATUS_1			0x22c 0x5a4 0x000 0x7 0x0
#define MX53_PAD_NANDF_WP_B__EMI_NANDF_WP_B			0x230 0x5a8 0x000 0x0 0x0
#define MX53_PAD_NANDF_WP_B__GPIO6_9				0x230 0x5a8 0x000 0x1 0x0
#define MX53_PAD_NANDF_WP_B__USBPHY1_VSTATUS_2			0x230 0x5a8 0x000 0x7 0x0
#define MX53_PAD_NANDF_RB0__EMI_NANDF_RB_0			0x234 0x5ac 0x000 0x0 0x0
#define MX53_PAD_NANDF_RB0__GPIO6_10				0x234 0x5ac 0x000 0x1 0x0
#define MX53_PAD_NANDF_RB0__USBPHY1_VSTATUS_3			0x234 0x5ac 0x000 0x7 0x0
#define MX53_PAD_NANDF_CS0__EMI_NANDF_CS_0			0x238 0x5b0 0x000 0x0 0x0
#define MX53_PAD_NANDF_CS0__GPIO6_11				0x238 0x5b0 0x000 0x1 0x0
#define MX53_PAD_NANDF_CS0__USBPHY1_VSTATUS_4			0x238 0x5b0 0x000 0x7 0x0
#define MX53_PAD_NANDF_CS1__EMI_NANDF_CS_1			0x23c 0x5b4 0x000 0x0 0x0
#define MX53_PAD_NANDF_CS1__GPIO6_14				0x23c 0x5b4 0x000 0x1 0x0
#define MX53_PAD_NANDF_CS1__MLB_MLBCLK				0x23c 0x5b4 0x858 0x6 0x0
#define MX53_PAD_NANDF_CS1__USBPHY1_VSTATUS_5			0x23c 0x5b4 0x000 0x7 0x0
#define MX53_PAD_NANDF_CS2__EMI_NANDF_CS_2			0x240 0x5b8 0x000 0x0 0x0
#define MX53_PAD_NANDF_CS2__GPIO6_15				0x240 0x5b8 0x000 0x1 0x0
#define MX53_PAD_NANDF_CS2__IPU_SISG_0				0x240 0x5b8 0x000 0x2 0x0
#define MX53_PAD_NANDF_CS2__ESAI1_TX0				0x240 0x5b8 0x7e4 0x3 0x0
#define MX53_PAD_NANDF_CS2__EMI_WEIM_CRE			0x240 0x5b8 0x000 0x4 0x0
#define MX53_PAD_NANDF_CS2__CCM_CSI0_MCLK			0x240 0x5b8 0x000 0x5 0x0
#define MX53_PAD_NANDF_CS2__MLB_MLBSIG				0x240 0x5b8 0x860 0x6 0x0
#define MX53_PAD_NANDF_CS2__USBPHY1_VSTATUS_6			0x240 0x5b8 0x000 0x7 0x0
#define MX53_PAD_NANDF_CS3__EMI_NANDF_CS_3			0x244 0x5bc 0x000 0x0 0x0
#define MX53_PAD_NANDF_CS3__GPIO6_16				0x244 0x5bc 0x000 0x1 0x0
#define MX53_PAD_NANDF_CS3__IPU_SISG_1				0x244 0x5bc 0x000 0x2 0x0
#define MX53_PAD_NANDF_CS3__ESAI1_TX1				0x244 0x5bc 0x7e8 0x3 0x0
#define MX53_PAD_NANDF_CS3__EMI_WEIM_A_26			0x244 0x5bc 0x000 0x4 0x0
#define MX53_PAD_NANDF_CS3__MLB_MLBDAT				0x244 0x5bc 0x85c 0x6 0x0
#define MX53_PAD_NANDF_CS3__USBPHY1_VSTATUS_7			0x244 0x5bc 0x000 0x7 0x0
#define MX53_PAD_FEC_MDIO__FEC_MDIO				0x248 0x5c4 0x804 0x0 0x1
#define MX53_PAD_FEC_MDIO__GPIO1_22				0x248 0x5c4 0x000 0x1 0x0
#define MX53_PAD_FEC_MDIO__ESAI1_SCKR				0x248 0x5c4 0x7dc 0x2 0x0
#define MX53_PAD_FEC_MDIO__FEC_COL				0x248 0x5c4 0x800 0x3 0x1
#define MX53_PAD_FEC_MDIO__RTC_CE_RTC_PS2			0x248 0x5c4 0x000 0x4 0x0
#define MX53_PAD_FEC_MDIO__SDMA_DEBUG_BUS_DEVICE_3		0x248 0x5c4 0x000 0x5 0x0
#define MX53_PAD_FEC_MDIO__EMI_EMI_DEBUG_49			0x248 0x5c4 0x000 0x6 0x0
#define MX53_PAD_FEC_REF_CLK__FEC_TX_CLK			0x24c 0x5c8 0x000 0x0 0x0
#define MX53_PAD_FEC_REF_CLK__GPIO1_23				0x24c 0x5c8 0x000 0x1 0x0
#define MX53_PAD_FEC_REF_CLK__ESAI1_FSR				0x24c 0x5c8 0x7cc 0x2 0x0
#define MX53_PAD_FEC_REF_CLK__SDMA_DEBUG_BUS_DEVICE_4		0x24c 0x5c8 0x000 0x5 0x0
#define MX53_PAD_FEC_REF_CLK__EMI_EMI_DEBUG_50			0x24c 0x5c8 0x000 0x6 0x0
#define MX53_PAD_FEC_RX_ER__FEC_RX_ER				0x250 0x5cc 0x000 0x0 0x0
#define MX53_PAD_FEC_RX_ER__GPIO1_24				0x250 0x5cc 0x000 0x1 0x0
#define MX53_PAD_FEC_RX_ER__ESAI1_HCKR				0x250 0x5cc 0x7d4 0x2 0x0
#define MX53_PAD_FEC_RX_ER__FEC_RX_CLK				0x250 0x5cc 0x808 0x3 0x1
#define MX53_PAD_FEC_RX_ER__RTC_CE_RTC_PS3			0x250 0x5cc 0x000 0x4 0x0
#define MX53_PAD_FEC_CRS_DV__FEC_RX_DV				0x254 0x5d0 0x000 0x0 0x0
#define MX53_PAD_FEC_CRS_DV__GPIO1_25				0x254 0x5d0 0x000 0x1 0x0
#define MX53_PAD_FEC_CRS_DV__ESAI1_SCKT				0x254 0x5d0 0x7e0 0x2 0x0
#define MX53_PAD_FEC_RXD1__FEC_RDATA_1				0x258 0x5d4 0x000 0x0 0x0
#define MX53_PAD_FEC_RXD1__GPIO1_26				0x258 0x5d4 0x000 0x1 0x0
#define MX53_PAD_FEC_RXD1__ESAI1_FST				0x258 0x5d4 0x7d0 0x2 0x0
#define MX53_PAD_FEC_RXD1__MLB_MLBSIG				0x258 0x5d4 0x860 0x3 0x1
#define MX53_PAD_FEC_RXD1__RTC_CE_RTC_PS1			0x258 0x5d4 0x000 0x4 0x0
#define MX53_PAD_FEC_RXD0__FEC_RDATA_0				0x25c 0x5d8 0x000 0x0 0x0
#define MX53_PAD_FEC_RXD0__GPIO1_27				0x25c 0x5d8 0x000 0x1 0x0
#define MX53_PAD_FEC_RXD0__ESAI1_HCKT				0x25c 0x5d8 0x7d8 0x2 0x0
#define MX53_PAD_FEC_RXD0__OSC32k_32K_OUT			0x25c 0x5d8 0x000 0x3 0x0
#define MX53_PAD_FEC_TX_EN__FEC_TX_EN				0x260 0x5dc 0x000 0x0 0x0
#define MX53_PAD_FEC_TX_EN__GPIO1_28				0x260 0x5dc 0x000 0x1 0x0
#define MX53_PAD_FEC_TX_EN__ESAI1_TX3_RX2			0x260 0x5dc 0x7f0 0x2 0x0
#define MX53_PAD_FEC_TXD1__FEC_TDATA_1				0x264 0x5e0 0x000 0x0 0x0
#define MX53_PAD_FEC_TXD1__GPIO1_29				0x264 0x5e0 0x000 0x1 0x0
#define MX53_PAD_FEC_TXD1__ESAI1_TX2_RX3			0x264 0x5e0 0x7ec 0x2 0x0
#define MX53_PAD_FEC_TXD1__MLB_MLBCLK				0x264 0x5e0 0x858 0x3 0x1
#define MX53_PAD_FEC_TXD1__RTC_CE_RTC_PRSC_CLK			0x264 0x5e0 0x000 0x4 0x0
#define MX53_PAD_FEC_TXD0__FEC_TDATA_0				0x268 0x5e4 0x000 0x0 0x0
#define MX53_PAD_FEC_TXD0__GPIO1_30				0x268 0x5e4 0x000 0x1 0x0
#define MX53_PAD_FEC_TXD0__ESAI1_TX4_RX1			0x268 0x5e4 0x7f4 0x2 0x0
#define MX53_PAD_FEC_TXD0__USBPHY2_DATAOUT_0			0x268 0x5e4 0x000 0x7 0x0
#define MX53_PAD_FEC_MDC__FEC_MDC				0x26c 0x5e8 0x000 0x0 0x0
#define MX53_PAD_FEC_MDC__GPIO1_31				0x26c 0x5e8 0x000 0x1 0x0
#define MX53_PAD_FEC_MDC__ESAI1_TX5_RX0				0x26c 0x5e8 0x7f8 0x2 0x0
#define MX53_PAD_FEC_MDC__MLB_MLBDAT				0x26c 0x5e8 0x85c 0x3 0x1
#define MX53_PAD_FEC_MDC__RTC_CE_RTC_ALARM1_TRIG		0x26c 0x5e8 0x000 0x4 0x0
#define MX53_PAD_FEC_MDC__USBPHY2_DATAOUT_1			0x26c 0x5e8 0x000 0x7 0x0
#define MX53_PAD_PATA_DIOW__PATA_DIOW				0x270 0x5f0 0x000 0x0 0x0
#define MX53_PAD_PATA_DIOW__GPIO6_17				0x270 0x5f0 0x000 0x1 0x0
#define MX53_PAD_PATA_DIOW__UART1_TXD_MUX			0x270 0x5f0 0x000 0x3 0x0
#define MX53_PAD_PATA_DIOW__USBPHY2_DATAOUT_2			0x270 0x5f0 0x000 0x7 0x0
#define MX53_PAD_PATA_DMACK__PATA_DMACK				0x274 0x5f4 0x000 0x0 0x0
#define MX53_PAD_PATA_DMACK__GPIO6_18				0x274 0x5f4 0x000 0x1 0x0
#define MX53_PAD_PATA_DMACK__UART1_RXD_MUX			0x274 0x5f4 0x878 0x3 0x3
#define MX53_PAD_PATA_DMACK__USBPHY2_DATAOUT_3			0x274 0x5f4 0x000 0x7 0x0
#define MX53_PAD_PATA_DMARQ__PATA_DMARQ				0x278 0x5f8 0x000 0x0 0x0
#define MX53_PAD_PATA_DMARQ__GPIO7_0				0x278 0x5f8 0x000 0x1 0x0
#define MX53_PAD_PATA_DMARQ__UART2_TXD_MUX			0x278 0x5f8 0x000 0x3 0x0
#define MX53_PAD_PATA_DMARQ__CCM_CCM_OUT_0			0x278 0x5f8 0x000 0x5 0x0
#define MX53_PAD_PATA_DMARQ__USBPHY2_DATAOUT_4			0x278 0x5f8 0x000 0x7 0x0
#define MX53_PAD_PATA_BUFFER_EN__PATA_BUFFER_EN			0x27c 0x5fc 0x000 0x0 0x0
#define MX53_PAD_PATA_BUFFER_EN__GPIO7_1			0x27c 0x5fc 0x000 0x1 0x0
#define MX53_PAD_PATA_BUFFER_EN__UART2_RXD_MUX			0x27c 0x5fc 0x880 0x3 0x3
#define MX53_PAD_PATA_BUFFER_EN__CCM_CCM_OUT_1			0x27c 0x5fc 0x000 0x5 0x0
#define MX53_PAD_PATA_BUFFER_EN__USBPHY2_DATAOUT_5		0x27c 0x5fc 0x000 0x7 0x0
#define MX53_PAD_PATA_INTRQ__PATA_INTRQ				0x280 0x600 0x000 0x0 0x0
#define MX53_PAD_PATA_INTRQ__GPIO7_2				0x280 0x600 0x000 0x1 0x0
#define MX53_PAD_PATA_INTRQ__UART2_CTS				0x280 0x600 0x000 0x3 0x0
#define MX53_PAD_PATA_INTRQ__CAN1_TXCAN				0x280 0x600 0x000 0x4 0x0
#define MX53_PAD_PATA_INTRQ__CCM_CCM_OUT_2			0x280 0x600 0x000 0x5 0x0
#define MX53_PAD_PATA_INTRQ__USBPHY2_DATAOUT_6			0x280 0x600 0x000 0x7 0x0
#define MX53_PAD_PATA_DIOR__PATA_DIOR				0x284 0x604 0x000 0x0 0x0
#define MX53_PAD_PATA_DIOR__GPIO7_3				0x284 0x604 0x000 0x1 0x0
#define MX53_PAD_PATA_DIOR__UART2_RTS				0x284 0x604 0x87c 0x3 0x3
#define MX53_PAD_PATA_DIOR__CAN1_RXCAN				0x284 0x604 0x760 0x4 0x1
#define MX53_PAD_PATA_DIOR__USBPHY2_DATAOUT_7			0x284 0x604 0x000 0x7 0x0
#define MX53_PAD_PATA_RESET_B__PATA_PATA_RESET_B		0x288 0x608 0x000 0x0 0x0
#define MX53_PAD_PATA_RESET_B__GPIO7_4				0x288 0x608 0x000 0x1 0x0
#define MX53_PAD_PATA_RESET_B__ESDHC3_CMD			0x288 0x608 0x000 0x2 0x0
#define MX53_PAD_PATA_RESET_B__UART1_CTS			0x288 0x608 0x000 0x3 0x0
#define MX53_PAD_PATA_RESET_B__CAN2_TXCAN			0x288 0x608 0x000 0x4 0x0
#define MX53_PAD_PATA_RESET_B__USBPHY1_DATAOUT_0		0x288 0x608 0x000 0x7 0x0
#define MX53_PAD_PATA_IORDY__PATA_IORDY				0x28c 0x60c 0x000 0x0 0x0
#define MX53_PAD_PATA_IORDY__GPIO7_5				0x28c 0x60c 0x000 0x1 0x0
#define MX53_PAD_PATA_IORDY__ESDHC3_CLK				0x28c 0x60c 0x000 0x2 0x0
#define MX53_PAD_PATA_IORDY__UART1_RTS				0x28c 0x60c 0x874 0x3 0x3
#define MX53_PAD_PATA_IORDY__CAN2_RXCAN				0x28c 0x60c 0x764 0x4 0x1
#define MX53_PAD_PATA_IORDY__USBPHY1_DATAOUT_1			0x28c 0x60c 0x000 0x7 0x0
#define MX53_PAD_PATA_DA_0__PATA_DA_0				0x290 0x610 0x000 0x0 0x0
#define MX53_PAD_PATA_DA_0__GPIO7_6				0x290 0x610 0x000 0x1 0x0
#define MX53_PAD_PATA_DA_0__ESDHC3_RST				0x290 0x610 0x000 0x2 0x0
#define MX53_PAD_PATA_DA_0__OWIRE_LINE				0x290 0x610 0x864 0x4 0x0
#define MX53_PAD_PATA_DA_0__USBPHY1_DATAOUT_2			0x290 0x610 0x000 0x7 0x0
#define MX53_PAD_PATA_DA_1__PATA_DA_1				0x294 0x614 0x000 0x0 0x0
#define MX53_PAD_PATA_DA_1__GPIO7_7				0x294 0x614 0x000 0x1 0x0
#define MX53_PAD_PATA_DA_1__ESDHC4_CMD				0x294 0x614 0x000 0x2 0x0
#define MX53_PAD_PATA_DA_1__UART3_CTS				0x294 0x614 0x000 0x4 0x0
#define MX53_PAD_PATA_DA_1__USBPHY1_DATAOUT_3			0x294 0x614 0x000 0x7 0x0
#define MX53_PAD_PATA_DA_2__PATA_DA_2				0x298 0x618 0x000 0x0 0x0
#define MX53_PAD_PATA_DA_2__GPIO7_8				0x298 0x618 0x000 0x1 0x0
#define MX53_PAD_PATA_DA_2__ESDHC4_CLK				0x298 0x618 0x000 0x2 0x0
#define MX53_PAD_PATA_DA_2__UART3_RTS				0x298 0x618 0x884 0x4 0x5
#define MX53_PAD_PATA_DA_2__USBPHY1_DATAOUT_4			0x298 0x618 0x000 0x7 0x0
#define MX53_PAD_PATA_CS_0__PATA_CS_0				0x29c 0x61c 0x000 0x0 0x0
#define MX53_PAD_PATA_CS_0__GPIO7_9				0x29c 0x61c 0x000 0x1 0x0
#define MX53_PAD_PATA_CS_0__UART3_TXD_MUX			0x29c 0x61c 0x000 0x4 0x0
#define MX53_PAD_PATA_CS_0__USBPHY1_DATAOUT_5			0x29c 0x61c 0x000 0x7 0x0
#define MX53_PAD_PATA_CS_1__PATA_CS_1				0x2a0 0x620 0x000 0x0 0x0
#define MX53_PAD_PATA_CS_1__GPIO7_10				0x2a0 0x620 0x000 0x1 0x0
#define MX53_PAD_PATA_CS_1__UART3_RXD_MUX			0x2a0 0x620 0x888 0x4 0x3
#define MX53_PAD_PATA_CS_1__USBPHY1_DATAOUT_6			0x2a0 0x620 0x000 0x7 0x0
#define MX53_PAD_PATA_DATA0__PATA_DATA_0			0x2a4 0x628 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA0__GPIO2_0				0x2a4 0x628 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA0__EMI_NANDF_D_0			0x2a4 0x628 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA0__ESDHC3_DAT4			0x2a4 0x628 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA0__GPU3d_GPU_DEBUG_OUT_0		0x2a4 0x628 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA0__IPU_DIAG_BUS_0			0x2a4 0x628 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA0__USBPHY1_DATAOUT_7			0x2a4 0x628 0x000 0x7 0x0
#define MX53_PAD_PATA_DATA1__PATA_DATA_1			0x2a8 0x62c 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA1__GPIO2_1				0x2a8 0x62c 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA1__EMI_NANDF_D_1			0x2a8 0x62c 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA1__ESDHC3_DAT5			0x2a8 0x62c 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA1__GPU3d_GPU_DEBUG_OUT_1		0x2a8 0x62c 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA1__IPU_DIAG_BUS_1			0x2a8 0x62c 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA2__PATA_DATA_2			0x2ac 0x630 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA2__GPIO2_2				0x2ac 0x630 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA2__EMI_NANDF_D_2			0x2ac 0x630 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA2__ESDHC3_DAT6			0x2ac 0x630 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA2__GPU3d_GPU_DEBUG_OUT_2		0x2ac 0x630 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA2__IPU_DIAG_BUS_2			0x2ac 0x630 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA3__PATA_DATA_3			0x2b0 0x634 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA3__GPIO2_3				0x2b0 0x634 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA3__EMI_NANDF_D_3			0x2b0 0x634 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA3__ESDHC3_DAT7			0x2b0 0x634 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA3__GPU3d_GPU_DEBUG_OUT_3		0x2b0 0x634 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA3__IPU_DIAG_BUS_3			0x2b0 0x634 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA4__PATA_DATA_4			0x2b4 0x638 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA4__GPIO2_4				0x2b4 0x638 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA4__EMI_NANDF_D_4			0x2b4 0x638 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA4__ESDHC4_DAT4			0x2b4 0x638 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA4__GPU3d_GPU_DEBUG_OUT_4		0x2b4 0x638 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA4__IPU_DIAG_BUS_4			0x2b4 0x638 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA5__PATA_DATA_5			0x2b8 0x63c 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA5__GPIO2_5				0x2b8 0x63c 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA5__EMI_NANDF_D_5			0x2b8 0x63c 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA5__ESDHC4_DAT5			0x2b8 0x63c 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA5__GPU3d_GPU_DEBUG_OUT_5		0x2b8 0x63c 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA5__IPU_DIAG_BUS_5			0x2b8 0x63c 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA6__PATA_DATA_6			0x2bc 0x640 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA6__GPIO2_6				0x2bc 0x640 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA6__EMI_NANDF_D_6			0x2bc 0x640 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA6__ESDHC4_DAT6			0x2bc 0x640 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA6__GPU3d_GPU_DEBUG_OUT_6		0x2bc 0x640 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA6__IPU_DIAG_BUS_6			0x2bc 0x640 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA7__PATA_DATA_7			0x2c0 0x644 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA7__GPIO2_7				0x2c0 0x644 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA7__EMI_NANDF_D_7			0x2c0 0x644 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA7__ESDHC4_DAT7			0x2c0 0x644 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA7__GPU3d_GPU_DEBUG_OUT_7		0x2c0 0x644 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA7__IPU_DIAG_BUS_7			0x2c0 0x644 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA8__PATA_DATA_8			0x2c4 0x648 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA8__GPIO2_8				0x2c4 0x648 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA8__ESDHC1_DAT4			0x2c4 0x648 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA8__EMI_NANDF_D_8			0x2c4 0x648 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA8__ESDHC3_DAT0			0x2c4 0x648 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA8__GPU3d_GPU_DEBUG_OUT_8		0x2c4 0x648 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA8__IPU_DIAG_BUS_8			0x2c4 0x648 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA9__PATA_DATA_9			0x2c8 0x64c 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA9__GPIO2_9				0x2c8 0x64c 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA9__ESDHC1_DAT5			0x2c8 0x64c 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA9__EMI_NANDF_D_9			0x2c8 0x64c 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA9__ESDHC3_DAT1			0x2c8 0x64c 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA9__GPU3d_GPU_DEBUG_OUT_9		0x2c8 0x64c 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA9__IPU_DIAG_BUS_9			0x2c8 0x64c 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA10__PATA_DATA_10			0x2cc 0x650 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA10__GPIO2_10				0x2cc 0x650 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA10__ESDHC1_DAT6			0x2cc 0x650 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA10__EMI_NANDF_D_10			0x2cc 0x650 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA10__ESDHC3_DAT2			0x2cc 0x650 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA10__GPU3d_GPU_DEBUG_OUT_10		0x2cc 0x650 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA10__IPU_DIAG_BUS_10			0x2cc 0x650 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA11__PATA_DATA_11			0x2d0 0x654 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA11__GPIO2_11				0x2d0 0x654 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA11__ESDHC1_DAT7			0x2d0 0x654 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA11__EMI_NANDF_D_11			0x2d0 0x654 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA11__ESDHC3_DAT3			0x2d0 0x654 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA11__GPU3d_GPU_DEBUG_OUT_11		0x2d0 0x654 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA11__IPU_DIAG_BUS_11			0x2d0 0x654 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA12__PATA_DATA_12			0x2d4 0x658 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA12__GPIO2_12				0x2d4 0x658 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA12__ESDHC2_DAT4			0x2d4 0x658 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA12__EMI_NANDF_D_12			0x2d4 0x658 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA12__ESDHC4_DAT0			0x2d4 0x658 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA12__GPU3d_GPU_DEBUG_OUT_12		0x2d4 0x658 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA12__IPU_DIAG_BUS_12			0x2d4 0x658 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA13__PATA_DATA_13			0x2d8 0x65c 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA13__GPIO2_13				0x2d8 0x65c 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA13__ESDHC2_DAT5			0x2d8 0x65c 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA13__EMI_NANDF_D_13			0x2d8 0x65c 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA13__ESDHC4_DAT1			0x2d8 0x65c 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA13__GPU3d_GPU_DEBUG_OUT_13		0x2d8 0x65c 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA13__IPU_DIAG_BUS_13			0x2d8 0x65c 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA14__PATA_DATA_14			0x2dc 0x660 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA14__GPIO2_14				0x2dc 0x660 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA14__ESDHC2_DAT6			0x2dc 0x660 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA14__EMI_NANDF_D_14			0x2dc 0x660 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA14__ESDHC4_DAT2			0x2dc 0x660 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA14__GPU3d_GPU_DEBUG_OUT_14		0x2dc 0x660 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA14__IPU_DIAG_BUS_14			0x2dc 0x660 0x000 0x6 0x0
#define MX53_PAD_PATA_DATA15__PATA_DATA_15			0x2e0 0x664 0x000 0x0 0x0
#define MX53_PAD_PATA_DATA15__GPIO2_15				0x2e0 0x664 0x000 0x1 0x0
#define MX53_PAD_PATA_DATA15__ESDHC2_DAT7			0x2e0 0x664 0x000 0x2 0x0
#define MX53_PAD_PATA_DATA15__EMI_NANDF_D_15			0x2e0 0x664 0x000 0x3 0x0
#define MX53_PAD_PATA_DATA15__ESDHC4_DAT3			0x2e0 0x664 0x000 0x4 0x0
#define MX53_PAD_PATA_DATA15__GPU3d_GPU_DEBUG_OUT_15		0x2e0 0x664 0x000 0x5 0x0
#define MX53_PAD_PATA_DATA15__IPU_DIAG_BUS_15			0x2e0 0x664 0x000 0x6 0x0
#define MX53_PAD_SD1_DATA0__ESDHC1_DAT0				0x2e4 0x66c 0x000 0x0 0x0
#define MX53_PAD_SD1_DATA0__GPIO1_16				0x2e4 0x66c 0x000 0x1 0x0
#define MX53_PAD_SD1_DATA0__GPT_CAPIN1				0x2e4 0x66c 0x000 0x3 0x0
#define MX53_PAD_SD1_DATA0__CSPI_MISO				0x2e4 0x66c 0x784 0x5 0x2
#define MX53_PAD_SD1_DATA0__CCM_PLL3_BYP			0x2e4 0x66c 0x778 0x7 0x0
#define MX53_PAD_SD1_DATA1__ESDHC1_DAT1				0x2e8 0x670 0x000 0x0 0x0
#define MX53_PAD_SD1_DATA1__GPIO1_17				0x2e8 0x670 0x000 0x1 0x0
#define MX53_PAD_SD1_DATA1__GPT_CAPIN2				0x2e8 0x670 0x000 0x3 0x0
#define MX53_PAD_SD1_DATA1__CSPI_SS0				0x2e8 0x670 0x78c 0x5 0x3
#define MX53_PAD_SD1_DATA1__CCM_PLL4_BYP			0x2e8 0x670 0x77c 0x7 0x1
#define MX53_PAD_SD1_CMD__ESDHC1_CMD				0x2ec 0x674 0x000 0x0 0x0
#define MX53_PAD_SD1_CMD__GPIO1_18				0x2ec 0x674 0x000 0x1 0x0
#define MX53_PAD_SD1_CMD__GPT_CMPOUT1				0x2ec 0x674 0x000 0x3 0x0
#define MX53_PAD_SD1_CMD__CSPI_MOSI				0x2ec 0x674 0x788 0x5 0x2
#define MX53_PAD_SD1_CMD__CCM_PLL1_BYP				0x2ec 0x674 0x770 0x7 0x0
#define MX53_PAD_SD1_DATA2__ESDHC1_DAT2				0x2f0 0x678 0x000 0x0 0x0
#define MX53_PAD_SD1_DATA2__GPIO1_19				0x2f0 0x678 0x000 0x1 0x0
#define MX53_PAD_SD1_DATA2__GPT_CMPOUT2				0x2f0 0x678 0x000 0x2 0x0
#define MX53_PAD_SD1_DATA2__PWM2_PWMO				0x2f0 0x678 0x000 0x3 0x0
#define MX53_PAD_SD1_DATA2__WDOG1_WDOG_B			0x2f0 0x678 0x000 0x4 0x0
#define MX53_PAD_SD1_DATA2__CSPI_SS1				0x2f0 0x678 0x790 0x5 0x2
#define MX53_PAD_SD1_DATA2__WDOG1_WDOG_RST_B_DEB		0x2f0 0x678 0x000 0x6 0x0
#define MX53_PAD_SD1_DATA2__CCM_PLL2_BYP			0x2f0 0x678 0x774 0x7 0x0
#define MX53_PAD_SD1_CLK__ESDHC1_CLK				0x2f4 0x67c 0x000 0x0 0x0
#define MX53_PAD_SD1_CLK__GPIO1_20				0x2f4 0x67c 0x000 0x1 0x0
#define MX53_PAD_SD1_CLK__OSC32k_32K_OUT			0x2f4 0x67c 0x000 0x2 0x0
#define MX53_PAD_SD1_CLK__GPT_CLKIN				0x2f4 0x67c 0x000 0x3 0x0
#define MX53_PAD_SD1_CLK__CSPI_SCLK				0x2f4 0x67c 0x780 0x5 0x2
#define MX53_PAD_SD1_CLK__SATA_PHY_DTB_0			0x2f4 0x67c 0x000 0x7 0x0
#define MX53_PAD_SD1_DATA3__ESDHC1_DAT3				0x2f8 0x680 0x000 0x0 0x0
#define MX53_PAD_SD1_DATA3__GPIO1_21				0x2f8 0x680 0x000 0x1 0x0
#define MX53_PAD_SD1_DATA3__GPT_CMPOUT3				0x2f8 0x680 0x000 0x2 0x0
#define MX53_PAD_SD1_DATA3__PWM1_PWMO				0x2f8 0x680 0x000 0x3 0x0
#define MX53_PAD_SD1_DATA3__WDOG2_WDOG_B			0x2f8 0x680 0x000 0x4 0x0
#define MX53_PAD_SD1_DATA3__CSPI_SS2				0x2f8 0x680 0x794 0x5 0x2
#define MX53_PAD_SD1_DATA3__WDOG2_WDOG_RST_B_DEB		0x2f8 0x680 0x000 0x6 0x0
#define MX53_PAD_SD1_DATA3__SATA_PHY_DTB_1			0x2f8 0x680 0x000 0x7 0x0
#define MX53_PAD_SD2_CLK__ESDHC2_CLK				0x2fc 0x688 0x000 0x0 0x0
#define MX53_PAD_SD2_CLK__GPIO1_10				0x2fc 0x688 0x000 0x1 0x0
#define MX53_PAD_SD2_CLK__KPP_COL_5				0x2fc 0x688 0x840 0x2 0x2
#define MX53_PAD_SD2_CLK__AUDMUX_AUD4_RXFS			0x2fc 0x688 0x73c 0x3 0x1
#define MX53_PAD_SD2_CLK__CSPI_SCLK				0x2fc 0x688 0x780 0x5 0x3
#define MX53_PAD_SD2_CLK__SCC_RANDOM_V				0x2fc 0x688 0x000 0x7 0x0
#define MX53_PAD_SD2_CMD__ESDHC2_CMD				0x300 0x68c 0x000 0x0 0x0
#define MX53_PAD_SD2_CMD__GPIO1_11				0x300 0x68c 0x000 0x1 0x0
#define MX53_PAD_SD2_CMD__KPP_ROW_5				0x300 0x68c 0x84c 0x2 0x1
#define MX53_PAD_SD2_CMD__AUDMUX_AUD4_RXC			0x300 0x68c 0x738 0x3 0x1
#define MX53_PAD_SD2_CMD__CSPI_MOSI				0x300 0x68c 0x788 0x5 0x3
#define MX53_PAD_SD2_CMD__SCC_RANDOM				0x300 0x68c 0x000 0x7 0x0
#define MX53_PAD_SD2_DATA3__ESDHC2_DAT3				0x304 0x690 0x000 0x0 0x0
#define MX53_PAD_SD2_DATA3__GPIO1_12				0x304 0x690 0x000 0x1 0x0
#define MX53_PAD_SD2_DATA3__KPP_COL_6				0x304 0x690 0x844 0x2 0x1
#define MX53_PAD_SD2_DATA3__AUDMUX_AUD4_TXC			0x304 0x690 0x740 0x3 0x1
#define MX53_PAD_SD2_DATA3__CSPI_SS2				0x304 0x690 0x794 0x5 0x3
#define MX53_PAD_SD2_DATA3__SJC_DONE				0x304 0x690 0x000 0x7 0x0
#define MX53_PAD_SD2_DATA2__ESDHC2_DAT2				0x308 0x694 0x000 0x0 0x0
#define MX53_PAD_SD2_DATA2__GPIO1_13				0x308 0x694 0x000 0x1 0x0
#define MX53_PAD_SD2_DATA2__KPP_ROW_6				0x308 0x694 0x850 0x2 0x1
#define MX53_PAD_SD2_DATA2__AUDMUX_AUD4_TXD			0x308 0x694 0x734 0x3 0x1
#define MX53_PAD_SD2_DATA2__CSPI_SS1				0x308 0x694 0x790 0x5 0x3
#define MX53_PAD_SD2_DATA2__SJC_FAIL				0x308 0x694 0x000 0x7 0x0
#define MX53_PAD_SD2_DATA1__ESDHC2_DAT1				0x30c 0x698 0x000 0x0 0x0
#define MX53_PAD_SD2_DATA1__GPIO1_14				0x30c 0x698 0x000 0x1 0x0
#define MX53_PAD_SD2_DATA1__KPP_COL_7				0x30c 0x698 0x848 0x2 0x1
#define MX53_PAD_SD2_DATA1__AUDMUX_AUD4_TXFS			0x30c 0x698 0x744 0x3 0x1
#define MX53_PAD_SD2_DATA1__CSPI_SS0				0x30c 0x698 0x78c 0x5 0x4
#define MX53_PAD_SD2_DATA1__RTIC_SEC_VIO			0x30c 0x698 0x000 0x7 0x0
#define MX53_PAD_SD2_DATA0__ESDHC2_DAT0				0x310 0x69c 0x000 0x0 0x0
#define MX53_PAD_SD2_DATA0__GPIO1_15				0x310 0x69c 0x000 0x1 0x0
#define MX53_PAD_SD2_DATA0__KPP_ROW_7				0x310 0x69c 0x854 0x2 0x1
#define MX53_PAD_SD2_DATA0__AUDMUX_AUD4_RXD			0x310 0x69c 0x730 0x3 0x1
#define MX53_PAD_SD2_DATA0__CSPI_MISO				0x310 0x69c 0x784 0x5 0x3
#define MX53_PAD_SD2_DATA0__RTIC_DONE_INT			0x310 0x69c 0x000 0x7 0x0
#define MX53_PAD_GPIO_0__CCM_CLKO				0x314 0x6a4 0x000 0x0 0x0
#define MX53_PAD_GPIO_0__GPIO1_0				0x314 0x6a4 0x000 0x1 0x0
#define MX53_PAD_GPIO_0__KPP_COL_5				0x314 0x6a4 0x840 0x2 0x3
#define MX53_PAD_GPIO_0__CCM_SSI_EXT1_CLK			0x314 0x6a4 0x000 0x3 0x0
#define MX53_PAD_GPIO_0__EPIT1_EPITO				0x314 0x6a4 0x000 0x4 0x0
#define MX53_PAD_GPIO_0__SRTC_ALARM_DEB				0x314 0x6a4 0x000 0x5 0x0
#define MX53_PAD_GPIO_0__USBOH3_USBH1_PWR			0x314 0x6a4 0x000 0x6 0x0
#define MX53_PAD_GPIO_0__CSU_TD					0x314 0x6a4 0x000 0x7 0x0
#define MX53_PAD_GPIO_1__ESAI1_SCKR				0x318 0x6a8 0x7dc 0x0 0x1
#define MX53_PAD_GPIO_1__GPIO1_1				0x318 0x6a8 0x000 0x1 0x0
#define MX53_PAD_GPIO_1__KPP_ROW_5				0x318 0x6a8 0x84c 0x2 0x2
#define MX53_PAD_GPIO_1__CCM_SSI_EXT2_CLK			0x318 0x6a8 0x000 0x3 0x0
#define MX53_PAD_GPIO_1__PWM2_PWMO				0x318 0x6a8 0x000 0x4 0x0
#define MX53_PAD_GPIO_1__WDOG2_WDOG_B				0x318 0x6a8 0x000 0x5 0x0
#define MX53_PAD_GPIO_1__ESDHC1_CD				0x318 0x6a8 0x000 0x6 0x0
#define MX53_PAD_GPIO_1__SRC_TESTER_ACK				0x318 0x6a8 0x000 0x7 0x0
#define MX53_PAD_GPIO_9__ESAI1_FSR				0x31c 0x6ac 0x7cc 0x0 0x1
#define MX53_PAD_GPIO_9__GPIO1_9				0x31c 0x6ac 0x000 0x1 0x0
#define MX53_PAD_GPIO_9__KPP_COL_6				0x31c 0x6ac 0x844 0x2 0x2
#define MX53_PAD_GPIO_9__CCM_REF_EN_B				0x31c 0x6ac 0x000 0x3 0x0
#define MX53_PAD_GPIO_9__PWM1_PWMO				0x31c 0x6ac 0x000 0x4 0x0
#define MX53_PAD_GPIO_9__WDOG1_WDOG_B				0x31c 0x6ac 0x000 0x5 0x0
#define MX53_PAD_GPIO_9__ESDHC1_WP				0x31c 0x6ac 0x7fc 0x6 0x1
#define MX53_PAD_GPIO_9__SCC_FAIL_STATE				0x31c 0x6ac 0x000 0x7 0x0
#define MX53_PAD_GPIO_3__ESAI1_HCKR				0x320 0x6b0 0x7d4 0x0 0x1
#define MX53_PAD_GPIO_3__GPIO1_3				0x320 0x6b0 0x000 0x1 0x0
#define MX53_PAD_GPIO_3__I2C3_SCL				0x320 0x6b0 0x824 0x2 0x1
#define MX53_PAD_GPIO_3__DPLLIP1_TOG_EN				0x320 0x6b0 0x000 0x3 0x0
#define MX53_PAD_GPIO_3__CCM_CLKO2				0x320 0x6b0 0x000 0x4 0x0
#define MX53_PAD_GPIO_3__OBSERVE_MUX_OBSRV_INT_OUT0		0x320 0x6b0 0x000 0x5 0x0
#define MX53_PAD_GPIO_3__USBOH3_USBH1_OC			0x320 0x6b0 0x8a0 0x6 0x1
#define MX53_PAD_GPIO_3__MLB_MLBCLK				0x320 0x6b0 0x858 0x7 0x2
#define MX53_PAD_GPIO_6__ESAI1_SCKT				0x324 0x6b4 0x7e0 0x0 0x1
#define MX53_PAD_GPIO_6__GPIO1_6				0x324 0x6b4 0x000 0x1 0x0
#define MX53_PAD_GPIO_6__I2C3_SDA				0x324 0x6b4 0x828 0x2 0x1
#define MX53_PAD_GPIO_6__CCM_CCM_OUT_0				0x324 0x6b4 0x000 0x3 0x0
#define MX53_PAD_GPIO_6__CSU_CSU_INT_DEB			0x324 0x6b4 0x000 0x4 0x0
#define MX53_PAD_GPIO_6__OBSERVE_MUX_OBSRV_INT_OUT1		0x324 0x6b4 0x000 0x5 0x0
#define MX53_PAD_GPIO_6__ESDHC2_LCTL				0x324 0x6b4 0x000 0x6 0x0
#define MX53_PAD_GPIO_6__MLB_MLBSIG				0x324 0x6b4 0x860 0x7 0x2
#define MX53_PAD_GPIO_2__ESAI1_FST				0x328 0x6b8 0x7d0 0x0 0x1
#define MX53_PAD_GPIO_2__GPIO1_2				0x328 0x6b8 0x000 0x1 0x0
#define MX53_PAD_GPIO_2__KPP_ROW_6				0x328 0x6b8 0x850 0x2 0x2
#define MX53_PAD_GPIO_2__CCM_CCM_OUT_1				0x328 0x6b8 0x000 0x3 0x0
#define MX53_PAD_GPIO_2__CSU_CSU_ALARM_AUT_0			0x328 0x6b8 0x000 0x4 0x0
#define MX53_PAD_GPIO_2__OBSERVE_MUX_OBSRV_INT_OUT2		0x328 0x6b8 0x000 0x5 0x0
#define MX53_PAD_GPIO_2__ESDHC2_WP				0x328 0x6b8 0x000 0x6 0x0
#define MX53_PAD_GPIO_2__MLB_MLBDAT				0x328 0x6b8 0x85c 0x7 0x2
#define MX53_PAD_GPIO_4__ESAI1_HCKT				0x32c 0x6bc 0x7d8 0x0 0x1
#define MX53_PAD_GPIO_4__GPIO1_4				0x32c 0x6bc 0x000 0x1 0x0
#define MX53_PAD_GPIO_4__KPP_COL_7				0x32c 0x6bc 0x848 0x2 0x2
#define MX53_PAD_GPIO_4__CCM_CCM_OUT_2				0x32c 0x6bc 0x000 0x3 0x0
#define MX53_PAD_GPIO_4__CSU_CSU_ALARM_AUT_1			0x32c 0x6bc 0x000 0x4 0x0
#define MX53_PAD_GPIO_4__OBSERVE_MUX_OBSRV_INT_OUT3		0x32c 0x6bc 0x000 0x5 0x0
#define MX53_PAD_GPIO_4__ESDHC2_CD				0x32c 0x6bc 0x000 0x6 0x0
#define MX53_PAD_GPIO_4__SCC_SEC_STATE				0x32c 0x6bc 0x000 0x7 0x0
#define MX53_PAD_GPIO_5__ESAI1_TX2_RX3				0x330 0x6c0 0x7ec 0x0 0x1
#define MX53_PAD_GPIO_5__GPIO1_5				0x330 0x6c0 0x000 0x1 0x0
#define MX53_PAD_GPIO_5__KPP_ROW_7				0x330 0x6c0 0x854 0x2 0x2
#define MX53_PAD_GPIO_5__CCM_CLKO				0x330 0x6c0 0x000 0x3 0x0
#define MX53_PAD_GPIO_5__CSU_CSU_ALARM_AUT_2			0x330 0x6c0 0x000 0x4 0x0
#define MX53_PAD_GPIO_5__OBSERVE_MUX_OBSRV_INT_OUT4		0x330 0x6c0 0x000 0x5 0x0
#define MX53_PAD_GPIO_5__I2C3_SCL				0x330 0x6c0 0x824 0x6 0x2
#define MX53_PAD_GPIO_5__CCM_PLL1_BYP				0x330 0x6c0 0x770 0x7 0x1
#define MX53_PAD_GPIO_7__ESAI1_TX4_RX1				0x334 0x6c4 0x7f4 0x0 0x1
#define MX53_PAD_GPIO_7__GPIO1_7				0x334 0x6c4 0x000 0x1 0x0
#define MX53_PAD_GPIO_7__EPIT1_EPITO				0x334 0x6c4 0x000 0x2 0x0
#define MX53_PAD_GPIO_7__CAN1_TXCAN				0x334 0x6c4 0x000 0x3 0x0
#define MX53_PAD_GPIO_7__UART2_TXD_MUX				0x334 0x6c4 0x000 0x4 0x0
#define MX53_PAD_GPIO_7__FIRI_RXD				0x334 0x6c4 0x80c 0x5 0x1
#define MX53_PAD_GPIO_7__SPDIF_PLOCK				0x334 0x6c4 0x000 0x6 0x0
#define MX53_PAD_GPIO_7__CCM_PLL2_BYP				0x334 0x6c4 0x774 0x7 0x1
#define MX53_PAD_GPIO_8__ESAI1_TX5_RX0				0x338 0x6c8 0x7f8 0x0 0x1
#define MX53_PAD_GPIO_8__GPIO1_8				0x338 0x6c8 0x000 0x1 0x0
#define MX53_PAD_GPIO_8__EPIT2_EPITO				0x338 0x6c8 0x000 0x2 0x0
#define MX53_PAD_GPIO_8__CAN1_RXCAN				0x338 0x6c8 0x760 0x3 0x2
#define MX53_PAD_GPIO_8__UART2_RXD_MUX				0x338 0x6c8 0x880 0x4 0x5
#define MX53_PAD_GPIO_8__FIRI_TXD				0x338 0x6c8 0x000 0x5 0x0
#define MX53_PAD_GPIO_8__SPDIF_SRCLK				0x338 0x6c8 0x000 0x6 0x0
#define MX53_PAD_GPIO_8__CCM_PLL3_BYP				0x338 0x6c8 0x778 0x7 0x1
#define MX53_PAD_GPIO_16__ESAI1_TX3_RX2				0x33c 0x6cc 0x7f0 0x0 0x1
#define MX53_PAD_GPIO_16__GPIO7_11				0x33c 0x6cc 0x000 0x1 0x0
#define MX53_PAD_GPIO_16__TZIC_PWRFAIL_INT			0x33c 0x6cc 0x000 0x2 0x0
#define MX53_PAD_GPIO_16__RTC_CE_RTC_EXT_TRIG1			0x33c 0x6cc 0x000 0x4 0x0
#define MX53_PAD_GPIO_16__SPDIF_IN1				0x33c 0x6cc 0x870 0x5 0x1
#define MX53_PAD_GPIO_16__I2C3_SDA				0x33c 0x6cc 0x828 0x6 0x2
#define MX53_PAD_GPIO_16__SJC_DE_B				0x33c 0x6cc 0x000 0x7 0x0
#define MX53_PAD_GPIO_17__ESAI1_TX0				0x340 0x6d0 0x7e4 0x0 0x1
#define MX53_PAD_GPIO_17__GPIO7_12				0x340 0x6d0 0x000 0x1 0x0
#define MX53_PAD_GPIO_17__SDMA_EXT_EVENT_0			0x340 0x6d0 0x868 0x2 0x1
#define MX53_PAD_GPIO_17__GPC_PMIC_RDY				0x340 0x6d0 0x810 0x3 0x1
#define MX53_PAD_GPIO_17__RTC_CE_RTC_FSV_TRIG			0x340 0x6d0 0x000 0x4 0x0
#define MX53_PAD_GPIO_17__SPDIF_OUT1				0x340 0x6d0 0x000 0x5 0x0
#define MX53_PAD_GPIO_17__IPU_SNOOP2				0x340 0x6d0 0x000 0x6 0x0
#define MX53_PAD_GPIO_17__SJC_JTAG_ACT				0x340 0x6d0 0x000 0x7 0x0
#define MX53_PAD_GPIO_18__ESAI1_TX1				0x344 0x6d4 0x7e8 0x0 0x1
#define MX53_PAD_GPIO_18__GPIO7_13				0x344 0x6d4 0x000 0x1 0x0
#define MX53_PAD_GPIO_18__SDMA_EXT_EVENT_1			0x344 0x6d4 0x86c 0x2 0x1
#define MX53_PAD_GPIO_18__OWIRE_LINE				0x344 0x6d4 0x864 0x3 0x1
#define MX53_PAD_GPIO_18__RTC_CE_RTC_ALARM2_TRIG		0x344 0x6d4 0x000 0x4 0x0
#define MX53_PAD_GPIO_18__CCM_ASRC_EXT_CLK			0x344 0x6d4 0x768 0x5 0x1
#define MX53_PAD_GPIO_18__ESDHC1_LCTL				0x344 0x6d4 0x000 0x6 0x0
#define MX53_PAD_GPIO_18__SRC_SYSTEM_RST			0x344 0x6d4 0x000 0x7 0x0

#endif /* __DTS_IMX53_PINFUNC_H */
