/*
  This file is part of TALER
  (C) 2025 Taler Systems SA

  TALER is free software; you can redistribute it and/or modify it under the
  terms of the GNU Affero General Public License as published by the Free Software
  Foundation; either version 3, or (at your option) any later version.

  TALER is distributed in the hope that it will be useful, but WITHOUT ANY
  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
  A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with
  TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
*/
/**
 * @file taler-merchant-httpd_private-get-units.c
 * @brief implement GET /private/units
 * @author Bohdan Potuzhnyi
 */
#include "platform.h"
#include "taler-merchant-httpd_private-get-units.h"


static void
add_unit (void *cls,
          uint64_t unit_serial,
          const struct TALER_MERCHANTDB_UnitDetails *ud)
{
  json_t *ua = cls;

  GNUNET_assert (
    0 ==
    json_array_append_new (
      ua,
      GNUNET_JSON_PACK (
        GNUNET_JSON_pack_uint64 ("unit_serial",
                                 unit_serial),
        GNUNET_JSON_pack_string ("unit",
                                 ud->unit),
        GNUNET_JSON_pack_string ("unit_name_long",
                                 ud->unit_name_long),
        GNUNET_JSON_pack_object_incref ("unit_name_long_i18n",
                                        (json_t *) ud->unit_name_long_i18n),
        GNUNET_JSON_pack_string ("unit_name_short",
                                 ud->unit_name_short),
        GNUNET_JSON_pack_object_incref ("unit_name_short_i18n",
                                        (json_t *) ud->unit_name_short_i18n),
        GNUNET_JSON_pack_bool ("unit_allow_fraction",
                               ud->unit_allow_fraction),
        GNUNET_JSON_pack_uint64 ("unit_precision_level",
                                 ud->unit_precision_level),
        GNUNET_JSON_pack_bool ("unit_active",
                               ud->unit_active),
        GNUNET_JSON_pack_bool ("unit_builtin",
                               ud->unit_builtin))));
}


MHD_RESULT
TMH_private_get_units (const struct TMH_RequestHandler *rh,
                       struct MHD_Connection *connection,
                       struct TMH_HandlerContext *hc)
{
  json_t *ua;
  enum GNUNET_DB_QueryStatus qs;

  (void) rh;
  ua = json_array ();
  GNUNET_assert (NULL != ua);
  qs = TMH_db->lookup_units (TMH_db->cls,
                             hc->instance->settings.id,
                             &add_unit,
                             ua);
  if (0 > qs)
  {
    GNUNET_break (0);
    json_decref (ua);
    return TALER_MHD_reply_with_error (connection,
                                       MHD_HTTP_INTERNAL_SERVER_ERROR,
                                       TALER_EC_GENERIC_DB_FETCH_FAILED,
                                       NULL);
  }
  return TALER_MHD_REPLY_JSON_PACK (connection,
                                    MHD_HTTP_OK,
                                    GNUNET_JSON_pack_array_steal ("units",
                                                                  ua));
}


/* end of taler-merchant-httpd_private-get-units.c */
