/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_insert_order_blinded_sigs.c
 * @brief implementation of insert_order_blinded_sigs() for Postgres
 * @author Bohdan Potuzhnyi
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_pq_lib.h>
#include "pg_insert_order_blinded_sigs.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_insert_order_blinded_sigs (
  void *cls,
  const char *order_id,
  uint32_t i,
  const struct GNUNET_HashCode *hash,
  const struct GNUNET_CRYPTO_BlindedSignature *blind_sig)
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (order_id),
    GNUNET_PQ_query_param_uint32 (&i),
    GNUNET_PQ_query_param_auto_from_type (hash),
    GNUNET_PQ_query_param_blinded_sig (blind_sig),
    GNUNET_PQ_query_param_end
  };

  check_connection (pg);
  PREPARE (pg,
           "insert_blinded_sigs",
           "INSERT INTO merchant_order_token_blinded_sigs"
           " (order_serial"
           " ,token_index"
           " ,token_hash"
           " ,token_blinded_signature"
           ")"
           " SELECT order_serial, $2, $3, $4"
           "   FROM merchant_contract_terms"
           "  WHERE order_id = $1");

  return GNUNET_PQ_eval_prepared_non_select (pg->conn,
                                             "insert_blinded_sigs",
                                             params);
}
