//These routines import the basic GTK/GDK types from the _gtkbase module.
//You must call pygtk_init before use.

%{
typedef struct {
  PyObject_HEAD
  GtkObject *obj;
} PyGtk_Object;
static PyTypeObject *PyGtk_Type;

typedef struct {
  PyObject_HEAD
  GtkAccelGroup *obj;
} PyGtkAccelGroup_Object;
static PyTypeObject *PyGtkAccelGroup_Type;

typedef struct {
  PyObject_HEAD
  GtkStyle *obj;
} PyGtkStyle_Object;
static PyTypeObject *PyGtkStyle_Type;

typedef struct {
  PyObject_HEAD
  GdkFont *obj;
} PyGdkFont_Object;
static PyTypeObject *PyGdkFont_Type;

typedef struct {
  PyObject_HEAD
  GdkColor obj;
} PyGdkColor_Object;
static PyTypeObject *PyGdkColor_Type;

typedef struct {
  PyObject_HEAD
  GdkEvent *obj;
        PyObject *attrs;
} PyGdkEvent_Object;
static PyTypeObject *PyGdkEvent_Type;

typedef struct {
  PyObject_HEAD
  GdkWindow *obj;
} PyGdkWindow_Object;
static PyTypeObject *PyGdkWindow_Type;

typedef struct {
  PyObject_HEAD
  GdkGC *obj;
} PyGdkGC_Object;
static PyTypeObject *PyGdkGC_Type;

typedef struct {
  PyObject_HEAD
  GdkColormap *obj;
} PyGdkColormap_Object;
static PyTypeObject *PyGdkColormap_Type;

#define PyGtk_Check(v) ((v)->ob_type == PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->obj)
#define PyGtkAccelGroup_Check(v) ((v)->ob_type == PyGtkAccelGroup_Type)
#define PyGtkAccelGroup_Get(v) (((PyGtkAccelGroup_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)
#define PyGdkColormap_Check(v) ((v)->ob_type == PyGdkColormap_Type)
#define PyGdkColormap_Get(v) (((PyGdkColormap_Object *)(v))->obj)

static PyObject *(*PyGtk_New)(GtkObject *)=0;
static PyObject *(*PyGtkAccelGroup_New)(GtkAccelGroup *)=0;
static PyObject *(*PyGtkStyle_New)(GtkStyle *)=0;
static PyObject *(*PyGdkFont_New)(GdkFont *)=0;
static PyObject *(*PyGdkColor_New)(GdkColor *)=0;
static PyObject *(*PyGdkEvent_New)(GdkEvent *)=0;
static PyObject *(*PyGdkWindow_New)(GdkWindow *)=0;
static PyObject *(*PyGdkGC_New)(GdkGC *)=0;
static PyObject *(*PyGdkColormap_New)(GdkColormap *)=0;

static void (*PyGtk_CallbackMarshal)(GtkObject *o, gpointer data,
				     int nargs, GtkArg *args)=0;
static void (*PyGtk_DestroyNotify)(gpointer data)=0;

static PyObject *(*GtkArgs_AsTuple)(int nparams, GtkArg *args)=0;
static int (*GtkArgs_FromSequence)(GtkArg *args, int nparams, PyObject *seq)=0;
static int (*GtkArg_FromPyObject)(GtkArg *arg, PyObject *obj)=0;
static PyObject *(*GtkArg_AsPyObject)(GtkArg *arg)=0;
static void (*GtkRet_FromPyObject)(GtkArg *ret, PyObject *py_ret)=0;
static PyObject *(*GtkRet_AsPyObject)(GtkArg *ret)=0;

static int (*PyGtkEnum_get_value)(GtkType type, PyObject *obj, gint *val)=0;
static int (*PyGtkFlag_get_value)(GtkType type, PyObject *obj, gint *val)=0;

static GtkArg *(*PyDict_AsGtkArgs)(PyObject *dict, GtkType type, gint*nargs)=0;

static void pygtk_init() {
  PyObject *gtkbase, *dict, *func, *ret;

  gtkbase = PyImport_ImportModule("_gtkbase");
  dict = PyModule_GetDict(gtkbase);
  Py_DECREF(gtkbase);

  ret = PyObject_CallObject(PyDict_GetItemString(dict, "gtk_init"), NULL);
  Py_DECREF(ret);

  /* extract the types */
  PyGtk_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GtkObjectType");
  Py_INCREF(PyGtk_Type);
  PyGtkAccelGroup_Type = (PyTypeObject *)PyDict_GetItemString(dict,
						"GtkAccelGroupType");
  Py_INCREF(PyGtkAccelGroup_Type);
  PyGtkStyle_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GtkStyleType");
  Py_INCREF(PyGtkStyle_Type);
  PyGdkFont_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkFontType");
  Py_INCREF(PyGdkFont_Type);
  PyGdkColor_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkColorType");
  Py_INCREF(PyGdkColor_Type);
  PyGdkEvent_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkEventType");
  Py_INCREF(PyGdkEvent_Type);
  PyGdkWindow_Type = (PyTypeObject*)PyDict_GetItemString(dict,"GdkWindowType");
  Py_INCREF(PyGdkWindow_Type);
  PyGdkGC_Type = (PyTypeObject *)PyDict_GetItemString(dict, "GdkGCType");
  Py_INCREF(PyGdkGC_Type);
  PyGdkColormap_Type = (PyTypeObject *)PyDict_GetItemString(dict,
							    "GdkColormapType");
  Py_INCREF(PyGdkColormap_Type);

  dict = PyDict_GetItemString(dict, "_private");
  PyGtk_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_New"));
  PyGtkAccelGroup_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkAccelGroup_New"));
  PyGtkStyle_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkStyle_New"));
  PyGdkFont_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkFont_New"));
  PyGdkColor_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkColor_New"));
  PyGdkEvent_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkEvent_New"));
  PyGdkWindow_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkWindow_New"));
  PyGdkGC_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkGC_New"));
  PyGdkColormap_New = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGdkColormap_New"));

  PyGtk_DestroyNotify = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_DestroyNotify"));
  PyGtk_CallbackMarshal = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtk_CallbackMarshal"));

  GtkArgs_AsTuple = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkArgs_AsTuple"));
  GtkArgs_FromSequence = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkArgs_FromSequence"));
  GtkRet_FromPyObject = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkRet_FromPyObject"));
  GtkRet_AsPyObject = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"GtkRet_AsPyObject"));

  PyGtkEnum_get_value = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkEnum_get_value"));
  PyGtkFlag_get_value = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyGtkFlag_get_value"));

  PyDict_AsGtkArgs = PyCObject_AsVoidPtr(PyDict_GetItemString(dict,
						"PyDict_AsGtkArgs"));
}
%}

%typemap(python,in) GtkObject * {
  if (PyGtk_Check($source))
    $target = PyGtk_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
%typemap(python,out) GtkObject * {
  $target = PyGtk_New($source);
}
%typemap(python,in) GtkWidget * {
  if (PyGtk_Check($source))
    $target = GTK_WIDGET(PyGtk_Get($source));
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkObject");
    return NULL;
  }
}
%typemap(python,out) GtkWidget * {
  $target = PyGtk_New((GtkObject *)$source);
}
%typemap(python,in) GtkAccelGroup * {
  if (PyGtkAccelGroup_Check($source))
    $target = PyGtkAccelGroup_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkAccelGroup");
    return NULL;
  }
}
%typemap(python,out) GtkAccelGroup * {
  $target = PyGtkAccelGroup_New($source);
}
%typemap(python,in) GtkStyle * {
  if (PyGtkStyle_Check($source))
    $target = PyGtkStyle_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GtkStyle");
    return NULL;
  }
}
%typemap(python,out) GtkStyle * {
  $target = PyGtkStyle_New($source);
}
%typemap(python,in) GdkFont * {
  if (PyGdkFont_Check($source))
    $target = PyGdkFont_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkFont");
    return NULL;
  }
}
%typemap(python,out) GdkFont * {
  $target = PyGdkFont_New($source);
}
%typemap(python,in) GdkColor * {
  if (PyGdkColor_Check($source))
    $target = PyGdkColor_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
    return NULL;
  }
}
%typemap(python,out) GdkColor * {
  $target = PyGdkColor_New($source);
}
%typemap(python,in) GdkEvent * {
  if (PyGdkEvent_Check($source))
    $target = PyGdkEvent_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkEvent");
    return NULL;
  }
}
%typemap(python,out) GdkEvent * {
  $target = PyGdkEvent_New($source);
}
%typemap(python,in) GdkWindow * {
  if (PyGdkWindow_Check($source))
    $target = PyGdkWindow_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
%typemap(python,out) GdkWindow * {
  $target = PyGdkWindow_New($source);
}
%typemap(python,in) GdkPixmap * {
  if (PyGdkWindow_Check($source))
    $target = PyGdkWindow_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
%typemap(python,out) GdkPixmap * {
  $target = PyGdkWindow_New($source);
}
%typemap(python,in) GdkBitmap * {
  if (PyGdkWindow_Check($source))
    $target = PyGdkWindow_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
%typemap(python,out) GdkBitmap * {
  $target = PyGdkWindow_New($source);
}
%typemap(python,in) GdkGC * {
  if (PyGdkGC_Check($source))
    $target = PyGdkGC_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
%typemap(python,out) GdkGC * {
  $target = PyGdkGC_New($source);
}
%typemap(python,in) GdkColormap * {
  if (PyGdkColormap_Check($source))
    $target = PyGdkColormap_Get($source);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkColormap");
    return NULL;
  }
}
%typemap(python,out) GdkColormap * {
  $target = PyGdkColormap_New($source);
}
