%{
#include "sysmodule.h"

static PyObject * gtk__init(PyObject *self, PyObject *args) {
    PyObject *av;
    int argc, i;
    char **argv;

    /* ensure that this procedure only gets run once */
    static int run_already = 0;
    if (run_already) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    run_already = 1;

    if (!PyArg_ParseTuple(args, ":gtk_init"))
        return NULL;

    av = PySys_GetObject("argv");
    argc = PyList_Size(av);
    argv = malloc(argc * sizeof(char *));
    for (i = 0; i < argc; i++)
        argv[i] = strdup(PyString_AsString(PyList_GetItem(av, i)));

    gtk_init(&argc, &argv);
    PySys_SetArgv(argc, argv);

    if (argv != NULL) {
        for (i = 0; i < argc; i++)
            if (argv[i] != NULL)
                free(argv[i]);
        free(argv);
    }
    gtk_signal_set_funcs((GtkSignalMarshal)PyGtk_SignalMarshal,
                         (GtkSignalDestroy)PyGtk_SignalDestroy);

    /* call gtk_*_get_type for each widget, so gtk_type_from_name works */
    gtk_adjustment_get_type();
    gtk_alignment_get_type();
    gtk_arrow_get_type();
    gtk_aspect_frame_get_type();
    gtk_bin_get_type();
    gtk_box_get_type();
    gtk_button_get_type();
    gtk_button_box_get_type();
    gtk_check_button_get_type();
    gtk_check_menu_item_get_type();
    gtk_clist_get_type();
    gtk_color_selection_get_type();
    gtk_color_selection_dialog_get_type();
    gtk_combo_get_type();
    gtk_container_get_type();
    gtk_curve_get_type();
    gtk_data_get_type();
    gtk_dialog_get_type();
    gtk_drawing_area_get_type();
    gtk_entry_get_type();
    gtk_event_box_get_type();
    gtk_file_selection_get_type();
    gtk_fixed_get_type();
    gtk_frame_get_type();
    gtk_gamma_curve_get_type();
    gtk_handle_box_get_type();
    gtk_hbox_get_type();
    gtk_hbutton_box_get_type();
    gtk_hpaned_get_type();
    gtk_hruler_get_type();
    gtk_hscale_get_type();
    gtk_hscrollbar_get_type();
    gtk_hseparator_get_type();
    gtk_image_get_type();
    gtk_input_dialog_get_type();
    gtk_item_get_type();
    gtk_label_get_type();
    gtk_list_get_type();
    gtk_list_item_get_type();
    gtk_menu_get_type();
    gtk_menu_bar_get_type();
    gtk_menu_item_get_type();
    gtk_menu_shell_get_type();
    gtk_misc_get_type();
    gtk_notebook_get_type();
    gtk_object_get_type();
    gtk_option_menu_get_type();
    gtk_paned_get_type();
    gtk_pixmap_get_type();
    gtk_preview_get_type();
    gtk_progress_bar_get_type();
    gtk_radio_button_get_type();
    gtk_radio_menu_item_get_type();
    gtk_range_get_type();
    gtk_ruler_get_type();
    gtk_scale_get_type();
    gtk_scrollbar_get_type();
    gtk_scrolled_window_get_type();
    gtk_separator_get_type();
    gtk_statusbar_get_type();
    gtk_table_get_type();
    gtk_text_get_type();
    gtk_toggle_button_get_type();
    gtk_toolbar_get_type();
    gtk_tree_get_type();
    gtk_tree_item_get_type();
    gtk_vbox_get_type();
    gtk_vbutton_box_get_type();
    gtk_vpaned_get_type();
    gtk_vruler_get_type();
    gtk_vscale_get_type();
    gtk_vscrollbar_get_type();
    gtk_vseparator_get_type();
    gtk_viewport_get_type();
    gtk_widget_get_type();
    gtk_window_get_type();

    Py_INCREF(Py_None);
    return Py_None;
}

%}

%native(gtk_init) PyObject * gtk__init(PyObject *self, PyObject *args);
void gtk_exit(int err);
void gtk_main();
void gtk_main_quit();
int gtk_main_iteration();
void gtk_grab_add(GtkWidget *w);
void gtk_grab_remove(GtkWidget *w);

%{
static PyObject *
gtk__timeout_add(PyObject *self, PyObject *args) {
    guint32 interval;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_timeout_add", &interval, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "second arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_timeout_add_interp(interval,
        (GtkCallbackMarshal)PyGtk_CallbackMarshal, callback,
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__idle_add(PyObject *self, PyObject *args) {
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "O:gtk_idle_add", &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_interp(
        (GtkCallbackMarshal)PyGtk_CallbackMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
%}
%native(gtk_timeout_add) PyObject *gtk__timeout_add(PyObject *s, PyObject *a);
void gtk_timeout_remove(int tag);
%native(gtk_idle_add) PyObject *gtk__idle_add(PyObject *s, PyObject *a);
void gtk_idle_remove(int tag);
%name(gtk_idle_remove_function) void gtk_idle_remove_by_data(PyObject *func);

/* rc parsing functions */
void gtk_rc_init();
void gtk_rc_parse(char *fname);
void gtk_rc_parse_string(char *rc_string);
GtkStyle *gtk_rc_get_style(GtkWidget *);
void gtk_rc_add_widget_name_style(GtkStyle *s, char *pattern);
void gtk_rc_add_widget_class_style(GtkStyle *s, char *pattern);

