/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

/*
 */
static void dummy(void) {}
#if HAVE_GNOME

#include <vdk/vdkgnomeform.h>
#include <vdk/boxes.h>
#include <vdk/vdkgnomeappbar.h>
#include <vdk/toolbar.h>
#include <vdk/menu.h>
VDKGnomeForm::VDKGnomeForm(VDKGnomeApplication* app,
			   char* title,
			   int mode):
    VDKForm(app,gnome_app_new(app->AppId(),app->AppTitle()),title)
{
    box = new VDKBox(this,mode);
    items.add(box);
    gtk_widget_set_name(box->Widget(),"VDKGnomeForm::Box");
    gnome_app_set_contents(GNOME_APP(window),box->Widget());
    gtk_widget_show(box->Widget());
    box->Parent(this);
}
/*
  for builder only
*/
VDKGnomeForm::VDKGnomeForm(VDKForm* owner,
			   char* app_id,
			   char* title,
			   int mode):
    VDKForm(owner,gnome_app_new(app_id,app_id),title)
{
    box = new VDKBox(this,mode);
    items.add(box);
    gtk_widget_set_name(box->Widget(),"VDKGnomeForm::Box");
    gnome_app_set_contents(GNOME_APP(window),box->Widget());
    gtk_widget_show(box->Widget());
    box->Parent(this);
}

/*
 */
VDKGnomeForm::~VDKGnomeForm()
{

}
/*
 */
void
VDKGnomeForm::Add(VDKObject* obj, int justify,
		  int expand, int fill , int padding)
{
    if(dynamic_cast<VDKGnomeAppBar*>(obj))
	{
	    gnome_app_set_statusbar(GNOME_APP(window),obj->Widget());
	    items.add(obj);
	    obj->Setup();
	    gtk_widget_show(obj->Widget());
	}
    else if(dynamic_cast<VDKToolbar*>(obj))
	{
	    gnome_app_set_toolbar(GNOME_APP(window),
				  GTK_TOOLBAR(obj->Widget()));
	    items.add(obj);
	    obj->Setup();
	    gtk_widget_show(obj->Widget());
	}
    else if(dynamic_cast<VDKMenubar*>(obj))
	{
	    gnome_app_set_menus(GNOME_APP(window),
				  GTK_MENU_BAR(obj->Widget()));
	    items.add(obj);
	    obj->Setup();
	    gtk_widget_show(obj->Widget());
	}
    else
	// call ancestor
	VDKForm::Add(obj,justify,expand,fill,padding);
    // set this as parent in any case
    obj->Parent(this);
}
#endif
