/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 1.0.4
 * December 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef GNOME_APPBAR_H
#define GNOME_APPBAR_H

#if HAVE_GNOME
#include <vdk/vdkobj.h>
#include <gnome.h>
class VDKForm;
/*!
  \class VDKGnomeAppBar
  \brief provides an application status bar
  
  This class wraps gnome_application_bar widget. It works like
  VDKStatusbar but having an optional inner progress bar.
  Furthermore status bar can be interactive  (planned in gnome future).
 */
class VDKGnomeAppBar: public VDKObject
{
    VDKObject* progress;
 public:
    /*!
      Set status bar
     */
    VDKReadWriteValueProp<VDKGnomeAppBar, char*> Status;
    /*!
      Set status bar default
     */
    VDKReadWriteValueProp<VDKGnomeAppBar, char*> Default;
    /*!
      Set progress bar value
     */
    VDKReadWriteValueProp<VDKGnomeAppBar, float> Progress;
    /*!
      Constructor
      \param woner
      \param has_progress
      \param has_status should be always true
      \param interact (unused, reserved for future use)
     */
    VDKGnomeAppBar(VDKForm* owner,
	       bool has_progress = true,
	       bool has_status = true,
	       GnomePreferencesType interact = GNOME_PREFERENCES_USER);
    /*!
      Destructor
     */
    virtual ~VDKGnomeAppBar();

    /*!
      Pushes a <msg> on status bar
      \param status status message
     */
    void Push(char* status)
      {
	gnome_appbar_push(GNOME_APPBAR(widget),status);
      }
    /*!
      Pops status bar
     */
    void Pop()
     {
	 gnome_appbar_pop(GNOME_APPBAR(widget));
     }
    /*!
      Clear status bar
     */
    void Clear()
      {
	 gnome_appbar_clear_stack(GNOME_APPBAR(widget));
      }
    /*!
      Refreshes statsu bar
     */
    void Refresh()
     {
	 gnome_appbar_refresh(GNOME_APPBAR(widget)); 	
     }
    void SetStatus(char* status)
      {
	gnome_appbar_set_status(GNOME_APPBAR(widget),status);
      }
    void SetDefault(char* default_status)
      {
	gnome_appbar_set_default(GNOME_APPBAR(widget),default_status);
      }
    void SetProgress(float value)
      {
	if(progress)
	  gtk_progress_set_percentage(
		      GTK_PROGRESS(progress->Widget()),value);
      }
    float GetProgress()
      {
	if(progress)
	  return gtk_progress_get_current_percentage(
				     GTK_PROGRESS(progress->Widget()));
	else
	  return 0.0;
      }
    
};
#endif

#endif
